/*###############################################################################
# Linux Management Providers (LMP), Power Supply provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "cmpiOpenDRIM_ComputerSystemPowerSupply.h"

CMPIObjectPath* PowerSupply_OpenDRIM_ComputerSystemPowerSupply_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_ComputerSystemPowerSupply& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_ComputerSystemPowerSupply_classnames[0], OpenDRIM_ComputerSystemPowerSupply_NAMESPACE);

	if (!instance.GroupComponent_isNULL)
		op.addKey("GroupComponent", instance.GroupComponent);

	if (!instance.PartComponent_isNULL)
		op.addKey("PartComponent", instance.PartComponent);

	_L_;
	return op.getHdl();
}

CMPIInstance* PowerSupply_OpenDRIM_ComputerSystemPowerSupply_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_ComputerSystemPowerSupply& instance) {
	_E_;
	Objectpath op(broker, PowerSupply_OpenDRIM_ComputerSystemPowerSupply_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	_L_;
	return ci.getHdl();
}

void PowerSupply_OpenDRIM_ComputerSystemPowerSupply_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_ComputerSystemPowerSupply& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("PartComponent", instance.PartComponent) == OK)
		instance.PartComponent_isNULL = false;

	if (op.getKey("GroupComponent", instance.GroupComponent) == OK)
		instance.GroupComponent_isNULL = false;

	_L_;
}

void PowerSupply_OpenDRIM_ComputerSystemPowerSupply_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_ComputerSystemPowerSupply& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("GroupComponent", instance.GroupComponent) == OK)
		instance.GroupComponent_isNULL = false;

	if (inst.getProperty("PartComponent", instance.PartComponent) == OK)
		instance.PartComponent_isNULL = false;

	_L_;
}

