#!/bin/sh
set -o errexit

###
# Copyright (c) 2015-2021, Antoine Le Gonidec <vv221@dotslashplay.it>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# This software is provided by the copyright holders and contributors "as is"
# and any express or implied warranties, including, but not limited to, the
# implied warranties of merchantability and fitness for a particular purpose
# are disclaimed. In no event shall the copyright holder or contributors be
# liable for any direct, indirect, incidental, special, exemplary, or
# consequential damages (including, but not limited to, procurement of
# substitute goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether in
# contract, strict liability, or tort (including negligence or otherwise)
# arising in any way out of the use of this software, even if advised of the
# possibility of such damage.
###

###
# Deep Sky Derelicts
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20211215.1

# Set game-specific variables

GAME_ID='deep-sky-derelicts'
GAME_NAME='Deep Sky Derelicts'

ARCHIVE_BASE_0='deep_sky_derelicts_1_5_3_37791.sh'
ARCHIVE_BASE_0_MD5='a55656f3033c2d339d0cbaeba7503270'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='1200000'
ARCHIVE_BASE_0_VERSION='1.5.3-gog37791'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/deep_sky_derelicts'

UNITY3D_NAME='Deep Sky Derelicts'

CONTENT_PATH_DEFAULT='data/noarch/game'

ARCHIVE_DOC_DATA_PATH="$CONTENT_PATH_DEFAULT"
ARCHIVE_DOC_DATA_FILES='
LICENSE
README.txt'

ARCHIVE_GAME_BIN_PATH="$CONTENT_PATH_DEFAULT"
ARCHIVE_GAME_BIN_FILES='
Deep?Sky?Derelicts.x86_64
Deep?Sky?Derelicts_Data/MonoBleedingEdge
Deep?Sky?Derelicts_Data/Plugins'

ARCHIVE_GAME_DATA_PATH="$CONTENT_PATH_DEFAULT"
ARCHIVE_GAME_DATA_FILES='
Deep?Sky?Derelicts_Data'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6 libz.so.1 libgtk-x11-2.0.so.0 libgdk_pixbuf-2.0.so.0 libgobject-2.0.so.0 libglib-2.0.so.0"

# Load common functions

target_version='2.14'

if [ -z "$PLAYIT_LIB2" ]; then
	for path in \
		"$PWD" \
		"${XDG_DATA_HOME:="$HOME/.local/share"}/play.it" \
		'/usr/local/share/games/play.it' \
		'/usr/local/share/play.it' \
		'/usr/share/games/play.it' \
		'/usr/share/play.it'
	do
		if [ -e "${path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=play.it-2/lib/libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
