#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Spore
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250807.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='spore'
GAME_NAME='Spore'

ARCHIVE_BASE_1_NAME='setup_sporetm_collection_3.1.0.29_(77221).exe'
ARCHIVE_BASE_1_MD5='a84931fcbdda5dda58dcc5cd9d5b906f'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_PART1_NAME='setup_sporetm_collection_3.1.0.29_(77221)-1.bin'
ARCHIVE_BASE_1_PART1_MD5='da8282841877bdfeb9ba3dbbaff03e1e'
ARCHIVE_BASE_1_PART2_NAME='setup_sporetm_collection_3.1.0.29_(77221)-2.bin'
ARCHIVE_BASE_1_PART2_MD5='e5290fb4975109b9229d3494c4c5ccd9'
ARCHIVE_BASE_1_SIZE='6223301'
ARCHIVE_BASE_1_VERSION='3.1.0.29-gog77221'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/spore_collection'

ARCHIVE_BASE_0_NAME='setup_spore_3.1.0.22_(10834).exe'
ARCHIVE_BASE_0_MD5='195652ca3eb62fe725f7b334cb27874e'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_spore_3.1.0.22_(10834)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='384354f468d981965d45f437e54a13ab'
ARCHIVE_BASE_0_PART2_NAME='setup_spore_3.1.0.22_(10834)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='885466a612c4243ef10758c7c6cfcfbb'
ARCHIVE_BASE_0_SIZE='6300000'
ARCHIVE_BASE_0_VERSION='3.1.0.22-gog10834'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='app'
CONTENT_GAME_BIN_FILES='
sporebin'
CONTENT_GAME_EP1_BIN_FILES='
sporebinep1'
CONTENT_GAME_DATA_FILES='
data'
CONTENT_GAME0_DATA_RELATIVE_PATH='__support/add'
CONTENT_GAME0_DATA_FILES='
login.prop'
CONTENT_GAME_EP1_DATA_FILES='
dataep1'
CONTENT_GAME_BP1_FILES='
bp1content'
CONTENT_DOC_DATA_FILES='
support'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/Spore
users/${USER}/Documents/My Spore Creations'
## Set required registry keys.
# shellcheck disable=SC1003
WINE_REGISTRY_INIT='
[HKEY_LOCAL_MACHINE\Software\electronic arts\spore]
"appdir"="Spore"
"installcompleted"=dword:00000001
"locale"="en-us"
"playerdir"="My Spore Creations"
"reindexyesorno"=dword:00000000
"installloc"="C:\\'"${GAME_ID}"'"
"datadir"="C:\\'"${GAME_ID}"'\\data"

[HKEY_LOCAL_MACHINE\Software\electronic arts\spore_EP1]
"AddOnID"=dword:00000002
"PackID"=dword:07a7f786
"DataDir"="C:\\'"${GAME_ID}"'\\dataep1\\"'

APP_MAIN_EXE='sporebin/sporeapp.exe'

APP_EP1_ID="${GAME_ID}-galactic-adventures"
APP_EP1_NAME="$GAME_NAME - Galactic Adventures"
APP_EP1_EXE='sporebinep1/sporeapp.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA
PKG_EP1_BIN
PKG_EP1_DATA
PKG_BP1'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_EP1_BIN_ID="${GAME_ID}-galactic-adventures"
PKG_EP1_BIN_DESCRIPTION='Galactic Adventures'
PKG_EP1_BIN_ARCH='32'
PKG_EP1_BIN_DEPENDENCIES_SIBLINGS='
PKG_BIN
PKG_EP1_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_EP1_DATA_ID="${PKG_EP1_BIN_ID}-data"
PKG_EP1_DATA_DESCRIPTION="$PKG_EP1_BIN_DESCRIPTION - data"

PKG_BP1_ID="${GAME_ID}-creepy-and-cute-parts-pack"
PKG_BP1_DESCRIPTION='Creepy & Cute Parts Pack'
PKG_BP1_DEPENDENCIES_SIBLINGS='
PKG_BIN'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA' 'APP_MAIN'
content_inclusion_icons 'PKG_EP1_DATA' 'APP_EP1'
content_inclusion_default

# Write launchers

## Include the login workaround.
wineprefix_init_custom() {
	cat <<- EOF
	    ## Include the login workaround.
	    install -D --mode=644 \\
	        "$(path_game_data)/login.prop" \\
	        "\${WINEPREFIX}/drive_c/users/\${USER}/AppData/Roaming/Spore/Preferences/login.prop"
	EOF
}

launchers_generation 'PKG_BIN' 'APP_MAIN'

## Prevent a file path conflict if the registry script
## is created both for the base game and the expansion.
wine_registry_script_write() { return 0; }

launchers_generation 'PKG_EP1_BIN' 'APP_EP1'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
