/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.agent;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.jiapi.agent.Transformer;
import net.sf.jiapi.reflect.JiapiClass;

public class InstrumentationAgent
implements ClassFileTransformer {
    private Instrumentation instrumentation;
    private Transformer transformer;
    private Properties agentArgs;

    public static void agentmain(String agentArgs, Instrumentation inst) {
        InstrumentationAgent.premain(agentArgs, inst);
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        Properties p = new Properties();
        if (agentArgs != null) {
            StringTokenizer st = new StringTokenizer(agentArgs, ",");
            while (st.hasMoreTokens()) {
                String nv = st.nextToken();
                StringTokenizer st2 = new StringTokenizer(nv, "=");
                String n = st2.nextToken();
                String v = null;
                v = st2.hasMoreTokens() ? st2.nextToken() : "";
                p.setProperty(n, v);
            }
        }
        try {
            String tr = p.getProperty("transformer", "net.sf.jiapi.agent.HotSpotTransformer");
            if (tr != null) {
                Class<?> c = Class.forName(tr);
                Object o = c.newInstance();
                Transformer tf = (Transformer)o;
                tf.init(p);
                InstrumentationAgent jcft = new InstrumentationAgent(p, instrumentation, tf);
                instrumentation.addTransformer(jcft);
            } else {
                System.out.println("Failed to create Transformer: Missing agent parameter 'transformer'");
            }
        }
        catch (Exception e) {
            System.out.println("Failed to create Transformer: " + e);
            e.printStackTrace();
        }
    }

    public InstrumentationAgent(Properties p, Instrumentation i, Transformer transformer) {
        this.agentArgs = p;
        this.instrumentation = i;
        this.transformer = transformer;
    }

    @Override
    public byte[] transform(ClassLoader cl, String className, Class<?> classBeingRedefined, ProtectionDomain pd, byte[] classFileBuffer) {
        if (this.transformer == null) {
            return null;
        }
        byte[] tempBuffer = new byte[classFileBuffer.length];
        System.arraycopy(classFileBuffer, 0, tempBuffer, 0, classFileBuffer.length);
        try {
            JiapiClass jc = JiapiClass.newInstance(tempBuffer);
            if (this.transformer.transform(jc)) {
                return jc.getByteCode();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public Properties getAgentArgs() {
        return this.agentArgs;
    }
}

