//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_21.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot21(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[21] = {2.902954393638768e-02,2.615043070821524e-01,7.277333883436495e-01,1.430315045933035e+00,2.373247472831900e+00,
    3.562058392635709e+00,5.003993562818670e+00,6.708280631012666e+00,8.686493482580042e+00,1.095305565041351e+01,1.352594301137335e+01,1.642768238791604e+01,
    1.968680665832298e+01,2.334004538823930e+01,2.743576281852024e+01,3.203964794798858e+01,3.724480661526604e+01,4.319140970101193e+01,5.011037036408683e+01,
    5.844271163828623e+01,6.931910199140093e+01};
  constexpr double aw[21] = {3.310489138908577e-01,2.627389067822954e-01,1.652880012746675e-01,8.221126930329362e-02,3.220210128890780e-02,
    9.879524053188518e-03,2.357161394596322e-03,4.334122717212564e-04,6.071962107788308e-05,6.390245967735531e-06,4.963659393579919e-07,2.783471526549022e-08,
    1.095805228807822e-09,2.921728837233345e-11,5.032705582183915e-13,5.253337715568679e-15,3.035890347810675e-17,8.482152080085886e-20,9.177890695692633e-23,
    2.527869864053624e-26,6.167858925810823e-31};
  constexpr double x[8064] = {  2.667941270798570e-03, -3.098219073957002e-05,  2.694799056576616e-07, -2.079871601760156e-09,  1.501578669284640e-11,
 -1.037945120064053e-13,  6.953212153464726e-16, -4.546217195906155e-18,  2.913625284617119e-20, -1.835391519729702e-22,  1.138316701534654e-24, -6.957583824482578e-27,
  2.392992177880591e-02, -2.750016962388864e-04,  2.341901351232219e-06, -1.743907424204795e-08,  1.191424142827327e-10, -7.598085261193838e-13,  4.539743871904534e-15,
 -2.525604784832467e-17,  1.283169955597460e-19, -5.673099515867205e-22,  1.872540978008852e-24, -7.653118504744724e-28,  6.602042022698942e-02, -7.429032178495746e-04,
  6.058691423310037e-06, -4.181073250005229e-08,  2.518429880029106e-10, -1.302380045695173e-12,  5.306275012212666e-15, -1.082236343852224e-17, -7.875568496516243e-20,
  1.285911234216763e-21, -1.123722599471200e-23,  7.437272607609749e-26,  1.280795656936374e-01, -1.395981842597454e-03,  1.064158530812862e-05, -6.464144642183298e-08,
  3.037847596496755e-10, -8.375000700526824e-13, -2.518054663101185e-15,  5.751159445542636e-17, -4.925327180957576e-19,  2.748204635691979e-21, -7.763888620126307e-24,
 -3.984154833925070e-26,  2.088352005288743e-01, -2.179999765746267e-03,  1.510453377559957e-05, -7.477849621531851e-08,  1.943166029599076e-10,  8.445756582028421e-13,
 -1.505818168688976e-14,  1.056136520103256e-16, -3.500728423805922e-19, -1.414695283722178e-21,  3.041693056777694e-23, -2.341787134873364e-25,  3.066240876849581e-01,
 -3.029478377489524e-03,  1.843622696574363e-05, -6.439796705615923e-08, -7.745579350717830e-11,  2.920575809325121e-12, -2.036413323844151e-14,  4.085528384340425e-17,
  5.971783918234366e-19, -7.120003162685032e-21,  3.228627953488621e-23,  8.145755324326595e-26,  4.194202108801213e-01, -3.872948527022431e-03,  1.979078598541997e-05,
 -3.197818346727603e-08, -4.204492872873992e-10,  3.963834735208804e-12, -9.170350049532621e-15, -1.176130778152102e-16,  1.288838751396253e-18, -3.428763371137064e-21,
 -4.243710268985740e-23,  5.036184613838425e-25,  5.448701391354021e-01, -4.638780989610940e-03,  1.865237023396402e-05,  1.669180368791910e-08, -6.872205447164341e-10,
  2.914134311574534e-12,  1.452450410214690e-14, -2.196495778115661e-16,  5.150919395927493e-19,  8.615274151694699e-21, -7.876911139638130e-23, -1.643881227231662e-26,
  6.803353592619460e-01, -5.261159987484809e-03,  1.494288094816898e-05,  6.988408532523815e-08, -7.424951988450999e-10, -7.370907549549380e-14,  3.390688560254870e-14,
 -1.306471256643888e-16, -1.232897963248031e-18,  1.218191579566232e-20,  1.838467916733607e-23, -7.832477937905276e-25,  8.229413723173943e-01, -5.685728794974353e-03,
  9.050935067180322e-06,  1.133431743632929e-07, -5.319124554711609e-10, -3.539989281096831e-12,  3.227865581858484e-14,  1.042262755128258e-16, -1.949959086658567e-18,
 -1.196474531737328e-21,  1.146968074937804e-22, -2.060352192639914e-25,  9.696331972255496e-01, -5.874433884165971e-03,  1.773720213662672e-06,  1.347082701615339e-07,
 -1.159707782450466e-10, -5.536758850175351e-12,  7.948842541194273e-15,  2.756500760616768e-16, -5.601054362867270e-19, -1.513950022350043e-20,  4.012667032075880e-23,
  8.819708961108916e-25,  1.117236723729106e+00, -5.809127861613777e-03, -5.820784469853579e-06,  1.275273648756913e-07,  3.504218963524276e-10, -4.858840877460896e-12,
 -2.260109192674406e-14,  2.155419675889799e-16,  1.500992373537081e-18, -1.000628261203363e-20, -1.009744055204981e-22,  4.548534649098324e-25,  1.262525108883144e+00,
 -5.493564933624843e-03, -1.258812456525685e-05,  9.350254305806883e-08,  6.858023190452378e-10, -1.859780245302622e-12, -3.732658274760482e-14, -2.248902076840426e-17,
  1.910383313607781e-18,  7.401928282660591e-21, -8.565967160033647e-23, -7.212570037270014e-25,  1.402289123439344e+00, -4.953536104865169e-03, -1.752279135808397e-05,
  4.213074903089267e-08,  7.656136211754169e-10,  1.738801762741701e-12, -2.666705087700096e-14, -2.136756556247837e-16,  3.407992768941097e-19,  1.334944507963619e-20,
  4.843860292424401e-23, -5.270184025075093e-25,  1.533410040971969e+00, -4.235040752858468e-03, -1.995304725322848e-05, -1.224598005685146e-08,  5.796748139084484e-10,
  3.951377721505786e-12, -1.048143299361586e-15, -1.956908231213649e-16, -1.226407655645145e-18,  2.206015399640456e-21,  8.217816013520375e-23,  4.368099581593494e-25,
  1.652933345903754e+00, -3.400567336142438e-03, -1.967518463798942e-05, -5.506412968268977e-08,  2.336695264223921e-10,  3.796084372005301e-12,  1.894191897114061e-14,
 -2.636197798940976e-17, -1.133740049507556e-18, -7.886968803045427e-21, -5.345771839235989e-24,  3.831753822484508e-25,  1.758141247926785e+00, -2.523743864435716e-03,
 -1.699744714920357e-05, -7.628428445257606e-08, -1.069985555086156e-10,  1.839423717565210e-12,  2.049635979836539e-14,  1.050536405138078e-16,  2.311911427906781e-20,
 -4.860928095111893e-21, -4.755270743136602e-23, -2.090258992068410e-25,  1.846621772410298e+00, -1.682798466749568e-03, -1.268114860578265e-05, -7.359406503761251e-08,
 -3.019704092023690e-10, -3.506816859741683e-13,  8.008324631347520e-15,  9.452923999065997e-17,  6.205397439585107e-19,  2.185216416868441e-21, -5.979811951363163e-24,
 -1.691430993093342e-25,  1.916332129247227e+00, -9.534186263036783e-04, -7.787742644684304e-06, -5.289614921627136e-08, -3.042304012717499e-10, -1.405614368458295e-12,
 -4.012767983522769e-15,  1.003321762464238e-17,  2.692542979157088e-19,  2.571478246180156e-21,  1.735983589729805e-23,  8.393030393610831e-26,  1.965654533245411e+00,
 -4.016876204552952e-04, -3.461178301647782e-06, -2.586273002611983e-08, -1.752581391209745e-10, -1.089995776825238e-12, -6.184448368817826e-15, -3.114260599752709e-17,
 -1.284538905460633e-19, -3.040814365059807e-22,  1.439140839622730e-24,  2.890184104246077e-26,  1.993449525489729e+00, -7.772043024190366e-05, -6.893472465187001e-07,
 -5.410964570442201e-09, -3.959693654034513e-11, -2.762850910923550e-13, -1.858920456202752e-15, -1.213312720092755e-17, -7.705607601950765e-20, -4.766742799090211e-22,
 -2.870661226198250e-24, -1.679310551190062e-26,  2.548171681314298e-03, -2.892225312154618e-05,  2.458972807600849e-07, -1.855360897446838e-09,  1.309698241274520e-11,
 -8.853478038636030e-14,  5.801462123723629e-16, -3.711353012706285e-18,  2.327972301177128e-20, -1.435802379268379e-22,  8.722311787178090e-25, -5.224571331359362e-27,
  2.286610432089054e-02, -2.570722718648335e-04,  2.143587196967591e-06, -1.564867747809805e-08,  1.049808213563526e-10, -6.588950676817051e-13,  3.887092717324700e-15,
 -2.146233066963613e-17,  1.092270422933763e-19, -4.938183420555086e-22,  1.786555937669970e-24, -2.902572715872066e-27,  6.314266295641412e-02, -6.963740355237710e-04,
  5.580302110324459e-06, -3.798281375056573e-08,  2.270430468976136e-10, -1.178910714367341e-12,  4.974342684949951e-15, -1.268252161316913e-17, -3.981202785449942e-20,
  8.967517598521041e-22, -8.341974725617497e-24,  5.772987883550749e-26,  1.226611058895386e-01, -1.313870611847022e-03,  9.894489323052308e-06, -5.991765720465499e-08,
  2.865520368560628e-10, -8.803012844357789e-13, -1.113955503816364e-15,  4.327076663662123e-17, -3.995168931313812e-19,  2.412579069266464e-21, -8.797107136614291e-24,
 -9.519536468855297e-27,  2.003512669959648e-01, -2.062698848164342e-03,  1.422634272031675e-05, -7.155295218804052e-08,  2.078269714344866e-10,  5.173604727516890e-13,
 -1.226392737786047e-14,  9.381185584231994e-17, -3.814726705736651e-19, -3.916986784481007e-22,  2.104749185188005e-23, -1.911182018660044e-25,  2.947962354559690e-01,
 -2.885096463329308e-03,  1.765785831663822e-05, -6.519609760468260e-08, -2.382882156745834e-11,  2.447495593094459e-12, -1.898937471936140e-14,  5.611820756401417e-17,
  3.646790678816501e-19, -5.788025938986021e-21,  3.361651749520815e-23, -1.420925159489481e-26,  4.042424853926084e-01, -3.716265612037779e-03,  1.936925918668679e-05,
 -3.808415403981890e-08, -3.436166604989556e-10,  3.708764062072861e-12, -1.190676422090519e-14, -7.863083055624586e-17,  1.139980053328087e-18, -4.706474671903688e-21,
 -2.208457693603143e-23,  4.167105969982318e-25,  5.266144637675416e-01, -4.488943202847936e-03,  1.878867776079910e-05,  6.179422318341153e-09, -6.259393796961880e-10,
  3.191047596147066e-12,  8.647377677402904e-15, -1.988100435458253e-16,  7.689116698351816e-19,  5.510307741437311e-21, -7.511739490385065e-23,  1.704346961341807e-25,
  6.595348316857518e-01, -5.138464293759105e-03,  1.571030142760444e-05,  5.803526452876254e-08, -7.361493431214736e-10,  6.921092494694526e-13,  2.976298835840879e-14,
 -1.630063748872990e-16, -7.890789315413874e-19,  1.226635384567197e-20, -1.307812662697756e-23, -6.350387519591781e-25,  8.003516751811721e-01, -5.608030625164200e-03,
  1.035779192119309e-05,  1.043091333325517e-07, -5.947654746332520e-10, -2.737341243240075e-12,  3.432311904845576e-14,  4.200094375815133e-17, -1.913419173880835e-18,
  3.125197660046394e-21,  9.944335179387035e-23, -4.723218380996030e-25,  9.461740235129065e-01, -5.853818005213166e-03,  3.375472644623969e-06,  1.319798030086306e-07,
 -2.241856167052890e-10, -5.255884241666902e-12,  1.533681687785123e-14,  2.493891802080355e-16, -1.067328174259208e-18, -1.280881359577660e-20,  7.494464445617303e-23,
  6.817702987293827e-25,  1.093916896407431e+00, -5.849485075449007e-03, -4.260112059381061e-06,  1.323293739332325e-07,  2.483362059487359e-10, -5.323777039617202e-12,
 -1.595292954912364e-14,  2.570753212695465e-16,  1.073733234092813e-18, -1.355310327005590e-20, -7.422127383509982e-23,  7.484621494889504e-25,  1.240356804570931e+00,
 -5.589598413494051e-03, -1.140164242779157e-05,  1.041290545553044e-07,  6.396339843364055e-10, -2.756045508738725e-12, -3.706542527161316e-14,  4.218615236260115e-17,
  2.107961035984601e-18,  3.390099508122660e-21, -1.134755916177696e-22, -5.215452265576639e-25,  1.382198113478496e+00, -5.091485505804951e-03, -1.694269398664118e-05,
  5.462199520483446e-08,  7.935132458624738e-10,  1.028686066836799e-12, -3.242266375617899e-14, -1.947569122179191e-16,  8.499530683017259e-19,  1.474519848461118e-20,
  1.946926939976246e-23, -7.842166171941976e-25,  1.516149929000845e+00, -4.395089278732583e-03, -2.004175202969759e-05, -2.342270969929962e-09,  6.579844649596370e-10,
  3.856132437769545e-12, -7.060245703001188e-15, -2.329949626274855e-16, -1.083468283664174e-18,  5.845638872493145e-21,  9.882995794040826e-23,  3.029521002232569e-25,
  1.639012186267831e+00, -3.560542404392990e-03, -2.031093736392325e-05, -5.069367158818838e-08,  3.140551822424029e-10,  4.237470243587924e-12,  1.765309545850203e-14,
 -6.718980463359263e-17, -1.416992903242607e-18, -7.712478403103965e-21,  1.535689486035516e-23,  5.594171720427990e-25,  1.747768478532586e+00, -2.663411216357194e-03,
 -1.792182709619583e-05, -7.767422688111599e-08, -6.505299645694558e-11,  2.366542719551027e-12,  2.341919275629949e-14,  1.026089861729846e-16, -1.882451164730116e-19,
 -6.937143139259870e-21, -5.592978963163053e-23, -1.636403986966677e-25,  1.839681970448372e+00, -1.787862767223605e-03, -1.359346161019766e-05, -7.847031659941101e-08,
 -3.068357548351371e-10, -1.244055451774377e-13,  1.094455146987483e-14,  1.155831173643400e-16,  6.929001963414504e-19,  1.774010923741589e-21, -1.519092648445963e-23,
 -2.529594434234864e-25,  1.912389711068874e+00, -1.018344503273381e-03, -8.452646903577005e-06, -5.799385240825775e-08, -3.332775847816080e-10, -1.497485504864177e-12,
 -3.596297123876475e-15,  2.027190372564778e-17,  3.752367642992765e-19,  3.341860040724242e-21,  2.120048949312756e-23,  8.950704026939235e-26,  1.963990368791968e+00,
 -4.306678388181011e-04, -3.789102194111677e-06, -2.884962905644582e-08, -1.986153955070155e-10, -1.249360594045042e-12, -7.115539498861193e-15, -3.541442675161238e-17,
 -1.380185527109947e-19, -2.166445403570937e-22,  3.053844868181608e-24,  4.557179333514629e-26,  1.993127187200048e+00, -8.350614117683667e-05, -7.582706556459287e-07,
 -6.091265933404368e-09, -4.559780751891895e-11, -3.252712333001090e-13, -2.235915685932752e-15, -1.489717729805651e-17, -9.647427084096652e-20, -6.077232780770279e-22,
 -3.720139506376690e-24, -2.206548173631978e-26,  2.436280875694136e-03, -2.704069964666206e-05,  2.248341848620908e-07, -1.659252109525568e-09,  1.145752017385556e-11,
 -7.577865240454136e-14,  4.859261135614143e-16, -3.042795324990057e-18,  1.868717682733000e-20, -1.128838665268705e-22,  6.718925389571542e-25, -3.945029366156681e-27,
  2.187096236158377e-02, -2.406471255999376e-04,  1.965462232793845e-06, -1.406953619941291e-08,  9.268911899312188e-11, -5.724371604696297e-13,  3.332505401028101e-15,
 -1.823798485699407e-17,  9.270176957999397e-20, -4.252652135492663e-22,  1.633979657899071e-24, -3.887542568452920e-27,  6.044364982857639e-02, -6.534947884027860e-04,
  5.145547073029104e-06, -3.453238713890437e-08,  2.046292854673778e-10, -1.063904132144491e-12,  4.605817877197421e-15, -1.349966621642689e-17, -1.296188840402108e-20,
  6.096481960139792e-22, -6.112484837943959e-24,  4.409449606459174e-26,  1.175594897917141e-01, -1.237514148206699e-03,  9.202401793125141e-06, -5.547473846791017e-08,
  2.687696654360718e-10, -8.938640812478051e-13, -6.878778987884732e-17,  3.180751626986779e-17, -3.190423755470369e-19,  2.058373993961964e-21, -8.782196621371115e-24,
  8.521432848370375e-27,  1.923227357792188e-01, -1.952265432349962e-03,  1.338795071863807e-05, -6.816006697192901e-08,  2.154364392425795e-10,  2.531599809362243e-13,
 -9.809148045125867e-15,  8.152592534109551e-17, -3.823284763137880e-19,  2.949224868328949e-22,  1.359873464778990e-23, -1.479169739378587e-25,  2.835334159874981e-01,
 -2.746965928864938e-03,  1.687475422614464e-05, -6.520996600460222e-08,  2.069694819091675e-11,  2.011741689379702e-12, -1.728417637530600e-14,  6.471111089617155e-17,
  1.801806196756378e-19, -4.475444887083887e-21,  3.158982278188705e-23, -7.238476055093020e-26,  3.896843120480525e-01, -3.563227508644915e-03,  1.888165775761134e-05,
 -4.300482123936297e-08, -2.724567172282913e-10,  3.400542133016335e-12, -1.362420443561556e-14, -4.499881522105796e-17,  9.587920792730828e-19, -5.253238005762934e-21,
 -6.011847034456417e-24,  3.129067958214769e-25,  5.089595455516348e-01, -4.338502509534461e-03,  1.880487821979412e-05, -3.315604463198733e-09, -5.604788852797494e-10,
  3.334727840948420e-12,  3.450953185770412e-15, -1.715937530423717e-16,  9.153672314682086e-19,  2.694290864158363e-21, -6.485592792240023e-23,  2.841742993324702e-25,
  6.392364690273102e-01, -5.010195125998924e-03,  1.633663242359243e-05,  4.640482548025026e-08, -7.155467715516825e-10,  1.349200644381148e-12,  2.491066782680409e-14,
 -1.813437894344680e-16, -3.631340591276467e-19,  1.124048872568333e-20, -3.677029656490320e-23, -4.373345033813721e-25,  7.780929713379351e-01, -5.520327096092026e-03,
  1.155074316755847e-05,  9.439994544871337e-08, -6.412147130990812e-10, -1.906262661623326e-12,  3.466406771321761e-14, -1.670481479794649e-17, -1.734846350275642e-18,
  6.631197637149710e-21,  7.466911144402499e-23, -6.352315326711407e-25,  9.228226930770170e-01, -5.820548019523234e-03,  4.934310669120324e-06,  1.275741903782551e-07,
 -3.250785253327605e-10, -4.808269351277858e-12,  2.177667131214745e-14,  2.084893236029890e-16, -1.467981173213904e-18, -9.291757469886242e-21,  9.878779239018975e-23,
  3.915699512007082e-25,  1.070460935882236e+00, -5.877154829408095e-03, -2.651893532214655e-06,  1.354326575301935e-07,  1.386330924729657e-10, -5.616857066234843e-12,
 -8.350829334849137e-15,  2.831236850583383e-16,  5.409266162139597e-19, -1.579828023441782e-20, -3.665130690269673e-23,  9.381647593402841e-25,  1.217824138150128e+00,
 -5.675643878506532e-03, -1.009266303503838e-05,  1.138744375848968e-07,  5.757528050163247e-10, -3.623738353281677e-12, -3.492798054824615e-14,  1.106776851692078e-16,
  2.143541560971741e-18, -1.521805019756424e-21, -1.297999305008536e-22, -2.037607973238556e-25,  1.361565546036753e+00, -5.224188086365816e-03, -1.621051571222619e-05,
  6.743872528501057e-08,  8.058817984886968e-10,  1.886713577833198e-13, -3.741461609390679e-14, -1.589862997666743e-16,  1.385891121202954e-18,  1.477011473274197e-20,
 -1.964425040387252e-23, -9.783347459627423e-25,  1.498248986145466e+00, -4.555350961984409e-03, -2.000418377213022e-05,  8.790969263648647e-09,  7.328649006959723e-10,
  3.604704719106636e-12, -1.403228890063299e-14, -2.635134554361360e-16, -7.992176617819508e-19,  1.000208962614430e-20,  1.072253949833112e-22,  6.038093495797161e-26,
  1.624441318206539e+00, -3.725371189580571e-03, -2.088624280517161e-05, -4.496850886175932e-08,  4.028613935669653e-10,  4.633193854479730e-12,  1.509636762102860e-14,
 -1.168061470278207e-16, -1.677180208533621e-18, -6.554226040269794e-21,  4.379886214365645e-23,  7.294421823107615e-25,  1.736822161210347e+00, -2.810528090090527e-03,
 -1.885849943273998e-05, -7.830492788024494e-08, -1.187337303665811e-11,  2.962152753877338e-12,  2.616721381806181e-14,  9.214494041554797e-17, -4.797603233594647e-19,
 -9.292509311423568e-21, -6.107779789504119e-23, -5.886746912368713e-26,  1.832306942299096e+00, -1.900460585352973e-03, -1.456459440310965e-05, -8.338417573020840e-08,
 -3.064218486427769e-10,  1.796593919526143e-13,  1.449992837358434e-14,  1.386369898163638e-16,  7.428815540103390e-19,  9.145943636108632e-22, -2.853566876754204e-23,
 -3.566427966532680e-25,  1.908176552155900e+00, -1.088842340504044e-03, -9.181570722503823e-06, -6.357036213447104e-08, -3.640369234371985e-10, -1.575511214109343e-12,
 -2.841280109942434e-15,  3.437575838281306e-17,  5.117555535899502e-19,  4.268288497388751e-21,  2.508886719956491e-23,  8.496832702492423e-26,  1.962204800379730e+00,
 -4.624214229748238e-04, -4.155220397786666e-06, -3.223699795058952e-08, -2.253932632562511e-10, -1.432538124041749e-12, -8.169955587719614e-15, -3.992792988564069e-17,
 -1.430772107064634e-19, -4.783484366358658e-23,  5.564927337306395e-24,  7.010156595781965e-26,  1.992780549182486e+00, -8.987760387592777e-05, -8.359677630905260e-07,
 -6.875938251804698e-09, -5.267553133954156e-11, -3.843088034642858e-13, -2.699762425478414e-15, -1.836513326948137e-17, -1.212820124198841e-19, -7.778645589981726e-22,
 -4.837855420245510e-24, -2.906727250929053e-26,  2.331593573748424e-03, -2.531866502935970e-05,  2.059750438017645e-07, -1.487450521507205e-09,  1.005200227425154e-11,
 -6.507480966213447e-14,  4.085238775260583e-16, -2.504960911860095e-18,  1.506805787228239e-20, -8.917964898261254e-23,  5.202279633606374e-25, -2.994945618050690e-27,
  2.093878645015709e-02, -2.255743967444130e-04,  1.805161761525950e-06, -1.267392242576664e-08,  8.200048732756601e-11, -4.982634876338916e-13,  2.861158636824276e-15,
 -1.550420958308984e-17,  7.852624345063239e-20, -3.634531841660687e-22,  1.454470654575644e-24, -4.187498466491238e-27,  5.790945146066515e-02, -6.139338859899845e-04,
  4.750119764366091e-06, -3.142266636226304e-08,  1.844258198430070e-10, -9.579285787624279e-13,  4.225004242786899e-15, -1.360688910246804e-17,  5.020862238732257e-21,
  4.005658879237285e-22, -4.420690908194628e-24,  3.323318267964161e-26,  1.127525569647037e-01, -1.166485973793306e-03,  8.561917357817322e-06, -5.131724886803673e-08,
  2.509423337186245e-10, -8.859152520518684e-13,  6.895535217429363e-16,  2.271692825081333e-17, -2.511424392905064e-19,  1.717919267971154e-21, -8.170714053200409e-24,
  1.815465126154671e-26,  1.847227842310479e-01, -1.848374605651203e-03,  1.259083952600894e-05, -6.468461806202369e-08,  2.183232534972800e-10,  4.376390071003548e-14,
 -7.695430907276673e-15,  6.955425635359787e-17, -3.633803737130488e-19,  7.205225180188463e-22,  7.963519453830076e-24, -1.091934266463287e-25,  2.728106041807204e-01,
 -2.615089429338521e-03,  1.609547798976233e-05, -6.457884877987758e-08,  5.693311114807944e-11,  1.619175603900665e-12, -1.541406611663991e-14,  6.813602122391158e-17,
  4.094397613775825e-20, -3.285915006340761e-21,  2.767609160428804e-23, -1.014358601299881e-25,  3.757301422147891e-01, -3.414307534712119e-03,  1.834162984179144e-05,
 -4.683817619897269e-08, -2.078005685590936e-10,  3.061732846581041e-12, -1.448324689393941e-14, -1.736465297046327e-17,  7.683860554749686e-19, -5.248888337365323e-21,
  5.488542943017718e-24,  2.113765169792863e-25,  4.919059530652088e-01, -4.188369992889226e-03,  1.871349617246684e-05, -1.174678317559400e-08, -4.933278508055510e-10,
  3.363277534648836e-12, -9.324279493454581e-16, -1.412251348803417e-16,  9.688539790623516e-19,  3.684862278840889e-22, -5.108983454507865e-23,  3.317157943824932e-25,
  6.194603295979674e-01, -4.877467010531502e-03,  1.682578877062433e-05,  3.520268741431861e-08, -6.830007254534657e-10,  1.885174956764761e-12,  1.972896739538764e-14,
 -1.868073926234741e-16,  1.096955199787033e-20,  9.446051817494486e-21, -5.144872427734293e-23, -2.315059156026909e-25,  7.562033995619409e-01, -5.423566968854762e-03,
  1.262087348848711e-05,  8.388044108186677e-08, -6.710898907662133e-10, -1.085971252359937e-12,  3.345879522899753e-14, -6.788007509537451e-17, -1.449319656244404e-18,
  9.036132597021944e-21,  4.521159426897929e-23, -6.857126015628885e-25,  8.996290113861121e-01, -5.775045509015216e-03,  6.430917127354891e-06,  1.216338932888225e-07,
 -4.155733009906468e-10, -4.221166131598187e-12,  2.691203450572836e-14,  1.569525568855222e-16, -1.728067153437267e-18, -5.090530449679805e-21,  1.089097820716286e-22,
  6.796903956711042e-26,  1.046920221056325e+00, -5.891840096773345e-03, -1.017127830072718e-06,  1.367439241123990e-07,  2.494172513761408e-11, -5.720725018994815e-12,
 -2.680722971876899e-16,  2.911330271899155e-16, -4.400518837906611e-20, -1.641376662835999e-20,  6.222205159301259e-24,  9.854178210347516e-25,  1.194968947946199e+00,
 -5.750768403217844e-03, -8.673433505327096e-06,  1.224623303411442e-07,  4.951860517817365e-10, -4.417157897657565e-12, -3.088414805115078e-14,  1.773814905285953e-16,
  1.994152887652560e-18, -6.781093600616468e-21, -1.303023344702792e-22,  1.881145912370725e-25,  1.340414860211734e+00, -5.350415990723403e-03, -1.532392377731081e-05,
  8.031281565168825e-08,  8.003430946948065e-10, -7.572036772112252e-13, -4.116699693172575e-14, -1.063681627751925e-16,  1.892787375898210e-18,  1.309137832060472e-20,
 -6.482707055762761e-23, -1.050958229059571e-24,  1.479708471949617e+00, -4.714757778764356e-03, -1.982602424756315e-05,  2.107270623491472e-08,  8.009801812035045e-10,
  3.176861625250285e-12, -2.170867919552762e-14, -2.824997967281180e-16, -3.621534144058085e-19,  1.424911533829187e-20,  1.025996920094162e-22, -2.859348919356017e-25,
  1.609202400094195e+00, -3.894502877770355e-03, -2.138407184958088e-05, -3.776295365052428e-08,  4.988512634067212e-10,  4.949990799746368e-12,  1.104173427033352e-14,
 -1.738476859716898e-16, -1.873478445887581e-18, -4.119122645673234e-21,  7.885595674669037e-23,  8.520857473013920e-25,  1.725272363345720e+00, -2.965153223273237e-03,
 -1.979723054722040e-05, -7.798599347763253e-08,  5.384845897189887e-11,  3.619065732360108e-12,  2.847867072104007e-14,  7.096628016483487e-17, -8.584666328242252e-19,
 -1.173961813181261e-20, -5.993903818848237e-23,  1.251651009619162e-25,  1.824465612106894e+00, -2.021062725080137e-03, -1.559443746319674e-05, -8.823790344011356e-08,
 -2.990202684708777e-10,  5.769477110219263e-13,  1.871776652012831e-14,  1.626829958622250e-16,  7.511710728215003e-19, -5.747010497663451e-22, -4.678946681035118e-23,
 -4.745434530098625e-25,  1.903669303339125e+00, -1.165447718791589e-03, -9.980413473300607e-06, -6.965037729531773e-08, -3.961408987546630e-10, -1.630152092548076e-12,
 -1.624970480762307e-15,  5.341119306793964e-17,  6.843351271789461e-19,  5.341488694163778e-21,  2.840266677241097e-23,  6.163019311083485e-26,  1.960286091638267e+00,
 -4.972741176251425e-04, -4.564683172544636e-06, -3.608353931059355e-08, -2.560980460977825e-10, -1.642550105515293e-12, -9.351951156984278e-15, -4.448440463602022e-17,
 -1.399638091363464e-19,  2.459997051905785e-22,  9.385692698032203e-24,  1.057149625693472e-25,  1.992407119683997e+00, -9.691032668428012e-05, -9.238014181857295e-07,
 -7.783939723174568e-09, -6.105368390217178e-11, -4.557396170494532e-13, -3.272811794304924e-15, -2.273420655756686e-17, -1.530994978951933e-19, -9.995059302166736e-22,
 -6.311864788946906e-24, -3.836754020361318e-26,  2.233505201871132e-03, -2.373962372659671e-05,  1.890493431130650e-07, -1.336520643118823e-09,  8.843140067007937e-12,
 -5.606024638215587e-14,  3.446800298224738e-16, -2.070378437638453e-18,  1.220246177393089e-20, -7.078227463202701e-23,  4.047998849724512e-25, -2.285594834545904e-27,
  2.006443875259148e-02, -2.117198806294230e-04,  1.660629579504697e-06, -1.143804847811702e-08,  7.268814972849592e-11, -4.345328412643352e-13,  2.460331482499009e-15,
 -1.318985081415181e-17,  6.644475357826957e-20, -3.089538605699155e-22,  1.271167386560394e-24, -4.098114631950959e-27,  5.552739865442482e-02, -5.773924729358824e-04,
  4.390137907472965e-06, -2.861974146358839e-08,  1.662505350093671e-10, -8.610700641549120e-13,  3.848201007847211e-15, -1.324692504753115e-17,  1.658629550232510e-20,
  2.503303780271926e-22, -3.152753952810182e-24,  2.475921464084171e-26,  1.082197982314156e-01, -1.100386946301135e-03,  7.969619597180480e-06, -4.744281815422843e-08,
  2.334365845777366e-10, -8.625862804506440e-13,  1.221972905624130e-15,  1.560847475595794e-17, -1.949731558520399e-19,  1.408603785034044e-21, -7.265117963259689e-24,
  2.229872714042291e-26,  1.775259070554885e-01, -1.750693362667192e-03,  1.183558127332182e-05, -6.119383978065633e-08,  2.175026952890447e-10, -1.188442502980965e-13,
 -5.906419788089292e-15,  5.839379379456339e-17, -3.327738368305966e-19,  9.529677474111529e-22,  3.893817652618659e-24, -7.692177787167591e-26,  2.626028910652729e-01,
 -2.489407570570115e-03,  1.532700270581680e-05, -6.342830085507557e-08,  8.577210829810995e-11,  1.272177888847127e-12, -1.350422651493924e-14,  6.775822328186470e-17,
 -5.853396079547824e-20, -2.271854942569556e-21,  2.296586833501248e-23, -1.099364394213867e-25,  3.623627446369791e-01, -3.269874719683541e-03,  1.776158210306852e-05,
 -4.969211173557542e-08, -1.500676483492721e-10,  2.710906217469999e-12, -1.465322786158841e-14,  4.259260611848183e-18,  5.853705246462576e-19, -4.870420370654582e-21,
  1.279480912134717e-23,  1.235759797794585e-25,  4.754508135612189e-01, -4.039354956413749e-03,  1.852738760353551e-05, -1.910440167834266e-08, -4.265882725351996e-10,
  3.296949861515010e-12, -4.453336532681996e-15, -1.103752392682641e-16,  9.488765936247391e-19, -1.381174447211199e-21, -3.642286115980298e-23,  3.279264923700440e-25,
  6.002220912858284e-01, -4.741353723771015e-03,  1.718397565156037e-05,  2.460025656200061e-08, -6.409844680649509e-10,  2.296242139360141e-12,  1.455146645640685e-14,
 -1.814291426618282e-16,  3.120451104829985e-19,  7.240554019928496e-21, -5.749635479924645e-23, -4.922135409791411e-26,  7.347171810537763e-01, -5.318757627016121e-03,
  1.356243675683516e-05,  7.301214115331255e-08, -6.849589255966916e-10, -3.106970112433425e-13,  3.095990964177410e-14, -1.087631254777725e-16, -1.098677163197669e-18,
  1.024912827139588e-20,  1.579656671182500e-23, -6.369695590900979e-25,  8.766408004563134e-01, -5.717878962275168e-03,  7.847960324597209e-06,  1.143458070791384e-07,
 -4.932146699770712e-10, -3.528929164533175e-12,  3.051098303100831e-14,  9.956335415255199e-17, -1.833030050307551e-18, -7.659247767899043e-22,  1.051369145944845e-22,
 -2.310881859257226e-25,  1.023346977289347e+00, -5.893415310956152e-03,  6.224244049055713e-07,  1.362300879100371e-07, -8.887994918519799e-11, -5.630039366482641e-12,
  7.775935921118351e-15,  2.804023854262635e-16, -6.201346149971021e-19, -1.531773945479580e-20,  4.781835634754719e-23,  8.813382223359307e-25,  1.171836587515048e+00,
 -5.814149955628958e-03, -7.159388539777899e-06,  1.296401041425863e-07,  3.998691797517094e-10, -5.091827410591434e-12, -2.506782790203291e-14,  2.363059002467496e-16,
  1.659300253122308e-18, -1.170824393316592e-20, -1.131437800696842e-22,  5.865986359173147e-25,  1.318774422611858e+00, -5.468936176693710e-03, -1.428401315486183e-05,
  9.294258671028586e-08,  7.751148468774503e-10, -1.773691638336669e-12, -4.323057538960462e-14, -3.884861603961805e-17,  2.306368095092500e-18,  9.588177892967929e-21,
 -1.096433999599000e-22, -9.559887873227461e-25,  1.460534139667050e+00, -4.872131984748383e-03, -1.949426003543991e-05,  3.436567226068268e-08,  8.586619653806680e-10,
  2.560125407986048e-12, -2.969833207050964e-14, -2.851208174118560e-16,  2.205753660263578e-19,  1.798221553230886e-20,  8.101592544534343e-23, -7.021804689832633e-25,
  1.593279575034933e+00, -4.067244777984150e-03, -2.178602875678525e-05, -2.897671492407756e-08,  6.000713012509627e-10,  5.149691685554275e-12,  5.317158626062430e-15,
 -2.354884089540774e-16, -1.955797635861376e-18, -1.994817403270684e-22,  1.172855982921054e-22,  8.730184563143730e-25,  1.713089096066507e+00, -3.127254003196425e-03,
 -2.072538243930725e-05, -7.650761684056885e-08,  1.332078468109447e-10,  4.322887579741889e-12,  3.001438316849036e-14,  3.628570430574852e-17, -1.322254444777587e-18,
 -1.395238141252012e-20, -4.867800147875163e-23,  4.026721387513686e-25,  1.816125030668287e+00, -2.150133934240158e-03, -1.668153405237259e-05, -9.290391090392341e-08,
 -2.826061788936806e-10,  1.083518747052937e-12,  2.360348247140144e-14,  1.859852622536007e-16,  6.914387201487967e-19, -2.899206342497151e-21, -7.029346040815446e-23,
 -5.918524896814959e-25,  1.898842377020743e+00, -1.248744483897169e-03, -1.085532878975383e-05, -7.625101962365022e-08, -4.289992251623736e-10, -1.648545030846440e-12,
  2.076235821497354e-16,  7.861043720132346e-17,  8.976150172710136e-19,  6.518438415167457e-21,  3.004459719235695e-23,  6.384079799300301e-27,  1.958221116152286e+00,
 -5.355958296058825e-04, -5.023395821172673e-06, -4.045654347425664e-08, -2.912969778323792e-10, -1.882438789106716e-12, -1.065831374925481e-14, -4.873919743967570e-17,
 -1.231064116901487e-19,  7.281727897741013e-22,  1.509343590394285e-23,  1.566665186324176e-25,  1.992004081580946e+00, -1.046916953064755e-04, -1.023385077326520e-06,
 -8.838211584169577e-09, -7.100852108253370e-11, -5.425144763664766e-13, -3.983734975658980e-15, -2.826133339086549e-17, -1.940634709150493e-19, -1.289126014138505e-21,
 -8.258896628667196e-24, -5.070612869279031e-26,  2.141473207869561e-03, -2.228905902464067e-05,  1.738244410005616e-07, -1.203569523961967e-09,  7.800181168260992e-12,
 -4.844169617245501e-14,  2.918142543916556e-16, -1.717731638539110e-18,  9.923067527958549e-21, -5.643381284929249e-23,  3.164959914754558e-25, -1.753135769794188e-27,
  1.924328707862413e-02, -1.989647393958952e-04,  1.530074327937144e-06, -1.034147643779849e-08,  6.455925723609481e-11, -3.796863461725694e-13,  2.119178794334646e-15,
 -1.123211105985001e-17,  5.619487413074537e-20, -2.616371159865389e-22,  1.096828122775142e-24, -3.803525743832511e-27,  5.328595802378088e-02, -5.436011739667416e-04,
  4.062108668064305e-06, -2.609261099277749e-08,  1.499230002365052e-10, -7.730967234993013e-13,  3.485910751976945e-15, -1.259430656939067e-17,  2.357190725374054e-20,
  1.439643855691095e-22, -2.212890355526956e-24,  1.825250174393651e-26,  1.039422466304932e-01, -1.038845050134453e-03,  7.422151922861515e-06, -4.384411666392317e-08,
  2.165100805132175e-10, -8.286746074839289e-13,  1.578896977421104e-15,  1.012655046470150e-17, -1.492537505555663e-19,  1.138032487691417e-21, -6.258146467015886e-24,
  2.304913739912120e-26,  1.707079353964695e-01, -1.658887084065982e-03,  1.112203353650855e-05, -5.773997903222353e-08,  2.138346257103789e-10, -2.421487012953970e-13,
 -4.415140400838473e-15,  4.831786761195798e-17, -2.964055897643455e-19,  1.049010657677344e-21,  1.093821851710676e-24, -5.144389654436461e-26,  2.528857076211201e-01,
 -2.369810954864703e-03,  1.457488156487630e-05, -6.186936782859791e-08,  1.081269351244631e-10,  9.705620904880006e-13, -1.164430542798734e-14,  6.474440510008278e-17,
 -1.249467980889230e-19, -1.449341247370410e-21,  1.819397233945727e-23, -1.053392122870103e-25,  3.495636021221231e-01, -3.130204105838468e-03,  1.715259776888032e-05,
 -5.167848033168024e-08, -9.934637313084346e-11,  2.362618320565250e-12, -1.429732202343575e-14,  2.029383821813322e-17,  4.203576046142892e-19, -4.271617307550535e-21,
  1.664291384277709e-23,  5.459888172045019e-26,  4.595882227462926e-01, -3.892163930209424e-03,  1.825933676129516e-05, -2.540909893566480e-08, -3.619509038578276e-10,
  3.156359535409419e-12, -7.128065150366435e-15, -8.106021915859312e-17,  8.763268136886304e-19, -2.558736477111115e-21, -2.273188165856320e-23,  2.902032895450042e-25,
  5.815332482292495e-01, -4.602871848933170e-03,  1.741921654252648e-05,  1.472917495066875e-08, -5.919719590611861e-10,  2.585870423997604e-12,  9.647256945901625e-15,
 -1.677185121101796e-16,  5.311980856817947e-19,  4.942012400344365e-21, -5.641096990448201e-23,  9.069242273152746e-26,  7.136644351334933e-01, -5.206940074396546e-03,
  1.437274911683550e-05,  6.204235604203249e-08, -6.840082360301027e-10,  3.921675552123611e-13,  2.747836363579805e-14, -1.379483808080760e-16, -7.248125122443884e-19,
  1.035172103458074e-20, -9.789372716742694e-24, -5.170327607984053e-25,  8.539033461181113e-01, -5.649745936590947e-03,  9.170563489002092e-06,  1.059303585627313e-07,
 -5.562790675829163e-10, -2.769837557341087e-12,  3.247906349639060e-14,  4.125247191580473e-17, -1.788035455825907e-18,  3.162667416140136e-21,  8.962640724108700e-23,
 -4.594527273811718e-25,  9.997935830091053e-01, -5.881929525558670e-03,  2.244977187032549e-06,  1.339199649508044e-07, -1.989922566129156e-10, -5.351938624947555e-12,
  1.526953727782948e-14,  2.521766120687744e-16, -1.128334013113828e-18, -1.268989672120912e-20,  8.187527620900209e-23,  6.489260534853453e-25,  1.148475433216148e+00,
 -5.865101514894804e-03, -5.568779946241713e-06,  1.351929824813315e-07,  2.925815415813236e-10, -5.608475790859660e-12, -1.777716472979633e-14,  2.818429496504213e-16,
  1.163522294621224e-18, -1.561348262718055e-20, -7.971693352175770e-23,  9.151963438425876e-25,  1.296677490957964e+00, -5.578539270006387e-03, -1.309564497251966e-05,
  1.050040449039032e-07,  7.292219056153826e-10, -2.815652044726545e-12, -4.323968509530219e-14,  3.955311055551606e-17,  2.563067685022544e-18,  4.430304513591777e-21,
 -1.462107171511379e-22, -6.763385579661440e-25,  1.440736649881997e+00, -5.026199330312861e-03, -1.899788354750240e-05,  4.847246501377156e-08,  9.020969564474338e-10,
  1.752981329038247e-12, -3.748150565953804e-14, -2.671472247608347e-16,  9.176683362387172e-19,  2.047871430853642e-20,  4.073910879999441e-23, -1.122175220839469e-24,
  1.576660058022475e+00, -4.242752810028690e-03, -2.207272766609804e-05, -1.854705869811640e-08,  7.037707110381271e-10,  5.191134795733806e-12, -2.146909745678675e-15,
 -2.972096560944319e-16, -1.869503926142798e-18,  5.232599313533808e-21,  1.533053912207364e-22,  7.331240520446776e-25,  1.700242719492656e+00, -3.296686369369328e-03,
 -2.162770527797853e-05, -7.364523717195778e-08,  2.269246207434691e-10,  5.050166921066503e-12,  3.036005353313900e-14, -1.439812440853747e-17, -1.854394543452064e-18,
 -1.544243189804313e-20, -2.312617366613799e-23,  7.727244937994370e-25,  1.807250423602684e+00, -2.288120607377790e-03, -1.782269140987612e-05, -9.721965369938185e-08,
 -2.548367160398486e-10,  1.714876480945035e-12,  2.910097089075897e-14,  2.058459410457778e-16,  5.299072462417999e-19, -6.261140523250642e-21, -9.844979565488534e-23,
 -6.798766287705211e-25,  1.893667750714680e+00, -1.339366351013323e-03, -1.181260992195880e-05, -8.337769406523004e-08, -4.617242827364258e-10, -1.613678073967539e-12,
  2.847774615315168e-15,  1.113197130587738e-16,  1.153742801128811e-18,  7.699124642759748e-21,  2.822189483421958e-23, -9.943207855605846e-26,  1.955995168056382e+00,
 -5.778070969791179e-04, -5.538127569372423e-06, -4.543285541904791e-08, -3.316164709335700e-10, -2.155031099930468e-12, -1.207330773545867e-14, -5.212804172776267e-17,
 -8.419005579935836e-20,  1.489159897370524e-21,  2.347702216773438e-23,  2.283144718317727e-25,  1.991568240535725e+00, -1.133231841600687e-04, -1.136636087982458e-06,
 -1.006662727343961e-08, -8.288282099803269e-11, -6.483669311639662e-13, -4.869450620840331e-15, -3.528228569884788e-17, -2.469963147046864e-19, -1.668581050746945e-21,
 -1.083257184798666e-23, -6.702432423897295e-26,  2.055009592753872e-03, -2.095418442228237e-05,  1.600996420307142e-07, -1.086152501331582e-09,  6.897664633351285e-12,
 -4.198122353610554e-14,  2.478744672396268e-16, -1.430399153646408e-18,  8.101903618275600e-21, -4.519027984820132e-23,  2.486029691779264e-25, -1.351374618340141e-27,
  1.847114740992742e-02, -1.872035352094125e-04,  1.411932374194508e-06, -9.366618110692998e-09,  5.744967311032398e-11, -3.324052521096998e-13,  1.828497513454185e-15,
 -9.576431403178277e-18,  4.752631550563442e-20, -2.210010398295880e-22,  9.378055722169053e-25, -3.416011734118194e-27,  5.117462008579724e-02, -5.123171170570334e-04,
  3.762894101033937e-06, -2.381311114580851e-08,  1.352695791886722e-10, -6.935771012622328e-13,  3.144496348957577e-15, -1.177268970550712e-17,  2.734055986251929e-20,
  6.995721178081414e-23, -1.523357055611391e-24,  1.331954732231071e-26,  9.990237020445031e-02, -9.815147073776987e-04,  6.916267475705638e-06, -4.051039726811075e-08,
  2.003358559075381e-10, -7.878820835159492e-13,  1.801400723334075e-15,  5.959595206389558e-18, -1.125481078833636e-19,  9.077401277012397e-22, -5.265324897074744e-24,
  2.184850197843930e-26,  1.642460329411883e-01, -1.572624575013425e-03,  1.044950465589873e-05, -5.436268500398958e-08,  2.080362125251292e-10, -3.329139764941167e-13,
 -3.189316163701679e-15,  3.944150827408605e-17, -2.583429899698992e-19,  1.053578155207030e-21, -7.254621495154748e-25, -3.220837272515566e-26,  2.436350031799153e-01,
 -2.256150841846223e-03,  1.384342238545119e-05, -5.999862343808379e-08,  1.248878619280647e-10,  7.123576622680840e-13, -9.894332326976344e-15,  6.004285808404187e-17,
 -1.651126471391837e-19, -8.111494460973688e-22,  1.380266649753011e-23, -9.345284675982463e-26,  3.373132661329594e-01, -2.995487441839850e-03,  1.652441827911885e-05,
 -5.290842830808824e-08, -5.547206785090365e-11,  2.027683935249510e-12, -1.356295395493593e-14,  3.141703107209071e-17,  2.789935746689801e-19, -3.573802224969997e-21,
  1.788721109928847e-23,  5.048944570011770e-27,  4.443096525778428e-01, -3.747402589839946e-03,  1.792173140185028e-05, -3.070530669847985e-08, -3.007022986544265e-10,
  2.961127749681076e-12, -9.020115716708904e-15, -5.464301950464177e-17,  7.707827910546284e-19, -3.228175269851971e-21, -1.114616812096886e-23,  2.346477468909831e-25,
  5.634013656738107e-01, -4.462968128093425e-03,  1.754088048314316e-05,  5.682382728177518e-09, -5.383090258532513e-10,  2.763121032779051e-12,  5.212811223172465e-15,
 -1.482993767191352e-16,  6.697389498902271e-19,  2.795724012226222e-21, -5.024091549874336e-23,  1.817115084314257e-25,  6.930710924526662e-01, -5.089165276416947e-03,
  1.505196380560522e-05,  5.119544681347291e-08, -6.698950419188180e-10,  1.003017288803390e-12,  2.334633287513732e-14, -1.552972205139314e-16, -3.642774493001057e-19,
  9.549899106781606e-21, -2.915197858237033e-23, -3.596836746200843e-25,  8.314589232813440e-01, -5.571452012882042e-03,  1.038663489649704e-05,  9.662935015416621e-08,
 -6.038201644841139e-10, -1.982815832452290e-12,  3.285489872174328e-14, -1.349349923275708e-17, -1.614954145625066e-18,  6.297213768589389e-21,  6.614129722066894e-23,
 -5.911548386461964e-25,  9.763118754980009e-01, -5.857603669619097e-03,  3.829452100421841e-06,  1.299020122843655e-07, -3.018171946900658e-10, -4.905216675082883e-12,
  2.176111555953722e-14,  2.094432795474462e-16, -1.520133669783086e-18, -8.931973920156289e-21,  1.037381845663362e-22,  3.365063358818543e-25,  1.124936302282887e+00,
 -5.903091571012946e-03, -3.922145514645578e-06,  1.389565015849142e-07,  1.768041923964914e-10, -5.936760554582335e-12, -9.452714317327226e-15,  3.095499488606730e-16,
  5.543869652116100e-19, -1.792853389614604e-20, -3.463099732044148e-23,  1.107415819194342e-24,  1.274162057786073e+00, -5.678070530838573e-03, -1.176763067196156e-05,
  1.161652512862944e-07,  6.626694194787831e-10, -3.830740889388356e-12, -4.096831752310667e-14,  1.229431351344676e-16,  2.611185910231212e-18, -1.893642259197808e-21,
 -1.667726480957601e-22, -2.361518335450901e-25,  1.420331919834459e+00, -5.175608015365132e-03, -1.832862079981584e-05,  6.313514271900262e-08,  9.275752047302457e-10,
  7.676719481368321e-13, -4.443803147320341e-14, -2.257747695912668e-16,  1.671340813834557e-18,  2.101335603513756e-20, -1.643160672570817e-23, -1.453415984829787e-24,
  1.559334754173613e+00, -4.420025606737541e-03, -2.222432131986864e-05, -6.461893726546373e-09,  8.063700373213565e-10,  5.033204237017869e-12, -1.126921916292225e-14,
 -3.527780529430472e-16, -1.563734359293551e-18,  1.192359498876655e-20,  1.787074583103401e-22,  3.845354309845008e-25,  1.686704431274858e+00, -3.473173327209981e-03,
 -2.248620268881064e-05, -6.916709135971312e-08,  3.351448648038252e-10,  5.766746668052726e-12,  2.904171145897476e-14, -8.273821763097342e-17, -2.417648452987322e-18,
 -1.556263308755903e-20,  2.028558597004028e-23,  1.206813114972461e-24,  1.797805295318830e+00, -2.435435134606460e-03, -1.901253140695904e-05, -1.009827220716357e-07,
 -2.130791793796245e-10,  2.484143255155074e-12,  3.506240877052617e-14,  2.183772218475101e-16,  2.263006746904753e-19, -1.080839559154740e-20, -1.290044926198484e-22,
 -6.913538183104888e-25,  1.888114766348373e+00, -1.437997371795464e-03, -1.285851769677091e-05, -9.101861940688571e-08, -4.930392297307334e-10, -1.503492493057597e-12,
  6.524761723489031e-15,  1.528808050393996e-16,  1.449760673265255e-18,  8.693616490804344e-21,  2.018719071549368e-23, -2.805273988705202e-25,  1.953591744939062e+00,
 -6.243864746902541e-04, -6.116631701407406e-06, -5.109976855724206e-08, -3.777342510777030e-10, -2.462553408467235e-12, -1.356113708686167e-14, -5.376190905193686e-17,
 -1.101514813810278e-20,  2.655999122206716e-21,  3.558225186106839e-23,  3.269043980307064e-25,  1.991095963377593e+00, -1.229230436074942e-04, -1.265841814870688e-06,
 -1.150319357929922e-08, -9.710371075901645e-11, -7.780403754299248e-13, -5.977670651896290e-15, -4.423701161210667e-17, -3.156284009317301e-19, -2.166763678430780e-21,
 -1.423265430970032e-23, -8.847750850208917e-26,  1.973674468885337e-03, -1.972370821831816e-05,  1.477012912543371e-07, -9.821967435804463e-10,  6.114431159918673e-12,
 -3.648499131818760e-14,  2.112214123851345e-16, -1.195359073514069e-18,  6.640601082112617e-21, -3.633958730060683e-23,  1.961478590527302e-25, -1.046704024594775e-27,
  1.774423373761124e-02, -1.763425377794184e-04,  1.304836219732312e-06, -8.498311987924776e-09,  5.121954602071742e-11, -2.915742372638414e-13,  1.580503115552738e-15,
 -8.175932784158850e-18,  4.021037981844283e-20, -1.863734021304508e-22,  7.965956723717362e-25, -3.002034365677007e-27,  4.918379871321680e-02, -4.833212284043512e-04,
  3.489677866459757e-06, -2.175578006320140e-08,  1.221265351984579e-10, -6.219640155154705e-13,  2.827410656834206e-15, -1.086818191995324e-17,  2.889266056321962e-20,
  1.957585927167025e-23, -1.022631445665174e-24,  9.618821423644981e-27,  9.608396823394554e-02, -9.280757573541784e-04,  6.448862695807846e-06, -3.742868589419870e-08,
  1.850220864621317e-10, -7.430242284027844e-13,  1.922481444211895e-15,  2.842111322795374e-18, -8.343417444810755e-20,  7.157548452254186e-22, -4.350017341121088e-24,
  1.965038600879630e-26,  1.581186743384718e-01, -1.491581892048295e-03,  9.816891703825813e-06, -5.109117158535818e-08,  2.006972703263733e-10, -3.971046034333850e-13,
 -2.195044258125989e-15,  3.177329447355330e-17, -2.212368690373625e-19,  1.000668934328215e-21, -1.818556525709763e-24, -1.826336167811968e-26,  2.348273839576347e-01,
 -2.148248425437186e-03,  1.313585803663191e-05, -5.789878207388002e-08,  1.368933657397760e-10,  4.944476725064424e-13, -8.290778344012824e-15,  5.439079983152484e-17,
 -1.853281313056247e-19, -3.369753754498743e-22,  1.001585593921118e-23, -7.841713349347144e-26,  3.255916686368674e-01, -2.865843819840438e-03,  1.588547366007557e-05,
 -5.348892228964473e-08, -1.809751692164117e-11,  1.713624059983460e-12, -1.257664562328094e-14,  3.842417983942680e-17,  1.631700966434198e-19, -2.864504686657887e-21,
  1.734348458507049e-23, -2.715888074520058e-26,  4.296043466828459e-01, -3.605579962259996e-03,  1.752631524042530e-05, -3.505499672697106e-08, -2.437545627389105e-10,
  2.728962090440756e-12, -1.022278220727574e-14, -3.190431809123004e-17,  6.488692399414659e-19, -3.485366548120830e-21, -2.156270083198668e-24,  1.739787020359358e-25,
  5.458303779841831e-01, -4.322510512633983e-03,  1.755923333784918e-05, -2.483031995887114e-09, -4.821190119725122e-10,  2.840901224626228e-12,  1.372932695477205e-15,
 -1.256285742213590e-16,  7.362929752513086e-19,  9.623488050928354e-22, -4.110069822280559e-23,  2.267731457369808e-25,  6.729588986323007e-01, -4.966472681022386e-03,
  1.560275576173155e-05,  4.066655438262051e-08, -6.445892815566029e-10,  1.510141093397089e-12,  1.888472894916057e-14, -1.617064550866969e-16, -4.484198353331333e-20,
  8.115853105547779e-21, -4.135866201481002e-23, -1.964544476181560e-25,  8.093464097276191e-01, -5.483887700575389e-03,  1.148704988548877e-05,  8.669358910830395e-08,
 -6.356511377070442e-10, -1.204445308385148e-12,  3.179100192367608e-14, -6.108621014173367e-17, -1.347061495921351e-18,  8.406446519816591e-21,  3.909412368168962e-23,
 -6.224640897534903e-25,  9.529524791220201e-01, -5.820822112587080e-03,  5.356161475336773e-06,  1.243183704832562e-07, -3.942534058877074e-10, -4.318341635247053e-12,
  2.690201621979963e-14,  1.564781175078310e-16, -1.764320630893955e-18, -4.584666194538701e-21,  1.112038526191355e-22,  4.723999158623478e-27,  1.101271798277365e+00,
 -5.927759821522872e-03, -2.241644361374945e-06,  1.408261359042561e-07,  5.651019168865046e-11, -6.058215798334021e-12, -6.353267193853941e-16,  3.167928023635615e-16,
 -1.040415477783166e-19, -1.832096400151105e-20,  1.513350708668914e-23,  1.124431576254894e-24,  1.251270568490005e+00, -5.766461561383640e-03, -1.031272912716498e-05,
  1.261029598000647e-07,  5.765494022833788e-10, -4.763338925374407e-12, -3.637559921322017e-14,  2.041116211768746e-16,  2.421821906837727e-18, -8.619066766478015e-21,
 -1.656019897431701e-22,  2.972314540546537e-25,  1.399341385351649e+00, -5.318953414273605e-03, -1.748163850200194e-05,  7.803919455041447e-08,  9.317856324299904e-10,
 -3.679662787114795e-13, -4.989888811604962e-14, -1.604439293732145e-16,  2.400015969544907e-18,  1.901841858737488e-20, -8.435656638919323e-23, -1.595039086324219e-24,
  1.541298891093193e+00, -4.597903477615319e-03, -2.222118761667260e-05,  7.227189878514098e-09,  9.035020506698603e-10,  4.639001698164684e-12, -2.177304236739923e-14,
 -3.945456711792797e-16, -1.003099029011845e-18,  1.925769325140286e-20,  1.838305744195652e-22, -1.869206951295555e-25,  1.672446842580621e+00, -3.656282802778345e-03,
 -2.328010769824285e-05, -6.284517516795986e-08,  4.572148099626834e-10,  6.426696125280614e-12,  2.555946650335153e-14, -1.687987474696436e-16, -2.949312070089293e-18,
 -1.355918761577999e-20,  8.302741815141404e-23,  1.636176932075854e-24,  1.787751603133656e+00, -2.592436430747820e-03, -2.024298632978319e-05, -1.039467159319648e-07,
 -1.544834875534166e-10,  3.399437527828688e-12,  4.121241979817795e-14,  2.183391117326151e-16, -2.628012248894006e-19, -1.655096659062384e-20, -1.571631872066887e-22,
 -5.580433989458784e-25,  1.882149930901819e+00, -1.545370736180612e-03, -1.399903342819701e-05, -9.913774409835946e-08, -5.211680646919752e-10, -1.289993847258523e-12,
  1.150291695462241e-14,  2.044080133363531e-16,  1.773618456148081e-18,  9.178756052222227e-21,  1.991478474524968e-24, -5.663610578022855e-25,  1.950992299217938e+00,
 -6.758789214193574e-04, -6.767775377195469e-06, -5.755572013892457e-08, -4.303617169745566e-10, -2.806025625311962e-12, -1.505489931641121e-14, -5.227959127470154e-17,
  1.140115521339308e-19,  4.403157723952941e-21,  5.273502524397285e-23,  4.586946755659886e-25,  1.990583104577949e+00, -1.336295790693344e-04, -1.413742052602043e-06,
 -1.318957692707179e-08, -1.142057080197256e-10, -9.375856196261480e-13, -7.370264700310179e-15, -5.570311844348563e-17, -4.048868477402732e-19, -2.821631115195826e-21,
 -1.871389988445600e-23, -1.163964722187174e-25,  1.897070486732560e-03, -1.858763392921389e-05,  1.364786977412462e-07, -8.899389736846077e-10,  5.432832558375171e-12,
 -3.179446246527575e-14,  1.805399740056857e-16, -1.002362807962324e-18,  5.463175397079573e-21, -2.934186579979213e-23,  1.554270370736351e-25, -8.145449435421656e-28,
  1.705911419469740e-02, -1.662982654593531e-04,  1.207587582799664e-06, -7.723465449732729e-09,  4.574956493198983e-11, -2.562498610944647e-13,  1.368624978625578e-15,
 -6.990653133930636e-18,  3.404375000713830e-20, -1.570311365453039e-22,  6.734537096300015e-25, -2.599210853027693e-27,  4.730474088590850e-02, -4.564157864356320e-04,
  3.239933821647342e-06, -1.989768437873901e-08,  1.103417261536676e-10, -5.576530045956923e-13,  2.536099665103658e-15, -9.939461266879477e-18,  2.895505932683298e-20,
 -1.373515650095452e-23, -6.629335605846662e-25,  6.867266973222421e-27,  9.247207200764991e-02, -8.782322196993751e-04,  6.016998371453507e-06, -3.458468754908934e-08,
  1.706279809242953e-10, -6.962087730260233e-13,  1.968325868317867e-15,  5.525570727263441e-19, -6.059743275596230e-20,  5.582971246761377e-22, -3.541792712025614e-24,
  1.705772173707311e-26,  1.523056103587912e-01, -1.415445165746926e-03,  9.222794014606942e-06, -4.794612582434779e-08,  1.922964343005799e-10, -4.398770822024980e-13,
 -1.399198752556946e-15,  2.525468163814389e-17, -1.866868190410389e-19,  9.149842928776525e-22, -2.395097510909061e-24, -8.557195607382201e-27,  2.264402171495566e-01,
 -2.045902783845868e-03,  1.245450711560116e-05, -5.563968214339673e-08,  1.449123892875165e-10,  3.130655477518921e-13, -6.852173126130870e-15,  4.833705047321985e-17,
 -1.910375234724847e-19, -7.568377599267451e-25,  6.908021061774116e-24, -6.293378791261148e-26,  3.143783921306718e-01, -2.741329921340015e-03,  1.524294812157810e-05,
 -5.352032741709039e-08,  1.324637757460629e-11,  1.425194549308978e-12, -1.144223198720603e-14,  4.212683051106376e-17,  7.218868492618211e-20, -2.200915983379848e-21,
  1.570377771016666e-23, -4.536456097726789e-26,  4.154596954542512e-01, -3.467114321347236e-03,  1.708401204410255e-05, -3.853202930839196e-08, -1.916895145946464e-10,
  2.475125596822083e-12, -1.084430958744318e-14, -1.315078890351577e-17,  5.235303160758267e-19, -3.435794735427064e-21,  4.218431701480175e-24,  1.168803950723790e-25,
  5.288209155237314e-01, -4.182282643778970e-03,  1.748503117096129e-05, -9.741749468563595e-09, -4.252425532934830e-10,  2.834324000889200e-12, -1.811747379277433e-15,
 -1.018103416266813e-16,  7.437963029757925e-19, -4.774802776949621e-22, -3.083519648981857e-23,  2.345812995214649e-25,  6.533454983547892e-01, -4.839871520839944e-03,
  1.602994609949281e-05,  3.061783511881229e-08, -6.102206101625317e-10,  1.909137252664773e-12,  1.437842103014333e-14, -1.588001574972899e-16,  2.158769634937609e-19,
  6.333269369965406e-21, -4.671204351180710e-23, -5.135236078229647e-26,  7.876009942678569e-01, -5.388004470977599e-03,  1.246568800493149e-05,  7.637124962363114e-08,
 -6.522726991541515e-10, -4.665680986593344e-13,  2.952444405136814e-14, -9.910130832322091e-17, -1.022796315697354e-18,  9.432984455551968e-21,  1.263061417654453e-23,
 -5.682749485001939e-25,  9.297641776997236e-01, -5.772119104969254e-03,  6.807400913154658e-06,  1.173558347962697e-07, -4.738423695907741e-10, -3.626618285423745e-12,
  3.047427147269506e-14,  9.823247612824527e-17, -1.850085996649054e-18, -2.231791117131567e-22,  1.047295559960763e-22, -2.885381562584521e-25,  1.077535605038481e+00,
 -5.938927150070372e-03, -5.502986509627426e-07,  1.407631573315112e-07, -6.409262421702469e-11, -5.968000359695874e-12,  8.090492770024533e-15,  3.031223549998765e-16,
 -7.410717961069025e-19, -1.676093718795137e-20,  6.170564888121136e-23,  9.654696986031130e-25,  1.228049513876927e+00, -5.842761169069465e-03, -8.747436641445812e-06,
  1.345202788095737e-07,  4.730592835914884e-10, -5.559346094867183e-12, -2.963106332942169e-14,  2.754020717265357e-16,  1.996910916090331e-18, -1.482217220389665e-20,
 -1.406983625207736e-22,  8.247506028519076e-25,  1.377792152984606e+00, -5.454808184233001e-03, -1.645617415776767e-05,  9.282245847018672e-08,  9.121341272108640e-10,
 -1.610164342181968e-12, -5.321861906131847e-14, -7.347673776713704e-17,  3.007140903024580e-18,  1.425699710219052e-20, -1.527774326282113e-22, -1.465849737720122e-24,
  1.522552643433263e+00, -4.775073472938204e-03, -2.204476577059108e-05,  2.239325827855355e-08,  9.901458801500762e-10,  3.980944830812312e-12, -3.315552273005736e-14,
 -4.141617354391811e-16, -1.813475200182364e-19,  2.623542878349090e-20,  1.595707696665430e-22, -9.382327206817124e-25,  1.657444642124702e+00, -3.845405894002820e-03,
 -2.398601246064978e-05, -5.446994164149655e-08,  5.914432332129127e-10,  6.972317721401610e-12,  1.944384501631011e-14, -2.701985554228037e-16, -3.359340304888085e-18,
 -8.693797765929417e-21,  1.625068696631376e-22,  1.944587131368646e-24,  1.777050017622079e+00, -2.759406256738468e-03, -2.150275400372586e-05, -1.058187467268533e-07,
 -7.611597219909875e-11,  4.460352223137204e-12,  4.710970111681922e-14,  1.991396456982122e-16, -9.769506936221151e-19, -2.324138050913275e-20, -1.747207618252191e-22,
 -1.945837397009088e-25,  1.875736726375121e+00, -1.662265226231090e-03, -1.523951569585678e-05, -1.076657670912801e-07, -5.437092054087414e-10, -9.385247981433009e-13,
  1.807039312365623e-14,  2.664108354655941e-16,  2.098471635379678e-18,  8.647050388145971e-21, -3.163112558197115e-23, -9.860282041088389e-25,  1.948175953845685e+00,
 -7.329052525285019e-04, -7.501675650143869e-06, -6.491059155712272e-08, -4.902111669445452e-10, -3.184334835865933e-12, -1.644067612339361e-14, -4.564565019797807e-17,
  3.157816436486634e-19,  6.963224819805387e-21,  7.649977597183845e-23,  6.277409843681272e-25,  1.990024918165072e+00, -1.456051694503279e-04, -1.583632177291342e-06,
 -1.517705066846487e-08, -1.348606030697655e-10, -1.134751573678600e-12, -9.127702869315684e-15, -7.043982754064951e-17, -5.212630025652518e-19, -3.682524493582703e-21,
 -2.459089126801016e-23, -1.521276708775576e-25,  1.824837999179790e-03, -1.753709053158755e-05,  1.263007349939192e-07, -8.078745417923293e-10,  4.838097648852411e-12,
 -2.777947695142631e-14,  1.547706852867624e-16, -8.433089104572202e-19,  4.510652218506995e-21, -2.378583292351274e-23,  1.236674143406218e-25, -6.368328154867690e-28,
  1.641267261933236e-02, -1.569962254833175e-04,  1.119134435148193e-06, -7.030752103004913e-09,  4.093779760685194e-11, -2.256336618792630e-13,  1.187324242903600e-15,
 -5.986720944087539e-18,  2.884897919326475e-20, -1.322681733185746e-22,  5.674040774366904e-25, -2.227315951676796e-27,  4.552944573748730e-02, -4.314222183720032e-04,
  3.011396822288322e-06, -1.821822691455980e-08,  9.977532583519122e-11, -5.000221960868499e-13,  2.270659021930805e-15, -9.025377051218842e-18,  2.805016179052404e-20,
 -3.485247321979652e-23, -4.076965508635792e-25,  4.837298403069933e-27,  8.905285081350392e-02, -8.317109284700675e-04,  5.617911228834724e-06, -3.196346501441640e-08,
  1.571763997881630e-10, -6.489847842070370e-13,  1.959484653479096e-15, -1.090902923826381e-18, -4.287504841235769e-20,  4.308571020496192e-22, -2.849360916521537e-24,
  1.443115257172264e-26,  1.467878234412577e-01, -1.343912602361042e-03,  8.665605361843287e-06, -4.494135910122788e-08,  1.832170004669494e-10, -4.656175795977640e-13,
 -7.708869134537574e-16,  1.978863785479514e-17, -1.555430525802379e-19,  8.137548532459191e-22, -2.619464793960716e-24, -2.103019063959237e-27,  2.184517057155199e-01,
 -1.948897595451855e-03,  1.180092142639470e-05, -5.327948090296281e-08,  1.496352434327074e-10,  1.641656022323541e-13, -5.583974483102301e-15,  4.227158926219296e-17,
 -1.867186284958926e-19,  2.245224932748327e-22,  4.460507673239086e-24, -4.858955754499479e-26,  3.036528998934074e-01, -2.621949637704558e-03,  1.460286924638144e-05,
 -5.309487007061144e-08,  3.910073038852864e-11,  1.164927653786027e-12, -1.024141078069908e-14,  4.328628116847070e-17,  3.753476339353021e-21, -1.615620805663631e-21,
  1.350446284903484e-23, -5.317740909142355e-26,  4.018615851623889e-01, -3.332340232119548e-03,  1.660481301227402e-05, -4.121727501319555e-08, -1.448101592035955e-10,
  2.212223695438149e-12, -1.099629867275111e-14,  1.664876652269103e-18,  4.039803921563507e-19, -3.179220364966345e-21,  8.256260093444695e-24,  6.830280452136007e-26,
  5.123706474362668e-01, -4.042981376153297e-03,  1.732916736083077e-05, -1.609542212876402e-08, -3.692079952302840e-10,  2.759299459207664e-12, -4.333381510306168e-15,
 -7.850194926173709e-17,  7.068605411062758e-19, -1.508356385671344e-21, -2.084401469878712e-23,  2.161640587218907e-25,  6.342445880100606e-01, -4.710325259701159e-03,
  1.634009561610994e-05,  2.117702161505197e-08, -5.689423217195927e-10,  2.201840823998407e-12,  1.006041936337729e-14, -1.486069759898126e-16,  4.100279631515587e-19,
  4.455391038333962e-21, -4.636101372049365e-23,  6.127300945092527e-26,  7.662539805083466e-01, -5.284791029122929e-03,  1.331933886842263e-05,  6.589772947621719e-08,
 -6.547607299318759e-10,  2.053381727933592e-13,  2.634286631062344e-14, -1.263470601529654e-16, -6.798733132607102e-19,  9.468198330891157e-21, -1.004139210916680e-23,
 -4.550072058485277e-25,  9.067933498449900e-01, -5.712160952845542e-03,  8.167919484323470e-06,  1.092346514044422e-07, -5.388726217409970e-10, -2.868898781627376e-12,
  3.240033372482403e-14,  3.968057423725729e-17, -1.786418053150732e-18,  3.642750345120718e-21,  8.701932650358345e-23, -5.006962702883555e-25,  1.053781753191850e+00,
 -5.936599329631134e-03,  1.128809392640243e-06,  1.387961758455193e-07, -1.808395782878899e-10, -5.675197667948948e-12,  1.615906356580759e-14,  2.703086267519170e-16,
 -1.290508329181947e-18, -1.352264472817694e-20,  9.803027475915008e-23,  6.673770076466225e-25,  1.204548903969660e+00, -5.906163704412307e-03, -7.091566472570766e-06,
  1.411638381234761e-07,  3.554206091058280e-10, -6.171265656839108e-12, -2.111269919263494e-14,  3.297586382685118e-16,  1.371990705246776e-18, -1.959077523468845e-20,
 -9.470454971543190e-23,  1.238957883484448e-24,  1.355717022429514e+00, -5.581756899982387e-03, -1.525602871178694e-05,  1.070890829009860e-07,  8.670497731281971e-10,
 -2.900796503851172e-12, -5.386072094876028e-14,  2.966408262792983e-17,  3.395768871768339e-18,  6.961216086935461e-21, -2.088700301786997e-22, -1.035175284503707e-24,
  1.503101722992928e+00, -4.950081652466340e-03, -2.167851606843866e-05,  3.882536570587102e-08,  1.060868599947117e-09,  3.046312662820781e-12, -4.468306448897691e-14,
 -4.037165078807757e-16,  8.658778863846491e-19,  3.155168638738897e-20,  1.002763866443001e-22, -1.754380276731020e-24,  1.641675343911346e+00, -4.039736929345896e-03,
 -2.457819691109731e-05, -4.386871836626177e-08,  7.348794704420456e-10,  7.335795770298780e-12,  1.033617705294420e-14, -3.812806019406536e-16, -3.534329779398644e-18,
 -4.472905850633551e-22,  2.500609537546145e-22,  1.975108268154724e-24,  1.765660286530209e+00, -2.936521104188702e-03, -2.277673826947938e-05, -1.062596929995468e-07,
  2.482733488950078e-11,  5.653541757110052e-12,  5.211248971449750e-14,  1.531345738522356e-16, -1.939956598889552e-18, -3.022677824553360e-20, -1.696017229782210e-22,
  4.856457296225242e-25,  1.868835440164500e+00, -1.789498457828920e-03, -1.658423681534884e-05, -1.164890382233941e-07, -5.574981894779127e-10, -4.074566128241592e-13,
  2.651453234116820e-14,  3.382043986622239e-16,  2.375126486930873e-18,  6.357230534830379e-21, -8.701444802804163e-23, -1.556218038174199e-24,  1.945119178019742e+00,
 -7.961726850991448e-04, -8.329835258231470e-06, -7.328531326209024e-08, -5.579401846485578e-10, -3.592851995307853e-12, -1.753505901616772e-14, -3.088180522168594e-17,
  6.287156906907218e-19,  1.063335492343960e-20,  1.084902180827691e-22,  8.311476915586227e-25,  1.989415951754429e+00, -1.590412130097331e-04, -1.779492812141065e-06,
 -1.752898923040496e-08, -1.599163277364331e-10, -1.379498731992307e-12, -1.135490658592765e-14, -8.944504454580062e-17, -6.732646531621563e-19, -4.812477616983940e-21,
 -3.223078036679195e-23, -1.966113520268153e-25,  1.756650854112085e-03, -1.656418761937001e-05,  1.170529959120835e-07, -7.347156194132220e-10,  4.317821507320067e-12,
 -2.433278016715919e-14,  1.330565811890916e-16, -7.117661604734608e-19,  3.737044421371354e-21, -1.935673513722400e-23,  9.878123245485583e-26, -5.002347049737105e-28,
  1.580207481148102e-02, -1.483698242018073e-04,  1.038551384194613e-06, -6.410355628012966e-09,  3.669702531913157e-11, -1.990493481720057e-13,  1.031934713451522e-15,
 -5.135545321213545e-18,  2.447316021921136e-20, -1.114312927732537e-22,  4.768578059965911e-25, -1.895385917589660e-27,  4.385059196331215e-02, -4.081791210129018e-04,
  2.802035876798362e-06, -1.669894842583809e-08,  9.029988942716854e-11, -4.484587389566718e-13,  2.030306143922828e-15, -8.150606934331889e-18,  2.654886529489594e-20,
 -4.737552368168025e-23, -2.292751688827352e-25,  3.349620516189313e-27,  8.581352353195192e-02, -7.882601028977314e-04,  5.249018495241285e-06, -2.954993801390363e-08,
  1.446637630546758e-10, -6.024651565703255e-13,  1.911913293575533e-15, -2.235530480519237e-18, -2.926947744400079e-20,  3.288412494498789e-22, -2.269372026515086e-24,
  1.196937737107208e-26,  1.415474765894078e-01, -1.276695823053328e-03,  8.143587811969458e-06, -4.208521253466763e-08,  1.737617220812847e-10, -4.780059840498529e-13,
 -2.822291102431144e-16,  1.525966295839077e-17, -1.281437092272482e-19,  7.084663306075653e-22, -2.615556508245529e-24,  1.945087846332815e-27,  2.108409385676931e-01,
 -1.857006734164586e-03,  1.117601847207653e-05, -5.086594162910393e-08,  1.516708200234445e-10,  4.368689446326800e-14, -4.482582389559349e-15,  3.645640227179451e-17,
 -1.759045512844380e-19,  3.639922508303485e-22,  2.603415202187589e-24, -3.617680137380053e-26,  2.933947292827980e-01, -2.507662916128836e-03,  1.397021119330443e-05,
 -5.229581308242884e-08,  6.003937345981443e-11,  9.336414291776737e-13, -9.035740549726450e-15,  4.257542668350431e-17, -4.525602587762217e-20, -1.122863743159152e-21,
  1.112847573999809e-23, -5.389545271561265e-26,  3.887947174382663e-01, -3.201516275985124e-03,  1.609771765977031e-05, -4.319458014259080e-08, -1.031939114882519e-10,
  1.950229376057373e-12, -1.078541999900755e-14,  1.282990260476678e-17,  2.960867315414272e-19, -2.800848446599022e-21,  1.038517128961457e-23,  3.024618188103801e-26,
  4.964746290605607e-01, -3.905216888206707e-03,  1.710237922838087e-05, -2.156761491695870e-08, -3.152270826297037e-10,  2.631422179607618e-12, -6.223967888438122e-15,
 -5.689406974702295e-17,  6.397621565655661e-19, -2.161075443565451e-21, -1.203967789478699e-23,  1.822930801404203e-25,  6.156661239923310e-01, -4.578739324925547e-03,
  1.654109332530066e-05,  1.243797149619115e-08, -5.228197998032073e-10,  2.394977173442009e-12,  6.104715602687642e-15, -1.332708713259956e-16,  5.379226755694222e-19,
  2.679683173865590e-21, -4.187856830579573e-23,  1.362477832325916e-25,  7.453326832982197e-01, -5.175250792925837e-03,  1.404749800324544e-05,  5.548751994762412e-08,
 -6.446296157619686e-10,  7.929671834626197e-13,  2.255103960552948e-14, -1.427635897630816e-16, -3.507040406002758e-19,  8.706911226393298e-21, -2.698315505927618e-23,
 -3.126787718666182e-25,  8.840834822500124e-01, -5.641724991877635e-03,  9.425247671553122e-06,  1.001961790073935e-07, -5.884173082290903e-10, -2.084273711756026e-12,
  3.273531632362223e-14, -1.476042997852799e-17, -1.598313397184860e-18,  6.642779240021963e-21,  6.217701963746952e-23, -6.112749964679210e-25,  1.030063884705076e+00,
 -5.920964303399884e-03,  2.773332345842627e-06,  1.350182662832446e-07, -2.898782194636270e-10, -5.201644376008133e-12,  2.308207008426094e-14,  2.220312180580106e-16,
 -1.700632312087437e-18, -9.121113688343208e-21,  1.193160526754532e-22,  2.937089835426569e-25,  1.180821636448529e+00, -5.956033240829365e-03, -5.367633478134062e-06,
  1.458388543820616e-07,  2.276989287529709e-10, -6.562885486837140e-12, -1.137540035615082e-14,  3.617586405821017e-16,  6.124270598211106e-19, -2.220907931471209e-20,
 -3.464968456257501e-23,  1.452576502627647e-24,  1.333154363702398e+00, -5.698433879370047e-03, -1.388986366340713e-05,  1.204280231508171e-07,  7.962387744205154e-10,
 -4.171035674357533e-12, -5.148310723564870e-14,  1.406476654646349e-16,  3.486685093528310e-18, -2.117204827835278e-21, -2.400116465258977e-22, -3.451795552395289e-25,
  1.482957903832319e+00, -5.121353374165465e-03, -2.110895680532774e-05,  5.622463324582377e-08,  1.110176011941137e-09,  1.842474605173750e-12, -5.542387772443878e-14,
 -3.572250133313528e-16,  2.053293106397940e-18,  3.379737075409849e-20,  6.887261934931899e-24, -2.453929937858829e-24,  1.625120108002666e+00, -4.238257096875825e-03,
 -2.502919828747110e-05, -3.092730034180828e-08,  8.831454759506572e-10,  7.443031874982738e-12, -1.910752970907373e-15, -4.925407112491872e-16, -3.350150774058015e-18,
  1.120858193327679e-20,  3.297236004698778e-22,  1.559891795907488e-24,  1.753541719992174e+00, -3.123819681013910e-03, -2.404551605009481e-05, -1.048886159642965e-07,
  1.507117898893696e-10,  6.947628901265253e-12,  5.535855674905411e-14,  7.239415746049092e-17, -3.142565488894981e-18, -3.630150950906946e-20, -1.264779695029656e-22,
  1.536517530386431e-24,  1.861403030784596e+00, -1.927915843775834e-03, -1.803577284948053e-05, -1.254362506961322e-07, -5.584716014482412e-10,  3.513012173144225e-13,
  3.707709501496261e-14,  4.170527848047326e-16,  2.523038207598618e-18,  1.308274198780740e-21, -1.705565238988666e-22, -2.258262424632515e-24,  1.941795418593603e+00,
 -8.664864329006438e-04, -9.265267319838054e-06, -8.281032650742868e-08, -6.340623132850063e-10, -4.021410768086760e-12, -1.805413270616496e-14, -3.725165313742425e-18,
  1.099029030706077e-18,  1.576881598296215e-20,  1.498813083287856e-22,  1.049839167521863e-24,  1.988749918515274e+00, -1.741642416807327e-04, -2.006153519397189e-06,
 -2.032407452710652e-08, -1.904476363934138e-10, -1.684673963479889e-12, -1.418891186000712e-14, -1.140281304657756e-16, -8.719404940724959e-19, -6.289731864578418e-21,
 -4.201693991203439e-23, -2.494183415443576e-25,  1.692212723842794e-03, -1.566189144560704e-05,  1.086354037932346e-07, -6.693567552241505e-10,  3.861552399347354e-12,
 -2.136568014240393e-14,  1.147017634654163e-16, -6.026086647325765e-19,  3.106324064797469e-21, -1.581269405627600e-23,  7.918728920686543e-26, -3.948839393796672e-28,
  1.522473885328037e-02, -1.403594226563876e-04,  9.650228875573684e-07, -5.853752820222478e-09,  3.295249736196781e-11, -1.759235423036830e-13,  8.985256818522859e-16,
 -4.413065061114745e-18,  2.078568137405233e-20, -9.393670902413232e-23,  3.999766840031305e-25, -1.606322137898881e-27,  4.226147273086116e-02, -3.865404867878478e-04,
  2.610029670417734e-06, -1.532333196138915e-08,  8.179999179528135e-11, -4.023756271730948e-13,  1.813715590970744e-15, -7.329834395211827e-18,  2.471060434854747e-20,
 -5.394337743728153e-23, -1.070069420647698e-25,  2.264694575481203e-27,  8.274227598480709e-02, -7.476479030791514e-04,  4.907917346805340e-06, -2.732924214741658e-08,
  1.330677461593351e-10, -5.574258772285784e-13,  1.837866264117212e-15, -2.999271039301772e-18, -1.894434307604822e-20,  2.479305444367363e-22, -1.792213346652080e-24,
  9.766089281758557e-27,  1.365678579904390e-01, -1.213520675842569e-03,  7.654930088298469e-06, -3.938173673534248e-08,  1.641661789709758e-10, -4.800927540097101e-13,
  9.132454551792665e-17,  1.154716554856648e-17, -1.044941139177732e-19,  6.063450526684295e-22, -2.473643377855481e-24,  4.268783876008962e-27,  2.035879203983757e-01,
 -1.769998867018327e-03,  1.058019839127927e-05, -4.843772811021915e-08,  1.515481877140464e-10, -5.226904968851410e-14, -3.538512229216838e-15,  3.105429366443547e-17,
 -1.612808687850491e-19,  4.394600109762718e-22,  1.244331832825219e-24, -2.596644926990832e-26,  2.835836513477262e-01, -2.398393750317843e-03,  1.334900435194237e-05,
 -5.119718115928328e-08,  7.663919195417500e-11,  7.308909601073592e-13, -7.869394379863447e-15,  4.056178289348845e-17, -7.823094794318232e-20, -7.243141064160455e-22,
  8.825911239294609e-24, -5.023418174548558e-26,  3.762428971963147e-01, -3.074833069642591e-03,  1.557071805388514e-05, -4.454756997559796e-08, -6.674357801835338e-11,
  1.696670546240429e-12, -1.030811007639714e-14,  2.077362224729793e-17,  2.029723882523474e-19, -2.367670025143662e-21,  1.107309444321938e-23,  2.675358160790531e-27,
  4.811256445933210e-01, -3.769514897153185e-03,  1.681501511623711e-05, -2.619883770584963e-08, -2.642097871423555e-10,  2.465169089479763e-12, -7.542659326733969e-15,
 -3.774441026563960e-17,  5.551221981891291e-19, -2.493908298381776e-21, -4.896673781666075e-24,  1.419331090268006e-25,  5.976165735660411e-01, -4.445952076745573e-03,
  1.664176137359494e-05,  4.462778883114795e-09, -4.737469930854294e-10,  2.498734348768785e-12,  2.626390336795742e-15, -1.148245409384324e-16,  6.058150451457206e-19,
  1.138405202709220e-21, -3.490041613267348e-23,  1.754705214889947e-25,  7.248604114297601e-01, -5.060381357662938e-03,  1.465207865288442e-05,  4.532834910671860e-08,
 -6.236871644640164e-10,  1.285236982694361e-12,  1.844203720565847e-14, -1.492035688832760e-16, -5.960524151739529e-20,  7.395557541883518e-21, -3.753082010541859e-23,
 -1.683250331414508e-25,  8.616747713737307e-01, -5.561676535292760e-03,  1.056987578361737e-05,  9.049046362305079e-08, -6.223086565543128e-10, -1.309128316209637e-12,
  3.164504435179160e-14, -6.165355046536225e-17, -1.320990919282030e-18,  8.581972394350769e-21,  3.470588602127708e-23, -6.221314134835777e-25,  1.006434540718494e+00,
 -5.892383315643160e-03,  4.362393146872852e-06,  1.295800502337691e-07, -3.879007906905531e-10, -4.579491663375658e-12,  2.849437760123945e-14,  1.632968289690442e-16,
 -1.941001918182209e-18, -4.202990841460697e-21,  1.238411940315225e-22, -8.266970951508448e-26,  1.156922779286464e+00, -5.991922164266934e-03, -3.600078197315296e-06,
  1.484206162961719e-07,  9.453987682184881e-11, -6.712874867318531e-12, -1.093164803110838e-15,  3.684222941306348e-16, -1.965285811294317e-19, -2.230759734243905e-20,
  2.950496997271793e-23,  1.422749064029323e-24,  1.310147839752765e+00, -5.803562435194837e-03, -1.237125461016201e-05,  1.324349081009630e-07,  7.008457215476877e-10,
 -5.346901925144707e-12, -4.600770857511339e-14,  2.491337066413982e-16,  3.236169341610131e-18, -1.178156876955731e-20, -2.371274751128797e-22,  4.866983849878090e-25,
  1.462139449487440e+00, -5.287221963618105e-03, -2.032671132564794e-05,  7.420671980783010e-08,  1.132956719282372e-09,  4.008193811711341e-13, -6.432428014785762e-14,
 -2.722192995400028e-16,  3.247610800278002e-18,  3.177357690009194e-20, -1.107910226600592e-22, -2.823519264796191e-24,  1.607764615961630e+00, -4.439723704947218e-03,
 -2.531065292022323e-05, -1.561348049040476e-08,  1.030369766371974e-09,  7.220032902800934e-12, -1.712324120913261e-14, -5.906235670533337e-16, -2.694862369535569e-18,
  2.552431260124669e-20,  3.789076513143512e-22,  5.773663412347243e-25,  1.740653813866786e+00, -3.321166437443907e-03, -2.528489048363965e-05, -1.012929501726940e-07,
  3.030506436683921e-10,  8.287956432312417e-12,  5.577517603822515e-14, -4.989898910629719e-17, -4.520697817629410e-18, -3.962056541900863e-20, -2.934683112751260e-23,
  2.924170214968929e-24,  1.853393048560275e+00, -2.078374002407049e-03, -1.959422141540692e-05, -1.342631050559545e-07, -5.415540510318488e-10,  1.390395926544692e-12,
  4.988139637671310e-14,  4.970192954912344e-16,  2.421376513226788e-18, -7.722164799128403e-21, -2.863975560986033e-22, -3.000766565988224e-24,  1.938174683268719e+00,
 -9.447621974409303e-04, -1.032259152103400e-05, -9.362224865523028e-08, -7.188090465884824e-10, -4.451419312650542e-12, -1.757194083456647e-14,  4.177765568136067e-17,
  1.786298919349668e-18,  2.274696598471661e-20,  2.003650523372591e-22,  1.231949129567605e-24,  1.988019541796317e+00, -1.912435137126833e-04, -2.269500314333955e-06,
 -2.366043195500380e-08, -2.278222969681467e-10, -2.066895605393806e-12, -1.780881073926504e-14, -1.458999496758496e-16, -1.131420398809493e-18, -8.206682528465027e-21,
 -5.424903683870082e-23, -3.067018601639125e-25,  1.631253894617279e-03, -1.482391852902348e-05,  1.009601997093753e-07, -6.108463958353895e-10,  3.460456399179537e-12,
 -1.880458681240004e-14,  9.913894505172231e-17, -5.117355095410532e-19,  2.590129494075113e-21, -1.296720898605139e-23,  6.367916853996659e-26, -3.134905422754987e-28,
  1.467830895419073e-02, -1.329115166067145e-04,  8.978288676733671e-07, -5.353529650816282e-09,  2.964003942234027e-11, -1.557695724278185e-13,  7.837846965310058e-16,
 -3.799076645526680e-18,  1.767560320589596e-20, -7.927563073746486e-23,  3.348713440676503e-25, -1.359973174344049e-27,  4.075593730898473e-02, -3.663741163460280e-04,
  2.433744392469692e-06, -1.407661530356560e-08,  7.417160101373223e-11, -3.612217431696595e-13,  1.619253800226771e-15, -6.570813010226208e-18,  2.271329443028557e-20,
 -5.648161824936316e-23, -2.565340498220369e-26,  1.474102560493960e-27,  7.982818402800455e-02, -7.096610053641703e-04,  4.592380725972896e-06, -2.528697945619644e-08,
  1.223531934000331e-10, -5.143855720528504e-13,  1.746647459552542e-15, -3.475712823129317e-18, -1.121104195244807e-20,  1.842510596426946e-22, -1.405726825141879e-24,
  7.848292432760525e-27,  1.318333232358047e-01, -1.154127633747050e-03,  7.197793009743397e-06, -3.683167024251886e-08,  1.546105611006356e-10, -4.743794717107289e-13,
  3.709794634816111e-16,  8.533905085515611e-18, -8.439764806997408e-20,  5.115584606564436e-22, -2.257564411891124e-24,  5.389875767432554e-27,  1.966735848909601e-01,
 -1.687641177731760e-03,  1.001344561866972e-05, -4.602564903994152e-08,  1.497210440197328e-10, -1.273273829668804e-13, -2.738811174123019e-15,  2.615396008418389e-17,
 -1.448165194485247e-19,  4.689028586733137e-22,  2.863913500722851e-25, -1.792008358764840e-26,  2.741998002428025e-01, -2.294037288157548e-03,  1.274244573038517e-05,
 -4.986389245136814e-08,  8.945879493953602e-11,  5.553496080773951e-13, -6.772170704487614e-15,  3.770509649994093e-17, -9.846950268555920e-20, -4.138363462814597e-22,
  6.741636168607298e-24, -4.426314480502110e-26,  3.641892884531309e-01, -2.952421270182577e-03,  1.503081666180166e-05, -4.535723172120028e-08, -3.523352887080641e-11,
  1.456914086457992e-12, -9.647721900374556e-15,  2.599030351071061e-17,  1.256814399003454e-19, -1.928400193199673e-21,  1.075710831109743e-23, -1.565487329277964e-26,
  4.663145375360428e-01, -3.636320503980668e-03,  1.647685917839530e-05, -3.004192715969455e-08, -2.167922298067989e-10,  2.273386445861101e-12, -8.364507421153010e-15,
 -2.144330136053798e-17,  4.632110616262788e-19, -2.576917273329948e-21,  4.519635064597826e-25,  1.015947883628269e-25,  5.800991957224536e-01, -4.312728816491146e-03,
  1.665149237633181e-05, -2.715004021782705e-09, -4.233909461824808e-10,  2.525405913605258e-12, -3.129624410348817e-16, -9.503674620940451e-17,  6.235766450058174e-19,
 -9.845713506368010e-23, -2.687275776188639e-23,  1.852056585542725e-25,  7.048565274800392e-01, -4.941156507847397e-03,  1.513706714619789e-05,  3.557761955964404e-08,
 -5.938948383037516e-10,  1.677733276215673e-12,  1.427552095886637e-14, -1.471529530076127e-16,  1.781859141361108e-19,  5.785206455658139e-21, -4.206493407821774e-23,
 -4.194501807579068e-26,  8.396038192640785e-01, -5.472944979752788e-03,  1.159528755758225e-05,  8.036466058479062e-08, -6.410596871114093e-10, -5.748458093534232e-13,
  2.937499068480692e-14, -9.876682617237530e-17, -9.935161954065468e-19,  9.438307680159290e-21,  8.622156751848332e-24, -5.524025564454633e-25,  9.829444960117705e-01,
 -5.851376549294983e-03,  5.877217109991387e-06,  1.226795024399292e-07, -4.723183592570979e-10, -3.847883444925704e-12,  3.218111858636446e-14,  9.970675127625649e-17,
 -2.004931756985129e-18,  5.789712836767162e-22,  1.129582673063899e-22, -3.975922529453115e-25,  1.132908792205254e+00, -6.013583080919369e-03, -1.814380556437349e-06,
  1.488612540550787e-07, -3.915118063692661e-11, -6.616762503233581e-12,  9.016202889491699e-15,  3.496310537020276e-16, -9.638034979719477e-19, -1.993685449629846e-20,
  8.712840005892789e-23,  1.162404234944955e-24,  1.286745972925162e+00, -5.895993470908518e-03, -1.071847084046880e-05,  1.427355179193645e-07,  5.834894485060754e-10,
 -6.356132057396019e-12, -3.765865886889054e-14,  3.441309880007160e-16,  2.648704047218603e-18, -2.059342008602598e-20, -1.975871823982956e-22,  1.290816207939159e-24,
  1.440671409120004e+00, -5.445965515116796e-03, -1.932748055139380e-05,  9.231191249234272e-08,  1.124982931863591e-09, -1.221665366703537e-12, -7.032704241505941e-14,
 -1.510932358473123e-16,  4.281681669870898e-18,  2.485777571331379e-20, -2.339609089966975e-22, -2.679593464930464e-24,  1.589599973983961e+00, -4.642667314000495e-03,
 -2.539442205491326e-05,  1.999526183092342e-09,  1.169274937170034e-09,  6.601835383703503e-12, -3.470883731523033e-14, -6.592065880689628e-16, -1.500791308373182e-18,
  4.077033641820181e-20,  3.720950118846084e-22, -9.708559291447819e-25,  1.726957025176438e+00, -3.528212126536831e-03, -2.646560942117718e-05, -9.504612205737956e-08,
  4.819925601968810e-10,  9.592128443104151e-12,  5.213827989322409e-14, -2.173307093213407e-16, -5.933055031219496e-18, -3.776962860562927e-20,  1.331128812905622e-22,
  4.458142958768368e-24,  1.844755636403335e+00, -2.241717145360926e-03, -2.125622620581890e-05, -1.426355761524461e-07, -5.006035060860689e-10,  2.762961087414180e-12,
  6.482360354120659e-14,  5.675743595918919e-16,  1.903583047765751e-18, -2.200918306587532e-20, -4.321326134376137e-22, -3.568385942850128e-24,  1.934223072595885e+00,
 -1.032039226150197e-03, -1.151807494524116e-05, -1.058578101145658e-07, -8.119231437218155e-10, -4.851834724596420e-12, -1.546714640102548e-14,  1.136961590907772e-16,
  2.762780223892616e-18,  3.187186242361528e-20,  2.561455568374779e-22,  1.265121162028811e-24,  1.987216365718954e+00, -2.106004843909156e-04, -2.576739794094494e-06,
 -2.766098091411807e-08, -2.737875838357264e-10, -2.547709294302283e-12, -2.244844378283502e-14, -1.872786222399540e-16, -1.469319462202848e-18, -1.066249911669545e-20,
 -6.891125857225136e-23, -3.570208712772243e-25,  1.573528451530630e-03, -1.404464408079579e-05,  9.395024159193343e-08, -5.583632587293578e-10,  3.107044029472390e-12,
 -1.658824376505330e-14,  8.590390483464276e-17, -4.358546535236807e-19,  2.166016079897263e-21, -1.067623768219819e-23,  5.132597479793548e-26, -2.507443448814821e-28,
  1.416063235915714e-02, -1.259780233023739e-04,  8.363323623115175e-07, -4.903225146595109e-09,  2.670445945404536e-11, -1.381738619068860e-13,  6.849179533410606e-16,
 -3.276648102528389e-18,  1.504894765957025e-20, -6.701433878126028e-23,  2.796826956742067e-25, -1.155481378341618e-27,  3.932833870603254e-02, -3.475601997087426e-04,
  2.271713748486272e-06, -1.294561475990850e-08,  6.732130093553280e-11, -3.244871968169141e-13,  1.445140180472042e-15, -5.876603440043505e-18,  2.067541924364687e-20,
 -5.639444093322131e-23,  2.578028537011632e-26,  8.919098231068397e-28,  7.706114225895905e-02, -6.741032217371288e-04,  4.300350670424130e-06, -2.340938616835826e-08,
  1.124766095679701e-10, -4.736686545658533e-13,  1.645228511052869e-15, -3.738544809598590e-18, -5.511521808912696e-21,  1.344249546984889e-22, -1.097580705098580e-24,
  6.199591360727058e-27,  1.273292366062581e-01, -1.098271873300197e-03,  6.770344266494773e-06, -3.443324225906041e-08,  1.452298543889175e-10, -4.628973493346117e-13,
  5.747656908771701e-16,  6.110882695800064e-18, -6.754849725319939e-20,  4.261357910053913e-22, -2.011447021837444e-24,  5.685107854552116e-27,  1.900797945705554e-01,
 -1.609702335354604e-03,  9.475416103679502e-06, -4.365381636191432e-08,  1.465738588886812e-10, -1.847791364523585e-13, -2.068832977777743e-15,  2.179070591590580e-17,
 -1.279020867195793e-19,  4.665117590302558e-22, -3.617382406603019e-25, -1.184655770254621e-26,  2.652237759609987e-01, -2.194466067846818e-03,  1.215300595538982e-05,
 -4.835217431791400e-08,  9.902408915644603e-11,  4.051183606118867e-13, -5.762432447671924e-15,  3.436405659513743e-17, -1.089650189129161e-19, -1.811420233857378e-22,
  4.942693191345100e-24, -3.746738279271588e-26,  3.526166385779329e-01, -2.834359333497875e-03,  1.448406896770334e-05, -4.570018774727906e-08, -8.349667166987628e-12,
  1.234494751972347e-12, -8.873541493791549e-15,  2.898281872992809e-17,  6.380374227631829e-20, -1.515575283162617e-21,  9.804882626257424e-24, -2.656859615284168e-26,
  4.520305232977999e-01, -3.506003226755299e-03,  1.609700861416164e-05, -3.315794342342185e-08, -1.733723222215449e-10,  2.067022899953251e-12, -8.771275358686543e-15,
 -8.093288012941990e-18,  3.717433939349728e-19, -2.480496799347720e-21,  4.104673055828018e-24,  6.532418545094253e-26,  5.631143404643737e-01, -4.179758528372742e-03,
  1.657992986851519e-05, -9.086466611615693e-09, -3.731618684797756e-10,  2.488207022261590e-12, -2.696549076720184e-15, -7.533062641556840e-17,  6.026304190465359e-19,
 -1.012549253935339e-21, -1.891776742708098e-23,  1.735372660828883e-25,  6.853365738725687e-01, -4.818511120137918e-03,  1.550814848550956e-05,  2.636096779629685e-08,
 -5.572436865602426e-10,  1.971727482055559e-12,  1.026404829682758e-14, -1.384451839554792e-16,  3.560069866065762e-19,  4.096562642411047e-21, -4.166174697081537e-23,
  5.486167936853613e-26,  8.179034246487844e-01, -5.376500173636269e-03,  1.249786372045295e-05,  7.005303438997506e-08, -6.457478382768779e-10,  9.369095237281440e-14,
  2.621571298884651e-14, -1.251019357608291e-16, -6.530908377229962e-19,  9.330173748763691e-21, -1.313916575373220e-23, -4.307423119142149e-25,  9.596421601976820e-01,
 -5.798604238851487e-03,  7.301627187479090e-06,  1.145495308401674e-07, -5.413637006470364e-10, -3.049235456870505e-12,  3.408382887684551e-14,  3.671585987548748e-17,
 -1.907632125990453e-18,  4.676848007475231e-21,  9.039526898657329e-23, -6.088454320520266e-25,  1.108836715069969e+00, -6.020973399149531e-03, -3.612407428814926e-08,
  1.471911678411849e-07, -1.685503093412119e-10, -6.287019491147911e-12,  1.827153206311277e-14,  3.080715994879997e-16, -1.607516005393867e-18, -1.554546105182009e-20,
  1.293159415706035e-22,  7.348379996826866e-25,  1.263001562348435e+00, -5.974741187074242e-03, -8.953974409551558e-06,  1.510087002313053e-07,  4.481556213175364e-10,
 -7.135470722010174e-12, -2.695799506884373e-14,  4.156255556694742e-16,  1.780589684629360e-18, -2.716440602167821e-20, -1.265851981195263e-22,  1.889555627735508e-24,
  1.418585751863441e+00, -5.595850851088119e-03, -1.811284583854052e-05,  1.100233165329370e-07,  1.083411726697899e-09, -2.944042397005612e-12, -7.251909616248616e-14,
 -1.788530505857918e-18,  4.981207077680391e-18,  1.331579744729155e-20, -3.377508877106707e-22, -1.941146895041103e-24,  1.570623607761925e+00, -4.845398961153471e-03,
 -2.525398408794012e-05,  2.171260358927404e-08,  1.291464517167864e-09,  5.543359233894625e-12, -5.359849013328788e-14, -6.809916556340408e-16,  2.195899028593395e-19,
  5.425079116669036e-20,  2.879092575060428e-22, -2.888896463047553e-24,  1.712413708264011e+00, -3.744353103932061e-03, -2.755334717982867e-05, -8.573398284625486e-08,
  6.857393676316448e-10,  1.074776045829890e-11,  4.320027597330896e-14, -4.275071677028083e-16, -7.145832612781450e-18, -2.810923945209624e-20,  3.592700387863085e-22,
  5.733719177092755e-24,  1.835437641929100e+00, -2.418744850637570e-03, -2.301379864809331e-05, -1.501131119572167e-07, -4.284673525605309e-10,  4.515456832115752e-12,
  8.142379027143431e-14,  6.121640292389479e-16,  7.616484254396558e-19, -4.249342359473661e-20, -5.921492390129379e-22, -3.568452662750244e-24,  1.929902259639441e+00,
 -1.129493343366057e-03, -1.286957741134794e-05, -1.196437667135301e-07, -9.123576946992879e-10, -5.173720586082585e-12, -1.085872298247322e-14,  2.225466376726013e-16,
  4.107513186217930e-18,  4.317024184494742e-20,  3.064075905590980e-22,  9.344691312853343e-25,  1.986330523219251e+00, -2.326206720078388e-04, -2.936736595372962e-06,
 -3.248037172886734e-08, -3.305831796166403e-10, -3.155085090838109e-12, -2.841217955346175e-14, -2.410017483842910e-16, -1.906656230251971e-18, -1.374177968007168e-20,
 -8.517610247547620e-23, -3.730616299646864e-25,  1.518811804219633e-03, -1.331902297489927e-05,  8.753756232333095e-08, -5.111966674053771e-10,  2.794946594392473e-12,
 -1.466550638362758e-14,  7.461527448315530e-17, -3.723160749039439e-19,  1.816106189942473e-21, -8.828801373900833e-24,  4.139342462549834e-26, -2.029884613399259e-28,
  1.366973892337073e-02, -1.195156599705802e-04,  7.799689040683460e-07, -4.497198722699278e-09,  2.409820313544371e-11, -1.227845221692702e-13,  5.995658865029664e-16,
 -2.831619229125166e-18,  1.282601861681411e-20, -5.679303509217214e-23,  2.325611584417886e-25, -9.937409341833589e-28,  3.797348667664909e-02, -3.299900490851572e-04,
  2.122621009302870e-06, -1.191856205778019e-08,  6.116544095930357e-11, -2.917054759717690e-13,  1.289554486930685e-15, -5.247205912573689e-18,  1.867195919092368e-20,
 -5.471732905140919e-23,  5.482815036340230e-26,  4.449364915030210e-28,  7.443179812851554e-02, -6.407941794879581e-04,  4.029930021064562e-06, -2.168343791713475e-08,
  1.033895272130999e-10, -4.354550697248748e-13,  1.538750152487340e-15, -3.845450765935106e-18, -1.400720906393287e-21,  9.554305410057114e-23, -8.569185635916057e-25,
  4.769696495237236e-27,  1.230419125419929e-01, -1.045723110739245e-03,  6.370784489730107e-06, -3.218282471292310e-08,  1.361225064723302e-10, -4.472803396464566e-13,
  7.178070408287361e-16,  4.179743777903770e-18, -5.359593416135382e-20,  3.506329843315190e-22, -1.765798195432781e-24,  5.397838115198323e-27,  1.837893300899545e-01,
 -1.535954819015554e-03,  8.965511252030018e-06, -4.134069771544423e-08,  1.424288527424563e-10, -2.275565501147141e-13, -1.513493976185198e-15,  1.796282346462918e-17,
 -1.114808338891989e-19,  4.430105747714897e-22, -7.818278028819226e-25, -7.519860295635046e-27,  2.566367237972061e-01, -2.099535421462965e-03,  1.158253009040771e-05,
 -4.671016417302504e-08,  1.058193530716440e-10,  2.779675484547431e-13, -4.849781575621093e-15,  3.080789050537046e-17, -1.123065837333741e-19, -1.442339047521849e-23,
  3.441303302256439e-24, -3.087981443815267e-26,  3.415074723078005e-01, -2.720680859237669e-03,  1.393564319392197e-05, -4.564755491202274e-08,  1.427729904525327e-11,
  1.031450930731368e-12, -8.041114982417165e-15,  3.022485129673586e-17,  1.600251709364760e-20, -1.148702928070099e-21,  8.498938707715809e-24, -3.206429641784534e-26,
  4.382614799982865e-01, -3.378862829121344e-03,  1.568379658080784e-05, -3.561266856654170e-08, -1.341487243386746e-10,  1.855055920970352e-12, -8.844515160522521e-15,
  2.410474565366620e-18,  2.860073845895377e-19, -2.268200689892514e-21,  6.289514713529936e-24,  3.503608001836238e-26,  5.466597563165947e-01, -4.047652984023540e-03,
  1.643669769005026e-05, -1.466313810628969e-08, -3.242046484886452e-10,  2.400319325507963e-12, -4.542264699562580e-15, -5.676117492528552e-17,  5.543387356250954e-19,
 -1.623215297338635e-21, -1.179943452876144e-23,  1.483916691089329e-25,  6.663124532727822e-01, -4.693329098543259e-03,  1.577232585873370e-05,  1.777263632301163e-08,
 -5.156525691220544e-10,  2.172959291169025e-12,  6.566985646233989e-15, -1.250089398818133e-16,  4.742646153120371e-19,  2.499427118037712e-21, -3.773460001277711e-23,
  1.181071913513190e-25,  7.966024662973423e-01, -5.273330003195863e-03,  1.327667756401667e-05,  5.976901529383287e-08, -6.378768832864589e-10,  6.787780971418949e-13,
  2.246984321620249e-14, -1.407626974749765e-16, -3.308554433034320e-19,  8.467113457661376e-21, -2.896785377179492e-23, -2.875517629250775e-25,  9.365730614125584e-01,
 -5.734844439638655e-03,  8.622382778115538e-06,  1.054445069283524e-07, -5.941199223921846e-10, -2.225605853748081e-12,  3.428722513726777e-14, -2.099136446645448e-17,
 -1.680979063766993e-18,  7.721009602683715e-21,  6.113764634366394e-23, -7.017300702275491e-25,  1.084763352906649e+00, -6.014252448730765e-03,  1.709924604281357e-06,
  1.435150878534258e-07, -2.892389261055443e-10, -5.751283447359348e-12,  2.610067903736760e-14,  2.487298081875633e-16, -2.067573275403563e-18, -9.871726482115697e-21,
  1.507106007039913e-22,  2.338909443645713e-25,  1.238970968199846e+00, -6.039013720640766e-03, -7.103659284155604e-06,  1.570064223423482e-07,  2.999482541701803e-10,
 -7.637308184567908e-12, -1.467578064966205e-14,  4.561498511861553e-16,  7.325607157845965e-19, -3.046111374219756e-20, -3.635855643123518e-23,  2.148423099431837e-24,
  1.395921314055530e+00, -5.735182898690983e-03, -1.669080715897812e-05,  1.267926042326418e-07,  1.007216855892681e-09, -4.666743672036399e-12, -7.028499112472652e-14,
  1.625250970968987e-16,  5.199832575507178e-18, -1.564075935264189e-21, -3.970648981675557e-22, -6.849825970689523e-25,  1.550840104749962e+00, -5.046029410762206e-03,
 -2.486603766180261e-05,  4.318663599329861e-08,  1.387935604365815e-09,  4.030853578524131e-12, -7.226003868725550e-14, -6.407768660000610e-16,  2.344035885474247e-18,
  6.265216358372850e-20,  1.184439572473792e-22, -4.762697486554715e-24,  1.696989211807244e+00, -3.968691910982837e-03, -2.850906025821569e-05, -7.299072378081626e-08,
  9.099559489601276e-10,  1.161426196452141e-11,  2.789931730722185e-14, -6.690838764891901e-16, -7.836277524999606e-18, -8.487466892271721e-21,  6.248096106672592e-22,
  6.132555532417323e-24,  1.825382878573576e+00, -2.610169629932861e-03, -2.485294872179167e-05, -1.561340822969179e-07, -3.172205018890222e-10,  6.676484696381393e-12,
  9.864131325731181e-14,  6.071941100266999e-16, -1.230355710639933e-18, -6.908619551619862e-20, -7.291293767075410e-22, -2.408784003838309e-24,  1.925168919285943e+00,
 -1.238448969132186e-03, -1.439634299944338e-05, -1.350810397998255e-07, -1.017850295482183e-09, -5.343179159251969e-12, -2.536347505091725e-15,  3.812856440361652e-16,
  5.890058788572701e-18,  5.600498988819801e-20,  3.276252113387692e-22, -1.326207369280044e-25,  1.985350450652983e+00, -2.577685895915500e-04, -3.360445991357414e-06,
 -3.831399016652407e-08, -4.010880559701626e-10, -3.925329857377689e-12, -3.609365226797541e-14, -3.106190679478486e-16, -2.466540331962686e-18, -1.746413181613049e-20,
 -1.003907078090134e-22, -2.955954809959632e-25,  1.466898507015699e-03, -1.264252136743353e-05,  8.166214371997725e-08, -4.687301345512246e-10,  2.518732453144636e-12,
 -1.299355363332813e-14,  6.495843898376192e-17, -3.189832944104613e-19,  1.526023238423140e-21, -7.340546506570453e-24,  3.327261625488261e-26, -1.682096143150729e-28,
  1.320382301273973e-02, -1.134854012489485e-04,  7.282373699796480e-07, -4.130517308348989e-09,  2.178021829543930e-11, -1.093018131203439e-13,  5.257315567047531e-16,
 -2.452187280035743e-18,  1.093872052361991e-20, -4.832795970581075e-23,  1.915149429556247e-25, -8.811048313511462e-28,  3.668660552215799e-02, -3.135649676999355e-04,
  1.985282934788912e-06, -1.098495506136752e-08,  5.562926512940856e-11, -2.624535158323709e-13,  1.150704834242935e-15, -4.680765776849556e-18,  1.674527670628596e-20,
 -5.224781482018259e-23,  6.585035324909106e-26,  5.942924922815574e-29,  7.193149119474518e-02, -6.095680714254637e-04,  3.779373159843086e-06, -2.009690842404195e-08,
  9.504099085277585e-11, -3.998192511698547e-13,  1.430922184851877e-15, -3.841469312342368e-18,  1.468879193283485e-21,  6.507543025616299e-23, -6.759248901335473e-25,
  3.468122244393780e-27,  1.189585581387712e-01, -9.962652586868244e-04,  5.997366281435587e-06, -3.007545699422976e-08,  1.273576991827398e-10, -4.288311922644994e-13,
  8.126319628979263e-16,  2.653460311015660e-18, -4.218895980705303e-20,  2.845603935269956e-22, -1.543392581050835e-24,  4.633348920428288e-27,  1.777858713224034e-01,
 -1.466176699729798e-03,  8.482939919183869e-06, -3.910005477566186e-08,  1.375532012148946e-10, -2.582335059927147e-13, -1.058127256052456e-15,  1.464398512154021e-17,
 -9.616654556191480e-20,  4.060385600675971e-22, -1.046837737298417e-24, -4.782959295033398e-27,  2.484203937619854e-01, -2.009088102906213e-03,  1.103233053512208e-05,
 -4.497861784372752e-08,  1.102825311898292e-10,  1.715185474602117e-13, -4.037377509639815e-15,  2.722978741132181e-17, -1.106594733226275e-19,  9.780169893149414e-23,
  2.210946394963055e-24, -2.526213781848049e-26,  3.308442574132199e-01, -2.611381411784497e-03,  1.338989073532308e-05, -4.526428327753977e-08,  3.304514525568254e-11,
  8.486416523023233e-13, -7.193415257478697e-15,  3.013807996043209e-17, -1.957911800537005e-20, -8.377529178944952e-22,  7.033698630501918e-24, -3.413685278515943e-26,
  4.249942149745412e-01, -3.255135608078634e-03,  1.524475336356760e-05, -3.747373185083572e-08, -9.915979132778203e-11,  1.644558031928292e-12, -8.660804691600360e-15,
  1.030733917416829e-17,  2.091828881345373e-19, -1.993308259363618e-21,  7.279691650530050e-24,  1.093236348359638e-26,  5.307308974091254e-01, -3.916947809332106e-03,
  1.623118001952182e-05, -1.947278952754287e-08, -2.774070203661806e-10,  2.274180761767899e-12, -5.892596797816852e-15, -4.003616739402955e-17,  4.888984116663037e-19,
 -1.973744505456382e-21, -5.961890760887725e-24,  1.162116268813771e-25,  6.477926512197653e-01, -4.566434309874779e-03,  1.593755356471605e-05,  9.877273786169348e-09,
 -4.708916482325833e-10,  2.290351875047467e-12,  3.290718355024100e-15, -1.086732242488119e-16,  5.384350766097018e-19,  1.105356893676912e-21, -3.174227376308639e-23,
  1.492978734307496e-25,  7.757258722178902e-01, -5.164419957082806e-03,  1.393320876727995e-05,  4.969953227128215e-08, -6.192328275688551e-10,  1.169834783300803e-12,
  1.842436314955456e-14, -1.467188728128470e-16, -4.956286723630503e-20,  7.097186198477379e-21, -3.851863172796392e-23, -1.492058931960802e-25,  9.137794233230049e-01,
 -5.660968735563971e-03,  9.829356476289527e-06,  9.562689602241468e-08, -6.304809815016191e-10, -1.415571765226424e-12,  3.299118796851037e-14, -6.992410491673244e-17,
 -1.366482065166411e-18,  9.546313648897593e-21,  3.023806738851577e-23, -6.870365382519588e-25,  1.060744486750967e+00, -5.993771510297029e-03,  3.400659261622588e-06,
  1.380033245752616e-07, -3.974761925147417e-10, -5.049056719530849e-12,  3.209378361263850e-14,  1.780562043385994e-16, -2.313291921547917e-18, -3.782577124936941e-21,
  1.502650980445883e-22, -2.429140931955862e-25,  1.214713287001643e+00, -6.088236812050374e-03, -5.195877845901349e-06,  1.605688650469819e-07,  1.447238195252957e-10,
 -7.834630343329938e-12, -1.741183194867005e-15,  4.619502995021860e-16, -3.674849136864367e-19, -3.003582802462052e-20,  5.664701686134995e-23,  2.015144927609994e-24,
  1.372723542464175e+00, -5.862357027829800e-03, -1.507597498635034e-05,  1.420716270795629e-07,  8.974787427624563e-10, -6.280335030627761e-12, -6.343529567658724e-14,
  3.249207402760150e-16,  4.854376868729301e-18, -1.760763267046066e-20, -3.939194397160629e-22,  8.460390620828972e-25,  1.530261952926522e+00, -5.242501749906980e-03,
 -2.421221731696154e-05,  6.593839437002532e-08,  1.449809718653807e-09,  2.091893748606190e-12, -8.880857956999694e-14, -5.292028180543318e-16,  4.630212244047143e-18,
  6.276248428088677e-20, -1.221879867883456e-22, -6.024887984464742e-24,  1.680653124858951e+00, -4.200002583431921e-03, -2.928982854858558e-05, -5.654364726876739e-08,
  1.147272569453851e-09,  1.203060044472954e-11,  5.645781958383246e-15, -9.193923981850353e-16, -7.628633010890567e-18,  2.168908178049859e-20,  8.754041080777522e-22,
  4.940647057219074e-24,  1.814532579338223e+00, -2.816562927423137e-03, -2.675217220336495e-05, -1.600070754997397e-07, -1.586732687040850e-10,  9.240940739165460e-12,
  1.146765199670602e-13,  5.222338503549633e-16, -4.261568766671002e-18, -9.963749735884278e-20, -7.763860548988898e-22,  6.288140231320936e-25,  1.919974114197011e+00,
 -1.360388581775745e-03, -1.611855542290358e-05, -1.522208228273216e-07, -1.124339540642823e-09, -5.252688561964873e-12,  1.109930430694824e-14,  6.045115534213478e-16,
  8.135621220538668e-18,  6.841107899113997e-20,  2.753874158419254e-22, -2.519690661364854e-24,  1.984262535007429e+00, -2.866066126479555e-04, -3.861469986919193e-06,
 -4.540964323491216e-08, -4.890102763467962e-10, -4.905473732572207e-12, -4.599616831832969e-14, -4.004046709397465e-16, -3.170113159062226e-18, -2.167547339424652e-20,
 -1.080723568776169e-22, -3.060530582850516e-27,  1.417600334184760e-03, -1.201105738346235e-05,  7.627087099485887e-08, -4.304276185614962e-10,  2.273755466198781e-12,
 -1.153644672681137e-14,  5.667258788461243e-17, -2.741358557652457e-19,  1.284005330591124e-21, -6.150257563895162e-24,  2.640091319586727e-26, -1.464081370067912e-28,
  1.276122743638381e-02, -1.078520046983738e-04,  6.806920826121431e-07, -3.798859205048236e-09,  1.971499383345057e-11, -9.747019284727842e-14,  4.617194168259115e-16,
 -2.128581207040305e-18,  9.327646563526583e-21, -4.142347626217717e-23,  1.540462504677808e-25, -8.354023178739882e-28,  3.546329616942692e-02, -2.981952403019114e-04,
  1.858635405579846e-06, -1.013542235631475e-08,  5.064605362306880e-11, -2.363505059869883e-13,  1.026866131546474e-15, -4.174505076407088e-18,  1.491134399018124e-20,
 -4.967822506539206e-23,  5.960067169660786e-26, -3.585190189396234e-28,  6.955219722411329e-02, -5.802724823851344e-04,  3.547076257748634e-06, -1.863839417733781e-08,
  8.737935068069546e-11, -3.667605558751236e-13,  1.324335704463153e-15, -3.761924130008272e-18,  3.358238441485893e-21,  4.070836583043060e-23, -5.520782547323087e-25,
  2.139164777952787e-27,  1.150672172845866e-01, -9.496959539010047e-04,  5.648407603267830e-06, -2.810526449257506e-08,  1.189813752760279e-10, -4.085799686195391e-13,
  8.694855052053630e-16,  1.455784704599753e-18, -3.300990427834742e-20,  2.265632624785121e-22, -1.365946636956438e-24,  3.326945765694462e-27,  1.720539722504796e-01,
 -1.400152969346896e-03,  8.026769831779586e-06, -3.694176739053796e-08,  1.321660521827580e-10, -2.790427114639433e-13, -6.890406586668096e-16,  1.179207011215622e-17,
 -8.234925426043651e-20,  3.604096855084891e-22, -1.226404322479170e-24, -3.661901322424746e-27,  2.405571829146292e-01, -1.922958207671810e-03,  1.050327108342359e-05,
 -4.319166704161745e-08,  1.128036365490681e-10,  8.337436233972512e-14, -3.323880104470081e-15,  2.375999327364664e-17, -1.058024647020765e-19,  1.653153132153368e-22,
  1.193471629364016e-24, -2.133062100238730e-26,  3.206095442472928e-01, -2.506424752808938e-03,  1.285042216858562e-05, -4.460887320019532e-08,  4.835943449195643e-11,
  6.860292842157345e-13, -6.362484337553565e-15,  2.908035003329503e-17, -4.503811296471881e-20, -5.866734332771598e-22,  5.515632025411687e-24, -3.480934868639885e-26,
  4.122147057189858e-01, -3.135000864868757e-03,  1.478659836551329e-05, -3.880834201110159e-08, -6.832021155455353e-11,  1.440854111049113e-12, -8.288868701870388e-15,
  1.590982556817203e-17,  1.427266165163749e-19, -1.698421459781359e-21,  7.325714290491867e-24, -8.181901906704263e-27,  5.153212230882249e-01, -3.788105112716173e-03,
  1.597235057349064e-05, -2.355546707136423e-08, -2.334195776899431e-10,  2.121007079319454e-12, -6.805538098042151e-15, -2.556492684580382e-17,  4.146907568224206e-19,
 -2.120150255572589e-21, -1.613889940786397e-24,  8.115597836814745e-26,  6.297824893066083e-01, -4.438584350522502e-03,  1.601239804252584e-05,  2.712755657944712e-09,
 -4.245311217665321e-10,  2.334790223233121e-12,  4.933975789125197e-16, -9.103860952326543e-17,  5.569860792289062e-19, -3.008702620818183e-23, -2.500523472370852e-23,
  1.527639250251018e-25,  7.552946656413972e-01, -5.050735213422004e-03,  1.447100290072571e-05,  4.000160889379976e-08, -5.917470071954086e-10,  1.562767910382974e-12,
  1.433025687265674e-14, -1.445249245725652e-16,  1.769503305682828e-19,  5.460971172726605e-21, -4.246039647679325e-23, -3.520645124035258e-26,  8.912998411346041e-01,
 -5.577917159390882e-03,  1.091555610789831e-05,  8.535497890694283e-08, -6.510572831167896e-10, -6.518944991133816e-13,  3.047412171395465e-14, -1.079772648114044e-16,
 -1.008128193017561e-18,  1.017420279391603e-20,  1.839163914526930e-24, -5.939196913451439e-25,  1.036834137113498e+00, -5.960057585016422e-03,  5.015348895365065e-06,
  1.308792501060715e-07, -4.903946031213348e-10, -4.227428895719103e-12,  3.603064442315524e-14,  1.029838914508194e-16, -2.344957488875877e-18,  1.894308373640641e-21,
  1.308331361992358e-22, -6.193175687102192e-25,  1.190289448822870e+00, -6.122069066113232e-03, -3.260324258298934e-06,  1.616329960528031e-07, -1.135000489526976e-11,
 -7.723511567757251e-12,  1.087032789929567e-14,  4.334941545950717e-16, -1.387672371238147e-18, -2.611671060816942e-20,  1.357734115610552e-22,  1.531665857697169e-24,
  1.349044027586013e+00, -5.975911342325425e-03, -1.328936128031805e-05,  1.553471142344081e-07,  7.574723358970449e-10, -7.676747453693442e-12, -5.227917334669055e-14,
  4.671775256025162e-16,  3.949937545392676e-18, -3.217413848002141e-20, -3.238000378786203e-22,  2.296179859088683e-24,  1.508910121710183e+00, -5.432637693674429e-03,
 -2.328078231210488e-05,  8.934953599541235e-08,  1.469228526488032e-09, -1.985404845085274e-13, -1.012220305775901e-13, -3.463561881781097e-16,  6.736457257395332e-18,
  5.244456968458175e-20, -3.944580425287861e-22, -6.122649717415373e-24,  1.663380644618160e+00, -4.436704959837094e-03, -2.985027518990652e-05, -3.626426520082494e-08,
  1.387015793235332e-09,  1.183057102701940e-11, -2.334702620856531e-14, -1.143877970375337e-15, -6.172262174079609e-18,  6.023951451732196e-20,  1.027940052895766e-21,
  1.620868907420480e-24,  1.802826091176252e+00, -3.038288762630806e-03, -2.868089350853942e-05, -1.609131092021293e-07,  5.475786080080607e-11,  1.214971215100729e-11,
  1.268086258819757e-13,  3.226148003111431e-16, -8.388168462341656e-18, -1.287101823806097e-19, -6.371948696207367e-22,  6.128321637015777e-24,  1.914262652083802e+00,
 -1.496957304238345e-03, -1.805654472005127e-05, -1.710298980946239e-07, -1.225196495392851e-09, -4.751425877013837e-12,  3.205421304375468e-14,  9.061003466126218e-16,
  1.075989337908568e-17,  7.606728011555876e-20,  7.471832772126619e-23, -7.024386237890840e-24,  1.983050675778665e+00, -3.198189120086980e-04, -4.456773525278082e-06,
 -5.408269007003699e-08, -5.991293600425011e-10, -6.156131546024340e-12, -5.875092052777223e-14, -5.151582324531097e-16, -4.026751594345446e-18, -2.582582745732412e-20,
 -9.405050436068663e-23,  7.446687105682580e-25,  1.370744576680283e-03, -1.142094954760288e-05,  7.131663849173301e-08, -3.958219903160134e-10,  2.056029365524902e-12,
 -1.026396890507475e-14,  4.954011430459830e-17, -2.363988090512109e-19,  1.080082756274253e-21, -5.219941823441577e-24,  2.016138551988636e-26, -1.400967116114197e-28,
  1.234042915764756e-02, -1.025835951422033e-04,  6.369359775895470e-07, -3.498432126965864e-09,  1.787174363135329e-11, -8.707173853598178e-14,  4.060818058570385e-16,
 -1.852839398768270e-18,  7.938401069385397e-21, -3.600449353109026e-23,  1.164941655804671e-25, -8.923440890524866e-28,  3.429950206777040e-02, -2.837992323503864e-04,
  1.741720598302608e-06, -9.361601338092504e-09,  4.615629530518102e-11, -2.130560700886529e-13,  9.163944710789711e-16, -3.725536411728431e-18,  1.316065984608473e-20,
 -4.776423510497908e-23,  3.185946952257160e-26, -9.433163055630568e-28,  6.728647682933940e-02, -5.527672944934057e-04,  3.331567380018712e-06, -1.729731490079352e-08,
  8.035351605168414e-11, -3.362271562569723e-13,  1.220697186320960e-15, -3.635116381773923e-18,  4.444946913644045e-21,  2.006518195945185e-23, -4.917564043775663e-25,
  5.307652754523937e-28,  1.113567168699403e-01, -9.058259964512933e-04,  5.322300684212435e-06, -2.626578966959399e-08,  1.110211678843939e-10, -3.873353707451305e-13,
  8.966115225707556e-16,  5.196776860253001e-19, -2.580673574501008e-20,  1.743008746947388e-22, -1.262592539143132e-24,  1.202499965624591e-27,  1.665790313019421e-01,
 -1.337676495807580e-03,  7.595969779572391e-06, -3.487254884512321e-08,  1.264450832836025e-10, -2.919036842629201e-13, -3.938739567429782e-16,  9.354704995114696e-18,
 -7.029681775680109e-20,  3.080498505411768e-22, -1.397416453169185e-24, -4.471557188374911e-27,  2.330301633041241e-01, -1.840974456768869e-03,  9.995841816677457e-06,
 -4.137758391315985e-08,  1.137253273898973e-10,  1.120779965476801e-14, -2.705049846895808e-15,  2.047695503126114e-17, -9.921197504019431e-20,  1.949039991976239e-22,
  2.959443867773125e-25, -1.997770880161604e-26,  3.107860815949770e-01, -2.405748457384407e-03,  1.232018484895660e-05, -4.373338056305903e-08,  6.061805898895975e-11,
  5.429197327129587e-13, -5.571300532896164e-15,  2.734077582438115e-17, -6.255870763890985e-20, -3.969759727825617e-22,  3.958814311266845e-24, -3.627830319214977e-26,
  3.999083149643766e-01, -3.018587340796553e-03,  1.431525590726195e-05, -3.968157738008297e-08, -4.145393951350291e-11,  1.247728565736028e-12, -7.788246260272810e-15,
  1.955433839148288e-17,  8.672593487449585e-20, -1.417541235630818e-21,  6.598367698637063e-24, -2.469984725304017e-26,  5.004224845744437e-01, -3.661517295500441e-03,
  1.566864720522700e-05, -2.695991090963814e-08, -1.926832971313768e-10,  1.950513062455025e-12, -7.347100330821762e-15, -1.352213762287555e-17,  3.379673988430626e-19,
 -2.123907857765929e-21,  1.160828659430832e-24,  4.473222339118976e-26,  6.122843981017916e-01, -4.310466877470556e-03,  1.600573688736258e-05, -3.706362994457189e-09,
 -3.779129968379456e-10,  2.318049273207012e-12, -1.807617751477757e-15, -7.341250140192492e-17,  5.394832915493935e-19, -9.001012822159700e-22, -1.863879195339025e-23,
  1.331428404005853e-25,  7.353260770020014e-01, -4.933205578138432e-03,  1.489530272576002e-05,  3.080102414461513e-08, -5.573761350061068e-10,  1.858943442248791e-12,
  1.039004083989453e-14, -1.360462260410832e-16,  3.428394805112874e-19,  3.757256848982727e-21, -4.216239643648815e-23,  4.198188821282015e-26,  8.691690573794686e-01,
 -5.486673497178806e-03,  1.187700987078807e-05,  7.487240831301485e-08, -6.570436821852174e-10,  3.989638670056553e-14,  2.705399565908651e-14, -1.344117280083320e-16,
 -6.464913481618304e-19,  9.762749565515644e-21, -2.143840302428270e-23, -4.609032797428517e-25,  1.013083902785192e+00, -5.913792093369062e-03,  6.536186419142728e-06,
  1.224043607966521e-07, -5.661056870952910e-10, -3.336472499052397e-12,  3.788077187130890e-14,  2.998809350697342e-17, -2.189879880569963e-18,  6.502317634068572e-21,
  9.784223667668297e-23, -8.562048859431326e-25,  1.165761271782175e+00, -6.140407991130046e-03, -1.326858472267298e-06,  1.602338348858170e-07, -1.622576657862733e-10,
 -7.322815705994315e-12,  2.225332294125480e-14,  3.752137555656370e-16, -2.215663495798789e-18, -1.953690376097799e-20,  1.879793793351319e-22,  8.150435093228117e-25,
  1.324939833772265e+00, -6.074575627100509e-03, -1.135775330659801e-05,  1.661749099291092e-07,  5.925189101442805e-10, -8.761347315131075e-12, -3.761932998596079e-14,
  5.727621501564993e-16,  2.586036849790321e-18, -4.276688558783561e-20, -1.985009644439314e-22,  3.299145524769020e-24,  1.486814431671109e+00, -5.614196718135021e-03,
 -2.206810844822026e-05,  1.126905945206979e-07,  1.440311749628919e-09, -2.718263003499658e-12, -1.076429302346129e-13, -1.041380709184666e-16,  8.278022299394116e-18,
  3.157373543767168e-20, -6.390635081329463e-22, -4.748951728552171e-24,  1.645154020297242e+00, -4.676852848715589e-03, -3.014461395664618e-05, -1.222082846310551e-08,
  1.615323808131506e-09,  1.086586994121698e-11, -5.775779332151634e-14, -1.298701899986270e-15, -3.259386114081344e-18,  1.013223985999105e-19,  9.866223169150758e-22,
 -3.798939527503179e-24,  1.790201859177363e+00, -3.275425291081370e-03, -3.059803265939398e-05, -1.579252018832026e-07,  3.287423463900089e-10,  1.526674422015681e-11,
  1.313559652912208e-13, -2.420828773038362e-17, -1.339601013285232e-17, -1.466300987307347e-19, -2.011738969486142e-22,  1.401854958356653e-23,  1.907972440279574e+00,
 -1.649959255376251e-03, -2.022949757938011e-05, -1.913421129214462e-07, -1.310265127020131e-09, -3.636233362460066e-12,  6.265719352288767e-14,  1.294091145853908e-15,
  1.346019511649423e-17,  7.091435279301618e-20, -3.867578754564486e-22, -1.450064451798830e-23,  1.981695738409230e+00, -3.582419130293463e-04, -5.167607490804855e-06,
 -6.473552959063056e-08, -7.375995764320987e-10, -7.754690578813288e-12, -7.512380213481000e-14, -6.595295003418866e-16, -5.012797217902049e-18, -2.853191100981932e-20,
 -2.924349931348300e-23,  2.406704987693263e-24,  1.326172531696157e-03, -1.086887184764098e-05,  6.675758248019327e-08, -3.645053376056112e-10,  1.862122929417279e-12,
 -9.150698954184517e-15,  4.337761373261493e-17, -2.046993715128161e-19,  9.051765687277221e-22, -4.539142271542693e-24,  1.378219716590457e-26, -1.533417341506194e-28,
  1.194002656436569e-02, -9.765129994355856e-05,  5.966146804109740e-07, -3.225903313983204e-09,  1.622370963570864e-11, -7.792079142439259e-14,  3.575698042192931e-16,
 -1.618729293835486e-18,  6.716231819805030e-21, -3.217853072837684e-23,  7.330591520654947e-26, -1.098229849749951e-27,  3.319147849286215e-02, -2.703025861700805e-04,
  1.633675545546929e-06, -8.656029237239072e-09,  4.210689828890985e-11, -1.922683763681857e-13,  8.177181432008573e-16, -3.331756546624588e-18,  1.145195004775748e-20,
 -4.755954461773241e-23, -2.823356566787825e-26, -1.851584314922129e-27,  6.512742832828379e-02, -5.269236713062690e-04,  3.131496691207379e-06, -1.606389750975421e-08,
  7.391378121429344e-11, -3.081352177427210e-13,  1.120986885863165e-15, -3.485105864494126e-18,  4.813529574683049e-21,  2.672058362221395e-25, -5.141100493177269e-25,
 -1.663432339289546e-27,  1.078166153605668e-01, -8.644787322597496e-04,  5.017517395868074e-06, -2.455025212204391e-08,  1.034903669276453e-10, -3.657299485640737e-13,
  9.004752540781457e-16, -2.154353935100591e-19, -2.043610853935519e-20,  1.239696964613046e-22, -1.278351206226223e-24, -2.147459730558005e-27,  1.613472584877238e-01,
 -1.278548673459403e-03,  7.189443833875073e-06, -3.289656110278332e-08,  1.205324246582732e-10, -2.984578206445839e-13, -1.618473707876995e-16,  7.271428454544995e-18,
 -6.026721447988335e-20,  2.474526012693438e-22, -1.656101888583445e-24, -7.720825333957428e-27,  2.258230979150051e-01, -1.762962917913659e-03,  9.510224929457533e-06,
 -3.955952424220734e-08,  1.133448867518294e-10, -4.718536814749447e-14, -2.175080994900225e-15,  1.741498518178069e-17, -9.219705505750033e-20,  1.887921922283545e-22,
 -6.177138622815241e-25, -2.220346895486855e-26,  3.013569112935440e-01, -2.309268913434652e-03,  1.180153911075545e-05, -4.268363338253331e-08,  7.020012898965406e-11,
  4.181566176507384e-13, -4.835734008789072e-15,  2.513762186374460e-17, -7.439315723347384e-20, -2.715851986292556e-22,  2.278287662549677e-24, -4.074866778978346e-26,
  3.880599803959965e-01, -2.905979453213766e-03,  1.383588852475561e-05, -4.015516850200546e-08, -1.832277097434758e-11,  1.067649124320691e-12, -7.209193856599001e-15,
  2.156158901468675e-17,  4.013925396171201e-20, -1.180206839786196e-21,  5.145107478481176e-24, -4.165136333523029e-26,  4.860249946338536e-01, -3.537511701456831e-03,
  1.532788668147975e-05, -2.974044983748652e-08, -1.554609905989455e-10,  1.770791060235146e-12, -7.585722440917473e-15, -3.918402912775132e-18,  2.627158639277939e-19,
 -2.049235489348814e-21,  2.293115163546926e-24,  6.326812402165132e-27,  5.952982002019459e-01, -4.182698175338478e-03,  1.592650133482237e-05, -9.385104415859064e-09,
 -3.321424022305168e-10,  2.251915806014549e-12, -3.627312973303116e-15, -5.680051156375171e-17,  4.949811148743793e-19, -1.538678038529185e-21, -1.357444016670870e-23,
  9.416675623156897e-26,  7.158337102069380e-01, -4.812713406197962e-03,  1.521267421486027e-05,  2.219271417938448e-08, -5.180053139021424e-10,  2.063946048017040e-12,
  6.752377463086737e-15, -1.232322084938383e-16,  4.483153387870394e-19,  2.120959390402787e-21, -3.940362892839566e-23,  7.617072758395346e-26,  8.474178339076840e-01,
 -5.388241975160471e-03,  1.271253959612876e-05,  6.440005366582589e-08, -6.500683694341763e-10,  6.420101231575506e-13,  2.305227746042190e-14, -1.496788350366208e-16,
 -3.149844549413615e-19,  8.540202677330456e-21, -3.870836585974134e-23, -3.267393891224500e-25,  9.895423924602835e-01, -5.855785923107731e-03,  7.948650982922328e-06,
  1.128623767719661e-07, -6.237156531314426e-10, -2.424935153868318e-12,  3.777950888292699e-14, -3.566354696282327e-17, -1.894794252381559e-18,  9.624335406547596e-21,
  5.754830274203288e-23, -9.542133514081807e-25,  1.141190511130066e+00, -6.143386693947138e-03,  5.756411460743068e-07,  1.564985001448626e-07, -3.025661678703232e-10,
 -6.671272485130107e-12,  3.167164118820844e-14,  2.945666400493336e-16, -2.777132806330206e-18, -1.153466377199890e-20,  2.063053628172171e-22,  1.734748015398044e-26,
  1.300472646105905e+00, -6.157313701002510e-03, -9.312698702407741e-06,  1.742099435479729e-07,  4.096044639256857e-10, -9.463882210911053e-12, -2.066413175866481e-14,
  6.296427662929786e-16,  9.398969850619884e-19, -4.766031319243764e-20, -4.401710767816429e-23,  3.593661736164141e-24,  1.464013666028778e+00, -5.784945718792067e-03,
 -2.057980151004599e-05,  1.351598528371342e-07,  1.360034484826671e-09, -5.305885885576599e-12, -1.067167065817883e-13,  1.736439704712927e-16,  8.910554368006522e-18,
  2.547797496980347e-21, -7.924266354527491e-22, -2.039684529995896e-24,  1.625964007663583e+00, -4.918141027345934e-03, -3.012929950021145e-05,  1.527504556936335e-08,
  1.815788231133379e-09,  9.035165653130355e-12, -9.498143898597950e-14, -1.337463875951277e-15,  1.041036606383004e-18,  1.355382113579759e-19,  6.760040419478961e-22,
 -1.038089909166385e-23,  1.776598745402730e+00, -3.527676230731542e-03, -3.245094778252428e-05, -1.500525217944371e-07,  6.652766181266720e-10,  1.835781315712848e-11,
  1.238798419227319e-13, -5.375297024718802e-16, -1.864706714544440e-17, -1.397226933981687e-19,  6.112152510268599e-22,  2.284295340601659e-23,  1.901033879615000e+00,
 -1.821340980967559e-03, -2.265348780347881e-05, -2.127932230013574e-07, -1.364756012424730e-09, -1.646755920998788e-12,  1.052763459681177e-13,  1.761258082356485e-15,
  1.555440114462180e-17,  3.972806809965414e-20, -1.251584331934718e-21, -2.533466166542886e-23,  1.980174869517019e+00, -4.029031615783211e-04, -6.020696791276789e-06,
 -7.788245176514554e-08, -9.123166304489594e-10, -9.798341195142589e-12, -9.599095701127284e-14, -8.363446920921021e-16, -6.028107977064971e-18, -2.674389617433935e-20,
  1.434182032574042e-22,  5.831440929355025e-24,  1.283738160388229e-03, -1.035181449757732e-05,  6.255642080884882e-08, -3.361208099091202e-10,  1.689071607443727e-12,
 -8.175289616319788e-15,  3.802766442969623e-17, -1.782555402017917e-19,  7.499911018167360e-22, -4.131080743284463e-24,  6.391168613747857e-27, -1.844778319800999e-28,
  1.155872810830215e-02, -9.302892849537275e-05,  5.594113583365940e-07, -2.978340002315386e-09,  1.474756031879765e-11, -6.985977586634855e-14,  3.150835659497965e-16,
 -1.421878849859539e-18,  5.598085404636255e-21, -3.030819608447422e-23,  1.765829181507356e-26, -1.445134300405006e-27,  3.213576489096987e-02, -2.576375036074989e-04,
  1.533721928932211e-06, -8.012046494051565e-09,  3.845043395061482e-11, -1.737227950130087e-13,  7.292994642908870e-16, -2.993086225910743e-18,  9.696706830169427e-21,
 -5.066659681694704e-23, -1.361556032118076e-25, -3.082622970092207e-27,  6.306864451106013e-02, -5.026231193405701e-04,  2.945626919988433e-06, -1.492914974463711e-08,
  6.801229895420494e-11, -2.823852597431561e-13,  1.025532473908157e-15, -3.335077963439421e-18,  4.428178161151400e-21, -2.255549363174709e-23, -6.474215499065719e-25,
 -4.444821735721172e-27,  1.044371539076697e-01, -8.254894041109634e-04,  4.732611858773836e-06, -2.295175215437525e-08,  9.639102769521694e-11, -3.442610607810644e-13,
  8.858868131983462e-16, -8.081129495220144e-19, -1.692786899964502e-20,  6.967112171498810e-23, -1.469619030676722e-24, -6.651309278896327e-27,  1.563456404415992e-01,
 -1.222579827600783e-03,  6.806058727530752e-06, -3.101594120448434e-08,  1.145398234095197e-10, -3.001091277050228e-13,  1.599670146930082e-17,  5.471873369456889e-18,
 -5.264663734024117e-20,  1.729102117874601e-22, -2.111297520098515e-24, -1.320010360634766e-26,  2.189204467260188e-01, -1.688749235182459e-03,  9.046351856525333e-06,
 -3.775623214764509e-08,  1.119169600292985e-10, -9.386320091057376e-14, -1.727789425400317e-15,  1.456665912432065e-17, -8.609391767256874e-20,  1.430546089770380e-22,
 -1.710950755310936e-24, -2.786889143967307e-26,  2.923054440540937e-01, -2.216885724718102e-03,  1.129633092176315e-05, -4.149959769680796e-08,  7.745827071552996e-11,
  3.102677424343820e-13, -4.166574075542888e-15,  2.261456372669344e-17, -8.298130854466024e-20, -2.184815191167868e-22,  3.182415249224975e-25, -4.871232219233025e-26,
  3.766543800346728e-01, -2.797223214119157e-03,  1.335294227958089e-05, -4.028670237843461e-08,  1.349495068108356e-12,  9.019803762105478e-13, -6.593613415187260e-15,
  2.220205908963887e-17,  8.654400843256238e-22, -1.016473424517895e-21,  2.905993981560328e-24, -6.015642820646199e-26,  4.721178775112856e-01, -3.416355807769263e-03,
  1.495721364566590e-05, -3.195441197818714e-08, -1.218700070349786e-10,  1.588299586500135e-12, -7.588705565034976e-15,  3.325689315275597e-18,  1.905544941144506e-19,
 -1.963702613117901e-21,  1.692865799935872e-24, -3.342354519779349e-26,  5.788213951823392e-01, -4.055823602780057e-03,  1.578346395240108e-05, -1.434431556885726e-08,
 -2.880944448156070e-10,  2.147510429914421e-12, -5.005007554654511e-15, -4.194495887536605e-17,  4.306797219395761e-19, -2.013650754506254e-21, -1.055959378917417e-23,
  4.152253873357445e-26,  6.968277513030728e-01, -4.690084470942891e-03,  1.543064586776476e-05,  1.424252241787797e-08, -4.753766745750431e-10,  2.186278033760251e-12,
  3.512069263346483e-15, -1.079619900077091e-16,  4.971183306048345e-19,  6.125640180762753e-22, -3.606306673812836e-23,  7.007593102906666e-26,  8.260729129422967e-01,
 -5.283626110403024e-03,  1.342345084109748e-05,  5.413029963823082e-08, -6.320398139462112e-10,  1.144106449964265e-12,  1.876409355940272e-14, -1.551640422146960e-16,
 -3.855699422888244e-20,  6.738471194058178e-21, -5.059133199159244e-23, -2.186637381167267e-25,  9.662547607583823e-01, -5.786952339821953e-03,  9.241680709741014e-06,
  1.025437426318719e-07, -6.632621591088100e-10, -1.536727481254765e-12,  3.598683871721618e-14, -9.039151037352087e-17, -1.517041046453895e-18,  1.108370118870099e-20,
  1.552991965979873e-23, -9.394538746201584e-25,  1.116637939298071e+00, -6.131361793608038e-03,  2.420314754617532e-06,  1.506339569305813e-07, -4.277756670313584e-10,
 -5.822547780133055e-12,  3.862422270554130e-14,  2.006350010138672e-16, -3.045715642552713e-18, -3.491654055863107e-21,  1.905135707703540e-22, -7.125306627684026e-25,
  1.275707766216830e+00, -6.223356331147753e-03, -7.189174317820287e-06,  1.792284827719918e-07,  2.168062753703681e-10, -9.746452667948846e-12, -2.871648574932511e-15,
  6.322324148158333e-16, -7.701602954970861e-19, -4.634629041710524e-20,  1.062013030086097e-22,  3.113605921446912e-24,  1.440555388972435e+00, -5.942735487048268e-03,
 -1.883126671123647e-05,  1.559345359536010e-07,  1.228864654701381e-09, -7.776659146464832e-12, -9.789330443912153e-14,  4.540145130451999e-16,  8.419015258705917e-18,
 -2.995878308345698e-20, -8.078403681477686e-22,  1.386280207816716e-24,  1.605811249944662e+00, -5.157935460725432e-03, -2.976615577318342e-05,  4.563682242694326e-08,
  1.970701819807748e-09,  6.314658545561383e-12, -1.311990355190613e-13, -1.221868371197924e-15,  6.279982369272802e-18,  1.515895268920746e-19,  8.370982802743197e-23,
 -1.622421401010574e-23,  1.761957714863879e+00, -3.794276455945204e-03, -3.417508909188014e-05, -1.363156943343772e-07,  1.060577505635240e-09,  2.107846380698176e-11,
  9.976465392122323e-14, -1.207894377631778e-15, -2.297422550836164e-17, -9.297142427535519e-20,  1.772984499688729e-21,  2.916069155835896e-23,  1.893369361464870e+00,
 -2.013155695501524e-03, -2.533861694928964e-05, -2.347377276306715e-07, -1.368135429924638e-09,  1.528821792918639e-12,  1.616923432404433e-13,  2.269816646786329e-15,
  1.578077749162592e-17, -3.638653549091048e-20, -2.648866634595577e-21, -3.826580929564215e-23,  1.978460635615698e+00, -4.550709915906187e-04, -7.049763702894074e-06,
 -9.418078971223678e-08, -1.133334353042417e-09, -1.240576952188490e-11, -1.222426824079957e-13, -1.042945433196831e-15, -6.811153342161507e-18, -1.421270104395440e-20,
  5.315820139418862e-22,  1.252156594013370e-23,  1.243306892565312e-03, -9.867049615007766e-06,  5.867988237882151e-08, -3.103557724012445e-10,  1.534301608849202e-12,
 -7.319943619582260e-15,  3.335040495216415e-17, -1.566024186357934e-19,  6.038356169969526e-22, -4.046340397207685e-24, -2.299243018599095e-27, -2.027860585365367e-28,
  1.119534214856038e-02, -8.869269019562510e-05,  5.250422314229884e-07, -2.753158917369451e-09,  1.342286038240105e-11, -6.275628539080354e-14,  2.776150942303420e-16,
 -1.260191659582016e-18,  4.503493687367662e-21, -3.096675297942508e-23, -5.226357455991298e-26, -1.660941003845114e-27,  3.112915993630896e-02, -2.457421059087239e-04,
  1.441156959793550e-06, -7.423712076901871e-09,  3.514439550322172e-11, -1.571919514614283e-13,  6.495538338070456e-16, -2.713312595969366e-18,  7.738919605695978e-21,
 -5.915024846315739e-23, -2.942177214671239e-25, -3.892236345411972e-27,  6.110417301061345e-02, -4.797566245168715e-04,  2.772824175246908e-06, -1.388482878188934e-08,
  6.260323648235369e-11, -2.588779935956779e-13,  9.339739644940234e-16, -3.211795154586621e-18,  3.095993675667421e-21, -5.309755641300173e-23, -8.941077699180179e-25,
 -6.345651750573031e-27,  1.012092100814604e-01, -7.887044907988058e-04,  4.466220877650690e-06, -2.146343105349148e-08,  8.971627847394618e-11, -3.233306180859201e-13,
  8.559684426560506e-16, -1.321668412652092e-18, -1.555976274039651e-20,  3.822148264712884e-24, -1.846725694789504e-24, -9.797681590375200e-27,  1.515619042416483e-01,
 -1.169589423911785e-03,  6.444665385908285e-06, -2.923125189570784e-08,  1.085529286012912e-10, -2.980718886601175e-13,  1.464359852312858e-16,  3.869245232588500e-18,
 -4.809640306272521e-20,  7.531479786194791e-23, -2.797673652415951e-24, -1.700336214912244e-26,  2.123073647117346e-01, -1.618160434704186e-03,  8.603952216568938e-06,
 -3.598269880724268e-08,  1.096564730848170e-10, -1.307428402857432e-13, -1.357827415256256e-15,  1.187834212024411e-17, -8.248679656398178e-20,  4.847253210306746e-23,
 -3.046593565733788e-24, -3.147983588877185e-26,  2.836155188031081e-01, -2.128485552029450e-03,  1.080595949554278e-05, -4.021584594000066e-08,  8.271335599978526e-11,
  2.175611114840355e-13, -3.571731789719351e-15,  1.983144404311354e-17, -9.115430322461686e-20, -2.507309245123161e-22, -1.966164746451291e-24, -5.318370448131875e-26,
  3.656760747219744e-01, -2.692331754336835e-03,  1.287019943491583e-05, -4.012918067533571e-08,  1.785686482672556e-11,  7.511635319527771e-13, -5.976940686897006e-15,
  2.166123068254095e-17, -3.431646504731168e-20, -9.577449658647178e-22, -5.651527572217414e-26, -7.157800725278805e-26,  4.586892974673601e-01, -3.298262708892305e-03,
  1.456307751881966e-05, -3.366005660428219e-08, -9.191447664587187e-11,  1.407912193105455e-12, -7.420772045788020e-15,  8.301897558267247e-18,  1.206304096539968e-19,
 -1.935598346855749e-21, -5.023211129343643e-25, -6.222168699953116e-26,  5.628494396461194e-01, -3.930319560055472e-03,  1.558507028905122e-05, -1.861712373052609e-08,
 -2.464328152741893e-10,  2.014784254580741e-12, -5.997984933492423e-15, -2.940196135805621e-17,  3.508833004568523e-19, -2.414887891495834e-21, -9.845880908679669e-24,
 -4.736986801103603e-27,  6.783152080529635e-01, -4.566081617454092e-03,  1.555737502442280e-05,  6.989884555146619e-09, -4.310437342465264e-10,  2.236100611876369e-12,
  7.132057898317612e-16, -9.197414764491975e-17,  4.938863971434539e-19, -7.750954116748595e-22, -3.348059630262340e-23,  4.922705463582501e-26,  8.051570573977231e-01,
 -5.173810273444113e-03,  1.401316894822163e-05,  4.422371108504007e-08, -6.050060361881488e-10,  1.542379903287202e-12,  1.443580967329448e-14, -1.529243148757364e-16,
  1.655223319724278e-19,  4.548512363364602e-21, -5.826620265832331e-23, -1.294732504768737e-25,  9.432623542210042e-01, -5.708279237406854e-03,  1.040766764383311e-05,
  9.173164405505108e-08, -6.855916520877803e-10, -7.085295226818797e-13,  3.283662018526127e-14, -1.325121769709854e-16, -1.116587356878295e-18,  1.090387651404154e-20,
 -2.369640958900099e-23, -8.252701586667121e-25,  1.092162489828995e+00, -6.104893714993634e-03,  4.183180780636016e-06,  1.429100155182287e-07, -5.345589941809312e-10,
 -4.839231665552864e-12,  4.286870267970488e-14,  1.025595956541676e-16, -3.043416145179257e-18,  3.328126424101485e-21,  1.466581438235764e-22, -1.233847424084793e-24,
  1.250712999195031e+00, -6.272222596536279e-03, -5.024047628120230e-06,  1.811401554652475e-07,  2.260112193179180e-11, -9.607233053117120e-12,  1.424231908961305e-14,
  5.819633158778663e-16, -2.331674718762075e-18, -3.964300345572113e-20,  2.210874959918768e-22,  2.039591770851569e-24,  1.416495453065231e+00, -6.085579138068229e-03,
 -1.684761427319876e-05,  1.742293071013665e-07,  1.051019090064303e-09, -9.944321861200467e-12, -8.161479068424178e-14,  7.001099952815754e-16,  6.782715286845333e-18,
 -6.005333235938224e-20, -6.731452447470693e-22,  4.633530489334601e-24,  1.584707485943634e+00, -5.393329677643366e-03, -2.902574369833382e-05,  7.799615425328294e-08,
  2.062874751564142e-09,  2.783071979470427e-12, -1.617813528825516e-13, -9.344147694036469e-16,  1.161491142455659e-17,  1.395616602838678e-19, -7.048199491023159e-22,
 -1.889586676703773e-23,  1.746223898112577e+00, -4.073899023737421e-03, -3.569476388483450e-05, -1.158568349957719e-07,  1.502910313112718e-09,  2.298134782697527e-11,
  5.526030266477283e-14, -1.980389862415817e-15, -2.473101248196967e-17,  3.958736286746774e-21,  3.064324998319392e-21,  2.781356203820003e-23,  1.884892960305385e+00,
 -2.227500369819884e-03, -2.828505720700888e-05, -2.561498242697926e-07, -1.293318049599548e-09,  6.227132696758273e-12,  2.319541453918529e-13,  2.729886338951950e-15,
  1.212576420698456e-17, -1.794695765966570e-19, -4.579946228642529e-21, -4.834181178783274e-23,  1.976519936261681e+00, -5.163179895830909e-04, -8.297465643953951e-06,
 -1.144688432707545e-07, -1.413282050923577e-09, -1.571494884540440e-11, -1.545371055851684e-13, -1.263728968314744e-15, -6.779596229284185e-18,  2.120770594602753e-20,
  1.329758505040720e-21,  2.498304367315150e-23,  1.204754560034365e-03, -9.412101154032647e-06,  5.509821179102024e-08, -2.869361020159593e-10,  1.395562369001552e-12,
 -6.570104497333612e-15,  2.921393220489206e-17, -1.396448933396773e-19,  4.544790882769938e-22, -4.301331480478269e-24, -9.720377460477045e-27, -9.854469076797290e-29,
  1.084876785490917e-02, -8.462094605026776e-05,  4.932526404051155e-07, -2.548083864237015e-09,  1.223158390895142e-11, -5.650171085385370e-14,  2.441760201709967e-16,
 -1.134457734616698e-18,  3.334397001331718e-21, -3.439178520314780e-23, -1.126797228441149e-25, -7.585252072626282e-28,  3.016869900912612e-02, -2.345598626895234e-04,
  1.355345204443032e-06, -6.885730796217636e-09,  3.215043155465166e-11, -1.424884054504517e-13,  5.767099133679044e-16, -2.502332054923115e-18,  5.358585996963562e-21,
 -7.403941030049589e-23, -4.337853000152474e-25, -1.531554732620230e-27,  5.922847998299696e-02, -4.582238605490972e-04,  2.612049143081982e-06, -1.292340997512238e-08,
  5.764259543174036e-11, -2.375326127921792e-13,  8.450910448068703e-16, -3.150737171276499e-18,  4.770450154296279e-22, -9.392080157663269e-23, -1.116325634939523e-24,
 -1.925638310530579e-27,  9.812425424369774e-02, -7.539810499177866e-04,  4.217062648322179e-06, -2.007860091203126e-08,  8.345180883068367e-11, -3.032881231782524e-13,
  8.119052410241255e-16, -1.832447633255104e-18, -1.684970257038022e-20, -7.779492366090845e-23, -2.182879234923665e-24, -2.423451957529964e-27,  1.469844807057909e-01,
 -1.119406126177343e-03,  6.104115428573311e-06, -2.754187185727204e-08,  1.026345197917389e-10, -2.934295774581164e-13,  2.334730713631489e-16,  2.350541744791281e-18,
 -4.756854652984830e-20, -5.000711399220278e-23, -3.385528776383161e-24, -5.106378315631694e-27,  2.059696933555186e-01, -1.551026369646666e-03,  8.182595122649337e-06,
 -3.425077697185199e-08,  1.067411398346972e-10, -1.596371413376195e-13, -1.062108449104029e-15,  9.240571491436558e-18, -8.324901233143972e-20, -9.842557610612261e-23,
 -4.169203615900604e-24, -1.301487511818659e-26,  2.752714477035449e-01, -2.043945437291379e-03,  1.033143883111175e-05, -3.886209725222855e-08,  8.625059909715776e-11,
  1.381643061315604e-13, -3.058779402478944e-15,  1.675050026677361e-17, -1.021307205712335e-19, -3.723115727606731e-22, -3.930433424554494e-24, -2.712687148906209e-26,
  3.551096293776722e-01, -2.591290410317457e-03,  1.239083460435350e-05, -3.973087503057596e-08,  3.149402033219397e-11,  6.148390162683538e-13, -5.391021458201237e-15,
  2.000499941695964e-17, -6.956689348664912e-20, -1.019051363932987e-21, -2.793197504464515e-24, -4.064213640664025e-26,  4.457266651554056e-01, -3.183396694617267e-03,
  1.415123115955296e-05, -3.491501291165820e-08, -6.551640918779607e-11,  1.232974642907417e-12, -7.144810854441421e-15,  1.103791145167861e-17,  4.993049960907005e-20,
 -2.008960332492610e-21, -2.971617922745378e-24, -3.382836703798926e-26,  5.473760169709466e-01, -3.806596639051344e-03,  1.533931096398637e-05, -2.224576280168530e-08,
 -2.076371237307932e-10,  1.862139289024790e-12, -6.677659183208250e-15, -1.964133954716539e-17,  2.567778654394357e-19, -2.814787581472236e-21, -9.999917080073029e-24,
  1.801174888004879e-26,  6.603001697775804e-01, -4.441400945998561e-03,  1.560134996359489e-05,  4.510470417567326e-10, -3.863500629620976e-10,  2.224065212413935e-12,
 -1.646821965288416e-15, -7.687036962994168e-17,  4.424228758924462e-19, -2.066830297513431e-21, -3.078712582681024e-23,  9.597803843257931e-26,  7.846891589230777e-01,
 -5.059744285828303e-03,  1.448684790132550e-05,  3.480777629293539e-08, -5.710370001712651e-10,  1.838190273821033e-12,  1.024943748839320e-14, -1.454666263314699e-16,
  2.862556508065342e-19,  2.139776109025763e-21, -6.105060939149168e-23,  2.789909134066128e-26,  9.206024672140024e-01, -5.620802063586118e-03,  1.144229803450084e-05,
  8.069030226143350e-08, -6.922013482494582e-10,  3.134216287526881e-14,  2.868336179337191e-14, -1.622126565114399e-16, -7.492886246855920e-19,  9.295629772859441e-21,
 -5.467249913286159e-23, -5.408429509155523e-25,  1.067820492516672e+00, -6.064720976449250e-03,  5.843772682926660e-06,  1.336394755016916e-07, -6.208788006061719e-10,
 -3.786779313058316e-12,  4.440236387421359e-14,  8.108193530095140e-18, -2.831830090515674e-18,  8.034540804923512e-21,  8.772669580233711e-23, -1.356904926553592e-24,
  1.225557480309319e+00, -6.303728558093995e-03, -2.854461931806837e-06,  1.799885604560075e-07, -1.648544248806669e-10, -9.079562780700617e-12,  2.929123059145960e-14,
  4.863756218529734e-16, -3.581364738824059e-18, -2.937176957998942e-20,  2.836192073801126e-22,  8.364527929078685e-25,  1.391897198946212e+00, -6.211726940342319e-03,
 -1.466285353450580e-05,  1.893551743384190e-07,  8.342505888078890e-10, -1.164548622459198e-11, -5.933256777221277e-14,  8.778157742782035e-16,  4.192403951388406e-18,
 -8.213263376360798e-20, -4.137173122767790e-22,  6.981182833522792e-24,  1.562676478986297e+00, -5.621227891131016e-03, -2.789062276978820e-05,  1.112283961269740e-07,
  2.077825335367572e-09, -1.367236604092774e-12, -1.820343427114644e-13, -4.894055842689495e-16,  1.593359659829343e-17,  9.507731086623879e-20, -1.500335200444818e-21,
 -1.626157922311080e-23,  1.729349004316067e+00, -4.364574171579818e-03, -3.692542077132132e-05, -8.808164666991851e-08,  1.970849866712457e-09,  2.355379061888725e-11,
 -1.106693913838076e-14, -2.743615839314914e-15, -2.211336121465172e-17,  1.479451456906369e-19,  4.034310790461769e-21,  1.397459200944046e-23,  1.875510449005380e+00,
 -2.466416239270008e-03, -3.147785123378291e-05, -2.755174159438856e-07, -1.106718684563743e-09,  1.274778264507933e-11,  3.125755628284441e-13,  2.974969204191861e-15,
  1.848682553216781e-18, -4.055976311805543e-19, -6.699744657915947e-21, -4.437260539170796e-23,  1.974312629303765e+00, -5.886018893666663e-04, -9.817825377064421e-06,
 -1.398097229416986e-07, -1.767658248942123e-09, -1.987183579997294e-11, -1.927567941874803e-13, -1.455722665402532e-15, -4.743904058507405e-18,  1.020163734767481e-19,
  2.870504562820373e-21,  4.700629800167007e-23,  1.167966442696456e-03, -8.984718545181830e-06,  5.178473611961220e-08, -2.656215275764632e-10,  1.270862784137481e-12,
 -5.914393289457894e-15,  2.548364480221049e-17, -1.276572037987390e-19,  2.924562469936816e-22, -4.674417010836105e-24, -5.454574072216555e-27,  3.862612426119929e-28,
  1.051798704482115e-02, -8.079398982841809e-05,  4.638135773399502e-07, -2.361110987978782e-09,  1.115763632913447e-11, -5.101178286586583e-14,  2.137125363430876e-16,
 -1.048453238854007e-18,  2.014879073735558e-21, -3.865061869108610e-23, -6.905551355182550e-26,  3.590191987896346e-27,  2.925163383232955e-02, -2.240390830282723e-04,
  1.275711205670051e-06, -6.393393512808354e-09,  2.943348778600729e-11, -1.294713579643172e-13,  5.086205567934260e-16, -2.376851054534825e-18,  2.385936538816971e-21,
 -9.021671316228826e-23, -2.887121165334376e-25,  1.050603326332790e-26,  5.743641681551027e-02, -4.379324663361886e-04,  2.462348628706392e-06, -1.203806167456064e-08,
  5.308761368991234e-11, -2.183107822749478e-13,  7.565146559081094e-16, -3.198093258322047e-18, -3.686618600429915e-21, -1.353383952164631e-22, -7.849939329389607e-25,
  2.171061762908996e-26,  9.517430851898921e-02, -7.211860768936649e-04,  3.983934019963309e-06, -1.879085792613810e-08,  7.757641957611566e-11, -2.844822161632541e-13,
  7.525077304276252e-16, -2.433072492793191e-18, -2.117800484163443e-20, -1.589944843527150e-22, -1.593215875189567e-24,  3.715169161652081e-26,  1.426024676919123e-01,
 -1.071867739945071e-03,  5.783273256482827e-06, -2.594634457206222e-08,  9.682639338393258e-11, -2.872110466182596e-13,  2.775212030508743e-16,  7.736409269859440e-19,
 -5.175309968310427e-20, -1.772198614552573e-22, -2.539627535817954e-24,  5.559847027932706e-26,  1.998939469977006e-01, -1.487180863602154e-03,  7.781723328765630e-06,
 -3.256976316547170e-08,  1.033128747143016e-10, -1.823283758649831e-13, -8.414319693901368e-16,  6.487586834432682e-18, -8.977529102901521e-20, -2.581296198409852e-22,
 -3.184967377937772e-24,  7.493558502670586e-26,  2.672580488216866e-01, -1.963135662287746e-03,  9.873452409107484e-06, -3.746381737504746e-08,  8.831580305587746e-11,
  6.999896043850018e-14, -2.637758283993098e-15,  1.323654988461760e-17, -1.184343341276766e-19, -5.277839876064985e-22, -2.972335857726087e-24,  9.423847385423357e-26,
  3.449397148130071e-01, -2.494061359302394e-03,  1.191747106052626e-05, -3.913544087496215e-08,  4.254087993604914e-11,  4.918899025941870e-13, -4.867728178150290e-15,
  1.716858514560338e-17, -1.084134739162244e-19, -1.133281134307557e-21, -1.777972926821627e-24,  1.183136858697800e-25,  4.332168217714870e-01, -3.071878772301394e-03,
  1.372674530596732e-05, -3.577520888416250e-08, -4.254599054214700e-11,  1.065320787511065e-12, -6.824423402160742e-15,  1.145478217093109e-17, -2.455200550966149e-20,
 -2.117325919408844e-21, -1.033387100070993e-24,  1.633317279420249e-25,  5.323932926389435e-01, -3.685003652237728e-03,  1.505362897861876e-05, -2.527889366894536e-08,
 -1.720371311805379e-10,  1.696108176435659e-12, -7.128343764884613e-15, -1.311897833527917e-17,  1.488297414681440e-19, -3.151778967329639e-21, -5.149505721781578e-24,
  2.554818190298343e-25,  6.427840779493118e-01, -4.316670220141290e-03,  1.557113191656453e-05, -5.377554973068611e-09, -3.424303918602109e-10,  2.160235853709152e-12,
 -3.613804039979837e-15, -6.412953698388541e-17,  3.473839778140817e-19, -3.152333593223152e-21, -2.131230542187901e-23,  3.999363110469125e-25,  7.646844012438013e-01,
 -4.942331177334270e-03,  1.485097442663849e-05,  2.597729452806740e-08, -5.321376573158610e-10,  2.036389571073518e-12,  6.312874942839272e-15, -1.355373491152466e-16,
  3.204953930720309e-19, -1.765683421603978e-22, -5.148646187693441e-23,  4.848885904522099e-25,  8.983082027452145e-01, -5.525578540774271e-03,  1.234426784806134e-05,
  6.965590933277443e-08, -6.850711452439049e-10,  6.628230940547886e-13,  2.385279883140122e-14, -1.812951769764962e-16, -4.583246471627038e-19,  6.796498587429205e-21,
 -6.520092623454894e-23,  1.649367107411027e-25,  1.043665020041228e+00, -6.011730359275698e-03,  7.385530080657349e-06,  1.231573272849599e-07, -6.859911381448553e-10,
 -2.728349449895432e-12,  4.340839406892578e-14, -7.731646448275983e-17, -2.492895479383000e-18,  1.046306895387383e-20,  3.821341714368460e-23, -7.274262598793626e-25,
  1.200310492656536e+00, -6.317983173829572e-03, -7.162819514010317e-07,  1.759407409526194e-07, -3.383834698380145e-10, -8.226998512680111e-12,  4.116228487646827e-14,
  3.570995963254271e-16, -4.427988693412518e-18, -1.753113814200859e-20,  3.043920352762408e-22,  3.027826719373944e-25,  1.366830372954774e+00, -6.319731965422433e-03,
 -1.231841661567721e-05,  2.007711298542223e-07,  5.891583220283515e-10, -1.276219284059883e-11, -3.333917664328500e-14,  9.621005115549684e-16,  1.016171691906949e-18,
 -9.206579188427714e-20, -7.242134094802217e-23,  8.443541455957290e-24,  1.539754563994833e+00, -5.838452380972254e-03, -2.635809222868728e-05,  1.440138844650168e-07,
  2.005991963406897e-09, -5.840169164846514e-12, -1.881749899378766e-13,  6.237315698631091e-17,  1.812268546040565e-17,  2.293030467148364e-20, -2.041550705548067e-21,
 -7.278941362608962e-24,  1.711294010417532e+00, -4.663633812888176e-03, -3.777777485919535e-05, -5.282135727738030e-08,  2.432658851723151e-09,  2.229242440536279e-11,
 -9.676725237015790e-14, -3.334086411059751e-15, -1.379737475927692e-17,  3.145365679747861e-19,  4.099706002760787e-21, -1.274121358285923e-23,  1.865119803178591e+00,
 -2.731742747378792e-03, -3.488049410374952e-05, -2.907494208090168e-07, -7.700273900435639e-10,  2.124044208480834e-11,  3.941188516138566e-13,  2.745364532329448e-15,
 -1.798267450708606e-17, -7.049857768170023e-19, -8.005863686804726e-21, -7.787969459790612e-24,  1.971789790255119e+00, -6.743680702335174e-04, -1.167920535761886e-05,
 -1.715372185151895e-07, -2.214729191583166e-09, -2.499997980982192e-11, -2.349061061955560e-13, -1.522014256010721e-15,  1.578286482032490e-18,  2.676948942910751e-19,
  5.677428315040953e-21,  8.331638192838041e-23,  1.132836413481100e-03, -8.582853594814937e-06,  4.871548148013848e-08, -2.462019935518932e-10,  1.158406270201430e-12,
 -5.344776983353325e-15,  2.201493940269782e-17, -1.209829914534714e-19,  1.270031761512282e-22, -4.246982596967816e-24,  3.620945910333320e-26,  1.682282284569513e-27,
  1.020205684283545e-02, -7.719385543645659e-05,  4.365185865238796e-07, -2.190481877592582e-09,  1.018634594995109e-11, -4.622897084529678e-14,  1.850480574073981e-16,
 -1.006311388183747e-18,  6.357437673449826e-22, -3.549926377306810e-23,  3.112165324298284e-25,  1.527453846729755e-26,  2.837541402989054e-02, -2.141324629621241e-04,
  1.201732734122761e-06, -5.942532395690937e-09,  2.696077051963248e-11, -1.180575097088232e-13,  4.426407654101689e-16, -2.353365493382118e-18, -8.916413557328604e-22,
 -8.484426128196016e-23,  7.933382223527160e-25,  4.310450896542081e-26,  5.572318959157423e-02, -4.187973900115240e-04,  2.322847326032096e-06, -1.122263383057654e-08,
  4.889561968998054e-11, -2.012469780401375e-13,  6.645556412165996e-16, -3.397372444157153e-18, -8.762099637402347e-21, -1.324740454100469e-22,  1.394749780265311e-24,
  8.615395467246861e-26,  9.235190827765795e-02, -6.901958912868504e-04,  3.765706414698168e-06, -1.759419570929064e-08,  7.206143940786119e-11, -2.673217469816054e-13,
  6.739710720080533e-16, -3.210044911661899e-18, -2.743421394431822e-20, -1.646145520479135e-22,  2.094681661464851e-24,  1.452373468749981e-25,  1.384055937908020e-01,
 -1.026821075840687e-03,  5.481024080184302e-06, -2.444271024070677e-08,  9.114953791942577e-11, -2.804841728744220e-13,  2.749369166421297e-16, -9.972090963584956e-19,
 -5.903483298011414e-20, -1.910675126591674e-22,  3.041546077241299e-24,  2.205744441283763e-25,  1.940672951126749e-01, -1.426462608487288e-03,  7.400680470257049e-06,
 -3.094697113303360e-08,  9.947736068562390e-11, -2.006767921861644e-13, -7.015189406644611e-16,  3.451047274281870e-18, -1.000815845641021e-19, -2.637758628812282e-22,
  4.618339918550390e-24,  3.119347323867554e-25,  2.595606681870816e-01, -1.885922199705607e-03,  9.432400300381507e-06, -3.604288625299999e-08,  8.911045084831427e-11,
  1.069388377944818e-14, -2.323145995311039e-15,  9.132064451692702e-18, -1.379082169726773e-19, -4.869795136111034e-22,  7.371589075598374e-24,  4.201106947143931e-25,
  3.351511918897097e-01, -2.400587813646455e-03,  1.145223420910489e-05, -3.838227602207578e-08,  5.124717488948439e-11,  3.804032118846541e-13, -4.441722162859355e-15,
  1.304866741789416e-17, -1.483542239823070e-19, -9.986411933083607e-22,  1.163868093561713e-23,  5.505278247531317e-25,  4.211462014163627e-01, -2.963792030386663e-03,
  1.329403296176997e-05, -3.629428590387141e-08, -2.285221421323527e-11,  9.052244124095338e-13, -6.526088703922938e-15,  9.462798422752446e-18, -9.866010744639317e-20,
 -1.884951369852214e-21,  1.667239504428700e-23,  7.187777977755956e-25,  5.178921521576857e-01, -3.565832284296895e-03,  1.473485569037917e-05, -2.776952238154328e-08,
 -1.398531905255861e-10,  1.521052558861208e-12, -7.446169976957735e-15, -1.018067515230234e-17,  3.577299982570818e-20, -2.970652794426003e-21,  1.925667904554033e-23,
  9.534638019772780e-25,  6.257659992789174e-01, -4.192449178515771e-03,  1.547513681345774e-05, -1.051610521307544e-08, -3.002324047054765e-10,  2.053103483645732e-12,
 -5.271783000446866e-15, -5.494783363307653e-17,  2.245677594217401e-19, -3.448377929098563e-21,  1.287418314117558e-23,  1.279575521657745e-24,  7.451544661993991e-01,
 -4.822418070753797e-03,  1.511298395274120e-05,  1.779587666111790e-08, -4.901962577648172e-10,  2.143498152298224e-12,  2.657936688506255e-15, -1.257237227611091e-16,
  2.845962163224384e-19, -1.535085058313551e-21, -8.045386524528916e-24,  1.644934679781193e-24,  8.764084292217499e-01, -5.423666052801599e-03,  1.311490536592004e-05,
  5.883017373069293e-08, -6.665088581967481e-10,  1.172926606916783e-12,  1.860458529401778e-14, -1.925142508520279e-16, -2.554579700317571e-19,  4.721237984497083e-21,
 -2.693275958870757e-23,  1.770987601991840e-24,  1.019745358612114e+00, -5.946924940142770e-03,  8.795943113589799e-06,  1.118006440294385e-07, -7.303605418996596e-10,
 -1.721183143706560e-12,  4.018520446124871e-14, -1.508046356891362e-16, -2.092438273033075e-18,  1.181176647748472e-20,  4.354731386513333e-23,  1.250832834438412e-24,
  1.175040324978594e+00, -6.315372454805146e-03,  1.357274758192245e-06,  1.692670661761090e-07, -4.923195062811348e-10, -7.135628176625361e-12,  4.909940015532490e-14,
  2.076907928214018e-16, -4.835217348841737e-18, -4.890859972623759e-21,  3.366404194284664e-22,  1.560198439148938e-24,  1.341369809394272e+00, -6.408501668429176e-03,
 -9.861142630884131e-06,  2.081214238999752e-07,  3.281010878017270e-10, -1.323845686514118e-11, -6.443037200402503e-15,  9.417798325961481e-16, -2.257076342748045e-18,
 -8.711184689814030e-20,  3.321465711571776e-22,  1.012673947975307e-23,  1.515990726648827e+00, -6.041869286055873e-03, -2.444199527884765e-05,  1.749317255491611e-07,
  1.844507868442501e-09, -1.026969193106638e-11, -1.783003431800377e-13,  6.393521906881291e-16,  1.743691971596419e-17, -6.111968089779586e-20, -2.051443665292683e-21,
  7.731757013715877e-24,  1.692031993931505e+00, -4.967696849759279e-03, -3.816388021424479e-05, -1.049070552820388e-08,  2.847512048238221e-09,  1.881142285410484e-11,
 -1.943840703035874e-13, -3.564434683871145e-15,  2.576206589631617e-19,  4.579821155750552e-19,  2.844426596135899e-21, -4.376313679636808e-23,  1.853612398560061e+00,
 -3.024916371515761e-03, -3.842765843610272e-05, -2.991328133489009e-07, -2.448471473347041e-10,  3.153105691371685e-11,  4.586788947195368e-13,  1.702611123736821e-15,
 -4.901541492797232e-17, -1.009961699586349e-18, -6.585759090139688e-21,  8.260633518607322e-23,  1.968891510710276e+00, -7.766779670888871e-04, -1.396779727295215e-05,
 -2.112934558799223e-07, -2.774484576166768e-09, -3.113275148307434e-11, -2.750085244308710e-13, -1.265470087972579e-15,  1.631679521861725e-17,  5.826668333375580e-19,
  1.046279223594181e-20,  1.370082070979340e-22,  1.099266169799092e-03, -8.204640295399754e-06,  4.586882686694146e-08, -2.284950952391057e-10,  1.056521750386175e-12,
 -4.856736506707225e-15,  1.866433875076126e-17, -1.189039475003413e-19,  2.374386496461680e-23, -6.708097076988415e-25,  1.610225414473277e-25,  4.210536753285314e-27,
  9.900103062682283e-03, -7.380414793604364e-05,  4.111809376188484e-07, -2.034665227769236e-09,  9.303903057505789e-12, -4.212469564041100e-14,  1.569903868021814e-16,
 -1.002365111399623e-18, -2.045367787703888e-22, -3.765858351786177e-24,  1.441774037505392e-24,  3.809886151011277e-26,  2.753767039026239e-02, -2.047966851234978e-04,
  1.132934469674192e-06, -5.529494560574125e-09,  2.470048917886283e-11, -1.082305809803688e-13,  3.759575605438223e-16, -2.420003751934919e-18, -2.773414409926709e-21,
  1.152619782970946e-24,  3.971527861415082e-24,  1.069202394483595e-25,  5.408433104808593e-02, -4.007402986469391e-04,  2.192739593775881e-06, -1.047166981546157e-08,
  4.502228788629453e-11, -1.864746483918131e-13,  5.649154836976038e-16, -3.734040607738059e-18, -1.132757093781603e-20,  3.147147762321922e-23,  7.723710611214290e-24,
  2.125704650174988e-25,  8.965006599915051e-02, -6.608955614301515e-04,  3.561320290938240e-06, -1.648313770602303e-08,  6.686894448065023e-11, -2.523287508071202e-13,
  5.711110664152139e-16, -4.150995710507591e-18, -2.983236890157312e-20,  1.012658826144587e-22,  1.274594505073295e-23,  3.574844730572367e-25,  1.343841826689340e-01,
 -9.841217646861060e-04,  5.196277919377843e-06, -2.302884998678716e-08,  8.560245225608637e-11, -2.744391801815142e-13,  2.198336181643219e-16, -2.949198238132825e-18,
 -6.065255585825131e-20,  2.075152027319995e-22,  1.924714094220758e-23,  5.443910808673191e-25,  1.884775413862744e-01, -1.368715872333172e-03,  7.038731307274112e-06,
 -2.938833018023494e-08,  9.530138685001144e-11, -2.167223026771800e-13, -6.507112349702533e-16,  1.657683344068785e-19, -1.018945551561548e-19,  3.142785507630513e-22,
  2.766941450141542e-23,  7.764948295779192e-25,  2.521651927492433e-01, -1.812168820832516e-03,  9.008437729170255e-06, -3.461835961418634e-08,  8.878484981760535e-11,
 -4.250502387047562e-14, -2.131206374065908e-15,  4.540866856961400e-18, -1.442339098004314e-19,  3.408930320689397e-22,  3.867498441890341e-23,  1.058693341342111e-24,
  3.257291797240368e-01, -2.310797808832313e-03,  1.099679924525871e-05, -3.750713452678393e-08,  5.781592290171902e-11,  2.776211731195139e-13, -4.147251839394983e-15,
  7.875715671888978e-18, -1.681680672750750e-19,  1.686275573100845e-22,  5.291888683670159e-23,  1.400647719483689e-24,  4.095009724261600e-01, -2.859186787147504e-03,
  1.285687782933300e-05, -3.652351252133687e-08, -6.294612930691164e-12,  7.513647499498680e-13, -6.314177866530407e-15,  5.426532212735966e-18, -1.444059747226107e-19,
 -3.040239608945368e-22,  7.041330477140057e-23,  1.822177093449362e-24,  5.038624194923615e-01, -3.449322167475976e-03,  1.438916769573796e-05, -2.977361061377621e-08,
 -1.112420337516063e-10,  1.338962025116501e-12, -7.729646064802979e-15, -1.049598062005634e-17, -4.403762496866934e-20, -1.003643618000871e-21,  8.933311500372829e-23,
  2.358882657011946e-24,  6.092428942956872e-01, -4.069231446760316e-03,  1.532145262311376e-05, -1.499871143938971e-08, -2.605564516131742e-10,  1.908822292306386e-12,
 -6.726907804922675e-15, -4.951274449124405e-17,  1.272513321100631e-19, -1.355595044084876e-21,  1.047131451155806e-22,  3.056956730465541e-24,  7.261077702276685e-01,
 -4.700790055668277e-03,  1.528089834066728e-05,  1.029798317148466e-08, -4.469684245383233e-10,  2.166025380008674e-12, -7.425988288787067e-16, -1.173883070492268e-16,
  2.461190274562385e-19,  1.720898188012669e-22,  1.100107739687317e-22,  3.924768421519373e-24,  8.549278211881267e-01, -5.316102320637735e-03,  1.375773027425092e-05,
  4.837611325455190e-08, -6.390259680782411e-10,  1.553982316402979e-12,  1.312490759280682e-14, -1.979807029857637e-16, -7.924129601726197e-20,  5.978240390639999e-21,
  1.117817537092134e-22,  4.791189209087380e-24,  9.961066073021365e-01, -5.871391905799938e-03,  1.006646575219840e-05,  9.989032095458662e-08, -7.555191614539486e-10,
 -8.145662268814956e-13,  3.509248558973219e-14, -2.104579567308390e-16, -1.613703987794562e-18,  1.566125379781527e-20,  1.776850055131579e-22,  5.198459242993816e-24,
  1.149813213036477e+00, -6.296533770119210e-03,  3.336719403546576e-06,  1.603139407029851e-07, -6.228678700799878e-10, -5.905008092422586e-12,  5.274166417214266e-14,
  5.293435459613418e-17, -4.743807362214609e-18,  1.093215628037226e-20,  4.845911627124235e-22,  5.691925459062781e-24,  1.315593941112284e+00, -6.477331870882834e-03,
 -7.340928371312149e-06,  2.112532693607106e-07,  6.386750757785122e-11, -1.308759687103470e-11,  1.846774659247796e-14,  8.228622149270133e-16, -5.038821819534664e-18,
 -6.402551454419464e-20,  8.490902095173747e-22,  1.384026914922418e-23,  1.491446158241223e+00, -6.228523905093820e-03, -2.217325366034551e-05,  2.025753866706104e-07,
  1.598087240149025e-09, -1.427360283213234e-11, -1.530249975033680e-13,  1.147280209044917e-15,  1.389105337597816e-17, -1.308852101860622e-19, -1.294696840337919e-21,
  2.719574984240688e-23,  1.671550916019157e+00, -5.272710143222392e-03, -3.800490530106907e-05,  3.779212342765166e-08,  3.169076186390708e-09,  1.296540453492914e-11,
 -2.914616643408933e-13, -3.274636539865689e-15,  1.826426145783990e-17,  5.264476949378827e-19,  4.510567134473683e-22, -6.097139808068001e-23,  1.840875130588066e+00,
 -3.346710733359685e-03, -4.201797392493965e-05, -2.973947076249048e-07,  4.986539559195006e-10,  4.289899348083462e-11,  4.786172905846648e-13, -4.890093709150823e-16,
 -8.887839433012256e-17, -1.160182374006435e-18,  1.781447872154215e-22,  2.335414632133586e-22,  1.965544124989222e+00, -8.993667971573490e-04, -1.679140827332800e-05,
 -2.610357672037683e-07, -3.465613045149388e-09, -3.807657035683507e-11, -2.993287294601819e-13, -3.140360502391744e-16,  4.644918319321053e-17,  1.140523795665807e-18,
  1.790011624899177e-20,  2.009993906872368e-22,  1.067164540383920e-03, -7.848377300847847e-06,  4.322518211537508e-08, -2.123446169683506e-10,  9.635973303412946e-13,
 -4.448626062164266e-15,  1.535328544793032e-17, -1.168659552935635e-19,  1.692401530271307e-22,  1.048122758359170e-23,  4.226441865391973e-25,  7.759681663955698e-27,
  9.611314221281166e-03, -7.060989645133042e-05,  3.876309643075732e-07, -1.892347567498899e-09,  8.496810858680579e-12, -3.869409701719941e-14,  1.289131057735696e-16,
 -9.961361946319231e-19,  1.183799934146396e-21,  9.651657136860973e-23,  3.807775494159615e-24,  7.015609893933643e-26,  2.673619963166227e-02, -1.959920680123974e-04,
  1.068881874412818e-06, -5.151136583634162e-09,  2.262057194393692e-11, -1.000293597875106e-13,  3.072403925613991e-16, -2.466733491399534e-18,  1.490310094165596e-21,
  2.795214339524970e-22,  1.060574302715218e-23,  1.966303471420619e-25,  5.251567476076614e-02, -3.836890548204276e-04,  2.071280909737574e-06, -9.780448749941984e-09,
  4.141970796363888e-11, -1.742085891347980e-13,  4.560034612342346e-16, -3.997513059695266e-18, -1.925556692998506e-21,  5.778732067234910e-22,  2.090279782671754e-23,
  3.904610945745205e-25,  8.706223733747374e-02, -6.331783802646852e-04,  3.369777820062388e-06, -1.545290383956912e-08,  6.194949397970555e-11, -2.401169544019254e-13,
  4.429703750174036e-16, -4.913163807281868e-18, -1.245648278737335e-20,  1.010347077782645e-21,  3.490338844202561e-23,  6.564101132822805e-25,  1.305291181878238e-01,
 -9.436340577034806e-04,  4.927969267775279e-06, -2.170286622799340e-08,  8.015865924390535e-11, -2.703599095923624e-13,  1.125746133003978e-16, -4.567521193353798e-18,
 -3.238772808482199e-20,  1.585666858994639e-21,  5.301155432455519e-23,  1.000714372707073e-24,  1.831131002392194e-01, -1.313791074695486e-03,  6.695074481750020e-06,
 -2.789903691396196e-08,  9.080931994190269e-11, -2.326321799318890e-13, -6.880544014052868e-16, -2.622507000662467e-18, -6.075496816194140e-20,  2.289765687425202e-21,
  7.591469201361226e-23,  1.431461843599599e-24,  2.450580554599246e-01, -1.741738933267311e-03,  8.601503799945399e-06, -3.320734779855576e-08,  8.743095811171638e-11,
 -9.262525148561646e-14, -2.064104393793899e-15,  5.263982539621422e-19, -9.059319939803084e-20,  3.074527302906428e-21,  1.046241763775249e-22,  1.959855866259417e-24,
  3.166591094482172e-01, -2.224607644219269e-03,  1.055242985054029e-05, -3.654300411128564e-08,  6.238781299369762e-11,  1.801488387334804e-13, -3.997450069505879e-15,
  3.140513257157181e-18, -1.060816975617343e-19,  3.857987352954991e-21,  1.403791337216871e-22,  2.603159760160375e-24,  3.982671585573739e-01, -2.758085516449323e-03,
  1.241846074458941e-05, -3.651219929486046e-08,  7.226929851035671e-12,  6.011393038112292e-13, -6.223663319474966e-15,  1.356838566070091e-18, -8.134346272277995e-20,
  4.558959022059484e-21,  1.842495084019948e-22,  3.390194188942465e-24,  4.902930545944115e-01, -3.335666247824338e-03,  1.402205591776407e-05, -3.134943161652637e-08,
 -8.634257007675890e-11,  1.149761536205298e-12, -8.042438811418922e-15, -1.155734505687618e-17,  1.426806551458735e-20,  5.212558644613164e-21,  2.362371432139852e-22,
  4.369060661384055e-24,  5.932098755455448e-01, -3.947447793167341e-03,  1.511768480616287e-05, -1.887143830609076e-08, -2.241044433386646e-10,  1.731191458219696e-12,
 -8.056099139996196e-15, -4.510784063214610e-17,  1.927339433463521e-19,  6.242642211723567e-21,  2.939513441999003e-22,  5.610971632797716e-24,  7.075497197153960e-01,
 -4.578166860576742e-03,  1.536298859592109e-05,  3.490983009834574e-09, -4.040876131867144e-10,  2.109695939925451e-12, -3.910004084503939e-15, -1.081724163125992e-16,
  3.814077638603156e-19,  8.945133239318348e-21,  3.525844390415909e-22,  7.186148038060832e-24,  8.338869700314265e-01, -5.203889776191758e-03,  1.427797305236240e-05,
  3.841556282307608e-08, -6.052458521576881e-10,  1.802413258455583e-12,  7.587187591390810e-15, -1.957270869108666e-16,  2.780865290394499e-19,  1.586811554724229e-20,
  4.140002426051041e-22,  9.054317853575850e-24,  9.727894034055162e-01, -5.786271896774099e-03,  1.119222466967030e-05,  8.771534308758725e-08, -7.638933350676691e-10,
 -4.831281855518786e-14,  2.857430909804467e-14, -2.511631400420351e-16, -8.525208759217224e-19,  2.893532015450470e-20,  5.275878531293120e-22,  1.086371823006152e-23,
  1.124692398875494e+00, -6.262322893313700e-03,  5.197017498932614e-06,  1.494722300183754e-07, -7.282765545949513e-10, -4.638064302284643e-12,  5.218780655434396e-14,
 -8.823043068124937e-17, -3.924170724042499e-18,  3.720402494375214e-20,  8.792819034673039e-22,  1.254125257896204e-23,  1.289583212563683e+00, -6.525921468177125e-03,
 -4.808297103674295e-06,  2.102126970385802e-07, -1.916881684271811e-10, -1.238797369683209e-11,  3.895811322236677e-14,  6.325880501483534e-16, -6.570092642887557e-18,
 -1.613993217440553e-20,  1.592511830998747e-21,  2.028281288459452e-23,  1.466193269790032e+00, -6.395774570698925e-03, -1.959896771001369e-05,  2.256732285059245e-07,
  1.278731241441935e-09, -1.751513294443613e-11, -1.154422077262650e-13,  1.509117019906802e-15,  8.591250106805763e-18, -1.526167943108244e-19,  3.573916987924109e-22,
  4.756438315483988e-23,  1.649856108778220e+00, -5.574056285998248e-03, -3.723992430267777e-05,  9.016197924683247e-08,  3.351422271845059e-09,  4.953597177734600e-12,
 -3.721253285423829e-13, -2.388656485980098e-15,  3.690613627760261e-17,  4.926420131732513e-19, -2.027391475200782e-21, -4.526546237994336e-23,  1.826793680576444e+00,
 -3.696924623834147e-03, -4.550853233021486e-05, -2.819392152991188e-07,  1.468570125224292e-09,  5.386212890216828e-11,  4.189700904344167e-13, -3.976799489946975e-15,
 -1.275671875151315e-16, -8.956365645029899e-19,  1.431462883198823e-20,  4.054160016284334e-22,  1.961656746253277e+00, -1.047230839940330e-03, -2.028293096260359e-05,
 -3.229675817854917e-07, -4.298647120213527e-09, -4.515469016151344e-11, -2.800497619447468e-13,  1.985730168497169e-15,  1.026701570032244e-16,  2.048358937566520e-18,
  2.775916203958146e-20,  2.359873762851928e-22,  1.036446857167005e-03, -7.512512924363475e-06,  4.076667781344882e-08, -1.976199149735869e-10,  8.780496692653668e-13,
 -4.118319241855624e-15,  1.224100942580021e-17, -1.014227954840375e-19,  9.420667581644085e-22,  3.516476632380584e-23,  8.306733510942296e-25,  1.030613527473148e-26,
  9.334936099040970e-03, -6.759742805702241e-05,  3.657134681517655e-07, -1.762430900109171e-09,  7.751648912465243e-12, -3.592618248070268e-14,  1.023212111366189e-16,
 -8.666882403934715e-19,  8.224473520677771e-21,  3.191412890505356e-22,  7.496414494470373e-24,  9.316588806515792e-26,  2.596895047220150e-02, -1.876822643349090e-04,
  1.009175025115008e-06, -4.804834723648473e-09,  2.068820729176244e-11, -9.346635120062399e-14,  2.410415359132195e-16, -2.157731406378528e-18,  2.149978976950822e-20,
  9.007988314704284e-22,  2.094251808111491e-23,  2.610745415210225e-25,  5.101333128262580e-02, -3.675772640441509e-04,  1.957778661572428e-06, -9.145050040078232e-09,
  3.803598009440761e-11, -1.645887531956413e-13,  3.476978959973423e-16, -3.528308078228993e-18,  3.851581619528722e-20,  1.805243650079323e-21,  4.142743853113758e-23,
  5.184134419886289e-25,  8.458228915269796e-02, -6.069454082847371e-04,  3.190133390726893e-06, -1.449960006220988e-08,  5.724227442441828e-11, -2.311367958232638e-13,
  3.075625840172671e-16, -4.398829426126954e-18,  5.675961301462835e-20,  3.064277479469404e-21,  6.941197121960267e-23,  8.718050086979187e-25,  1.268318102875162e-01,
 -9.052306481998372e-04,  4.675052020216910e-06, -2.046348322113560e-08,  7.476779896653408e-11, -2.692402656457728e-13, -1.778924431705057e-17, -4.187516778386306e-18,
  7.462626817264936e-20,  4.709266561398486e-21,  1.056453316223511e-22,  1.330315779620957e-24,  1.779629712024156e-01, -1.261545292044354e-03,  6.368847214777212e-06,
 -2.648423387864375e-08,  8.598487001159770e-11, -2.501459598121294e-13, -7.713637949009378e-16, -2.527446829546173e-18,  9.316737627550331e-20,  6.762152545612317e-21,
  1.512704477104189e-22,  1.906039097036284e-24,  2.382262333950689e-01, -1.674497232612486e-03,  8.211339149900231e-06, -3.182596335518312e-08,  8.508312234245339e-11,
 -1.421788611666732e-13, -2.066500515111191e-15,  3.899511399504937e-19,  1.184798936053416e-19,  9.226976789420907e-21,  2.079234871321651e-22,  2.615487570602054e-24,
  3.079267647560698e-01, -2.141925060039904e-03,  1.012000511377683e-05, -3.552116289722001e-08,  6.503724666041387e-11,  8.505466615390586e-14, -3.927035582352532e-15,
  3.296241736682424e-18,  1.645304744310646e-19,  1.208883498245635e-20,  2.777678641056803e-22,  3.482540287250668e-24,  3.874307408498114e-01, -2.660487589277889e-03,
  1.198137862941899e-05, -3.630849165838271e-08,  1.775844736606414e-11,  4.521433726547800e-13, -6.185477241330423e-15,  3.120640388630996e-18,  2.553755433832299e-19,
  1.533751388660418e-20,  3.633424364595100e-22,  4.544018995020699e-24,  4.771723290030918e-01, -3.225016379409464e-03,  1.363829843088106e-05, -3.255754439107698e-08,
 -6.530246495466231e-11,  9.531598785908721e-13, -8.316091345012461e-15, -5.864265734696276e-18,  4.234726110834912e-19,  1.905432875235242e-20,  4.670356542158698e-22,
  5.858709733576186e-24,  5.776604504251646e-01, -3.827470539074663e-03,  1.487082094176807e-05, -2.219103725145355e-08, -1.915115631477131e-10,  1.523687336713864e-12,
 -9.179795522336812e-15, -3.254864533945729e-17,  6.951594738335205e-19,  2.363705395732224e-20,  5.900808746167303e-22,  7.517493427503249e-24,  6.894829744156975e-01,
 -4.455202127838767e-03,  1.536746112107379e-05, -2.642966190187972e-09, -3.630686331731678e-10,  1.981300311985181e-12, -6.696283738781150e-15, -8.741856414075647e-17,
  1.041877621703354e-18,  3.026743556299047e-20,  7.319370448153613e-22,  9.639335654637518e-24,  8.133025493457112e-01, -5.087983876832316e-03,  1.468207281508342e-05,
  2.902807181563082e-08, -5.678126519005721e-10,  1.920409795007846e-12,  2.344953973630693e-15, -1.736396135704658e-16,  1.254417721393104e-18,  4.157044485726235e-20,
  8.954580367218812e-22,  1.230264148312813e-23,  9.498297646376084e-01, -5.692731385338071e-03,  1.217155720136506e-05,  7.552014799184123e-08, -7.585826324448202e-10,
  5.511301939722557e-13,  2.135135349305060e-14, -2.566702740665493e-16,  6.990394791570744e-19,  6.118753055010476e-20,  1.118462966795083e-21,  1.533463792485406e-23,
  1.099737331069530e+00, -6.213776790370808e-03,  6.917926158987261e-06,  1.371446909707597e-07, -8.087799801906110e-10, -3.427882850968767e-12,  4.821594431234901e-14,
 -1.843811364226818e-16, -1.799839742820555e-18,  8.544494979128073e-20,  1.576402800219116e-21,  1.837515886050327e-23,  1.263418472118674e+00, -6.554368246244364e-03,
 -2.312142886619455e-06,  2.052200045434694e-07, -4.287862990312230e-10, -1.126423871670855e-11,  5.373818379903534e-14,  4.272080147839682e-16, -5.771497003209701e-18,
  6.732809557677866e-20,  2.620386708224076e-21,  2.550747828719577e-23,  1.440314193979124e+00, -6.541413710165285e-03, -1.678013792212655e-05,  2.431948329604490e-07,
  9.042848430527301e-10, -1.975248761255347e-11, -7.011913379920808e-14,  1.703283422441576e-15,  3.903613977060201e-18, -9.170263512553195e-20,  2.783031398124934e-21,
  6.028218684941095e-23,  1.626972189932425e+00, -5.866732044171280e-03, -3.583460240517819e-05,  1.440719243648375e-07,  3.356523593860690e-09, -4.630802442522862e-12,
 -4.199382177379305e-13, -9.427180376212854e-16,  5.281479899219396e-17,  3.845743950905115e-19, -3.007831466819446e-21,  4.716112127555119e-24,  1.811257094254677e+00,
 -4.074041316638693e-03, -4.871362561048839e-05, -2.493243094236792e-07,  2.634853045334488e-09,  6.209498986053977e-11,  2.466239076783995e-13, -8.427142587969766e-15,
 -1.448676113579225e-16,  6.858417591995772e-20,  3.446611455655993e-20,  4.805294717817600e-22,  1.957117006453242e+00, -1.226236847038147e-03, -2.460212729787932e-05,
 -3.993093358146927e-07, -5.262211895763629e-09, -5.076113252642796e-11, -1.657247573374544e-13,  6.684982867726849e-15,  1.987837727416568e-16,  3.350715706664510e-18,
  3.657316529728895e-20,  1.239670316348724e-22,  1.007034382244146e-03, -7.195632588889267e-06,  3.847686276422934e-08, -1.842149759208402e-10,  7.984145743869251e-13,
 -3.853785705577811e-15,  1.006434978211976e-17, -4.373238930964408e-20,  2.913101831687037e-21,  7.709100522164010e-23,  1.240105188090405e-24,  6.658818642976750e-27,
  9.070266763237252e-03, -6.475426232569224e-05,  3.452851556548106e-07, -1.644026837830021e-09,  7.055923625363422e-12, -3.371905834067211e-14,  8.392441091538205e-17,
 -3.538831177338115e-19,  2.607845198008208e-20,  6.976435184947453e-22,  1.119810767537197e-23,  6.022671921008011e-26,  2.523401080724632e-02, -1.798340091298728e-04,
  9.534423548993576e-07, -4.488482403032112e-09,  1.887238828126852e-11, -8.829231051663975e-14,  1.964139837301271e-16, -7.669944386401957e-19,  7.171851987305466e-20,
  1.958916107345980e-21,  3.131845329567847e-23,  1.689489794469912e-25,  4.957366594073476e-02, -3.523438987496614e-04,  1.851582271454334e-06, -8.562385354799602e-09,
  3.482067011905900e-11, -1.572176582016954e-13,  2.784671195921938e-16, -8.920596774754441e-19,  1.387171130667236e-19,  3.900122925959464e-21,  6.203975187623866e-23,
  3.360069499570195e-25,  8.220446920509381e-02, -5.821051009732780e-04,  3.021482094907183e-06, -1.362034117327474e-08,  5.268494598938857e-11, -2.249051194567303e-13,
  2.306595878437622e-16, -2.074582750417923e-19,  2.261078508391738e-19,  6.577219675873330e-21,  1.040964440512385e-22,  5.662229986199015e-25,  1.232841614731943e-01,
 -8.687925519575992e-04,  4.436490064306799e-06, -1.931033277277042e-08,  6.937140160793732e-11, -2.706157332112597e-13, -6.964711272567243e-17,  1.841866105160522e-18,
  3.340505495490207e-19,  1.005941157097643e-20,  1.586143989016434e-22,  8.662200442707290e-25,  1.730167112964623e-01, -1.211842756508002e-03,  6.059122557202184e-06,
 -2.514951984788497e-08,  8.079395199730784e-11, -2.689002854187403e-13, -7.545264845459175e-16,  5.678997724542976e-18,  4.653381554345526e-19,  1.442488923333480e-20,
  2.272408751511551e-22,  1.244857323999292e-24,  2.316572394828190e-01, -1.610311256599068e-03,  7.837493040933643e-06, -3.049006077376255e-08,  8.174821292396606e-11,
 -1.908455577659264e-13, -1.939826330688528e-15,  1.132399961746756e-17,  6.275666161201486e-19,  1.975751782053549e-20,  3.123007637446323e-22,  1.714267953322180e-24,
  2.995183100924588e-01, -2.062652248584779e-03,  9.700034407348917e-06, -3.447203101325679e-08,  6.580841155712913e-11, -7.005520973145945e-15, -3.678591580498420e-15,
  1.796554756240220e-17,  8.359764270121922e-19,  2.614963188227407e-20,  4.169496535235922e-22,  2.292104458940860e-24,  3.769777407650226e-01, -2.566373902448980e-03,
  1.154765396519517e-05, -3.596002550595850e-08,  2.533121171972502e-11,  3.062840216574441e-13, -5.878432332162655e-15,  2.331954369180418e-17,  1.116472041584898e-18,
  3.372432643457029e-20,  5.452504541954983e-22,  3.005995295860772e-24,  4.644879786320437e-01, -3.117489138147472e-03,  1.324193275413671e-05, -3.346074122963739e-08,
 -4.823731632514763e-11,  7.539097550069989e-13, -8.158840211240041e-15,  2.276753542172741e-17,  1.506776232121595e-18,  4.270913638466072e-20,  7.020335672638534e-22,
  3.901444585965978e-24,  5.625867442985552e-01, -3.709618995554685e-03,  1.458710953052944e-05, -2.502365558476357e-08, -1.632978152855156e-10,  1.295914716310424e-12,
 -9.615592052219515e-15,  8.508656985391973e-18,  2.049399291924478e-18,  5.363052982460416e-20,  8.923880040478069e-22,  5.053017581496921e-24,  6.719077088929067e-01,
 -4.332485104875080e-03,  1.530216823279597e-05, -8.144537629142937e-09, -3.252234553677939e-10,  1.796213650518586e-12, -8.468358963347968e-15, -3.016994801269779e-17,
  2.759242020381200e-18,  6.775706298708921e-20,  1.121136352636756e-21,  6.570268831919443e-24,  7.931875189608184e-01, -4.969285460822358e-03,  1.497717276151651e-05,
  2.025184167443108e-08, -5.292051864908301e-10,  1.924537944721827e-12, -1.674584277504548e-15, -1.015865203781662e-16,  3.524665836101973e-18,  8.791545571543525e-20,
  1.395730636951151e-21,  8.559481939428079e-24,  9.272590335648666e-01, -5.591939288338948e-03,  1.300542247506131e-05,  6.349648020147128e-08, -7.429949011780373e-10,
  9.822260632870265e-13,  1.487813089649951e-14, -1.891020376405673e-16,  3.868807024405029e-18,  1.191481008576771e-19,  1.749079504543757e-21,  1.093733413219504e-23,
  1.075003016785647e+00, -6.152075235033042e-03,  8.483955844665282e-06,  1.237167922082692e-07, -8.662038495610767e-10, -2.335843670934827e-12,  4.280535891991243e-14,
 -1.790012861371424e-16,  2.605882938262636e-18,  1.644324605479587e-19,  2.336955522358486e-21,  1.315247125809670e-23,  1.237179414936824e+00, -6.563148106576265e-03,
  1.021365621419024e-07,  1.966309479178716e-07, -6.403005469326102e-10, -9.848833212241760e-12,  6.363560253751183e-14,  3.036994654363327e-16, -1.196100570013506e-18,
  1.936969261333810e-19,  3.637682700460687e-21,  1.685170747792423e-23,  1.413898846751352e+00, -6.663766032487748e-03, -1.378827655767428e-05,  2.544279957877018e-07,
  4.963327634718524e-10, -2.085108194219660e-11, -2.099149256063182e-14,  1.802030077877570e-15,  3.239337763952343e-18,  7.152524982542863e-20,  5.285303364359957e-21,
  4.701847832250692e-23,  1.602944132689773e+00, -6.145591063218713e-03, -3.378835910572852e-05,  1.964823911671853e-07,  3.162022640170464e-09, -1.482310340573225e-11,
 -4.207501733500818e-13,  9.470678854750674e-16,  6.469630455603564e-17,  2.848526224266949e-19, -1.618615152742954e-21,  5.283774191681342e-23,  1.794163700654030e+00,
 -4.474905170731936e-03, -5.141078862543318e-05, -1.969993850707727e-07,  3.914170092914811e-09,  6.467139642026033e-11, -5.173596167429522e-14, -1.271749878968339e-14,
 -1.127488257742327e-16,  1.836467313687225e-18,  5.245088983815541e-20,  2.750946316646317e-22,  1.951785953789388e+00, -1.443730222365690e-03, -2.993300569965180e-05,
 -4.917645113894093e-07, -6.297821786339086e-09, -5.165185769241289e-11,  1.306903583087453e-13,  1.526312332391465e-14,  3.461057276452210e-16,  4.810640507333080e-18,
  3.262448857548482e-20, -4.052437954610981e-22,  9.788537803288040e-04, -6.896448610517052e-06,  3.634042926283916e-08, -1.720440150597631e-10,  7.237217225174584e-13,
 -3.613484567379009e-15,  1.063267664950547e-17,  1.038224832974287e-19,  6.617602450120829e-21,  1.285351488405444e-22,  1.198824756688799e-24, -1.179730448488211e-26,
  8.816651973171725e-03, -6.206902570811162e-05,  3.262122977773509e-07, -1.536419015796948e-09,  6.401479113008722e-12, -3.170308609183951e-14,  9.011156480996718e-17,
  9.721560503848224e-19,  5.958540227526208e-20,  1.162254200476439e-21,  1.082842050772076e-23, -1.065033911156266e-25,  2.452959579588006e-02, -1.724169167108380e-04,
  9.013348653431162e-07, -4.200396550845384e-09,  1.715359103977885e-11, -8.350268071664986e-14,  2.194517124908374e-16,  2.907204930897753e-18,  1.657141824897710e-19,
  3.258703899816623e-21,  3.030115048045212e-23, -2.976992449819598e-25,  4.819327797983691e-02, -3.379330004636585e-04,  1.752073846612614e-06, -8.030043971091090e-09,
  3.174433287056223e-11, -1.501851942115547e-13,  3.402728805465689e-16,  6.290425596630801e-18,  3.256363617797851e-19,  6.475955051495272e-21,  6.007127185789955e-23,
 -5.891270979264455e-25,  7.992337715163256e-02, -5.585730301260990e-04,  2.862948329282590e-06, -1.281305025029871e-08,  4.824699291880222e-11, -2.183729839611904e-13,
  3.676683459447955e-16,  1.165070592088314e-17,  5.409601393279490e-19,  1.090125615611157e-20,  1.008904995746056e-22, -9.868408021083911e-25,  1.198785336168932e-01,
 -8.342090701294012e-04,  4.211246935481997e-06, -1.824373569100685e-08,  6.395437567286585e-11, -2.700807122596576e-13,  1.950517546880192e-16,  1.959716442565516e-17,
  8.151895120366002e-19,  1.665136509560785e-20,  1.538986241629699e-22, -1.499736050693483e-24,  1.682644053462869e-01, -1.164555391754261e-03,  5.764904112394223e-06,
 -2.390073344969624e-08,  7.525870728713648e-11, -2.828736032277944e-13, -2.960356884183093e-16,  3.070053661244046e-17,  1.155173915760509e-18,  2.387363268704840e-20,
  2.207528720954796e-22, -2.140232867254054e-24,  2.253391080895034e-01, -1.549052905461329e-03,  7.479326401156866e-06, -2.921499627249566e-08,  7.750626611978973e-11,
 -2.305811261244571e-13, -1.216890692286133e-15,  4.529092961744433e-17,  1.573279136611287e-18,  3.274947044120553e-20,  3.037977268900772e-22, -2.925022281793877e-24,
  2.914203069927607e-01, -1.986688771627820e-03,  9.292668105575405e-06, -3.342477647764147e-08,  6.484593017828534e-11, -8.524385300526833e-14, -2.635767431733838e-15,
  6.312333683443857e-17,  2.090458161318142e-18,  4.350462058225147e-20,  4.062651468483677e-22, -3.875658564614218e-24,  3.668942849367336e-01, -2.475711444660727e-03,
  1.111874358825399e-05, -3.551307563118009e-08,  3.012514618300301e-11,  1.783512482682980e-13, -4.511724889226726e-15,  8.284663417225102e-17,  2.740167055153045e-18,
  5.643744775640799e-20,  5.324657222417676e-22, -5.018571401304497e-24,  4.522273328896875e-01, -3.013171833878875e-03,  1.283623706636009e-05, -3.412221693705592e-08,
 -3.503069234011031e-11,  5.728166528810859e-13, -6.575155702981228e-15,  1.012209009201432e-16,  3.572142539009424e-18,  7.199252378555046e-20,  6.878748275067011e-22,
 -6.383948485150069e-24,  5.479797000602710e-01, -3.594165782426528e-03,  1.427196435784797e-05, -2.744137334560466e-08, -1.396211718442639e-10,  1.077448435366290e-12,
 -8.118055535065463e-15,  1.121533487305148e-16,  4.652110573344505e-18,  9.094283022687363e-20,  8.789598659506172e-22, -8.003861810754973e-24,  6.548218628029592e-01,
 -4.210544499684955e-03,  1.517436177682739e-05, -1.307183719172499e-08, -2.913377224082556e-10,  1.595387330289373e-12, -7.646201869966896e-15,  1.061837221434460e-16,
  6.045021017698431e-18,  1.148160570458284e-19,  1.112792623285774e-21, -9.916103716832562e-24,  7.735513516412112e-01, -4.848637026757956e-03,  1.517065228442190e-05,
  1.208960465249104e-08, -4.912669975347123e-10,  1.866283752792101e-12, -2.384209640240649e-15,  7.311446417136593e-17,  7.747201692403199e-18,  1.467950909965527e-19,
  1.398350766854517e-21, -1.220601355368750e-23,  9.051039057112673e-01, -5.485048560794868e-03,  1.369675964898359e-05,  5.178362612094888e-08, -7.201175748539464e-10,
  1.294216721959073e-12,  1.206162930051733e-14,  1.747455894045414e-17,  9.485832487242254e-18,  1.931271443393936e-19,  1.761228268649537e-21, -1.519977434170293e-23,
  1.050539524759558e+00, -6.078503985040559e-03,  9.884036852539158e-06,  1.095381558128847e-07, -9.029790817118905e-10, -1.353100430797846e-12,  3.998406520763609e-14,
  1.789793588381350e-17,  1.028761630437784e-17,  2.624164050141392e-19,  2.322996822828310e-21, -2.000537695531453e-23,  1.210943135731698e+00, -6.553081307077799e-03,
  2.394015564435912e-06,  1.848962126825223e-07, -8.213071410558444e-10, -8.216386801028644e-12,  7.285777748084580e-14,  4.060096438833393e-16,  8.492475152934900e-18,
  3.443546921568484e-19,  3.571872228315753e-21, -2.795689493507237e-23,  1.387042655411392e+00, -6.761756483945260e-03, -1.070129556662139e-05,  2.590231855450156e-07,
  7.843639848688607e-11, -2.073375820400362e-11,  3.161414788034162e-14,  1.990926901181749e-15,  9.989611802592253e-18,  3.092373868777156e-19,  6.102830968431569e-21,
 -2.181559322050963e-23,  1.577837267449279e+00, -6.405632744575653e-03, -3.113854171043623e-05,  2.441677414916202e-07,  2.767976481918638e-09, -2.435980575225667e-11,
 -3.637685240509264e-13,  3.173628292177497e-15,  7.436034801449643e-17,  2.666715881282884e-19,  5.075537099719634e-22,  2.369296618633763e-23,  1.775428166725856e+00,
 -4.894485561443191e-03, -5.335690279214379e-05, -1.242201813068876e-07,  5.164544455573788e-09,  5.882495329553411e-11, -4.454154754622961e-13, -1.484758298179851e-14,
 -7.288413414149932e-18,  4.023719672126106e-18,  5.232871641778940e-20, -3.530392530479104e-22,  1.945492211223691e+00, -1.708588555435157e-03, -3.647185305644183e-05,
 -6.004535870337764e-07, -7.257700350953805e-09, -4.196752777847688e-11,  7.406532101094585e-13,  2.930796510811785e-14,  5.355865251959576e-16,  5.425940729022928e-18,
 -1.208969588343289e-20, -1.818387175349892e-21,  9.518366281992832e-04, -6.613791832390041e-06,  3.434304224264920e-08, -1.610272833792474e-10,  6.543822496420060e-13,
 -3.294915994204505e-15,  1.725726906767373e-17,  3.972703885010322e-19,  1.189081207848528e-20,  1.556201356150854e-22, -1.513792495254220e-25, -5.394252447599099e-26,
  8.573480894932041e-03, -5.953138159810181e-05,  3.083693039315786e-07, -1.438936684932256e-09,  5.792536484496762e-12, -2.895697614444947e-14,  1.508334018707128e-16,
  3.617435295997423e-18,  1.072614849148126e-19,  1.406929297872608e-21, -1.366520092720499e-24, -4.872696770805525e-25,  2.385403667895145e-02, -1.654033159244003e-04,
  8.525227714246022e-07, -3.938973437263262e-09,  1.554638386943989e-11, -7.654393809051023e-14,  3.941766168431846e-16,  1.028042450521537e-17,  2.993581412434986e-19,
  3.943579925768505e-21, -3.816661161770081e-24, -1.363589093345994e-24,  4.686898076914695e-02, -3.242934423481294e-04,  1.658663310947524e-06, -7.545636582841928e-09,
  2.884361557759138e-11, -1.384973521264282e-13,  7.002071026222982e-16,  2.082433920763405e-17,  5.911558538299363e-19,  7.834499061659567e-21, -7.531502966149806e-24,
 -2.702892764279383e-24,  7.773393650658844e-02, -5.362716748233160e-04,  2.713681262882378e-06, -1.207540759926985e-08,  4.400593774413469e-11, -2.032907250013412e-13,
  1.000056291234144e-15,  3.588471009097528e-17,  9.878251511111087e-19,  1.318533163317467e-20, -1.252967895805191e-23, -4.536895220926834e-24,  1.166077147841666e-01,
 -8.013778060712606e-04,  3.998284951568200e-06, -1.726317717246281e-08,  5.866174538934452e-11, -2.552752869296010e-13,  1.206450660182010e-15,  5.625755811313480e-17,
  1.497719846619187e-18,  2.014150157215031e-20, -1.878565542461734e-23, -6.911316689466552e-24,  1.636966341208071e-01, -1.119563354374896e-03,  5.485133202667720e-06,
 -2.274186180059088e-08,  6.962497484831628e-11, -2.746374186270491e-13,  1.220859640269076e-15,  8.282869560579791e-17,  2.133945690305521e-18,  2.889319553802696e-20,
 -2.618404264479665e-23, -9.889308961105447e-24,  2.192603746408587e-01, -1.490599890554416e-03,  7.136031180224438e-06, -2.801282759171275e-08,  7.273961145870909e-11,
 -2.377154507983916e-13,  9.478673016657274e-16,  1.164441358335221e-16,  2.916761356763222e-18,  3.968392683116729e-20, -3.446526543620006e-23, -1.355641593808441e-23,
  2.836197190191795e-01, -1.913934326258651e-03,  8.897730614565404e-06, -3.240356117585548e-08,  6.269721157792748e-11, -1.181862799440974e-13,  3.231288203260441e-16,
  1.576811944508116e-16,  3.877142768365577e-18,  5.282668374351248e-20, -4.317911777715992e-23, -1.802766087991947e-23,  3.571666519448157e-01, -2.388457691947307e-03,
  1.069557998831722e-05, -3.500742804736475e-08,  3.285691546626423e-11,  1.098237362733050e-13, -6.334277103035212e-16,  2.064604228350076e-16,  5.061832893976652e-18,
  6.873734175257709e-20, -5.169362083426335e-23, -2.345769166903540e-23,  4.403774196918019e-01, -2.912128511292830e-03,  1.242376106498778e-05, -3.459840295468990e-08,
 -2.484527881817854e-11,  4.645050749534898e-13, -1.717950323309253e-15,  2.614267351399119e-16,  6.539807581586055e-18,  8.800872481516110e-20, -5.937370598106713e-23,
 -3.005565451240649e-23,  5.338292512820476e-01, -3.481343654826144e-03,  1.392994480540715e-05, -2.951209500345338e-08, -1.196655901450776e-10,  9.403637687621894e-13,
 -2.359081240080668e-15,  3.190794446394904e-16,  8.408385195755085e-18,  1.115813980514449e-19, -6.616286289494398e-23, -3.810859138625444e-23,  6.382213723831205e-01,
 -4.089853930511377e-03,  1.499055578840766e-05, -1.748649359365222e-08, -2.608940403457137e-10,  1.473510702838925e-12, -1.289773869410125e-15,  3.729628936885903e-16,
  1.079140876921720e-17,  1.411419019091446e-19, -7.388399781957445e-23, -4.802447317206040e-23,  7.544002678556602e-01, -4.726822309799429e-03,  1.526979084358208e-05,
  4.526095173433602e-09, -4.541809215434554e-10,  1.866873917082820e-12,  3.995822204206692e-15,  4.146499951694532e-16,  1.380420221266566e-17,  1.800256628562551e-19,
 -8.784742781689543e-23, -6.043280426879300e-23,  8.833865213795786e-01, -5.373182668502084e-03,  1.424993913523012e-05,  4.048541811937124e-08, -6.910926629837555e-10,
  1.630730634298801e-12,  1.793100808638073e-14,  4.436967425455281e-16,  1.741214012724556e-17,  2.350237431947709e-19, -1.123864801406954e-22, -7.647519208862540e-23,
  1.026391629284747e+00, -5.994421183048350e-03,  1.111108690934436e-05,  9.492709093529881e-08, -9.201728843990884e-10, -3.409611870228963e-13,  4.662685994945820e-14,
  5.133716849130936e-16,  2.102447666285906e-17,  3.182865430619961e-19, -1.020344563757346e-22, -9.867268898655560e-23,  1.184782835821234e+00, -6.525289409581391e-03,
  4.528821796641709e-06,  1.705402565087418e-07, -9.670175424042683e-10, -6.288317323716382e-12,  9.006994673920785e-14,  8.998294097679909e-16,  2.293746166004636e-17,
  4.367493619169189e-19,  2.872518315752793e-22, -1.324700814909243e-22,  1.359844083533623e+00, -6.834943551103485e-03, -7.598984515919164e-06,  2.570217426133051e-07,
 -3.238997395304854e-10, -1.925805948532701e-11,  9.382353112517582e-14,  2.531773270096223e-15,  2.494571399437589e-17,  4.955795831114511e-19,  2.090451549054432e-21,
 -1.761768023382399e-22,  1.551736086962476e+00, -6.642308075770460e-03, -2.796032265146503e-05,  2.841186077782866e-07,  2.202101558736568e-09, -3.174600235367237e-11,
 -2.401212125342632e-13,  5.710478039099651e-15,  8.422127244853075e-17,  2.661799275932149e-19, -1.890517867603106e-21, -1.631807307644759e-22,  1.754989168767936e+00,
 -5.325813653332615e-03, -5.431518901030076e-05, -3.289627437181515e-08,  6.200950597215443e-09,  4.326708711412320e-11, -8.400094435996153e-13, -1.240532937901168e-14,
  1.690763215813804e-16,  5.536573273711967e-18,  1.623262256591266e-20, -1.318314147272554e-21,  1.938025811591305e+00, -2.031215227825562e-03, -4.439775423606558e-05,
 -7.220096871414207e-07, -7.842075461275066e-09, -1.223514232997315e-11,  1.828817398250194e-12,  4.928204598891606e-14,  6.967002109104152e-16,  2.637687707670609e-18,
 -1.472497077767633e-19, -4.547596610188929e-21,  9.259189563629067e-04, -6.346603652003142e-06,  3.247144612610818e-08, -1.510572300350934e-10,  5.937702879837831e-13,
 -2.699260755610035e-15,  3.450981695012620e-17,  8.605563820672109e-19,  1.665130798674557e-20,  8.415866266761320e-23, -3.897341107708794e-24, -1.187856742938931e-25,
  8.340182086372983e-03, -5.713196309298374e-05,  2.916397849086061e-07, -1.350650528335730e-09,  5.259999201887445e-12, -2.368844637122037e-14,  3.074248345080186e-16,
  7.798257229452696e-18,  1.503069348570554e-19,  7.614096439248542e-22, -3.520708782849033e-23, -1.073150654465300e-24,  2.320577023893266e-02, -1.587680882981744e-04,
  8.066990069242615e-07, -3.701845331038082e-09,  1.413955996650864e-11, -6.242025973486459e-14,  8.364647680343931e-16,  2.195810775975806e-17,  4.200514116946898e-19,
  2.137242456530985e-21, -9.853260193675041e-23, -3.003934337872301e-24,  4.559778295162081e-02, -3.113786843850754e-04,  1.570796849878545e-06, -7.105145268797477e-09,
  2.630107234680726e-11, -1.123059721986121e-13,  1.588508913510691e-15,  4.391075505688819e-17,  8.310449408196818e-19,  4.254782749848657e-21, -1.953217028148779e-22,
 -5.956702343082237e-24,  7.563136748048273e-02, -5.151301732231398e-04,  2.572872094234098e-06, -1.140212365577788e-08,  4.028179653895053e-11, -1.632362715142021e-13,
  2.515351725889426e-15,  7.451451889119804e-17,  1.391812144200020e-18,  7.179919139415803e-21, -3.278401240324725e-22, -1.000362817787292e-23,  1.134648861488025e-01,
 -7.702045776816417e-04,  3.796596683713663e-06, -1.636321867635678e-08,  5.400413899535079e-11, -2.013545519047045e-13,  3.556511901689509e-15,  1.149118402706640e-16,
  2.115332783247046e-18,  1.100290400099099e-20, -4.992984701083155e-22, -1.524862091992207e-23,  1.593044406571926e-01, -1.076755362711883e-03,  5.218741269955068e-06,
 -2.166927278646638e-08,  6.465694150360191e-11, -2.088607040840339e-13,  4.645130911290134e-15,  1.665116378703891e-16,  3.020775610202268e-18,  1.584094444092222e-20,
 -7.140499283517627e-22, -2.183517178687766e-23,  2.134100500760672e-01, -1.434836818627811e-03,  6.806710885366246e-06, -2.688447740926672e-08,  6.853685427144822e-11,
 -1.640175673418701e-13,  5.719838140466609e-15,  2.309413677354454e-16,  4.136177729981586e-18,  2.184273606706728e-20, -9.778954322244013e-22, -2.995804865470933e-23,
  2.761039065860565e-01, -1.844290966988635e-03,  8.514834931737480e-06, -3.141711883861529e-08,  6.084838491678064e-11, -4.173007957505056e-14,  6.747980635835568e-15,
  3.099410696039721e-16,  5.502523377508439e-18,  2.919741900343372e-20, -1.298565149963256e-21, -3.988068145003628e-23,  3.477813027362964e-01, -2.304564298744648e-03,
  1.027872114964658e-05, -3.446264809525025e-08,  3.547368073805370e-11,  1.845096232293759e-13,  7.770395402223104e-15,  4.051549433644420e-16,  7.179843447570510e-18,
  3.815433319157623e-20, -1.686509700433144e-21, -5.196131435131869e-23,  4.289250477342641e-01, -2.814405198325079e-03,  1.200650230431986e-05, -3.492089582232522e-08,
 -1.524022786206627e-11,  5.375979402190542e-13,  8.987010212886892e-15,  5.177589788896891e-16,  9.255999019427052e-18,  4.906989810927832e-20, -2.156266838429913e-21,
 -6.669331668856179e-23,  5.201244687893567e-01, -3.371351799151467e-03,  1.356493216275041e-05, -3.127573121178926e-08, -1.005283035930137e-10,  1.024959736636758e-12,
  1.091968115595784e-14,  6.478777205557593e-16,  1.185817207738143e-17,  6.252330079966002e-20, -2.728937933529518e-21, -8.476993510680546e-23,  6.221003793611418e-01,
 -3.970837549581390e-03,  1.475665062707696e-05, -2.142240673818754e-08, -2.306663535210808e-10,  1.611448287800158e-12,  1.471895587362887e-14,  7.939312946709280e-16,
  1.516382640194085e-17,  7.960636019481375e-20, -3.436807288351431e-21, -1.071958014065708e-22,  7.357374686601196e-01, -4.604567372684109e-03,  1.528176474475554e-05,
 -2.431968390635756e-09, -4.146612019254964e-10,  2.157825437693423e-12,  2.272376748844051e-14,  9.529947988106165e-16,  1.939567260772734e-17,  1.026430624484885e-19,
 -4.331744649669237e-21, -1.355023637703762e-22,  8.621246047347161e-01, -5.257425176018197e-03,  1.467058576324467e-05,  2.971768954460690e-08, -6.528104501681679e-10,
  2.280715113765764e-12,  3.937531134738116e-14,  1.127274165063397e-15,  2.474494552840490e-17,  1.368663726456344e-19, -5.497636102359513e-21, -1.722388578230562e-22,
  1.002598582906680e+00, -5.901226367387147e-03,  1.216186425933693e-05,  8.021696089693324e-08, -9.142003857772930e-10,  1.036913871502488e-12,  7.207835189355543e-14,
  1.358229616758070e-15,  3.105859438797228e-17,  1.933860899227607e-19, -7.049306858548544e-21, -2.222913251794952e-22,  1.158766717475667e+00, -6.481144677604907e-03,
  6.478728758067207e-06,  1.541895391462220e-07, -1.068636742728397e-09, -3.727076797437236e-12,  1.278418299585738e-13,  1.873589485078661e-15,  3.705897674152746e-17,
  2.866065943895635e-19, -8.996160059931667e-21, -2.964070586305071e-22,  1.332402097414635e+00, -6.883514834697291e-03, -4.558061759314200e-06,  2.489063418467251e-07,
 -6.802643898644485e-10, -1.604879806051964e-11,  1.785796150725486e-13,  3.612660002310529e-15,  4.183836958639358e-17,  3.588930249580787e-19, -1.065778243993463e-20,
 -4.126221987944268e-22,  1.524741862292590e+00, -6.851803987892924e-03, -2.436130228061624e-05,  3.140197019933973e-07,  1.524111977469436e-09, -3.527776106689168e-11,
 -4.126810340161369e-14,  8.524771106446349e-15,  8.986705250759451e-17, -4.803078153267095e-20, -1.643086587066029e-20, -5.192293727806283e-22,  1.732816829269185e+00,
 -5.760169411996234e-03, -5.408993598646288e-05,  7.204157563972162e-08,  6.840502322424392e-09,  1.973556439426917e-11, -1.081498462033608e-12, -3.811419641076526e-15,
  3.634668912621250e-16,  4.740479783934283e-18, -6.250979178967833e-20, -2.196238410072452e-21,  1.929132700578874e+00, -2.423187359097066e-03, -5.381366747359576e-05,
 -8.465406093700163e-07, -7.522880683296731e-09,  5.077079932530189e-11,  3.524441937156344e-12,  7.150685543642631e-14,  6.281599188841524e-16, -8.270511147760348e-18,
 -4.228735262503858e-19, -7.875366391314071e-21,  9.010408275651182e-04, -6.093925089867538e-06,  3.071415061608882e-08, -1.419344874450545e-10,  5.503374325031883e-13,
 -1.520218466397293e-15,  6.624109454699516e-17,  1.400385098818504e-18,  1.543832940101704e-20, -1.952800413937818e-22, -1.048040295795637e-23, -1.729328218040709e-25,
  8.116219797265886e-03, -5.486227831215492e-05,  2.759228295460343e-07, -1.269795583258218e-09,  4.880571756545134e-12, -1.313340177071429e-14,  5.947088520443085e-16,
  1.267184887718553e-17,  1.393894100084812e-19, -1.763067285189496e-21, -9.468440562287428e-23, -1.562532955662917e-24,  2.258332904443321e-02, -1.524884254996140e-04,
  7.635972348674684e-07, -3.484271906009050e-09,  1.314973761370585e-11, -3.341133624219720e-14,  1.643973360526641e-15,  3.558179455672475e-17,  3.897155633712067e-19,
 -4.928731484711739e-21, -2.650405146743100e-22, -4.374915475586320e-24,  4.437687086693821e-02, -2.991463576151436e-04,  1.487993872556901e-06, -6.699752381046290e-09,
  2.455167532759230e-11, -5.634886452301757e-14,  3.199332431745067e-15,  7.087525822992271e-17,  7.715317001132255e-19, -9.754952510386838e-21, -5.255630007741336e-22,
 -8.678657452186366e-24,  7.361116135236866e-02, -4.950837646681500e-04,  2.439818712519726e-06, -1.077965078306841e-08,  3.781637447217523e-11, -7.267298855337190e-14,
  5.240624660558465e-15,  1.196968374358756e-16,  1.293223379831102e-18, -1.634233536090073e-20, -8.825833570611395e-22, -1.458243928431133e-23,  1.104435901597264e-01,
 -7.406028195092493e-04,  3.605307912985067e-06, -1.552549685560309e-08,  5.113170046408024e-11, -6.954598463974198e-14,  7.745426559593580e-15,  1.836214887624055e-16,
  1.967441127166631e-18, -2.483829364189970e-20, -1.345167686068030e-21, -2.224287483596383e-23,  1.550792966717787e-01, -1.036028240388032e-03,  4.964803650323887e-06,
 -2.066033605654667e-08,  6.203001598399917e-11, -3.022727401516260e-14,  1.069523264704563e-14,  2.646915733987924e-16,  2.812689180462054e-18, -3.545066116862464e-20,
 -1.925760461788203e-21, -3.187656749228763e-23,  2.077775930205773e-01, -1.381655133253597e-03,  6.490599272406783e-06, -2.580419812585907e-08,  6.723221424317212e-11,
  6.619850836599018e-14,  1.408717988731637e-14,  3.654537762777129e-16,  3.855804816862666e-18, -4.846777231735429e-20, -2.641157929653199e-21, -4.377823426280597e-23,
  2.688606157497721e-01, -1.777663748605730e-03,  8.143680854848876e-06, -3.043810531874786e-08,  6.244159668304569e-11,  2.447791504083309e-13,  1.795615035321542e-14,
  4.889834209517536e-16,  5.135798656905419e-18, -6.428730263920923e-20, -3.513989844752729e-21, -5.834795643121404e-23,  3.387249000186855e-01, -2.223978720443271e-03,
  9.868741132138124e-06, -3.385108015995542e-08,  4.208514168786031e-11,  5.337767014362556e-13,  2.241648906783331e-14,  6.388739436921517e-16,  6.709771930553938e-18,
 -8.345621586735965e-20, -4.575027918876100e-21, -7.613273585732124e-23,  4.178568723435662e-01, -2.720032607976747e-03,  1.158639621740447e-05, -3.506145966175990e-08,
 -9.798685815112388e-13,  9.616053569022690e-13,  2.774126944894839e-14,  8.191580887128344e-16,  8.661902127334883e-18, -1.067220639300732e-19, -5.866911379114274e-21,
 -9.789146042958098e-23,  5.068536871606092e-01, -3.264359236375725e-03,  1.318071401920524e-05, -3.269899430418362e-08, -7.571193946031299e-11,  1.548728085617601e-12,
  3.451440166748670e-14,  1.034133518159001e-15,  1.111650740758428e-17, -1.350865198635825e-19, -7.450432965443295e-21, -1.247002183026235e-22,  6.064514223310989e-01,
 -3.853872745621038e-03,  1.447858658308163e-05, -2.482747577272122e-08, -1.928138336381250e-10,  2.287747231690860e-12,  4.392527539659916e-14,  1.288180942688332e-15,
  1.425473014226113e-17, -1.698205913526108e-19, -9.415682337792334e-21, -1.581322633382220e-22,  7.175633679737351e-01, -4.482539254368999e-03,  1.521432169257981e-05,
 -8.681299916095594e-09, -3.635180017828819e-10,  3.095440989177138e-12,  5.833957382689339e-14,  1.586291120414100e-15,  1.832672051894043e-17, -2.123088595212448e-19,
 -1.190270762887473e-20, -2.005911000635244e-22,  8.413316463317299e-01, -5.138807745015939e-03,  1.496623311704204e-05,  1.970136390168839e-08, -5.947144676256260e-10,
  3.696599644215583e-12,  8.236822868707850e-14,  1.938909134394091e-15,  2.362050480715241e-17, -2.633690555553533e-19, -1.514043561524067e-20, -2.560069022819477e-22,
  9.791940156368464e-01, -5.800327442319087e-03,  1.303773370309127e-05,  6.586466124916288e-08, -8.724838557885795e-10,  3.339437899847863e-12,  1.245594678089226e-13,
  2.387643897000847e-15,  3.024155343885083e-17, -3.215371807862123e-19, -1.951338216614735e-20, -3.315554918969516e-22,  1.132957100489122e+00, -6.422208902256224e-03,
  8.224548980365849e-06,  1.366820645330845e-07, -1.107525168447160e-09,  1.110204833908901e-13,  1.977978569899249e-13,  3.126544256181903e-15,  3.729583794825079e-17,
 -3.837767140263157e-19, -2.561450852688001e-20, -4.425539205416462e-22,  1.304813734714000e+00, -6.908239555298252e-03, -1.646228139064226e-06,  2.357244025927900e-07,
 -9.493689797605238e-10, -1.038971039569584e-11,  2.996060610107261e-13,  5.036036755708935e-15,  4.204890642405035e-17, -5.018315127113948e-19, -3.395107343444902e-20,
 -6.234746282240708e-22,  1.496969245643079e+00, -7.031260447378975e-03, -2.046997307807094e-05,  3.327941658376206e-07,  8.296387829327475e-10, -3.308628402562035e-11,
  2.362278481503189e-13,  1.119423000875107e-14,  6.973030467568520e-17, -1.278447387790456e-18, -4.773310191128556e-20, -8.742243818416002e-22,  1.708918842468470e+00,
 -6.187549529735690e-03, -5.256032986057174e-05,  1.832262019211716e-07,  6.974392889308517e-09, -6.051151913808042e-12, -1.004308001233600e-12,  9.870016223075193e-15,
  4.646247279278627e-16,  1.890182819649594e-19, -1.661584110277126e-19, -2.335126203200188e-21,  1.918511850247442e+00, -2.896266311462068e-03, -6.464400721194813e-05,
 -9.534706959997247e-07, -5.489330575551613e-09,  1.612458674303207e-10,  5.735920461904769e-12,  8.286961240704915e-14, -6.196143862063820e-17, -3.250969682802657e-17,
 -7.862255494949642e-19, -7.307161353159303e-21,  };
  constexpr double w[8064] = {  1.458360194812409e-01, -9.396229347619806e-04,  6.553270989324980e-06, -4.792477532464067e-08,  3.583088890740087e-10,
 -2.696511538001052e-12,  2.025616974580649e-14, -1.513002432952851e-16,  1.121882773374831e-18, -8.255030797269369e-21,  6.028387981998798e-23, -4.370593492012882e-25,
  1.435889568470841e-01, -1.644943661749971e-03,  2.113052034597510e-05, -2.578430758300635e-07,  2.971689870432337e-09, -3.271315580682931e-11,  3.470493913670268e-13,
 -3.570155411489491e-15,  3.576954061668617e-17, -3.501813374210291e-19,  3.358399801393902e-21, -3.161410127704544e-23,  1.392379736414512e-01, -2.977646519605426e-03,
  5.852260313316925e-05, -1.003413890271752e-06,  1.565568287492785e-08, -2.275979952295090e-10,  3.127222197152205e-12, -4.100203765313312e-14,  5.165341309068675e-16,
 -6.284677612139018e-18,  7.414737964124129e-20, -8.508761005203581e-22,  1.330499251721942e-01, -4.794295388717421e-03,  1.323598713641847e-04, -3.033865637859027e-06,
  6.140137976626782e-08, -1.132264539537629e-09,  1.939276055825844e-11, -3.124957138953302e-13,  4.781298531243323e-15, -6.993810236082828e-17,  9.831881484841766e-19,
 -1.333686972795916e-20,  1.253806635100101e-01, -6.907941883151159e-03,  2.569036732654749e-04, -7.616639859857856e-06,  1.940326281415211e-07, -4.415004581225966e-09,
  9.187102909381639e-11, -1.776036619108460e-12,  3.225553667261232e-14, -5.549353362273195e-16,  9.102097418854126e-18, -1.430212327792044e-19,  1.166320863274378e-01,
 -9.114769998219368e-03,  4.418700950711567e-04, -1.648924574453735e-05,  5.163241427266124e-07, -1.418971071745572e-08,  3.517330852561712e-10, -8.008373810251797e-12,
  1.696585336224115e-13, -3.376561938752916e-15,  6.359861736922966e-17, -1.140007367986077e-18,  1.072089296977478e-01, -1.121998243529862e-02,  6.883701473612980e-04,
 -3.157594875262807e-05,  1.190999057086536e-06, -3.882727501179315e-08,  1.127765644822266e-09, -2.978247701217069e-11,  7.254713676342679e-13, -1.647602330884090e-14,
  3.517568335047248e-16, -7.103553797859312e-18,  9.748218689578639e-02, -1.305843010921295e-02,  9.870216942008802e-04, -5.448563375555811e-05,  2.431416433483759e-06,
 -9.254261813965431e-08,  3.104401061768721e-09, -9.382411144425991e-11,  2.595114165366219e-12, -6.646262107867855e-14,  1.590348686861210e-15, -3.579460545210726e-17,
  8.776352804693902e-02, -1.450737191056342e-02,  1.318541904622519e-03, -8.591892905262990e-05,  4.462294142097445e-06, -1.954297837716202e-07,  7.472449002059440e-09,
 -2.553418274211599e-10,  7.929134498602383e-12, -2.265695046221227e-13,  6.015151008441950e-15, -1.494412506640969e-16,  7.829211546090269e-02, -1.549089111977779e-02,
  1.656409928430562e-03, -1.251716562363981e-04,  7.451841611263357e-06, -3.704996420631592e-07,  1.595080972672260e-08, -6.093536976371167e-10,  2.102201526987730e-11,
 -6.636178866281819e-13,  1.936587804164145e-14, -5.263784972522687e-16,  6.923263266383554e-02, -1.597724818866721e-02,  1.970728195550158e-03, -1.699032349576439e-04,
  1.143081180482793e-05, -6.370678497509361e-07,  3.052772376153369e-08, -1.290001487688666e-09,  4.895457365051685e-11, -1.691469742306699e-12,  5.378221686701733e-14,
 -1.586014268009548e-15,  6.068170928833918e-02, -1.597145380315661e-02,  2.232294250856140e-03, -2.162570937596431e-04,  1.622415408685172e-05, -1.001466105255212e-06,
  5.283117867091618e-08, -2.444484343067338e-09,  1.010828071270804e-10, -3.788906697391833e-12,  1.301655574490017e-13, -4.131508560812869e-15,  5.267934882153327e-02,
 -1.550556080626979e-02,  2.416070620728305e-03, -2.593148757578807e-04,  2.142165601118332e-05, -1.447829618556496e-06,  8.320415038614288e-08, -4.174475750270370e-09,
  1.863867119991579e-10, -7.514324935403200e-12,  2.766674248100442e-13, -9.379350545202022e-15,  4.522224520618332e-02, -1.462879555436696e-02,  2.503574530045959e-03,
 -2.937789194055631e-04,  2.640433043662472e-05, -1.932694114285251e-06,  1.197724201814586e-07, -6.454579861872912e-09,  3.084294953723848e-10, -1.326309898249418e-11,
  5.192438755948306e-13, -1.866104509496403e-14,  3.827664757663686e-02, -1.339897153968951e-02,  2.484060690287314e-03, -3.147337510061537e-04,  3.042721538172168e-05,
 -2.386638508190887e-06,  1.579349889555310e-07, -9.058362300063973e-09,  4.592588431015291e-10, -2.089376228748412e-11,  8.630687079009425e-13, -3.264183629610126e-14,
  3.178934807842160e-02, -1.187591618014999e-02,  2.354639683006811e-03, -3.183407625093462e-04,  3.274294207136020e-05, -2.724240623055369e-06,  1.906711257284425e-07,
 -1.153493937217995e-08,  6.152668351943241e-10, -2.937729845841527e-11,  1.270696658150297e-12, -5.021126317217432e-14,  2.569617824658469e-02, -1.011706689230379e-02,
  2.119621736740642e-03, -3.023576494412767e-04,  3.273938694733380e-05, -2.860875251908226e-06,  2.098142652018252e-07, -1.327089764872718e-08,  7.385340054122561e-10,
 -3.671786013734064e-11,  1.650630857023706e-12, -6.766171220903835e-14,  1.992798785289030e-02, -8.175023350750665e-03,  1.789409934588112e-03, -2.664257270622068e-04,
  3.006166931372116e-05, -2.732421139540925e-06,  2.080707804939993e-07, -1.364112015175490e-08,  7.855486824536600e-10, -4.035033545689540e-11,  1.871267946479932e-12,
 -7.901241707593833e-14,  1.441444933287211e-02, -6.096677131126424e-03,  1.379224899457093e-03, -2.121168180923527e-04,  2.469332780262395e-05, -2.312665817028906e-06,
  1.812174546395508e-07, -1.220959786603774e-08,  7.216835202191334e-10, -3.800380030085811e-11,  1.804804625706562e-12, -7.794888762265055e-14,  9.086418941723710e-03,
 -3.923611887951046e-03,  9.078845415047466e-04, -1.427700080779370e-04,  1.698159827083855e-05, -1.623564260253537e-06,  1.297557473661473e-07, -8.908754907272231e-09,
  5.361463290621110e-10, -2.872310150621777e-11,  1.386643421694677e-12, -6.083231712028245e-14,  3.882640130626526e-03, -1.695724038253485e-03,  3.972910462391038e-04,
 -6.325003012289774e-05,  7.613289441346710e-06, -7.362537281291642e-07,  5.948905585585299e-08, -4.127346630092075e-09,  2.508869762692950e-10, -1.356976034786520e-11,
  6.610970632305473e-13, -2.925537644835911e-14,  1.421788701896954e-01, -8.894036299987703e-04,  6.010873435941778e-06, -4.259823165365284e-08,  3.089168483327163e-10,
 -2.257402458897569e-12,  1.648080272386056e-14, -1.197246171961369e-16,  8.638474097584174e-19, -6.187697335609057e-21,  4.400089024645239e-23, -3.107153535350618e-25,
  1.373287535322431e-01, -1.487514610552251e-03,  1.830147334412985e-05, -2.151093918640060e-07,  2.393243698095186e-09, -2.546498454298367e-11,  2.613848336468945e-13,
 -2.603800099927365e-15,  2.528009780108943e-17, -2.399813561647549e-19,  2.232948791429684e-21, -2.040369853717564e-23,  1.281930765963773e-01, -2.553692480823011e-03,
  4.784658560107647e-05, -7.856199713114145e-07,  1.177009864117295e-08, -1.646438233897966e-10,  2.180253080648262e-12, -2.758641071351413e-14,  3.357446344402156e-16,
 -3.950260991574905e-18,  4.510596645651258e-20, -5.013340323915495e-22,  1.157814271843576e-01, -3.865911142176808e-03,  1.011751967023302e-04, -2.210008972984465e-06,
  4.278199603590678e-08, -7.566286400684464e-10,  1.245452444448188e-11, -1.932034633920140e-13,  2.849797237736672e-15, -4.023541051772408e-17,  5.465413545242839e-19,
 -7.170545314356948e-21,  1.013470383395388e-01, -5.171542983074875e-03,  1.815636703142307e-04, -5.113742120469457e-06,  1.242862486138189e-07, -2.706433524414285e-09,
  5.402690510958360e-11, -1.003930396750110e-12,  1.755484831781614e-14, -2.912052908444204e-16,  4.611167826001164e-18, -7.002914053903540e-20,  8.616291771080391e-02,
 -6.249779543206987e-03,  2.855022068627773e-04, -1.010623913594829e-05,  3.015337374294704e-07, -7.922365915221302e-09,  1.882356302943993e-10, -4.116976278808539e-12,
  8.393654969935106e-14, -1.610208650826967e-15,  2.927500647590415e-17, -5.071689725164351e-19,  7.133320580978597e-02, -6.955415801779503e-03,  4.022576669101156e-04,
 -1.750422722148219e-05,  6.291129193642803e-07, -1.960873513450517e-08,  5.460131254227657e-10, -1.385466340301186e-11,  3.248956733817369e-13, -7.115335701412179e-15,
  1.467076860987122e-16, -2.865132038213226e-18,  5.767655163458946e-02, -7.234421486179015e-03,  5.165566808375265e-04, -2.709056640352680e-05,  1.153326557646021e-06,
 -4.201572233716424e-08,  1.352655771399131e-09, -3.932276374561898e-11,  1.048220545109013e-12, -2.591695670560672e-14,  5.996141909812914e-16, -1.306707789880322e-17,
  4.568993464164235e-02, -7.113412969060494e-03,  6.128928258474633e-04, -3.804435512815253e-05,  1.889327994884102e-06, -7.936190379592846e-08,  2.917848421275709e-09,
 -9.608308989079801e-11,  2.880724330050117e-12, -7.960845937615547e-14,  2.047109751813735e-15, -4.932956946250399e-17,  3.557782344622649e-02, -6.673063483994091e-03,
  6.794893081738437e-04, -4.909361989192337e-05,  2.803593317300591e-06, -1.340802128013479e-07,  5.565484615440233e-09, -2.054078935564057e-10,  6.858494685863914e-12,
 -2.098818254960368e-13,  5.945977992023093e-15, -1.571077390328157e-16,  2.731975214368351e-02, -6.017466370711512e-03,  7.105206886032107e-04, -5.882668875823986e-05,
  3.811354478103797e-06, -2.050495125867757e-07,  9.504853335647055e-09, -3.892412597915106e-10,  1.433878517769684e-11, -4.816317694881886e-13,  1.490744964231119e-14,
 -4.284812393886068e-16,  2.074942853612148e-02, -5.248633794704675e-03,  7.062403310554645e-04, -6.602913353297180e-05,  4.791595888735248e-06, -2.866740084538558e-07,
  1.468452534128275e-08, -6.608081476855525e-10,  2.661432810984434e-11, -9.729157689102109e-13,  3.263651782334326e-14, -1.012647054089974e-15,  1.562598665835340e-02,
 -4.450467027559301e-03,  6.715348337849993e-04, -6.992229412406607e-05,  5.613779505937898e-06, -3.693652771308022e-07,  2.069546984577878e-08, -1.013721232844747e-09,
  4.424449528322337e-11, -1.745649957889064e-12,  6.296557382562898e-14, -2.093293845320154e-15,  1.168761434887509e-02, -3.682221659725842e-03,  6.137994880891735e-04,
 -7.024417068459065e-05,  6.165811010047188e-06, -4.413423520729786e-07,  2.677910205242334e-08, -1.414557322598232e-09,  6.632380527872234e-11, -2.801122059533335e-12,
  1.077986390761191e-13, -3.811533789969478e-15,  8.685727837835312e-03, -2.978989264303630e-03,  5.409306982276000e-04, -6.718639721766008e-05,  6.373857834635791e-06,
 -4.910939032383363e-07,  3.195247994739231e-08, -1.803460152925211e-09,  9.005336147794603e-11, -4.038071845169841e-12,  1.645220291257380e-13, -6.141461287354056e-15,
  6.402618964423340e-03, -2.356050736142425e-03,  4.598923671787378e-04, -6.124588374481150e-05,  6.209647539692165e-06, -5.096541280228920e-07,  3.521268769571974e-08,
 -2.104260403674565e-09,  1.109392205626216e-10, -5.238667920257079e-12,  2.242187485382386e-13, -8.771635484143860e-15,  4.657295657825497e-03, -1.814474374702481e-03,
  3.759660126865811e-04, -5.305730791764119e-05,  5.686366081092054e-06, -4.920610662871237e-07,  3.575372417274154e-08, -2.241573869336868e-09,  1.237025568800541e-10,
 -6.101246286265238e-12,  2.722017484973722e-13, -1.107765596184683e-14,  3.304084544363681e-03, -1.346293957321592e-03,  2.925675432686425e-04, -4.325455127477801e-05,
  4.847669884637060e-06, -4.377910746233819e-07,  3.313319541828596e-08, -2.159551961227078e-09,  1.236716382623523e-10, -6.318919229912467e-12,  2.915673931090233e-13,
 -1.225218094248887e-14,  2.227513782460741e-03, -9.385035296092739e-04,  2.114277633154606e-04, -3.238315997515615e-05,  3.754976613442250e-06, -3.503466399019485e-07,
  2.735374729622074e-08, -1.836630995076968e-09,  1.082031526271478e-10, -5.680127559312979e-12,  2.689435073726855e-13, -1.158250319705701e-14,  1.335799524311195e-03,
 -5.757423062684548e-04,  1.329505843138836e-04, -2.086527693841932e-05,  2.476971011458290e-06, -2.363737427287578e-07,  1.885717592149849e-08, -1.292467459345611e-09,
  7.765502611861424e-11, -4.153659330742259e-12,  2.002192773264003e-13, -8.770928917447267e-15,  5.549381979550855e-04, -2.421877296360674e-04,  5.669556600759395e-05,
 -9.018695087074530e-06,  1.084688132193055e-06, -1.048138875996722e-07,  8.462467872003963e-09, -5.866910483381341e-10,  3.563731225028556e-11, -1.926179535778397e-12,
  9.377707766306452e-14, -4.147187055680101e-15,  1.387143064485499e-01, -8.432806293134664e-04,  5.527927418312776e-06, -3.799634160865569e-08,  2.674679687177179e-10,
 -1.899161305366664e-12,  1.348430477029736e-14, -9.533093506030390e-17,  6.697369635464743e-19, -4.672915369227405e-21,  3.237694466713046e-23, -2.228255999666336e-25,
  1.316560409705095e-01, -1.350813721371055e-03,  1.593414525401619e-05, -1.805742844609492e-07,  1.941211620700569e-09, -1.998261975216526e-11,  1.986185781659505e-13,
 -1.917440388862488e-15,  1.805366817880052e-17, -1.663021081176660e-19,  1.502324379461629e-21, -1.333422864254232e-23,  1.186883564735764e-01, -2.205661095942522e-03,
  3.944895144208890e-05, -6.210407037252910e-07,  8.943675855582419e-09, -1.204926722039294e-10,  1.539121926475877e-12, -1.880866916342003e-14,  2.213229923719816e-16,
 -2.519950552129467e-18,  2.786733609691847e-20, -3.001900397004352e-22,  1.017836596955952e-01, -3.152006291066075e-03,  7.831077971594014e-05, -1.631986591089753e-06,
  3.024840517351219e-08, -5.135330646566929e-10,  8.130634689594032e-12, -1.215141043665773e-13,  1.729140183294565e-15, -2.357964940583845e-17,  3.096785627328490e-19,
 -3.931898168485251e-21,  8.322006673446332e-02, -3.934386652933577e-03,  1.305485956696164e-04, -3.496268434591630e-06,  8.113827778592573e-08, -1.692178738737886e-09,
  3.242813738333415e-11, -5.795714433723450e-13,  9.763141311585516e-15, -1.562366983014689e-16,  2.389548044573488e-18, -3.509000370762217e-20,  6.506546866412027e-02,
 -4.379466023237601e-03,  1.886456244736420e-04, -6.338166050609538e-06,  1.802932750087740e-07, -4.530945099277886e-09,  1.032389007725610e-10, -2.169926938328448e-12,
  4.259121485046647e-14, -7.878189198665513e-16,  1.382962247535185e-17, -2.316186031326434e-19,  4.882474719977380e-02, -4.432196531197275e-03,  2.416509730685374e-04,
 -9.977253997570065e-06,  3.417562350324688e-07, -1.018632478217990e-08,  2.719679647753388e-10, -6.631710011559377e-12,  1.497318502323042e-13, -3.162464384903997e-15,
  6.297669734459924e-17, -1.189456214289547e-18,  3.531602672200613e-02, -4.142630121651784e-03,  2.792925820833024e-04, -1.391176515062951e-05,  5.649201499662397e-07,
 -1.969482832735879e-08,  6.084159786659026e-10, -1.701026810126622e-11,  4.369358335277689e-13, -1.042765686884866e-14,  2.332225016253247e-16, -4.920119746674265e-18,
  2.474404515143934e-02, -3.622295281527837e-03,  2.955698090723134e-04, -1.746453666253078e-05,  8.288185219799199e-07, -3.337381906168203e-08,  1.179298797185910e-09,
 -3.740538578192499e-11,  1.082301209340804e-12, -2.891349519046687e-14,  7.198389308850825e-16, -1.681748115032311e-17,  1.688356688885911e-02, -2.995880502873682e-03,
  2.900905228595016e-04, -2.001646379076627e-05,  1.095437330041339e-06, -5.034846285512353e-08,  2.013366269615037e-09, -7.173679219760613e-11,  2.316621013511072e-12,
 -6.867695165302882e-14,  1.887586850917356e-15, -4.845300503878618e-17,  1.128283280758199e-02, -2.366658637112701e-03,  2.670488153163970e-04, -2.120234714364372e-05,
  1.321199279260159e-06, -6.853661509994113e-08,  3.069952574539119e-09, -1.217189758291346e-10,  4.348530828973364e-12, -1.418723702568014e-13,  4.271078449684716e-15,
 -1.195578571528744e-16,  7.427585721505273e-03, -1.801542787677542e-03,  2.329318721399755e-04, -2.098282145238207e-05,  1.470705938233405e-06, -8.517067585953404e-08,
  4.231034911318594e-09, -1.849628595619208e-10,  7.247846348916515e-12, -2.581378813754551e-13,  8.447121243329481e-15, -2.559799900601831e-16,  4.843907365902241e-03,
 -1.331980095172908e-03,  1.942515857887803e-04, -1.958832898932239e-05,  1.526084807339602e-06, -9.761121732413303e-08,  5.325261357437079e-09, -2.543545266441406e-10,
  1.083951563155319e-11, -4.180818293595771e-13,  1.475845711353713e-14, -4.806826552095900e-16,  3.145320738468494e-03, -9.631478331486724e-04,  1.560907379913206e-04,
 -1.739251933830424e-05,  1.488701195201396e-06, -1.040594905853260e-07,  6.173961506689858e-09, -3.192821675731552e-10,  1.467203040157717e-11, -6.079404473523467e-13,
  2.297511756211449e-14, -7.984547734884271e-16,  2.041602384714052e-03, -6.848582508555052e-04,  1.216032860713241e-04, -1.478392778756035e-05,  1.374388479558993e-06,
 -1.038843096891760e-07,  6.637696969405946e-09, -3.682673315390693e-10,  1.809195534309783e-11, -7.988129630160360e-13,  3.207091414584514e-14, -1.180578908180079e-15,
  1.327267704976416e-03, -4.804180094115040e-04,  9.219691533660700e-05, -1.207925895525343e-05,  1.205822762245807e-06, -9.752061286977822e-08,  6.644453444884001e-09,
 -3.918437708722706e-10,  2.040070265923012e-11, -9.519205073949021e-13,  4.028342138435218e-14, -1.559042307960501e-15,  8.628187897847288e-04, -3.322907640669943e-04,
  6.802385286254650e-05, -9.487848065648537e-06,  1.005541548246407e-06, -8.609308595040027e-08,  6.192823033607112e-09, -3.845568459309295e-10,  2.102979747588844e-11,
 -1.028299676449303e-12,  4.550092866705402e-14, -1.837323029527364e-15,  5.561721158179379e-04, -2.249373435970002e-04,  4.849599119858820e-05, -7.114712932959072e-06,
  7.914917642708570e-07, -7.097737464063563e-08,  5.335874213449622e-09, -3.455719022751817e-10,  1.967039615888780e-11, -9.992680116854724e-13,  4.585584990933130e-14,
 -1.916923781403013e-15,  3.473841118109872e-04, -1.457382164346207e-04,  3.268157141178075e-05, -4.983141288058853e-06,  5.753204662587257e-07, -5.345676100204978e-08,
  4.157258723153446e-09, -2.780854934184660e-10,  1.632448377908172e-11, -8.540309947438236e-13,  4.030523745908658e-14, -1.730439161706210e-15,  1.972713885617933e-04,
 -8.485285669128331e-05,  1.955071949120186e-05, -3.061563710755535e-06,  3.626755506017451e-07, -3.453910961825585e-08,  2.750046803146580e-09, -1.881354803123935e-10,
  1.128347920203282e-11, -6.025038280273081e-13,  2.899490840254973e-14, -1.268177568263538e-15,  7.946162721405815e-05, -3.465141256508423e-05,  8.104676917800998e-06,
 -1.288094911524705e-06,  1.547869986346220e-07, -1.494459369477473e-08,  1.205615819487362e-09, -8.351778250723129e-11,  5.069238913462296e-12, -2.737873010441933e-13,
  1.331993037516718e-14, -5.886512605332174e-16,  1.354268420884211e-01, -8.008110598982629e-04,  5.096449376211302e-06, -3.400400227124253e-08,  2.325166527106839e-10,
 -1.605294371923243e-12,  1.109146789099396e-14, -7.635896529122815e-17,  5.226432320653503e-19, -3.554185127362704e-21,  2.400800655433356e-23, -1.611272064469072e-25,
  1.264947161581238e-01, -1.231508892407669e-03,  1.394121339599841e-05, -1.524702655846403e-07,  1.585194265627197e-09, -1.579989570550817e-11,  1.521947576671672e-13,
 -1.424971349492273e-15,  1.302078068508418e-17, -1.164676623375208e-19,  1.022180588790496e-21, -8.818357940009999e-24,  1.104529045306863e-01, -1.917617701779363e-03,
  3.278157517729206e-05, -4.953793654840868e-07,  6.864360075864508e-09, -8.914988070301123e-11,  1.099390224649455e-12, -1.298608369527444e-14,  1.478516200603638e-16,
 -1.630226711000021e-18,  1.747185694346686e-20, -1.825264911878627e-22,  9.031524256630563e-02, -2.596344849896130e-03,  6.132328912434984e-05, -1.220628641844692e-06,
  2.168277431436934e-08, -3.536805629585911e-10,  5.390549895502181e-12, -7.767426744513400e-14,  1.067061680470616e-15, -1.406350502705169e-17,  1.786869662881003e-19,
 -2.196826288181807e-21,  6.933366271874268e-02, -3.038071567565245e-03,  9.538910755862759e-05, -2.431461293052424e-06,  5.392556955791812e-08, -1.077941169500809e-09,
  1.984436080828262e-11, -3.413426785994342e-13,  5.542636786945182e-15, -8.561205518521267e-17,  1.265330755427128e-18, -1.797503602115967e-20,  5.014537541217427e-02,
 -3.131597990847799e-03,  1.272910060284102e-04, -4.061989925309767e-06,  1.102275188802867e-07, -2.651127375149892e-09,  5.795761009985508e-11, -1.171207051247574e-12,
  2.214050402413223e-14, -3.950282216042470e-16,  6.697668723810379e-18, -1.084728839416810e-19,  3.431748875945355e-02, -2.898396431255273e-03,  1.490066570010254e-04,
 -5.838907537811941e-06,  1.906691324638498e-07, -5.435969342626389e-09,  1.391962079632077e-10, -3.262423864533334e-12,  7.093277258411680e-14, -1.445049768946602e-15,
  2.779624266114851e-17, -5.077754625229507e-19,  2.233998837754443e-02, -2.447879781367480e-03,  1.557724936214921e-04, -7.368237464172399e-06,  2.853622905668875e-07,
 -9.519963076117339e-09,  2.821800611358718e-10, -7.586786637891904e-12,  1.877694013592668e-13, -4.325024035125468e-15,  9.350155087464528e-17, -1.909266556148163e-18,
  1.391878759833888e-02, -1.912852597754144e-03,  1.476896723525269e-04, -8.301751336512742e-06,  3.763060978193171e-07, -1.451916173157894e-08,  4.928953833023580e-10,
 -1.505317415317146e-11,  4.201877402513564e-13, -1.084764136935810e-14,  2.613776340382074e-16, -5.918319966183492e-18,  8.357969561576853e-03, -1.400326495455689e-03,
  1.287713148358992e-04, -8.476868675163843e-06,  4.441866896642751e-07, -1.960540100797174e-08,  7.547475236267391e-10, -2.594400743813045e-11,  8.097989944573620e-13,
 -2.324234639522487e-14,  6.193962021625764e-16, -1.543736544263662e-17,  4.874499313620076e-03, -9.715649417246252e-04,  1.045920993164552e-04, -7.952267053333480e-06,
  4.760309939146599e-07, -2.378471415527483e-08,  1.028492958134980e-09, -3.944413683127954e-11,  1.365469049086560e-12, -4.323471591261733e-14,  1.264975779859239e-15,
 -3.445926328254145e-17,  2.784095069822830e-03, -6.459946364663575e-04,  8.010802954969979e-05, -6.941651864700384e-06,  4.692682661522434e-07, -2.627113339400015e-08,
  1.264161120445645e-09, -5.362667106091508e-11,  2.042382447240182e-12, -7.080028251913692e-14,  2.257946329957093e-15, -6.676753574261186e-17,  1.570680570690560e-03,
 -4.160388076026259e-04,  5.852653216301769e-05, -5.705852098031153e-06,  4.306928866514403e-07, -2.674188666763126e-08,  1.418683403299005e-09, -6.599466093142963e-11,
  2.742909924972346e-12, -1.033112523044693e-13,  3.565471906785213e-15, -1.136588239563873e-16,  8.827101316612731e-04, -2.621552650487830e-04,  4.122693069028541e-05,
 -4.465000650420388e-06,  3.720933758161377e-07, -2.536237471174669e-08,  1.469450599290351e-09, -7.430400629399835e-11,  3.342633424524381e-12, -1.357350236755343e-13,
  5.032162676776525e-15, -1.717227807346707e-16,  4.980003304963841e-04, -1.630842101294134e-04,  2.826667808361277e-05, -3.358411127637837e-06,  3.055043115451069e-07,
 -2.262293721089688e-08,  1.417745366346386e-09, -7.722864886840529e-11,  3.728656611192246e-12, -1.619379973227298e-13,  6.400415880728781e-15, -2.321285473713307e-16,
  2.837399261163425e-04, -1.008676936264617e-04,  1.900372368634722e-05, -2.446102109575590e-06,  2.401167826977617e-07, -1.911305297672076e-08,  1.282794018751395e-09,
 -7.457954494729918e-11,  3.830734110939183e-12, -1.764680285074006e-13,  7.377305836617915e-15, -2.822312194646937e-16,  1.636750163458174e-04, -6.223948431499871e-05,
  1.257366308304763e-05, -1.731468728518027e-06,  1.812827931060412e-07, -1.534279814893714e-08,  1.091604008342681e-09, -6.708465855447531e-11,  3.632576178581043e-12,
 -1.759673799561339e-13,  7.717335809067654e-15, -3.090044985283930e-16,  9.517575232607872e-05, -3.817750624414653e-05,  8.159593036405237e-06, -1.186973448678729e-06,
  1.309822372022404e-07, -1.165572638293983e-08,  8.698532231393972e-10, -5.594480461153508e-11,  3.163490350152720e-12, -1.597017315693003e-13,  7.285009918153320e-15,
 -3.028165304786287e-16,  5.472003853748698e-05, -2.284882770978692e-05,  5.097933773874452e-06, -7.734690454862224e-07,  8.887595992416795e-08, -8.220652219125343e-09,
  6.365518117339796e-10, -4.240515091472904e-11,  2.479587243125837e-12, -1.292393093321765e-13,  6.077714836493270e-15, -2.600574198942965e-16,  2.927836345996104e-05,
 -1.256541041817000e-05,  2.888108153772331e-06, -4.511801283669627e-07,  5.332329580183569e-08, -5.066907944750343e-09,  4.025749750174806e-10, -2.748481202681691e-11,
  1.645202474456297e-12, -8.768541913607119e-14,  4.212264544322991e-15, -1.839227859304189e-16,  1.140049051913270e-05, -4.967259756388762e-06,  1.160702979011457e-06,
 -1.842990177928056e-07,  2.212627879939408e-08, -2.134362792326401e-09,  1.720344594005645e-10, -1.190748351847338e-11,  7.221545953762832e-13, -3.897252639933969e-14,
  1.894593575684650e-15, -8.366667198426613e-17,  1.323026429181856e-01, -7.616107620245894e-04,  4.709708396114235e-06, -3.052681404116087e-08,  2.029088239683923e-10,
 -1.362977804311277e-12,  9.169571105392802e-15, -6.150926090344463e-17,  4.103987846762407e-19, -2.721706688365780e-21,  1.793349134631219e-23, -1.174379089807473e-25,
  1.217807308602573e-01, -1.126889375668759e-03,  1.225392866781883e-05, -1.294494443176842e-07,  1.302719120757377e-09, -1.258253849136674e-11,  1.175507034860758e-13,
 -1.068200604917005e-15,  9.479242704840849e-18, -8.238897350683382e-20,  7.029565518864794e-22, -5.898155950493776e-24,  1.032717583806875e-01, -1.677402974733133e-03,
  2.744149019696828e-05, -3.984946392434454e-07,  5.318313001739710e-09, -6.664297529246742e-11,  7.940724566665007e-13, -9.073224767006997e-15,  1.000240289245500e-16,
 -1.068764084742907e-18,  1.110824164288296e-20, -1.126133255392408e-22,  8.082593878989786e-02, -2.158946331499519e-03,  4.854476675163922e-05, -9.239394474968751e-07,
  1.574485153296250e-08, -2.469702174361371e-10,  3.626441910337102e-12, -5.041843433258072e-14,  6.691311013968929e-16, -8.528910654895954e-18,  1.049017227868720e-19,
 -1.249527060567303e-21,  5.854155204955119e-02, -2.378486229134790e-03,  7.075272393735730e-05, -1.718168043173679e-06,  3.644788250870223e-08, -6.988588276046665e-10,
  1.236814393777949e-11, -2.048837072433420e-13,  3.208742795535861e-15, -4.786487547690811e-17,  6.839795349051082e-19, -9.403961592161769e-21,  3.938450018446653e-02,
 -2.281852310366321e-03,  8.759670574727673e-05, -2.656814602838438e-06,  6.882255884847115e-08, -1.585109252135967e-09,  3.326568932817054e-11, -6.466233043391242e-13,
  1.177807623923349e-14, -2.027782934272955e-16,  3.321883492658054e-18, -5.204230330172256e-20,  2.472789337551551e-02, -1.941969519252939e-03,  9.416926856317532e-05,
 -3.503436343483566e-06,  1.091040894511323e-07, -2.976296742355787e-09,  7.311484822443758e-11, -1.647546908420851e-12,  3.450339740940482e-14, -6.781223848398316e-16,
  1.260182464571898e-17, -2.226877988769699e-19,  1.457397078670484e-02, -1.490151077382438e-03,  8.948567111883459e-05, -4.019300681140792e-06,  1.484603222281207e-07,
 -4.739446923675404e-09,  1.347922700311808e-10, -3.485107582040908e-12,  8.310662139082838e-14, -1.847475456956394e-15,  3.860403471165197e-17, -7.629429374326738e-19,
  8.119392263610619e-03, -1.045971924751044e-03,  7.635880282734295e-05, -4.081155658681911e-06,  1.766255941386337e-07, -6.527721507792950e-09,  2.128317431498931e-10,
 -6.256699251139753e-12,  1.684367742677721e-13, -4.200914459235463e-15,  9.793770678477787e-17, -2.148605911696555e-18,  4.310820228888065e-03, -6.806750311397322e-04,
  5.937261217231165e-05, -3.725310226073130e-06,  1.867607730841399e-07, -7.910614841712153e-09,  2.929908602365956e-10, -9.710719803890418e-12,  2.928037613701471e-13,
 -8.131913866201993e-15,  2.100134406181791e-16, -5.079490031782015e-18,  2.201540192874859e-03, -4.160543098935036e-04,  4.266389948056464e-05, -3.102339626225480e-06,
  1.782002220640309e-07, -8.567328585447334e-09,  3.573105289908718e-10, -1.324376002085153e-11,  4.438913635784190e-13, -1.362983118296269e-14,  3.872854088502682e-16,
 -1.025959732973625e-17,  1.092770056835815e-03, -2.419945882532489e-04,  2.872843322910100e-05, -2.390936958392242e-06,  1.556759072794866e-07, -8.414518515654605e-09,
  3.917609008687864e-10, -1.610927106621656e-11,  5.957005819037899e-13, -2.008022884773204e-14,  6.235572579772651e-16, -1.797657296778996e-17,  5.331501101284901e-04,
 -1.357098639685786e-04,  1.837896049117619e-05, -1.729301601129000e-06,  1.262728063521106e-07, -7.600179648783254e-09,  3.915651442813379e-10, -1.771845988573905e-11,
  7.174108101353031e-13, -2.635868301290963e-14,  8.884691023319700e-16, -2.769352043194706e-17,  2.586941411120688e-04, -7.434671429526478e-05,  1.132306228763091e-05,
 -1.189850278077895e-06,  9.638565889748305e-08, -6.397001200950955e-09,  3.614386340912879e-10, -1.784798148016694e-11,  7.850770760930603e-13, -3.120785782341090e-14,
  1.133798182764553e-15, -3.795394055411555e-17,  1.262911302860574e-04, -4.029367500274775e-05,  6.804889700888825e-06, -7.888042107927787e-07,  7.010543847334261e-08,
 -5.078802655133218e-09,  3.117622005287655e-10, -1.665358240384007e-11,  7.892901080209328e-13, -3.368241335848033e-14,  1.309230292920651e-15, -4.673668689321522e-17,
  6.267664673213712e-05, -2.184674031684191e-05,  4.034384941514214e-06, -5.094378087180596e-07,  4.910861448586297e-08, -3.842521055759739e-09,  2.537472299553181e-10,
 -1.452783732123173e-11,  7.354465318865205e-13, -3.341553029400069e-14,  1.378781326370294e-15, -5.209671239586542e-17,  3.185135104136776e-05, -1.194393803306095e-05,
  2.378246109493710e-06, -3.229610406605891e-07,  3.336802128696258e-08, -2.788811364749276e-09,  1.960695571923755e-10, -1.191437955525400e-11,  6.382944395143893e-13,
 -3.060796656998270e-14,  1.329497829638893e-15, -5.274962740966791e-17,  1.658231060001530e-05, -6.591449806525164e-06,  1.395337796141065e-06, -2.011004838336616e-07,
  2.199528542249855e-08, -1.940861047555446e-09,  1.436901186217079e-10, -9.171603166565253e-12,  5.149024627499505e-13, -2.581660176109900e-14,  1.170034660104691e-15,
 -4.833623111243368e-17,  8.714682340688705e-06, -3.619965970240111e-06,  8.031714328910426e-07, -1.211958546471388e-07,  1.385347088149369e-08, -1.275020010796284e-09,
  9.826227494957788e-11, -6.516519705272131e-12,  3.794172167258021e-13, -1.969535708844624e-14,  9.226284754366375e-16, -3.933307691395479e-17,  4.369155268092644e-06,
 -1.870490129020339e-06,  4.287727439087608e-07, -6.680634188509074e-08,  7.875535662567213e-09, -7.465315764613677e-10,  5.917537329841746e-11, -4.031082755110997e-12,
  2.407834621776064e-13, -1.280720848521357e-14,  6.140471868951615e-16, -2.676208325554419e-17,  1.639106442789623e-06, -7.135118650073602e-07,  1.665571816998757e-07,
 -2.641947607418062e-08,  3.168682557270812e-09, -3.053659810679197e-10,  2.459027960868251e-11, -1.700501842369439e-12,  1.030408733399860e-13, -5.556135198835818e-15,
  2.698841236434775e-16, -1.190894768687955e-17,  1.293293104465763e-01, -7.253451875738104e-04,  4.362003503495699e-06, -2.748695216765333e-08,  1.777177645448019e-10,
 -1.162177031362532e-12,  7.617372119122045e-15, -4.981525305989848e-17,  3.241760780692826e-19, -2.097770728167533e-21,  1.349007321204992e-23, -8.624424101279407e-26,
  1.174598742830213e-01, -1.034735357720751e-03,  1.081776205592503e-05, -1.104754443026099e-07,  1.077024027405790e-09, -1.008851848471104e-11,  9.147783898702519e-14,
 -8.073633137706874e-16,  6.962588480761446e-18, -5.884011056170692e-20,  4.883603704482311e-22, -3.987658314244104e-24,  9.697284139316138e-02, -1.475647188548372e-03,
  2.312926108813308e-05, -3.231093337004639e-07,  4.157181638859660e-09, -5.030486206230532e-11,  5.796083443893357e-13, -6.411133206696722e-15,  6.848227429445469e-17,
 -7.095808842894673e-19,  7.156734057584669e-21, -7.045010739026897e-23,  7.290223742101715e-02, -1.811001580850813e-03,  3.882010278986239e-05, -7.072479987638296e-07,
  1.157284252917008e-08, -1.747138333963186e-10,  2.473544070739774e-12, -3.320550434436668e-14,  4.260275050030843e-16, -5.255040496637798e-18,  6.260604959401122e-20,
 -7.229128652756263e-22,  5.004178653639033e-02, -1.885989063555666e-03,  5.321983239517530e-05, -1.232451704490223e-06,  2.502822103004703e-08, -4.606831340152655e-10,
  7.843301279282147e-12, -1.252086529511823e-13,  1.892450987069733e-15, -2.727796299111390e-17,  3.770678394766661e-19, -5.019928046285294e-21,  3.148029275802322e-02,
 -1.692041293269585e-03,  6.140109101753336e-05, -1.771360488364955e-06,  4.383209725246493e-08, -9.673367997168702e-10,  1.949918915121029e-11, -3.647746463551080e-13,
  6.404989536940305e-15, -1.064524080784115e-16,  1.685593432234296e-18, -2.555353731635390e-20,  1.823708902634389e-02, -1.331078206741310e-03,  6.090848580032749e-05,
 -2.152334760765340e-06,  6.394945311819270e-08, -1.669852707818637e-09,  3.936748860946600e-11, -8.531477009128559e-13,  1.721414628412776e-14, -3.264729820318400e-16,
  5.862546515005348e-18, -1.002317136078055e-19,  9.788442204183991e-03, -9.330181406902194e-04,  5.286841353844552e-05, -2.254943515684508e-06,  7.944376819874941e-08,
 -2.427142123722873e-09,  6.623902563768252e-11, -1.647072428383158e-12,  3.784461645961319e-14, -8.119647653597475e-16,  1.639897914540678e-17, -3.136754495729440e-19,
  4.903777558032940e-03, -5.913305453596121e-04,  4.079189507705059e-05, -2.072211319333793e-06,  8.560083974730618e-08, -3.029620016119522e-09,  9.484796928155082e-11,
 -2.683362504804446e-12,  6.965534476517257e-14, -1.677961130502280e-15,  3.784111439587941e-17, -8.041679748773878e-19,  2.313468537851852e-03, -3.436441163055269e-04,
  2.840121640429947e-05, -1.697143864865449e-06,  8.134725427551645e-08, -3.304653327733032e-09,  1.176939270664138e-10, -3.759190430729027e-12,  1.094448126474962e-13,
 -2.939827069261938e-15,  7.354335401990231e-17, -1.725396821647611e-18,  1.038596711489499e-03, -1.857062074188189e-04,  1.811206828407551e-05, -1.258085555089301e-06,
  6.927173290214296e-08, -3.201616270145677e-09,  1.286774372575956e-10, -4.605882473661690e-12,  1.493563337288829e-13, -4.444209606418314e-15,  1.225552929620396e-16,
 -3.155162452383208e-18,  4.490625030882072e-04, -9.468858506252620e-05,  1.074179483011456e-05, -8.573202398148450e-07,  5.369256398379653e-08, -2.798678766314450e-09,
  1.259322594848769e-10, -5.014475633590079e-12,  1.798695452419604e-13, -5.890430125993206e-15,  1.779541837685962e-16, -4.997555222483687e-18,  1.895500054126904e-04,
 -4.625402630017254e-05,  6.018439418442293e-06, -5.455900304535914e-07,  3.847957408736145e-08, -2.241963780820520e-09,  1.120310899600377e-10, -4.925399031104331e-12,
  1.940606083652297e-13, -6.947927338528325e-15,  2.285016021972495e-16, -6.957635618336543e-18,  7.927088001093898e-05, -2.199388285162070e-05,  3.237425926626574e-06,
 -3.294824267969843e-07,  2.590207809821862e-08, -1.671390785445802e-09,  9.196706196668764e-11, -4.429236909256468e-12,  1.902738401041061e-13, -7.395888430753901e-15,
  2.630324647171937e-16, -8.628607701521201e-18,  3.335586251211601e-05, -1.034640146928967e-05,  1.699244897436982e-06, -1.918377904403614e-07,  1.663117638514751e-08,
 -1.176991600591691e-09,  7.067377081345955e-11, -3.697404767496852e-12,  1.718173292856643e-13, -7.196492435463446e-15,  2.748097779037205e-16, -9.646417257677599e-18,
  1.433496228538258e-05, -4.890383660210634e-06,  8.836926243067436e-07, -1.092988027914074e-07,  1.033180367654365e-08, -7.936119563597868e-10,  5.150091997692853e-11,
 -2.900356080895564e-12,  1.445510993365595e-13, -6.471319837970625e-15,  2.632947600126955e-16, -9.816936630374409e-18,  6.371036459916978e-06, -2.352664603478843e-06,
  4.610971946946459e-07, -6.167019525725898e-08,  6.280326634286050e-09, -5.177688111765734e-10,  3.593472070008176e-11, -2.157073788315085e-12,  1.142314315977438e-13,
 -5.417912649675810e-15,  2.328959864485151e-16, -9.149717161851587e-18,  2.946222289166686e-06, -1.159411151180215e-06,  2.428578383920149e-07, -3.464567143308956e-08,
  3.752651118242445e-09, -3.280902730034609e-10,  2.407836867661494e-11, -1.524216010203605e-12,  8.490144393444657e-14, -4.225263377532290e-15,  1.901439182297734e-16,
 -7.802727534443558e-18,  1.404734662343099e-06, -5.801439210281438e-07,  1.279256572701330e-07, -1.918774976859714e-08,  2.180694900260995e-09, -1.996065447157772e-10,
  1.530332042390583e-11, -1.009880881150688e-12,  5.852418681586147e-14, -3.024461897523824e-15,  1.410823986579445e-16, -5.990459572027763e-18,  6.559186619739695e-07,
 -2.800420675707962e-07,  6.400454683172926e-08, -9.943528057182296e-09,  1.168933043512903e-09, -1.105089652833920e-10,  8.737422739717743e-12, -5.937567573354244e-13,
  3.538401634983305e-14, -1.877911391349199e-15,  8.984759290519867e-17, -3.907981801898768e-18,  2.362000160052834e-07, -1.027169396299989e-07,  2.395118388093889e-08,
 -3.795005251246168e-09,  4.546772398517973e-10, -4.377195474579065e-11,  3.521313677802675e-12, -2.432760410272769e-13,  1.472744271438887e-14, -7.934146651133448e-16,
  3.850594507876977e-17, -1.697699105044588e-18,  1.264956987371113e-01, -6.917218982644578e-04,  4.048484874914315e-06, -2.481993721681805e-08,  1.561951873138596e-10,
 -9.949920373135048e-13,  6.357124452558759e-15, -4.055277541766856e-17,  2.575206679262085e-19, -1.626921054791860e-21,  1.021561447264656e-23, -6.379607122103743e-26,
  1.134860152029179e-01, -9.532177280150399e-04,  9.589159048224482e-06, -9.474519266692214e-08,  8.954995152004499e-10, -8.140978192491402e-12,  7.169748014962562e-14,
 -6.150001384974564e-16,  5.157480858721616e-18, -4.240504377770349e-20,  3.425724312057096e-22, -2.723783194506959e-24,  9.141726589030914e-02, -1.305063433318962e-03,
  1.962012891352718e-05, -2.639442589443036e-07,  3.276836324608292e-09, -3.832253904492060e-11,  4.272978324984390e-13, -4.578704033226267e-15,  4.742236586995983e-17,
 -4.767989823054064e-19,  4.669465766073208e-21, -4.465951422833977e-23,  6.622972034885975e-02, -1.531486922616143e-03,  3.133845522042034e-05, -5.471017113460412e-07,
  8.604184488423624e-09, -1.251242566871135e-10,  1.709326487288209e-12, -2.217218665834097e-14,  2.751901726349159e-16, -3.287009680375006e-18,  3.795337136896206e-20,
 -4.250796184187540e-22,  4.326444593814881e-02, -1.513219655306985e-03,  4.055921639429455e-05, -8.965613528611647e-07,  1.744484038529894e-08, -3.084839805021112e-10,
  5.056144301906050e-12, -7.783436695806911e-14,  1.136022767992182e-15, -1.583154355402348e-17,  2.118063589253943e-19, -2.731734294378724e-21,  2.557500354502266e-02,
 -1.275256385982073e-03,  4.378799283138098e-05, -1.202491026394608e-06,  2.844406221800897e-08, -6.018850698109336e-10,  1.166024238627074e-11, -2.100389956274250e-13,
  3.556930281749478e-15, -5.709461949560910e-17,  8.741850218331268e-19, -1.282887895883530e-20,  1.374532059868057e-02, -9.319690060620158e-04,  4.026403106374762e-05,
 -1.352111550608516e-06,  3.834654398852062e-08, -9.588765491417282e-10,  2.170318108208097e-11, -4.524992199293407e-13,  8.799412118038000e-15, -1.610842990411235e-16,
  2.795852215056931e-18, -4.625766062263296e-20,  6.757153585878388e-03, -5.998964221028149e-04,  3.207598179487646e-05, -1.299334607039490e-06,  4.366992165160734e-08,
 -1.277047881016932e-09,  3.344810110949685e-11, -7.999680493172802e-13,  1.771253989532674e-14, -3.668078682362641e-16,  7.160917981756233e-18, -1.325719208552137e-19,
  3.061313902976305e-03, -3.450901954280988e-04,  2.248386136964897e-05, -1.085293797288282e-06,  4.278412080203705e-08, -1.449867683641864e-09,  4.357852568011619e-11,
 -1.186331776442760e-12,  2.968948209890007e-14, -6.906929927832986e-16,  1.506514203769158e-17, -3.100681748581676e-19,  1.290012763256137e-03, -1.799493768768676e-04,
  1.407787044775989e-05, -8.006056144587720e-07,  3.666882090296596e-08, -1.427985594199784e-09,  4.888108316257975e-11, -1.503973438878084e-12,  4.226101685107029e-14,
 -1.097500344456194e-15,  2.658421357007515e-17, -6.047459041607463e-19,  5.112828923247909e-04, -8.631607768399418e-05,  7.995626988476748e-06, -5.299400207567054e-07,
  2.794423872945260e-08, -1.240568921235312e-09,  4.801286111001691e-11, -1.658464423219556e-12,  5.199624435894775e-14, -1.498380535261306e-15,  4.007637998362226e-17,
 -1.002092892235916e-18,  1.931327436692697e-04, -3.868523763814755e-05,  4.186338816843788e-06, -3.199480728228533e-07,  1.924952970093523e-08, -9.664933526466896e-10,
  4.198801364166913e-11, -1.617445559702988e-12,  5.622750638285608e-14, -1.787369124133695e-15,  5.248957935639032e-17, -1.434826652689723e-18,  7.060996840618132e-05,
 -1.647723186878132e-05,  2.055792756341087e-06, -1.792480668635921e-07,  1.219236876861945e-08, -6.867180995876117e-10,  3.324102586028572e-11, -1.418250691949002e-12,
  5.431622041883063e-14, -1.893052712990169e-15,  6.068593492956256e-17, -1.803403130563898e-18,  2.542581101500350e-05, -6.793811647602520e-06,  9.645007973053099e-07,
 -9.489499525877452e-08,  7.227921338545512e-09, -4.527778008164611e-10,  2.422901434555594e-11, -1.136624426469699e-12,  4.762912602880261e-14, -1.808226576276631e-15,
  6.288620564987207e-17, -2.019562714028812e-18,  9.191109816380899e-06, -2.765362223915399e-06,  4.407802486920870e-07, -4.837717773760164e-08,  4.084302148649703e-09,
 -2.819360286092400e-10,  1.653673031038437e-11, -8.462074453024989e-13,  3.850867807858655e-14, -1.581259208992970e-15,  5.925768961680071e-17, -2.043282824738620e-18,
  3.401628837290386e-06, -1.133573800395367e-06,  2.000723617179410e-07, -2.419803433020137e-08,  2.239611649920206e-09, -1.686425425076629e-10,  1.074061306907753e-11,
 -5.942573017450998e-13,  2.912537380210005e-14, -1.283378950898077e-15,  5.143656205321205e-17, -1.890668543604346e-18,  1.312591960163551e-06, -4.765867080098491e-07,
  9.180218984274136e-08, -1.207609356941079e-08,  1.210613286843288e-09, -9.833538762660542e-11,  6.729727705456537e-12, -3.986502032996418e-13,  2.084812654883618e-14,
 -9.771385106460473e-16,  4.153331721560928e-17, -1.614403733272632e-18,  5.347475324525777e-07, -2.081078207545128e-07,  4.308751932249500e-08, -6.078143720172662e-09,
  6.513614870064163e-10, -5.637479031100391e-11,  4.097917805357663e-12, -2.570697027515918e-13,  1.419701469470483e-14, -7.008238097743682e-16,  3.129630744400318e-17,
 -1.274942971487076e-18,  2.294540926787406e-07, -9.415567949470361e-08,  2.062050619455639e-08, -3.072409371359742e-09,  3.469710990159627e-10, -3.156855059834962e-11,
  2.406480561000732e-12, -1.579474997531605e-13,  9.106378974473705e-15, -4.683177024955657e-16,  2.174476251859462e-17, -9.192566731619918e-19,  9.912144861695007e-08,
 -4.219181056145763e-08,  9.611619660364714e-09, -1.488454941269758e-09,  1.744412082843638e-10, -1.644302675876034e-11,  1.296441098455533e-12, -8.786611819957398e-14,
  5.222985634889810e-15, -2.765272820627379e-16,  1.319987634460468e-17, -5.728824479826433e-19,  3.412100863735171e-08, -1.482229684569725e-08,  3.452103148482602e-09,
 -5.463303522296583e-10,  6.538013459669769e-11, -6.287160728917359e-12,  5.052384101913525e-13, -3.486910526389618e-14,  2.108797518486557e-15, -1.134983196205711e-16,
  5.503177887534676e-18, -2.424143518406805e-19,  1.237917586373960e-01, -6.604843515419094e-04,  3.765009508056042e-06, -2.247209323106163e-08,  1.377336754861766e-10,
 -8.551670165983300e-13,  5.328743138410439e-15, -3.317552953141339e-17,  2.056780285161002e-19, -1.269267645776024e-21,  7.785398371291568e-24, -4.751977908738216e-26,
  1.098196984895456e-01, -8.808204436396174e-04,  8.533099266915132e-06, -8.163179987677395e-08,  7.485832501255013e-10, -6.609550762008966e-12,  5.657611259834479e-14,
 -4.719589544778212e-16,  3.851203275022906e-18, -3.082573968690026e-20,  2.425309060137187e-22, -1.878771420572394e-24,  8.649206027313769e-02, -1.159935261698736e-03,
  1.674377403000762e-05, -2.171299829533682e-07,  2.603375853958498e-09, -2.944901682378135e-11,  3.179952678613768e-13, -3.303293620154951e-15,  3.319498435727169e-17,
 -3.240609333714777e-19,  3.083466291124732e-21, -2.866927586220050e-23,  6.056667851505788e-02, -1.304876512076978e-03,  2.552333807373513e-05, -4.274201594550422e-07,
  6.466365394216589e-09, -9.065489037791204e-11,  1.195895965020831e-12, -1.499943251232696e-14,  1.802111626750016e-16, -2.085682615629149e-18,  2.335397081305622e-20,
 -2.538465696308773e-22,  3.779850653861307e-02, -1.227465332898401e-03,  3.129108220436799e-05, -6.608814226137485e-07,  1.233129792748136e-08, -2.096544983330219e-10,
  3.310465176390561e-12, -4.917461554406971e-14,  6.934971263028296e-16, -9.349195523621575e-18,  1.211229007652486e-19, -1.514119801587864e-21,  2.109302627181594e-02,
 -9.757603726851184e-04,  3.173578403561871e-05, -8.302730103603697e-07,  1.878766142765195e-08, -3.814331713870270e-10,  7.106058318916317e-12, -1.233229104787918e-13,
  2.015204572261086e-15, -3.125518781635456e-17,  4.629406428224342e-19, -6.579105431957454e-21,  1.057192012993957e-02, -6.656207541677464e-04,  2.716824821840482e-05,
 -8.674832420271395e-07,  2.349573671226339e-08, -5.628961626089186e-10,  1.223709132704448e-11, -2.455558683560843e-13,  4.603769085997126e-15, -8.137446322434198e-17,
  1.365507125950871e-18, -2.186871057802094e-20,  4.786560075937014e-03, -3.954697694615531e-04,  1.995637162039321e-05, -7.679294614358330e-07,  2.462779921304509e-08,
 -6.895091581272609e-10,  1.733566443821136e-11, -3.988627925941549e-13,  8.511703721209422e-15, -1.701593268810650e-16,  3.211309464292052e-18, -5.754654529667001e-20,
  1.972141115103077e-03, -2.075598640372772e-04,  1.276799652037735e-05, -5.855207814071842e-07,  2.202561416993970e-08, -7.146279124842674e-10,  2.062060977583609e-11,
 -5.401180271417237e-13,  1.303087691601512e-14, -2.927339021998383e-16,  6.174810529149413e-18, -1.230718010176256e-19,  7.462809024134504e-04, -9.759932762697512e-05,
  7.221417998946313e-06, -3.906142517493416e-07,  1.708750333238171e-08, -6.376405226742800e-10,  2.097123470881303e-11, -6.213458701994975e-13,  1.684565085377616e-14,
 -4.228131981149927e-16,  9.913425773049894e-18, -2.185919554661542e-19,  2.623485710337154e-04, -4.173282327871244e-05,  3.666825504502760e-06, -2.316648594395884e-07,
  1.168908874792287e-08, -4.980850687622272e-10,  1.855031062752148e-11, -6.179664781056952e-13,  1.872090349694196e-14, -5.221647784217907e-16,  1.353823130564248e-17,
 -3.286064091850582e-19,  8.688203545400506e-05, -1.649336879702140e-05,  1.699706674983339e-06, -1.242224121663187e-07,  7.171252760185211e-09, -3.464607825560825e-10,
  1.451787963178329e-11, -5.405465956599577e-13,  1.819583985600274e-14, -5.610024116936824e-16,  1.600248384423926e-17, -4.254701960534174e-19,  2.756387650995106e-05,
 -6.135717964760843e-06,  7.325966249356877e-07, -6.133490420881148e-08,  4.017664881953881e-09, -2.184650470192517e-10,  1.023145783490436e-11, -4.231586599131544e-13,
  1.573629016180672e-14, -5.333573378901938e-16,  1.665037597370960e-17, -4.824682658590428e-19,  8.544140466612683e-06, -2.193096294240968e-06,  2.996523892172970e-07,
 -2.844884950733704e-08,  2.095975714261839e-09, -1.272728147840349e-10,  6.614305791784219e-12, -3.018524345816952e-13,  1.232356101337618e-14, -4.564535212688699e-16,
  1.550673688670456e-17, -4.870283554510424e-19,  2.646413811603823e-06, -7.704877907297517e-07,  1.189386667100767e-07, -1.266672644664655e-08,  1.039658964322877e-09,
 -6.989236102091957e-11,  3.998702354566611e-12, -1.998734825855077e-13,  8.896256416906613e-15, -3.577124661067592e-16,  1.314096238872698e-17, -4.446399003137478e-19,
  8.392153845957848e-07, -2.726063501525781e-07,  4.690412395103099e-08, -5.537552213524328e-09,  5.010058979652197e-10, -3.692801453496979e-11,  2.305034362560898e-12,
 -1.251348076048019e-13,  6.023998775279218e-15, -2.609730391248243e-16,  1.029259510441657e-17, -3.726055734659304e-19,  2.791455283405685e-07, -9.948778096327130e-08,
  1.880430027288043e-08, -2.429248085821484e-09,  2.393997687530697e-10, -1.913483117976199e-11,  1.289755132542285e-12, -7.531245302349113e-14,  3.885521743633574e-15,
 -1.797888916478408e-16,  7.549555978160425e-18, -2.900938348697359e-19,  9.933902228995939e-08, -3.818589318934384e-08,  7.805400663982996e-09, -1.087552814566802e-09,
  1.151888826803569e-10, -9.859624460029655e-12,  7.092377434582616e-13, -4.405375036488801e-14,  2.410271690770761e-15, -1.179321830764423e-16,  5.222442764586377e-18,
 -2.110694785289793e-19,  3.803079872824899e-08, -1.549455226790474e-08,  3.367744934062652e-09, -4.981100485557845e-10,  5.585930191876259e-11, -5.048591148106497e-12,
  3.824412062366021e-13, -2.495212983842990e-14,  1.430507956736443e-15, -7.317509742018220e-17,  3.380459822597387e-18, -1.422243746870389e-19,  1.508855177055029e-08,
 -6.401021364819961e-09,  1.452932250605514e-09, -2.242059103004774e-10,  2.618703881061453e-11, -2.460448345636181e-12,  1.933967533171849e-13, -1.306916289530939e-14,
  7.747074662336716e-16, -4.090802678202483e-17,  1.947814458031655e-18, -8.433452520604649e-20,  4.942227254680944e-09, -2.144403907016539e-09,  4.987855958618670e-10,
 -7.883672838340188e-11,  9.422750995349253e-12, -9.050314334752952e-13,  7.264434124226019e-14, -5.007966205790156e-15,  3.025441748475020e-16, -1.626649771693018e-17,
  7.879260290972874e-19, -3.467483623706128e-20,  1.212084047352674e-01, -6.314067286170530e-04,  3.508024088620059e-06, -2.039853543572219e-08,  1.218376634649443e-10,
 -7.377205964872339e-13,  4.485508755427989e-15, -2.726868622325559e-17,  1.651207969454970e-19, -9.959002801012382e-22,  5.969395098784076e-24, -3.563413823610393e-26,
  1.064270170746374e-01, -8.162799497914756e-04,  7.621246633545652e-06, -7.064247575608663e-08,  6.289679505638021e-10, -5.397338555416084e-12,  4.493224066688702e-14,
 -3.647540771081203e-16,  2.897883788041030e-18, -2.259363192945169e-20,  1.732206108604774e-22, -1.308064684099159e-24,  8.210466162580331e-02, -1.035741406669222e-03,
  1.436996416549436e-05, -1.798025641277966e-07,  2.083800030441440e-09, -2.281698975472736e-11,  2.387770173784584e-13, -2.406172134805964e-15,  2.347550775538024e-17,
 -2.226572059965997e-19,  2.059605863263865e-21, -1.862670665799571e-23,  5.572537530719513e-02, -1.119575451778611e-03,  2.095992271331157e-05, -3.370355472911067e-07,
  4.909359131877859e-09, -6.640498715596410e-11,  8.465279194634195e-13, -1.027350713296190e-14,  1.195605281134025e-16, -1.341579946158636e-18,  1.457611608118715e-20,
 -1.538436836336179e-22,  3.334342330334755e-02, -1.005797652941141e-03,  2.441874257237301e-05, -4.932352334457658e-07,  8.832944085076652e-09, -1.444988428799450e-10,
  2.199646277616600e-12, -3.154909247353632e-14,  4.301703883483965e-16, -5.613162712188185e-18,  7.045703791237745e-20, -8.540962345811480e-22,  1.764117595937107e-02,
 -7.571418758648854e-04,  2.335147450615524e-05, -5.824885305614285e-07,  1.261842786589703e-08, -2.459619235044853e-10,  4.409214596279923e-12, -7.376373485730735e-14,
  1.163703479973675e-15, -1.744756520822439e-17,  2.501056319292400e-19, -3.443473580102096e-21,  8.286212439324387e-03, -4.842855527777606e-04,  1.868848280481076e-05,
 -5.677271653235256e-07,  1.469357978591825e-08, -3.374373278304452e-10,  7.049121150706709e-12, -1.361972653584424e-13,  2.462777596280678e-15, -4.204604348455076e-17,
  6.823567547465001e-19, -1.058089183925765e-20,  3.473860033669596e-03, -2.668986659773505e-04,  1.271445208361146e-05, -4.649085344012616e-07,  1.423147569400309e-08,
 -3.815755149136066e-10,  9.211526822417608e-12, -2.039380234004475e-13,  4.195318505270670e-15, -8.097713794102479e-17,  1.477577712642669e-18, -2.563276226453256e-20,
  1.308908326301230e-03, -1.284639312944357e-04,  7.459402397421336e-06, -3.249661658087773e-07,  1.166467104895158e-08, -3.623565708989621e-10,  1.003783307773097e-11,
 -2.529771884223764e-13,  5.883686734597963e-15, -1.276303054519676e-16,  2.603441092543387e-18, -5.024663334084397e-20,  4.472160138828025e-04, -5.474668110536110e-05,
  3.828317658187436e-06, -1.968660198645086e-07,  8.222353105909645e-09, -2.939210608845807e-10,  9.285152908828569e-12, -2.648461260461329e-13,  6.926119570287599e-15,
 -1.679709926045805e-16,  3.811114702245299e-18, -8.143437482454439e-20,  1.401378577603525e-04, -2.096356664123550e-05,  1.745056690119675e-06, -1.049991986439550e-07,
  5.065714748084417e-09, -2.070510339644398e-10,  7.416192198143678e-12, -2.381341031041082e-13,  6.967111850809166e-15, -1.879946489607958e-16,  4.722532463196825e-18,
 -1.112178609397330e-19,  4.085108534232086e-05, -7.332890958728782e-06,  7.184803958781484e-07, -5.014888256925890e-08,  2.774805441369669e-09, -1.288686428077171e-10,
  5.203933457708718e-12, -1.871230719103491e-13,  6.094624648567194e-15, -1.821142479483704e-16,  5.042207452228717e-18, -1.303042645767129e-19,  1.127504372537750e-05,
 -2.388114553120255e-06,  2.723434557057660e-07, -2.185865313267869e-08,  1.376915754693216e-09, -7.219083286928316e-11,  3.267328141080365e-12, -1.308511408135247e-13,
  4.720198911044539e-15, -1.554332915273312e-16,  4.721016169704284e-18, -1.332730918485668e-19,  3.010284883788747e-06, -7.403118442749807e-07,  9.714396052058747e-08,
 -8.883140520393261e-09,  6.320143692788417e-10, -3.714574549216284e-11,  1.872249409592536e-12, -8.301454110180557e-14,  3.298132407250511e-15, -1.190488401062684e-16,
  3.946507947907838e-18, -1.210999951420374e-19,  7.974147035356758e-07, -2.240877036198320e-07,  3.342818006641135e-08, -3.447755821344871e-09,  2.746347965908153e-10,
 -1.795190633913139e-11,  1.000356952818187e-12, -4.877648766350115e-14,  2.120716248504853e-15, -8.340173919335812e-17,  3.000079845850015e-18, -9.950648536050335e-20,
  2.156970253427373e-07, -6.814273805286787e-08,  1.140614365204826e-08, -1.312055462057918e-09,  1.158442511017805e-10, -8.345105085262558e-12,  5.097882630083775e-13,
 -2.711860524398061e-14,  1.280690505047817e-15, -5.448499340115665e-17,  2.112240952392205e-18, -7.523187112934072e-20,  6.141789830984606e-08, -2.144632463448398e-08,
  3.970574531472870e-09, -5.029299165327766e-10,  4.865045667948664e-11, -3.821105208879133e-12,  2.533466878047534e-13, -1.456556430432959e-14,  7.405246214026720e-16,
 -3.379329633205352e-17,  1.400516502127039e-18, -5.315129182131301e-20,  1.892648607693973e-08, -7.176455559548483e-09,  1.446290235965121e-09, -1.987964446219095e-10,
  2.078640993082602e-11, -1.757738311824098e-12,  1.249999582998527e-13, -7.680777499009223e-15,  4.159615052658496e-16, -2.015702050177388e-17,  8.845031442284553e-19,
 -3.544057019592045e-20,  6.405557958785103e-09, -2.589013944555550e-09,  5.580037912945727e-10, -8.186244442266216e-11,  9.109382338868749e-12, -8.172920925570245e-13,
  6.148364339798273e-14, -3.985246747151795e-15,  2.270623722516772e-16, -1.154702171400512e-17,  5.304800887671793e-19, -2.220166940157080e-20,  2.315398163907899e-09,
 -9.785919389274079e-10,  2.212335666019259e-10, -3.400545659962817e-11,  3.956920137466744e-12, -3.704536748703237e-13,  2.901990617663507e-14, -1.954775312088184e-15,
  1.155207681681371e-16, -6.082342715252534e-18,  2.888102667404310e-19, -1.247196643664879e-20,  7.179322585604492e-10, -3.111077881099691e-10,  7.226155307454472e-11,
 -1.140556148473866e-11,  1.361376953233623e-12, -1.305864278516121e-13,  1.046866927559252e-14, -7.208212292972024e-16,  4.349625252054795e-17, -2.336003080948750e-18,
  1.130315254313928e-19, -4.969150336325113e-21,  1.187374012711429e-01, -6.042896103452461e-04,  3.274469445931156e-06, -1.856156827675653e-08,  1.081008792213363e-10,
 -6.386651409256900e-13,  3.790881476956908e-15, -2.251527286760851e-17,  1.332140362582100e-19, -7.857160394379428e-22,  4.603356081178275e-24, -2.689653008669847e-26,
  1.032786995602477e-01, -7.585375760716272e-04,  6.830536343815395e-06, -6.138726418480689e-08,  5.310287869575116e-10, -4.431749788878909e-12,  3.590402197596176e-14,
 -2.838033209473084e-16,  2.196522490069638e-18, -1.669056908309515e-20,  1.247602779865820e-22, -9.188778482371157e-25,  7.817870730144416e-02, -9.288781895565546e-04,
  1.239826847056206e-05, -1.498225858760905e-07,  1.679718751535863e-09, -1.781680300909859e-11,  1.808209214126242e-13, -1.768780051593485e-15,  1.676465931590799e-17,
 -1.545757369378060e-19,  1.390817990311080e-21, -1.224146696201402e-23,  5.155857815771520e-02, -9.668326503023876e-04,  1.734629338236119e-05, -2.680972868355855e-07,
  3.763184413487825e-09, -4.914879261825471e-11,  6.059038731330107e-13, -7.119807767285020e-15,  8.031067412500498e-17, -8.742235999592657e-19,  9.221582646242367e-21,
 -9.455906041161235e-23,  2.967657075252218e-02, -8.319228308517504e-04,  1.926104632709714e-05, -3.724341801300187e-07,  6.406641068770768e-09, -1.009212760536643e-10,
  1.482100001753741e-12, -2.053871774765017e-14,  2.709175466849940e-16, -3.423614878598614e-18,  4.165760707606152e-20, -4.899357880212246e-22,  1.494635863047209e-02,
 -5.951970269545565e-04,  1.742751941507416e-05, -4.148313101858920e-07,  8.609618891120747e-09, -1.612354657965356e-10,  2.782964557012940e-12, -4.490597170256365e-14,
  6.843149371945258e-16, -9.923137607545648e-18,  1.377267853345276e-19, -1.837825222013257e-21,  6.609972885758251e-03, -3.584909686955957e-04,  1.309021458932748e-05,
 -3.785804129900002e-07,  9.368436044631460e-09, -2.063459011783579e-10,  4.144238476758438e-12, -7.713204419910822e-14,  1.345745235303268e-15, -2.219982788640086e-17,
  3.485485284939878e-19, -5.234659719508355e-21,  2.579151508492522e-03, -1.841382914261358e-04,  8.284125220266631e-06, -2.879446191688395e-07,  8.416498853587310e-09,
 -2.161862491263074e-10,  5.012631069893140e-12, -1.068162934253967e-13,  2.118779943854307e-15, -3.949447862987392e-17,  6.968966521749616e-19, -1.170555679947572e-20,
  8.935528787081169e-04, -8.169061056803972e-05,  4.477096417047751e-06, -1.852927977856893e-07,  6.347115441969055e-09, -1.887947183106230e-10,  5.021235366291280e-12,
 -1.217683255401853e-13,  2.730273318713783e-15, -5.719097374129397e-17,  1.128154942018336e-18, -2.108374059777700e-20,  2.771746684624722e-04, -3.171223301210742e-05,
  2.094561763033678e-06, -1.023611009761552e-07,  4.080761067978447e-09, -1.397072799242923e-10,  4.238405985328952e-12, -1.163644510476445e-13,  2.934787964130294e-15,
 -6.875762805767975e-17,  1.509366226579535e-18, -3.124678493678955e-20,  7.782219096015675e-05, -1.092674582547395e-05,  8.607918972806060e-07, -4.928793814347303e-08,
  2.272238931755160e-09, -8.903593352451885e-11,  3.065544961118687e-12, -9.483572570077299e-14,  2.678417017305204e-15, -6.988668219046395e-17,  1.700256355605243e-18,
 -3.883442415300266e-20,  2.005756146043598e-05, -3.396706597615327e-06,  3.159448745716429e-07, -2.103579981533501e-08,  1.114469944998802e-09, -4.971090904401763e-11,
  1.932943716220404e-12, -6.707379742326939e-14,  2.112243594480175e-15, -6.112941659631275e-17,  1.641713055073299e-18, -4.121127638720649e-20,  4.831470831797572e-06,
 -9.712440950406899e-07,  1.055919172649117e-07, -8.111920359385666e-09,  4.907261277913375e-10, -2.477742745505267e-11,  1.082538810800965e-12, -4.193758360300118e-14,
  1.466065538512525e-15, -4.686091363877271e-17,  1.383605246496447e-18, -3.802080303567086e-20,  1.112535581444188e-06, -2.614433093578682e-07,  3.287656948385493e-08,
 -2.890309910846226e-09,  1.982626255414868e-10, -1.126216253044075e-11,  5.497961338842619e-13, -2.365559903365994e-14,  9.135175148112194e-16, -3.209938030721062e-17,
  1.037288277451948e-18, -3.106710519409320e-20,  2.517811019511420e-07, -6.811328053202421e-08,  9.796820783611905e-09, -9.766361437344103e-10,  7.536601055784338e-11,
 -4.782422543933995e-12,  2.591822312385271e-13, -1.231076070687577e-14,  5.221812250430180e-16, -2.006125582276323e-17,  7.058116629627176e-19, -2.292343576036510e-20,
  5.787168924458935e-08, -1.773766459101073e-08,  2.882140931071339e-09, -3.223945744408500e-10,  2.772931287788561e-11, -1.949116701908533e-12,  1.163548917824460e-13,
 -6.056729348541733e-15,  2.802367378845324e-16, -1.169379440090403e-17,  4.451093944965706e-19, -1.558100157495206e-20,  1.401315201498177e-08, -4.784392295544474e-09,
  8.659909842884742e-10, -1.073620968325941e-10,  1.017807537857353e-11, -7.843896897196822e-13,  5.108729779022111e-14, -2.888225720154467e-15,  1.445319894144562e-16,
 -6.497660243143631e-18,  2.655022432332434e-19, -9.942242891880064e-21,  3.706447066705959e-09, -1.384199806665956e-09,  2.746372144179169e-10, -3.718927698470622e-11,
  3.833995185078713e-12, -3.199225189366186e-13,  2.246753441961380e-14, -1.364329149460116e-15,  7.306782105055608e-17, -3.503705037363770e-18,  1.522222698376393e-19,
 -6.042240308911498e-21,  1.098184021124895e-09, -4.399247466327153e-10,  9.393169434163760e-11, -1.365631320938740e-11,  1.506644756420726e-12, -1.340842683265744e-13,
  1.001006087055026e-14, -6.441627568592045e-16,  3.645216819129701e-17, -1.841826083552227e-18,  8.410070106476643e-20, -3.499575584329626e-21,  3.584946008490175e-10,
 -1.508833502872747e-10,  3.395822567576879e-11, -5.196953521094195e-12,  6.022116287930947e-13, -5.615762820592824e-14,  4.382718363858154e-15, -2.941729227823443e-16,
  1.732626280261312e-17, -9.093485606932434e-19,  4.304846241865048e-20, -1.853681349569933e-21,  1.046208426652486e-10, -4.527266964623866e-11,  1.049941310745451e-11,
 -1.654681384031410e-12,  1.972135887322262e-13, -1.889040584558268e-14,  1.512321170640092e-15, -1.039952095208750e-16,  6.267491449331548e-18, -3.361965719995556e-19,
  1.624868064965724e-20, -7.135431220698127e-22,  1.163712639317598e-01, -5.789563463006891e-04,  3.061702239194642e-06, -1.692940332402215e-08,  9.618870636326437e-11,
 -5.547923356840068e-13,  3.216122010031372e-15, -1.867164791214372e-17,  1.079763315199067e-19, -6.232072776421388e-22,  3.569081287999119e-24, -2.043385390065470e-26,
  1.003493678066873e-01, -7.067018791097494e-04,  6.142087587711691e-06, -5.355563041266072e-08,  4.504059025509377e-10, -3.657991171238457e-12,  2.885767671731360e-14,
 -2.222390023649505e-16,  1.676542950312707e-18, -1.242268516935888e-20,  9.058037072155155e-23, -6.510149753274423e-25,  7.465079146215313e-02, -8.364522714272616e-04,
  1.075061161727990e-05, -1.255777942726142e-07,  1.363060916551016e-09, -1.401557244734343e-11,  1.380399431227838e-13, -1.311580103172100e-15,  1.208396318592954e-17,
 -1.083752403367962e-19,  9.490305981549913e-22, -8.133630476609147e-24,  4.794976550518373e-02, -8.399772763107753e-04,  1.446033939052379e-05, -2.150229492019493e-07,
  2.910863871339926e-09, -3.673567433793801e-11,  4.382612036279893e-13, -4.989632661411955e-15,  5.458544944505793e-17, -5.767655872542065e-19,  5.909897918711140e-21,
 -5.890682935938461e-23,  2.663102378958260e-02, -6.941104424020811e-04,  1.534603126127371e-05, -2.843219258849929e-07,  4.701956126884658e-09, -7.137559588879987e-11,
  1.011928306403973e-12, -1.355763698591183e-14,  1.731074690884095e-16, -2.119754301639934e-18,  2.501579562343577e-20, -2.855846464281074e-22,  1.281589394266026e-02,
 -4.735704140673231e-04,  1.318033748931249e-05, -2.996329655347755e-07,  5.962488911689680e-09, -1.073538870309404e-10,  1.785220228900022e-12, -2.780057514680161e-14,
  4.094393965911825e-16, -5.745097819206620e-18,  7.724076528744979e-20, -9.993777321326132e-22,  5.359904465386753e-03, -2.696747531697674e-04,  9.326121970595587e-06,
 -2.569520355735922e-07,  6.083532994090030e-09, -1.285866661563760e-10,  2.484146806944929e-12, -4.455836820195535e-14,  7.504395330594328e-16, -1.196630992861140e-17,
  1.818265910336844e-19, -2.645692466077388e-21,  1.956107196671460e-03, -1.296880216996845e-04,  5.512784172835717e-06, -1.822281343101162e-07,  5.088194764644438e-09,
 -1.252555677746995e-10,  2.790461912751532e-12, -5.725222398992228e-14,  1.095335063101975e-15, -1.972248003900017e-17,  3.366168080310698e-19, -5.475502566260876e-21,
  6.264480127838945e-04, -5.329101623767473e-05,  2.756723643621490e-06, -1.084016556854860e-07,  3.544102102070359e-09, -1.009572915846808e-10,  2.578323128984422e-12,
 -6.017234775406525e-14,  1.300817983813865e-15, -2.631417202030606e-17,  5.019999924763625e-19, -9.084861511474219e-21,  1.773856629309715e-04, -1.894036700979316e-05,
  1.181054009278678e-06, -5.483774267519845e-08,  2.086385599341471e-09, -6.840050490210354e-11,  1.992586253971799e-12, -5.264992372579716e-14,  1.280447178304422e-15,
 -2.897674210326626e-17,  6.153452349486722e-19, -1.234010427076478e-20,  4.486409239432160e-05, -5.901411579881524e-06,  4.395525394391343e-07, -2.393472616275074e-08,
  1.053828968476351e-09, -3.956929270512300e-11,  1.309062082418699e-12, -3.900137409409125e-14,  1.062916916493262e-15, -2.680901609938756e-17,  6.314443462298369e-19,
 -1.398248530170313e-20,  1.027280325345169e-05, -1.637605478027741e-06,  1.443970047641563e-07, -9.160795805999923e-09,  4.642855485488374e-10, -1.987420833124492e-11,
  7.435749884338951e-13, -2.488301205123887e-14,  7.571602934974664e-16, -2.120984585324449e-17,  5.522019896981480e-19, -1.345698098291823e-20,  2.167771480200432e-06,
 -4.125480463610651e-07,  4.267978375763427e-08, -3.133696944744872e-09,  1.818236789656543e-10, -8.831150164225673e-12,  3.720764112146895e-13, -1.392999377931572e-14,
  4.714950702212984e-16, -1.461630254126747e-17,  4.191746962969081e-19, -1.120381843058965e-20,  4.314317691490112e-07, -9.661565006708785e-08,  1.161808523573275e-08,
 -9.802020586499164e-10,  6.472334632384768e-11, -3.548324722795707e-12,  1.675575604358008e-13, -6.987394305097094e-15,  2.619860441247779e-16, -8.951992675027556e-18,
  2.817088937874788e-19, -8.227267775224282e-21,  8.340107811159895e-08, -2.165981709140772e-08,  2.996847456862255e-09, -2.881809956175918e-10,  2.150583531923686e-11,
 -1.322646474901204e-12,  6.960969092368833e-14, -3.216450987274716e-15,  1.329293868498632e-16, -4.982871648640078e-18,  1.712736614849197e-19, -5.441105747315641e-21,
  1.623946852705035e-08, -4.816450657786934e-09,  7.579697352650667e-10, -8.228092223944833e-11,  6.881477852054390e-12, -4.711879141878008e-13,  2.744481422835715e-14,
 -1.395949599580607e-15,  6.319592670857457e-17, -2.583310306927974e-18,  9.643279802606541e-20, -3.313944812820427e-21,  3.323446373428275e-09, -1.106991117740179e-09,
  1.954898207904898e-10, -2.367741958788940e-11,  2.196062049848329e-12, -1.658045164093027e-13,  1.059269094117527e-14, -5.880991593033982e-16,  2.893106020457436e-17,
 -1.279839162012974e-18,  5.150485570818830e-20, -1.901132501244616e-21,  7.478412533952847e-10, -2.746112501758795e-10,  5.355355681482932e-11, -7.133448659666256e-12,
  7.240953579544996e-13, -5.954615819870152e-14,  4.124841492550106e-15, -2.472661266242204e-16,  1.308245338217649e-17, -6.201650288029556e-19,  2.665330936583982e-20,
 -1.047201451669393e-21,  1.919917382679176e-10, -7.614606215791247e-11,  1.608968257183341e-11, -2.315829643650096e-12,  2.530770064649207e-13, -2.232151177209414e-14,
  1.652387380485685e-15, -1.054901165749186e-16,  5.924855103515292e-18, -2.972517717091214e-19,  1.348239789624629e-20, -5.574932110995557e-22,  5.605964659284023e-11,
 -2.348397091567978e-11,  5.258982685133726e-12, -8.009317995436964e-13,  9.238157234522531e-14, -8.577088622311505e-15,  6.666111410786813e-16, -4.456843404811483e-17,
  2.615273907336963e-18, -1.367780056747759e-19,  6.453531481361765e-21, -2.770175981568046e-22,  1.529876336983592e-11, -6.610040723247092e-12,  1.530386812424802e-12,
 -2.407844904058822e-13,  2.865187367863305e-14, -2.740230657929344e-15,  2.190520832783004e-16, -1.504185178039675e-17,  9.052993963608835e-19, -4.849833623387445e-20,
  2.341046138736980e-21, -1.026818757942533e-22,  1.141031750056703e-01, -5.552499933107796e-04,  2.867430467737611e-06, -1.547512795854648e-08,  8.582431497918124e-11,
 -4.835084258102423e-13,  2.738503183101733e-15, -1.554948509489167e-17,  8.790793671404115e-20, -4.969081786084226e-22,  2.780817937916409e-24, -1.562914826814710e-26,
  9.761692938466093e-02, -6.600186640053034e-04,  5.540361080663204e-06, -4.689879585207318e-08,  3.836975479615945e-10, -3.034406401492612e-12,  2.332352352183360e-14,
 -1.750981728342641e-16,  1.288193115327728e-18, -9.312707386797134e-21,  6.627020700425355e-23, -4.650208029048172e-25,  7.146794497933931e-02, -7.561245531911093e-04,
  9.365832416711271e-06, -1.058430509485968e-07,  1.113115818640213e-09, -1.110296849550413e-11,  1.061912357084567e-13, -9.806371521073871e-16,  8.787583473187922e-18,
 -7.670179997143484e-20,  6.540478211522748e-22, -5.461068749440942e-24,  4.480592864528253e-02, -7.338762552659931e-04,  1.213699085452199e-05, -1.737995233632075e-07,
  2.270960826237449e-09, -2.771421255388622e-11,  3.201824442764139e-13, -3.534114972591553e-15,  3.751918404265593e-17, -3.850311376959548e-19,  3.834504086924957e-21,
 -3.717117809879637e-23,  2.408018263722609e-02, -5.838112285290759e-04,  1.234239503696907e-05, -2.193098154529894e-07,  3.489517417795036e-09, -5.108289564581532e-11,
  6.996411248699708e-13, -9.068197324082340e-15,  1.121438918261317e-16, -1.331392643875662e-18,  1.524681849181794e-20, -1.690391865749677e-22,  1.111181760864475e-02,
 -3.810375667272807e-04,  1.009316406756105e-05, -2.193221164576338e-07,  4.187724276955765e-09, -7.254079812574015e-11,  1.162940992996030e-12, -1.748789353942525e-14,
  2.490523139472386e-16, -3.383215904282466e-18,  4.408188814784314e-20, -5.532588308973823e-22,  4.412997598370200e-03, -2.059210842216306e-04,  6.751290811238473e-06,
 -1.773300679609545e-07,  4.019437776264333e-09, -8.157813819321315e-11,  1.516775497341185e-12, -2.623303438032758e-14,  4.266664880294006e-16, -6.579149510279480e-18,
  9.678645785003352e-20, -1.364909112018053e-21,  1.513439966743138e-03, -9.311790065040042e-05,  3.742297132699245e-06, -1.177005036326485e-07,  3.140936202230385e-09,
 -7.413410386662927e-11,  1.587486115301674e-12, -3.137079877906364e-14,  5.790632005298706e-16, -1.007464493093585e-17,  1.663636289389970e-19, -2.621262669957307e-21,
  4.503360331620191e-04, -3.561065777179274e-05,  1.739013134184789e-06, -6.498525828521360e-08,  2.028326882026776e-09, -5.534561936610366e-11,  1.357528283469063e-12,
 -3.049446803865686e-14,  6.357031974395256e-16, -1.242037703150162e-17,  2.291747278357536e-19, -4.016539337970892e-21,  1.170360765672932e-04, -1.164592570621777e-05,
  6.853735347071186e-07, -3.023011103810630e-08,  1.097568290047431e-09, -3.445580806426749e-11,  9.637761941957455e-13, -2.450751357420519e-14,  5.747064618820912e-16,
 -1.256168238822237e-17,  2.580340242408010e-19, -5.012150815901358e-21,  2.680963690279968e-05, -3.297869132208423e-06,  2.320472396139513e-07, -1.200959518301433e-08,
  5.047929259275404e-10, -1.815604858081119e-11,  5.769537850644075e-13, -1.654939888707038e-14,  4.350958255365619e-16, -1.060482289835791e-17,  2.417483385837559e-19,
 -5.188357356684514e-21,  5.481678162964995e-06, -8.207745783478509e-07,  6.851699317117478e-08, -4.137845128490209e-09,  2.004555787538164e-10, -8.228830918769706e-12,
  2.960485548930398e-13, -9.548323355508898e-15,  2.805824813896531e-16, -7.603577354099346e-18,  1.918064440109772e-19, -4.535444553164718e-21,  1.017712023570288e-06,
 -1.828947271563564e-07,  1.797346935494571e-08, -1.259508920694719e-09,  7.000938115456310e-11, -3.267499934548513e-12,  1.326300785653629e-13, -4.794395789515895e-15,
  1.569906029113491e-16, -4.716203026517247e-18,  1.312732686116855e-19, -3.410289647023454e-21,  1.755608054348413e-07, -3.736209715409055e-08,  4.287234730375211e-09,
 -3.465106967998195e-10,  2.199103313427777e-11, -1.161967918867883e-12,  5.300932342914392e-14, -2.140028031404866e-15,  7.782008815219538e-17, -2.583158676877449e-18,
  7.908395763460313e-20, -2.250063508711829e-21,  2.900935383453382e-08, -7.211898044558431e-09,  9.576276505917594e-10, -8.864904423302377e-11,  6.386127676672752e-12,
 -3.800493607531646e-13,  1.939517503126662e-14, -8.706338593945419e-16,  3.501339013202527e-17, -1.279072870251956e-18,  4.290382816949434e-20, -1.331783487451778e-21,
  4.774678327037119e-09, -1.366542806151121e-09,  2.077853577020090e-10, -2.184338172410252e-11,  1.773006764895995e-12, -1.180560146541224e-13,  6.698638800637895e-15,
 -3.324422934565222e-16,  1.470538139052408e-17, -5.881216434524141e-19,  2.150462778670553e-20, -7.246929654634195e-22,  8.212956072327922e-10, -2.662342089338606e-10,
  4.576964863341237e-11, -5.404986207376994e-12,  4.895691699693147e-13, -3.615198022614168e-14,  2.262084788585392e-15, -1.231591137139802e-16,  5.948285548868877e-18,
 -2.586124918896147e-19,  1.023826586246679e-20, -3.721107429138348e-22,  1.558534792692704e-10, -5.616620948387027e-11,  1.074670836786197e-11, -1.405799908762716e-12,
  1.402895744380977e-13, -1.135387834003591e-14,  7.747891045770200e-16, -4.579506924092447e-17,  2.391013121250471e-18, -1.119362718596208e-19,  4.754356483391058e-21,
 -1.847317325274608e-22,  3.429704250334542e-11, -1.345099716443673e-11,  2.809285244252265e-12, -3.998550657247611e-13,  4.323784490070529e-14, -3.775897163475917e-15,
  2.769176070079903e-16, -1.752398172729674e-17,  9.761219478602048e-19, -4.859177376526411e-20,  2.187806208021713e-21, -8.983996656806739e-23,  8.863802781328377e-12,
 -3.693597401673741e-12,  8.225171720604428e-13, -1.245894954222433e-13,  1.429652030360938e-14, -1.320888015920060e-15,  1.021876052405270e-16, -6.802439198195726e-18,
  3.975311029458631e-19, -2.071022335581466e-20,  9.735802613273706e-22, -4.164629903768838e-23,  2.245665851121018e-12, -9.686199815807191e-13,  2.238438484818020e-13,
 -3.515440484532912e-14,  4.175800220584207e-15, -3.986951681168925e-16,  3.182000658885564e-17, -2.181644714081886e-18,  1.311094969491037e-19, -7.013837943597063e-21,
  3.381053271409973e-22, -1.481068740117773e-23,  1.119269098261282e-01, -5.330307239418396e-04,  2.689660127196093e-06, -1.417587177542056e-08,  7.677769636842772e-11,
 -4.227068949480874e-13,  2.339956696943042e-15, -1.300245816486931e-17,  7.186614322437506e-20, -3.982976374429189e-22,  2.175774597335904e-24, -1.204553513752817e-26,
  9.506207769556113e-02, -6.178469744774175e-04,  5.012501944158788e-06, -4.121631315933510e-08,  3.282327656917450e-10, -2.529109146568106e-12,  1.895091322775324e-14,
 -1.387659644993126e-16,  9.961050057759316e-19, -7.029422848252965e-21,  4.884062022221164e-23, -3.347802389063292e-25,  6.858566227889232e-02, -6.859916137955602e-04,
  8.195671316462979e-06, -8.967999440936154e-08,  9.144722775673872e-10, -8.854478883372478e-12,  8.228857398363162e-14, -7.390002243275857e-16,  6.444619790145134e-18,
 -5.477497795748953e-20,  4.550573766326952e-22, -3.703512159976571e-24,  4.205222644827786e-02, -6.445445748867134e-04,  1.025238349212735e-05, -1.415122643969699e-07,
  1.786155412397694e-09, -2.109345053928849e-11,  2.361459139872291e-13, -2.528601526920215e-15,  2.606587397806313e-17, -2.599414522464474e-19,  2.517396516572794e-21,
 -2.374535408357586e-23,  2.192699307937114e-02, -4.947219100993043e-04,  1.001469201780894e-05, -1.708180301851915e-07,  2.617128757263748e-09, -3.697332364095937e-11,
  4.895284683817180e-13, -6.141913068423754e-15,  7.360928643615798e-17, -8.477344583726919e-19,  9.425400426327006e-21, -1.015326308833626e-22,  9.733963676283460e-03,
 -3.097818297595505e-04,  7.819936724324610e-06, -1.625601935622618e-07,  2.980569134532368e-09, -4.970702808036085e-11,  7.687214250887780e-13, -1.116912997874890e-14,
  1.538947604596923e-16, -2.024939546178968e-18,  2.558156572298909e-20, -3.115804113132119e-22,  3.685251609703860e-03, -1.594415987049523e-04,  4.961140128646556e-06,
 -1.243182333950652e-07,  2.699538160790687e-09, -5.264177913076763e-11,  9.425072003369337e-13, -1.572558602822780e-14,  2.471166583916960e-16, -3.686424235494663e-18,
  5.252531197756820e-20, -7.181615074203656e-22,  1.192972734650560e-03, -6.807539112487312e-05,  2.588464132417542e-06, -7.750175907958784e-08,  1.977652131812906e-09,
 -4.477536475653997e-11,  9.219974662023522e-13, -1.755549800397687e-14,  3.127603767150845e-16, -5.259476672135128e-18,  8.405235013093252e-20, -1.283150260799814e-21,
  3.314596080746584e-04, -2.434005452405551e-05,  1.122411429311208e-06, -3.987079297691703e-08,  1.188392192425073e-09, -3.106989542249871e-11,  7.321181965666976e-13,
 -1.583301811966842e-14,  3.183439483516776e-16, -6.008394508183242e-18,  1.072436558892123e-19, -1.820455561494022e-21,  7.948231292783314e-05, -7.360675037257340e-06,
  4.087510174793598e-07, -1.712583500967397e-08,  5.933710646635400e-10, -1.783759685668324e-11,  4.790911993236796e-13, -1.172442186653516e-14,  2.651079950601983e-16,
 -5.596715362884929e-18,  1.112013415321861e-19, -2.092110231705496e-21,  1.658096679360649e-05, -1.904038486657112e-06,  1.264752500327091e-07, -6.218713517843967e-09,
  2.494525958923531e-10, -8.592095722033407e-12,  2.621990579437257e-13, -7.239249578633594e-15,  1.835611432407584e-16, -4.322519016780993e-18,  9.534586086629118e-20,
 -1.982811162719654e-21,  3.043545739351297e-06, -4.271179880548936e-07,  3.371548996280206e-08, -1.936554660329906e-09,  8.961094920779533e-11, -3.525596669427107e-12,
  1.219013484022077e-13, -3.787353968328343e-15,  1.074250858111019e-16, -2.814918791078279e-18,  6.876949092438738e-20, -1.577111369096849e-21,  4.995029132676831e-07,
 -8.455495977936677e-08,  7.880054384626922e-09, -5.263420842869370e-10,  2.799685533064588e-11, -1.254418164337263e-12,  4.901172867798255e-14, -1.709275937399766e-15,
  5.410448755897504e-17, -1.573962065336414e-18,  4.249135919767176e-20, -1.072175138050556e-21,  7.495237420210005e-08, -1.511611084592641e-08,  1.651747631153098e-09,
 -1.276740321695517e-10,  7.776383918015457e-12, -3.954979451146150e-13,  1.741014308113851e-14, -6.796833989863472e-16,  2.394638364505659e-17, -7.714248304381002e-19,
  2.295538667083709e-20, -6.357069076318367e-22,  1.060308897235866e-08, -2.515852173259735e-09,  3.198455338988268e-10, -2.844589416407973e-11,  1.974633577280697e-12,
 -1.135304173154496e-13,  5.609986337391702e-15, -2.443172258274358e-16,  9.549096138273190e-18, -3.395578683715214e-19,  1.110249697250601e-20, -3.363876904023948e-22,
  1.473335325936868e-09, -4.057264922150021e-10,  5.945824707217466e-11, -6.039906108158879e-12,  4.748817701431432e-13, -3.069478526811744e-14,  1.693929887203447e-15,
 -8.190276925087012e-17,  3.535064964906889e-18, -1.381428665842358e-19,  4.941746190912706e-21, -1.631191658229019e-22,  2.119879823312030e-10, -6.670187150169983e-11,
  1.113675003007343e-11, -1.279565880209047e-12,  1.129692033854519e-13, -8.144911334173066e-15,  4.983491684348929e-16, -2.656815761884656e-17,  1.258057891572344e-18,
 -5.368682110232818e-20,  2.088368550515197e-21, -7.465268738801684e-23,  3.363815693208428e-11, -1.187213148557053e-11,  2.224342447321136e-12, -2.852350562443232e-13,
  2.793795638016230e-14, -2.221866946289424e-15,  1.491553722861390e-16, -8.681477409253893e-18,  4.467636234444092e-19, -2.063269318384121e-20,  8.651765666740999e-22,
 -3.321283986117743e-23,  6.274318075904507e-12, -2.429934304606471e-12,  5.009383446190198e-13, -7.041864484013013e-14,  7.525869426850403e-15, -6.500253163359375e-16,
  4.718145494253839e-17, -2.956902224967352e-18,  1.632089647756380e-19, -8.055111383078297e-21,  3.597509305163632e-22, -1.466068196330055e-23,  1.418898033946504e-12,
 -5.877528002292027e-13,  1.300632787836447e-13, -1.958170088757214e-14,  2.234062065189341e-15, -2.052902918762536e-16,  1.580064565479687e-17, -1.046753139528949e-18,
  6.089392082763366e-20, -3.158803749618609e-21,  1.478933114550036e-22, -6.302210721815132e-24,  3.310191530845605e-13, -1.425088685900145e-13,  3.286578106298313e-14,
 -5.151160000388370e-15,  6.106951710678261e-16, -5.819985127946412e-17,  4.636751864685556e-18, -3.173697320789198e-19,  1.904219149256310e-20, -1.017117919922913e-21,
  4.895871599514197e-23, -2.141633576140157e-24,  1.098367727859165e-01, -5.121736245225776e-04,  2.526650894844937e-06, -1.301212970523837e-08,  6.885694742120424e-11,
 -3.706695653377029e-13,  2.006042319361505e-15, -1.091634906540032e-17,  5.897404458479936e-20, -3.210229372682537e-22,  1.707378130051696e-24, -9.376222002685340e-27,
  9.266787855655398e-02, -5.796397526427495e-04,  4.547823908513204e-06, -3.634579349785777e-08,  2.819017505874948e-10, -2.117531703474207e-12,  1.547620827171529e-14,
 -1.105895094843254e-16,  7.749328250627893e-19, -5.341026318426189e-21,  3.624745092870874e-23, -2.428465835718860e-25,  6.596634513570930e-02, -6.244949414978766e-04,
  7.201786090926946e-06, -7.636448847074279e-08,  7.555690436612977e-10, -7.106257328384190e-12,  6.421063113583222e-14, -5.611051268864932e-16,  4.764598970142781e-18,
 -3.945348449603553e-20,  3.194993150875789e-22, -2.535737439671504e-24,  3.962797734711318e-02, -5.688624357747993e-04,  8.712721121459135e-06, -1.160232764510349e-07,
  1.415679356312130e-09, -1.618930378227309e-11,  1.757433485292692e-13, -1.826658260566312e-15,  1.829435333368352e-17, -1.773844307384972e-19,  1.671397019027515e-21,
 -1.534791462688179e-23,  2.009629411592893e-02, -4.221441045738026e-04,  8.193636415638982e-06, -1.342753762203530e-07,  1.982484028174896e-09, -2.704795047163790e-11,
  3.464161707828032e-13, -4.209862895967906e-15,  4.892364840579454e-17, -5.468587652968059e-19,  5.906116982195225e-21, -6.184621310402813e-23,  8.608653301036457e-03,
 -2.542840425602657e-04,  6.125521296992874e-06, -1.219189157138692e-07,  2.148204011718004e-09, -3.451496598764052e-11,  5.152383403540967e-13, -7.237377820071993e-15,
  9.653200695540944e-17, -1.230911350295336e-18,  1.508448623599693e-20, -1.783772140572931e-22,  3.118355623716449e-03, -1.250581920948637e-04,  3.697341052688697e-06,
 -8.845434855455245e-08,  1.841384696968628e-09, -3.452135232803231e-11,  5.955168124436171e-13, -9.590380669054373e-15,  1.456776387162346e-16, -2.103336832538142e-18,
  2.903800767787436e-20, -3.850768249989139e-22,  9.568750690085114e-04, -5.061084276136557e-05,  1.822228263969165e-06, -5.196991268757112e-08,  1.268787279847658e-09,
 -2.756935154403890e-11,  5.461526852125946e-13, -1.002409822777067e-14,  1.724271595792383e-16, -2.803574849105097e-18,  4.337437096920111e-20, -6.417390292222938e-22,
  2.494288624822916e-04, -1.699301451174559e-05,  7.402668544013285e-07, -2.500533610515049e-08,  7.119909769873749e-10, -1.784154910347444e-11,  4.039986971007776e-13,
 -8.413748447640068e-15,  1.632020611306621e-16, -2.976187179007254e-18,  5.139659163219781e-20, -8.451510350158880e-22,  5.547468537949143e-05, -4.774855880772488e-06,
  2.501873735514862e-07, -9.957662866948580e-09,  3.292733008110880e-10, -9.479597715557317e-12,  2.445008937784399e-13, -5.758877584136064e-15,  1.255682777219975e-16,
 -2.560453646979742e-18,  4.920973827744279e-20, -8.967144161841211e-22,  1.059679791378048e-05, -1.134021609439377e-06,  7.107176838081795e-08, -3.318888511448905e-09,
  1.270238876548143e-10, -4.189105103623173e-12,  1.227426130115110e-13, -3.261452423292156e-15,  7.974693955235427e-17, -1.813997327873886e-18,  3.871077332403177e-20,
 -7.799118583884070e-22,  1.755800943363153e-06, -2.304549554567649e-07,  1.718352392731222e-08, -9.380188441903990e-10,  4.143550382474147e-11, -1.561617244077647e-12,
  5.186826576642134e-14, -1.551691554496990e-15,  4.246514246425631e-17, -1.075527066168043e-18,  2.543693285003359e-20, -5.655500484950661e-22,  2.560380797311717e-07,
 -4.072380116147816e-08,  3.593507508342414e-09, -2.285116538285551e-10,  1.161995768211659e-11, -4.993829196418012e-13,  1.876636850099759e-14, -6.309499705275575e-16,
  1.929289830292495e-17, -5.431429467189854e-19,  1.421238767613646e-20, -3.481081179685776e-22,  3.355923695147675e-08, -6.395739631026424e-09,  6.641648702220750e-10,
 -4.901713889022805e-11,  2.861311496432540e-12, -1.398987503659747e-13,  5.935874296936497e-15, -2.238594014619770e-16,  7.633912520401652e-18, -2.384489856144243e-19,
  6.890634861241224e-21, -1.855803951616789e-22,  4.074361247043886e-09, -9.198772227116817e-10,  1.117022220141135e-10, -9.525276785806874e-12,  6.360515952862324e-13,
 -3.527480381463507e-14,  1.685360982971033e-15, -7.111570378438277e-17,  2.698057903622254e-18, -9.328095768354896e-20,  2.969838217272082e-21, -8.773729667868587e-23,
  4.778408303038960e-10, -1.262202138096027e-10,  1.778196335862103e-11, -1.741588619060015e-12,  1.323759123705389e-13, -8.291172831909561e-15,  4.442955519273244e-16,
 -2.089756295971829e-17,  8.788724931722748e-19, -3.351418858836276e-20,  1.171475762127782e-21, -3.783169133344099e-23,  5.728590009958700e-11, -1.744603342626111e-11,
  2.821828913270608e-12, -3.147393257769340e-13,  2.703043342857573e-14, -1.899300918803656e-15,  1.134446903180742e-16, -5.913035307655288e-18,  2.741198684770788e-19,
 -1.146663719181542e-20,  4.377180441611446e-22, -1.537146763811063e-23,  7.539877630219030e-12, -2.600067872880263e-12,  4.759800691124928e-13, -5.971573067374942e-14,
  5.730508495793482e-15, -4.471063111413595e-16,  2.948225964843677e-17, -1.687458395654874e-18,  8.548317950729601e-20, -3.889824098155753e-21,  1.608510508634356e-22,
 -6.094333787783815e-24,  1.178362468687832e-12, -4.499349368135467e-13,  9.141518138279610e-14, -1.267358360449040e-14,  1.336927430335509e-15, -1.140714775922241e-16,
  8.185562350903732e-18, -5.075215645380447e-19,  2.773240526721320e-20, -1.355826443429213e-21,  6.001584171355265e-23, -2.425391734887171e-24,  2.302934345963685e-13,
 -9.475397499904510e-14,  2.081973798864651e-14, -3.113183672750922e-15,  3.528939328412106e-16, -3.223123073761461e-17,  2.466612849417919e-18, -1.625311015510796e-19,
  9.407412842507818e-21, -4.856807820821080e-22,  2.263744185059135e-23, -9.605873106844813e-25,  4.902006085943246e-14, -2.105961593984798e-14,  4.845801350093941e-15,
 -7.578100505756825e-16,  8.965041375126926e-17, -8.526380450273414e-18,  6.779752559816126e-19, -4.631941133669755e-20,  2.774279242477445e-21, -1.479367770158938e-22,
  7.109517281008892e-24, -3.105230590873877e-25,  1.078275414993295e-01, -4.925668174233493e-04,  2.376879161934472e-06, -1.196721001707904e-08,  6.190130643801816e-11,
 -3.259894193378674e-13,  1.725157030757174e-15, -9.201676614454839e-18,  4.855286691950870e-20, -2.603553669904615e-22,  1.340272494514580e-24, -7.414796058714409e-27,
  9.041942661397580e-02, -5.449281747498982e-04,  4.137401995106318e-06, -3.215499416452279e-08,  2.430283523610873e-10, -1.780626775929770e-12,  1.269984662423508e-14,
 -8.860787914008463e-17,  6.063718209122027e-19, -4.083974113678906e-21,  2.708045887673445e-23, -1.774631732253242e-25,  6.357806679797499e-02, -5.703509162728761e-04,
  6.353514069036275e-06, -6.533370201903092e-08,  6.276656384749165e-10, -5.737734021480366e-12,  5.043710429926494e-14, -4.290992467927793e-16,  3.549772564884208e-18,
 -2.865168161632479e-20,  2.262831255769396e-22, -1.752142090280519e-24,  3.748362632618124e-02, -5.043679198827492e-04,  7.446359615427864e-06, -9.574979694017775e-08,
  1.130247250011957e-09, -1.252453809286016e-11,  1.319176608390722e-13, -1.331722302047453e-15,  1.296535091600224e-17, -1.222940596219050e-19,  1.121705757364793e-21,
 -1.003222303090440e-23,  1.852932149030092e-02, -3.625393605099850e-04,  6.756159659192834e-06, -1.064686902165756e-07,  1.515959562524669e-09, -1.998825158574378e-11,
  2.477948733601977e-13, -2.918535979754249e-15,  3.290649385490221e-17, -3.571868533994827e-19,  3.749095594703838e-21, -3.818099175915239e-23,  7.681020486204143e-03,
 -2.105960845627306e-04,  4.847944174531083e-06, -9.246128144575717e-08,  1.566791785161425e-09, -2.426907722615458e-11,  3.499255367124545e-13, -4.754690288808780e-15,
  6.142305759360419e-17, -7.594020346843584e-19,  9.031678689028272e-21, -1.037371972610547e-22,  2.671201537724113e-03, -9.927226068126961e-05,  2.792164712596674e-06,
 -6.382170243485411e-08,  1.274582979351662e-09, -2.298724708194107e-11,  3.822913984172524e-13, -5.945445261892177e-15,  8.734013440309838e-17, -1.221060026528254e-18,
  1.634067932233300e-20, -2.102543350351862e-22,  7.800749027732385e-04, -3.822017276497704e-05,  1.304267935910069e-06, -3.545352810259402e-08,  8.286083901998260e-10,
 -1.728881190868245e-11,  3.296539413699201e-13, -5.834816568694391e-15,  9.694434857085653e-17, -1.524623591881479e-18,  2.284239441116300e-20, -3.276391573976359e-22,
  1.916421918509483e-04, -1.210152930250216e-05,  4.982892127074711e-07, -1.601193723472667e-08,  4.357135251632714e-10, -1.046888906720459e-11,  2.278780058989478e-13,
 -4.571646402076615e-15,  8.557198828075386e-17, -1.508153598638616e-18,  2.520432116801713e-20, -4.015589164084891e-22,  3.973123420640934e-05, -3.174342378566217e-06,
  1.569496210133662e-07, -5.934823152808157e-09,  1.873295702073549e-10, -5.165786720672366e-12,  1.279683497675603e-13, -2.901364504574032e-15,  6.101039998007493e-17,
 -1.201729581145890e-18,  2.234232078039542e-20, -3.943489097686918e-22,  6.987150675062644e-06, -6.956666529149393e-07,  4.111920979168502e-08, -1.823247415064242e-09,
  6.657145538413328e-11, -2.101878025253446e-12,  5.912716443656209e-14, -1.511885508281787e-15,  3.564491663663595e-17, -7.831453239150610e-19,  1.616659632839939e-20,
 -3.155088121063461e-22,  1.050885649117984e-06, -1.287389651810493e-07,  9.058941205047062e-09, -4.696805150260133e-10,  1.979624147966657e-11, -7.143917935187915e-13,
  2.278524446402548e-14, -6.561184459644758e-16,  1.731891546261717e-17, -4.238327472398608e-19,  9.700826586363993e-21, -2.090313963543845e-22,  1.369025700522912e-07,
 -2.040916932956960e-08,  1.702732121951763e-09, -1.029717906883732e-10,  5.001326201126804e-12, -2.060040726007033e-13,  7.440608435348883e-15, -2.410151379070468e-16,
  7.114789305157142e-18, -1.937220650658060e-19,  4.910564266392363e-21, -1.166861205690576e-22,  1.574849237767395e-08, -2.828190756669448e-09,  2.785683938117530e-10,
 -1.959970255501297e-11,  1.095073629036266e-12, -5.141324071457728e-14,  2.100416970887136e-15, -7.644749430785711e-17,  2.521043292871873e-18, -7.628695955997095e-20,
  2.139097171167630e-21, -5.598363635352888e-23,  1.646319214929672e-09, -3.525713096281453e-10,  4.079722689306661e-11, -3.329161460977402e-12,  2.134826943911836e-13,
 -1.140318222185302e-14,  5.260616389577287e-16, -2.148021649388768e-17,  7.901103838721802e-19, -2.652990450390208e-20,  8.215800426441880e-22, -2.364267549560750e-23,
  1.630925769593968e-10, -4.118989886008246e-11,  5.563788843083952e-12, -5.242103956808170e-13,  3.844271874755574e-14, -2.329017248273611e-15,  1.209888887305679e-16,
 -5.527595784844065e-18,  2.261987411666164e-19, -8.406124321014534e-21,  2.867593053525575e-22, -9.049651416312902e-24,  1.624410367912989e-11, -4.773435340657358e-12,
  7.459704424269195e-13, -8.058228230261130e-14,  6.717921891494554e-15, -4.591608117534051e-16,  2.672657519776776e-17, -1.359791797747738e-18,  6.162373987280441e-20,
 -2.523310349888693e-21,  9.440283720878376e-23, -3.252821694474279e-24,  1.760213240706986e-12, -5.915409307148360e-13,  1.055578423977677e-13, -1.292889804546007e-14,
  1.213217589253909e-15, -9.270119587565949e-17,  5.994640520225531e-18, -3.369047251370450e-19,  1.677724363775894e-20, -7.512531475336304e-22,  3.059909680573525e-23,
 -1.142957408513544e-24,  2.278051002292947e-13, -8.560379733556019e-14,  1.711138370858254e-14, -2.335875498877445e-15,  2.428637239795679e-16, -2.044307899788918e-17,
  1.448486958118900e-18, -8.875026641919146e-20,  4.795955596617966e-21, -2.320389718597333e-22,  1.017102395807680e-23, -4.072705355085659e-25,  3.796115162049340e-14,
 -1.549992553328564e-14,  3.378503511577505e-15, -5.013176716731563e-16,  5.641590909279773e-17, -5.117713722005839e-18,  3.891574185743462e-19, -2.548926977364114e-20,
  1.467055352643771e-21, -7.534064569050076e-23,  3.494165176094762e-24, -1.475778065261525e-25,  7.296770723204333e-15, -3.127427534855040e-15,  7.177989910364705e-16,
 -1.119757856708372e-16,  1.321564820526701e-17, -1.254073193892603e-18,  9.950452267356229e-20, -6.784367112959458e-21,  4.055623541048241e-22, -2.158667808240108e-23,
  1.035595941123852e-24, -4.515672762915129e-26,  1.058944179229800e-01, -4.741098543641831e-04,  2.239007069208910e-06, -1.102678236510407e-08,  5.577555823916909e-11,
 -2.875101525992906e-13,  1.487922934758317e-15, -7.788213436194457e-18,  4.007055998707032e-20, -2.128253918233236e-22,  1.046200520408636e-24, -6.045047610359440e-27,
  8.830355845246293e-02, -5.133088977902758e-04,  3.773749003879021e-06, -2.853568597905335e-08,  2.102735988144566e-10, -1.503538799800112e-12,  1.046978469404936e-14,
 -7.136164645489258e-17,  4.771027614996663e-19, -3.142009458833064e-21,  2.035811773265942e-23, -1.306487921053514e-25,  6.139358403642596e-02, -5.224964098000297e-04,
  5.626181056715437e-06, -5.614718497439119e-08,  5.241051757863767e-10, -4.659479037569280e-12,  3.986919409278603e-14, -3.304032317695673e-16,  2.664243010235620e-18,
 -2.097103336585944e-20,  1.616057393514388e-22, -1.221330497566646e-24,  3.557842966665483e-02, -4.491035853408849e-04,  6.398124095054512e-06, -7.950963014601127e-08,
  9.086224769498582e-10, -9.762868696026003e-12,  9.983313718375154e-14, -9.794074981838855e-16,  9.274340717411983e-18, -8.514242122489851e-20,  7.605869127217054e-22,
 -6.628422116107839e-24,  1.717971554040628e-02, -3.132166519364418e-04,  5.611850857829369e-06, -8.511411926277416e-08,  1.169614120934874e-09, -1.491373535663213e-11,
  1.790736575819084e-13, -2.045316767015494e-15,  2.238632036749217e-17, -2.360900713287825e-19,  2.409505590554301e-21, -2.387580787777385e-23,  6.909732688650744e-03,
 -1.758586392886239e-04,  3.874166583655294e-06, -7.086093172351914e-08,  1.155657827251466e-09, -1.726930678101830e-11,  2.406516641738452e-13, -3.164882922180171e-15,
  3.962034483585384e-17, -4.751819056514441e-19,  5.487235817758151e-21, -6.124458200295617e-23,  2.314383817118498e-03, -7.968365957920515e-05,  2.134965438306248e-06,
 -4.665922414431350e-08,  8.945786480822712e-10, -1.553061892398558e-11,  2.491434174944816e-13, -3.743847568378044e-15,  5.321492258960558e-17, -7.207112673977733e-19,
  9.353050173434258e-21, -1.168134987934093e-22,  6.456547792563314e-04, -2.928615555378193e-05,  9.482159513204261e-07, -2.458196835917752e-08,  5.503331207626785e-10,
 -1.103210915110655e-11,  2.025697767727941e-13, -3.459229410293398e-15,  5.553806700081300e-17, -8.451434460586491e-19,  1.226646762484292e-20, -1.706246594784045e-22,
  1.501403221294858e-04, -8.779452142991435e-06,  3.419207617276570e-07, -1.045692563968159e-08,  2.720670879812343e-10, -6.270441651535441e-12,  1.312558940909448e-13,
 -2.537454278112049e-15,  4.584731416521419e-17, -7.811373025303432e-19,  1.263629573345682e-20, -1.951029800210463e-22,  2.915681016272658e-05, -2.159553746679061e-06,
  1.007795788735208e-07, -3.621314501764378e-09,  1.091364999277412e-10, -2.883346360404129e-12,  6.861662690484627e-14, -1.497792865819113e-15,  3.037962260839346e-17,
 -5.781095286969135e-19,  1.039843277882726e-20, -1.777903846349747e-22,  4.745729761468255e-06, -4.388784218713887e-07,  2.445922050622965e-08, -1.029671618285857e-09,
  3.586536721584315e-11, -1.084107367248073e-12,  2.927874117469022e-14, -7.204312220021858e-16,  1.637698847903043e-17, -3.475218282217447e-19,  6.939276281334874e-21,
 -1.311759532054324e-22,  6.515573922163271e-07, -7.434735185362353e-08,  4.933258866002557e-09, -2.428083288766512e-10,  9.761104939149037e-12, -3.371844491769709e-13,
  1.032408748137028e-14, -2.860806860872624e-16,  7.281558477043706e-18, -1.721352054126753e-19,  3.811889197340036e-21, -7.958344358450867e-23,  7.625888793398454e-08,
 -1.062944921467841e-08,  8.373527909026019e-10, -4.811122419980260e-11,  2.230223775610660e-12, -8.798536391270830e-14,  3.052579890351034e-15, -9.520945739981472e-17,
  2.711946737766690e-18, -7.137977302686002e-20,  1.751900367273725e-21, -4.036679094143513e-23,  7.739411054365085e-09, -1.305967251906527e-09,  1.217839265849919e-10,
 -8.156992961745834e-12,  4.356909398071440e-13, -1.962160626375021e-14,  7.710974307433766e-16, -2.706134968276998e-17,  8.622837248114412e-19, -2.525796097849652e-20,
  6.866977828164210e-22, -1.745163099326491e-23,  6.994842775442880e-10, -1.416418776777914e-10,  1.558178149738626e-11, -1.214471091575534e-12,  7.466573869066857e-14,
 -3.835731169374255e-15,  1.706360159831524e-16, -6.734040229205505e-18,  2.398812924169024e-19, -7.814243291785976e-21,  2.351449030149709e-22, -6.585027499985724e-24,
  5.863982545690482e-11, -1.411226966902120e-11,  1.822817709877650e-12, -1.648405188487911e-13,  1.164008831517821e-14, -6.809178914595609e-16,  3.423587708199694e-17,
 -1.517020782214154e-18,  6.032072099827452e-20, -2.181777309935637e-21,  7.254665600244610e-23, -2.234705741749292e-24,  4.843791044401140e-12, -1.368910071500721e-12,
  2.061131058413266e-13, -2.151099855913542e-14,  1.737024638451752e-15, -1.152586234598376e-16,  6.526237022259797e-18, -3.235782151082576e-19,  1.431321856892944e-20,
 -5.728868406001577e-22,  2.097782625901337e-23, -7.083477995981827e-25,  4.292582560841883e-13, -1.401824300128254e-13,  2.432092552236965e-14, -2.901482794329641e-15,
  2.656850754443404e-16, -1.984371560273529e-17,  1.256258702044904e-18, -6.921582296942127e-20,  3.383357181916801e-21, -1.488808825397529e-22,  5.965396758881520e-24,
 -2.194151934338725e-25,  4.546697620653547e-14, -1.677993963001486e-14,  3.293479127440954e-15, -4.419015951185858e-16,  4.521008700119149e-17, -3.748759255209781e-18,
  2.619155337795959e-19, -1.583879198921824e-20,  8.454718931815152e-22, -4.043814813261956e-23,  1.753508926412781e-24, -6.950738182949035e-26,  6.367316688298385e-15,
 -2.577246853279457e-15,  5.566768817352945e-16, -8.188776597075943e-17,  9.140288111764741e-18, -8.228338057931263e-19,  6.212305759314306e-20, -4.041798698648456e-21,
  2.311727716296964e-22, -1.180214793502624e-23,  5.443421788854602e-25, -2.287153323382561e-26,  1.092402767601502e-15, -4.669742924357338e-16,  1.068753984689789e-16,
 -1.662651513201332e-17,  1.957141917489975e-18, -1.852557057753383e-19,  1.466436176157223e-20, -9.975971412378062e-22,  5.950857171323058e-23, -3.161046575162057e-24,
  1.513570083013761e-25, -6.587867218997248e-27,  1.040329854402574e-01, -4.567123371797658e-04,  2.111856466200413e-06, -1.017850643107639e-08,  5.036551283159695e-11,
 -2.542787499526040e-13,  1.286707414601820e-15, -6.620969125785781e-18,  3.310060813017467e-20, -1.760198634861376e-22,  7.998614091717143e-25, -5.252480752617446e-27,
  8.630861197296553e-02, -4.844336241975840e-04,  3.450557142024388e-06, -2.539887161667982e-08,  1.825622151167250e-10, -1.274615439688682e-12,  8.669454716937067e-15,
 -5.775757694784036e-17,  3.773619958031360e-19, -2.431932601793614e-21,  1.539066900200446e-23, -9.695991439460715e-26,  5.938954243411310e-02, -4.800462291955701e-04,
  4.999813889351783e-06, -4.845801000796251e-08,  4.397818307284678e-10, -3.804655406544753e-12,  3.170631084746934e-14, -2.560770926942295e-16,  2.013773112073343e-18,
 -1.546477155550181e-20,  1.163440814285283e-22, -8.584448821454350e-25,  3.387867293691663e-02, -4.015019472480527e-04,  5.525190393810443e-06, -6.641230201916383e-08,
  7.352657817326875e-10, -7.665053849513840e-12,  7.614261982005033e-14, -7.263249688549054e-16,  6.693216535624815e-18, -5.983391776647358e-20,  5.208395064139670e-22,
 -4.424659079501136e-24,  1.601059091787649e-02, -2.721104306086683e-04,  4.693627820138603e-06, -6.857108841228392e-08,  9.100656111961549e-10, -1.122948084253205e-11,
  1.306777482311428e-13, -1.448216468816226e-15,  1.539564382562151e-17, -1.578306991026915e-19,  1.567022655799884e-21, -1.511494538597433e-23,  6.263310928470813e-03,
 -1.479766427355141e-04,  3.124320790861561e-06, -5.484742647458204e-08,  8.615286102669494e-10, -1.242821315849520e-11,  1.674872019071589e-13, -2.133134766401990e-15,
  2.589173338912684e-17, -3.013827181372776e-19,  3.380748505905831e-21, -3.668292072019304e-23,  2.026577378295322e-03, -6.462191312011610e-05,  1.651646798630841e-06,
 -3.453844477985542e-08,  6.361710504502822e-10, -1.063830538773260e-11,  1.647174005269983e-13, -2.392870971175602e-15,  3.292575183552739e-17, -4.321829715617407e-19,
  5.441326353842633e-21, -6.599065700429309e-23,  5.420045808224190e-04, -2.274587442964349e-05,  6.995567658234912e-07, -1.730727313543871e-08,  3.713920046819164e-10,
 -7.156968132741104e-12,  1.266171866825604e-13, -2.087074334055619e-15,  3.239315677136651e-17, -4.771609347138059e-19,  6.711550976787115e-21, -9.056473759926979e-23,
  1.197916949018697e-04, -6.480544179499286e-06,  2.389125408394015e-07, -6.957440674624013e-09,  1.731627381378660e-10, -3.829971852194870e-12,  7.712827654908083e-14,
 -1.437354130612864e-15,  2.507739261221050e-17, -4.131688054660158e-19,  6.471458842987990e-21, -9.685525569220147e-23,  2.189263332954321e-05, -1.501319991955045e-06,
  6.615304819191030e-08, -2.259493275612414e-09,  6.503605120598312e-11, -1.646651330308571e-12,  3.765419504506715e-14, -7.915145208084363e-16,  1.548841509193273e-17,
 -2.847977167454403e-19,  4.956744066966439e-21, -8.210700384167540e-23,  3.315183862441879e-06, -2.843034949970534e-07,  1.493793485312289e-08, -5.970277614940373e-10,
  1.983934919367217e-11, -5.741547134451793e-13,  1.488793712016906e-14, -3.525351189703716e-16,  7.727148981572633e-18, -1.583710158869672e-19,  3.058870804149278e-21,
 -5.600642539666490e-23,  4.178149569502750e-07, -4.431793873203341e-08,  2.771249553611901e-09, -1.294315286903204e-10,  4.961494790256623e-12, -1.640210865531851e-13,
  4.820192006278845e-15, -1.285069664857241e-16,  3.153386275987872e-18, -7.199622139340715e-20,  1.542231097409823e-21, -3.119037419507910e-23,  4.419020037292923e-08,
 -5.745097295785244e-09,  4.268335383118825e-10, -2.328096497809407e-11,  1.029324792317484e-12, -3.887235291018237e-14,  1.294793146305482e-15, -3.886729524905476e-17,
  1.067755143432176e-18, -2.715510329076208e-20,  6.450303786744691e-22, -1.440576608673378e-23,  3.979039857363237e-09, -6.290992674975677e-10,  5.544410089851011e-11,
 -3.530567089395681e-12,  1.800830473720367e-13, -7.772102195258163e-15,  2.935500638143428e-16, -9.925611080125989e-18,  3.053614649388542e-19, -8.652233102277790e-21,
  2.279199775134715e-22, -5.620841687880928e-24,  3.124071130882524e-10, -5.962261822571121e-11,  6.221463277374605e-12, -4.623166042164998e-13,  2.720873377238211e-14,
 -1.342469886509060e-15,  5.751755048822984e-17, -2.191346644510992e-18,  7.551587738500459e-20, -2.384143266129879e-21,  6.964625516153676e-23, -1.896248644016890e-24,
  2.222691098812966e-11, -5.079397015285263e-12,  6.256796472209011e-13, -5.418509032010907e-14,  3.677097224736757e-15, -2.073309050509485e-16,  1.007336075837058e-17,
 -4.322826939567783e-19,  1.667908646245032e-20, -5.864076731101725e-22,  1.898316095651452e-23, -5.701170109503630e-25,  1.521842616316421e-12, -4.121789033934156e-13,
  5.961925024600396e-14, -5.996295189646698e-15,  4.679614100936362e-16, -3.008459455041645e-17,  1.654059963141272e-18, -7.978577814713584e-20,  3.439457128776397e-21,
 -1.343693366909616e-22,  4.809265041666591e-24, -1.589354322236432e-25,  1.096784872192942e-13, -3.469616931223180e-14,  5.836263778243403e-15, -6.764996107232152e-16,
  6.031430025881137e-17, -4.394531967629247e-18,  2.718635009287582e-19, -1.465981735376966e-20,  7.023039535688597e-22, -3.032604332318267e-23,  1.193745297685724e-24,
 -4.318188424684154e-26,  9.398526337207230e-15, -3.398600903437328e-15,  6.535519770336109e-16, -8.601787589510472e-17,  8.643875867398055e-18, -7.048776168233571e-19,
  4.848856600220432e-20, -2.890058673551219e-21,  1.521962811913842e-22, -7.187758391504385e-24,  3.080009416004973e-25, -1.207377873568405e-26,  1.089138399190215e-15,
 -4.364626609071764e-16,  9.330551059249287e-17, -1.359100164647726e-17,  1.503101115163875e-18, -1.341532668240222e-19,  1.004735688677274e-20, -6.488044238562490e-22,
  3.684915461008052e-23, -1.868950580078422e-24,  8.567082179761559e-26, -3.578907679435415e-27,  1.646008909648158e-16, -7.015314671271173e-17,  1.600469437829684e-17,
 -2.482150500719293e-18,  2.913208446690895e-19, -2.749866956367035e-20,  2.171003449765230e-21, -1.473236539574969e-22,  8.767490010177075e-24, -4.646859362657746e-25,
  2.220314862402294e-26, -9.644717488888901e-28,  1.022391710726514e-01, -4.402927302465204e-04,  1.994386922136214e-06, -9.411725910432373e-09,  4.557432576030519e-11,
 -2.255083712551934e-13,  1.115238170193483e-15, -5.657407982926066e-18,  2.728498405321004e-20, -1.485606630140175e-22,  5.738747496511168e-25, -5.149744746928325e-27,
  8.442422371507252e-02, -4.580005225779489e-04,  3.162490583389989e-06, -2.267103597455793e-08,  1.590263049605185e-10, -1.084667376981053e-12,  7.208940234680430e-15,
 -4.697184068549820e-17,  2.999369972519493e-19, -1.893901173950189e-21,  1.168741976113424e-23, -7.268459380185307e-26,  5.754583330671335e-02, -4.422596079566412e-04,
  4.458153320422841e-06, -4.199121368450948e-08,  3.707530161274701e-10, -3.122948090830604e-12,  2.536062743578260e-14, -1.997148170803497e-16,  1.532450796969427e-18,
 -1.148603153593485e-20,  8.441201492465622e-23, -6.081139646854625e-25,  3.235628861330707e-02, -3.602992607484058e-04,  4.794073077644262e-06, -5.578167147989432e-08,
  5.987087601419862e-10, -6.059328938311283e-12,  5.850686552770514e-14, -5.429373365968635e-16,  4.871632040416545e-18, -4.242528120987135e-20,  3.600648938115680e-22,
 -2.982538282735205e-24,  1.499236411487624e-02, -2.376213087560317e-04,  3.951246184769035e-06, -5.564920045691424e-08,  7.138210115009523e-10, -8.528992669694516e-12,
  9.625002032888395e-14, -1.035558940503800e-15,  1.069834404157278e-17, -1.066637280692488e-19,  1.030750114584238e-21, -9.681878827628470e-24,  5.717532678761908e-03,
 -1.253979834288352e-04,  2.541311569947548e-06, -4.285182234446992e-08,  6.487678115698673e-10, -9.040793722951194e-12,  1.178971163120204e-13, -1.454954755485038e-15,
  1.713184585496390e-17, -1.936366216625305e-19,  2.110996485627891e-21, -2.227715342870560e-23,  1.792115752929380e-03, -5.290842528757180e-05,  1.291874905918197e-06,
 -2.586785386287262e-08,  4.580694479714243e-10, -7.383036649305225e-12,  1.103983191463378e-13, -1.551264003824263e-15,  2.067378387913502e-17, -2.631213247091066e-19,
  3.215339698415860e-21, -3.788056213051020e-23,  4.610281509674575e-04, -1.788904741809490e-05,  5.232847271224357e-07, -1.236295522860473e-08,  2.544514655177218e-10,
 -4.716474955811653e-12,  8.043754898666882e-14, -1.280426411910155e-15,  1.922061548053800e-17, -2.741754006493687e-19,  3.738693877105356e-21, -4.895774182124024e-23,
  9.722292008156368e-05, -4.861330738022839e-06,  1.698110712981044e-07, -4.711269241019820e-09,  1.122303914514852e-10, -2.383308473593711e-12,  4.619407715406775e-14,
 -8.301947441668082e-16,  1.399131627379464e-17, -2.229861711183176e-19,  3.382707307551485e-21, -4.908845523203632e-23,  1.679611525064105e-05, -1.065079083114832e-06,
  4.433644790399720e-08, -1.439916358187241e-09,  3.959859560773575e-11, -9.611555021499411e-13,  2.112598184200462e-14, -4.277638696778691e-16,  8.077466210055840e-18,
 -1.435487921276437e-19,  2.417927911388586e-21, -3.880974245098970e-23,  2.378211184433584e-06, -1.888224622598519e-07,  9.354031628684007e-09, -3.549625266554805e-10,
  1.125459038698916e-11, -3.118841688919334e-13,  7.765635917074474e-15, -1.769772719240908e-16,  3.740640941180610e-18, -7.405223832840387e-20,  1.383552401159078e-21,
 -2.453684626801966e-23,  2.766678300711297e-07, -2.722494012507372e-08,  1.603573007913758e-09, -7.105065740397158e-11,  2.596593515288887e-12, -8.213959857273666e-14,
  2.316576777474043e-15, -5.941334842326051e-17,  1.405388985767417e-18, -3.098559734803797e-20,  6.419600360380751e-22, -1.257481705063103e-23,  2.659902739531029e-08,
 -3.217645795247384e-09,  2.252246663012216e-10, -1.165352269255906e-11,  4.911598546088839e-13, -1.774753032423746e-14,  5.673100696116915e-16, -1.638349521241924e-17,
  4.339281140996343e-19, -1.065919299002447e-20,  2.449570951384030e-22, -5.300660530468854e-24,  2.137645630362572e-09, -3.157573188771730e-10,  2.625831768106322e-11,
 -1.587762875402566e-12,  7.726270826412951e-14, -3.192838449013263e-15,  1.158128838917372e-16, -3.770145850278578e-18,  1.119127788633497e-19, -3.065351603353291e-21,
  7.819004408374428e-23, -1.870062032542980e-24,  1.465895761260258e-10, -2.628124601053634e-11,  2.595563153325561e-12, -1.835725955002871e-13,  1.032716625468502e-14,
 -4.887560530370481e-16,  2.014461817000511e-17, -7.401362408386803e-19,  2.464966604928736e-20, -7.535249297559480e-22,  2.134950564984140e-23, -5.646566090704434e-25,
  8.885621121934840e-12, -1.921232986818121e-12,  2.250818913311511e-13, -1.862564723530218e-14,  1.212378727607290e-15, -6.577770125362140e-17,  3.083486956783596e-18,
 -1.279680288584947e-19,  4.784762921865900e-21, -1.633170751412223e-22,  5.141057063327903e-24, -1.503682076727572e-25,  5.046662573122419e-13, -1.305044521676246e-13,
  1.807925075280895e-14, -1.747820927271562e-15,  1.315287735237372e-16, -8.175968436133183e-18,  4.356742659999180e-19, -2.041065554975792e-20,  8.561401923104657e-22,
 -3.259845418334694e-23,  1.138846871891568e-24, -3.678759205408740e-26,  2.944847081795992e-14, -8.992999899394473e-15,  1.462237187875659e-15, -1.642462050663091e-16,
  1.422429774336987e-17, -1.008875078451133e-18,  6.087212337407254e-20, -3.206843409566130e-21,  1.503205480862162e-22, -6.359899905359028e-24,  2.456003472469052e-25,
 -8.725889849536672e-27,  2.019025338047775e-15, -7.134593200490417e-16,  1.340884852751040e-16, -1.727315506196698e-17,  1.701492686352202e-18, -1.362067204673369e-19,
  9.209938373337798e-21, -5.402220682940829e-22,  2.802755471350083e-23, -1.305312271173053e-24,  5.520764506570942e-26, -2.137870011411832e-27,  1.904602711602119e-16,
 -7.545581437526822e-17,  1.594184577289284e-17, -2.296329885133098e-18,  2.513283451805889e-19, -2.221452501307072e-20,  1.648774657777080e-21, -1.055758774175298e-22,
  5.949285864972944e-24, -2.995335834789916e-25,  1.363628224766094e-26, -5.660092970917138e-28,  2.498232637030102e-17, -1.061148539512014e-17,  2.412185717836889e-18,
 -3.728024195603382e-19,  4.361015638311547e-20, -4.103688462227225e-21,  3.230337711419791e-22, -2.186039023419212e-23,  1.297558231315499e-24, -6.860256341644329e-26,
  3.270265216830816e-27, -1.417431485312640e-28,  1.005092121114568e-01, -4.247773350813490e-04,  1.885677078702423e-06, -8.717215912386104e-09,  4.131947396738952e-11,
 -2.005496761964714e-13,  9.682793886712742e-16, -4.865880751240854e-18,  2.229401910864215e-20, -1.303011437760396e-22,  3.332521239871758e-25, -5.955109034587836e-27,
  8.264115744210662e-02, -4.337471422464666e-04,  2.905018070508170e-06, -2.029118985297884e-08,  1.389619200974320e-10, -9.264106990676708e-13,  6.018459408094256e-15,
 -3.838043161746092e-17,  2.394520855635366e-19, -1.484816005209672e-21,  8.893324126893420e-24, -5.529004208164879e-26,  5.584507036614587e-02, -4.085136559063331e-04,
  3.987892058083936e-06, -3.652757312691594e-08,  3.139547496723301e-10, -2.576215873446883e-12,  2.039734803059645e-14, -1.566895857820415e-16,  1.173798975143240e-18,
 -8.588832499783102e-21,  6.171447740653654e-23, -4.338392481027700e-25,  3.098777568835031e-02, -3.244700865194920e-04,  4.178403639245700e-06, -4.710039997509553e-08,
  4.904178422063057e-10, -4.821293141288390e-12,  4.527593150639297e-14, -4.089399691639177e-16,  3.574810975121248e-18, -3.033808100889837e-20,  2.512211041416387e-22,
 -2.028929318596792e-24,  1.410112746543206e-02, -2.085005364910535e-04,  3.346734665978950e-06, -4.547639840359829e-08,  5.641783631835312e-10, -6.531537672160832e-12,
  7.152221429333871e-14, -7.474567767770212e-16,  7.508327201614606e-18, -7.283495886243863e-20,  6.854387108649147e-22, -6.271637481052563e-24,  5.253577180178567e-03,
 -1.069607211895989e-04,  2.083867152836302e-06, -3.377714027800068e-08,  4.932422133730882e-10, -6.644081598732120e-12,  8.389145205105744e-14, -1.003713808288034e-15,
  1.147113027340368e-17, -1.259560915290765e-19,  1.335163892557324e-21, -1.370882467300061e-23,  1.599348291290673e-03, -4.370084327788136e-05,  1.020991502905626e-06,
 -1.958959620526274e-08,  3.337382456240978e-10, -5.187884780948504e-12,  7.496050796307630e-14, -1.019366919650923e-15,  1.316438609774342e-17, -1.625323684094016e-19,
  1.928571492966777e-21, -2.208054149929069e-23,  3.969939801215225e-04, -1.423352404500554e-05,  3.965529675425363e-07, -8.952523887280629e-09,  1.768469124322511e-10,
 -3.154879030479081e-12,  5.189632130370864e-14, -7.981723853862605e-16,  1.159323444066948e-17, -1.602126838776620e-19,  2.118806011721242e-21, -2.693476399708400e-23,
  8.017528731174468e-05, -3.701723543027451e-06,  1.226525040384756e-07, -3.243755081013089e-09,  7.400100455303947e-11, -1.509582081525516e-12,  2.817421533053395e-14,
 -4.885076115348702e-16,  7.955663072609113e-18, -1.226934503339524e-19,  1.803259650209592e-21, -2.538007462798023e-23,  1.314923126423102e-05, -7.700329217900842e-07,
  3.030380692905250e-08, -9.361774513487626e-10,  2.460843041673944e-11, -5.728344096596967e-13,  1.210636539889531e-14, -2.361986006475768e-16,  4.305187592650361e-18,
 -7.396375409703955e-20,  1.205985811727177e-21, -1.876019204795220e-23,  1.749379172271028e-06, -1.283829108654137e-07,  5.997800768069358e-09, -2.161338031230439e-10,
  6.539966689037925e-12, -1.735750006895209e-13,  4.150755134882207e-15, -9.105597780369108e-17,  1.856122840995656e-18, -3.549626085856758e-20,  6.415792074800724e-22,
 -1.102169373935864e-23,  1.888795643130205e-07, -1.720821817887601e-08,  9.544601577133342e-10, -4.011251769226983e-11,  1.397489090685154e-12, -4.229983083970642e-14,
  1.144839952969261e-15, -2.824472602697318e-17,  6.440027277523950e-19, -1.371046253910589e-20,  2.747089991156305e-22, -5.211308745389284e-24,  1.660464074887079e-08,
 -1.864465731468744e-09,  1.228497552920258e-10, -6.026495293985123e-12,  2.420247490740203e-13, -8.364625654480173e-15,  2.565148865845445e-16, -7.124739860701611e-18,
  1.818761747288999e-19, -4.314015920979157e-21,  9.588629573541659e-23, -2.009788993154032e-24,  1.198399123299190e-09, -1.649124746013243e-10,  1.292128573765627e-11,
 -7.411265677119964e-13,  3.437651116309974e-14, -1.359221099233931e-15,  4.731703006193936e-17, -1.482096276504505e-18,  4.242361636309047e-20, -1.122663808303925e-21,
  2.771402049980514e-23, -6.424745708277780e-25,  7.220720529686950e-11, -1.212091021154896e-11,  1.130620191350027e-12, -7.598422605260495e-14,  4.080548614066230e-15,
 -1.850264817978148e-16,  7.328419821806057e-18, -2.594050578989854e-19,  8.341608405402615e-21, -2.466886279207758e-22,  6.773306593449682e-24, -1.738786190550644e-25,
  3.746981731576848e-12, -7.636898950804877e-13,  8.486661158216796e-14, -6.695944717373390e-15,  4.172896753425999e-16, -2.174948145830362e-17,  9.822493121043702e-19,
 -3.936899330267828e-20,  1.424673910385073e-21, -4.715319097107971e-23,  1.441757283944477e-24, -4.102378038647204e-26,  1.768997869566627e-13, -4.350520626275563e-14,
  5.754388605650545e-15, -5.333332707605202e-16,  3.861250390071276e-17, -2.316039495893389e-18,  1.193937475741487e-19, -5.423259005291936e-21,  2.209981870054878e-22,
 -8.189268787094545e-24,  2.788719439652502e-25, -8.793683616374540e-27,  8.332943415867386e-15, -2.447260917945126e-15,  3.834031122796079e-16, -4.161626718025000e-17,
  3.492249937348288e-18, -2.405799511976300e-19,  1.412880411847912e-20, -7.258424860189286e-22,  3.323424232060130e-23, -1.375535761554611e-24,  5.203476281308526e-26,
 -1.813292493760487e-27,  4.524036823052636e-16, -1.557487197963648e-16,  2.852922272352375e-17, -3.588151298159701e-18,  3.457060998512437e-19, -2.711260672408438e-20,
  1.798763124886529e-21, -1.036616555329122e-22,  5.290372556281614e-24, -2.426314784897055e-25,  1.011570715438340e-26, -3.864998238497642e-28,  3.414742964752765e-17,
 -1.335108797473406e-17,  2.783028596190651e-18, -3.958196733768561e-19,  4.281243791309831e-20, -3.742823185881140e-21,  2.749783607403867e-22, -1.744169631313674e-23,
  9.742260550755911e-25, -4.864856333686465e-26,  2.197789012849843e-27, -9.057371690696926e-29,  3.822980217953580e-18, -1.617569848829770e-18,  3.661990705681963e-19,
 -5.637311410212345e-20,  6.569952931520347e-21, -6.160656884923671e-22,  4.833602630838635e-23, -3.260900059614373e-24,  1.929935159340612e-25, -1.017573978359494e-26,
  4.838225870976362e-28, -2.091934175972911e-29,  9.883962657081759e-02, -4.100994027751307e-04,  1.784908761281124e-06, -8.086974568310444e-09,  3.753023020976515e-11,
 -1.788695471499953e-13,  8.413325044495969e-16, -4.225491745780105e-18,  1.777588828468201e-20, -1.226726953440464e-22,  3.522993020180033e-26, -7.718182875063721e-27,
  8.095115859876034e-02, -4.114445360618229e-04,  2.674277165327746e-06, -1.820852718545264e-08,  1.217953634182203e-10, -7.940446891400613e-13,  5.043509160545723e-15,
 -3.150907851779657e-17,  1.918521023096684e-19, -1.173793639687977e-21,  6.747527844129944e-24, -4.294312633679527e-26,  5.427216152478503e-02, -3.782821974094916e-04,
  3.578082792807036e-06, -3.189131235090316e-08,  2.669912065286379e-10, -2.135352309189150e-12,  1.649261123321403e-14, -1.236336805286242e-16,  9.047974587769185e-19,
 -6.462861732167327e-21,  4.547420313693687e-23, -3.113717155838829e-25,  2.975334928937414e-02, -2.931772461656423e-04,  3.657278040061871e-06, -3.996975440925441e-08,
  4.039934900516316e-10, -3.860092010768307e-12,  3.527581683955864e-14, -3.102432272184135e-16,  2.643916023664386e-18, -2.186857860806156e-20,  1.768815753597020e-22,
 -1.391871206973673e-24,  1.331742114558617e-02, -1.837654252192070e-04,  2.851151971832629e-06, -3.740798225024268e-08,  4.491483920816947e-10, -5.041246032481725e-12,
  5.359779025582983e-14, -5.443475392453823e-16,  5.319866660823036e-18, -5.022779489627068e-20,  4.606393331774965e-22, -4.106044135142587e-24,  4.856686038322934e-03,
 -9.178635767844057e-05,  1.721837563275736e-06, -2.684778281335736e-08,  3.784159538315757e-10, -4.930303487087878e-12,  6.031203886017386e-14, -6.999544645762675e-16,
  7.768587267971379e-18, -8.290352135865739e-20,  8.549294019292065e-22, -8.543519625898958e-24,  1.439510476988610e-03, -3.638973051571531e-05,  8.148232539059446e-07,
 -1.499100965046177e-08,  2.458840187675642e-10, -3.688655137375871e-12,  5.153233263903679e-14, -6.785485117796124e-16,  8.495857253210796e-18, -1.017992068463907e-19,
  1.173444275790599e-21, -1.306134689511118e-23,  3.457864376705710e-04, -1.144710972394531e-05,  3.042178897567692e-07, -6.566988453936217e-09,  1.245901921803188e-10,
 -2.140429258872261e-12,  3.397863916918400e-14, -5.051802971032383e-16,  7.103162411289010e-18, -9.513900113847624e-20,  1.220760047353900e-21, -1.507059098065038e-23,
  6.710997382980077e-05, -2.858152508696588e-06,  8.994265711707728e-08, -2.268713769869475e-09,  4.959624861901624e-11, -9.724045379361970e-13,  1.748401478313675e-14,
 -2.926015038680947e-16,  4.606623457693130e-18, -6.877206573138612e-20,  9.795936420386302e-22, -1.337621622015694e-23,  1.049122950242577e-05, -5.666237605730279e-07,
  2.109962091810423e-08, -6.203064329137381e-10,  1.559268148313763e-11, -3.482403011107876e-13,  7.079305260754286e-15, -1.331310481526865e-16,  2.342999477155917e-18,
 -3.892440275565845e-20,  6.145155954730145e-22, -9.266628747987894e-24,  1.317589252207910e-06, -8.922858606519503e-08,  3.932897543741676e-09, -1.346134044047710e-10,
  3.888386355074265e-12, -9.886456434285712e-14,  2.271110828605737e-15, -4.796783946857935e-17,  9.431836098678290e-19, -1.742700260291466e-20,  3.047592703779913e-22,
 -5.071959065592191e-24,  1.327321409038593e-07, -1.117360042695234e-08,  5.835415728548849e-10, -2.325996287723238e-11,  7.725390306790097e-13, -2.237522817543687e-14,
  5.811655364014625e-16, -1.379294083981566e-17,  3.031430979115661e-19, -6.231729043871925e-21,  1.207508048937478e-22, -2.218321149653414e-24,  1.073291254223460e-08,
 -1.115944130568727e-09,  6.916866421903958e-11, -3.215547563158662e-12,  1.230110516296715e-13, -4.065287050106306e-15,  1.195750812283584e-16, -3.193535064105239e-18,
  7.855592247527100e-20, -1.798820238727525e-21,  3.866096213776213e-23, -7.847256949505132e-25,  7.000720667192030e-10, -8.949129807968847e-11,  6.597874405291181e-12,
 -3.586387176286880e-13,  1.584513315129657e-14, -5.990660960998655e-16,  2.000347320182555e-17, -6.025515888430639e-19,  1.662332449819391e-20, -4.248060584270026e-22,
  1.014408586540682e-23, -2.278333478318118e-25,  3.730033642949555e-11, -5.842808737757604e-12,  5.137414550439122e-13, -3.275958077439741e-14,  1.677355990870212e-15,
 -7.279188858024420e-17,  2.767908836816607e-18, -9.430817420337412e-20,  2.925697923057745e-21, -8.363646967752709e-23,  2.223701293242159e-24, -5.536675742702198e-26,
  1.666441484485948e-12, -3.189409499682687e-13,  3.353140787561941e-14, -2.517258268912702e-15,  1.499295589408886e-16, -7.495404414744822e-18,  3.256621905275255e-19,
 -1.258958280364354e-20,  4.404032317872440e-22, -1.411811251443802e-23,  4.188409575873376e-25, -1.158203598855668e-26,  6.562093399812922e-14, -1.528446025163736e-14,
  1.924134800957543e-15, -1.705208336869086e-16,  1.185019195362722e-17, -6.844878305980940e-19,  3.407374296978168e-20, -1.498142463412312e-21,  5.921691906741074e-23,
 -2.132430080833660e-24,  7.068578036784457e-26, -2.173037916182216e-27,  2.491855079628906e-15, -7.009077179140835e-16,  1.054423316773626e-16, -1.102751793135185e-17,
  8.943448026751672e-19, -5.970391294706621e-20,  3.405681140891031e-21, -1.702889223896769e-22,  7.602659201955022e-24, -3.073226752567133e-25,  1.137094977768678e-26,
 -3.881015907329542e-28,  1.061402831402415e-16, -3.547799336414626e-17,  6.314425105639094e-18, -7.732760405586469e-19,  7.269349546465993e-20, -5.573246263243164e-21,
  3.620738052920845e-22, -2.046385156249822e-23,  1.025637262183158e-24, -4.625158774718649e-26,  1.898151141841366e-27, -7.146464518975026e-29,  6.297267417579972e-18,
 -2.424885853848102e-18,  4.977324875854561e-19, -6.977298154760084e-20,  7.446095409190546e-21, -6.429282903202636e-22,  4.669460100751524e-23, -2.930391140157453e-24,
  1.620671959085733e-25, -8.018682739419109e-27,  3.591604207963438e-28, -1.468351395699139e-29,  5.905192940928720e-19, -2.487479744546145e-19,  5.605021254251225e-20,
 -8.589761398088651e-21,  9.968625479550846e-22, -9.310649380530843e-23,  7.278027318710706e-24, -4.892962698590654e-25,  2.886440347051819e-26, -1.517250837926914e-27,
  7.193297839886578e-29, -3.101816318450371e-30,  9.722718695172478e-02, -3.961983641906848e-04,  1.691353361205160e-06, -7.514052037463488e-09,  3.414549051285710e-11,
 -1.600371426285343e-13,  7.303163449167915e-16, -3.727750609801781e-18,  1.329784456623552e-20, -1.286310316525413e-22, -3.454454180677058e-25, -9.341425158043108e-27,
  7.934683027131306e-02, -3.908923653648077e-04,  2.466963637654040e-06, -1.638055975283052e-08,  1.070568753851897e-10, -6.829310534434221e-13,  4.241202968179494e-15,
 -2.599734785489633e-17,  1.540245460923630e-19, -9.388457135844397e-22,  5.065691709576693e-24, -3.386377550527271e-26,  5.281395673462865e-02, -3.511188080753684e-04,
  3.219675452658548e-06, -2.794072381600108e-08,  2.279780261025155e-10, -1.778001869759897e-12,  1.340359654492335e-14, -9.807680531539993e-17,  7.018303295650286e-19,
 -4.890201531307762e-21,  3.378898811838930e-23, -2.246908117416415e-25,  2.863626680927305e-02, -2.657332663063536e-04,  3.214018031124109e-06, -3.408026399705001e-08,
  3.346007055736690e-10, -3.108835152313244e-12,  2.766421222515690e-14, -2.369799279916083e-16,  1.970528382149916e-18, -1.587946296019999e-20,  1.256939232373585e-22,
 -9.624715691504130e-25,  1.262529778214890e-02, -1.626368572365275e-04,  2.442260234417075e-06, -3.096317213758362e-08,  3.600451249733048e-10, -3.920115062441490e-12,
  4.049097268403843e-14, -3.998121793700322e-16,  3.804002700302331e-18, -3.496163753020519e-20,  3.127625646483816e-22, -2.715716002664135e-24,  4.515185614145611e-03,
 -7.920443585155843e-05,  1.432975795582843e-06, -2.150952052096040e-08,  2.928315579934687e-10, -3.692446770798476e-12,  4.378808453839591e-14, -4.931826908926634e-16,
  5.318707173784932e-18, -5.518350459121256e-20,  5.539534995467564e-22, -5.389403823917431e-24,  1.305936951008231e-03, -3.052903263612181e-05,  6.563027555815065e-07,
 -1.158579947926489e-08,  1.830852247045284e-10, -2.652238591640552e-12,  3.584679689201861e-14, -4.572738159404219e-16,  5.553742891397816e-18, -6.461066161333969e-20,
  7.238588104268692e-22, -7.835935579392726e-24,  3.044102826889669e-04, -9.297681236237603e-06,  2.360934186568250e-07, -4.876090586412145e-09,  8.891117717853839e-11,
 -1.471854753438782e-12,  2.256127719741275e-14, -3.244145026372617e-16,  4.417842920862738e-18, -5.737385392289329e-20,  7.145688083434655e-22, -8.569994606397808e-24,
  5.696129138853899e-05, -2.235361970011687e-06,  6.690444853580950e-08, -1.610472091974272e-09,  3.375798241415031e-11, -6.364879864663725e-13,  1.103065791747135e-14,
 -1.782578130323677e-16,  2.714176354257418e-18, -3.923880962512906e-20,  5.418771153150393e-22, -7.180916829659223e-24,  8.520543375028124e-06, -4.238353681797329e-07,
  1.494977635925558e-08, -4.184406049878176e-10,  1.006381873910369e-11, -2.157397363733265e-13,  4.220345761362002e-15, -7.652844662816965e-17,  1.300889446240871e-18,
 -2.090472948323424e-20,  3.196412384279683e-22, -4.673608255096790e-24,  1.014687407743503e-06, -6.330228275117608e-08,  2.634049627692552e-09, -8.565799465546582e-11,
  2.362811751360495e-12, -5.756979579602266e-14,  1.270787171050293e-15, -2.584782307280543e-17,  4.903590925577686e-19, -8.755383280793279e-21,  1.481660664922191e-22,
 -2.389186133243849e-24,  9.586395512781805e-08, -7.441282287217117e-09,  3.659564529299278e-10, -1.383548387700393e-11,  4.381250363174057e-13, -1.214366841418940e-14,
  3.027277929283032e-16, -6.912097440072785e-18,  1.464430795131565e-19, -2.907000431838946e-21,  5.447503903016060e-23, -9.691563189344918e-25,  7.171656428002359e-09,
 -6.887808478780391e-10,  4.014089887228200e-11, -1.767856058252258e-12,  6.440861875846118e-14, -2.035083703652376e-15,  5.740543731567927e-17, -1.473999686771729e-18,
  3.493348433711780e-20, -7.721237031363253e-22,  1.604393022212035e-23, -3.153050420331120e-25,  4.254836560495102e-10, -5.037883695767516e-11,  3.491037450658228e-12,
 -1.796943584740860e-13,  7.557577265524777e-15, -2.730806015701543e-16,  8.742295239995547e-18, -2.531379184281489e-19,  6.728113912607409e-21, -1.659666962470039e-22,
  3.832141373395356e-24, -8.335276609659002e-26,  2.018236456288362e-11, -2.940082062357119e-12,  2.432395521510344e-13, -1.469713369610254e-14,  7.167016552789360e-16,
 -2.973914085550097e-17,  1.084724419799913e-18, -3.554702742466203e-20,  1.063085553084976e-21, -2.935562858597629e-23,  7.552697734074738e-25, -1.822681261357170e-26,
  7.812882119271181e-13, -1.398678104097223e-13,  1.387651034931527e-14, -9.892364074665804e-16,  5.621787277576050e-17, -2.691831848787361e-18,  1.123698337799903e-19,
 -4.184850090533468e-21,  1.413533243102544e-22, -4.384285768516107e-24,  1.260727529320260e-25, -3.384746282258905e-27,  2.578123329507382e-14, -5.662697028809881e-15,
  6.763174728598276e-16, -5.716158943232524e-17,  3.804525850905805e-18, -2.112049608632419e-19,  1.013444360317132e-20, -4.306007062109641e-22,  1.648428711135006e-23,
 -5.760400440597926e-25,  1.856198779497212e-26, -5.556190918014268e-28,  7.894740197847988e-16, -2.117407464281537e-16,  3.047731797615898e-17, -3.061755319678946e-18,
  2.393455807941300e-19, -1.544668065046370e-20,  8.540011955667247e-22, -4.147948582363478e-23,  1.802445233764098e-24, -7.104031644679553e-26,  2.566891384375271e-27,
 -8.568293793663858e-29,  2.617787065587433e-17, -8.462750678992641e-18,  1.458545902172953e-18, -1.733993824753077e-19,  1.586304766190445e-20, -1.186097523086532e-21,
  7.529514749682388e-23, -4.165416327718737e-24,  2.046584906174558e-25, -9.059899991252788e-27,  3.654483382788671e-28, -1.353899606832331e-29,  1.198901365499478e-18,
 -4.535773604467351e-19,  9.146761929532790e-20, -1.261179485628226e-20,  1.325518092741623e-21, -1.128505182324399e-22,  8.090251498457824e-24, -5.016490904168786e-25,
  2.743669180047884e-26, -1.343531617991333e-27,  5.960118586047216e-29, -2.414969201911867e-30,  9.219732198961863e-20, -3.863683513951697e-20,  8.659149192802707e-21,
 -1.320214128407391e-21,  1.524770579588499e-22, -1.417735220805740e-23,  1.103586159178617e-24, -7.390316470686438e-26,  4.343733678812486e-27, -2.275457747430619e-28,
  1.075332540264231e-29, -4.622982926086843e-31,  9.566889687952346e-02, -3.830191614675075e-04,  1.604360069181463e-06, -6.992412478536265e-09,  3.111179898651079e-11,
 -1.437183835210814e-13,  6.311769660244661e-16, -3.379774465126531e-18,  8.321023978811947e-21, -1.503860122017635e-22, -7.214477301808644e-25, -6.300537979874891e-27,
  7.782152709057219e-02, -3.719148069747273e-04,  2.280240908035388e-06, -1.477162604785407e-08,  9.435993179806589e-11, -5.893502394186537e-13,  3.577461837219865e-15,
 -2.157300021393972e-17,  1.235363528838069e-19, -7.635859637015136e-22,  3.759444681611400e-24, -2.524836690310082e-26,  5.145895693260968e-02, -3.266431426387716e-04,
  2.905153347299977e-06, -2.456096743584905e-08,  1.954248716954051e-10, -1.486885338752859e-12,  1.094715391285950e-14, -7.819227448806241e-17,  5.479095956755896e-19,
 -3.716812997546809e-21,  2.532310650895922e-23, -1.638375470414600e-25,  2.762229047121612e-02, -2.415704650979963e-04,  2.835235683499904e-06, -2.919012649329536e-08,
  2.785606467939870e-10, -2.517889348805624e-12,  2.183209837814590e-14, -1.821762846955114e-16,  1.480030724253173e-18, -1.160491243737560e-20,  9.014035770377120e-23,
 -6.725899242464410e-25,  1.201160412750598e-02, -1.444927088260754e-04,  2.102840423637631e-06, -2.578044114808753e-08,  2.905203340429998e-10, -3.069995422502361e-12,
  3.082716321505425e-14, -2.960230440973483e-16,  2.744501269985032e-18, -2.454745176985713e-20,  2.144846219150938e-22, -1.815382032544368e-24,  4.219766248031038e-03,
 -6.869869981636143e-05,  1.200709280745046e-06, -1.736227859263524e-08,  2.284653530615637e-10, -2.789703146904318e-12,  3.209109757324306e-14, -3.509172586525540e-16,
  3.679770087504858e-18, -3.712628588553356e-20,  3.630499107899107e-22, -3.440368829428868e-24,  1.193506491278794e-03, -2.578867772909797e-05,  5.332392016096289e-07,
 -9.038067464875935e-09,  1.377019326052310e-10, -1.927442054348643e-12,  2.521778521723077e-14, -3.117923519390603e-16,  3.675376680858197e-18, -4.152980083693392e-20,
  4.524461008370658e-22, -4.765402685902714e-24,  2.706578852277335e-04, -7.620862720232218e-06,  1.852318828368242e-07, -3.662412265538342e-09,  6.422814218169740e-11,
 -1.025140538666252e-12,  1.518179419400955e-14, -2.112357827985953e-16,  2.787391931580519e-18, -3.511352819989828e-20,  4.246693483848915e-22, -4.949840055937493e-24,
  4.897971458619554e-05, -1.769128642860135e-06,  5.044181566075222e-08, -1.159334273975955e-09,  2.331697484746378e-11, -4.230020254251805e-13,  7.069621887080918e-15,
 -1.103707874358741e-16,  1.625987484724226e-18, -2.277246509867628e-20,  3.050051389071682e-22, -3.923957557270020e-24,  7.036070007044965e-06, -3.218804190885870e-07,
  1.076824945939007e-08, -2.870865641586051e-10,  6.609992626556294e-12, -1.360771573301497e-13,  2.562720765510144e-15, -4.482633123678155e-17,  7.362633141732835e-19,
 -1.144807156052869e-20,  1.695850747079372e-22, -2.404887055950236e-24,  7.979172256330747e-07, -4.577662859828801e-08,  1.799752400654924e-09, -5.562460310479198e-11,
  1.465843909928376e-12, -3.423754907605751e-14,  7.264459520005731e-16, -1.423376044028577e-17,  2.605955748011087e-19, -4.497401146033816e-21,  7.366519659579641e-23,
 -1.151124194014052e-24,  7.104941042088478e-08, -5.074749438225133e-09,  2.350952546950913e-10, -8.431094950705169e-12,  2.546048687921660e-13, -6.754626293469248e-15,
  1.616385597051843e-16, -3.551108805835668e-18,  7.253408847027595e-20, -1.390510872892590e-21,  2.520164035353972e-23, -4.342183794854800e-25,  4.945622432775880e-09,
 -4.376600517538349e-10,  2.397566888771435e-11, -1.000124928643253e-12,  3.469926756492906e-14, -1.048143730394922e-15,  2.835221579586052e-17, -6.998684822089423e-19,
  1.597958549066010e-20, -3.408852890127437e-22,  6.847415752316510e-24, -1.302778709104683e-25,  2.686035632005275e-10, -2.937162727129697e-11,  1.911260156572072e-12,
 -9.309980074628112e-14,  3.725655993155567e-15, -1.286081515682184e-16,  3.945954178650746e-18, -1.097943465852980e-19,  2.810513777745660e-21, -6.690004236487264e-23,
  1.493149121948319e-24, -3.144211780462315e-26,  1.142232068539572e-11, -1.542136062260364e-12,  1.198495122678562e-13, -6.853665469870050e-15,  3.180058245379889e-16,
 -1.260670084794324e-17,  4.407512444223070e-19, -1.388241916298150e-20,  3.999738288684802e-22, -1.066201213798037e-23,  2.652864918611892e-25, -6.201551779229379e-27,
  3.858483546258240e-13, -6.435342639288307e-14,  6.010430230753555e-15, -4.061326961707758e-16,  2.198833987192426e-17, -1.007049739583750e-18,  4.034205975020641e-20,
 -1.445741567226108e-21,  4.710319978582362e-23, -1.412148311607787e-24,  3.932258888805733e-26, -1.024050021649347e-27,  1.073260575359166e-14, -2.212972384283693e-15,
  2.499569860889584e-16, -2.009666443397399e-17,  1.278283136529819e-18, -6.807123790297866e-20,  3.143051309407893e-21, -1.288485792595870e-22,  4.770219302506322e-24,
 -1.615380587994091e-25,  5.053535506374452e-27, -1.471053101743840e-28,  2.655963075290885e-16, -6.759980017451440e-17,  9.274908596931097e-18, -8.922232007776483e-19,
  6.704643994458459e-20, -4.173007245889428e-21,  2.231250061132377e-22, -1.050632915740691e-23,  4.435393689475167e-25, -1.701565266832764e-26,  5.994607091012574e-28,
 -1.954061289161395e-29,  6.814795642587642e-18, -2.121476708867054e-18,  3.527437732194734e-19, -4.057962403137794e-20,  3.602359231464797e-21, -2.620214834483724e-22,
  1.621604996576095e-23, -8.762589277341088e-25,  4.212509611896853e-26, -1.827402808953601e-27,  7.233237032085005e-29, -2.632952396260158e-30,  2.366209668855255e-19,
 -8.770118448004153e-20,  1.732914396702604e-20, -2.344624618910942e-21,  2.421752427414602e-22, -2.029121534303993e-23,  1.433441403432768e-24, -8.768542953335379e-26,
  4.736022121921465e-27, -2.292370118556972e-28,  1.006022634434068e-29, -4.035685333585785e-31,  1.457341288859881e-20, -6.070548139140098e-21,  1.352028082120041e-21,
 -2.049177060907087e-22,  2.353626607449773e-23, -2.177189495401580e-24,  1.686683996047245e-25, -1.124506108181239e-26,  6.582110617907498e-28, -3.434739890733751e-29,
  1.617335053577179e-30, -6.929705315925433e-32,  9.416197023687463e-02, -3.705116675660848e-04,  1.523345577344638e-06, -6.516827281575293e-09,  2.838138197647817e-11,
 -1.296808631996206e-13,  5.394153257776470e-16, -3.206032140996400e-18,  2.353589786939907e-21, -1.808904183464537e-22, -6.661982984030478e-25,  1.292852984459950e-26,
  7.636926416375116e-02, -3.543571183514848e-04,  2.111665546454324e-06, -1.335169582084128e-08,  8.338479476441543e-11, -5.103173885815055e-13,  3.024824852207813e-15,
 -1.803262121562963e-17,  9.851599336508389e-20, -6.320664275702963e-22,  2.913630170774130e-24, -1.177441342793924e-26,  5.019707235800680e-02, -3.045298576098271e-04,
  2.628245470754592e-06, -2.165850631727311e-08,  1.681468808397704e-10, -1.248561988478118e-12,  8.984434501325231e-15, -6.261784089652819e-17,  4.307222174498056e-19,
 -2.834889562769427e-21,  1.906266209210553e-23, -1.240798947099718e-25,  2.669925607652450e-02, -2.202175876718032e-04,  2.510121882184293e-06, -2.510919212777159e-08,
  2.330554945291005e-10, -2.050140935623483e-12,  1.733605556943241e-14, -1.408578752965613e-16,  1.120602146227344e-18, -8.528816066503254e-21,  6.504889373002894e-23,
 -4.822082384364988e-25,  1.146542514574066e-02, -1.288328436072510e-04,  1.819461806842534e-06, -2.158576594845576e-08,  2.358955925028142e-10, -2.420444126297770e-12,
  2.364616246629053e-14, -2.208269722671405e-16,  1.997740799348916e-18, -1.737514417291242e-20,  1.483673320640737e-22, -1.232110634925224e-24,  3.962945727564410e-03,
 -5.986825650539258e-05,  1.012580375832975e-06, -1.411445488408883e-08,  1.796411428229359e-10, -2.125260585951575e-12,  2.373141415169193e-14, -2.520179227435147e-16,
  2.571855796724393e-18, -2.523215183929837e-20,  2.404804690072123e-22, -2.224588178853468e-24,  1.098245981653034e-03, -2.192186631908126e-05,  4.368286147011185e-07,
 -7.113088979227436e-09,  1.045614623345148e-10, -1.414953291555727e-12,  1.793212348969528e-14, -2.149809611164729e-16,  2.461188812477103e-18, -2.701864215787209e-20,
  2.863687629257041e-22, -2.937326696145673e-24,  2.428825610313759e-04, -6.298772281096198e-06,  1.468312838345354e-07, -2.780830931038740e-09,  4.693740881542965e-11,
 -7.227340366347590e-13,  1.034702912683152e-14, -1.393692881086467e-16,  1.782997953926241e-18, -2.179533738736856e-20,  2.560754519192922e-22, -2.902288019558333e-24,
  4.263033524386616e-05, -1.415487833100742e-06,  3.851627876164263e-08, -8.456780993351760e-10,  1.633077633173285e-11, -2.852170958816221e-13,  4.599453712154127e-15,
 -6.940210654568672e-17,  9.897147044399138e-19, -1.343335301442262e-20,  1.745648439938607e-22, -2.181117292047369e-24,  5.901312260988788e-06, -2.479037261850971e-07,
  7.877723485432400e-09, -2.001405425631497e-10,  4.414134996663421e-12, -8.730983724542679e-14,  1.583730943042676e-15, -2.673302725694502e-17,  4.244236207028279e-19,
 -6.387655645074832e-21,  9.170041886403604e-23, -1.261610861504317e-24,  6.398805589934268e-07, -3.369637740787893e-08,  1.253116654613762e-09, -3.682210904491386e-11,
  9.274598238661713e-13, -2.077455476431864e-14,  4.238524926806574e-16, -8.002702827869729e-18,  1.414390968229379e-19, -2.359990974321559e-21,  3.742304616880714e-23,
 -5.668233674515858e-25,  5.395694650776910e-08, -3.538475606253410e-09,  1.545067109869173e-10, -5.256999077838087e-12,  1.514335662937921e-13, -3.846313413140116e-15,
  8.837435377558647e-17, -1.868487212594574e-18,  3.680103084803305e-20, -6.814104008307383e-22,  1.194579719781000e-23, -1.993505163454118e-25,  3.514074208417540e-09,
 -2.858047846470574e-10,  1.471729863851059e-11, -5.814201763828631e-13,  1.921021635630179e-14, -5.547583240461445e-16,  1.439043271250995e-17, -3.415002553683954e-19,
  7.511743520345684e-21, -1.546570445795490e-22,  3.003056704421280e-24, -5.531006446943267e-26,  1.758311176079738e-10, -1.770354696383752e-11,  1.081041100224574e-12,
 -4.980841231217682e-14,  1.895898327095717e-15, -6.250495909000100e-17,  1.837533360819612e-18, -4.911927336974083e-20,  1.210655359745939e-21, -2.780135692675069e-23,
  5.996365302078312e-25, -1.222115047855711e-26,  6.751353700990014e-12, -8.418107572879545e-13,  6.136828880094822e-14, -3.317960037820015e-15,  1.463660397714797e-16,
 -5.539656881523842e-18,  1.855261532768527e-19, -5.613211191323494e-21,  1.557175600417364e-22, -4.004933465895759e-24,  9.631792054632660e-26, -2.179928704567596e-27,
  2.005207531364006e-13, -3.103015485148589e-14,  2.722114178694700e-15, -1.740503245618556e-16,  8.964914020784158e-18, -3.922514160128560e-19,  1.506271522542676e-20,
 -5.189198381553643e-22,  1.629227696779560e-23, -4.716902279167944e-25,  1.270814010788232e-26, -3.207536687723884e-28,  4.734506767344661e-15, -9.121363329168940e-16,
  9.713026950514013e-17, -7.410547620602687e-18,  4.495315045836568e-19, -2.292129366832712e-20,  1.016730391733747e-21, -4.015430357338073e-23,  1.435635559002967e-24,
 -4.705020849581088e-26,  1.427210647033148e-27, -4.035383520727368e-29,  9.506040893582012e-17, -2.284363541098525e-17,  2.976083325150878e-18, -2.732736913639289e-19,
  1.968604660983408e-20, -1.178810384959396e-21,  6.082344329392513e-23, -2.770995229799380e-24,  1.134411277788042e-25, -4.228807400323366e-27,  1.450256957284181e-28,
 -4.609573042401934e-30,  1.880171625499527e-18, -5.608896762991268e-19,  8.960742356311319e-20, -9.940320939618584e-21,  8.536800503806852e-22, -6.023988270501473e-23,
  3.625728239034919e-24, -1.909491631057708e-25,  8.963652420179972e-27, -3.803388542520080e-28,  1.474752620214989e-29, -5.266095559955738e-31,  4.863839363631868e-20,
 -1.760123333936352e-20,  3.397246448121697e-21, -4.498028013485096e-22,  4.554846985314609e-23, -3.747783785810353e-24,  2.603867562656269e-25, -1.568620715034101e-26,
  8.353578636828522e-28, -3.990934661831361e-29,  1.730392228690724e-30, -6.864156713424574e-32,  2.336765586162443e-21, -9.665056929759301e-22,  2.136946345766123e-22,
 -3.216624216874416e-23,  3.671018279935095e-24, -3.375836858262641e-25,  2.601040435450748e-26, -1.725352190172724e-27,  1.005174458183897e-28, -5.222435459134961e-30,
  2.449126908055464e-31, -1.045392631153776e-32,  9.270381246111695e-02, -3.586301836171118e-04,  1.447784868558128e-06, -6.082801157353147e-09,  2.590997101557597e-11,
 -1.178097723561785e-13,  4.496950709126672e-16, -3.238224435345659e-18, -4.388386485841632e-21, -1.831428587392701e-22,  9.610114347397039e-25,  6.930001006045715e-26,
  7.498463863856289e-02, -3.380827455983648e-04,  1.959125650077178e-06, -1.209541103819381e-08,  7.386526168661418e-11, -4.434445582883527e-13,  2.560782181174336e-15,
 -1.522232652825503e-17,  7.779273488424809e-20, -5.192513269983413e-22,  2.923242439944336e-24,  1.532390407335329e-26,  4.901942096730750e-02, -2.844995907433314e-04,
  2.383697830950930e-06, -1.915677969822832e-08,  1.451975555978500e-10, -1.052506957529795e-12,  7.409745721004608e-15, -5.033068648958821e-17,  3.411429542914566e-19,
 -2.174482330993041e-21,  1.409339957436928e-23, -1.055053431726250e-25,  2.585672493940915e-02, -2.012814384586347e-04,  2.229901542518874e-06, -2.168699207847143e-08,
  1.959136636193720e-10, -1.677618481987618e-12,  1.385125862366498e-14, -1.094481492278605e-16,  8.556421551779907e-19, -6.313231078723676e-21,  4.653442578888370e-23,
 -3.717135560400888e-25,  1.097765061557192e-02, -1.152525909955215e-04,  1.581575533939258e-06, -1.816985226013723e-08,  1.926959756642189e-10, -1.920449759297598e-12,
  1.827155024920324e-14, -1.658604468328040e-16,  1.467127079232722e-18, -1.240300703234783e-20,  1.029207515414334e-22, -8.630520633545836e-25,  3.738666251667056e-03,
 -5.239928555315444e-05,  8.591438615137364e-07, -1.155153455745504e-08,  1.423046223331317e-10, -1.631862235096866e-12,  1.770275141177931e-14, -1.825716928711542e-16,
  1.815381898753193e-18, -1.732040273707371e-20,  1.606283908857877e-22, -1.463950754213004e-24,  1.017044675196957e-03, -1.874223331108092e-05,  3.606460931668765e-07,
 -5.645011903834810e-09,  8.012097911238654e-11, -1.048741813805102e-12,  1.288345433013497e-14, -1.498050292294623e-16,  1.666951937913328e-18, -1.778419503446789e-20,
  1.833355681288337e-22, -1.836879100017010e-24,  2.198421078206335e-04, -5.245851961924811e-06,  1.175306403031031e-07, -2.133196747598708e-09,  3.468040848381576e-11,
 -5.154461424602304e-13,  7.138285302852708e-15, -9.311582797937206e-17,  1.155634605910136e-18, -1.371313206497814e-20,  1.565506134347317e-22, -1.727254953507744e-24,
  3.752611765449477e-05, -1.143905781275552e-06,  2.976541901682332e-08, -6.246243307667313e-10,  1.158966052545796e-11, -1.949734412606151e-13,  3.035506374472199e-15,
 -4.428882986711836e-17,  6.116754197469915e-19, -8.049104674377867e-21,  1.015153839693435e-22, -1.232552047481675e-24,  5.022065793910821e-06, -1.934084933265046e-07,
  5.848224735344911e-09, -1.416481508955395e-10,  2.994517360771939e-12, -5.693749464356944e-14,  9.952592425890948e-16, -1.621876907662016e-17,  2.490012211591522e-19,
 -3.628620233446802e-21,  5.049886742392343e-23, -6.742792423520317e-25,  5.226650508020524e-07, -2.521496685362741e-08,  8.881786140065521e-10, -2.482187397789003e-11,
  5.978873526076225e-13, -1.284882409985189e-14,  2.521772530830551e-16, -4.589710124330977e-18,  7.833324086274420e-20, -1.264032527204084e-21,  1.940999292846746e-23,
 -2.850294174873366e-25,  4.192690795579469e-08, -2.518745139508299e-09,  1.037516570720098e-10, -3.349886851860090e-12,  9.208173703394728e-14, -2.239817489187956e-15,
  4.942568137134251e-17, -1.005922997574169e-18,  1.910814876410579e-20, -3.417927250191582e-22,  5.796794567102961e-24, -9.370670286864180e-26,  2.568544916952657e-09,
 -1.914850643163463e-10,  9.271246314848774e-12, -3.468739098567869e-13,  1.091545850678956e-14, -3.013895502608014e-16,  7.497956350540429e-18, -1.710721267303356e-19,
  3.625373092198351e-21, -7.204128724369087e-23,  1.352244042907862e-24, -2.410949226692669e-26,  1.191480302395251e-10, -1.101181594429888e-11,  6.307438488670349e-13,
 -2.747794699006808e-14,  9.946334725949413e-16, -3.131256859289370e-17,  8.818746874435094e-19, -2.264345401035701e-20,  5.372819197165074e-22, -1.190081050011641e-23,
  2.480065775835465e-25, -4.891210627654827e-27,  4.160640721898180e-12, -4.773928450315978e-13,  3.260651426781247e-14, -1.665307425795553e-15,  6.979686783613851e-17,
 -2.520639085862392e-18,  8.082444339301317e-20, -2.347881561234656e-21,  6.268480050118493e-23, -1.554798908322290e-24,  3.612667770136342e-26, -7.912607112401571e-28,
  1.095178490517296e-13, -1.565863857269149e-14,  1.287556326668333e-15, -7.778157945646272e-17,  3.806789142224610e-18, -1.589543048867300e-19,  5.845520114085650e-21,
 -1.934174086201487e-22,  5.846978055611258e-24, -1.633429479454835e-25,  4.254512121949089e-27, -1.039968593103488e-28,  2.212448266667114e-15, -3.963324799900372e-16,
  3.966862173307125e-17, -2.865267820096551e-18,  1.654380062153007e-19, -8.063356542336234e-21,  3.430785228673641e-22, -1.303477520938463e-23,  4.494648677109270e-25,
 -1.423814645854664e-26,  4.182853290730130e-28, -1.147472619694454e-29,  3.625045675534631e-17, -8.180231224182839e-18,  1.007985557897813e-18, -8.806694074196907e-20,
  6.065290766276903e-21, -3.485850740573015e-22,  1.731917906315001e-23, -7.619007458067563e-25,  3.019230538076587e-26, -1.091788108705895e-27,  3.639069339780189e-29,
 -1.126145832383085e-30,  5.519274105751658e-19, -1.569300214855942e-19,  2.398337267086910e-20, -2.556008163509145e-21,  2.116763375622312e-22, -1.444976012484358e-23,
  8.436493338939585e-25, -4.320266251567256e-26,  1.976124054561627e-27, -8.185474462939074e-29,  3.103546544694929e-30, -1.085325648136177e-31,  1.046647855525144e-20,
 -3.683278617082602e-21,  6.919493553000446e-22, -8.937299798839028e-23,  8.848191329501366e-24, -7.132049784240979e-25,  4.862741844700946e-26, -2.879239858717924e-27,
  1.509138545136757e-28, -7.104962625522539e-30,  3.039068871411151e-31, -1.190512634641992e-32,  3.809900522942757e-22, -1.562620678348296e-22,  3.425460864072658e-23,
 -5.114910664374974e-24,  5.794364788816754e-25, -5.292229925868064e-26,  4.052065704073322e-27, -2.672331995694365e-28,  1.548556868258162e-29, -8.005758218082588e-31,
  3.737128190959299e-32, -1.588352418833943e-33,  9.129200370960641e-02, -3.473330070275911e-04,  1.377202671867216e-06, -5.686535969742777e-09,  2.365425175950407e-11,
 -1.081266514550696e-13,  3.561631739309475e-16, -3.469083113008016e-18, -9.293956565479285e-21, -5.410037034761428e-23,  6.349326182491510e-24,  1.872545474332973e-25,
  7.366276191740438e-02, -3.229708818168407e-04,  1.820789541829922e-06, -1.098131878916790e-08,  6.557781758505101e-11, -3.868356087172390e-13,  2.166770100515842e-15,
 -1.300742515345280e-17,  6.148110589280945e-20, -3.759245804619603e-22,  4.610169201985086e-24,  6.576340404708354e-26,  4.791815957728969e-02, -2.663115791131247e-04,
  2.167090826359539e-06, -1.699281545809872e-08,  1.258176872076580e-10, -8.904192637102511e-13,  6.142273633598886e-15, -4.056684529468368e-17,  2.718952168800658e-19,
 -1.703380168976741e-21,  9.421640749073445e-24, -1.110126432908144e-25,  2.508570140952820e-02, -1.844323508098290e-04,  1.987413910211585e-06, -1.880371922763338e-08,
  1.654525110223760e-10, -1.379066782018632e-12,  1.113825230067550e-14, -8.537569219325961e-17,  6.580865433530598e-19, -4.762652332895817e-21,  3.127250002414278e-23,
 -3.334018024021134e-25,  1.054063488391093e-02, -1.034224980832988e-04,  1.380841707075609e-06, -1.537165107429143e-08,  1.583217457391670e-10, -1.532742451823424e-12,
  1.422286284076399e-14, -1.253316760879814e-16,  1.086252950327124e-18, -8.972592084476618e-21,  7.016653185291670e-23, -6.473095753638925e-25,  3.541989048280094e-03,
 -4.604424008919053e-05,  7.331799578945556e-07, -9.514301117659401e-09,  1.135335982924439e-10, -1.262310618615872e-12,  1.331845625423839e-14, -1.333323094083235e-16,
  1.293424277234753e-18, -1.202797767907963e-20,  1.074119069899577e-22, -9.929263176047283e-25,  9.474458526702171e-04, -1.610772383456785e-05,  2.999561631722536e-07,
 -4.515399711009892e-09,  6.192722815354220e-11, -7.843903295942064e-13,  9.348703173753862e-15, -1.054352833910082e-16,  1.141300760873210e-18, -1.184642796422197e-20,
  1.183933456102791e-22, -1.169625932844067e-24,  2.005894227424607e-04, -4.399294329618822e-06,  9.494930311721287e-08, -1.652289997284763e-09,  2.589329450691216e-11,
 -3.716517966731790e-13,  4.982377082225469e-15, -6.296016265599939e-17,  7.584896426345695e-19, -8.743089703626360e-21,  9.690406939410963e-23, -1.044046822764237e-24,
  3.338335950932528e-05, -9.328845949509537e-07,  2.326561075300691e-08, -4.668122224014746e-10,  8.328655166721530e-12, -1.350326613231322e-13,  2.030915997418020e-15,
 -2.866281727275038e-17,  3.835830932122019e-19, -4.896176894388740e-21,  5.993072440821046e-23, -7.079039441124161e-25,  4.332283708036980e-06, -1.526861168739952e-07,
  4.402159815354667e-09, -1.016876773749618e-10,  2.062033147585428e-12, -3.770846781813273e-14,  6.355242781076188e-16, -1.000241241397756e-17,  1.485629309296911e-19,
 -2.097132463439333e-21,  2.829916031539522e-23, -3.669186106446999e-25,  4.343358678414277e-07, -1.915595425256418e-08,  6.401900875630938e-10, -1.702173735708237e-11,
  3.923271363367433e-13, -8.092699342243670e-15,  1.528590273662359e-16, -2.682792061898070e-18,  4.423142494690903e-20, -6.904868339274054e-22,  1.026995348653055e-23,
 -1.462596060836834e-25,  3.328870827159259e-08, -1.827508964560361e-09,  7.109989374888877e-11, -2.178963396696790e-12,  5.718020803308464e-14, -1.332444869863216e-15,
  2.824823626443436e-17, -5.535690763819981e-19,  1.014424911380112e-20, -1.753301409415430e-22,  2.877261887484293e-24, -4.506300586539918e-26,  1.928240921579592e-09,
 -1.313978502785368e-10,  5.985455229061802e-12, -2.120917148995788e-13,  6.357977940894440e-15, -1.678782812160111e-16,  4.006133826596083e-18, -8.788982611484349e-20,
  1.794667005658721e-21, -3.442308914077862e-23,  6.246386474610178e-25, -1.078131947645511e-26,  8.343178988050773e-11, -7.055334188680641e-12,  3.790373340445657e-13,
 -1.560894182108864e-14,  5.372569701995643e-16, -1.614953674358169e-17,  4.356986007739377e-19, -1.074502143517524e-20,  2.454251886422188e-22, -5.242969824040790e-24,
  1.055544671557799e-25, -2.014188782246026e-27,  2.668705423600622e-12, -2.807338082109759e-13,  1.794857847768814e-14, -8.653148248236712e-16,  3.444048384418095e-17,
 -1.186281783456010e-18,  3.640487134438572e-20, -1.014981094177342e-21,  2.607025673063714e-23, -6.233814229111887e-25,  1.398914547290928e-26, -2.964002649256248e-28,
  6.276888726146383e-14, -8.256151964139763e-15,  6.351637535366615e-16, -3.620362906941045e-17,  1.681826573323609e-18, -6.695583494604154e-20,  2.356074038502062e-21,
 -7.481678694293289e-23,  2.176048568150280e-24, -5.861685465123816e-26,  1.475013684988487e-27, -3.489420949044948e-29,  1.094455489548133e-15, -1.813823520677206e-16,
  1.701486556199426e-17, -1.160972194227770e-18,  6.368990461457538e-20, -2.962586330108727e-21,  1.207383003028736e-22, -4.407295702327540e-24,  1.463908988512813e-25,
 -4.477237689343797e-27,  1.272456948170784e-28, -3.383186200305636e-30,  1.474354487787794e-17, -3.106314175659855e-18,  3.606032262110252e-19, -2.988341751378153e-20,
  1.962424992278067e-21, -1.079962316282066e-22,  5.155931337108682e-24, -2.186004363274892e-25,  8.370292918821773e-27, -2.931279967660215e-28,  9.481070090752784e-30,
 -2.852403149009322e-31,  1.730293565694617e-19, -4.661117286233150e-20,  6.782582810844013e-21, -6.917461493333544e-22,  5.505671461232012e-23, -3.625006342020304e-24,
  2.047600356462656e-25, -1.017121243692459e-26,  4.523300181083513e-28, -1.825355950623313e-29,  6.754793003452608e-31, -2.309342923958844e-32,  2.371218140630612e-21,
 -8.076437021034465e-22,  1.470687569108983e-22, -1.846447247987265e-23,  1.781661019060794e-24, -1.402963773573824e-25,  9.364170908372570e-27, -5.437598140191713e-28,
  2.799575799376521e-29, -1.296502712028482e-30,  5.461966930363422e-32, -2.109813984497940e-33,  6.334575370594484e-23, -2.572123344462802e-23,  5.581460574490722e-24,
 -8.255944203771303e-25,  9.272008398881032e-26, -8.401641948454448e-27,  6.386265670426068e-28, -4.183725278091447e-29,  2.409526742513815e-30, -1.238637082395218e-31,
  5.751755222288429e-33, -2.432766511681743e-34,  8.992428361765720e-02, -3.365820669242544e-04,  1.311165097540241e-06, -5.324937401674058e-09,  2.156915651090809e-11,
 -1.007775493682806e-13,  2.550293267794971e-16, -3.729616179045671e-18, -4.237961775004293e-21,  4.144796659971301e-22,  1.840610292431724e-23,  3.682724809335970e-25,
  7.239920087163462e-02, -3.089144018500002e-04,  1.695062698740590e-06, -9.991261914359745e-09,  5.833273043858794e-11, -3.389923757768051e-13,  1.828363604222732e-15,
 -1.121411311370728e-17,  5.214865723398287e-20, -1.131322262334683e-22,  9.070815145840456e-24,  1.396433398024944e-25,  4.688634185297099e-02, -2.497575884812144e-04,
  1.974692792904518e-06, -1.511455923013263e-08,  1.093962914243889e-10, -7.557062877083574e-13,  5.119453685107176e-15, -3.278455393830744e-17,  2.161188986734008e-19,
 -1.431202746748513e-21,  3.978562234537437e-24, -1.393817922554560e-25,  2.437840243045170e-02, -1.693926206544214e-04,  1.776787462441347e-06, -1.636337736929313e-08,
  1.403623790520045e-10, -1.138205823485983e-12,  9.018334880326829e-15, -6.684757917736187e-17,  5.055923616902519e-19, -3.808033789616174e-21,  1.629668371975662e-23,
 -3.549317391080018e-25,  1.014792798223418e-02, -9.307275508524476e-05,  1.210626151139613e-06, -1.306632145470958e-08,  1.308152311235220e-10, -1.229857727975578e-12,
  1.115520880995431e-14, -9.525142448984227e-17,  8.072517674054564e-19, -6.697755048724025e-21,  4.434892315958183e-23, -5.402120513678076e-25,  3.368861082433658e-03,
 -4.060641759614968e-05,  6.291274257647968e-07, -7.883556004459735e-09,  9.120399291239912e-11, -9.831627597541431e-13,  1.010495647404889e-14, -9.812119833484346e-17,
  9.281065235476687e-19, -8.510640895731573e-21,  7.052398943093443e-23, -7.076341028088837e-25,  8.874933877347783e-04, -1.390908727868981e-05,  2.512355976001256e-07,
 -3.638810044243733e-09,  4.826375097245552e-11, -5.916844829931721e-13,  6.849679856289471e-15, -7.491552692226667e-17,  7.889202743067046e-19, -8.005691103403157e-21,
  7.659007062887419e-23, -7.634224010446504e-25,  1.843951082368255e-04, -3.712492336000576e-06,  7.738180823325275e-08, -1.291518067920048e-09,  1.952626663786713e-11,
 -2.707528149168237e-13,  3.516832827491267e-15, -4.305793999852430e-17,  5.036858772356190e-19, -5.651896393513401e-21,  6.056981947474818e-23, -6.420948988760764e-25,
  2.999154090561427e-05, -7.670906052713022e-07,  1.838218226241943e-08, -3.527605012681093e-10,  6.056947509709128e-12, -9.468206466304696e-14,  1.376680699225418e-15,
 -1.880042986004725e-17,  2.438896833651947e-19, -3.022849418755262e-21,  3.587017896888079e-23, -4.132577206312136e-25,  3.784968036292700e-06, -1.218413429442767e-07,
  3.357421012328656e-09, -7.398615870984644e-11,  1.440210587989600e-12, -2.534215647556227e-14,  4.120552919526581e-16, -6.265966748851226e-18,  9.007198515497632e-20,
 -1.232386629791123e-21,  1.612306264665288e-23, -2.031900907957985e-25,  3.667973655540543e-07, -1.475588590120551e-08,  4.688336914279290e-10, -1.186293815565541e-11,
  2.618132770924900e-13, -5.185976892260837e-15,  9.431948891405890e-17, -1.596900174622401e-18,  2.544260440873383e-20, -3.843948851063045e-22,  5.538663705243291e-24,
 -7.653291943445686e-26,  2.697022895095125e-08, -1.349556759317117e-09,  4.966858053322200e-11, -1.445113171085125e-12,  3.622283041590803e-14, -8.089293034894292e-16,
  1.648246042775228e-17, -3.111039131242556e-19,  5.501368213750320e-21, -9.190115963905090e-23,  1.459556625372353e-24, -2.215256810534969e-26,  1.484441067936758e-09,
 -9.219020184781375e-11,  3.954808743744833e-12, -1.327336884959701e-13,  3.791791206363510e-15, -9.576566269608789e-17,  2.192593459341595e-18, -4.626253734206247e-20,
  9.103670568168755e-22, -1.685703935005693e-23,  2.957386966881963e-25, -4.941986074621262e-27,  6.026681346276094e-11, -4.647436861098954e-12,  2.342429786623141e-13,
 -9.116909488348868e-15,  2.984043876203662e-16, -8.564692734368028e-18,  2.213527446245189e-19, -5.243138450648490e-21,  1.152783826977461e-22, -2.375062174902637e-24,
  4.619144219722130e-26, -8.527529852867903e-28,  1.778368616117284e-12, -1.708491094018913e-13,  1.021908481585282e-14, -4.647989160286490e-16,  1.756151449164124e-17,
 -5.767534047196778e-19,  1.693481576738754e-20, -4.530287569602971e-22,  1.119170329064950e-23, -2.579176586668132e-25,  5.588278322035850e-27, -1.145073157600466e-28,
  3.768849326937098e-14, -4.540008661694692e-15,  3.262839974752235e-16, -1.752719936619042e-17,  7.721492596188389e-19, -2.928642024909632e-20,  9.854001783267046e-22,
 -3.001065690249879e-23,  8.392778246615605e-25, -2.178610669897467e-26,  5.293189130503324e-28, -1.211168820913478e-29,  5.725238207791378e-16, -8.732201118703660e-17,
  7.656844114356714e-18, -4.925506189661764e-19,  2.563139344357658e-20, -1.136260229548505e-21,  4.429897700331989e-23, -1.551762037988418e-24,  4.959461953041165e-26,
 -1.462885955993414e-27,  4.018069838431992e-29, -1.034400744407438e-30,  6.398575693367008e-18, -1.251073006598681e-18,  1.362922762641191e-19, -1.068050192949477e-20,
  6.670678761011776e-22, -3.507304988105228e-23,  1.605755623523705e-24, -6.549331421766146e-26,  2.419005821257584e-27, -8.190940268139105e-29,  2.567007147491872e-30,
 -7.497371154450568e-32,  5.812566764862926e-20, -1.473772234850988e-20,  2.031842130881480e-21, -1.975072153784646e-22,  1.505553956456332e-23, -9.531995262495448e-25,
  5.194851696643556e-26, -2.496939040168562e-27,  1.077180837086005e-28, -4.226089865388909e-30,  1.523401819751882e-31, -5.082585393054873e-33,  5.690350699676485e-22,
 -1.865443832319894e-22,  3.277084828198429e-23, -3.983209750650100e-24,  3.732836558384082e-25, -2.862755416664566e-26,  1.865415809526296e-27, -1.059721436771946e-28,
  5.347528847828721e-30, -2.431171044712352e-31,  1.006929220986156e-32, -3.828919252072228e-34,  1.077884301427674e-23, -4.323899052184448e-24,  9.269783956402143e-25,
 -1.355921582516115e-25,  1.507367197254295e-26, -1.353270167551254e-27,  1.019994481915625e-28, -6.630704230590140e-30,  3.791867875209885e-31, -1.936593541380909e-32,
  8.938994094116869e-34, -3.759983082150771e-35,  8.859853737938250e-02, -3.263426275265197e-04,  1.249270954626550e-06, -4.995658295722176e-09,  1.960635431420121e-11,
 -9.590560561977735e-14,  1.521580311891451e-16, -3.449308871343662e-18,  2.835248334134465e-20,  1.530128545784324e-21,  3.861095950565091e-23,  5.341591704904215e-25,
  7.118992667081908e-02, -2.958181146241302e-04,  1.580551202344810e-06, -9.109896208188071e-09,  5.196722531482293e-11, -2.986919584980356e-13,  1.537694332967614e-15,
 -9.527119259203667e-18,  5.629201592504696e-20,  3.946509088973519e-22,  1.680637792418086e-23,  2.052068108325203e-25,  4.591779842378262e-02, -2.346568959858209e-04,
  1.803342164282851e-06, -1.347875445623544e-08,  9.544031900173794e-11, -6.431203415618733e-13,  4.290708171115138e-15, -2.667503269027457e-17,  1.658869384919683e-19,
 -1.405050736044484e-21, -2.904859303398606e-24, -1.705862395717982e-25,  2.372806864128597e-02, -1.559272412024471e-04,  1.593186936879720e-06, -1.428853740881775e-08,
  1.196199775322508e-10, -9.425212933711786e-13,  7.353215387753566e-15, -5.276752228586423e-17,  3.763619245566999e-19, -3.480536512678801e-21, -1.844202076942614e-25,
 -3.891098327166539e-25,  9.794061822096576e-03, -8.398112673814671e-05,  1.065621612113148e-06, -1.115636561996225e-08,  1.086934778716772e-10, -9.914298567647611e-13,
  8.815746607644731e-15, -7.298029460238695e-17,  5.925003231014005e-19, -5.381404260416565e-21,  2.187801569753658e-23, -4.823152314286369e-25,  3.215935455143328e-03,
 -3.592841459479549e-05,  5.426717184173952e-07, -6.569298477018961e-09,  7.375959774834803e-11, -7.705215676291896e-13,  7.730841662921955e-15, -7.283680502025297e-17,
  6.655331181168673e-19, -6.254652939942584e-21,  4.356924835387449e-23, -5.286806527744932e-25,  8.356176751803480e-04, -1.206158231328065e-05,  2.118397862527472e-07,
 -2.952992650379772e-09,  3.791776138180471e-11, -4.498577404980938e-13,  5.066014930978874e-15, -5.375066976095694e-17,  5.485322394205296e-19, -5.531394234050593e-21,
  4.895050947610623e-23, -5.115784012721792e-25,  1.706920831485594e-04, -3.150503252437754e-06,  6.359322517483619e-08, -1.018211699690464e-09,  1.486626664142483e-11,
 -1.991675290670365e-13,  2.509311970169761e-15, -2.977820075335807e-17,  3.377602726572003e-19, -3.714603104516183e-21,  3.803549292004190e-23, -4.020144013644687e-25,
  2.719263340789177e-05, -6.354512433471522e-07,  1.467339467643302e-08, -2.693675905005460e-10,  4.455234739517059e-12, -6.716823339099637e-14,  9.449573302640680e-16,
 -1.249225818220813e-17,  1.570370622837849e-19, -1.895412040517653e-21,  2.171964560930817e-23, -2.451701843471697e-25,  3.346204770523908e-06, -9.817687638417034e-08,
  2.592712074559422e-09, -5.451449101748632e-11,  1.019573738320180e-12, -1.726943554164033e-14,  2.710862852017664e-16, -3.984653504110990e-18,  5.544128195686719e-20,
 -7.362133487618133e-22,  9.328047817240103e-24, -1.144481904593955e-25,  3.144646432475405e-07, -1.151057707980409e-08,  3.485502855281047e-10, -8.394386645344828e-12,
  1.775349433850577e-13, -3.378273514663095e-15,  5.919475658578673e-17, -9.672069261347591e-19,  1.489552120990352e-20, -2.179507863127208e-22,  3.041873371085072e-24,
 -4.080947208449571e-26,  2.226931862977546e-08, -1.012824245838610e-09,  3.533303378461382e-11, -9.761227949637887e-13,  2.338561682178612e-14, -5.006850048875232e-16,
  9.809291466102380e-18, -1.783922196203709e-19,  3.044917359077490e-21, -4.918241548670723e-23,  7.560285818120696e-25, -1.112357824265498e-26,  1.170154566537364e-09,
 -6.602053861622661e-11,  2.670997605451819e-12, -8.491604355814093e-14,  2.312677023430556e-15, -5.588427209812877e-17,  1.227962936268248e-18, -2.492410043908294e-20,
  4.727509814360785e-22, -8.452560686192107e-24,  1.433880403579077e-25, -2.320175290109005e-27,  4.483158485672639e-11, -3.141302247401410e-12,  1.486488715931082e-13,
 -5.467460871624121e-15,  1.702040129137465e-16, -4.664937841222772e-18,  1.155080143552244e-19, -2.628063775423354e-21,  5.562330344852675e-23, -1.105269300553054e-24,
  2.076537151319353e-26, -3.708797853372920e-28,  1.228898367391929e-12, -1.073820353841176e-13,  6.008034643332755e-15, -2.576934318250098e-16,  9.240998345418054e-18,
 -2.893165709732085e-19,  8.126607699594522e-21, -2.085575662928114e-22,  4.954497615298912e-24, -1.100214533430362e-25,  2.301140448530585e-27, -4.559003172699261e-29,
  2.366376817196800e-14, -2.598409727557167e-15,  1.742503238520973e-16, -8.812804978768894e-18,  3.679213259382839e-19, -1.328640915219008e-20,  4.272237358255200e-22,
 -1.247208822633350e-23,  3.352010613828996e-25, -8.380665392342282e-27,  1.964994197271952e-28, -4.346696469607504e-30,  3.162735565368255e-16, -4.415187636275103e-17,
  3.610270795389574e-18, -2.185599420250487e-19,  1.077315423494120e-20, -4.545822109935059e-22,  1.693484459218327e-23, -5.686730716990521e-25,  1.747069238288843e-26,
 -4.965406586441944e-28,  1.316858649980717e-29, -3.279543758097176e-31,  2.963111969098232e-18, -5.342227841400441e-19,  5.441031284880265e-20, -4.020344221548857e-21,
  2.382390674962084e-22, -1.194242636119263e-23,  5.233419072787868e-25, -2.049856879904355e-26,  7.291430872718008e-28, -2.383585442200125e-29,  7.227583702451229e-31,
 -2.046486883090329e-32,  2.098310585868789e-20, -4.971726517631136e-21,  6.460919856630346e-22, -5.961227352722536e-23,  4.336886803858978e-24, -2.632223993194990e-25,
  1.380302532049420e-26, -6.403773143980466e-28,  2.673769755355269e-29, -1.017692578731144e-30,  3.566584336662196e-32, -1.159103008543792e-33,  1.455794143881006e-22,
 -4.563547524065529e-23,  7.692705113196536e-24, -9.011335860174330e-25,  8.170007478582744e-26, -6.081537773934231e-27,  3.857132763829997e-28, -2.137909464173461e-29,
  1.054809520276297e-30, -4.697470636658359e-32,  1.908919923149005e-33, -7.132730153992001e-35,  1.885296175152815e-24, -7.451738700432536e-25,  1.574426531615426e-25,
 -2.272484398738203e-26,  2.496038868516509e-27, -2.216578651430523e-28,  1.654263786775028e-29, -1.065769280087646e-30,  6.044979417356354e-32, -3.064216396494592e-33,
  1.404674380587425e-34, -5.871144523243246e-36,  8.731278287260222e-02, -3.165830631996910e-04,  1.191142526475715e-06, -4.697133336820070e-09,  1.771772547278157e-11,
 -9.324754547970882e-14,  7.895644957446623e-17, -1.315796937667749e-18,  1.169989619056197e-19,  3.550263238194728e-21,  6.183866304036505e-23,  4.506569240885345e-25,
  7.003127005216389e-02, -2.835972863571919e-04,  1.476030421466857e-06, -8.324292981962509e-09,  4.634195129504411e-11, -2.647666440123172e-13,  1.299318669983126e-15,
 -7.350755992622090e-18,  8.480920963251729e-20,  1.249072721139687e-21,  2.567334105890127e-23,  1.693038560425460e-25,  4.500703533370141e-02, -2.208521215297785e-04,
  1.650352376738692e-06, -1.204925728709821e-08,  8.355008082121684e-11, -5.485542149527728e-13,  3.610274906148957e-15, -2.221316979634505e-17,  1.113956564213826e-19,
 -1.671167690140551e-21, -1.023286371807607e-23, -1.457304597987740e-25,  2.312880885942679e-02, -1.438364316048023e-04,  1.432615684848392e-06, -1.251631193435228e-08,
  1.024211859203954e-10, -7.825297406691132e-13,  6.025295070969827e-15, -4.276339436932556e-17,  2.468543258027967e-19, -3.822438687526231e-21, -1.639458254698587e-23,
 -3.147329854294550e-25,  9.474379218673839e-03, -7.596353035199147e-05,  9.415608820857677e-07, -9.565061485407245e-09,  9.082547239204749e-11, -8.024048083544455e-13,
  7.009584589915024e-15, -5.699122631334182e-17,  4.096224359125982e-19, -4.905596840225151e-21,  2.746653014200379e-24, -3.649029208945763e-25,  3.080432135639789e-03,
 -3.188341353648913e-05,  4.704433729213985e-07, -5.503000010819617e-09,  6.005096943107879e-11, -6.072450734048577e-13,  5.957867333032752e-15, -5.484891741647237e-17,
  4.665334621691119e-19, -4.932602031146864e-21,  2.366440016980252e-23, -3.716793452033981e-25,  7.905500651015900e-04, -1.049893730721001e-05,  1.797671551308542e-07,
 -2.412157876293956e-09,  3.002405969227970e-11, -3.445216280356658e-13,  3.779258451924106e-15, -3.904651510022949e-17,  3.797243475208119e-19, -3.969139273417134e-21,
  3.041626032443778e-23, -3.383905046062695e-25,  1.590355123305150e-04, -2.686870787244831e-06,  5.268027018847863e-08, -8.092090961705201e-10,  1.142343733797670e-11,
 -1.478420406494263e-13,  1.808643563828265e-15, -2.084743167324827e-17,  2.276098937674000e-19, -2.498253034093699e-21,  2.386285238897347e-23, -2.529102325464008e-25,
  2.486671642841602e-05, -5.298765480445077e-07,  1.182804458502356e-08, -2.077079902208325e-10,  3.313014810475541e-12, -4.817634865504234e-14,  6.563520625403858e-16,
 -8.410223158255554e-18,  1.021447786366072e-19, -1.209758916497186e-21,  1.327328204268624e-23, -1.471619176649126e-25,  2.991197144874803e-06, -7.979867889796539e-08,
  2.026068899112478e-09, -4.064554164034673e-11,  7.311493553714181e-13, -1.192387181395954e-14,  1.808307978970988e-16, -2.571395732846494e-18,  3.459465478769903e-20,
 -4.472832219891025e-22,  5.473268740433751e-24, -6.545195257549839e-26,  2.734231497911555e-07, -9.081491405217155e-09,  2.628583650453179e-10, -6.025485360520506e-12,
  1.222329914359578e-13, -2.235208434123432e-15,  3.775567865333556e-17, -5.957191296652680e-19,  8.866382249379039e-21, -1.258189475389802e-22,  1.699687966759408e-24,
 -2.215230231924025e-26,  1.871723684194178e-08, -7.713386128390623e-10,  2.557135640495599e-11, -6.707904901638404e-13,  1.537220429032753e-14, -3.156401783386444e-16,
  5.948912969766587e-18, -1.042865648791119e-19,  1.718352067771825e-21, -2.685478757922643e-23,  3.995352493501559e-25, -5.700467461195156e-27,  9.431426341059734e-10,
 -4.817508502751395e-11,  1.841743941527194e-12, -5.546320120665998e-14,  1.440946159728244e-15, -3.332421891771043e-17,  7.030043387705158e-19, -1.373071613210112e-20,
  2.510765073150707e-22, -4.336091762693063e-24,  7.113154276655231e-26, -1.114718524421039e-27,  3.428633759984234e-11, -2.174477022016106e-12,  9.672739831787917e-14,
 -3.361785049123606e-15,  9.956879038377274e-17, -2.606377333203928e-18,  6.184104558907865e-20, -1.351712182072829e-21,  2.754272144900915e-23, -5.279020517079590e-25,
  9.581314305565403e-27, -1.655644400436389e-28,  8.789589278818095e-13, -6.955309784085867e-14,  3.641487055617432e-15, -1.472354847257358e-16,  5.011138703181719e-18,
 -1.495477605956378e-19,  4.018225452878455e-21, -9.892109059313117e-23,  2.259542708739121e-24, -4.834423054392765e-26,  9.759309826365755e-28, -1.869182257839479e-29,
  1.550695024444861e-14, -1.544434946368802e-15,  9.657390492575147e-17, -4.594819604413391e-18,  1.816927392733925e-19, -6.244131918351894e-21,  1.917943214883322e-22,
 -5.364901285887060e-24,  1.385116995415058e-25, -3.334130088780006e-27,  7.541042491516172e-29, -1.611976702312278e-30,  1.841984384119751e-16, -2.340068303015938e-17,
  1.780827711834014e-18, -1.012974635427894e-19,  4.723815696352257e-21, -1.895235541188765e-22,  6.740086046705559e-24, -2.167727542830808e-25,  6.396115228638341e-27,
 -1.750125717451400e-28,  4.477958086186164e-30, -1.077986645544364e-31,  1.463388656996905e-18, -2.416408139263776e-19,  2.292793455662615e-20, -1.593073119762567e-21,
  8.937071918929789e-23, -4.262967063844506e-24,  1.784991508071006e-25, -6.703451751453920e-27,  2.292904858790266e-28, -7.226202233653848e-30,  2.117172163822510e-31,
 -5.804239526909840e-33,  8.158342763795204e-21, -1.792363920066620e-21,  2.184103065939496e-22, -1.904883808542995e-23,  1.318047091913995e-24, -7.645662070915270e-26,
  3.847248762255257e-27, -1.718572907904093e-28,  6.929136266755822e-30, -2.553299577534856e-31,  8.682537889693057e-33, -2.743583127452635e-34,  3.996985517930320e-23,
 -1.189022310621303e-23,  1.911697353754099e-24, -2.147457268935129e-25,  1.875573316753848e-26, -1.350077026085532e-27,  8.307019351064649e-29, -4.479265629000700e-30,
  2.155112666779108e-31, -9.378868515671806e-33,  3.731383015904205e-34, -1.367307990162849e-35,  3.407903730233658e-25, -1.322678497059690e-25,  2.745655942439863e-26,
 -3.900134467359617e-27,  4.222771832619785e-28, -3.701950913510089e-29,  2.730901848162111e-30, -1.741001437680728e-31,  9.781034608850870e-33, -4.915083367109711e-34,
  2.235280363301934e-35, -9.275076196600903e-37,  8.606515853564228e-02, -3.072747072595604e-04,  1.136416605959392e-06, -4.428469605548132e-09,  1.587149234777223e-11,
 -9.123564863185640e-14,  1.173329072381204e-16,  4.981053887654875e-18,  2.927869120898943e-19,  6.262824170478007e-21,  6.828317331830523e-23, -3.143447098955678e-25,
  6.891988202540070e-02, -2.721763957982577e-04,  1.380418298724997e-06, -7.623553970425677e-09,  4.134357141337027e-11, -2.356972417489352e-13,  1.139733636991776e-15,
 -3.707968377318272e-18,  1.495198720529139e-19,  2.361294776335041e-21,  2.772295260564950e-23, -1.383178657216489e-25,  4.414914776326546e-02, -2.082057454828395e-04,
  1.513434739094268e-06, -1.079572183417129e-08,  7.339691771303400e-11, -4.690271243638596e-13,  3.028540978534446e-15, -1.970057402421851e-17,  4.265210544343801e-20,
 -2.169347732513383e-21, -1.330753410816068e-23,  4.446715524698774e-26,  2.257547156771235e-02, -1.329495708969533e-04,  1.291760279347471e-06, -1.099531345911131e-08,
  8.812372978416251e-11, -6.515308007631836e-13,  4.916785963477878e-15, -3.721491625060948e-17,  9.482572084669900e-20, -4.670183812904993e-21, -2.311373968646526e-23,
  8.502026793304159e-26,  9.184896467310815e-03, -6.886662458087977e-05,  8.349979880601960e-07, -8.231616194246817e-09,  7.633738347191732e-11, -6.520057578459004e-13,
  5.570782149851195e-15, -4.671478067244786e-17,  2.318159923112543e-19, -5.037064613873507e-21, -6.768498329762746e-24, -1.103467698689294e-26,  2.960029250672760e-03,
 -2.836855170364426e-05,  4.097952920053776e-07, -4.632068506584708e-09,  4.921960250651416e-11, -4.811567844908539e-13,  4.605543455231995e-15, -4.260685388263007e-17,
  3.025946925676173e-19, -4.252288354785149e-21,  1.209220149427038e-23, -1.307346603077573e-25,  7.512581433686853e-04, -9.168910505786982e-06,  1.534911899149157e-07,
 -1.982316861970028e-09,  2.395865608239337e-11, -2.656902761233246e-13,  2.836110384799184e-15, -2.897314308708612e-17,  2.555618675044906e-19, -3.004594416789993e-21,
  1.895902231930295e-23, -1.798531581248041e-25,  1.490735221056300e-04, -2.301373813175474e-06,  4.397596614483787e-08, -6.479150178340001e-10,  8.857312295125502e-12,
 -1.106933120060446e-13,  1.314561383407371e-15, -1.483845746860280e-17,  1.524730555445949e-19, -1.733720442043707e-21,  1.511451737830368e-23, -1.493471305226965e-25,
  2.292185534469072e-05, -4.443890745007309e-07,  9.624370338589848e-09, -1.616259878638948e-10,  2.489688461933986e-12, -3.491724728386719e-14,  4.607426984901533e-16,
 -5.747391062335909e-18,  6.677211004538620e-20, -7.887240095195557e-22,  8.211686382620052e-24, -8.739428905182474e-26,  2.701589128210777e-06, -6.535894637909973e-08,
  1.601344954223030e-09, -3.064157392504070e-11,  5.308278375899856e-13, -8.336323693144338e-15,  1.221809288958319e-16, -1.684801818462630e-18,  2.182588537432202e-20,
 -2.766624150043610e-22,  3.258624100825838e-24, -3.772393495261677e-26,  2.408878104181263e-07, -7.237704045679317e-09,  2.009569346788229e-10, -4.383301217133643e-12,
  8.538859764280222e-14, -1.500932263098283e-15,  2.445031227585360e-17, -3.730397899738558e-19,  5.357406237215083e-21, -7.394664992509333e-23,  9.658915991163147e-25,
 -1.220803118223705e-26,  1.599537237363567e-08, -5.952183510975359e-10,  1.881194128041323e-11, -4.684717327811384e-13,  1.027930550154045e-14, -2.024870477322677e-16,
  3.672815491380230e-18, -6.211486566768232e-20,  9.875949354222212e-22, -1.495244887619542e-23,  2.152641154157249e-25, -2.977492809479925e-27,  7.761883186096159e-10,
 -3.575671526250684e-11,  1.295170346394282e-12, -3.693927405869969e-14,  9.161861543468529e-16, -2.028448426378723e-17,  4.109814467751748e-19, -7.728149132815567e-21,
  1.362340344309595e-22, -2.273852796921541e-24,  3.607419286568853e-26, -5.475456795800938e-28,  2.691417335735461e-11, -1.538435901956589e-12,  6.445429859461704e-14,
 -2.116341994198489e-15,  5.966622028683443e-17, -1.492003157131712e-18,  3.393015073665743e-20, -7.126783283721386e-22,  1.398131098582617e-23, -2.585418977841723e-25,
  4.533479885539782e-27, -7.579579485251751e-29,  6.494828331997867e-13, -4.632288776262734e-14,  2.271742595231010e-15, -8.655810696782255e-17,  2.796473405501368e-18,
 -7.955118849695775e-20,  2.044712788260190e-21, -4.828781785146205e-23,  1.060491668134371e-24, -2.186105016333724e-26,  4.259143690303127e-28, -7.885350682743367e-30,
  1.058421950511894e-14, -9.510621676030948e-16,  5.544699160455209e-17, -2.480000117759243e-18,  9.285707039137770e-20, -3.035896192443654e-21,  8.905078603723766e-23,
 -2.386057107312108e-24,  5.916038828475508e-26, -1.370624292757497e-27,  2.989467338952423e-29, -6.173136947637179e-31,  1.128856664831682e-16, -1.297121740597945e-17,
  9.173507617174387e-19, -4.896269702510958e-20,  2.158009926610690e-21, -8.225102704195070e-23,  2.790161688524944e-24, -8.588132277126914e-26,  2.431967646816717e-27,
 -6.401932640949467e-29,  1.579228897866314e-30, -3.672293457778659e-32,  7.699541507779341e-19, -1.156089002181223e-19,  1.018688523752855e-20, -6.639427869408638e-22,
  3.519153215641002e-23, -1.594551373331769e-24,  6.369618772075230e-26, -2.290183240969117e-27,  7.522525323088213e-29, -2.282604797792054e-30,  6.453881425037736e-32,
 -1.711053288954763e-33,  3.421612866951813e-21, -6.911457169057033e-22,  7.856361042510030e-23, -6.450790879646064e-24,  4.230875270198795e-25, -2.338710338308027e-26,
  1.126294762669096e-27, -4.832636785329280e-29,  1.877403052987021e-30, -6.683686078266498e-32,  2.201062191516604e-33, -6.750210528310347e-35,  1.185498375679457e-23,
 -3.317310813086407e-24,  5.053294009599973e-25, -5.414007784181070e-26,  4.534300421485102e-27, -3.143678741593105e-28,  1.869966811951800e-29, -9.778435505864876e-31,
  4.574914362200147e-32, -1.940617272176339e-33,  7.541175483046118e-35, -2.704173719648241e-36,  6.409067621360430e-26, -2.431769078789261e-26,  4.940171014114531e-27,
 -6.883145992520654e-28,  7.325579631488808e-29, -6.324389818153447e-30,  4.601841890843767e-31, -2.897744121728303e-32,  1.609896880158675e-33, -8.008409592958595e-35,
  3.608634648312465e-36, -1.484835642163214e-37,  8.485391172206892e-02, -2.983917612685705e-04,  1.084739095644617e-06, -4.188901117896897e-09,  1.409265704677685e-11,
 -8.546128001089011e-14,  4.253384797352813e-16,  1.843106538097882e-17,  5.599120868393771e-19,  8.240472908782924e-21,  1.629296876951301e-23, -2.282911464870252e-24,
  6.785269916048056e-02, -2.614880832836274e-04,  1.292753817295500e-06, -6.998306669065798e-09,  3.689790688623668e-11, -2.089631350187073e-13,  1.117080369779483e-15,
  2.628251462345958e-18,  2.513571177439877e-19,  3.158162848758721e-21,  6.421843719684602e-24, -9.224218677393142e-25,  4.333974653798108e-02, -1.965971864431143e-04,
  1.390634907981186e-06, -9.692652006595603e-09,  6.469902229373147e-11, -4.028829251491974e-13,  2.483614101257002e-15, -1.967755359457155e-17, -4.352149471394747e-20,
 -2.544266574445292e-21, -1.890355671773435e-24,  5.327180036667407e-25,  2.206353838896456e-02, -1.231202444664856e-04,  1.167866196426137e-06, -9.683517387936720e-09,
  7.618982989189326e-11, -5.458505667678022e-13,  3.890810217346737e-15, -3.702820484666711e-17, -8.694227141284599e-20, -5.279934334378804e-21, -2.153001113886647e-25,
  1.070032207112324e-24,  8.922192397724628e-03, -6.256194049269074e-05,  7.431390061675161e-07, -7.107706486739400e-09,  6.453192176652943e-11, -5.333341523616666e-13,
  4.339036616837243e-15, -4.224016961110488e-17,  4.721439748245755e-20, -5.121082519877212e-21,  8.356966387447914e-24,  7.855606379321359e-25,  2.852777714195835e-03,
 -2.529983520420100e-05,  3.586363773139858e-07, -3.915922035145871e-09,  4.061023114359049e-11, -3.839837367821481e-13,  3.525731730351301e-15, -3.528469789940798e-17,
  1.578165125275974e-19, -3.772279287266719e-21,  1.508932000002749e-23,  3.069822440837112e-25,  7.168964006559148e-04, -8.029996569239798e-06,  1.318393263820894e-07,
 -1.638050950616842e-09,  1.926417577793212e-11, -2.065295287554872e-13,  2.124062525370507e-15, -2.239176231497558e-17,  1.596255419060333e-19, -2.350350763359486e-21,
  1.519955389503617e-23,  1.922089733292436e-26,  1.405255933673760e-04, -1.978414596284308e-06,  3.698341939946139e-08, -5.223268057507611e-10,  6.927906110533374e-12,
 -8.363200551005812e-14,  9.587748922988057e-16, -1.085252238553330e-17,  9.959910837750125e-20, -1.234165081149664e-21,  1.050701860318461e-23, -6.068483014017597e-26,
  2.128689606877084e-05, -3.745243898568015e-07,  7.902629635444002e-09, -1.268276099180928e-10,  1.890030882379283e-12, -2.557323913658399e-14,  3.258733773119252e-16,
 -4.008330208221377e-18,  4.348195969134228e-20, -5.243906445573165e-22,  5.295356513428882e-24, -4.736565980334702e-26,  2.463634447476187e-06, -5.388630746481416e-08,
  1.279579010658620e-09, -2.333754541437093e-11,  3.899755208241774e-13, -5.899529965530666e-15,  8.344939944502518e-17, -1.123484515371949e-18,  1.386266637690167e-20,
 -1.741008627826053e-22,  1.987975850123842e-24, -2.136943139296873e-26,  2.148491966522257e-07, -5.819311919891772e-09,  1.556583599438753e-10, -3.228581492666836e-12,
  6.048254771570535e-14, -1.022310777390980e-15,  1.605276495789204e-17, -2.376752856300652e-19,  3.278472634720303e-21, -4.421932162125024e-23,  5.598129306547235e-25,
 -6.774356819163157e-27,  1.388346355057786e-08, -4.646928524799031e-10,  1.405749245731913e-11, -3.321443384261983e-13,  6.986706902429692e-15, -1.320826684039429e-16,
  2.305632808494412e-18, -3.768878299494980e-20,  5.772114935660317e-22, -8.483479367928553e-24,  1.182870067179450e-25, -1.580441159106122e-27,  6.513919435021631e-10,
 -2.694691795075886e-11,  9.280195323952762e-13, -2.505548179607621e-14,  5.938623824768423e-16, -1.259169968689740e-17,  2.450624394480655e-19, -4.441047936226448e-21,
  7.543389140811251e-23, -1.217922698634525e-24,  1.869352596176405e-26, -2.745842941939364e-28,  2.165110341017174e-11, -1.110167443747606e-12,  4.392818429106629e-14,
 -1.362132206922811e-15,  3.658191362327281e-17, -8.740763657843016e-19,  1.905578620975952e-20, -3.848219655745785e-22,  7.267915544493599e-24, -1.297176185075522e-25,
  2.197890337278868e-27, -3.554968505470785e-29,  4.948945104866022e-13, -3.164872159808488e-14,  1.456531636184698e-15, -5.227540460238072e-17,  1.603776273174361e-18,
 -4.349254554684521e-20,  1.069463746088735e-21, -2.423263687764378e-23,  5.116725381289362e-25, -1.016328091705796e-26,  1.911013545472741e-28, -3.419764003583276e-30,
  7.509045202306193e-15, -6.052281909936527e-16,  3.291979836630874e-17, -1.383286859381885e-18,  4.903817749772190e-20, -1.524958584223399e-21,  4.270871008825727e-23,
 -1.095999210434770e-24,  2.609095754951102e-26, -5.816777586519432e-28,  1.223162081634897e-29, -2.439322163031380e-31,  7.264658351175123e-17, -7.500525074381366e-18,
  4.925623135597138e-19, -2.463924660309284e-20,  1.025628865520898e-21, -3.711022127789024e-23,  1.200026528103783e-24, -3.532885066230041e-26,  9.595689234400885e-28,
 -2.428710689257678e-29,  5.772692227581202e-31, -1.295907245932412e-32,  4.309351569536977e-19, -5.838633933456899e-20,  4.764999381423231e-21, -2.906778883933769e-22,
  1.453186786633028e-23, -6.245214146245550e-25,  2.376710209348378e-26, -8.170937047469681e-28,  2.574209979931882e-29, -7.511890925734306e-31,  2.047369719410714e-32,
 -5.243469667085080e-34,  1.549113014355611e-21, -2.850728312304775e-22,  3.007750558263334e-23, -2.316045332822560e-24,  1.435262850126960e-25, -7.539281244813285e-27,
  3.466258423141533e-28, -1.425328572027119e-29,  5.323910837156398e-31, -1.827531142975421e-32,  5.817578112610422e-34, -1.728519055959624e-35,  3.822382814365033e-24,
 -9.959666033744176e-25,  1.427108153143704e-25, -1.449878143720324e-26,  1.158774531405439e-27, -7.705638609186160e-29,  4.414759404281739e-30, -2.231415623642124e-31,
  1.012158063756575e-32, -4.173526306549921e-34,  1.580172244463804e-35, -5.532359228723305e-37,  1.264374654331859e-26, -4.662737727524269e-27,  9.224321952631653e-28,
 -1.255428132330663e-28,  1.308782092493406e-29, -1.109418087536182e-30,  7.942073595580675e-32, -4.928704310211721e-33,  2.702590308018284e-34, -1.328585860860546e-35,
  5.922800120335220e-37, -2.413417573775262e-38,  8.367738739214753e-02, -2.899112078207520e-04,  1.035771144273055e-06, -3.976322369341306e-09,  1.253893914592810e-11,
 -6.676287383384628e-14,  1.236352987820243e-15,  4.097225465196466e-17,  8.360991240611583e-19,  5.987182041056057e-21, -1.533357959505613e-22, -5.612519964239541e-24,
  6.682691277930748e-02, -2.514722431994496e-04,  1.212183249874138e-06, -6.439874869702152e-09,  3.299784654383445e-11, -1.802567200714311e-13,  1.320164853614235e-15,
  1.244038716752094e-17,  3.567184543407185e-19,  2.247422880315503e-21, -6.163666279495301e-23, -2.244278158022613e-24,  4.257489537158409e-02, -1.859203486276784e-04,
  1.280278257073307e-06, -8.718881525222665e-09,  5.719163244934648e-11, -3.501290038911270e-13,  1.899599522227440e-15, -2.249161712684040e-17, -1.288422051279453e-19,
 -1.928550204183411e-21,  3.873165711086699e-23,  1.359736617025822e-24,  2.158903552528256e-02, -1.142221986067189e-04,  1.058633403185075e-06, -8.547102977143076e-09,
  6.612027145191208e-11, -4.653999255169804e-13,  2.787142067947600e-15, -4.273544976358326e-17, -2.618615141775489e-19, -3.902363948124000e-21,  8.117134826095155e-23,
  2.719664160989138e-24,  8.683318429493972e-03, -5.694122157102101e-05,  6.637068243233257e-07, -6.155272297165256e-09,  5.481098114293200e-11, -4.433852393322194e-13,
  3.150699599809931e-15, -4.352650765119151e-17, -1.196496997972573e-19, -3.742999433810447e-21,  7.009349607664402e-23,  2.089646763237814e-24,  2.757033805803214e-03,
 -2.260821787722495e-05,  3.153044619838810e-07, -3.323325383607290e-09,  3.369914096236443e-11, -3.107716370946410e-13,  2.589081981622819e-15, -3.225381726981315e-17,
  3.777734016915236e-20, -2.714898480079542e-21,  4.270934576370154e-23,  9.806476076868204e-25,  6.867683567110149e-04, -7.048965497325768e-06,  1.139041788441615e-07,
 -1.360302829432929e-09,  1.559524264705749e-11, -1.625723215485628e-13,  1.556752523441849e-15, -1.851424751639265e-17,  8.682069986712518e-20, -1.652044568883035e-21,
  2.163977476620632e-23,  2.824038568264344e-25,  1.331664752087125e-04, -1.705854023569510e-06,  3.132916166923734e-08, -4.237085210137521e-10,  5.462455780981953e-12,
 -6.394595898618011e-14,  6.934010977885362e-16, -8.298775242744861e-18,  6.232883401867262e-20, -8.410894259505652e-22,  9.800112229777955e-24,  2.887040934498373e-26,
  1.990627946778455e-05, -3.169132788687019e-07,  6.546541517435823e-09, -1.002894354884419e-10,  1.448428416306961e-12, -1.895791824089401e-14,  2.305527393596438e-16,
 -2.881576555974323e-18,  2.800132720636550e-20, -3.448032994244677e-22,  3.905054075845179e-24, -1.697939552677994e-26,  2.266927586180773e-06, -4.467211419970593e-08,
  1.033397711470388e-09, -1.794290669656540e-11,  2.897010676019627e-13, -4.229392020386154e-15,  5.735986765581038e-17, -7.664459798065010e-19,  8.830897353893754e-21,
 -1.100370779188443e-22,  1.289752200500235e-24, -1.109756572909560e-26,  1.938384457034372e-07, -4.713994040712954e-09,  1.221090811529821e-10, -2.405564459252261e-12,
  4.340549423499466e-14, -7.063779851520026e-16,  1.065505174194922e-17, -1.544316318251247e-19,  2.027404450865063e-21, -2.676041274599297e-23,  3.353589579187829e-25,
 -3.706314322525165e-27,  1.222680985366961e-08, -3.664583295785862e-10,  1.066415143883488e-11, -2.388082740230611e-13,  4.822625602257639e-15, -8.757633358741852e-17,
  1.468825829284589e-18, -2.331165610421633e-20,  3.425565339115794e-22, -4.892706880746302e-24,  6.656139129703862e-26, -8.465345331130304e-28,  5.567535581415557e-10,
 -2.058114909426593e-11,  6.769844163422715e-13, -1.728663799887547e-14,  3.920259368416553e-16, -7.965507526536683e-18,  1.488226846864909e-19, -2.605078357808026e-21,
  4.257256908628150e-23, -6.653721885123733e-25,  9.904872894427870e-27, -1.402114551725867e-28,  1.782224160862018e-11, -8.153576334817386e-13,  3.058908135915813e-14,
 -8.950655977271400e-16,  2.292049924834366e-17, -5.235331657378036e-19,  1.094006489839366e-20, -2.126474039442706e-22,  3.864670396159830e-24, -6.660145470026445e-26,
  1.091305710388341e-27, -1.705910490914013e-29,  3.881700523391596e-13, -2.212753269536406e-14,  9.584429275201031e-16, -3.238048208780523e-17,  9.439355852384465e-19,
 -2.440917037792097e-20,  5.742039657725320e-22, -1.248917841670566e-23,  2.535103803279690e-25, -4.852724982438398e-27,  8.808124126469461e-29, -1.523170869849034e-30,
  5.525893983215745e-15, -3.969309751684363e-16,  2.017704602628359e-17, -7.959321113086914e-19,  2.671965913477139e-20, -7.902891238130222e-22,  2.112988694851620e-23,
 -5.193416667885601e-25,  1.186832028279534e-26, -2.545910414776763e-28,  5.160822883819562e-30, -9.937621958012926e-32,  4.898340542822794e-17, -4.511428205142806e-18,
  2.751394022826142e-19, -1.288486596913793e-20,  5.063114913931358e-22, -1.738268888466566e-23,  5.355634756207797e-25, -1.507406882266102e-26,  3.925164952458561e-28,
 -9.547812177156224e-30,  2.185600234690674e-31, -4.734305595159369e-33,  2.560804869869417e-19, -3.104691350928295e-20,  2.342308216577852e-21, -1.334754132433669e-22,
  6.284889813631156e-24, -2.558551931416204e-25,  9.265501984025492e-27, -3.042486987565593e-28,  9.183792556680565e-30, -2.574685765297664e-31,  6.757675894477440e-33,
 -1.670233377292653e-34,  7.570660587051533e-22, -1.256628225420558e-22,  1.225004296569689e-23, -8.814235324039440e-25,  5.145883271242212e-26, -2.562091590414652e-27,
  1.121956592112255e-28, -4.411925418074842e-30,  1.581337466919746e-31, -5.224236827452806e-33,  1.604695360494886e-34, -4.611467934430270e-36,  1.347372391387080e-24,
 -3.231393646189274e-25,  4.322283655866813e-26, -4.139148731327389e-27,  3.141111118658994e-28, -1.994802922284189e-29,  1.096594683102094e-30, -5.339181325919866e-32,
  2.340744730462583e-33, -9.355811564621490e-35,  3.442391755854933e-36, -1.173926617578894e-37,  2.643055158102258e-27, -9.401290226970776e-28,  1.799807802216340e-28,
 -2.380453676584978e-29,  2.420434245995855e-30, -2.007237150603771e-31,  1.409345234142720e-32, -8.596572032232048e-34,  4.641643045383532e-35, -2.250388277116181e-36,
  9.907324727875771e-38, -3.991565868106137e-39,  8.253401739565956e-02, -2.818125803892980e-04,  9.892213741009704e-07, -3.784322717311772e-09,  1.160960536116138e-11,
 -2.015674260571538e-14,  2.778987532618501e-15,  6.944305009482981e-17,  8.717017815811343e-19, -6.174179301600114e-21, -4.797375998728511e-22, -8.972906426265172e-24,
  6.583994163287719e-02, -2.420751779007825e-04,  1.137959532786107e-06, -5.938886516843173e-09,  2.974467131111382e-11, -1.430504233616291e-13,  1.835827912869711e-15,
  2.445463186700663e-17,  3.654725721652079e-19, -2.625212442120269e-21, -1.919245879806587e-22, -3.578765266934222e-24,  4.185105707305196e-02, -1.760815899625066e-04,
  1.180918407487878e-06, -7.857582162649697e-09,  5.059131439677579e-11, -3.126119507293536e-13,  1.204566215478469e-15, -2.729294538125757e-17, -1.534777623553016e-19,
  1.087517885824455e-21,  1.182709590563985e-22,  2.192755520847198e-24,  2.114845977019666e-02, -1.061460934995291e-04,  9.621191667219526e-07, -7.560433458367034e-09,
  5.737892056268949e-11, -4.139155199554328e-13,  1.458100578692363e-15, -5.246934749783498e-17, -3.101118840682692e-19,  2.275979115509704e-21,  2.401020059930017e-22,
  4.380352275262548e-24,  8.465725241649845e-03, -5.191276080636850e-05,  5.948249312705733e-07, -5.345553247289826e-09,  4.659804797758699e-11, -3.829262388863670e-13,
  1.863123725043466e-15, -4.876454859627475e-17, -1.778748456249392e-19,  1.323150009567510e-21,  1.929412360380524e-22,  3.397394135214053e-24,  2.671405576420280e-03,
 -2.023658758968835e-05,  2.784646665885169e-07, -2.830792048571135e-09,  2.803230937121523e-11, -2.594105363009965e-13,  1.691110562648639e-15, -3.218148551664782e-17,
 -1.682378515624219e-20,  7.223029629390992e-23,  1.016035335830345e-22,  1.647500968159167e-24,  6.602972569178116e-04, -6.199019471875210e-06,  9.897649677229204e-08,
 -1.134931760419104e-09,  1.267683977583153e-11, -1.311653919757186e-13,  1.069664553006235e-15, -1.649126606861248e-17,  4.666833782604329e-20, -4.569178748658401e-22,
  3.997494433207570e-23,  5.329209542427369e-25,  1.268141002288344e-04, -1.474164651541929e-06,  2.672957293170390e-08, -3.457116674700496e-10,  4.332187451484828e-12,
 -4.989252308485903e-14,  4.849680962295027e-16, -6.709044406016080e-18,  3.964349671460613e-20, -3.985647380324390e-22,  1.289866634442377e-23,  1.063885311657366e-25,
  1.873626952697803e-05, -2.689878591712490e-07,  5.470508178285546e-09, -7.987295446296336e-11,  1.118545744562095e-12, -1.430202885524634e-14,  1.607558266110401e-16,
 -2.155002091895638e-18,  1.828821015502674e-20, -1.961752687834055e-22,  3.691915048695260e-24,  5.593586330144489e-27,  2.103513171938409e-06, -3.719337010670243e-08,
  8.433263735728093e-10, -1.391636068495921e-11,  2.172920230300770e-13, -3.081673934003377e-15,  3.932622618242530e-17, -5.381020455154092e-19,  5.700736690771193e-21,
 -6.603730324602152e-23,  9.581823186675233e-25, -4.517268902456121e-27,  1.767687494736838e-07, -3.841772416402421e-09,  9.698430983378805e-11, -1.811551685054057e-12,
  3.151932044902253e-14, -4.960194750674914e-16,  7.111210616873180e-18, -1.026616503087220e-19,  1.271732409800054e-21, -1.601339490588147e-23,  2.148542825307415e-25,
 -1.933849066836514e-27,  1.091514434654193e-08, -2.914178512098413e-10,  8.209271202911523e-12, -1.739446876475870e-13,  3.376518914024161e-15, -5.906457114270021e-17,
  9.463687286337394e-19, -1.471866545875051e-20,  2.066192065744103e-22, -2.841386631995850e-24,  3.885693879131411e-26, -4.526049025109710e-28,  4.840829534522232e-10,
 -1.589936086491001e-11,  5.024889776749982e-13, -1.211692896799267e-14,  2.632356627048834e-16, -5.134797258881104e-18,  9.183457280745665e-20, -1.560148033016375e-21,
  2.448225471439025e-23, -3.692943947937624e-25,  5.387801579508237e-27, -7.259981578683634e-29,  1.499006930960631e-11, -6.080859613853036e-13,  2.174435846041899e-14,
 -5.996357335785060e-16,  1.465697948572154e-17, -3.203934296762872e-19,  6.409381770679664e-21, -1.201918130796374e-22,  2.100432600635629e-24, -3.492529908223847e-26,
  5.552960841571934e-28, -8.359480284295992e-30,  3.128531273015861e-13, -1.579026904190002e-14,  6.465211027068893e-16, -2.053847454079992e-17,  5.693674034722253e-19,
 -1.404794799246620e-20,  3.159984136328991e-22, -6.604495855821005e-24,  1.288465580150779e-25, -2.376655902175053e-27,  4.168216820540125e-29, -6.959295289693165e-31,
  4.209387493299127e-15, -2.674955765975950e-16,  1.274674800729600e-17, -4.715784581747407e-19,  1.499762049867263e-20, -4.219855500167525e-22,  1.076864710852231e-23,
 -2.535814540842325e-25,  5.562183657731890e-27, -1.147954168438018e-28,  2.243504560409688e-30, -4.170015331054606e-32,  3.452521753669616e-17, -2.813575487096611e-18,
  1.595781073649564e-19, -6.988253197577377e-21,  2.591836922746522e-22, -8.440742800739719e-24,  2.476837643620546e-25, -6.663419369153177e-27,  1.662818311528255e-28,
 -3.885840840968016e-30,  8.563894225134859e-32, -1.789229933912604e-33,  1.612101439469192e-19, -1.732846549330201e-20,  1.207542760595462e-21, -6.416461388593168e-23,
  2.842554778892257e-24, -1.095047492881583e-25,  3.769917692751225e-27, -1.181324924988904e-28,  3.413484496337837e-30, -9.185902687177557e-32,  2.319805922864474e-33,
 -5.528650556286814e-35,  3.990381337982468e-22, -5.909119375702438e-23,  5.301837829934553e-24, -3.552851196029866e-25,  1.948997264634434e-26, -9.176637322929493e-28,
  3.819526438353198e-29, -1.433580572145306e-30,  4.921648090244759e-32, -1.562158797337364e-33,  4.622454732593538e-35, -1.282767168610136e-36,  5.216756002065013e-25,
 -1.136478239993689e-25,  1.408046773217762e-26, -1.263290558684858e-27,  9.057411958725043e-29, -5.469507410497175e-30,  2.873945907665763e-31, -1.343277462312534e-32,
  5.674074942795015e-34, -2.192029668539486e-35,  7.817196099276115e-37, -2.590240790961868e-38,  5.926223565246950e-28, -2.012715627321537e-28,  3.699376881831253e-29,
 -4.724756940470262e-30,  4.661239864382756e-31, -3.765145510296205e-32,  2.583229530266981e-33, -1.543795406982451e-34,  8.185210424782363e-36, -3.904266070423698e-37,
  1.693851431218200e-38, -6.734865213361414e-40,  };
  int offset = -21;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 21;
    if (std::isnan(t)) {
      fill_n(rr+offset, 21, 0.5);
      fill_n(ww+offset, 21, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 21; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=21; ++j) {
        const int boxof = it*252+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
