# -*- coding: utf-8 -*-

# Balazar in the Rancid Skull Dungeon
# Copyright (C) 2001-2008 Jean-Baptiste LAMY -- jibalamy@free.fr
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Locale Prepare

Search all gettext'ed string in the source.
"""

import os, os.path, re, song

START = "gchar *s = N_(\""
END   = "\");"

ids = []

gettext_call = re.compile("""_\([ \t]*"(.*?)"[ \t]*\)""")

dir = os.path.dirname(song.__file__)

for source in filter(lambda filename: filename.endswith(".py"), os.listdir(dir)):
  f = open(os.path.join(dir, source), "r")
  for id in gettext_call.findall(f.read()):
    if not id in ids: ids.append(id)
    
current = open(os.path.join("balazar3", "locale", "fr", "LC_MESSAGES", "balazar3.po")).read()

current_ids = re.findall(r'msgid\s*"([^"]*)"', current)
try: current_ids.remove("")
except: pass

print "  New keys :"
for id in ids:
  if not id in current_ids:
    print "msgid  \"%s\"" % id
    print "msgstr \"%s\"" % id
    
print
print
print "  Deprecated keys :"
for id in current_ids:
  if not id in ids:
    print "msgid  \"%s\"" % id
    
