{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetShape: TShapeNode;
    procedure SetShape(const Value: TShapeNode);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdShape: TSFNode;
    { X3D field "shape". } { }
    public property FdShape: TSFNode read FFdShape;
    { X3D field "shape". } { }
    property Shape: TShapeNode read GetShape write SetShape;

{$endif read_interface}

{$ifdef read_implementation}

{ TCollidableShapeNode ----------------------------------------------- }

function TCollidableShapeNode.GetShape: TShapeNode;
begin
  if FdShape.Value is TShapeNode then
    Result := TShapeNode(FdShape.Value)
  else
    Result := nil;
end;

procedure TCollidableShapeNode.SetShape(const Value: TShapeNode);
begin
  FdShape.Send(Value);
end;

class function TCollidableShapeNode.ClassX3DType: String;
begin
  Result := 'CollidableShape';
end;

procedure TCollidableShapeNode.CreateNode;
begin
  inherited;

  FFdShape := TSFNode.Create(Self, False, 'shape', [TShapeNode]);
   FdShape.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdShape);
end;

{$endif read_implementation}
