# admob
This service enables the AdMob banner, interstitial and rewarded advertisements. Use [TAds](http://castle-engine.sourceforge.net/apidoc/html/CastleAds.TAds.html) class from the [CastleAds](http://castle-engine.sourceforge.net/apidoc/html/CastleAds.html) unit to show and control the ads from your Pascal code, with `AdNetwork` set to `anAdMob`.

## Requires
* Using this service requires using also <code>google_play_services</code>.

## App ID

From Ads SDK version 17 you need use App ID to properly initialize ads.
To do this in CGE you need to declare it in `CastleEngineManifest.xml` like this:

~~~~xml
<service name="admob">
    <parameter key="app_id" value="..."/>
</service>
~~~~

### Test App ID
If you just want test admob service you can use test app id: `ca-app-pub-3940256099942544~3347511713`

## Watched status

Statuses used by the admob service:

| TAdWatchStatus | AdMob errorCode equivalent | Description | 
| --- | --- | --- |
| wsWatched | - | The ad was displayed. |
| wsUnknownError | ERROR_CODE_INTERNAL_ERROR | Ad mob internal error or unknown error code. |
| wsNetworkNotAvailable | ERROR_CODE_NETWORK_ERROR | No internet connection. |
| wsNoAdsAvailable | ERROR_CODE_NO_FILL | No ads available. |
| wsUserAborted | - | Rewarded ad aborted by user. |
| wsAdNotReady | - | The ad is still loading (when we don't want to wait). |
| wsAdNetworkNotInitialized | - | Ad network not initialized or request for uninitialized ad type. |
| wsInvalidRequest | ERROR_CODE_INVALID_REQUEST | Invalid Request - bad Unit ID for example. |
| wsApplicationReinitialized | - | Java application was killed, but native code survived, while waiting for ad to finish. |

## Debug

If you have any problems with the admob service or want more logs, change the value of the `ServiceAdMob.debug` from `false` to `true`. 
Service source file is located in: 
`tools/build-tool/data/android/integrated-services/admob/app/src/main/java/net/sourceforge/castleengine/ServiceAdMob.java`

