/* colors.h
 *
 * By Byron C. Darrah,
 * 4/28/94, Thursday
 * Initialize some colors for drawings to use.
 * For now, this simply makes a color table for 27 colors -- a fixed set of
 * combinations of the three primary colors, R, G & B.  In the future, color
 * should be enhanced to allow more efficient use of the colormap.   Eg:
 * allocate only colors that are needed, and thereby be able allocate a range
 * of colors for objects to make use of shading.  Another enhancement
 * could be to take over the colormap of the display entirely, so that
 * a color table is not needed for lookup of which pixel value has which
 * desired color.
 */

#include <X11/Intrinsic.h>

#define NUMCOLORS 16
#define COLOR_ERROR 500

int init_colors(Display *disp, unsigned long *color_table, int color);
