#!/usr/bin/perl

# Simple script for benchmarking purposes. Invoke as:
#   http://whereever/test.cgi?bytes=XYZZY&usec=PLUGH
# Will spam XYZZY bytes as payload, and delay for PLUGH microsecs.
# The payload files are created in $tmpdir if they don't yet exist
# so that CPU looping is avoided.

use strict;
use Time::HiRes qw(usleep);
use CGI qw(:standard);

my $tmpdir = '/tmp';

# CGI Header
print ("Content-Type: text/plain\r\n\r\n");

# Delay for 'usec' microsecs.
my $usec = param('usec') or 0;
usleep($usec);

# Check that we have a file for the payload. If not, create it.
my $bytes = param('bytes');
my $file  = "$tmpdir/test.cgi.$bytes";
if (! -f $file) {
    open (my $of, ">$file") or die ("Cannot write $file: $!\n");
    for (my $i = 0; $i < $bytes; $i++) {
	print $of ('X');
    }
    close ($of);
}
# Send the file to the browser.
my $buf;
open (my $if, $file) or die ("Cannot read $file: $!\n");
while (sysread($if, $buf, 2048)) {
    print ($buf);
}

# All done. Return control to the web server.


