% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quote.R
\docType{class}
\name{SQL}
\alias{SQL}
\alias{SQL-class}
\title{SQL quoting}
\usage{
SQL(x, ..., names = NULL)
}
\arguments{
\item{x}{A character vector to label as being escaped SQL.}

\item{...}{Other arguments passed on to methods. Not otherwise used.}

\item{names}{Names for the returned object, must have the same length as \code{x}.}
}
\value{
An object of class \code{SQL}.
}
\description{
This set of classes and generics make it possible to flexibly deal with SQL
escaping needs. By default, any user supplied input to a query should be
escaped using either \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}} or \code{\link[=dbQuoteString]{dbQuoteString()}}
depending on whether it refers to a table or variable name, or is a literal
string.
These functions may return an object of the \code{SQL} class,
which tells DBI functions that a character string does not need to be escaped
anymore, to prevent double escaping.
The \code{SQL} class has associated the \code{SQL()} constructor function.
}
\section{Implementation notes}{


DBI provides default generics for SQL-92 compatible quoting. If the database
uses a different convention, you will need to provide your own methods.
Note that because of the way that S4 dispatch finds methods and because
SQL inherits from character, if you implement (e.g.) a method for
\code{dbQuoteString(MyConnection, character)}, you will also need to
implement \code{dbQuoteString(MyConnection, SQL)} - this should simply
return \code{x} unchanged.
}

\examples{
dbQuoteIdentifier(ANSI(), "SELECT")
dbQuoteString(ANSI(), "SELECT")

# SQL vectors are always passed through as is
var_name <- SQL("SELECT")
var_name

dbQuoteIdentifier(ANSI(), var_name)
dbQuoteString(ANSI(), var_name)

# This mechanism is used to prevent double escaping
dbQuoteString(ANSI(), dbQuoteString(ANSI(), "SELECT"))
}
