﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

namespace Microsoft.EntityFrameworkCore.Query;

#nullable disable

public class CompositeKeysQuerySqlServerTest : CompositeKeysQueryRelationalTestBase<CompositeKeysQuerySqlServerFixture>
{
    public CompositeKeysQuerySqlServerTest(
        CompositeKeysQuerySqlServerFixture fixture,
        ITestOutputHelper testOutputHelper)
        : base(fixture)
    {
        Fixture.TestSqlLoggerFactory.Clear();
        Fixture.TestSqlLoggerFactory.SetTestOutputHelper(testOutputHelper);
    }

    public override async Task Projecting_multiple_collections_same_level_top_level_ordering(bool async)
    {
        await base.Projecting_multiple_collections_same_level_top_level_ordering(async);

        AssertSql(
            """
SELECT [c].[Name], [c].[Id1], [c].[Id2], [c0].[Id1], [c0].[Id2], [c0].[Date], [c0].[Level1_Optional_Id1], [c0].[Level1_Optional_Id2], [c0].[Level1_Required_Id1], [c0].[Level1_Required_Id2], [c0].[Name], [c0].[OneToMany_Optional_Inverse2Id1], [c0].[OneToMany_Optional_Inverse2Id2], [c0].[OneToMany_Optional_Self_Inverse2Id1], [c0].[OneToMany_Optional_Self_Inverse2Id2], [c0].[OneToMany_Required_Inverse2Id1], [c0].[OneToMany_Required_Inverse2Id2], [c0].[OneToMany_Required_Self_Inverse2Id1], [c0].[OneToMany_Required_Self_Inverse2Id2], [c0].[OneToOne_Optional_PK_Inverse2Id1], [c0].[OneToOne_Optional_PK_Inverse2Id2], [c0].[OneToOne_Optional_Self2Id1], [c0].[OneToOne_Optional_Self2Id2], [c1].[Id1], [c1].[Id2], [c1].[Date], [c1].[Level1_Optional_Id1], [c1].[Level1_Optional_Id2], [c1].[Level1_Required_Id1], [c1].[Level1_Required_Id2], [c1].[Name], [c1].[OneToMany_Optional_Inverse2Id1], [c1].[OneToMany_Optional_Inverse2Id2], [c1].[OneToMany_Optional_Self_Inverse2Id1], [c1].[OneToMany_Optional_Self_Inverse2Id2], [c1].[OneToMany_Required_Inverse2Id1], [c1].[OneToMany_Required_Inverse2Id2], [c1].[OneToMany_Required_Self_Inverse2Id1], [c1].[OneToMany_Required_Self_Inverse2Id2], [c1].[OneToOne_Optional_PK_Inverse2Id1], [c1].[OneToOne_Optional_PK_Inverse2Id2], [c1].[OneToOne_Optional_Self2Id1], [c1].[OneToOne_Optional_Self2Id2]
FROM [CompositeOnes] AS [c]
LEFT JOIN [CompositeTwos] AS [c0] ON [c].[Id1] = [c0].[OneToMany_Optional_Inverse2Id1] AND [c].[Id2] = [c0].[OneToMany_Optional_Inverse2Id2]
LEFT JOIN [CompositeTwos] AS [c1] ON [c].[Id1] = [c1].[OneToMany_Required_Inverse2Id1] AND [c].[Id2] = [c1].[OneToMany_Required_Inverse2Id2]
ORDER BY [c].[Id2], [c].[Id1], [c0].[Id1], [c0].[Id2], [c1].[Id1]
""");
    }

    public override async Task Projecting_multiple_collections_same_level_top_level_ordering_using_entire_composite_key(bool async)
    {
        await base.Projecting_multiple_collections_same_level_top_level_ordering_using_entire_composite_key(async);

        AssertSql(
            """
SELECT [c].[Name], [c].[Id1], [c].[Id2], [c0].[Id1], [c0].[Id2], [c0].[Date], [c0].[Level1_Optional_Id1], [c0].[Level1_Optional_Id2], [c0].[Level1_Required_Id1], [c0].[Level1_Required_Id2], [c0].[Name], [c0].[OneToMany_Optional_Inverse2Id1], [c0].[OneToMany_Optional_Inverse2Id2], [c0].[OneToMany_Optional_Self_Inverse2Id1], [c0].[OneToMany_Optional_Self_Inverse2Id2], [c0].[OneToMany_Required_Inverse2Id1], [c0].[OneToMany_Required_Inverse2Id2], [c0].[OneToMany_Required_Self_Inverse2Id1], [c0].[OneToMany_Required_Self_Inverse2Id2], [c0].[OneToOne_Optional_PK_Inverse2Id1], [c0].[OneToOne_Optional_PK_Inverse2Id2], [c0].[OneToOne_Optional_Self2Id1], [c0].[OneToOne_Optional_Self2Id2], [c1].[Id1], [c1].[Id2], [c1].[Date], [c1].[Level1_Optional_Id1], [c1].[Level1_Optional_Id2], [c1].[Level1_Required_Id1], [c1].[Level1_Required_Id2], [c1].[Name], [c1].[OneToMany_Optional_Inverse2Id1], [c1].[OneToMany_Optional_Inverse2Id2], [c1].[OneToMany_Optional_Self_Inverse2Id1], [c1].[OneToMany_Optional_Self_Inverse2Id2], [c1].[OneToMany_Required_Inverse2Id1], [c1].[OneToMany_Required_Inverse2Id2], [c1].[OneToMany_Required_Self_Inverse2Id1], [c1].[OneToMany_Required_Self_Inverse2Id2], [c1].[OneToOne_Optional_PK_Inverse2Id1], [c1].[OneToOne_Optional_PK_Inverse2Id2], [c1].[OneToOne_Optional_Self2Id1], [c1].[OneToOne_Optional_Self2Id2]
FROM [CompositeOnes] AS [c]
LEFT JOIN [CompositeTwos] AS [c0] ON [c].[Id1] = [c0].[OneToMany_Optional_Inverse2Id1] AND [c].[Id2] = [c0].[OneToMany_Optional_Inverse2Id2]
LEFT JOIN [CompositeTwos] AS [c1] ON [c].[Id1] = [c1].[OneToMany_Required_Inverse2Id1] AND [c].[Id2] = [c1].[OneToMany_Required_Inverse2Id2]
ORDER BY [c].[Id2], [c].[Id1] DESC, [c0].[Id1], [c0].[Id2], [c1].[Id1]
""");
    }

    public override async Task Projecting_multiple_collections_with_ordering_same_level(bool async)
    {
        await base.Projecting_multiple_collections_with_ordering_same_level(async);

        AssertSql(
            """
SELECT [c].[Name], [c].[Id1], [c].[Id2], [c0].[Id1], [c0].[Id2], [c0].[Date], [c0].[Level1_Optional_Id1], [c0].[Level1_Optional_Id2], [c0].[Level1_Required_Id1], [c0].[Level1_Required_Id2], [c0].[Name], [c0].[OneToMany_Optional_Inverse2Id1], [c0].[OneToMany_Optional_Inverse2Id2], [c0].[OneToMany_Optional_Self_Inverse2Id1], [c0].[OneToMany_Optional_Self_Inverse2Id2], [c0].[OneToMany_Required_Inverse2Id1], [c0].[OneToMany_Required_Inverse2Id2], [c0].[OneToMany_Required_Self_Inverse2Id1], [c0].[OneToMany_Required_Self_Inverse2Id2], [c0].[OneToOne_Optional_PK_Inverse2Id1], [c0].[OneToOne_Optional_PK_Inverse2Id2], [c0].[OneToOne_Optional_Self2Id1], [c0].[OneToOne_Optional_Self2Id2], [c1].[Id1], [c1].[Id2], [c1].[Date], [c1].[Level1_Optional_Id1], [c1].[Level1_Optional_Id2], [c1].[Level1_Required_Id1], [c1].[Level1_Required_Id2], [c1].[Name], [c1].[OneToMany_Optional_Inverse2Id1], [c1].[OneToMany_Optional_Inverse2Id2], [c1].[OneToMany_Optional_Self_Inverse2Id1], [c1].[OneToMany_Optional_Self_Inverse2Id2], [c1].[OneToMany_Required_Inverse2Id1], [c1].[OneToMany_Required_Inverse2Id2], [c1].[OneToMany_Required_Self_Inverse2Id1], [c1].[OneToMany_Required_Self_Inverse2Id2], [c1].[OneToOne_Optional_PK_Inverse2Id1], [c1].[OneToOne_Optional_PK_Inverse2Id2], [c1].[OneToOne_Optional_Self2Id1], [c1].[OneToOne_Optional_Self2Id2]
FROM [CompositeOnes] AS [c]
LEFT JOIN [CompositeTwos] AS [c0] ON [c].[Id1] = [c0].[OneToMany_Optional_Inverse2Id1] AND [c].[Id2] = [c0].[OneToMany_Optional_Inverse2Id2]
LEFT JOIN [CompositeTwos] AS [c1] ON [c].[Id1] = [c1].[OneToMany_Required_Inverse2Id1] AND [c].[Id2] = [c1].[OneToMany_Required_Inverse2Id2]
ORDER BY [c].[Id1], [c].[Id2], [c0].[Id2], [c0].[Id1], [c1].[Name] DESC, [c1].[Id1]
""");
    }

    public override async Task Projecting_multiple_collections_with_ordering_same_level_top_level_ordering(bool async)
    {
        await base.Projecting_multiple_collections_with_ordering_same_level_top_level_ordering(async);

        AssertSql(
            """
SELECT [c].[Name], [c].[Id1], [c].[Id2], [c0].[Id1], [c0].[Id2], [c0].[Date], [c0].[Level1_Optional_Id1], [c0].[Level1_Optional_Id2], [c0].[Level1_Required_Id1], [c0].[Level1_Required_Id2], [c0].[Name], [c0].[OneToMany_Optional_Inverse2Id1], [c0].[OneToMany_Optional_Inverse2Id2], [c0].[OneToMany_Optional_Self_Inverse2Id1], [c0].[OneToMany_Optional_Self_Inverse2Id2], [c0].[OneToMany_Required_Inverse2Id1], [c0].[OneToMany_Required_Inverse2Id2], [c0].[OneToMany_Required_Self_Inverse2Id1], [c0].[OneToMany_Required_Self_Inverse2Id2], [c0].[OneToOne_Optional_PK_Inverse2Id1], [c0].[OneToOne_Optional_PK_Inverse2Id2], [c0].[OneToOne_Optional_Self2Id1], [c0].[OneToOne_Optional_Self2Id2], [c1].[Id1], [c1].[Id2], [c1].[Date], [c1].[Level1_Optional_Id1], [c1].[Level1_Optional_Id2], [c1].[Level1_Required_Id1], [c1].[Level1_Required_Id2], [c1].[Name], [c1].[OneToMany_Optional_Inverse2Id1], [c1].[OneToMany_Optional_Inverse2Id2], [c1].[OneToMany_Optional_Self_Inverse2Id1], [c1].[OneToMany_Optional_Self_Inverse2Id2], [c1].[OneToMany_Required_Inverse2Id1], [c1].[OneToMany_Required_Inverse2Id2], [c1].[OneToMany_Required_Self_Inverse2Id1], [c1].[OneToMany_Required_Self_Inverse2Id2], [c1].[OneToOne_Optional_PK_Inverse2Id1], [c1].[OneToOne_Optional_PK_Inverse2Id2], [c1].[OneToOne_Optional_Self2Id1], [c1].[OneToOne_Optional_Self2Id2]
FROM [CompositeOnes] AS [c]
LEFT JOIN [CompositeTwos] AS [c0] ON [c].[Id1] = [c0].[OneToMany_Optional_Inverse2Id1] AND [c].[Id2] = [c0].[OneToMany_Optional_Inverse2Id2]
LEFT JOIN [CompositeTwos] AS [c1] ON [c].[Id1] = [c1].[OneToMany_Required_Inverse2Id1] AND [c].[Id2] = [c1].[OneToMany_Required_Inverse2Id2]
ORDER BY [c].[Id2], [c].[Id1], [c0].[Id2], [c0].[Id1], [c1].[Name] DESC, [c1].[Id1]
""");
    }

    public override async Task Projecting_collections_multi_level(bool async)
    {
        await base.Projecting_collections_multi_level(async);

        AssertSql(
            """
SELECT [c].[Name], [c].[Id1], [c].[Id2], [s].[Name], [s].[Id1], [s].[Id2], [s].[Id10], [s].[Id20], [s].[Level2_Optional_Id1], [s].[Level2_Optional_Id2], [s].[Level2_Required_Id1], [s].[Level2_Required_Id2], [s].[Name0], [s].[OneToMany_Optional_Inverse3Id1], [s].[OneToMany_Optional_Inverse3Id2], [s].[OneToMany_Optional_Self_Inverse3Id1], [s].[OneToMany_Optional_Self_Inverse3Id2], [s].[OneToMany_Required_Inverse3Id1], [s].[OneToMany_Required_Inverse3Id2], [s].[OneToMany_Required_Self_Inverse3Id1], [s].[OneToMany_Required_Self_Inverse3Id2], [s].[OneToOne_Optional_PK_Inverse3Id1], [s].[OneToOne_Optional_PK_Inverse3Id2], [s].[OneToOne_Optional_Self3Id1], [s].[OneToOne_Optional_Self3Id2]
FROM [CompositeOnes] AS [c]
LEFT JOIN (
    SELECT [c0].[Name], [c0].[Id1], [c0].[Id2], [c1].[Id1] AS [Id10], [c1].[Id2] AS [Id20], [c1].[Level2_Optional_Id1], [c1].[Level2_Optional_Id2], [c1].[Level2_Required_Id1], [c1].[Level2_Required_Id2], [c1].[Name] AS [Name0], [c1].[OneToMany_Optional_Inverse3Id1], [c1].[OneToMany_Optional_Inverse3Id2], [c1].[OneToMany_Optional_Self_Inverse3Id1], [c1].[OneToMany_Optional_Self_Inverse3Id2], [c1].[OneToMany_Required_Inverse3Id1], [c1].[OneToMany_Required_Inverse3Id2], [c1].[OneToMany_Required_Self_Inverse3Id1], [c1].[OneToMany_Required_Self_Inverse3Id2], [c1].[OneToOne_Optional_PK_Inverse3Id1], [c1].[OneToOne_Optional_PK_Inverse3Id2], [c1].[OneToOne_Optional_Self3Id1], [c1].[OneToOne_Optional_Self3Id2], [c0].[OneToMany_Optional_Inverse2Id1], [c0].[OneToMany_Optional_Inverse2Id2]
    FROM [CompositeTwos] AS [c0]
    LEFT JOIN [CompositeThrees] AS [c1] ON [c0].[Id1] = [c1].[OneToMany_Required_Inverse3Id1] AND [c0].[Id2] = [c1].[OneToMany_Required_Inverse3Id2]
) AS [s] ON [c].[Id1] = [s].[OneToMany_Optional_Inverse2Id1] AND [c].[Id2] = [s].[OneToMany_Optional_Inverse2Id2]
ORDER BY [c].[Id2], [c].[Id1], [s].[Id2], [s].[Id1], [s].[Id20] DESC
""");
    }

    public override async Task Projecting_multiple_collections_on_multiple_levels_no_explicit_ordering(bool async)
    {
        await base.Projecting_multiple_collections_on_multiple_levels_no_explicit_ordering(async);

        AssertSql(
            """
SELECT [c].[Name], [c].[Id1], [c].[Id2], [s1].[Name], [s1].[Id1], [s1].[Id2], [s1].[Name0], [s1].[Id10], [s1].[Id20], [s1].[Id100], [s1].[Id200], [s1].[Level3_Optional_Id1], [s1].[Level3_Optional_Id2], [s1].[Level3_Required_Id1], [s1].[Level3_Required_Id2], [s1].[Name00], [s1].[OneToMany_Optional_Inverse4Id1], [s1].[OneToMany_Optional_Inverse4Id2], [s1].[OneToMany_Optional_Self_Inverse4Id1], [s1].[OneToMany_Optional_Self_Inverse4Id2], [s1].[OneToMany_Required_Inverse4Id1], [s1].[OneToMany_Required_Inverse4Id2], [s1].[OneToMany_Required_Self_Inverse4Id1], [s1].[OneToMany_Required_Self_Inverse4Id2], [s1].[OneToOne_Optional_PK_Inverse4Id1], [s1].[OneToOne_Optional_PK_Inverse4Id2], [s1].[OneToOne_Optional_Self4Id1], [s1].[OneToOne_Optional_Self4Id2], [s1].[Id11], [s1].[Id21], [s1].[Level3_Optional_Id10], [s1].[Level3_Optional_Id20], [s1].[Level3_Required_Id10], [s1].[Level3_Required_Id20], [s1].[Name1], [s1].[OneToMany_Optional_Inverse4Id10], [s1].[OneToMany_Optional_Inverse4Id20], [s1].[OneToMany_Optional_Self_Inverse4Id10], [s1].[OneToMany_Optional_Self_Inverse4Id20], [s1].[OneToMany_Required_Inverse4Id10], [s1].[OneToMany_Required_Inverse4Id20], [s1].[OneToMany_Required_Self_Inverse4Id10], [s1].[OneToMany_Required_Self_Inverse4Id20], [s1].[OneToOne_Optional_PK_Inverse4Id10], [s1].[OneToOne_Optional_PK_Inverse4Id20], [s1].[OneToOne_Optional_Self4Id10], [s1].[OneToOne_Optional_Self4Id20], [s1].[Name2], [s1].[Id12], [s1].[Id22], [s1].[Id101], [s1].[Id201], [s1].[Level3_Optional_Id11], [s1].[Level3_Optional_Id21], [s1].[Level3_Required_Id11], [s1].[Level3_Required_Id21], [s1].[Name01], [s1].[OneToMany_Optional_Inverse4Id11], [s1].[OneToMany_Optional_Inverse4Id21], [s1].[OneToMany_Optional_Self_Inverse4Id11], [s1].[OneToMany_Optional_Self_Inverse4Id21], [s1].[OneToMany_Required_Inverse4Id11], [s1].[OneToMany_Required_Inverse4Id21], [s1].[OneToMany_Required_Self_Inverse4Id11], [s1].[OneToMany_Required_Self_Inverse4Id21], [s1].[OneToOne_Optional_PK_Inverse4Id11], [s1].[OneToOne_Optional_PK_Inverse4Id21], [s1].[OneToOne_Optional_Self4Id11], [s1].[OneToOne_Optional_Self4Id21], [s1].[Id110], [s1].[Id210], [s1].[Level3_Optional_Id100], [s1].[Level3_Optional_Id200], [s1].[Level3_Required_Id100], [s1].[Level3_Required_Id200], [s1].[Name10], [s1].[OneToMany_Optional_Inverse4Id100], [s1].[OneToMany_Optional_Inverse4Id200], [s1].[OneToMany_Optional_Self_Inverse4Id100], [s1].[OneToMany_Optional_Self_Inverse4Id200], [s1].[OneToMany_Required_Inverse4Id100], [s1].[OneToMany_Required_Inverse4Id200], [s1].[OneToMany_Required_Self_Inverse4Id100], [s1].[OneToMany_Required_Self_Inverse4Id200], [s1].[OneToOne_Optional_PK_Inverse4Id100], [s1].[OneToOne_Optional_PK_Inverse4Id200], [s1].[OneToOne_Optional_Self4Id100], [s1].[OneToOne_Optional_Self4Id200], [s4].[Name], [s4].[Id1], [s4].[Id2], [s4].[Name0], [s4].[Id10], [s4].[Id20], [s4].[Id100], [s4].[Id200], [s4].[Level3_Optional_Id1], [s4].[Level3_Optional_Id2], [s4].[Level3_Required_Id1], [s4].[Level3_Required_Id2], [s4].[Name00], [s4].[OneToMany_Optional_Inverse4Id1], [s4].[OneToMany_Optional_Inverse4Id2], [s4].[OneToMany_Optional_Self_Inverse4Id1], [s4].[OneToMany_Optional_Self_Inverse4Id2], [s4].[OneToMany_Required_Inverse4Id1], [s4].[OneToMany_Required_Inverse4Id2], [s4].[OneToMany_Required_Self_Inverse4Id1], [s4].[OneToMany_Required_Self_Inverse4Id2], [s4].[OneToOne_Optional_PK_Inverse4Id1], [s4].[OneToOne_Optional_PK_Inverse4Id2], [s4].[OneToOne_Optional_Self4Id1], [s4].[OneToOne_Optional_Self4Id2], [s4].[Id11], [s4].[Id21], [s4].[Level3_Optional_Id10], [s4].[Level3_Optional_Id20], [s4].[Level3_Required_Id10], [s4].[Level3_Required_Id20], [s4].[Name1], [s4].[OneToMany_Optional_Inverse4Id10], [s4].[OneToMany_Optional_Inverse4Id20], [s4].[OneToMany_Optional_Self_Inverse4Id10], [s4].[OneToMany_Optional_Self_Inverse4Id20], [s4].[OneToMany_Required_Inverse4Id10], [s4].[OneToMany_Required_Inverse4Id20], [s4].[OneToMany_Required_Self_Inverse4Id10], [s4].[OneToMany_Required_Self_Inverse4Id20], [s4].[OneToOne_Optional_PK_Inverse4Id10], [s4].[OneToOne_Optional_PK_Inverse4Id20], [s4].[OneToOne_Optional_Self4Id10], [s4].[OneToOne_Optional_Self4Id20], [s4].[Name2], [s4].[Id12], [s4].[Id22], [s4].[Id101], [s4].[Id201], [s4].[Level3_Optional_Id11], [s4].[Level3_Optional_Id21], [s4].[Level3_Required_Id11], [s4].[Level3_Required_Id21], [s4].[Name01], [s4].[OneToMany_Optional_Inverse4Id11], [s4].[OneToMany_Optional_Inverse4Id21], [s4].[OneToMany_Optional_Self_Inverse4Id11], [s4].[OneToMany_Optional_Self_Inverse4Id21], [s4].[OneToMany_Required_Inverse4Id11], [s4].[OneToMany_Required_Inverse4Id21], [s4].[OneToMany_Required_Self_Inverse4Id11], [s4].[OneToMany_Required_Self_Inverse4Id21], [s4].[OneToOne_Optional_PK_Inverse4Id11], [s4].[OneToOne_Optional_PK_Inverse4Id21], [s4].[OneToOne_Optional_Self4Id11], [s4].[OneToOne_Optional_Self4Id21], [s4].[Id110], [s4].[Id210], [s4].[Level3_Optional_Id100], [s4].[Level3_Optional_Id200], [s4].[Level3_Required_Id100], [s4].[Level3_Required_Id200], [s4].[Name10], [s4].[OneToMany_Optional_Inverse4Id100], [s4].[OneToMany_Optional_Inverse4Id200], [s4].[OneToMany_Optional_Self_Inverse4Id100], [s4].[OneToMany_Optional_Self_Inverse4Id200], [s4].[OneToMany_Required_Inverse4Id100], [s4].[OneToMany_Required_Inverse4Id200], [s4].[OneToMany_Required_Self_Inverse4Id100], [s4].[OneToMany_Required_Self_Inverse4Id200], [s4].[OneToOne_Optional_PK_Inverse4Id100], [s4].[OneToOne_Optional_PK_Inverse4Id200], [s4].[OneToOne_Optional_Self4Id100], [s4].[OneToOne_Optional_Self4Id200]
FROM [CompositeOnes] AS [c]
LEFT JOIN (
    SELECT [c0].[Name], [c0].[Id1], [c0].[Id2], [s].[Name] AS [Name0], [s].[Id1] AS [Id10], [s].[Id2] AS [Id20], [s].[Id10] AS [Id100], [s].[Id20] AS [Id200], [s].[Level3_Optional_Id1], [s].[Level3_Optional_Id2], [s].[Level3_Required_Id1], [s].[Level3_Required_Id2], [s].[Name0] AS [Name00], [s].[OneToMany_Optional_Inverse4Id1], [s].[OneToMany_Optional_Inverse4Id2], [s].[OneToMany_Optional_Self_Inverse4Id1], [s].[OneToMany_Optional_Self_Inverse4Id2], [s].[OneToMany_Required_Inverse4Id1], [s].[OneToMany_Required_Inverse4Id2], [s].[OneToMany_Required_Self_Inverse4Id1], [s].[OneToMany_Required_Self_Inverse4Id2], [s].[OneToOne_Optional_PK_Inverse4Id1], [s].[OneToOne_Optional_PK_Inverse4Id2], [s].[OneToOne_Optional_Self4Id1], [s].[OneToOne_Optional_Self4Id2], [s].[Id11], [s].[Id21], [s].[Level3_Optional_Id10], [s].[Level3_Optional_Id20], [s].[Level3_Required_Id10], [s].[Level3_Required_Id20], [s].[Name1], [s].[OneToMany_Optional_Inverse4Id10], [s].[OneToMany_Optional_Inverse4Id20], [s].[OneToMany_Optional_Self_Inverse4Id10], [s].[OneToMany_Optional_Self_Inverse4Id20], [s].[OneToMany_Required_Inverse4Id10], [s].[OneToMany_Required_Inverse4Id20], [s].[OneToMany_Required_Self_Inverse4Id10], [s].[OneToMany_Required_Self_Inverse4Id20], [s].[OneToOne_Optional_PK_Inverse4Id10], [s].[OneToOne_Optional_PK_Inverse4Id20], [s].[OneToOne_Optional_Self4Id10], [s].[OneToOne_Optional_Self4Id20], [s0].[Name] AS [Name2], [s0].[Id1] AS [Id12], [s0].[Id2] AS [Id22], [s0].[Id10] AS [Id101], [s0].[Id20] AS [Id201], [s0].[Level3_Optional_Id1] AS [Level3_Optional_Id11], [s0].[Level3_Optional_Id2] AS [Level3_Optional_Id21], [s0].[Level3_Required_Id1] AS [Level3_Required_Id11], [s0].[Level3_Required_Id2] AS [Level3_Required_Id21], [s0].[Name0] AS [Name01], [s0].[OneToMany_Optional_Inverse4Id1] AS [OneToMany_Optional_Inverse4Id11], [s0].[OneToMany_Optional_Inverse4Id2] AS [OneToMany_Optional_Inverse4Id21], [s0].[OneToMany_Optional_Self_Inverse4Id1] AS [OneToMany_Optional_Self_Inverse4Id11], [s0].[OneToMany_Optional_Self_Inverse4Id2] AS [OneToMany_Optional_Self_Inverse4Id21], [s0].[OneToMany_Required_Inverse4Id1] AS [OneToMany_Required_Inverse4Id11], [s0].[OneToMany_Required_Inverse4Id2] AS [OneToMany_Required_Inverse4Id21], [s0].[OneToMany_Required_Self_Inverse4Id1] AS [OneToMany_Required_Self_Inverse4Id11], [s0].[OneToMany_Required_Self_Inverse4Id2] AS [OneToMany_Required_Self_Inverse4Id21], [s0].[OneToOne_Optional_PK_Inverse4Id1] AS [OneToOne_Optional_PK_Inverse4Id11], [s0].[OneToOne_Optional_PK_Inverse4Id2] AS [OneToOne_Optional_PK_Inverse4Id21], [s0].[OneToOne_Optional_Self4Id1] AS [OneToOne_Optional_Self4Id11], [s0].[OneToOne_Optional_Self4Id2] AS [OneToOne_Optional_Self4Id21], [s0].[Id11] AS [Id110], [s0].[Id21] AS [Id210], [s0].[Level3_Optional_Id10] AS [Level3_Optional_Id100], [s0].[Level3_Optional_Id20] AS [Level3_Optional_Id200], [s0].[Level3_Required_Id10] AS [Level3_Required_Id100], [s0].[Level3_Required_Id20] AS [Level3_Required_Id200], [s0].[Name1] AS [Name10], [s0].[OneToMany_Optional_Inverse4Id10] AS [OneToMany_Optional_Inverse4Id100], [s0].[OneToMany_Optional_Inverse4Id20] AS [OneToMany_Optional_Inverse4Id200], [s0].[OneToMany_Optional_Self_Inverse4Id10] AS [OneToMany_Optional_Self_Inverse4Id100], [s0].[OneToMany_Optional_Self_Inverse4Id20] AS [OneToMany_Optional_Self_Inverse4Id200], [s0].[OneToMany_Required_Inverse4Id10] AS [OneToMany_Required_Inverse4Id100], [s0].[OneToMany_Required_Inverse4Id20] AS [OneToMany_Required_Inverse4Id200], [s0].[OneToMany_Required_Self_Inverse4Id10] AS [OneToMany_Required_Self_Inverse4Id100], [s0].[OneToMany_Required_Self_Inverse4Id20] AS [OneToMany_Required_Self_Inverse4Id200], [s0].[OneToOne_Optional_PK_Inverse4Id10] AS [OneToOne_Optional_PK_Inverse4Id100], [s0].[OneToOne_Optional_PK_Inverse4Id20] AS [OneToOne_Optional_PK_Inverse4Id200], [s0].[OneToOne_Optional_Self4Id10] AS [OneToOne_Optional_Self4Id100], [s0].[OneToOne_Optional_Self4Id20] AS [OneToOne_Optional_Self4Id200], [c0].[OneToMany_Optional_Inverse2Id1], [c0].[OneToMany_Optional_Inverse2Id2]
    FROM [CompositeTwos] AS [c0]
    LEFT JOIN (
        SELECT [c1].[Name], [c1].[Id1], [c1].[Id2], [c2].[Id1] AS [Id10], [c2].[Id2] AS [Id20], [c2].[Level3_Optional_Id1], [c2].[Level3_Optional_Id2], [c2].[Level3_Required_Id1], [c2].[Level3_Required_Id2], [c2].[Name] AS [Name0], [c2].[OneToMany_Optional_Inverse4Id1], [c2].[OneToMany_Optional_Inverse4Id2], [c2].[OneToMany_Optional_Self_Inverse4Id1], [c2].[OneToMany_Optional_Self_Inverse4Id2], [c2].[OneToMany_Required_Inverse4Id1], [c2].[OneToMany_Required_Inverse4Id2], [c2].[OneToMany_Required_Self_Inverse4Id1], [c2].[OneToMany_Required_Self_Inverse4Id2], [c2].[OneToOne_Optional_PK_Inverse4Id1], [c2].[OneToOne_Optional_PK_Inverse4Id2], [c2].[OneToOne_Optional_Self4Id1], [c2].[OneToOne_Optional_Self4Id2], [c3].[Id1] AS [Id11], [c3].[Id2] AS [Id21], [c3].[Level3_Optional_Id1] AS [Level3_Optional_Id10], [c3].[Level3_Optional_Id2] AS [Level3_Optional_Id20], [c3].[Level3_Required_Id1] AS [Level3_Required_Id10], [c3].[Level3_Required_Id2] AS [Level3_Required_Id20], [c3].[Name] AS [Name1], [c3].[OneToMany_Optional_Inverse4Id1] AS [OneToMany_Optional_Inverse4Id10], [c3].[OneToMany_Optional_Inverse4Id2] AS [OneToMany_Optional_Inverse4Id20], [c3].[OneToMany_Optional_Self_Inverse4Id1] AS [OneToMany_Optional_Self_Inverse4Id10], [c3].[OneToMany_Optional_Self_Inverse4Id2] AS [OneToMany_Optional_Self_Inverse4Id20], [c3].[OneToMany_Required_Inverse4Id1] AS [OneToMany_Required_Inverse4Id10], [c3].[OneToMany_Required_Inverse4Id2] AS [OneToMany_Required_Inverse4Id20], [c3].[OneToMany_Required_Self_Inverse4Id1] AS [OneToMany_Required_Self_Inverse4Id10], [c3].[OneToMany_Required_Self_Inverse4Id2] AS [OneToMany_Required_Self_Inverse4Id20], [c3].[OneToOne_Optional_PK_Inverse4Id1] AS [OneToOne_Optional_PK_Inverse4Id10], [c3].[OneToOne_Optional_PK_Inverse4Id2] AS [OneToOne_Optional_PK_Inverse4Id20], [c3].[OneToOne_Optional_Self4Id1] AS [OneToOne_Optional_Self4Id10], [c3].[OneToOne_Optional_Self4Id2] AS [OneToOne_Optional_Self4Id20], [c1].[OneToMany_Required_Inverse3Id1], [c1].[OneToMany_Required_Inverse3Id2]
        FROM [CompositeThrees] AS [c1]
        LEFT JOIN [CompositeFours] AS [c2] ON [c1].[Id1] = [c2].[OneToMany_Optional_Inverse4Id1] AND [c1].[Id2] = [c2].[OneToMany_Optional_Inverse4Id2]
        LEFT JOIN [CompositeFours] AS [c3] ON [c1].[Id1] = [c3].[OneToMany_Required_Inverse4Id1] AND [c1].[Id2] = [c3].[OneToMany_Required_Inverse4Id2]
    ) AS [s] ON [c0].[Id1] = [s].[OneToMany_Required_Inverse3Id1] AND [c0].[Id2] = [s].[OneToMany_Required_Inverse3Id2]
    LEFT JOIN (
        SELECT [c4].[Name], [c4].[Id1], [c4].[Id2], [c5].[Id1] AS [Id10], [c5].[Id2] AS [Id20], [c5].[Level3_Optional_Id1], [c5].[Level3_Optional_Id2], [c5].[Level3_Required_Id1], [c5].[Level3_Required_Id2], [c5].[Name] AS [Name0], [c5].[OneToMany_Optional_Inverse4Id1], [c5].[OneToMany_Optional_Inverse4Id2], [c5].[OneToMany_Optional_Self_Inverse4Id1], [c5].[OneToMany_Optional_Self_Inverse4Id2], [c5].[OneToMany_Required_Inverse4Id1], [c5].[OneToMany_Required_Inverse4Id2], [c5].[OneToMany_Required_Self_Inverse4Id1], [c5].[OneToMany_Required_Self_Inverse4Id2], [c5].[OneToOne_Optional_PK_Inverse4Id1], [c5].[OneToOne_Optional_PK_Inverse4Id2], [c5].[OneToOne_Optional_Self4Id1], [c5].[OneToOne_Optional_Self4Id2], [c6].[Id1] AS [Id11], [c6].[Id2] AS [Id21], [c6].[Level3_Optional_Id1] AS [Level3_Optional_Id10], [c6].[Level3_Optional_Id2] AS [Level3_Optional_Id20], [c6].[Level3_Required_Id1] AS [Level3_Required_Id10], [c6].[Level3_Required_Id2] AS [Level3_Required_Id20], [c6].[Name] AS [Name1], [c6].[OneToMany_Optional_Inverse4Id1] AS [OneToMany_Optional_Inverse4Id10], [c6].[OneToMany_Optional_Inverse4Id2] AS [OneToMany_Optional_Inverse4Id20], [c6].[OneToMany_Optional_Self_Inverse4Id1] AS [OneToMany_Optional_Self_Inverse4Id10], [c6].[OneToMany_Optional_Self_Inverse4Id2] AS [OneToMany_Optional_Self_Inverse4Id20], [c6].[OneToMany_Required_Inverse4Id1] AS [OneToMany_Required_Inverse4Id10], [c6].[OneToMany_Required_Inverse4Id2] AS [OneToMany_Required_Inverse4Id20], [c6].[OneToMany_Required_Self_Inverse4Id1] AS [OneToMany_Required_Self_Inverse4Id10], [c6].[OneToMany_Required_Self_Inverse4Id2] AS [OneToMany_Required_Self_Inverse4Id20], [c6].[OneToOne_Optional_PK_Inverse4Id1] AS [OneToOne_Optional_PK_Inverse4Id10], [c6].[OneToOne_Optional_PK_Inverse4Id2] AS [OneToOne_Optional_PK_Inverse4Id20], [c6].[OneToOne_Optional_Self4Id1] AS [OneToOne_Optional_Self4Id10], [c6].[OneToOne_Optional_Self4Id2] AS [OneToOne_Optional_Self4Id20], [c4].[OneToMany_Optional_Inverse3Id1], [c4].[OneToMany_Optional_Inverse3Id2]
        FROM [CompositeThrees] AS [c4]
        LEFT JOIN [CompositeFours] AS [c5] ON [c4].[Id1] = [c5].[OneToMany_Required_Inverse4Id1] AND [c4].[Id2] = [c5].[OneToMany_Required_Inverse4Id2]
        LEFT JOIN [CompositeFours] AS [c6] ON [c4].[Id1] = [c6].[OneToMany_Optional_Inverse4Id1] AND [c4].[Id2] = [c6].[OneToMany_Optional_Inverse4Id2]
    ) AS [s0] ON [c0].[Id1] = [s0].[OneToMany_Optional_Inverse3Id1] AND [c0].[Id2] = [s0].[OneToMany_Optional_Inverse3Id2]
) AS [s1] ON [c].[Id1] = [s1].[OneToMany_Optional_Inverse2Id1] AND [c].[Id2] = [s1].[OneToMany_Optional_Inverse2Id2]
LEFT JOIN (
    SELECT [c7].[Name], [c7].[Id1], [c7].[Id2], [s2].[Name] AS [Name0], [s2].[Id1] AS [Id10], [s2].[Id2] AS [Id20], [s2].[Id10] AS [Id100], [s2].[Id20] AS [Id200], [s2].[Level3_Optional_Id1], [s2].[Level3_Optional_Id2], [s2].[Level3_Required_Id1], [s2].[Level3_Required_Id2], [s2].[Name0] AS [Name00], [s2].[OneToMany_Optional_Inverse4Id1], [s2].[OneToMany_Optional_Inverse4Id2], [s2].[OneToMany_Optional_Self_Inverse4Id1], [s2].[OneToMany_Optional_Self_Inverse4Id2], [s2].[OneToMany_Required_Inverse4Id1], [s2].[OneToMany_Required_Inverse4Id2], [s2].[OneToMany_Required_Self_Inverse4Id1], [s2].[OneToMany_Required_Self_Inverse4Id2], [s2].[OneToOne_Optional_PK_Inverse4Id1], [s2].[OneToOne_Optional_PK_Inverse4Id2], [s2].[OneToOne_Optional_Self4Id1], [s2].[OneToOne_Optional_Self4Id2], [s2].[Id11], [s2].[Id21], [s2].[Level3_Optional_Id10], [s2].[Level3_Optional_Id20], [s2].[Level3_Required_Id10], [s2].[Level3_Required_Id20], [s2].[Name1], [s2].[OneToMany_Optional_Inverse4Id10], [s2].[OneToMany_Optional_Inverse4Id20], [s2].[OneToMany_Optional_Self_Inverse4Id10], [s2].[OneToMany_Optional_Self_Inverse4Id20], [s2].[OneToMany_Required_Inverse4Id10], [s2].[OneToMany_Required_Inverse4Id20], [s2].[OneToMany_Required_Self_Inverse4Id10], [s2].[OneToMany_Required_Self_Inverse4Id20], [s2].[OneToOne_Optional_PK_Inverse4Id10], [s2].[OneToOne_Optional_PK_Inverse4Id20], [s2].[OneToOne_Optional_Self4Id10], [s2].[OneToOne_Optional_Self4Id20], [s3].[Name] AS [Name2], [s3].[Id1] AS [Id12], [s3].[Id2] AS [Id22], [s3].[Id10] AS [Id101], [s3].[Id20] AS [Id201], [s3].[Level3_Optional_Id1] AS [Level3_Optional_Id11], [s3].[Level3_Optional_Id2] AS [Level3_Optional_Id21], [s3].[Level3_Required_Id1] AS [Level3_Required_Id11], [s3].[Level3_Required_Id2] AS [Level3_Required_Id21], [s3].[Name0] AS [Name01], [s3].[OneToMany_Optional_Inverse4Id1] AS [OneToMany_Optional_Inverse4Id11], [s3].[OneToMany_Optional_Inverse4Id2] AS [OneToMany_Optional_Inverse4Id21], [s3].[OneToMany_Optional_Self_Inverse4Id1] AS [OneToMany_Optional_Self_Inverse4Id11], [s3].[OneToMany_Optional_Self_Inverse4Id2] AS [OneToMany_Optional_Self_Inverse4Id21], [s3].[OneToMany_Required_Inverse4Id1] AS [OneToMany_Required_Inverse4Id11], [s3].[OneToMany_Required_Inverse4Id2] AS [OneToMany_Required_Inverse4Id21], [s3].[OneToMany_Required_Self_Inverse4Id1] AS [OneToMany_Required_Self_Inverse4Id11], [s3].[OneToMany_Required_Self_Inverse4Id2] AS [OneToMany_Required_Self_Inverse4Id21], [s3].[OneToOne_Optional_PK_Inverse4Id1] AS [OneToOne_Optional_PK_Inverse4Id11], [s3].[OneToOne_Optional_PK_Inverse4Id2] AS [OneToOne_Optional_PK_Inverse4Id21], [s3].[OneToOne_Optional_Self4Id1] AS [OneToOne_Optional_Self4Id11], [s3].[OneToOne_Optional_Self4Id2] AS [OneToOne_Optional_Self4Id21], [s3].[Id11] AS [Id110], [s3].[Id21] AS [Id210], [s3].[Level3_Optional_Id10] AS [Level3_Optional_Id100], [s3].[Level3_Optional_Id20] AS [Level3_Optional_Id200], [s3].[Level3_Required_Id10] AS [Level3_Required_Id100], [s3].[Level3_Required_Id20] AS [Level3_Required_Id200], [s3].[Name1] AS [Name10], [s3].[OneToMany_Optional_Inverse4Id10] AS [OneToMany_Optional_Inverse4Id100], [s3].[OneToMany_Optional_Inverse4Id20] AS [OneToMany_Optional_Inverse4Id200], [s3].[OneToMany_Optional_Self_Inverse4Id10] AS [OneToMany_Optional_Self_Inverse4Id100], [s3].[OneToMany_Optional_Self_Inverse4Id20] AS [OneToMany_Optional_Self_Inverse4Id200], [s3].[OneToMany_Required_Inverse4Id10] AS [OneToMany_Required_Inverse4Id100], [s3].[OneToMany_Required_Inverse4Id20] AS [OneToMany_Required_Inverse4Id200], [s3].[OneToMany_Required_Self_Inverse4Id10] AS [OneToMany_Required_Self_Inverse4Id100], [s3].[OneToMany_Required_Self_Inverse4Id20] AS [OneToMany_Required_Self_Inverse4Id200], [s3].[OneToOne_Optional_PK_Inverse4Id10] AS [OneToOne_Optional_PK_Inverse4Id100], [s3].[OneToOne_Optional_PK_Inverse4Id20] AS [OneToOne_Optional_PK_Inverse4Id200], [s3].[OneToOne_Optional_Self4Id10] AS [OneToOne_Optional_Self4Id100], [s3].[OneToOne_Optional_Self4Id20] AS [OneToOne_Optional_Self4Id200], [c7].[OneToMany_Required_Inverse2Id1], [c7].[OneToMany_Required_Inverse2Id2]
    FROM [CompositeTwos] AS [c7]
    LEFT JOIN (
        SELECT [c8].[Name], [c8].[Id1], [c8].[Id2], [c9].[Id1] AS [Id10], [c9].[Id2] AS [Id20], [c9].[Level3_Optional_Id1], [c9].[Level3_Optional_Id2], [c9].[Level3_Required_Id1], [c9].[Level3_Required_Id2], [c9].[Name] AS [Name0], [c9].[OneToMany_Optional_Inverse4Id1], [c9].[OneToMany_Optional_Inverse4Id2], [c9].[OneToMany_Optional_Self_Inverse4Id1], [c9].[OneToMany_Optional_Self_Inverse4Id2], [c9].[OneToMany_Required_Inverse4Id1], [c9].[OneToMany_Required_Inverse4Id2], [c9].[OneToMany_Required_Self_Inverse4Id1], [c9].[OneToMany_Required_Self_Inverse4Id2], [c9].[OneToOne_Optional_PK_Inverse4Id1], [c9].[OneToOne_Optional_PK_Inverse4Id2], [c9].[OneToOne_Optional_Self4Id1], [c9].[OneToOne_Optional_Self4Id2], [c10].[Id1] AS [Id11], [c10].[Id2] AS [Id21], [c10].[Level3_Optional_Id1] AS [Level3_Optional_Id10], [c10].[Level3_Optional_Id2] AS [Level3_Optional_Id20], [c10].[Level3_Required_Id1] AS [Level3_Required_Id10], [c10].[Level3_Required_Id2] AS [Level3_Required_Id20], [c10].[Name] AS [Name1], [c10].[OneToMany_Optional_Inverse4Id1] AS [OneToMany_Optional_Inverse4Id10], [c10].[OneToMany_Optional_Inverse4Id2] AS [OneToMany_Optional_Inverse4Id20], [c10].[OneToMany_Optional_Self_Inverse4Id1] AS [OneToMany_Optional_Self_Inverse4Id10], [c10].[OneToMany_Optional_Self_Inverse4Id2] AS [OneToMany_Optional_Self_Inverse4Id20], [c10].[OneToMany_Required_Inverse4Id1] AS [OneToMany_Required_Inverse4Id10], [c10].[OneToMany_Required_Inverse4Id2] AS [OneToMany_Required_Inverse4Id20], [c10].[OneToMany_Required_Self_Inverse4Id1] AS [OneToMany_Required_Self_Inverse4Id10], [c10].[OneToMany_Required_Self_Inverse4Id2] AS [OneToMany_Required_Self_Inverse4Id20], [c10].[OneToOne_Optional_PK_Inverse4Id1] AS [OneToOne_Optional_PK_Inverse4Id10], [c10].[OneToOne_Optional_PK_Inverse4Id2] AS [OneToOne_Optional_PK_Inverse4Id20], [c10].[OneToOne_Optional_Self4Id1] AS [OneToOne_Optional_Self4Id10], [c10].[OneToOne_Optional_Self4Id2] AS [OneToOne_Optional_Self4Id20], [c8].[OneToMany_Optional_Inverse3Id1], [c8].[OneToMany_Optional_Inverse3Id2]
        FROM [CompositeThrees] AS [c8]
        LEFT JOIN [CompositeFours] AS [c9] ON [c8].[Id1] = [c9].[OneToMany_Required_Inverse4Id1] AND [c8].[Id2] = [c9].[OneToMany_Required_Inverse4Id2]
        LEFT JOIN [CompositeFours] AS [c10] ON [c8].[Id1] = [c10].[OneToMany_Optional_Inverse4Id1] AND [c8].[Id2] = [c10].[OneToMany_Optional_Inverse4Id2]
    ) AS [s2] ON [c7].[Id1] = [s2].[OneToMany_Optional_Inverse3Id1] AND [c7].[Id2] = [s2].[OneToMany_Optional_Inverse3Id2]
    LEFT JOIN (
        SELECT [c11].[Name], [c11].[Id1], [c11].[Id2], [c12].[Id1] AS [Id10], [c12].[Id2] AS [Id20], [c12].[Level3_Optional_Id1], [c12].[Level3_Optional_Id2], [c12].[Level3_Required_Id1], [c12].[Level3_Required_Id2], [c12].[Name] AS [Name0], [c12].[OneToMany_Optional_Inverse4Id1], [c12].[OneToMany_Optional_Inverse4Id2], [c12].[OneToMany_Optional_Self_Inverse4Id1], [c12].[OneToMany_Optional_Self_Inverse4Id2], [c12].[OneToMany_Required_Inverse4Id1], [c12].[OneToMany_Required_Inverse4Id2], [c12].[OneToMany_Required_Self_Inverse4Id1], [c12].[OneToMany_Required_Self_Inverse4Id2], [c12].[OneToOne_Optional_PK_Inverse4Id1], [c12].[OneToOne_Optional_PK_Inverse4Id2], [c12].[OneToOne_Optional_Self4Id1], [c12].[OneToOne_Optional_Self4Id2], [c13].[Id1] AS [Id11], [c13].[Id2] AS [Id21], [c13].[Level3_Optional_Id1] AS [Level3_Optional_Id10], [c13].[Level3_Optional_Id2] AS [Level3_Optional_Id20], [c13].[Level3_Required_Id1] AS [Level3_Required_Id10], [c13].[Level3_Required_Id2] AS [Level3_Required_Id20], [c13].[Name] AS [Name1], [c13].[OneToMany_Optional_Inverse4Id1] AS [OneToMany_Optional_Inverse4Id10], [c13].[OneToMany_Optional_Inverse4Id2] AS [OneToMany_Optional_Inverse4Id20], [c13].[OneToMany_Optional_Self_Inverse4Id1] AS [OneToMany_Optional_Self_Inverse4Id10], [c13].[OneToMany_Optional_Self_Inverse4Id2] AS [OneToMany_Optional_Self_Inverse4Id20], [c13].[OneToMany_Required_Inverse4Id1] AS [OneToMany_Required_Inverse4Id10], [c13].[OneToMany_Required_Inverse4Id2] AS [OneToMany_Required_Inverse4Id20], [c13].[OneToMany_Required_Self_Inverse4Id1] AS [OneToMany_Required_Self_Inverse4Id10], [c13].[OneToMany_Required_Self_Inverse4Id2] AS [OneToMany_Required_Self_Inverse4Id20], [c13].[OneToOne_Optional_PK_Inverse4Id1] AS [OneToOne_Optional_PK_Inverse4Id10], [c13].[OneToOne_Optional_PK_Inverse4Id2] AS [OneToOne_Optional_PK_Inverse4Id20], [c13].[OneToOne_Optional_Self4Id1] AS [OneToOne_Optional_Self4Id10], [c13].[OneToOne_Optional_Self4Id2] AS [OneToOne_Optional_Self4Id20], [c11].[OneToMany_Optional_Inverse3Id1], [c11].[OneToMany_Optional_Inverse3Id2]
        FROM [CompositeThrees] AS [c11]
        LEFT JOIN [CompositeFours] AS [c12] ON [c11].[Id1] = [c12].[OneToMany_Optional_Inverse4Id1] AND [c11].[Id2] = [c12].[OneToMany_Optional_Inverse4Id2]
        LEFT JOIN [CompositeFours] AS [c13] ON [c11].[Id1] = [c13].[OneToMany_Required_Inverse4Id1] AND [c11].[Id2] = [c13].[OneToMany_Required_Inverse4Id2]
    ) AS [s3] ON [c7].[Id1] = [s3].[OneToMany_Optional_Inverse3Id1] AND [c7].[Id2] = [s3].[OneToMany_Optional_Inverse3Id2]
) AS [s4] ON [c].[Id1] = [s4].[OneToMany_Required_Inverse2Id1] AND [c].[Id2] = [s4].[OneToMany_Required_Inverse2Id2]
ORDER BY [c].[Id1], [c].[Id2], [s1].[Id1], [s1].[Id2], [s1].[Id10], [s1].[Id20], [s1].[Id100], [s1].[Id200], [s1].[Id11], [s1].[Id21], [s1].[Id12], [s1].[Id22], [s1].[Id101], [s1].[Id201], [s1].[Id110], [s1].[Id210], [s4].[Id1], [s4].[Id2], [s4].[Id10], [s4].[Id20], [s4].[Id100], [s4].[Id200], [s4].[Id11], [s4].[Id21], [s4].[Id12], [s4].[Id22], [s4].[Id101], [s4].[Id201], [s4].[Id110]
""");
    }

    public override async Task Projecting_multiple_collections_on_multiple_levels_some_explicit_ordering(bool async)
    {
        await base.Projecting_multiple_collections_on_multiple_levels_some_explicit_ordering(async);

        AssertSql(
            """
SELECT [c].[Id1], [c].[Id2], [s1].[Name], [s1].[Id1], [s1].[Id2], [s1].[Id10], [s1].[Id20], [s1].[Id100], [s1].[Id200], [s1].[Level3_Optional_Id1], [s1].[Level3_Optional_Id2], [s1].[Level3_Required_Id1], [s1].[Level3_Required_Id2], [s1].[Name0], [s1].[OneToMany_Optional_Inverse4Id1], [s1].[OneToMany_Optional_Inverse4Id2], [s1].[OneToMany_Optional_Self_Inverse4Id1], [s1].[OneToMany_Optional_Self_Inverse4Id2], [s1].[OneToMany_Required_Inverse4Id1], [s1].[OneToMany_Required_Inverse4Id2], [s1].[OneToMany_Required_Self_Inverse4Id1], [s1].[OneToMany_Required_Self_Inverse4Id2], [s1].[OneToOne_Optional_PK_Inverse4Id1], [s1].[OneToOne_Optional_PK_Inverse4Id2], [s1].[OneToOne_Optional_Self4Id1], [s1].[OneToOne_Optional_Self4Id2], [s1].[Id11], [s1].[Id21], [s1].[Level3_Optional_Id10], [s1].[Level3_Optional_Id20], [s1].[Level3_Required_Id10], [s1].[Level3_Required_Id20], [s1].[Name00], [s1].[OneToMany_Optional_Inverse4Id10], [s1].[OneToMany_Optional_Inverse4Id20], [s1].[OneToMany_Optional_Self_Inverse4Id10], [s1].[OneToMany_Optional_Self_Inverse4Id20], [s1].[OneToMany_Required_Inverse4Id10], [s1].[OneToMany_Required_Inverse4Id20], [s1].[OneToMany_Required_Self_Inverse4Id10], [s1].[OneToMany_Required_Self_Inverse4Id20], [s1].[OneToOne_Optional_PK_Inverse4Id10], [s1].[OneToOne_Optional_PK_Inverse4Id20], [s1].[OneToOne_Optional_Self4Id10], [s1].[OneToOne_Optional_Self4Id20], [s1].[Name1], [s1].[Id12], [s1].[Id22], [s1].[Id101], [s1].[Id201], [s1].[Level3_Optional_Id11], [s1].[Level3_Optional_Id21], [s1].[Level3_Required_Id11], [s1].[Level3_Required_Id21], [s1].[Name01], [s1].[OneToMany_Optional_Inverse4Id11], [s1].[OneToMany_Optional_Inverse4Id21], [s1].[OneToMany_Optional_Self_Inverse4Id11], [s1].[OneToMany_Optional_Self_Inverse4Id21], [s1].[OneToMany_Required_Inverse4Id11], [s1].[OneToMany_Required_Inverse4Id21], [s1].[OneToMany_Required_Self_Inverse4Id11], [s1].[OneToMany_Required_Self_Inverse4Id21], [s1].[OneToOne_Optional_PK_Inverse4Id11], [s1].[OneToOne_Optional_PK_Inverse4Id21], [s1].[OneToOne_Optional_Self4Id11], [s1].[OneToOne_Optional_Self4Id21], [s1].[Id110], [s1].[Id210], [s1].[Level3_Optional_Id100], [s1].[Level3_Optional_Id200], [s1].[Level3_Required_Id100], [s1].[Level3_Required_Id200], [s1].[Name10], [s1].[OneToMany_Optional_Inverse4Id100], [s1].[OneToMany_Optional_Inverse4Id200], [s1].[OneToMany_Optional_Self_Inverse4Id100], [s1].[OneToMany_Optional_Self_Inverse4Id200], [s1].[OneToMany_Required_Inverse4Id100], [s1].[OneToMany_Required_Inverse4Id200], [s1].[OneToMany_Required_Self_Inverse4Id100], [s1].[OneToMany_Required_Self_Inverse4Id200], [s1].[OneToOne_Optional_PK_Inverse4Id100], [s1].[OneToOne_Optional_PK_Inverse4Id200], [s1].[OneToOne_Optional_Self4Id100], [s1].[OneToOne_Optional_Self4Id200], [s4].[Name], [s4].[Id1], [s4].[Id2], [s4].[Name0], [s4].[Id10], [s4].[Id20], [s4].[Id100], [s4].[Id200], [s4].[Level3_Optional_Id1], [s4].[Level3_Optional_Id2], [s4].[Level3_Required_Id1], [s4].[Level3_Required_Id2], [s4].[Name00], [s4].[OneToMany_Optional_Inverse4Id1], [s4].[OneToMany_Optional_Inverse4Id2], [s4].[OneToMany_Optional_Self_Inverse4Id1], [s4].[OneToMany_Optional_Self_Inverse4Id2], [s4].[OneToMany_Required_Inverse4Id1], [s4].[OneToMany_Required_Inverse4Id2], [s4].[OneToMany_Required_Self_Inverse4Id1], [s4].[OneToMany_Required_Self_Inverse4Id2], [s4].[OneToOne_Optional_PK_Inverse4Id1], [s4].[OneToOne_Optional_PK_Inverse4Id2], [s4].[OneToOne_Optional_Self4Id1], [s4].[OneToOne_Optional_Self4Id2], [s4].[Id11], [s4].[Id21], [s4].[Level3_Optional_Id10], [s4].[Level3_Optional_Id20], [s4].[Level3_Required_Id10], [s4].[Level3_Required_Id20], [s4].[Name1], [s4].[OneToMany_Optional_Inverse4Id10], [s4].[OneToMany_Optional_Inverse4Id20], [s4].[OneToMany_Optional_Self_Inverse4Id10], [s4].[OneToMany_Optional_Self_Inverse4Id20], [s4].[OneToMany_Required_Inverse4Id10], [s4].[OneToMany_Required_Inverse4Id20], [s4].[OneToMany_Required_Self_Inverse4Id10], [s4].[OneToMany_Required_Self_Inverse4Id20], [s4].[OneToOne_Optional_PK_Inverse4Id10], [s4].[OneToOne_Optional_PK_Inverse4Id20], [s4].[OneToOne_Optional_Self4Id10], [s4].[OneToOne_Optional_Self4Id20], [s4].[Name2], [s4].[Id12], [s4].[Id22], [s4].[Id101], [s4].[Id201], [s4].[Level3_Optional_Id11], [s4].[Level3_Optional_Id21], [s4].[Level3_Required_Id11], [s4].[Level3_Required_Id21], [s4].[Name01], [s4].[OneToMany_Optional_Inverse4Id11], [s4].[OneToMany_Optional_Inverse4Id21], [s4].[OneToMany_Optional_Self_Inverse4Id11], [s4].[OneToMany_Optional_Self_Inverse4Id21], [s4].[OneToMany_Required_Inverse4Id11], [s4].[OneToMany_Required_Inverse4Id21], [s4].[OneToMany_Required_Self_Inverse4Id11], [s4].[OneToMany_Required_Self_Inverse4Id21], [s4].[OneToOne_Optional_PK_Inverse4Id11], [s4].[OneToOne_Optional_PK_Inverse4Id21], [s4].[OneToOne_Optional_Self4Id11], [s4].[OneToOne_Optional_Self4Id21], [s4].[Id110], [s4].[Id210], [s4].[Level3_Optional_Id100], [s4].[Level3_Optional_Id200], [s4].[Level3_Required_Id100], [s4].[Level3_Required_Id200], [s4].[Name10], [s4].[OneToMany_Optional_Inverse4Id100], [s4].[OneToMany_Optional_Inverse4Id200], [s4].[OneToMany_Optional_Self_Inverse4Id100], [s4].[OneToMany_Optional_Self_Inverse4Id200], [s4].[OneToMany_Required_Inverse4Id100], [s4].[OneToMany_Required_Inverse4Id200], [s4].[OneToMany_Required_Self_Inverse4Id100], [s4].[OneToMany_Required_Self_Inverse4Id200], [s4].[OneToOne_Optional_PK_Inverse4Id100], [s4].[OneToOne_Optional_PK_Inverse4Id200], [s4].[OneToOne_Optional_Self4Id100], [s4].[OneToOne_Optional_Self4Id200]
FROM [CompositeOnes] AS [c]
LEFT JOIN (
    SELECT [c0].[Name], [c0].[Id1], [c0].[Id2], [s].[Id1] AS [Id10], [s].[Id2] AS [Id20], [s].[Id10] AS [Id100], [s].[Id20] AS [Id200], [s].[Level3_Optional_Id1], [s].[Level3_Optional_Id2], [s].[Level3_Required_Id1], [s].[Level3_Required_Id2], [s].[Name] AS [Name0], [s].[OneToMany_Optional_Inverse4Id1], [s].[OneToMany_Optional_Inverse4Id2], [s].[OneToMany_Optional_Self_Inverse4Id1], [s].[OneToMany_Optional_Self_Inverse4Id2], [s].[OneToMany_Required_Inverse4Id1], [s].[OneToMany_Required_Inverse4Id2], [s].[OneToMany_Required_Self_Inverse4Id1], [s].[OneToMany_Required_Self_Inverse4Id2], [s].[OneToOne_Optional_PK_Inverse4Id1], [s].[OneToOne_Optional_PK_Inverse4Id2], [s].[OneToOne_Optional_Self4Id1], [s].[OneToOne_Optional_Self4Id2], [s].[Id11], [s].[Id21], [s].[Level3_Optional_Id10], [s].[Level3_Optional_Id20], [s].[Level3_Required_Id10], [s].[Level3_Required_Id20], [s].[Name0] AS [Name00], [s].[OneToMany_Optional_Inverse4Id10], [s].[OneToMany_Optional_Inverse4Id20], [s].[OneToMany_Optional_Self_Inverse4Id10], [s].[OneToMany_Optional_Self_Inverse4Id20], [s].[OneToMany_Required_Inverse4Id10], [s].[OneToMany_Required_Inverse4Id20], [s].[OneToMany_Required_Self_Inverse4Id10], [s].[OneToMany_Required_Self_Inverse4Id20], [s].[OneToOne_Optional_PK_Inverse4Id10], [s].[OneToOne_Optional_PK_Inverse4Id20], [s].[OneToOne_Optional_Self4Id10], [s].[OneToOne_Optional_Self4Id20], [s0].[Name] AS [Name1], [s0].[Id1] AS [Id12], [s0].[Id2] AS [Id22], [s0].[Id10] AS [Id101], [s0].[Id20] AS [Id201], [s0].[Level3_Optional_Id1] AS [Level3_Optional_Id11], [s0].[Level3_Optional_Id2] AS [Level3_Optional_Id21], [s0].[Level3_Required_Id1] AS [Level3_Required_Id11], [s0].[Level3_Required_Id2] AS [Level3_Required_Id21], [s0].[Name0] AS [Name01], [s0].[OneToMany_Optional_Inverse4Id1] AS [OneToMany_Optional_Inverse4Id11], [s0].[OneToMany_Optional_Inverse4Id2] AS [OneToMany_Optional_Inverse4Id21], [s0].[OneToMany_Optional_Self_Inverse4Id1] AS [OneToMany_Optional_Self_Inverse4Id11], [s0].[OneToMany_Optional_Self_Inverse4Id2] AS [OneToMany_Optional_Self_Inverse4Id21], [s0].[OneToMany_Required_Inverse4Id1] AS [OneToMany_Required_Inverse4Id11], [s0].[OneToMany_Required_Inverse4Id2] AS [OneToMany_Required_Inverse4Id21], [s0].[OneToMany_Required_Self_Inverse4Id1] AS [OneToMany_Required_Self_Inverse4Id11], [s0].[OneToMany_Required_Self_Inverse4Id2] AS [OneToMany_Required_Self_Inverse4Id21], [s0].[OneToOne_Optional_PK_Inverse4Id1] AS [OneToOne_Optional_PK_Inverse4Id11], [s0].[OneToOne_Optional_PK_Inverse4Id2] AS [OneToOne_Optional_PK_Inverse4Id21], [s0].[OneToOne_Optional_Self4Id1] AS [OneToOne_Optional_Self4Id11], [s0].[OneToOne_Optional_Self4Id2] AS [OneToOne_Optional_Self4Id21], [s0].[Id11] AS [Id110], [s0].[Id21] AS [Id210], [s0].[Level3_Optional_Id10] AS [Level3_Optional_Id100], [s0].[Level3_Optional_Id20] AS [Level3_Optional_Id200], [s0].[Level3_Required_Id10] AS [Level3_Required_Id100], [s0].[Level3_Required_Id20] AS [Level3_Required_Id200], [s0].[Name1] AS [Name10], [s0].[OneToMany_Optional_Inverse4Id10] AS [OneToMany_Optional_Inverse4Id100], [s0].[OneToMany_Optional_Inverse4Id20] AS [OneToMany_Optional_Inverse4Id200], [s0].[OneToMany_Optional_Self_Inverse4Id10] AS [OneToMany_Optional_Self_Inverse4Id100], [s0].[OneToMany_Optional_Self_Inverse4Id20] AS [OneToMany_Optional_Self_Inverse4Id200], [s0].[OneToMany_Required_Inverse4Id10] AS [OneToMany_Required_Inverse4Id100], [s0].[OneToMany_Required_Inverse4Id20] AS [OneToMany_Required_Inverse4Id200], [s0].[OneToMany_Required_Self_Inverse4Id10] AS [OneToMany_Required_Self_Inverse4Id100], [s0].[OneToMany_Required_Self_Inverse4Id20] AS [OneToMany_Required_Self_Inverse4Id200], [s0].[OneToOne_Optional_PK_Inverse4Id10] AS [OneToOne_Optional_PK_Inverse4Id100], [s0].[OneToOne_Optional_PK_Inverse4Id20] AS [OneToOne_Optional_PK_Inverse4Id200], [s0].[OneToOne_Optional_Self4Id10] AS [OneToOne_Optional_Self4Id100], [s0].[OneToOne_Optional_Self4Id20] AS [OneToOne_Optional_Self4Id200], [c0].[OneToMany_Optional_Inverse2Id1], [c0].[OneToMany_Optional_Inverse2Id2]
    FROM [CompositeTwos] AS [c0]
    LEFT JOIN (
        SELECT [c1].[Id1], [c1].[Id2], [c2].[Id1] AS [Id10], [c2].[Id2] AS [Id20], [c2].[Level3_Optional_Id1], [c2].[Level3_Optional_Id2], [c2].[Level3_Required_Id1], [c2].[Level3_Required_Id2], [c2].[Name], [c2].[OneToMany_Optional_Inverse4Id1], [c2].[OneToMany_Optional_Inverse4Id2], [c2].[OneToMany_Optional_Self_Inverse4Id1], [c2].[OneToMany_Optional_Self_Inverse4Id2], [c2].[OneToMany_Required_Inverse4Id1], [c2].[OneToMany_Required_Inverse4Id2], [c2].[OneToMany_Required_Self_Inverse4Id1], [c2].[OneToMany_Required_Self_Inverse4Id2], [c2].[OneToOne_Optional_PK_Inverse4Id1], [c2].[OneToOne_Optional_PK_Inverse4Id2], [c2].[OneToOne_Optional_Self4Id1], [c2].[OneToOne_Optional_Self4Id2], [c3].[Id1] AS [Id11], [c3].[Id2] AS [Id21], [c3].[Level3_Optional_Id1] AS [Level3_Optional_Id10], [c3].[Level3_Optional_Id2] AS [Level3_Optional_Id20], [c3].[Level3_Required_Id1] AS [Level3_Required_Id10], [c3].[Level3_Required_Id2] AS [Level3_Required_Id20], [c3].[Name] AS [Name0], [c3].[OneToMany_Optional_Inverse4Id1] AS [OneToMany_Optional_Inverse4Id10], [c3].[OneToMany_Optional_Inverse4Id2] AS [OneToMany_Optional_Inverse4Id20], [c3].[OneToMany_Optional_Self_Inverse4Id1] AS [OneToMany_Optional_Self_Inverse4Id10], [c3].[OneToMany_Optional_Self_Inverse4Id2] AS [OneToMany_Optional_Self_Inverse4Id20], [c3].[OneToMany_Required_Inverse4Id1] AS [OneToMany_Required_Inverse4Id10], [c3].[OneToMany_Required_Inverse4Id2] AS [OneToMany_Required_Inverse4Id20], [c3].[OneToMany_Required_Self_Inverse4Id1] AS [OneToMany_Required_Self_Inverse4Id10], [c3].[OneToMany_Required_Self_Inverse4Id2] AS [OneToMany_Required_Self_Inverse4Id20], [c3].[OneToOne_Optional_PK_Inverse4Id1] AS [OneToOne_Optional_PK_Inverse4Id10], [c3].[OneToOne_Optional_PK_Inverse4Id2] AS [OneToOne_Optional_PK_Inverse4Id20], [c3].[OneToOne_Optional_Self4Id1] AS [OneToOne_Optional_Self4Id10], [c3].[OneToOne_Optional_Self4Id2] AS [OneToOne_Optional_Self4Id20], [c1].[OneToMany_Required_Inverse3Id1], [c1].[OneToMany_Required_Inverse3Id2]
        FROM [CompositeThrees] AS [c1]
        LEFT JOIN [CompositeFours] AS [c2] ON [c1].[Id1] = [c2].[OneToMany_Optional_Inverse4Id1] AND [c1].[Id2] = [c2].[OneToMany_Optional_Inverse4Id2]
        LEFT JOIN [CompositeFours] AS [c3] ON [c1].[Id1] = [c3].[OneToMany_Required_Inverse4Id1] AND [c1].[Id2] = [c3].[OneToMany_Required_Inverse4Id2]
    ) AS [s] ON [c0].[Id1] = [s].[OneToMany_Required_Inverse3Id1] AND [c0].[Id2] = [s].[OneToMany_Required_Inverse3Id2]
    LEFT JOIN (
        SELECT [c4].[Name], [c4].[Id1], [c4].[Id2], [c5].[Id1] AS [Id10], [c5].[Id2] AS [Id20], [c5].[Level3_Optional_Id1], [c5].[Level3_Optional_Id2], [c5].[Level3_Required_Id1], [c5].[Level3_Required_Id2], [c5].[Name] AS [Name0], [c5].[OneToMany_Optional_Inverse4Id1], [c5].[OneToMany_Optional_Inverse4Id2], [c5].[OneToMany_Optional_Self_Inverse4Id1], [c5].[OneToMany_Optional_Self_Inverse4Id2], [c5].[OneToMany_Required_Inverse4Id1], [c5].[OneToMany_Required_Inverse4Id2], [c5].[OneToMany_Required_Self_Inverse4Id1], [c5].[OneToMany_Required_Self_Inverse4Id2], [c5].[OneToOne_Optional_PK_Inverse4Id1], [c5].[OneToOne_Optional_PK_Inverse4Id2], [c5].[OneToOne_Optional_Self4Id1], [c5].[OneToOne_Optional_Self4Id2], [c6].[Id1] AS [Id11], [c6].[Id2] AS [Id21], [c6].[Level3_Optional_Id1] AS [Level3_Optional_Id10], [c6].[Level3_Optional_Id2] AS [Level3_Optional_Id20], [c6].[Level3_Required_Id1] AS [Level3_Required_Id10], [c6].[Level3_Required_Id2] AS [Level3_Required_Id20], [c6].[Name] AS [Name1], [c6].[OneToMany_Optional_Inverse4Id1] AS [OneToMany_Optional_Inverse4Id10], [c6].[OneToMany_Optional_Inverse4Id2] AS [OneToMany_Optional_Inverse4Id20], [c6].[OneToMany_Optional_Self_Inverse4Id1] AS [OneToMany_Optional_Self_Inverse4Id10], [c6].[OneToMany_Optional_Self_Inverse4Id2] AS [OneToMany_Optional_Self_Inverse4Id20], [c6].[OneToMany_Required_Inverse4Id1] AS [OneToMany_Required_Inverse4Id10], [c6].[OneToMany_Required_Inverse4Id2] AS [OneToMany_Required_Inverse4Id20], [c6].[OneToMany_Required_Self_Inverse4Id1] AS [OneToMany_Required_Self_Inverse4Id10], [c6].[OneToMany_Required_Self_Inverse4Id2] AS [OneToMany_Required_Self_Inverse4Id20], [c6].[OneToOne_Optional_PK_Inverse4Id1] AS [OneToOne_Optional_PK_Inverse4Id10], [c6].[OneToOne_Optional_PK_Inverse4Id2] AS [OneToOne_Optional_PK_Inverse4Id20], [c6].[OneToOne_Optional_Self4Id1] AS [OneToOne_Optional_Self4Id10], [c6].[OneToOne_Optional_Self4Id2] AS [OneToOne_Optional_Self4Id20], [c4].[OneToMany_Optional_Inverse3Id1], [c4].[OneToMany_Optional_Inverse3Id2]
        FROM [CompositeThrees] AS [c4]
        LEFT JOIN [CompositeFours] AS [c5] ON [c4].[Id1] = [c5].[OneToMany_Required_Inverse4Id1] AND [c4].[Id2] = [c5].[OneToMany_Required_Inverse4Id2]
        LEFT JOIN [CompositeFours] AS [c6] ON [c4].[Id1] = [c6].[OneToMany_Optional_Inverse4Id1] AND [c4].[Id2] = [c6].[OneToMany_Optional_Inverse4Id2]
    ) AS [s0] ON [c0].[Id1] = [s0].[OneToMany_Optional_Inverse3Id1] AND [c0].[Id2] = [s0].[OneToMany_Optional_Inverse3Id2]
) AS [s1] ON [c].[Id1] = [s1].[OneToMany_Optional_Inverse2Id1] AND [c].[Id2] = [s1].[OneToMany_Optional_Inverse2Id2]
LEFT JOIN (
    SELECT [c7].[Name], [c7].[Id1], [c7].[Id2], [s2].[Name] AS [Name0], [s2].[Id1] AS [Id10], [s2].[Id2] AS [Id20], [s2].[Id10] AS [Id100], [s2].[Id20] AS [Id200], [s2].[Level3_Optional_Id1], [s2].[Level3_Optional_Id2], [s2].[Level3_Required_Id1], [s2].[Level3_Required_Id2], [s2].[Name0] AS [Name00], [s2].[OneToMany_Optional_Inverse4Id1], [s2].[OneToMany_Optional_Inverse4Id2], [s2].[OneToMany_Optional_Self_Inverse4Id1], [s2].[OneToMany_Optional_Self_Inverse4Id2], [s2].[OneToMany_Required_Inverse4Id1], [s2].[OneToMany_Required_Inverse4Id2], [s2].[OneToMany_Required_Self_Inverse4Id1], [s2].[OneToMany_Required_Self_Inverse4Id2], [s2].[OneToOne_Optional_PK_Inverse4Id1], [s2].[OneToOne_Optional_PK_Inverse4Id2], [s2].[OneToOne_Optional_Self4Id1], [s2].[OneToOne_Optional_Self4Id2], [s2].[Id11], [s2].[Id21], [s2].[Level3_Optional_Id10], [s2].[Level3_Optional_Id20], [s2].[Level3_Required_Id10], [s2].[Level3_Required_Id20], [s2].[Name1], [s2].[OneToMany_Optional_Inverse4Id10], [s2].[OneToMany_Optional_Inverse4Id20], [s2].[OneToMany_Optional_Self_Inverse4Id10], [s2].[OneToMany_Optional_Self_Inverse4Id20], [s2].[OneToMany_Required_Inverse4Id10], [s2].[OneToMany_Required_Inverse4Id20], [s2].[OneToMany_Required_Self_Inverse4Id10], [s2].[OneToMany_Required_Self_Inverse4Id20], [s2].[OneToOne_Optional_PK_Inverse4Id10], [s2].[OneToOne_Optional_PK_Inverse4Id20], [s2].[OneToOne_Optional_Self4Id10], [s2].[OneToOne_Optional_Self4Id20], [s3].[Name] AS [Name2], [s3].[Id1] AS [Id12], [s3].[Id2] AS [Id22], [s3].[Id10] AS [Id101], [s3].[Id20] AS [Id201], [s3].[Level3_Optional_Id1] AS [Level3_Optional_Id11], [s3].[Level3_Optional_Id2] AS [Level3_Optional_Id21], [s3].[Level3_Required_Id1] AS [Level3_Required_Id11], [s3].[Level3_Required_Id2] AS [Level3_Required_Id21], [s3].[Name0] AS [Name01], [s3].[OneToMany_Optional_Inverse4Id1] AS [OneToMany_Optional_Inverse4Id11], [s3].[OneToMany_Optional_Inverse4Id2] AS [OneToMany_Optional_Inverse4Id21], [s3].[OneToMany_Optional_Self_Inverse4Id1] AS [OneToMany_Optional_Self_Inverse4Id11], [s3].[OneToMany_Optional_Self_Inverse4Id2] AS [OneToMany_Optional_Self_Inverse4Id21], [s3].[OneToMany_Required_Inverse4Id1] AS [OneToMany_Required_Inverse4Id11], [s3].[OneToMany_Required_Inverse4Id2] AS [OneToMany_Required_Inverse4Id21], [s3].[OneToMany_Required_Self_Inverse4Id1] AS [OneToMany_Required_Self_Inverse4Id11], [s3].[OneToMany_Required_Self_Inverse4Id2] AS [OneToMany_Required_Self_Inverse4Id21], [s3].[OneToOne_Optional_PK_Inverse4Id1] AS [OneToOne_Optional_PK_Inverse4Id11], [s3].[OneToOne_Optional_PK_Inverse4Id2] AS [OneToOne_Optional_PK_Inverse4Id21], [s3].[OneToOne_Optional_Self4Id1] AS [OneToOne_Optional_Self4Id11], [s3].[OneToOne_Optional_Self4Id2] AS [OneToOne_Optional_Self4Id21], [s3].[Id11] AS [Id110], [s3].[Id21] AS [Id210], [s3].[Level3_Optional_Id10] AS [Level3_Optional_Id100], [s3].[Level3_Optional_Id20] AS [Level3_Optional_Id200], [s3].[Level3_Required_Id10] AS [Level3_Required_Id100], [s3].[Level3_Required_Id20] AS [Level3_Required_Id200], [s3].[Name1] AS [Name10], [s3].[OneToMany_Optional_Inverse4Id10] AS [OneToMany_Optional_Inverse4Id100], [s3].[OneToMany_Optional_Inverse4Id20] AS [OneToMany_Optional_Inverse4Id200], [s3].[OneToMany_Optional_Self_Inverse4Id10] AS [OneToMany_Optional_Self_Inverse4Id100], [s3].[OneToMany_Optional_Self_Inverse4Id20] AS [OneToMany_Optional_Self_Inverse4Id200], [s3].[OneToMany_Required_Inverse4Id10] AS [OneToMany_Required_Inverse4Id100], [s3].[OneToMany_Required_Inverse4Id20] AS [OneToMany_Required_Inverse4Id200], [s3].[OneToMany_Required_Self_Inverse4Id10] AS [OneToMany_Required_Self_Inverse4Id100], [s3].[OneToMany_Required_Self_Inverse4Id20] AS [OneToMany_Required_Self_Inverse4Id200], [s3].[OneToOne_Optional_PK_Inverse4Id10] AS [OneToOne_Optional_PK_Inverse4Id100], [s3].[OneToOne_Optional_PK_Inverse4Id20] AS [OneToOne_Optional_PK_Inverse4Id200], [s3].[OneToOne_Optional_Self4Id10] AS [OneToOne_Optional_Self4Id100], [s3].[OneToOne_Optional_Self4Id20] AS [OneToOne_Optional_Self4Id200], CAST(LEN([c7].[Name]) AS int) AS [c], [s3].[c] AS [c0], [c7].[OneToMany_Required_Inverse2Id1], [c7].[OneToMany_Required_Inverse2Id2]
    FROM [CompositeTwos] AS [c7]
    LEFT JOIN (
        SELECT [c8].[Name], [c8].[Id1], [c8].[Id2], [c9].[Id1] AS [Id10], [c9].[Id2] AS [Id20], [c9].[Level3_Optional_Id1], [c9].[Level3_Optional_Id2], [c9].[Level3_Required_Id1], [c9].[Level3_Required_Id2], [c9].[Name] AS [Name0], [c9].[OneToMany_Optional_Inverse4Id1], [c9].[OneToMany_Optional_Inverse4Id2], [c9].[OneToMany_Optional_Self_Inverse4Id1], [c9].[OneToMany_Optional_Self_Inverse4Id2], [c9].[OneToMany_Required_Inverse4Id1], [c9].[OneToMany_Required_Inverse4Id2], [c9].[OneToMany_Required_Self_Inverse4Id1], [c9].[OneToMany_Required_Self_Inverse4Id2], [c9].[OneToOne_Optional_PK_Inverse4Id1], [c9].[OneToOne_Optional_PK_Inverse4Id2], [c9].[OneToOne_Optional_Self4Id1], [c9].[OneToOne_Optional_Self4Id2], [c10].[Id1] AS [Id11], [c10].[Id2] AS [Id21], [c10].[Level3_Optional_Id1] AS [Level3_Optional_Id10], [c10].[Level3_Optional_Id2] AS [Level3_Optional_Id20], [c10].[Level3_Required_Id1] AS [Level3_Required_Id10], [c10].[Level3_Required_Id2] AS [Level3_Required_Id20], [c10].[Name] AS [Name1], [c10].[OneToMany_Optional_Inverse4Id1] AS [OneToMany_Optional_Inverse4Id10], [c10].[OneToMany_Optional_Inverse4Id2] AS [OneToMany_Optional_Inverse4Id20], [c10].[OneToMany_Optional_Self_Inverse4Id1] AS [OneToMany_Optional_Self_Inverse4Id10], [c10].[OneToMany_Optional_Self_Inverse4Id2] AS [OneToMany_Optional_Self_Inverse4Id20], [c10].[OneToMany_Required_Inverse4Id1] AS [OneToMany_Required_Inverse4Id10], [c10].[OneToMany_Required_Inverse4Id2] AS [OneToMany_Required_Inverse4Id20], [c10].[OneToMany_Required_Self_Inverse4Id1] AS [OneToMany_Required_Self_Inverse4Id10], [c10].[OneToMany_Required_Self_Inverse4Id2] AS [OneToMany_Required_Self_Inverse4Id20], [c10].[OneToOne_Optional_PK_Inverse4Id1] AS [OneToOne_Optional_PK_Inverse4Id10], [c10].[OneToOne_Optional_PK_Inverse4Id2] AS [OneToOne_Optional_PK_Inverse4Id20], [c10].[OneToOne_Optional_Self4Id1] AS [OneToOne_Optional_Self4Id10], [c10].[OneToOne_Optional_Self4Id2] AS [OneToOne_Optional_Self4Id20], [c8].[OneToMany_Optional_Inverse3Id1], [c8].[OneToMany_Optional_Inverse3Id2]
        FROM [CompositeThrees] AS [c8]
        LEFT JOIN [CompositeFours] AS [c9] ON [c8].[Id1] = [c9].[OneToMany_Required_Inverse4Id1] AND [c8].[Id2] = [c9].[OneToMany_Required_Inverse4Id2]
        LEFT JOIN [CompositeFours] AS [c10] ON [c8].[Id1] = [c10].[OneToMany_Optional_Inverse4Id1] AND [c8].[Id2] = [c10].[OneToMany_Optional_Inverse4Id2]
    ) AS [s2] ON [c7].[Id1] = [s2].[OneToMany_Optional_Inverse3Id1] AND [c7].[Id2] = [s2].[OneToMany_Optional_Inverse3Id2]
    LEFT JOIN (
        SELECT [c11].[Name], [c11].[Id1], [c11].[Id2], [c12].[Id1] AS [Id10], [c12].[Id2] AS [Id20], [c12].[Level3_Optional_Id1], [c12].[Level3_Optional_Id2], [c12].[Level3_Required_Id1], [c12].[Level3_Required_Id2], [c12].[Name] AS [Name0], [c12].[OneToMany_Optional_Inverse4Id1], [c12].[OneToMany_Optional_Inverse4Id2], [c12].[OneToMany_Optional_Self_Inverse4Id1], [c12].[OneToMany_Optional_Self_Inverse4Id2], [c12].[OneToMany_Required_Inverse4Id1], [c12].[OneToMany_Required_Inverse4Id2], [c12].[OneToMany_Required_Self_Inverse4Id1], [c12].[OneToMany_Required_Self_Inverse4Id2], [c12].[OneToOne_Optional_PK_Inverse4Id1], [c12].[OneToOne_Optional_PK_Inverse4Id2], [c12].[OneToOne_Optional_Self4Id1], [c12].[OneToOne_Optional_Self4Id2], [c13].[Id1] AS [Id11], [c13].[Id2] AS [Id21], [c13].[Level3_Optional_Id1] AS [Level3_Optional_Id10], [c13].[Level3_Optional_Id2] AS [Level3_Optional_Id20], [c13].[Level3_Required_Id1] AS [Level3_Required_Id10], [c13].[Level3_Required_Id2] AS [Level3_Required_Id20], [c13].[Name] AS [Name1], [c13].[OneToMany_Optional_Inverse4Id1] AS [OneToMany_Optional_Inverse4Id10], [c13].[OneToMany_Optional_Inverse4Id2] AS [OneToMany_Optional_Inverse4Id20], [c13].[OneToMany_Optional_Self_Inverse4Id1] AS [OneToMany_Optional_Self_Inverse4Id10], [c13].[OneToMany_Optional_Self_Inverse4Id2] AS [OneToMany_Optional_Self_Inverse4Id20], [c13].[OneToMany_Required_Inverse4Id1] AS [OneToMany_Required_Inverse4Id10], [c13].[OneToMany_Required_Inverse4Id2] AS [OneToMany_Required_Inverse4Id20], [c13].[OneToMany_Required_Self_Inverse4Id1] AS [OneToMany_Required_Self_Inverse4Id10], [c13].[OneToMany_Required_Self_Inverse4Id2] AS [OneToMany_Required_Self_Inverse4Id20], [c13].[OneToOne_Optional_PK_Inverse4Id1] AS [OneToOne_Optional_PK_Inverse4Id10], [c13].[OneToOne_Optional_PK_Inverse4Id2] AS [OneToOne_Optional_PK_Inverse4Id20], [c13].[OneToOne_Optional_Self4Id1] AS [OneToOne_Optional_Self4Id10], [c13].[OneToOne_Optional_Self4Id2] AS [OneToOne_Optional_Self4Id20], [c13].[Id1] + CAST([c13].[Id2] AS nvarchar(max)) AS [c], [c11].[OneToMany_Optional_Inverse3Id1], [c11].[OneToMany_Optional_Inverse3Id2]
        FROM [CompositeThrees] AS [c11]
        LEFT JOIN [CompositeFours] AS [c12] ON [c11].[Id1] = [c12].[OneToMany_Optional_Inverse4Id1] AND [c11].[Id2] = [c12].[OneToMany_Optional_Inverse4Id2]
        LEFT JOIN [CompositeFours] AS [c13] ON [c11].[Id1] = [c13].[OneToMany_Required_Inverse4Id1] AND [c11].[Id2] = [c13].[OneToMany_Required_Inverse4Id2]
    ) AS [s3] ON [c7].[Id1] = [s3].[OneToMany_Optional_Inverse3Id1] AND [c7].[Id2] = [s3].[OneToMany_Optional_Inverse3Id2]
) AS [s4] ON [c].[Id1] = [s4].[OneToMany_Required_Inverse2Id1] AND [c].[Id2] = [s4].[OneToMany_Required_Inverse2Id2]
ORDER BY [c].[Name], [c].[Id1], [c].[Id2], [s1].[Id1], [s1].[Id2], [s1].[Id20] DESC, [s1].[Id10] DESC, [s1].[Id100], [s1].[Id200], [s1].[Id11], [s1].[Id21], [s1].[Id12], [s1].[Id22], [s1].[Id101], [s1].[Id201], [s1].[Id110], [s1].[Id210], [s4].[c], [s4].[Id1], [s4].[Id2], [s4].[Id10], [s4].[Id20], [s4].[Id100], [s4].[Id200], [s4].[Id11], [s4].[Id21], [s4].[Id12], [s4].[Id22], [s4].[Id101], [s4].[Id201], [s4].[c0] DESC, [s4].[Id110]
""");
    }

    private void AssertSql(params string[] expected)
        => Fixture.TestSqlLoggerFactory.AssertBaseline(expected);
}
