/*
 * Decompiled with CFR 0.152.
 */
package dumphd.aacs;

import dumphd.aacs.AACSException;
import dumphd.aacs.AACSKeys;
import dumphd.aacs.PackDecrypter;
import dumphd.bdplus.SubTable;
import dumphd.core.DiscSet;
import dumphd.core.KeyData;
import dumphd.core.KeyDataFile;
import dumphd.core.MultiplexedArf;
import dumphd.util.ByteArray;
import dumphd.util.ByteSource;
import dumphd.util.CopyResult;
import dumphd.util.FileSource;
import dumphd.util.MessagePrinter;
import dumphd.util.PESPack;
import dumphd.util.PESParserException;
import dumphd.util.SimpleFilenameFilter;
import dumphd.util.TSAlignedUnit;
import dumphd.util.TSParserException;
import dumphd.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;
import java.util.zip.CRC32;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AACSDecrypter {
    public static final String idStringAACS = "AACS";
    public static final String idStringTKF = "DVD_HD_V_TKF";
    public static final int maxTKFVersion = 0;
    public static final long TKFFileSize = 2480L;
    public static final HashMap<Integer, Integer> BD_APPLICATION_TYPES = new HashMap();
    public static final byte[] cbc_iv = new byte[]{11, -96, -8, -35, -2, -90, 31, -77, -40, -33, -97, 86, 106, 5, 15, 120};
    public static final IvParameterSpec cbc_iv_spec = new IvParameterSpec(cbc_iv);
    public static final byte[] h0 = new byte[]{45, -62, -33, 57, 66, 3, 33, -48, -50, -15, -2, 35, 116, 2, -99, -107};
    public static final int decrypterThreads = 2;
    public static final int queueLength = 30;
    private MessagePrinter out = null;
    private KeyDataFile kdf = null;
    private byte[] packBuffer = new byte[122880];
    private PackDecrypter packDecrypter = null;
    private AACSKeys akl = null;
    private CRC32 crc32Calc = new CRC32();
    private Cipher aes_128d = null;
    private Cipher aes_128cbcd = null;
    private MessageDigest sha1 = null;
    private DiscSet ds = null;

    static {
        BD_APPLICATION_TYPES.put(5, 1);
        BD_APPLICATION_TYPES.put(6, 3);
        BD_APPLICATION_TYPES.put(7, 2);
    }

    public static boolean isArfEncrypted(ByteSource ds) throws IOException {
        byte[] data = new byte[idStringAACS.length()];
        Arrays.fill(data, (byte)0);
        ds.read(data, 0, idStringAACS.length());
        ds.setPosition(0L);
        return new String(data, 0, idStringAACS.length(), "US-ASCII").equals(idStringAACS);
    }

    public AACSDecrypter(MessagePrinter mp, KeyDataFile kdf) throws AACSException {
        this.out = mp;
        this.kdf = kdf;
        this.out.print("Initializing AACS... ");
        try {
            this.aes_128d = Cipher.getInstance("AES/ECB/NOPADDING");
            this.aes_128cbcd = Cipher.getInstance("AES/CBC/NOPADDING");
            this.sha1 = MessageDigest.getInstance("SHA-1");
            this.packDecrypter = new PackDecrypter(2, 30);
        }
        catch (GeneralSecurityException e) {
            this.out.println("FAILED");
            throw new AACSException(e.getMessage(), e);
        }
        this.out.println("OK");
        this.out.print("Loading aacskeys library... ");
        try {
            this.akl = new AACSKeys(mp);
            this.out.println("OK");
            this.out.println(this.akl.getVersionString());
        }
        catch (AACSException e) {
            this.out.println("FAILED");
            this.out.println(e.getMessage());
            this.out.println("Direct key retrieval disabled, only keys from the database will be used");
        }
    }

    public void init(DiscSet ds) throws AACSException {
        if (ds.keyData == null) {
            throw new AACSException("DiscSet contains no key data");
        }
        this.ds = ds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void identifyDisc(DiscSet ds) throws AACSException {
        block46: {
            ds.selected = false;
            this.out.print("Identifying disc... ");
            if (ds.aacsDir == null) {
                this.out.println("FAILED");
                throw new AACSException("AACS directory not found");
            }
            File idFile = null;
            switch (ds.contentType) {
                case 1: {
                    idFile = new File(ds.aacsDir, "VTKF.AACS");
                    break;
                }
                case 2: {
                    idFile = new File(ds.aacsDir, "ATKF.AACS");
                    break;
                }
                case 3: {
                    LinkedList<String> idFileList = new LinkedList<String>();
                    Utils.scanForFilenames(ds.aacsDir, ds.aacsDir.getPath(), idFileList, false, new SimpleFilenameFilter("VTKF[0-9]{3}.AACS", false, false), true);
                    if (idFileList.isEmpty()) break;
                    Collections.sort(idFileList);
                    idFile = new File(idFileList.getFirst());
                    break;
                }
                case 4: {
                    LinkedList<String> idFileList = new LinkedList();
                    Utils.scanForFilenames(ds.aacsDir, ds.aacsDir.getPath(), idFileList, false, new SimpleFilenameFilter("ATKF[0-9]{3}.AACS", false, false), true);
                    if (idFileList.isEmpty()) break;
                    Collections.sort(idFileList);
                    idFile = new File(idFileList.getFirst());
                    break;
                }
                case 5: {
                    idFile = new File(ds.aacsDir, "Unit_Key_RO.inf");
                    break;
                }
                case 6: 
                case 7: {
                    idFile = new File(ds.aacsDir, "Unit_Key_RW.inf");
                    break;
                }
                default: {
                    this.out.println("FAILED");
                    throw new AACSException("Unknown disc type: " + ds.contentType);
                }
            }
            if (!idFile.isFile()) {
                this.out.println("FAILED");
                throw new AACSException("DiscID file not found: " + idFile.getPath());
            }
            this.sha1.reset();
            FileSource idSource = null;
            try {
                idSource = new FileSource(idFile, 0);
                long remaining = idSource.size();
                while (remaining > 0L) {
                    if (remaining > (long)Utils.buffer.length) {
                        if (idSource.read(Utils.buffer, 0, Utils.buffer.length) != Utils.buffer.length) {
                            throw new IOException("Unexpected EOF");
                        }
                        this.sha1.update(Utils.buffer, 0, Utils.buffer.length);
                        remaining -= (long)Utils.buffer.length;
                        continue;
                    }
                    if (idSource.read(Utils.buffer, 0, (int)remaining) != (int)remaining) {
                        throw new IOException("Unexpected EOF");
                    }
                    this.sha1.update(Utils.buffer, 0, (int)remaining);
                    remaining = 0L;
                }
            }
            catch (IOException e) {
                this.out.println("FAILED");
                if (idSource == null) throw new AACSException(e.getMessage(), e);
                try {
                    idSource.close();
                    throw new AACSException(e.getMessage(), e);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new AACSException(e.getMessage(), e);
            }
            byte[] discId = this.sha1.digest();
            this.out.println("OK");
            this.out.println("DiscID : " + Utils.toHexString(discId, 0, 20));
            this.out.println("Searching disc in key database...");
            try {
                ds.keyData = this.kdf.getKeyData(discId, 0);
                if (ds.keyData != null) {
                    this.out.println("Disc found in key database");
                }
            }
            catch (IOException e) {
                this.out.println(e.getMessage());
                ds.keyData = null;
            }
            if (ds.keyData == null) {
                ds.keyData = new KeyData(discId, 0);
                if (this.akl == null) throw new AACSException("Disc not found in key database");
                this.out.println("Disc not found in key database");
                this.out.println("Retrieving keys from source... ");
                try {
                    this.akl.getKeys(ds.srcDir.getPath(), ds.keyData);
                    this.out.println();
                    this.out.println("Keys successfully retrieved from source");
                    if (ds.keyData.getTitle() == null) {
                        ds.keyData.setTitle("Movie Title");
                    }
                    if (ds.keyData.getDate() == null) {
                        try {
                            long lastModified = idFile.lastModified();
                            if (lastModified != 0L) {
                                ds.keyData.setDate(new Date(lastModified));
                            }
                        }
                        catch (SecurityException lastModified) {
                            // empty catch block
                        }
                    }
                    this.out.println("Saving keys in key database...");
                    KeyData result = null;
                    try {
                        result = ds.bdplus ? this.kdf.appendKeyData(ds.keyData, ds.isBluRay(), ds.isRecordable(), this.kdf.getSmartMode(ds.keyData) | 0x10) : this.kdf.appendKeyData(ds.keyData, ds.isBluRay(), ds.isRecordable());
                    }
                    catch (IOException e) {
                        this.out.println(e.getMessage());
                        result = null;
                    }
                    if (result != null) {
                        this.out.println("Keys saved in key database");
                    }
                    this.out.println("Failed saving keys in key database");
                }
                catch (AACSException e) {
                    this.out.println();
                    this.out.println(e.getMessage());
                    throw new AACSException("Failed retrieving keys from source");
                }
            } else if (ds.bdplus && ds.keyData.getVid() == null) {
                this.out.println("Disc is BD+ protected and the Volume ID is not present in the key database");
                if (this.akl != null) {
                    this.out.println("Retrieving keys from source...");
                    try {
                        this.akl.getKeys(ds.srcDir.getPath(), ds.keyData);
                        this.out.println();
                        this.out.println("Keys successfully retrieved from source");
                        if (ds.keyData.getTitle() == null) {
                            ds.keyData.setTitle("Movie Title");
                        }
                        if (ds.keyData.getDate() == null) {
                            try {
                                long lastModified = idFile.lastModified();
                                if (lastModified != 0L) {
                                    ds.keyData.setDate(new Date(lastModified));
                                }
                            }
                            catch (SecurityException lastModified) {
                                // empty catch block
                            }
                        }
                        this.out.println("Saving keys in key database...");
                        KeyData result = null;
                        try {
                            result = this.kdf.setKeyData(ds.keyData, ds.isBluRay(), ds.isRecordable(), true, this.kdf.getSmartMode(ds.keyData) | 0x10);
                        }
                        catch (IOException e) {
                            this.out.println(e.getMessage());
                            result = null;
                        }
                        if (result != null) {
                            this.out.println("Keys saved in key database");
                            break block46;
                        }
                        this.out.println("Failed saving keys in key database");
                    }
                    catch (AACSException e) {
                        this.out.println();
                        this.out.println(e.getMessage());
                        this.out.println("Warning! Failed retrieving keys from source");
                    }
                } else {
                    this.out.println("Warning! Direct key retrieval disabled, cannot retrieve Volume ID");
                }
            }
        }
        ds.selected = true;
    }

    /*
     * Unable to fully structure code
     */
    public void initDisc(DiscSet ds) throws AACSException {
        block95: {
            block92: {
                block93: {
                    block94: {
                        this.out.print("Processing disc AACS data... ");
                        if (ds.keyData == null) break block92;
                        calculatedPak = false;
                        if (ds.keyData.pakCount() < 1) {
                            calculatedPak = true;
                            this.out.print("\nNo Volume Unique Key / Protected Area Keys present, calculating them... ");
                            mek = ds.keyData.getMek();
                            if (mek != null && ds.keyData.bnCount() > 0) {
                                try {
                                    mekKey = new SecretKeySpec(mek, "AES");
                                    for (int index : ds.keyData.bnIdx()) {
                                        bn = ds.keyData.getBn(index);
                                        System.arraycopy(bn, 0, Utils.buffer, 0, bn.length);
                                        this.aes_128d.init(2, mekKey);
                                        this.aes_128d.doFinal(Utils.buffer, 0, mek.length, Utils.buffer, 0);
                                        i = 0;
                                        while (i < mek.length) {
                                            Utils.buffer[i] = (byte)(Utils.buffer[i] ^ bn[i]);
                                            ++i;
                                        }
                                        ds.keyData.setPak(index, Utils.buffer, 0);
                                    }
                                    this.out.println("OK");
                                }
                                catch (GeneralSecurityException e) {
                                    this.out.println("FAILED");
                                    this.out.println(e.getMessage());
                                }
                            } else {
                                this.out.println("FAILED");
                                this.out.println("Not enough data present to calculate a Volume Unique Key / Protected Area Keys");
                            }
                        }
                        if (ds.keyData.pakCount() <= 0) break block93;
                        if (!calculatedPak) {
                            this.out.println("\nVolume Unique Key / Protected Area Keys present, decrypting Title Keys / CPS Unit Keys... ");
                        }
                        this.out.println("Searching Title Key / CPS Unit Key Files... ");
                        keyFile = null;
                        keyFilenames = new LinkedList<String>();
                        switch (ds.contentType) {
                            case 1: {
                                keyFile = new File(ds.aacsDir, "VTKF.AACS");
                                if (!keyFile.isFile()) break;
                                keyFilenames.add(keyFile.getPath());
                                break;
                            }
                            case 2: {
                                keyFile = new File(ds.aacsDir, "ATKF.AACS");
                                if (!keyFile.isFile()) break;
                                keyFilenames.add(keyFile.getPath());
                                break;
                            }
                            case 3: {
                                Utils.scanForFilenames(ds.aacsDir, ds.aacsDir.getPath(), keyFilenames, false, new SimpleFilenameFilter("VTKF[0-9]{3}.AACS", false, false), false);
                                if (keyFilenames.isEmpty()) break;
                                Collections.sort(keyFilenames);
                                break;
                            }
                            case 4: {
                                Utils.scanForFilenames(ds.aacsDir, ds.aacsDir.getPath(), keyFilenames, false, new SimpleFilenameFilter("ATKF[0-9]{3}.AACS", false, false), false);
                                if (keyFilenames.isEmpty()) break;
                                Collections.sort(keyFilenames);
                                break;
                            }
                            case 5: {
                                keyFile = new File(ds.aacsDir, "Unit_Key_RO.inf");
                                if (!keyFile.isFile()) break;
                                keyFilenames.add(keyFile.getPath());
                                break;
                            }
                            case 6: 
                            case 7: {
                                keyFile = new File(ds.aacsDir, "Unit_Key_RW.inf");
                                if (!keyFile.isFile()) break;
                                keyFilenames.add(keyFile.getPath());
                                break;
                            }
                            default: {
                                this.out.println("FAILED");
                                throw new AACSException("Unknown disc type: " + ds.contentType);
                            }
                        }
                        if (keyFilenames.isEmpty()) break block94;
                        keySource = null;
                        vuk = ds.keyData.getVuk();
                        vukKey = new SecretKeySpec(vuk, "AES");
                        switch (ds.contentType) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                for (String fileName : keyFilenames) {
                                    this.out.print("Decrypting " + fileName + "... ");
                                    try {
                                        keySource = new FileSource(new File(fileName), 0);
                                        if (keySource.size() < 2480L) ** GOTO lbl109
                                        if (keySource.read(Utils.buffer, 0, 2480) != 2480) {
                                            throw new IOException("Unexpected EOF");
                                        }
                                        if (!new String(Utils.buffer, 0, "DVD_HD_V_TKF".length(), "US-ASCII").equals("DVD_HD_V_TKF")) ** GOTO lbl108
                                        if (ByteArray.getVarLong(Utils.buffer, "DVD_HD_V_TKF".length(), 4) != 2480L) ** GOTO lbl107
                                        if (ByteArray.getUShort(Utils.buffer, 32) > 0) ** GOTO lbl106
                                        pos = 128;
                                        i = 1;
                                        while (i <= 64) {
                                            if ((ByteArray.getUByte(Utils.buffer, pos) & 128) == 128) {
                                                this.aes_128d.init(2, vukKey);
                                                this.aes_128d.doFinal(Utils.buffer, pos + 4, vuk.length, Utils.buffer, 0);
                                                ds.keyData.setTuk(i, Utils.buffer, 0);
                                            }
                                            pos += 36;
                                            ++i;
                                        }
                                        this.out.println("OK");
                                        ** GOTO lbl140
lbl106:
                                        // 1 sources

                                        throw new AACSException("Unsupported version");
lbl107:
                                        // 1 sources

                                        throw new AACSException("Wrong file size stated in HD_VTKF_SIZE");
lbl108:
                                        // 1 sources

                                        throw new AACSException("Wrong TKF_ID");
lbl109:
                                        // 1 sources

                                        throw new AACSException("File too small to be a Title Key File");
                                    }
                                    catch (IOException e) {
                                        this.out.println("FAILED");
                                        this.out.println(e.getMessage());
                                        try {
                                            keySource.close();
                                        }
                                        catch (IOException var13_21) {}
                                        continue;
                                    }
                                    catch (AACSException e2) {
                                        this.out.println("FAILED");
                                        this.out.println(e2.getMessage());
                                        continue;
                                    }
                                    catch (GeneralSecurityException e3) {
                                        this.out.println("FAILED");
                                        this.out.println(e3.getMessage());
                                        {
                                            catch (Throwable var12_30) {
                                                throw var12_30;
                                            }
                                        }
                                        try {
                                            keySource.close();
                                        }
                                        catch (IOException var13_23) {}
                                        continue;
                                    }
                                    {
                                        finally {
                                            try {
                                                keySource.close();
                                            }
                                            catch (IOException var13_22) {}
                                        }
                                    }
lbl140:
                                    // 1 sources

                                    try {
                                        keySource.close();
                                    }
                                    catch (IOException var13_25) {
                                        // empty catch block
                                    }
                                }
                                if (ds.keyData.tukCount() == 0) {
                                    throw new AACSException("Could not decrypt any Title Key, no decrypted Title Keys present");
                                }
                                this.out.println("Updated disc data:");
                                this.out.println(ds.keyData.toString());
                                this.out.print("Searching Sequence Key Block File... ");
                                if (new File(ds.aacsDir, "SKB.AACS").isFile()) {
                                    this.out.println("ERROR");
                                    this.out.println("Sequence Key Block File found! Cannot process Sequence Keys, dumping may fail!");
                                    break;
                                }
                                this.out.println("OK");
                                this.out.println("Sequence Key Block File not found (this is good)");
                                break;
                            }
                            case 5: 
                            case 6: 
                            case 7: {
                                keyBlockOffset = 0L;
                                bdDirectoryWarning = false;
                                skbWarning = false;
                                try {
                                    this.out.println("Decrypting " + keyFilenames.getFirst() + "... ");
                                    keySource = new FileSource(new File(keyFilenames.getFirst()), 0);
                                    if (keySource.read(Utils.buffer, 0, 20) != 20) {
                                        throw new IOException("Unexpected EOF");
                                    }
                                    keyBlockOffset = ByteArray.getVarLong(Utils.buffer, 0, 4);
                                    if (ByteArray.getUByte(Utils.buffer, 16) != AACSDecrypter.BD_APPLICATION_TYPES.get(ds.contentType)) ** GOTO lbl251
                                    bdDirectories = ByteArray.getUByte(Utils.buffer, 17);
                                    if (bdDirectories < 1) ** GOTO lbl250
                                    if (ds.contentType == 5 && ByteArray.getUByte(Utils.buffer, 18) >>> 7 == 1) {
                                        skbWarning = true;
                                    }
                                    if (ds.contentType != 7 && bdDirectories > 1) {
                                        bdDirectories = 1;
                                        bdDirectoryWarning = true;
                                    }
                                    tcs = 0;
                                    i = 0;
                                    while (i < bdDirectories) {
                                        if (keySource.read(Utils.buffer, 0, 6) != 6) {
                                            throw new IOException("Unexpected EOF");
                                        }
                                        if (ds.contentType != 6) {
                                            tmp = ByteArray.getUShort(Utils.buffer, 0);
                                            if (tmp != 0) {
                                                ds.keyData.setHeadUnit(i, 0, tmp);
                                            }
                                            if ((tmp = ByteArray.getUShort(Utils.buffer, 2)) != 0) {
                                                ds.keyData.setHeadUnit(i, 1, tmp);
                                            }
                                        }
                                        tcs = ByteArray.getUShort(Utils.buffer, 4);
                                        j = 1;
                                        while (j <= tcs) {
                                            if (keySource.read(Utils.buffer, 0, 4) != 4) {
                                                throw new IOException("Unexpected EOF");
                                            }
                                            if (ds.contentType != 5) {
                                                ds.keyData.setTcUnit(i, ByteArray.getUShort(Utils.buffer, 0), ByteArray.getUShort(Utils.buffer, 2));
                                            } else {
                                                ds.keyData.setTcUnit(i, j, ByteArray.getUShort(Utils.buffer, 2));
                                            }
                                            ++j;
                                        }
                                        ++i;
                                    }
                                    keySource.setPosition(keyBlockOffset);
                                    if (keySource.read(Utils.buffer, 0, 16) != 16) {
                                        throw new IOException("Unexpected EOF");
                                    }
                                    cpsUnits = ByteArray.getUShort(Utils.buffer, 0);
                                    ukey = new byte[16];
                                    hbuf = new byte[AACSDecrypter.h0.length];
                                    unit = 1;
                                    while (unit <= cpsUnits) {
                                        if (keySource.read(Utils.buffer, 0, 48) != 48) {
                                            throw new IOException("Unexpected EOF");
                                        }
                                        this.aes_128d.init(2, vukKey);
                                        this.aes_128d.doFinal(Utils.buffer, 32, vuk.length, Utils.buffer, 0);
                                        if (ds.contentType != 5) {
                                            System.arraycopy(Utils.buffer, 0, ukey, 0, ukey.length);
                                            System.arraycopy(AACSDecrypter.h0, 0, hbuf, 0, AACSDecrypter.h0.length);
                                            try {
                                                ur = new FileSource(new File(ds.aacsDir, String.format("CPSUnit%1$05d.cci", new Object[]{unit})), 0);
                                                while (ur.read(Utils.buffer, 0, hbuf.length) != -1) {
                                                    aeskey = new SecretKeySpec(Utils.buffer, 0, hbuf.length, "AES");
                                                    this.aes_128d.init(2, aeskey);
                                                    this.aes_128d.doFinal(hbuf, 0, hbuf.length, Utils.buffer, 0);
                                                    i = 0;
                                                    while (i < hbuf.length) {
                                                        hbuf[i] = (byte)(Utils.buffer[i] ^ hbuf[i]);
                                                        ++i;
                                                    }
                                                }
                                                i = 0;
                                                while (i < ukey.length) {
                                                    ukey[i] = (byte)(ukey[i] ^ hbuf[i]);
                                                    ++i;
                                                }
                                                ds.keyData.setTuk(unit, ukey, 0);
                                            }
                                            catch (IOException e1) {
                                                this.out.println("Failed decrypting CPS Unit Key: " + unit);
                                                this.out.println(e1.getMessage());
                                            }
                                            catch (GeneralSecurityException e2) {
                                                this.out.println("Failed decrypting CPS Unit Key: " + unit);
                                                this.out.println(e2.getMessage());
                                            }
                                        } else {
                                            ds.keyData.setTuk(unit, Utils.buffer, 0);
                                        }
                                        ++unit;
                                    }
                                    this.out.println("Finished decrypting CPS Unit Keys");
                                    ** GOTO lbl282
lbl250:
                                    // 1 sources

                                    throw new AACSException("Invalid number of BD Directories: " + bdDirectories);
lbl251:
                                    // 1 sources

                                    throw new AACSException("Wrong Application Type, expected: " + AACSDecrypter.BD_APPLICATION_TYPES.get(ds.contentType) + ", got: " + ByteArray.getUByte(Utils.buffer, 16));
                                }
                                catch (IOException e1) {
                                    this.out.println("Failed decrypting CPS Unit Keys");
                                    this.out.println(e1.getMessage());
                                    try {
                                        keySource.close();
                                    }
                                    catch (IOException var23_44) {}
                                    ** GOTO lbl287
                                }
                                catch (AACSException e2) {
                                    this.out.println("Failed decrypting CPS Unit Keys");
                                    this.out.println(e2.getMessage());
                                    ** GOTO lbl287
                                }
                                catch (GeneralSecurityException e3) {
                                    this.out.println("Failed decrypting CPS Unit Keys");
                                    this.out.println(e3.getMessage());
                                    {
                                        catch (Throwable var22_49) {
                                            throw var22_49;
                                        }
                                    }
                                    try {
                                        keySource.close();
                                    }
                                    catch (IOException var23_46) {}
                                    ** GOTO lbl287
                                }
                                {
                                    finally {
                                        try {
                                            keySource.close();
                                        }
                                        catch (IOException var23_45) {}
                                    }
                                }
lbl282:
                                // 1 sources

                                try {
                                    keySource.close();
                                }
                                catch (IOException var23_48) {
                                    // empty catch block
                                }
lbl287:
                                // 7 sources

                                if (bdDirectoryWarning) {
                                    this.out.println("WARNING! More than one BD Directory specified, ignored the following ones");
                                }
                                if (ds.keyData.tukCount() == 0) {
                                    throw new AACSException("Could not decrypt any CPS Unit Key, no decrypted CPS Unit Keys present");
                                }
                                this.out.println("Updated disc data:");
                                this.out.println(ds.keyData.toString());
                                if (skbWarning) {
                                    this.out.println("ERROR! Sequence Key Block found! Cannot process Sequence Keys, dumping may fail!");
                                    break;
                                }
                                this.out.println("Sequence Key Block not found (this is good)");
                                break;
                            }
                            default: {
                                this.out.println("FAILED");
                                throw new AACSException("Unknown disc type: " + ds.contentType);
                            }
                        }
                        this.out.println("AACS data processed");
                        break block95;
                    }
                    this.out.println("No Title Key / CPS Unit Key Files Found");
                    if (ds.keyData.tukCount() == 0) {
                        throw new AACSException("Could not decrypt Title Keys / CPS Unit Keys, no decrypted Title Keys / CPS Unit Keys present");
                    }
                    break block95;
                }
                if (ds.keyData.tukCount() == 0) {
                    this.out.println("FAILED");
                    throw new AACSException("No Volume Unique Key / Protected Area Keys present, no decrypted Title Keys / CPS Unit Keys present");
                }
                this.out.println("OK");
                break block95;
            }
            this.out.println("FAILED");
            throw new AACSException("No Key Data present");
        }
    }

    public Collection<MultiplexedArf> decryptEvob(ByteSource input, ByteSource output) throws AACSException, IOException {
        if (this.ds == null) {
            throw new AACSException("AACSDecrypter not initialized");
        }
        PESPack pack = new PESPack();
        long position = 0L;
        long baseAddress = 0L;
        int key_vf = 0;
        int packKeyPtr = 0;
        int currentKeyPtr = 0;
        byte[] npk = null;
        boolean firstRead = true;
        int read = 0;
        int readOffset = 0;
        int readAmount = this.packBuffer.length;
        int packGuardReadOffset = 0;
        int writeOffset = 0;
        int writeAmount = 61440;
        int packGuardCheckAmount = 30;
        int packGuardWriteOffset = 0;
        Semaphore[] packGuard = new Semaphore[this.packBuffer.length / 2048];
        int i = 0;
        while (i < packGuard.length) {
            packGuard[i] = new Semaphore(0, false);
            ++i;
        }
        MultiplexedArf[] arfs = new MultiplexedArf[256];
        int i2 = 0;
        while (i2 < arfs.length) {
            arfs[i2] = null;
            ++i2;
        }
        MultiplexedArf currentArf = null;
        LinkedList<MultiplexedArf> arfList = new LinkedList<MultiplexedArf>();
        this.packDecrypter.init(this.packBuffer, packGuard, null);
        this.packDecrypter.updateBaseAddress(baseAddress);
        while ((read = input.read(this.packBuffer, readOffset, readAmount)) != -1) {
            int endOffset = readOffset + read;
            while (readOffset < endOffset) {
                try {
                    pack.parse(this.packBuffer, readOffset, false);
                    if (pack.isNavPck()) {
                        key_vf = this.packBuffer[readOffset + 60] & 0xC0;
                        if (key_vf == 128) {
                            packKeyPtr = this.packBuffer[readOffset + 62] & 0xFF;
                            if (packKeyPtr != currentKeyPtr) {
                                if (packKeyPtr > 0 && packKeyPtr <= 64) {
                                    this.out.println(String.format("0x%1$010X Key change, new key: Title Key #%2$d", position, packKeyPtr));
                                    currentKeyPtr = packKeyPtr;
                                    npk = this.ds.keyData.getTuk(currentKeyPtr);
                                    if (npk == null) {
                                        this.out.println(String.format("0x%1$010X ERROR! Required Title Key not present: #%2$d", position, currentKeyPtr));
                                    } else {
                                        this.packDecrypter.updateKey(npk, false);
                                    }
                                } else {
                                    this.out.println(String.format("0x%1$010X ERROR! Key change, new Title Key pointer invalid, ignoring #%2$d", position, packKeyPtr));
                                }
                            }
                        } else if (key_vf == 64) {
                            packKeyPtr = this.packBuffer[readOffset + 63] & 0xFF;
                            if (packKeyPtr != currentKeyPtr) {
                                if (packKeyPtr > 0 && packKeyPtr <= 192) {
                                    this.out.println(String.format("0x%1$010X Key change, new key: Sequence Key #%2$d", position, packKeyPtr));
                                    currentKeyPtr = packKeyPtr;
                                    this.out.println("### !ERROR! Sequence Keys not supported, skipping decryption !ERROR! ###");
                                    npk = null;
                                } else {
                                    this.out.println(String.format("0x%1$010X ERROR! Key change, new Sequence Key pointer invalid, ignoring #%2$d", position, packKeyPtr));
                                }
                            }
                        } else if (key_vf == 0) {
                            if (currentKeyPtr != 0) {
                                this.out.println(String.format("0x%1$010X Warning! No Key valid, disabling decryption", position));
                                currentKeyPtr = 0;
                                npk = null;
                            }
                        } else if (currentKeyPtr != Integer.MAX_VALUE) {
                            this.out.println(String.format("0x%1$010X Warning! Reserved Key Validity Flag, disabling decryption", position));
                            currentKeyPtr = Integer.MAX_VALUE;
                            npk = null;
                        }
                        this.packDecrypter.updateCpi(readOffset);
                        ByteArray.setInt(this.packBuffer, readOffset + 60, 0);
                        ByteArray.setShort(this.packBuffer, readOffset + 68, Short.MAX_VALUE);
                        ByteArray.setInt(this.packBuffer, readOffset + 70, 61440);
                        packGuard[packGuardReadOffset].release();
                    } else if (pack.isScrambled()) {
                        if (npk != null) {
                            pack.setScrambled(false);
                            this.packDecrypter.decryptPack(readOffset);
                        } else {
                            packGuard[packGuardReadOffset].release();
                        }
                    } else if (pack.isAdvPck()) {
                        int payloadOffset = pack.getPacket(0).payloadOffset();
                        int payloadLength = pack.getPacket(0).getPayloadLength();
                        if (payloadLength >= 3) {
                            int packetType = ByteArray.getUByte(this.packBuffer, payloadOffset);
                            int packetId = ByteArray.getUByte(this.packBuffer, payloadOffset + 1);
                            if (packetType == 0) {
                                currentArf = arfs[packetId];
                                if (currentArf != null) {
                                    currentArf.addData(position, payloadOffset + 3 - readOffset, payloadLength - 3);
                                } else {
                                    this.out.println(String.format("0x%1$010X Error! INTERMEDIATE_PACKET for not opened ARF ID? 0x%2$02X found, ignoring", position, packetId));
                                }
                            } else if (packetType == 16) {
                                if (arfs[packetId] == null) {
                                    if (payloadLength >= 258) {
                                        int nameStringEndOffset = payloadOffset + 2;
                                        int maxNameStringOffset = payloadOffset + 258;
                                        while (nameStringEndOffset < maxNameStringOffset) {
                                            if (this.packBuffer[nameStringEndOffset] == 0) break;
                                            ++nameStringEndOffset;
                                        }
                                        try {
                                            String arfName = new String(this.packBuffer, payloadOffset + 2, nameStringEndOffset - (payloadOffset + 2), "US-ASCII");
                                            this.out.println(String.format("0x%1$010X Multiplexed ARF found, ID?: 0x%2$02X, filename: %3$s", position, packetId, arfName));
                                            currentArf = new MultiplexedArf(arfName, output, false);
                                            currentArf.addData(position, payloadOffset + 258 - readOffset, payloadLength - 258);
                                            arfs[packetId] = currentArf;
                                        }
                                        catch (UnsupportedEncodingException e) {
                                            this.out.println(String.format("0x%1$010X ERROR! Could not decode filename for ARF ID? 0x%2$02X, ignoring", position, packetId));
                                        }
                                    } else {
                                        this.out.println(String.format("0x%1$010X Warning! Broken START_PACKET packet found for ARF ID? 0x%2$02X, payload too small for filename field, ignoring", position, packetId));
                                    }
                                } else {
                                    this.out.println(String.format("0x%1$010X ERROR! START_PACKET for already opened ARF ID? 0x%2$02X found, ignoring", position, packetId));
                                }
                            } else if (packetType == 32) {
                                currentArf = arfs[packetId];
                                if (currentArf != null) {
                                    currentArf.addData(position, payloadOffset + 3 - readOffset, payloadLength - 3);
                                    currentArf.markComplete();
                                    arfList.add(currentArf);
                                    arfs[packetId] = null;
                                } else {
                                    this.out.println(String.format("0x%1$010X ERROR! END_PACKET for not opened ARF ID? 0x%2$02X found, ignoring", position, packetId));
                                }
                            } else {
                                this.out.println(String.format("0x%1$010X Warning! Unknown ARF packet type 0x%2$02X for ARF ID? 0x%3$02X found, ignoring", position, packetType, packetId));
                            }
                        } else {
                            this.out.println(String.format("0x%1$010X Warning! Broken ARF packet found, payload too small, ignoring", position));
                        }
                        packGuard[packGuardReadOffset].release();
                    } else {
                        packGuard[packGuardReadOffset].release();
                    }
                }
                catch (PESParserException e) {
                    this.out.println(String.format("0x%1$010X ERROR! PES parser exception: %2$s", position, e.getMessage()));
                    packGuard[packGuardReadOffset].release();
                }
                if (++packGuardReadOffset == packGuard.length) {
                    packGuardReadOffset = 0;
                }
                position += 2048L;
                readOffset += 2048;
            }
            if (readOffset == this.packBuffer.length) {
                readOffset = 0;
                this.packDecrypter.updateBaseAddress(baseAddress += (long)this.packBuffer.length);
            }
            if (firstRead) {
                firstRead = false;
                if (read == this.packBuffer.length) {
                    readAmount = 61440;
                } else {
                    writeAmount = read;
                    packGuardCheckAmount = read / 2048;
                }
            }
            endOffset = packGuardWriteOffset + packGuardCheckAmount;
            while (packGuardWriteOffset < endOffset) {
                try {
                    packGuard[packGuardWriteOffset].acquire();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++packGuardWriteOffset;
            }
            if (packGuardWriteOffset == packGuard.length) {
                packGuardWriteOffset = 0;
            }
            output.write(this.packBuffer, writeOffset, writeAmount);
            if ((writeOffset += writeAmount) != this.packBuffer.length) continue;
            writeOffset = 0;
        }
        this.packDecrypter.waitForDecryption();
        writeAmount = 0;
        while (packGuard[packGuardWriteOffset].tryAcquire()) {
            writeAmount += 2048;
            if (++packGuardWriteOffset == packGuard.length) break;
        }
        output.write(this.packBuffer, writeOffset, writeAmount);
        int i3 = 0;
        while (i3 < arfs.length) {
            currentArf = arfs[i3];
            if (currentArf != null) {
                arfs[i3] = null;
                this.out.println(String.format("Warning! Remaining open ARF with ID? 0x%1$02X found, enforcing close", i3));
                currentArf.markComplete();
                arfList.add(currentArf);
            }
            ++i3;
        }
        return arfList;
    }

    public CopyResult decryptArf(ByteSource input, ByteSource output) throws AACSException, IOException {
        if (this.ds == null) {
            throw new AACSException("AACSDecrypter not initialized");
        }
        byte[] data = Utils.buffer;
        String fileId = null;
        int protectionType = 0;
        int titleKeyPtr = 0;
        long resourceFileSize = 0L;
        if (input.read(data, 0, 11) == 11 && (fileId = new String(data, 0, idStringAACS.length(), "US-ASCII")).equals(idStringAACS)) {
            protectionType = ByteArray.getUByte(data, 4);
            titleKeyPtr = ByteArray.getUByte(data, 6);
            resourceFileSize = ByteArray.getVarLong(data, 7, 4);
            if (resourceFileSize + 272L <= input.size()) {
                input.read(data, 0, 272);
                switch (protectionType) {
                    case 1: 
                    case 17: {
                        if (titleKeyPtr > 0 && titleKeyPtr <= 64) {
                            long written = 0L;
                            byte[] tk = this.ds.keyData.getTuk(titleKeyPtr);
                            if (tk != null) {
                                SecretKeySpec tkKey = new SecretKeySpec(tk, "AES");
                                try {
                                    this.aes_128cbcd.init(2, (Key)tkKey, cbc_iv_spec);
                                    this.aes_128cbcd.update(data, 0, 272, data, 0);
                                    this.crc32Calc.reset();
                                    int readResult = 0;
                                    int writeResult = 0;
                                    while (written < resourceFileSize) {
                                        long writeAmount = resourceFileSize - written;
                                        if (writeAmount < (long)data.length) {
                                            readResult = input.read(data, 0, (int)writeAmount);
                                            if (readResult != (int)writeAmount) {
                                                throw new IOException("Could not read the requested number of bytes");
                                            }
                                            int residual = (int)writeAmount % 16;
                                            if (residual > 0) {
                                                this.aes_128cbcd.doFinal(data, 0, (int)writeAmount - residual, data, 0);
                                            } else {
                                                this.aes_128cbcd.doFinal(data, 0, (int)writeAmount, data, 0);
                                            }
                                            writeResult = output.write(data, 0, (int)writeAmount);
                                            if (writeResult != (int)writeAmount) {
                                                throw new IOException("Could not write the requested number of bytes");
                                            }
                                            written += (long)((int)writeAmount);
                                            this.crc32Calc.update(data, 0, (int)writeAmount);
                                            continue;
                                        }
                                        readResult = input.read(data, 0, data.length);
                                        if (readResult != data.length) {
                                            throw new IOException("Could not read the requested number of bytes");
                                        }
                                        this.aes_128cbcd.update(data, 0, data.length, data, 0);
                                        writeResult = output.write(data, 0, data.length);
                                        if (writeResult != data.length) {
                                            throw new IOException("Could not write the requested number of bytes");
                                        }
                                        written += (long)data.length;
                                        this.crc32Calc.update(data, 0, data.length);
                                    }
                                }
                                catch (GeneralSecurityException e) {
                                    throw new AACSException(e.getMessage(), e);
                                }
                            } else {
                                throw new AACSException("Title Key #" + titleKeyPtr + " not found");
                            }
                            return new CopyResult(written, this.crc32Calc.getValue());
                        }
                        throw new AACSException("Invalid Title Key Pointer #" + titleKeyPtr);
                    }
                    case 2: 
                    case 18: 
                    case 33: {
                        return Utils.copyBs(input, output, resourceFileSize);
                    }
                }
                throw new AACSException("Unknown protection type");
            }
            throw new AACSException("Physical filesize smaller than AACS filesize");
        }
        input.setPosition(0L);
        return Utils.copyBs(input, output, input.size());
    }

    public void decryptTs(ByteSource input, ByteSource output, byte[] key, SubTable subTable) throws AACSException, IOException {
        if (this.ds == null) {
            throw new AACSException("AACSDecrypter not initialized");
        }
        TSAlignedUnit unit = new TSAlignedUnit();
        long position = 0L;
        long baseAddress = 0L;
        int decryptionState = -1;
        boolean firstRead = true;
        int read = 0;
        int readOffset = 0;
        int readAmount = this.packBuffer.length;
        int packGuardReadOffset = 0;
        int writeOffset = 0;
        int writeAmount = 61440;
        int packGuardCheckAmount = 10;
        int packGuardWriteOffset = 0;
        Semaphore[] packGuard = new Semaphore[this.packBuffer.length / 6144];
        int i = 0;
        while (i < packGuard.length) {
            packGuard[i] = new Semaphore(0, false);
            ++i;
        }
        this.packDecrypter.init(this.packBuffer, packGuard, subTable);
        this.packDecrypter.updateBaseAddress(baseAddress);
        if (key == null) {
            this.out.print("Searching CPS Unit Key... ");
            int index = this.findTsKey(input);
            if (index < 0) {
                this.out.println("ERROR");
                if (index == -2) {
                    this.out.println("Failed to determine CPS Unit Key!");
                } else {
                    this.out.println("An error occured while trying to determine the CPS Unit Key!");
                }
            } else if (index == 0) {
                this.out.println("Not encrypted");
            } else {
                this.out.println(String.format("#%1$d", index));
                key = this.ds.keyData.getTuk(index);
            }
        }
        if (key != null) {
            this.packDecrypter.updateKey(key, true);
        }
        while ((read = input.read(this.packBuffer, readOffset, readAmount)) != -1) {
            int endOffset = readOffset + read;
            while (readOffset < endOffset) {
                try {
                    unit.parse(this.packBuffer, readOffset);
                    if (unit.isEncrypted()) {
                        if (decryptionState == 0 || decryptionState == -1) {
                            if (decryptionState == 0) {
                                if (this.ds.contentType == 5) {
                                    this.out.println(String.format("0x%1$010X Warning! Decryption is disabled, enabling decryption", position));
                                } else {
                                    this.out.println(String.format("0x%1$010X Info! Enabling decryption", position));
                                }
                            }
                            decryptionState = 1;
                            if (key != null) {
                                this.out.println(String.format("0x%1$010X Decryption enabled", position));
                            } else {
                                this.out.println(String.format("0x%1$010X ERROR! Required CPS Unit Key / Sequence Key not present", position));
                            }
                        }
                        if (key != null) {
                            this.packDecrypter.decryptAlignedUnit(readOffset, false);
                        } else {
                            packGuard[packGuardReadOffset].release();
                        }
                    } else {
                        if (decryptionState == -1) {
                            decryptionState = 0;
                            this.out.println(String.format("0x%1$010X Decryption disabled", position));
                        } else if (decryptionState == 1) {
                            decryptionState = 0;
                            if (this.ds.contentType == 5) {
                                this.out.println(String.format("0x%1$010X Warning! Decryption is enabled, disabling decryption", position));
                            } else {
                                this.out.println(String.format("0x%1$010X Info! Disabling decryption", position));
                            }
                        }
                        if (subTable != null) {
                            this.packDecrypter.decryptAlignedUnit(readOffset, true);
                        } else {
                            packGuard[packGuardReadOffset].release();
                        }
                    }
                }
                catch (TSParserException e) {
                    this.out.println(String.format("0x%1$010X ERROR! TS parser exception: %2$s", position, e.getMessage()));
                    packGuard[packGuardReadOffset].release();
                }
                if (++packGuardReadOffset == packGuard.length) {
                    packGuardReadOffset = 0;
                }
                position += 6144L;
                readOffset += 6144;
            }
            if (readOffset == this.packBuffer.length) {
                readOffset = 0;
                this.packDecrypter.updateBaseAddress(baseAddress += (long)this.packBuffer.length);
            }
            if (firstRead) {
                firstRead = false;
                if (read == this.packBuffer.length) {
                    readAmount = 61440;
                } else {
                    writeAmount = read;
                    packGuardCheckAmount = read / 6144;
                }
            }
            endOffset = packGuardWriteOffset + packGuardCheckAmount;
            while (packGuardWriteOffset < endOffset) {
                try {
                    packGuard[packGuardWriteOffset].acquire();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++packGuardWriteOffset;
            }
            if (packGuardWriteOffset == packGuard.length) {
                packGuardWriteOffset = 0;
            }
            output.write(this.packBuffer, writeOffset, writeAmount);
            if ((writeOffset += writeAmount) != this.packBuffer.length) continue;
            writeOffset = 0;
        }
        this.packDecrypter.waitForDecryption();
        writeAmount = 0;
        while (packGuard[packGuardWriteOffset].tryAcquire()) {
            writeAmount += 6144;
            if (++packGuardWriteOffset == packGuard.length) break;
        }
        output.write(this.packBuffer, writeOffset, writeAmount);
    }

    public void decryptTdf(ByteSource input, ByteSource output, byte[] key) throws AACSException, IOException {
        if (this.ds == null) {
            throw new AACSException("AACSDecrypter not initialized");
        }
        if (key == null) {
            throw new AACSException("Required CPS Unit Key not present");
        }
        SecretKeySpec cpsKey = new SecretKeySpec(key, "AES");
        byte[] bk = new byte[16];
        SecretKeySpec bkKey = null;
        while (input.read(Utils.buffer, 0, 2048) != -1) {
            try {
                this.aes_128d.init(1, cpsKey);
                this.aes_128d.doFinal(Utils.buffer, 0, bk.length, bk, 0);
                int i = 0;
                while (i < bk.length) {
                    bk[i] = (byte)(bk[i] ^ Utils.buffer[i]);
                    ++i;
                }
                bkKey = new SecretKeySpec(bk, "AES");
                this.aes_128cbcd.init(2, (Key)bkKey, cbc_iv_spec);
                this.aes_128cbcd.doFinal(Utils.buffer, 16, 2032, Utils.buffer, 16);
            }
            catch (GeneralSecurityException e) {
                throw new AACSException(e.getMessage(), e);
            }
            output.write(Utils.buffer, 0, 2048);
        }
    }

    private int findTsKey(ByteSource input) throws IOException {
        SecretKeySpec ckKey;
        byte[] ck;
        SecretKeySpec npkKey;
        byte[] currentKey;
        block10: {
            long currentOffset = input.getPosition();
            int currentIndex = 0;
            currentKey = null;
            TSAlignedUnit unit = new TSAlignedUnit();
            npkKey = null;
            ck = new byte[16];
            ckKey = null;
            input.setPosition(0L);
            if (input.read(Utils.buffer, 0, 6144) != 6144) {
                input.setPosition(currentOffset);
                return 0;
            }
            input.setPosition(currentOffset);
            try {
                unit.parse(Utils.buffer, 0);
                if (unit.isEncrypted()) {
                    System.arraycopy(Utils.buffer, 0, Utils.buffer, 6144, 16);
                    break block10;
                }
                return 0;
            }
            catch (TSParserException ex) {
                return -1;
            }
        }
        try {
            for (int currentIndex : this.ds.keyData.tukIdx()) {
                currentKey = this.ds.keyData.getTuk(currentIndex);
                npkKey = new SecretKeySpec(currentKey, "AES");
                this.aes_128d.init(1, npkKey);
                this.aes_128d.doFinal(Utils.buffer, 0, 16, ck);
                int i = 0;
                while (i < 16) {
                    ck[i] = (byte)(ck[i] ^ Utils.buffer[i]);
                    ++i;
                }
                ckKey = new SecretKeySpec(ck, "AES");
                this.aes_128cbcd.init(2, (Key)ckKey, cbc_iv_spec);
                this.aes_128cbcd.doFinal(Utils.buffer, 16, 6128, Utils.buffer, 6160);
                int found = 0;
                int i2 = 0;
                while (i2 < 32) {
                    if (Utils.buffer[6144 + i2 * 192 + 4] == 71 && ++found > 24) {
                        return currentIndex;
                    }
                    ++i2;
                }
            }
        }
        catch (GeneralSecurityException e) {
            return -1;
        }
        return -2;
    }
}

