/*******************************************************************************
 * Copyright (C) 2003-2006, 2013, Guillaume Brocker
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Guillaume Brocker - Initial API and implementation
 *
 ******************************************************************************/ 

package eclox.core;

import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;


/**
 * Implements the core eclox plugin
 * 
 * @author gbrocker
 */
public class Plugin extends org.eclipse.core.runtime.Plugin {
	
	/**
	 * the default plugin instance
	 */
	private static Plugin plugin;
	

	/**
	 * The constructor.
	 */
	public Plugin() {
		plugin = this;
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}
	
	/**
	 * Returns the shared instance.
	 */
	public static Plugin getDefault() {
		return plugin;
	}
	
	/**
	 * Adds the specified message into the plugin's log as a warning.
	 *  
	 * @param message	a string containing a message to log as a warning
	 */
	public void logWarning( String message ) {
	    getLog().log( new Status(Status.WARNING, getBundle().getSymbolicName(), 0, message, null) );
	}
	
	/**
	 * Adds the specified message into the plugin's log as an error.
	 *  
	 * @param message	a string containing a message to log as an error
	 */
	public void logError( String message ) {
	    getLog().log( new Status(Status.ERROR, getBundle().getSymbolicName(), 0, message, null) );
	}
	
	/**
	 * Adds the specified throwable object into the plugin's log as an error.
	 *  
	 * @param throwable	a throwable instance to log
	 */
	public static void log( Throwable throwable ) {
	    plugin.getLog().log( new Status(Status.ERROR, plugin.getBundle().getSymbolicName(), 0, "Exception caught. " + throwable.toString(), throwable) );
	}
}
