/* PR c/102989 */
/* { dg-do run } */
/* { dg-require-effective-target fenv_exceptions } */
/* { dg-options "-std=c23" } */
/* { dg-add-options ieee } */

#include <fenv.h>

#if __FLT_MANT_DIG__ == 24
#if __BITINT_MAXWIDTH__ >= 135
__attribute__((noipa)) _BitInt(135)
testflt_135 (float d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(135)
testfltu_135 (float d)
{
  return d;
}
#endif

#if __BITINT_MAXWIDTH__ >= 192
__attribute__((noipa)) _BitInt(192)
testflt_192 (float d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(192)
testfltu_192 (float d)
{
  return d;
}
#endif

#if __BITINT_MAXWIDTH__ >= 575
__attribute__((noipa)) _BitInt(575)
testflt_575 (float d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(575)
testfltu_575 (float d)
{
  return d;
}
#endif
#endif

#if __DBL_MANT_DIG__ == 53
#if __BITINT_MAXWIDTH__ >= 135
__attribute__((noipa)) _BitInt(135)
testdbl_135 (double d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(135)
testdblu_135 (double d)
{
  return d;
}
#endif

#if __BITINT_MAXWIDTH__ >= 192
__attribute__((noipa)) _BitInt(192)
testdbl_192 (double d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(192)
testdblu_192 (double d)
{
  return d;
}
#endif

#if __BITINT_MAXWIDTH__ >= 575
__attribute__((noipa)) _BitInt(575)
testdbl_575 (double d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(575)
testdblu_575 (double d)
{
  return d;
}
#endif
#endif

#if __LDBL_MANT_DIG__ == 64
#if __BITINT_MAXWIDTH__ >= 135
__attribute__((noipa)) _BitInt(135)
testldbl_135 (long double d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(135)
testldblu_135 (long double d)
{
  return d;
}
#endif

#if __BITINT_MAXWIDTH__ >= 192
__attribute__((noipa)) _BitInt(192)
testldbl_192 (long double d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(192)
testldblu_192 (long double d)
{
  return d;
}
#endif

#if __BITINT_MAXWIDTH__ >= 575
__attribute__((noipa)) _BitInt(575)
testldbl_575 (long double d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(575)
testldblu_575 (long double d)
{
  return d;
}
#endif
#endif

#if __FLT128_MANT_DIG__ == 113
#if __BITINT_MAXWIDTH__ >= 135
__attribute__((noipa)) _BitInt(135)
testflt128_135 (_Float128 d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(135)
testflt128u_135 (_Float128 d)
{
  return d;
}
#endif

#if __BITINT_MAXWIDTH__ >= 192
__attribute__((noipa)) _BitInt(192)
testflt128_192 (_Float128 d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(192)
testflt128u_192 (_Float128 d)
{
  return d;
}
#endif

#if __BITINT_MAXWIDTH__ >= 575
__attribute__((noipa)) _BitInt(575)
testflt128_575 (_Float128 d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(575)
testflt128u_575 (_Float128 d)
{
  return d;
}
#endif
#endif

__attribute__((noipa)) void
check_invalid (int test, int inv)
{
  if (!test)
    __builtin_abort ();
  if ((!fetestexcept (FE_INVALID)) != (!inv))
    __builtin_abort ();
  feclearexcept (FE_INVALID);
}

int
main ()
{
#if __FLT_MANT_DIG__ == 24
#if __BITINT_MAXWIDTH__ >= 135
  check_invalid (testflt_135 (-85070591730234615865843651857942052864.0f) == -85070591730234615865843651857942052864wb, 0);
  check_invalid (testflt_135 (__builtin_inff ()) == 21778071482940061661655974875633165533183wb, 1);
  check_invalid (testflt_135 (-__builtin_inff ()) == -21778071482940061661655974875633165533183wb - 1wb, 1);
  check_invalid (testflt_135 (__builtin_nanf ("")) == 21778071482940061661655974875633165533183wb, 1);
  check_invalid (testflt_135 (0xffffffp+104f) == 340282346638528859811704183484516925440wb, 0);
  check_invalid (testflt_135 (-0xffffffp+104f) == -340282346638528859811704183484516925440wb, 0);
  check_invalid (testfltu_135 (-0.9990234375f) == 0uwb, 0);
  check_invalid (testfltu_135 (-1.f) == 0uwb, 1);
  check_invalid (testfltu_135 (__builtin_inff ()) == 43556142965880123323311949751266331066367uwb, 1);
  check_invalid (testfltu_135 (-__builtin_inff ()) == 0uwb, 1);
  check_invalid (testfltu_135 (__builtin_nanf ("")) == 43556142965880123323311949751266331066367uwb, 1);
  check_invalid (testfltu_135 (0xffffffp+104f) == 340282346638528859811704183484516925440uwb, 0);
#endif
#if __BITINT_MAXWIDTH__ >= 192
  check_invalid (testflt_192 (-85070591730234615865843651857942052864.0f) == -85070591730234615865843651857942052864wb, 0);
  check_invalid (testflt_192 (__builtin_inff ()) == 3138550867693340381917894711603833208051177722232017256447wb, 1);
  check_invalid (testflt_192 (-__builtin_inff ()) == -3138550867693340381917894711603833208051177722232017256447wb - 1wb, 1);
  check_invalid (testflt_192 (__builtin_nanf ("")) == 3138550867693340381917894711603833208051177722232017256447wb, 1);
  check_invalid (testflt_192 (0xffffffp+104f) == 340282346638528859811704183484516925440wb, 0);
  check_invalid (testflt_192 (-0xffffffp+104f) == -340282346638528859811704183484516925440wb, 0);
  check_invalid (testfltu_192 (-0.9990234375f) == 0uwb, 0);
  check_invalid (testfltu_192 (-1.f) == 0uwb, 1);
  check_invalid (testfltu_192 (__builtin_inff ()) == 6277101735386680763835789423207666416102355444464034512895uwb, 1);
  check_invalid (testfltu_192 (-__builtin_inff ()) == 0uwb, 1);
  check_invalid (testfltu_192 (__builtin_nanf ("")) == 6277101735386680763835789423207666416102355444464034512895uwb, 1);
  check_invalid (testfltu_192 (0xffffffp+104f) == 340282346638528859811704183484516925440uwb, 0);
#endif
#if __BITINT_MAXWIDTH__ >= 575
  check_invalid (testflt_575 (-85070591730234615865843651857942052864.0f) == -85070591730234615865843651857942052864wb, 0);
  check_invalid (testflt_575 (__builtin_inff ()) == 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb, 1);
  check_invalid (testflt_575 (-__builtin_inff ()) == -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1wb, 1);
  check_invalid (testflt_575 (__builtin_nanf ("")) == 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb, 1);
  check_invalid (testflt_575 (0xffffffp+104f) == 340282346638528859811704183484516925440wb, 0);
  check_invalid (testflt_575 (-0xffffffp+104f) == -340282346638528859811704183484516925440wb, 0);
  check_invalid (testfltu_575 (-0.9990234375f) == 0uwb, 0);
  check_invalid (testfltu_575 (-1.f) == 0uwb, 1);
  check_invalid (testfltu_575 (__builtin_inff ()) == 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb, 1);
  check_invalid (testfltu_575 (-__builtin_inff ()) == 0uwb, 1);
  check_invalid (testfltu_575 (__builtin_nanf ("")) == 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb, 1);
  check_invalid (testfltu_575 (0xffffffp+104f) == 340282346638528859811704183484516925440uwb, 0);
#endif
#endif
#if __DBL_MANT_DIG__ == 53
#if __BITINT_MAXWIDTH__ >= 135
  check_invalid (testdbl_135 (-85070591730234615865843651857942052864.0) == -85070591730234615865843651857942052864wb, 0);
  check_invalid (testdbl_135 (__builtin_inf ()) == 21778071482940061661655974875633165533183wb, 1);
  check_invalid (testdbl_135 (-__builtin_inf ()) == -21778071482940061661655974875633165533183wb - 1wb, 1);
  check_invalid (testdbl_135 (__builtin_nan ("")) == 21778071482940061661655974875633165533183wb, 1);
  check_invalid (testdbl_135 (0x1fffffffffffffp+81) == 21778071482940059243804335646374816120832wb, 0);
  check_invalid (testdbl_135 (0x20000000000000p+81) == 21778071482940061661655974875633165533183wb, 1);
  check_invalid (testdbl_135 (-0x20000000000000p+81) == -21778071482940061661655974875633165533183wb - 1, 0);
  check_invalid (testdbl_135 (-0x20000000000002p+81) == -21778071482940061661655974875633165533183wb - 1, 1);
  check_invalid (testdblu_135 (-0.9990234375) == 0uwb, 0);
  check_invalid (testdblu_135 (-1.) == 0uwb, 1);
  check_invalid (testdblu_135 (__builtin_inf ()) == 43556142965880123323311949751266331066367uwb, 1);
  check_invalid (testdblu_135 (-__builtin_inf ()) == 0uwb, 1);
  check_invalid (testdblu_135 (__builtin_nan ("")) == 43556142965880123323311949751266331066367uwb, 1);
  check_invalid (testdblu_135 (0x1fffffffffffffp+82) == 43556142965880118487608671292749632241664uwb, 0);
  check_invalid (testdblu_135 (0x20000000000000p+82) == 43556142965880123323311949751266331066367uwb, 1);
#endif
#if __BITINT_MAXWIDTH__ >= 192
  check_invalid (testdbl_192 (-85070591730234615865843651857942052864.0) == -85070591730234615865843651857942052864wb, 0);
  check_invalid (testdbl_192 (__builtin_inf ()) == 3138550867693340381917894711603833208051177722232017256447wb, 1);
  check_invalid (testdbl_192 (-__builtin_inf ()) == -3138550867693340381917894711603833208051177722232017256447wb - 1wb, 1);
  check_invalid (testdbl_192 (__builtin_nan ("")) == 3138550867693340381917894711603833208051177722232017256447wb, 1);
  check_invalid (testdbl_192 (0x1fffffffffffffp+138) == 3138550867693340033468750984562846621555579712101368725504wb, 0);
  check_invalid (testdbl_192 (0x20000000000000p+138) == 3138550867693340381917894711603833208051177722232017256447wb, 1);
  check_invalid (testdbl_192 (-0x20000000000000p+138) == -3138550867693340381917894711603833208051177722232017256447wb - 1, 0);
  check_invalid (testdbl_192 (-0x20000000000002p+138) == -3138550867693340381917894711603833208051177722232017256447wb - 1, 1);
  check_invalid (testdblu_192 (-0.9990234375) == 0uwb, 0);
  check_invalid (testdblu_192 (-1.) == 0uwb, 1);
  check_invalid (testdblu_192 (__builtin_inf ()) == 6277101735386680763835789423207666416102355444464034512895uwb, 1);
  check_invalid (testdblu_192 (-__builtin_inf ()) == 0uwb, 1);
  check_invalid (testdblu_192 (__builtin_nan ("")) == 6277101735386680763835789423207666416102355444464034512895uwb, 1);
  check_invalid (testdblu_192 (0x1fffffffffffffp+139) == 6277101735386680066937501969125693243111159424202737451008uwb, 0);
  check_invalid (testdblu_192 (0x20000000000000p+139) == 6277101735386680763835789423207666416102355444464034512895uwb, 1);
#endif
#if __BITINT_MAXWIDTH__ >= 575
  check_invalid (testdbl_575 (-85070591730234615865843651857942052864.0) == -85070591730234615865843651857942052864wb, 0);
  check_invalid (testdbl_575 (__builtin_inf ()) == 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb, 1);
  check_invalid (testdbl_575 (-__builtin_inf ()) == -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1wb, 1);
  check_invalid (testdbl_575 (__builtin_nan ("")) == 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb, 1);
  check_invalid (testdbl_575 (0x1fffffffffffffp+521) == 61832600368276126650327970124302082526882038193909742709080463879918896882169507607035916867654709124839777195049479857541529867095829765369898539058829479405123401922117632wb, 0);
  check_invalid (testdbl_575 (0x20000000000000p+521) == 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb, 1);
  check_invalid (testdbl_575 (-0x20000000000000p+521) == -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1, 0);
  check_invalid (testdbl_575 (-0x20000000000002p+521) == -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1, 1);
  check_invalid (testdblu_575 (-0.9990234375) == 0uwb, 0);
  check_invalid (testdblu_575 (-1.) == 0uwb, 1);
  check_invalid (testdblu_575 (__builtin_inf ()) == 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb, 1);
  check_invalid (testdblu_575 (-__builtin_inf ()) == 0uwb, 1);
  check_invalid (testdblu_575 (__builtin_nan ("")) == 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb, 1);
  check_invalid (testdblu_575 (0x1fffffffffffffp+522) == 123665200736552253300655940248604165053764076387819485418160927759837793764339015214071833735309418249679554390098959715083059734191659530739797078117658958810246803844235264uwb, 0);
  check_invalid (testdblu_575 (0x20000000000000p+522) == 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb, 1);
#endif
#endif
#if __LDBL_MANT_DIG__ == 64
#if __BITINT_MAXWIDTH__ >= 135
  check_invalid (testldbl_135 (-85070591730234615865843651857942052864.0L) == -85070591730234615865843651857942052864wb, 0);
  check_invalid (testldbl_135 (__builtin_infl ()) == 21778071482940061661655974875633165533183wb, 1);
  check_invalid (testldbl_135 (-__builtin_infl ()) == -21778071482940061661655974875633165533183wb - 1wb, 1);
  check_invalid (testldbl_135 (__builtin_nanl ("")) == 21778071482940061661655974875633165533183wb, 1);
  check_invalid (testldbl_135 (0xffffffffffffffffp+70L) == 21778071482940061660475383254915754229760wb, 0);
  check_invalid (testldbl_135 (0x10000000000000000p+70L) == 21778071482940061661655974875633165533183wb, 1);
  check_invalid (testldbl_135 (-0x10000000000000000p+70L) == -21778071482940061661655974875633165533183wb - 1, 0);
  check_invalid (testldbl_135 (-0x10000000000000002p+70L) == -21778071482940061661655974875633165533183wb - 1, 1);
  check_invalid (testldblu_135 (-0.9990234375L) == 0uwb, 0);
  check_invalid (testldblu_135 (-1.L) == 0uwb, 1);
  check_invalid (testldblu_135 (__builtin_infl ()) == 43556142965880123323311949751266331066367uwb, 1);
  check_invalid (testldblu_135 (-__builtin_infl ()) == 0uwb, 1);
  check_invalid (testldblu_135 (__builtin_nanl ("")) == 43556142965880123323311949751266331066367uwb, 1);
  check_invalid (testldblu_135 (0xffffffffffffffffp+71L) == 43556142965880123320950766509831508459520uwb, 0);
  check_invalid (testldblu_135 (0x10000000000000000p+71L) == 43556142965880123323311949751266331066367uwb, 1);
#endif
#if __BITINT_MAXWIDTH__ >= 192
  check_invalid (testldbl_192 (-85070591730234615865843651857942052864.0L) == -85070591730234615865843651857942052864wb, 0);
  check_invalid (testldbl_192 (__builtin_infl ()) == 3138550867693340381917894711603833208051177722232017256447wb, 1);
  check_invalid (testldbl_192 (-__builtin_infl ()) == -3138550867693340381917894711603833208051177722232017256447wb - 1wb, 1);
  check_invalid (testldbl_192 (__builtin_nanl ("")) == 3138550867693340381917894711603833208051177722232017256447wb, 1);
  check_invalid (testldbl_192 (0xffffffffffffffffp+127L) == 3138550867693340381747753528143363976319490418516133150720wb, 0);
  check_invalid (testldbl_192 (0x10000000000000000p+127L) == 3138550867693340381917894711603833208051177722232017256447wb, 1);
  check_invalid (testldbl_192 (-0x10000000000000000p+127L) == -3138550867693340381917894711603833208051177722232017256447wb - 1, 0);
  check_invalid (testldbl_192 (-0x10000000000000002p+127L) == -3138550867693340381917894711603833208051177722232017256447wb - 1, 1);
  check_invalid (testldblu_192 (-0.9990234375L) == 0uwb, 0);
  check_invalid (testldblu_192 (-1.L) == 0uwb, 1);
  check_invalid (testldblu_192 (__builtin_infl ()) == 6277101735386680763835789423207666416102355444464034512895uwb, 1);
  check_invalid (testldblu_192 (-__builtin_infl ()) == 0uwb, 1);
  check_invalid (testldblu_192 (__builtin_nanl ("")) == 6277101735386680763835789423207666416102355444464034512895uwb, 1);
  check_invalid (testldblu_192 (0xffffffffffffffffp+128L) == 6277101735386680763495507056286727952638980837032266301440uwb, 0);
  check_invalid (testldblu_192 (0x10000000000000000p+128L) == 6277101735386680763835789423207666416102355444464034512895uwb, 1);
#endif
#if __BITINT_MAXWIDTH__ >= 575
  check_invalid (testldbl_575 (-85070591730234615865843651857942052864.0L) == -85070591730234615865843651857942052864wb, 0);
  check_invalid (testldbl_575 (__builtin_infl ()) == 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb, 1);
  check_invalid (testldbl_575 (-__builtin_infl ()) == -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1wb, 1);
  check_invalid (testldbl_575 (__builtin_nanl ("")) == 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb, 1);
  check_invalid (testldbl_575 (0xffffffffffffffffp+510L) == 61832600368276133511773678272426148233889331025751498446645922568076207932202076431648659257792374503198949281962308977915333294030066289778448068072486649492543280785653760wb, 0);
  check_invalid (testldbl_575 (0x10000000000000000p+510L) == 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb, 1);
  check_invalid (testldbl_575 (-0x10000000000000000p+510L) == -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1, 0);
  check_invalid (testldbl_575 (-0x10000000000000002p+510L) == -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1, 1);
  check_invalid (testldblu_575 (-0.9990234375L) == 0uwb, 0);
  check_invalid (testldblu_575 (-1.L) == 0uwb, 1);
  check_invalid (testldblu_575 (__builtin_infl ()) == 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb, 1);
  check_invalid (testldblu_575 (-__builtin_infl ()) == 0uwb, 1);
  check_invalid (testldblu_575 (__builtin_nanl ("")) == 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb, 1);
  check_invalid (testldblu_575 (0xffffffffffffffffp+511L) == 123665200736552267023547356544852296467778662051502996893291845136152415864404152863297318515584749006397898563924617955830666588060132579556896136144973298985086561571307520uwb, 0);
  check_invalid (testldblu_575 (0x10000000000000000p+511L) == 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb, 1);
#endif
#endif
#if __FLT128_MANT_DIG__ == 113
#if __BITINT_MAXWIDTH__ >= 135
  check_invalid (testflt128_135 (-85070591730234615865843651857942052864.0F128) == -85070591730234615865843651857942052864wb, 0);
  check_invalid (testflt128_135 (__builtin_inff128 ()) == 21778071482940061661655974875633165533183wb, 1);
  check_invalid (testflt128_135 (-__builtin_inff128 ()) == -21778071482940061661655974875633165533183wb - 1wb, 1);
  check_invalid (testflt128_135 (__builtin_nanf128 ("")) == 21778071482940061661655974875633165533183wb, 1);
  check_invalid (testflt128_135 (0x1ffffffffffffffffffffffffffffp+21F128) == 21778071482940061661655974875633163436032wb, 0);
  check_invalid (testflt128_135 (0x20000000000000000000000000000p+21F128) == 21778071482940061661655974875633165533183wb, 1);
  check_invalid (testflt128_135 (-0x20000000000000000000000000000p+21F128) == -21778071482940061661655974875633165533183wb - 1, 0);
  check_invalid (testflt128_135 (-0x20000000000000000000000000002p+21F128) == -21778071482940061661655974875633165533183wb - 1, 1);
  check_invalid (testflt128u_135 (-0.9990234375F128) == 0uwb, 0);
  check_invalid (testflt128u_135 (-1.F128) == 0uwb, 1);
  check_invalid (testflt128u_135 (__builtin_inff128 ()) == 43556142965880123323311949751266331066367uwb, 1);
  check_invalid (testflt128u_135 (-__builtin_inff128 ()) == 0uwb, 1);
  check_invalid (testflt128u_135 (__builtin_nanf128 ("")) == 43556142965880123323311949751266331066367uwb, 1);
  check_invalid (testflt128u_135 (0x1ffffffffffffffffffffffffffffp+22F128) == 43556142965880123323311949751266326872064uwb, 0);
  check_invalid (testflt128u_135 (0x20000000000000000000000000000p+22F128) == 43556142965880123323311949751266331066367uwb, 1);
#endif
#if __BITINT_MAXWIDTH__ >= 192
  check_invalid (testflt128_192 (-85070591730234615865843651857942052864.0F128) == -85070591730234615865843651857942052864wb, 0);
  check_invalid (testflt128_192 (__builtin_inff128 ()) == 3138550867693340381917894711603833208051177722232017256447wb, 1);
  check_invalid (testflt128_192 (-__builtin_inff128 ()) == -3138550867693340381917894711603833208051177722232017256447wb - 1wb, 1);
  check_invalid (testflt128_192 (__builtin_nanf128 ("")) == 3138550867693340381917894711603833208051177722232017256447wb, 1);
  check_invalid (testflt128_192 (0x1ffffffffffffffffffffffffffffp+78F128) == 3138550867693340381917894711603832905819722818574723579904wb, 0);
  check_invalid (testflt128_192 (0x20000000000000000000000000000p+78F128) == 3138550867693340381917894711603833208051177722232017256447wb, 1);
  check_invalid (testflt128_192 (-0x20000000000000000000000000000p+78F128) == -3138550867693340381917894711603833208051177722232017256447wb - 1, 0);
  check_invalid (testflt128_192 (-0x20000000000000000000000000002p+78F128) == -3138550867693340381917894711603833208051177722232017256447wb - 1, 1);
  check_invalid (testflt128u_192 (-0.9990234375F128) == 0uwb, 0);
  check_invalid (testflt128u_192 (-1.F128) == 0uwb, 1);
  check_invalid (testflt128u_192 (__builtin_inff128 ()) == 6277101735386680763835789423207666416102355444464034512895uwb, 1);
  check_invalid (testflt128u_192 (-__builtin_inff128 ()) == 0uwb, 1);
  check_invalid (testflt128u_192 (__builtin_nanf128 ("")) == 6277101735386680763835789423207666416102355444464034512895uwb, 1);
  check_invalid (testflt128u_192 (0x1ffffffffffffffffffffffffffffp+79F128) == 6277101735386680763835789423207665811639445637149447159808uwb, 0);
  check_invalid (testflt128u_192 (0x20000000000000000000000000000p+79F128) == 6277101735386680763835789423207666416102355444464034512895uwb, 1);
#endif
#if __BITINT_MAXWIDTH__ >= 575
  check_invalid (testflt128_575 (-85070591730234615865843651857942052864.0F128) == -85070591730234615865843651857942052864wb, 0);
  check_invalid (testflt128_575 (__builtin_inff128 ()) == 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb, 1);
  check_invalid (testflt128_575 (-__builtin_inff128 ()) == -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1wb, 1);
  check_invalid (testflt128_575 (__builtin_nanf128 ("")) == 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb, 1);
  check_invalid (testflt128_575 (0x1ffffffffffffffffffffffffffffp+461F128) == 61832600368276133515125630254911791554520007845691312598455129804691160851602940042069550439343049559602369631548246946680753811425558728725309540242943660463695151425912832wb, 0);
  check_invalid (testflt128_575 (0x20000000000000000000000000000p+461F128) == 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb, 1);
  check_invalid (testflt128_575 (-0x20000000000000000000000000000p+461F128) == -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1, 0);
  check_invalid (testflt128_575 (-0x20000000000000000000000000002p+461F128) == -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1, 1);
  check_invalid (testflt128u_575 (-0.9990234375F128) == 0uwb, 0);
  check_invalid (testflt128u_575 (-1.F128) == 0uwb, 1);
  check_invalid (testflt128u_575 (__builtin_inff128 ()) == 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb, 1);
  check_invalid (testflt128u_575 (-__builtin_inff128 ()) == 0uwb, 1);
  check_invalid (testflt128u_575 (__builtin_nanf128 ("")) == 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb, 1);
  check_invalid (testflt128u_575 (0x1ffffffffffffffffffffffffffffp+462F128) == 123665200736552267030251260509823583109040015691382625196910259609382321703205880084139100878686099119204739263096493893361507622851117457450619080485887320927390302851825664uwb, 0);
  check_invalid (testflt128u_575 (0x20000000000000000000000000000p+462F128) == 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb, 1);
#endif
#endif
}
