# From 5.2 to 5.3
*Make sure you view this [upgrade guide from the `master` branch](../../../master/doc/update/5.2-to-5.3.md) for the most up to date instructions.*

## Warning

GitLab 5.3 is affected by critical security vulnerabilities CVE-2013-4490 and CVE-2013-4489.

## 0. Backup

It's useful to make a backup just in case things go south (with MySQL, this may require granting "LOCK TABLES" privileges to the GitLab user on the database version):

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:create RAILS_ENV=production
```

## 1. Stop server

    sudo service gitlab stop

## 2. Get latest code

```bash
cd /home/git/gitlab
sudo -u git -H git fetch
sudo -u git -H git checkout 5-3-stable
```

## 3. Install libs, migrations, etc.

```bash
cd /home/git/gitlab

# MySQL
sudo -u git -H bundle install --without development test postgres --deployment

#PostgreSQL
sudo -u git -H bundle install --without development test mysql --deployment

sudo -u git -H bundle exec rake db:migrate RAILS_ENV=production

sudo -u git -H bundle exec rake assets:precompile RAILS_ENV=production
```

## 4. Update config files

- Make `/home/git/gitlab/config/gitlab.yml` same as https://gitlab.com/gitlab-org/gitlab-ce/blob/5-3-stable/config/gitlab.yml.example but with your settings.
- Make `/home/git/gitlab/config/puma.rb` same as https://gitlab.com/gitlab-org/gitlab-ce/blob/5-3-stable/config/puma.rb.example but with your settings.

## 5. Update Init script

```bash
sudo rm /etc/init.d/gitlab
sudo curl -L --output /etc/init.d/gitlab https://raw.github.com/gitlabhq/gitlabhq/5-3-stable/lib/support/init.d/gitlab
sudo chmod +x /etc/init.d/gitlab
```

## 6. Start application

    sudo service gitlab start
    sudo service nginx restart

## 7. Check application status

Check if GitLab and its environment are configured correctly:

    sudo -u git -H bundle exec rake gitlab:env:info RAILS_ENV=production

To make sure you didn't miss anything run a more thorough check with:

    sudo -u git -H bundle exec rake gitlab:check RAILS_ENV=production

If all items are green, then congratulations upgrade complete!

## Things went south? Revert to previous version (5.2)

### 1. Revert the code to the previous version

Follow the [upgrade guide from 5.1 to 5.2](5.1-to-5.2.md), except for the database migration (the backup is already migrated to the previous version).

### 2. Restore from the backup:

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:restore RAILS_ENV=production
```
