"""
Copyright (c) 2003-2007, Paul Varga and other contributors
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
    * Neither the name of the project nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
"""

# Gettext
import gettext
_ = gettext.gettext
N_ = lambda s: s

# Converts a number of seconds into a short displayable string.
def succinct(seconds):
	seconds = int(seconds)
	
	hours    = seconds / (60 * 60)
	seconds -= hours * (60 * 60)
	
	minutes  = seconds / 60
	seconds -= minutes * 60
	
	return '%0.2d:%0.2d:%0.2d' % (hours, minutes, seconds)

# Converts a number of seconds into a precise, but verbose displayable string.
def lengthy_precise(seconds):
	seconds = int(seconds)
	
	days     = seconds / (60 * 60 * 24)
	seconds -= days * (60 * 60 * 24)
	
	hours    = seconds / (60 * 60)
	seconds -= hours * (60 * 60)
	
	minutes  = seconds / 60
	seconds -= minutes * 60
	
	def create_listing(items):
		def append_listing(listing, singular, plural, count, index, length):
			initial = not listing
			
			if listing or count != 0 or index+1 == length:
				listing += gettext.ngettext(singular, plural, count) % (count,)
				
				if index+1 < length:
					listing += ', '
			
			return listing
		
		listing = ''
		
		for index, item in zip(range(0,len(items)), items):
			listing = append_listing(listing, item[0][0], item[0][1], item[1], index, len(items))
		
		return listing
	
	return create_listing((
		((N_('%i day'), N_('%i days')), days),
		((N_('%i hour'), N_('%i hours')), hours),
		((N_('%i minute'), N_('%i minutes')), minutes),
		((N_('%i second'), N_('%i seconds')), seconds)
	))

# Converts a number of seconds into a rough estimate
def lengthy_estimate(seconds):
	seconds = int(seconds)
	
	days     = seconds / (60 * 60 * 24)
	seconds -= days * (60 * 60 * 24)
	
	hours    = seconds / (60 * 60)
	seconds -= hours * (60 * 60)
	
	minutes  = seconds / 60
	seconds -= minutes * 60
	
	if days >= 1:
		return gettext.ngettext('About %i day', 'About %i days', days) % days
	elif hours >= 1:
		return gettext.ngettext('About %i hour', 'About %i hours', hours) % hours
	elif minutes >= 1:
		return gettext.ngettext('About %i minute', 'About %i minutes', minutes) % minutes
	else:
		return gettext.ngettext('About %i second', 'About %i seconds', seconds) % seconds

lengthy = lengthy_estimate
