# CodePath Android Cliffnotes

Welcome to the open-source [Codepath](http://codepath.com) Android Cliffnotes! Our goal is to become the **central crowdsourced resource** for complete and up-to-date Android content and tutorials. [Just take me to the notes](https://github.com/codepath/android_guides/wiki#getting-started)!

[![CodePath](http://i.imgur.com/XgxWfyF.png)](http://codepath.com)

We have guides for everyone whether you are **beginner, intermediate or advanced**. Want to learn how to [use the ActionBar](https://github.com/codepath/android_guides/wiki/Defining-The-ActionBar) or the [ins and outs of fragments](https://github.com/codepath/android_guides/wiki/Creating-and-Using-Fragments)? We got that. Want to learn [about testing](https://github.com/codepath/android_guides/wiki/Android-Unit-and-Integration-testing) or how to [build flexible user interfaces for multiple devices](https://github.com/codepath/android_guides/wiki/Flexible-User-Interfaces)? We got you covered. We don't waste time with the "theoretical approach" from a book. We cover **exactly the things we use every day** as we are developing apps for contracts.

**Need Help?** Please join the [google groups](https://groups.google.com/forum/#!forum/codepath-android-guides) for these guides where you can post related questions.

## Motivation

Ever been **frustrated finding information on outdated one-off blog posts and tutorials** that has since become irrelevant? How many times were you googling only to find your answer only on a **2 year old Stack Overflow post**? We believe there's got to be a better way. Why not have the community work together to create useful and detailed documentation for every aspect of Android (or any platform)? There's absolutely no reason that we should have to make do with outdated, vague or un-editable content anymore.

Read about our [mission to change the way engineers learn new technologies](https://github.com/codepath/android_guides/wiki/The-CodePath-Goal) and we would love for you to [get involved](https://github.com/codepath/android_guides/wiki/The-CodePath-Goal#how-do-i-help)! In addition, we are a fledgling startup so if you like this guide and what we are trying to do, please consider following us on twitter [@codepath](https://twitter.com/codepath)! 

## Live in San Francisco?

Located in the San Francisco Bay Area and interested in learning with others in a more structured program? Check out our local [Android](http://www.meetup.com/Learning-Android-Development) or [iOS](http://www.meetup.com/Learning-iOS-Development-SF/) meetup events. We have free evening events and at-cost 1-day workshops to make learning social and connect you with others passionate about mobile.

If you are an experienced engineer (2+ years of professional experience in software development) and serious about learning Android, check out our [free evening 8-week Android bootcamp](http://codepath.com/androidbootcamp). Learn how to build mobile apps while collaborating with other engineers and designers. Work on solving important problems for non-profits with our free 8-week accelerated evening mobile bootcamp. [Learn more and apply here](http://courses.codepath.com/snippets/intro_to_android/about_bootcamp).

## We Need Your Help!

We need your help making the guides even better. In particular, here are the easiest ways to contribute:

1. **Update Guides.** Review existing guides and update outdated content, add tips or add/update images
2. **Fill Out Guides.** Find guides that are [simply stubs](https://github.com/codepath/android_guides/issues/2) and fill them out with content.
3. **Create New Guides.** Review the [missing topics list](https://github.com/codepath/android_guides/issues/2) and create new topic guides.

We [maintain a master missing topics list](https://github.com/codepath/android_guides/issues/2) that contains the most important missing topics. Also look for items in the cliffnotes with the **Needs Attention** mark which indicates the guide needs some love. If you see a topic you'd like added, please check the [issues](https://github.com/codepath/android_guides/issues) for this repository to let us know.

If you are interested in contributing to our guides, please check out our [contribution guidelines](https://github.com/codepath/android_guides/wiki/Contributing-Guidelines) first.

## Contributors

These guides were originally created and adapted by [Nathan Esquenazi](http://github.com/nesquena) 
as a part of our [CodePath](http://codepath.com) training and bootcamps. We have also had contributions from many
community members including:

 * [Nidhi Shah](https://github.com/nidhi1608) (CodePath Alumni and Staff)
 * [Roger Hu](https://github.com/rogerhu) (CodePath Alumni and Instructor)
 * [Nick Aiwazian](https://github.com/nickai) (CodePath Alumni and Instructor)
 * [Kevin Leong](https://github.com/kgleong) (CodePath Alumni and Instructor)
 * [Michael Alan Huff](https://github.com/koalahamlet) (CodePath Alumni and Mentor)
 * [Vibhor Bharadwaj](https://github.com/vibhorB) (CodePath Alumni and Mentor)
 * [Ari Lacenski](https://github.com/tensory) (CodePath Alumni)
 * [Chunyan Song](https://github.com/chunyan) (CodePath Alumni)
 * [Vishal Kapoor](https://github.com/kapoor) (CodePath Alumni)
 * [Trevor Elkins](https://github.com/trevor-e)
 * [Adrian Romero](https://github.com/romeroadrian)
 * [Aaron Fleshner](https://github.com/adfleshner)
