//**************************************************************************************************
//                                          DlgPrefs.cpp                                           *
//                                         --------------                                          *
// Started     : 2006-10-17                                                                        *
// Last Update : 2015-03-23                                                                        *
// Copyright   : (C) 2006 by MSWaters                                                              *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#include "DlgPrefs.hpp"

//**************************************************************************************************
// Implement an event table.

wxBEGIN_EVENT_TABLE( DlgPrefs, wxDialog )

  EVT_BUTTON( DlgPrefs::ID_BTN_OK    , DlgPrefs::OnBtnOk     )
  EVT_BUTTON( DlgPrefs::ID_BTN_CANCEL, DlgPrefs::OnBtnCancel )

wxEND_EVENT_TABLE( )

//**************************************************************************************************
// Constructor.
//
// Argument List:
//   poWin - A pointer to the dialog parent window

DlgPrefs::DlgPrefs( wxWindow * poWin ) :
                    wxDialog( poWin, -1, wxT(""), wxDefaultPosition, wxDefaultSize,
                              wxDEFAULT_DIALOG_STYLE, wxDialogNameStr )
{
  // Get the global configuration object
  m_poCfg = (wxConfig *) wxConfig::Get( );

  // Construct the display objects
  Initialize( );

  // Clear object attributes
  bClear( );
}

//**************************************************************************************************
// Destructor.

DlgPrefs::~DlgPrefs( )
{
}

//**************************************************************************************************
// Initialize object attributes.

void  DlgPrefs::Initialize( void )
{
  SetTitle( wxT(" Preferences") );

  // Call all the initialization functions
  Create( );
  ToolTips( );

  // Layout the of the display objects
  DoLayout( );
}

//**************************************************************************************************
// Create the display objects.

void  DlgPrefs::Create( void )
{
  wxPanel * poPnlPrefs, * poPnlBtns;
//  wxPanel * poPnlLHS, * poPnlRHS;
  wxSize    oSizeCbx;
  int       iWdName=145, iWdValue=130;

  // Create the various underlying panel objects
  poPnlPrefs = new wxPanel( this );
//  poPnlLHS   = new wxPanel( this );
//  poPnlRHS   = new wxPanel( this );
  poPnlBtns  = new wxPanel( this );

  // Create the waveform viewer choice control
  m_oChoViewerUtil.bCreate( poPnlPrefs, ID_CHO_VIEWERUTIL, iWdName, iWdValue );
  m_oChoViewerUtil.m_oLblName.SetLabel( wxT("Waveform viewer") );
  m_oChoViewerUtil.m_oChoice.Append( CLP_GAW   );
  m_oChoViewerUtil.m_oChoice.Append( CLP_GWAVE );

  // Create the temporary file management strategy choice control
  m_oChoTmpFileMgt.bCreate( poPnlPrefs, ID_CHO_TMPFILEMGT, iWdName, iWdValue );
  m_oChoTmpFileMgt.m_oLblName.SetLabel( wxT("Temporary files") );
  m_oChoTmpFileMgt.m_oChoice.Append( wxT("Delete") );
  m_oChoTmpFileMgt.m_oChoice.Append( wxT("Prompt") );
  m_oChoTmpFileMgt.m_oChoice.Append( wxT("Keep")   );

  // Create the main frame layout choice control
  m_oChoFrmLayout.bCreate( poPnlPrefs, ID_CHO_FRMLAYOUT  , iWdName, iWdValue );
  m_oChoFrmLayout.m_oLblName.SetLabel( wxT("Main frame layout") );
  m_oChoFrmLayout.m_oChoice.Append( wxT("Long Probes")  );
  m_oChoFrmLayout.m_oChoice.Append( wxT("Wide Console") );

  // Create the phase / angle units choice control
  m_oChoUnitsPhase.bCreate( poPnlPrefs, ID_CHO_PHASEUNITS, iWdName, iWdValue );
  m_oChoUnitsPhase.m_oLblName.SetLabel( wxT("Phase / angle units") );
  m_oChoUnitsPhase.m_oChoice.Append( wxT("Degrees") );
  m_oChoUnitsPhase.m_oChoice.Append( wxT("Radians") );

  // Create the results precision choice control
  m_oChoPrecision.bCreate( poPnlPrefs, ID_CHO_PRECISION  , iWdName, iWdValue );
  m_oChoPrecision.m_oLblName.SetLabel( wxT("Results precision") );
  m_oChoPrecision.m_oChoice.Append( wxT("%3.1E") );
  m_oChoPrecision.m_oChoice.Append( wxT("%4.2E") );
  m_oChoPrecision.m_oChoice.Append( wxT("%5.3E") );
  m_oChoPrecision.m_oChoice.Append( wxT("%6.4E") );
  m_oChoPrecision.m_oChoice.Append( wxT("%7.5E") );
  m_oChoPrecision.m_oChoice.Append( wxT("%8.6E") );

  // Create the PnlValue controls
  m_oPnlNbkMaxLns.bCreate( poPnlPrefs, ID_VAL_NBKMAXLNS  , iWdName, iWdValue-45, 45,
                           wxDefaultPosition, PnlValue::eSHOW_LBL );
  m_oPnlNbkMaxLns.bSetName( wxT("Max text control size") );
  m_oPnlNbkMaxLns.bSetValueType( eVALUE_INT );
  m_oPnlNbkMaxLns.bSetDefValue( TXT_LNSDEF );
  m_oPnlNbkMaxLns.bSetSpnRange( TXT_LNSMIN, TXT_LNSMAX );
  m_oPnlNbkMaxLns.bSetSpnIncSz( 10, 10000 );
  m_oPnlNbkMaxLns.bSetUnits( wxT("Lines") );

  // Create the PnlValue controls
  m_oPnlSpnPeriod.bCreate( poPnlPrefs, ID_VAL_SPINPERIOD, iWdName, iWdValue-45, 45,
                           wxDefaultPosition, PnlValue::eSHOW_LBL );
  m_oPnlSpnPeriod.bSetName( wxT("Spin control period") );
  m_oPnlSpnPeriod.bSetValueType( eVALUE_INT );
  m_oPnlSpnPeriod.bSetDefValue( SPN_PERIOD_DEF );
  m_oPnlSpnPeriod.bSetSpnRange( SPN_PERIOD_MIN, SPN_PERIOD_MAX );
  m_oPnlSpnPeriod.bSetSpnIncSz( 1, 10 );
  m_oPnlSpnPeriod.bSetUnits( wxT("mSec") );

  // Set height of check box controls according to size of PnlValue object
  oSizeCbx = m_oPnlNbkMaxLns.GetSize( );
  oSizeCbx.SetWidth( 250 );

  // Create the synchronize sweep sources check box
  m_oCbxSyncSwpSrcs.Create( poPnlPrefs, ID_CBX_SYNCSWPSRCS, wxT("Sync sweep sources \t   "),
                            wxDefaultPosition, oSizeCbx, wxALIGN_RIGHT );

  // Create the tool tips check box
#if wxCHECK_VERSION( 3,0,0 )
  m_oCbxToolTips.Create( poPnlPrefs, ID_CBX_TOOLTIPS,       wxT("Show tool tips \t\t   ")  ,
                         wxDefaultPosition, oSizeCbx, wxALIGN_RIGHT );
#else
  m_oCbxToolTips.Create( poPnlPrefs, ID_CBX_TOOLTIPS,       wxT("Show tool tips \t\t\t   ")  ,
                         wxDefaultPosition, oSizeCbx, wxALIGN_RIGHT );
#endif

  // Create the application path text controls
//  m_oTxtGschem .bCreate( poPnlRight, ID_TXT_GSCHEM , 80, 250 );
//  m_oTxtGnetlst.bCreate( poPnlRight, ID_TXT_GNETLST, 80, 250 );
//  m_oTxtNgspice.bCreate( poPnlRight, ID_TXT_NGSPICE, 80, 250 );
//  m_oTxtGnucap .bCreate( poPnlRight, ID_TXT_GNUCAP , 80, 250 );
//  m_oTxtGaw    .bCreate( poPnlRight, ID_TXT_GAW    , 80, 250 );
//  m_oTxtGwave  .bCreate( poPnlRight, ID_TXT_GWAVE  , 80, 250 );
//  m_oTxtCalc   .bCreate( poPnlRight, ID_TXT_CALC   , 80, 250 );
//  m_oTxtGschem .m_oLblName.SetLabel( wxT("Gschem")     );
//  m_oTxtGnetlst.m_oLblName.SetLabel( wxT("Gnetlist")   );
//  m_oTxtNgspice.m_oLblName.SetLabel( wxT("NG-Spice")   );
//  m_oTxtGnucap .m_oLblName.SetLabel( wxT("GNU-Cap")    );
//  m_oTxtGaw    .m_oLblName.SetLabel( wxT("Gaw")        );
//  m_oTxtGwave  .m_oLblName.SetLabel( wxT("Gwave")      );
//  m_oTxtCalc   .m_oLblName.SetLabel( wxT("Calculator") );

  // Create the buttons
  m_oBtnOk    .Create( poPnlBtns, ID_BTN_OK,     wxT("OK") );
  m_oBtnCancel.Create( poPnlBtns, ID_BTN_CANCEL, wxT("Cancel") );
}

//**************************************************************************************************
// Initialize the tool tips.

void  DlgPrefs::ToolTips( void )
{
  m_oChoViewerUtil .SetToolTip( wxT("Select the waveform viewing utility") );
  m_oChoTmpFileMgt .SetToolTip( wxT("The temporary file management strategy to be used") );
  m_oChoFrmLayout  .SetToolTip( wxT("The main frame layout to be used") );
  m_oChoUnitsPhase .SetToolTip( wxT("The phase / angle units to be used") );
  m_oChoPrecision  .SetToolTip( wxT("Select the precision of the analysis results") );
  m_oPnlNbkMaxLns  .SetToolTip( wxT("The maximum number of lines that can be displayed in a text control") );
  m_oPnlSpnPeriod  .SetToolTip( wxT("The period between successive spin button control updates") );
  m_oCbxSyncSwpSrcs.SetToolTip( wxT("Enable or disable synchronization of sweep sources") );
  m_oCbxToolTips   .SetToolTip( wxT("Enable or disable tool tips") );

//m_oTxtGschem     .SetToolTip( wxT("The path to the binary for gschem (schematic capture application)") );
//m_oTxtGnetlst    .SetToolTip( wxT("The path to the binary for gnetlist (schematic to netlist converter)") );
//m_oTxtNgspice    .SetToolTip( wxT("The path to the binary for NG-Spice (simulation engine)") );
//m_oTxtGnucap     .SetToolTip( wxT("The path to the binary for GNU-Cap (simulation engine)") );
//m_oTxtGaw        .SetToolTip( wxT("The path to the binary for Gaw (waveform viewer)") );
//m_oTxtGwave      .SetToolTip( wxT("The path to the binary for Gwave (waveform viewer)") );
//m_oTxtCalc       .SetToolTip( wxT("The path to the binary for the calculator utility") );
}

//**************************************************************************************************
// Layout the display objects within the dialog.

void  DlgPrefs::DoLayout( void )
{
  wxBoxSizer  * poSzrDlg;
  wxPanel     * poPnlPrefs, * poPnlBtns;
  wxBoxSizer  * poSzrPrefs, * poSzrBtns;
  wxSizerFlags  oFlags;

  // Get pointers to the various panels
  poPnlPrefs = (wxPanel *) m_oPnlNbkMaxLns .GetParent( );
  poPnlBtns  = (wxPanel *) m_oBtnOk        .GetParent( );

  // Create sizers to associate with the panels
  poSzrDlg   = new wxBoxSizer      ( wxVERTICAL   );
  poSzrPrefs = new wxStaticBoxSizer( wxVERTICAL, poPnlPrefs, wxT("") );
  poSzrBtns  = new wxBoxSizer      ( wxHORIZONTAL );

  // Set the sizers to the panels
              SetSizer( poSzrDlg   );
  poPnlPrefs->SetSizer( poSzrPrefs );
  poPnlBtns ->SetSizer( poSzrBtns  );

  // Layout the preferences controls
  oFlags.Align( wxALIGN_LEFT );
  oFlags.Border( wxLEFT | wxRIGHT | wxTOP, 10 );
  poSzrPrefs->Add( &m_oChoViewerUtil , oFlags );
  oFlags.Border( wxLEFT                  , 10 );
  poSzrPrefs->Add( &m_oChoTmpFileMgt , oFlags );
  poSzrPrefs->Add( &m_oChoFrmLayout  , oFlags );
  poSzrPrefs->Add( &m_oChoUnitsPhase , oFlags );
  poSzrPrefs->Add( &m_oChoPrecision  , oFlags );
  poSzrPrefs->Add( &m_oPnlNbkMaxLns  , oFlags );
  poSzrPrefs->Add( &m_oPnlSpnPeriod  , oFlags );
  oFlags.Border( wxLEFT                  ,  7 );
  poSzrPrefs->Add( &m_oCbxSyncSwpSrcs, oFlags );
  oFlags.Border( wxLEFT | wxBOTTOM       ,  7 );
  poSzrPrefs->Add( &m_oCbxToolTips   , oFlags );

  // Layout the buttons
  oFlags.Border( wxTOP | wxBOTTOM, 10 );
  oFlags.Align( wxALIGN_RIGHT );
  poSzrBtns->Add( &m_oBtnOk    , oFlags );
  poSzrBtns->AddSpacer( 10 );
  oFlags.Align( wxALIGN_LEFT );
  poSzrBtns->Add( &m_oBtnCancel, oFlags );

  // Layout the underlying dialog
  oFlags.Border( wxALL,    15 );
  poSzrDlg->Add( poPnlPrefs, oFlags );
  oFlags.Align( wxALIGN_CENTER );
  oFlags.Border( wxBOTTOM, 15 );
  poSzrDlg->Add( poPnlBtns , oFlags );

  // Set dialogues minimum size and initial size as calculated by the sizer
  poSzrPrefs->SetSizeHints( poPnlPrefs );
  poSzrBtns ->SetSizeHints( poPnlBtns  );
  poSzrDlg  ->SetSizeHints( this       );
}

//**************************************************************************************************
// Load the values into the display controls from the configuration file.

void  DlgPrefs::Load( void )
{
  wxString  os1;
  long      li1;

  SetEvtHandlerEnabled( false );

  m_poCfg->SetPath( wxT("/Viewer") );

  m_poCfg->Read( wxT("Name"),        &os1, CLP_GWAVE );
  for( li1=0; (uint)li1<m_oChoViewerUtil.m_oChoice.GetCount( ); li1++ )
  {
    if( m_oChoViewerUtil.m_oChoice.GetString( (uint) li1 ) == os1 )
    {
      m_oChoViewerUtil.m_oChoice.SetSelection( (uint) li1 );
      break;
    }
  }

  m_poCfg->SetPath( wxT("/Main") );

  m_poCfg->Read( wxT("TmpFileMgt")   , &li1, eTFM_DELETE );
  m_oChoTmpFileMgt .m_oChoice.SetSelection( li1 );

  m_poCfg->Read( wxT("MainFrmLayout"), &li1, 0 );
  m_oChoFrmLayout  .m_oChoice.SetSelection( li1 );

  m_poCfg->Read( wxT("Precision")    , &li1, CNVT_DEF_FLT_RES );
  m_oChoPrecision  .m_oChoice.SetSelection( li1-1 );

  m_poCfg->Read( wxT("NbkMaxLns")    , &li1, TXT_LNSDEF );
  m_oPnlNbkMaxLns  .bSetValue( li1 );

  m_poCfg->Read( wxT("SpnPeriod")    , &li1, SPN_PERIOD_DEF );
  m_oPnlSpnPeriod  .bSetValue( double( li1 ), -3 );

  m_poCfg->Read( wxT("ToolTips")     , &li1, 0 );
  m_oCbxToolTips   .SetValue( li1 != 0 ? true : false );

//  m_poCfg->Read( wxT("TipDelay")    , &li1, 0 ); // ??? MSW 2015-03-23
//  m_oPnlTipDelay   .bSetValue( li1 );

  m_poCfg->SetPath( wxT("/Simulator") );

  m_poCfg->Read( wxT("PhaseUnits")   , &li1, 0 );
  m_oChoUnitsPhase .m_oChoice.SetSelection( li1 );

  m_poCfg->Read( wxT("SyncSwpSrcs")  , &li1, 0 );
  m_oCbxSyncSwpSrcs.SetValue( li1 != 0 ? true : false );

  SetEvtHandlerEnabled( true );
}

//**************************************************************************************************
// Save the values in the display controls in the configuration file.

void  DlgPrefs::Save( void )
{
  SetEvtHandlerEnabled( false );

  m_poCfg->SetPath( wxT("/Viewer") );

  m_poCfg->Write( wxT("Name")         , rosGetViewerUtil( ) );

  m_poCfg->SetPath( wxT("/Main") );

  m_poCfg->Write( wxT("TmpFileMgt")   , (long) iGetTmpFileMgt( ) );
  m_poCfg->Write( wxT("MainFrmLayout"), (long) iGetFrmLayout( ) );
  m_poCfg->Write( wxT("Precision")    , (long) iGetPrecision( ) );
  m_poCfg->Write( wxT("NbkMaxLns")    , (long) iGetNbkMaxLns( ) );
  m_poCfg->Write( wxT("SpnPeriod")    , (long) iGetSpnPeriod( ) );
  m_poCfg->Write( wxT("ToolTips")     , (long) ( bGetToolTips( ) ? 1 : 0 ) );
//  m_poCfg->Write( wxT("TipDelay")    , (long) iGetTipDelay( ) ); // ??? MSW 2015-03-23

  m_poCfg->SetPath( wxT("/Simulator") );

  m_poCfg->Write( wxT("PhaseUnits")   , (long) iGetUnitsPhase( ) );
  m_poCfg->Write( wxT("SyncSwpSrcs")  , (long) ( bGetSyncSwpSrcs( ) ? 1 : 0 ) );

  m_poCfg->Flush( );

  SetEvtHandlerEnabled( true );
}

//**************************************************************************************************
// Reset all dialog settings to defaults.
//
// Return Values:
//   true  - Success
//   false - Failure

bool  DlgPrefs::bClear( void )
{
  Load( );

  return( true );
}

//**************************************************************************************************
//                                         Event Handlers                                          *
//**************************************************************************************************
// Ok button event handler.
//
// Argument List:
//   roEvtCmd - An object holding information about the event (not used)

void  DlgPrefs::OnBtnOk( wxCommandEvent & WXUNUSED( roEvtCmd ) )
{
  Save( );

  EndModal( wxID_OK );
}

//**************************************************************************************************
// Cancel button event handler.
//
// Argument List:
//   roEvtCmd - An object holding information about the event (not used)

void  DlgPrefs::OnBtnCancel( wxCommandEvent & WXUNUSED( roEvtCmd ) )
{
  Load( );

  EndModal( wxID_CANCEL );
}

//**************************************************************************************************
