
/***************************************************************************
 *            ho_recognize_font_6.h
 *
 *  Fri Aug 12 20:13:33 2005
 *  Copyright  2005-2008  Yaacov Zamir
 *  <kzamir@walla.co.il>
 ****************************************************************************/

/*  
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/** @file ho_recognize_font_6.h
    @brief libhocr C language header.
    
    libhocr - LIBrary for Hebrew Optical Character Recognition 
*/

#ifndef HO_RECOGNIZE_FONT_6_H
#define HO_RECOGNIZE_FONT_6_H 1

double ho_recognize_font_6_zero (const double *array_in);

double ho_recognize_font_6_one (const double *array_in);

double ho_recognize_font_6_two (const double *array_in);

double ho_recognize_font_6_three (const double *array_in);

double ho_recognize_font_6_four (const double *array_in);

double ho_recognize_font_6_five (const double *array_in);

double ho_recognize_font_6_six (const double *array_in);

double ho_recognize_font_6_seven (const double *array_in);

double ho_recognize_font_6_eight (const double *array_in);

double ho_recognize_font_6_nine (const double *array_in);

double ho_recognize_font_6_dot (const double *array_in);

double ho_recognize_font_6_comma (const double *array_in);

double ho_recognize_font_6_open (const double *array_in);

double ho_recognize_font_6_close (const double *array_in);

double ho_recognize_font_6_minus (const double *array_in);

double ho_recognize_font_6_plus (const double *array_in);

double ho_recognize_font_6_div (const double *array_in);

double ho_recognize_font_6_tag (const double *array_in);

double ho_recognize_font_6_two_tags (const double *array_in);

double ho_recognize_font_6_question (const double *array_in);

double ho_recognize_font_6_exclem (const double *array_in);

double ho_recognize_font_6_dot_dot (const double *array_in);

double ho_recognize_font_6_dot_comma (const double *array_in);

double ho_recognize_font_6_alef (const double *array_in);

double ho_recognize_font_6_bet (const double *array_in);

double ho_recognize_font_6_gimal (const double *array_in);

double ho_recognize_font_6_dalet (const double *array_in);

double ho_recognize_font_6_hey (const double *array_in);

double ho_recognize_font_6_vav (const double *array_in);

double ho_recognize_font_6_zayin (const double *array_in);

double ho_recognize_font_6_het (const double *array_in);

double ho_recognize_font_6_tet (const double *array_in);

double ho_recognize_font_6_yud (const double *array_in);

double ho_recognize_font_6_caf (const double *array_in);

double ho_recognize_font_6_caf_sofit (const double *array_in);

double ho_recognize_font_6_lamed (const double *array_in);

double ho_recognize_font_6_mem (const double *array_in);

double ho_recognize_font_6_mem_sofit (const double *array_in);

double ho_recognize_font_6_nun (const double *array_in);

double ho_recognize_font_6_nun_sofit (const double *array_in);

double ho_recognize_font_6_samech (const double *array_in);

double ho_recognize_font_6_ayin (const double *array_in);

double ho_recognize_font_6_pey (const double *array_in);

double ho_recognize_font_6_pey_sofit (const double *array_in);

double ho_recognize_font_6_tzadi (const double *array_in);

double ho_recognize_font_6_tzadi_sofit (const double *array_in);

double ho_recognize_font_6_kuf (const double *array_in);

double ho_recognize_font_6_resh (const double *array_in);

double ho_recognize_font_6_shin (const double *array_in);

double ho_recognize_font_6_tav (const double *array_in);

#endif /* HO_RECOGNIZE_FONT_6_H */
