package CParse::Op::Call;

use 5.6.0;
use strict;
use warnings;

use CParse::Op;

our @ISA = qw/CParse::Op/;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $args = shift;

    my $self = {args => $args,
               };
    bless $self, $class;
    return $self;
  }

sub set_prefix
  {
    my $self = shift;
    $self->{func} = shift;
  }

sub args
  {
    my $self = shift;
    return ($self->{func}, $self->{args});
  }

sub dump_c
  {
    my $self = shift;
    my $func = $self->{func}->dump_c;
    my $args = join(', ', map {$_->dump_c} @{$self->{args}});

    return "($func($args))";
  }

1;
