
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAction.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAction>
#include <QGraphicsWidget>
#include <QMenu>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAction

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAction::staticMetaObject);
}


// QActionGroup *QAction::actionGroup()


static void _init_f_actionGroup_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QActionGroup * > ();
}

static void _call_f_actionGroup_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QActionGroup * > ((QActionGroup *)((QAction *)cls)->actionGroup ());
}


// void QAction::activate(QAction::ActionEvent event)


static void _init_f_activate_2359 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<const qt_gsi::Converter<QAction::ActionEvent>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_activate_2359 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAction::ActionEvent>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAction::ActionEvent>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->activate (qt_gsi::QtToCppAdaptor<QAction::ActionEvent>(arg1).cref());
}


// QList<QGraphicsWidget *> QAction::associatedGraphicsWidgets()


static void _init_f_associatedGraphicsWidgets_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QGraphicsWidget *> > ();
}

static void _call_f_associatedGraphicsWidgets_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QGraphicsWidget *> > ((QList<QGraphicsWidget *>)((QAction *)cls)->associatedGraphicsWidgets ());
}


// QList<QWidget *> QAction::associatedWidgets()


static void _init_f_associatedWidgets_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QWidget *> > ();
}

static void _call_f_associatedWidgets_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QWidget *> > ((QList<QWidget *>)((QAction *)cls)->associatedWidgets ());
}


// bool QAction::autoRepeat()


static void _init_f_autoRepeat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_autoRepeat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAction *)cls)->autoRepeat ());
}


// QVariant QAction::data()


static void _init_f_data_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVariant > ();
}

static void _call_f_data_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVariant > ((QVariant)((QAction *)cls)->data ());
}


// QFont QAction::font()


static void _init_f_font_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFont > ();
}

static void _call_f_font_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFont > ((QFont)((QAction *)cls)->font ());
}


// void QAction::hover()


static void _init_f_hover_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_hover_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->hover ();
}


// QIcon QAction::icon()


static void _init_f_icon_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIcon > ();
}

static void _call_f_icon_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QIcon > ((QIcon)((QAction *)cls)->icon ());
}


// QString QAction::iconText()


static void _init_f_iconText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_iconText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QAction *)cls)->iconText ());
}


// bool QAction::isCheckable()


static void _init_f_isCheckable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isCheckable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAction *)cls)->isCheckable ());
}


// bool QAction::isChecked()


static void _init_f_isChecked_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isChecked_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAction *)cls)->isChecked ());
}


// bool QAction::isEnabled()


static void _init_f_isEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAction *)cls)->isEnabled ());
}


// bool QAction::isIconVisibleInMenu()


static void _init_f_isIconVisibleInMenu_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isIconVisibleInMenu_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAction *)cls)->isIconVisibleInMenu ());
}


// bool QAction::isSeparator()


static void _init_f_isSeparator_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSeparator_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAction *)cls)->isSeparator ());
}


// bool QAction::isVisible()


static void _init_f_isVisible_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isVisible_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAction *)cls)->isVisible ());
}


// QMenu *QAction::menu()


static void _init_f_menu_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMenu * > ();
}

static void _call_f_menu_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMenu * > ((QMenu *)((QAction *)cls)->menu ());
}


// QAction::MenuRole QAction::menuRole()


static void _init_f_menuRole_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAction::MenuRole>::target_type > ();
}

static void _call_f_menuRole_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAction::MenuRole>::target_type > ((qt_gsi::Converter<QAction::MenuRole>::target_type)qt_gsi::CppToQtAdaptor<QAction::MenuRole>(((QAction *)cls)->menuRole ()));
}


// QWidget *QAction::parentWidget()


static void _init_f_parentWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_parentWidget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QAction *)cls)->parentWidget ());
}


// QAction::Priority QAction::priority()


static void _init_f_priority_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAction::Priority>::target_type > ();
}

static void _call_f_priority_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAction::Priority>::target_type > ((qt_gsi::Converter<QAction::Priority>::target_type)qt_gsi::CppToQtAdaptor<QAction::Priority>(((QAction *)cls)->priority ()));
}


// void QAction::setActionGroup(QActionGroup *group)


static void _init_f_setActionGroup_1834 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("group");
  decl->add_arg<QActionGroup * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActionGroup_1834 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionGroup *arg1 = gsi::arg_reader<QActionGroup * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setActionGroup (arg1);
}


// void QAction::setAutoRepeat(bool)


static void _init_f_setAutoRepeat_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAutoRepeat_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setAutoRepeat (arg1);
}


// void QAction::setCheckable(bool)


static void _init_f_setCheckable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCheckable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setCheckable (arg1);
}


// void QAction::setChecked(bool)


static void _init_f_setChecked_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setChecked_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setChecked (arg1);
}


// void QAction::setData(const QVariant &var)


static void _init_f_setData_2119 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("var");
  decl->add_arg<const QVariant & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setData_2119 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVariant &arg1 = gsi::arg_reader<const QVariant & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setData (arg1);
}


// void QAction::setDisabled(bool b)


static void _init_f_setDisabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDisabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setDisabled (arg1);
}


// void QAction::setEnabled(bool)


static void _init_f_setEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setEnabled (arg1);
}


// void QAction::setFont(const QFont &font)


static void _init_f_setFont_1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("font");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFont_1801 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = gsi::arg_reader<const QFont & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setFont (arg1);
}


// void QAction::setIcon(const QIcon &icon)


static void _init_f_setIcon_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIcon_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setIcon (arg1);
}


// void QAction::setIconText(const QString &text)


static void _init_f_setIconText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIconText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setIconText (arg1);
}


// void QAction::setIconVisibleInMenu(bool visible)


static void _init_f_setIconVisibleInMenu_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIconVisibleInMenu_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setIconVisibleInMenu (arg1);
}


// void QAction::setMenu(QMenu *menu)


static void _init_f_setMenu_1108 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("menu");
  decl->add_arg<QMenu * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMenu_1108 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMenu *arg1 = gsi::arg_reader<QMenu * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setMenu (arg1);
}


// void QAction::setMenuRole(QAction::MenuRole menuRole)


static void _init_f_setMenuRole_2046 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("menuRole");
  decl->add_arg<const qt_gsi::Converter<QAction::MenuRole>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMenuRole_2046 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAction::MenuRole>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAction::MenuRole>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setMenuRole (qt_gsi::QtToCppAdaptor<QAction::MenuRole>(arg1).cref());
}


// void QAction::setPriority(QAction::Priority priority)


static void _init_f_setPriority_2105 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("priority");
  decl->add_arg<const qt_gsi::Converter<QAction::Priority>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPriority_2105 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAction::Priority>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAction::Priority>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setPriority (qt_gsi::QtToCppAdaptor<QAction::Priority>(arg1).cref());
}


// void QAction::setSeparator(bool b)


static void _init_f_setSeparator_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSeparator_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setSeparator (arg1);
}


// void QAction::setShortcut(const QKeySequence &shortcut)


static void _init_f_setShortcut_2516 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("shortcut");
  decl->add_arg<const QKeySequence & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setShortcut_2516 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QKeySequence &arg1 = gsi::arg_reader<const QKeySequence & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setShortcut (arg1);
}


// void QAction::setShortcutContext(Qt::ShortcutContext context)


static void _init_f_setShortcutContext_2350 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("context");
  decl->add_arg<const qt_gsi::Converter<Qt::ShortcutContext>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setShortcutContext_2350 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ShortcutContext>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::ShortcutContext>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setShortcutContext (qt_gsi::QtToCppAdaptor<Qt::ShortcutContext>(arg1).cref());
}


// void QAction::setShortcuts(const QList<QKeySequence> &shortcuts)


static void _init_f_setShortcuts_3131 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("shortcuts");
  decl->add_arg<const QList<QKeySequence> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setShortcuts_3131 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QKeySequence> &arg1 = gsi::arg_reader<const QList<QKeySequence> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setShortcuts (arg1);
}


// void QAction::setShortcuts(QKeySequence::StandardKey)


static void _init_f_setShortcuts_2869 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QKeySequence::StandardKey>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setShortcuts_2869 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QKeySequence::StandardKey>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QKeySequence::StandardKey>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setShortcuts (qt_gsi::QtToCppAdaptor<QKeySequence::StandardKey>(arg1).cref());
}


// void QAction::setSoftKeyRole(QAction::SoftKeyRole softKeyRole)


static void _init_f_setSoftKeyRole_2350 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("softKeyRole");
  decl->add_arg<const qt_gsi::Converter<QAction::SoftKeyRole>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSoftKeyRole_2350 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAction::SoftKeyRole>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAction::SoftKeyRole>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setSoftKeyRole (qt_gsi::QtToCppAdaptor<QAction::SoftKeyRole>(arg1).cref());
}


// void QAction::setStatusTip(const QString &statusTip)


static void _init_f_setStatusTip_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("statusTip");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStatusTip_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setStatusTip (arg1);
}


// void QAction::setText(const QString &text)


static void _init_f_setText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setText (arg1);
}


// void QAction::setToolTip(const QString &tip)


static void _init_f_setToolTip_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tip");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setToolTip_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setToolTip (arg1);
}


// void QAction::setVisible(bool)


static void _init_f_setVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVisible_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setVisible (arg1);
}


// void QAction::setWhatsThis(const QString &what)


static void _init_f_setWhatsThis_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("what");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWhatsThis_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->setWhatsThis (arg1);
}


// QKeySequence QAction::shortcut()


static void _init_f_shortcut_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QKeySequence > ();
}

static void _call_f_shortcut_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QKeySequence > ((QKeySequence)((QAction *)cls)->shortcut ());
}


// Qt::ShortcutContext QAction::shortcutContext()


static void _init_f_shortcutContext_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::ShortcutContext>::target_type > ();
}

static void _call_f_shortcutContext_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::ShortcutContext>::target_type > ((qt_gsi::Converter<Qt::ShortcutContext>::target_type)qt_gsi::CppToQtAdaptor<Qt::ShortcutContext>(((QAction *)cls)->shortcutContext ()));
}


// QList<QKeySequence> QAction::shortcuts()


static void _init_f_shortcuts_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QKeySequence> > ();
}

static void _call_f_shortcuts_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QKeySequence> > ((QList<QKeySequence>)((QAction *)cls)->shortcuts ());
}


// bool QAction::showStatusText(QWidget *widget)


static void _init_f_showStatusText_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_showStatusText_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  ret.write<bool > ((bool)((QAction *)cls)->showStatusText (arg1));
}


// QAction::SoftKeyRole QAction::softKeyRole()


static void _init_f_softKeyRole_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAction::SoftKeyRole>::target_type > ();
}

static void _call_f_softKeyRole_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAction::SoftKeyRole>::target_type > ((qt_gsi::Converter<QAction::SoftKeyRole>::target_type)qt_gsi::CppToQtAdaptor<QAction::SoftKeyRole>(((QAction *)cls)->softKeyRole ()));
}


// QString QAction::statusTip()


static void _init_f_statusTip_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_statusTip_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QAction *)cls)->statusTip ());
}


// QString QAction::text()


static void _init_f_text_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_text_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QAction *)cls)->text ());
}


// void QAction::toggle()


static void _init_f_toggle_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_toggle_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->toggle ();
}


// QString QAction::toolTip()


static void _init_f_toolTip_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toolTip_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QAction *)cls)->toolTip ());
}


// void QAction::trigger()


static void _init_f_trigger_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_trigger_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction *)cls)->trigger ();
}


// QString QAction::whatsThis()


static void _init_f_whatsThis_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_whatsThis_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QAction *)cls)->whatsThis ());
}


// static QString QAction::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QAction::tr (arg1, arg2));
}


// static QString QAction::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QAction::tr (arg1, arg2, arg3));
}


// static QString QAction::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QAction::trUtf8 (arg1, arg2));
}


// static QString QAction::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QAction::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QAction () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":actionGroup", "@brief Method QActionGroup *QAction::actionGroup()\n", true, &_init_f_actionGroup_c0, &_call_f_actionGroup_c0);
  methods += new qt_gsi::GenericMethod ("activate", "@brief Method void QAction::activate(QAction::ActionEvent event)\n", false, &_init_f_activate_2359, &_call_f_activate_2359);
  methods += new qt_gsi::GenericMethod ("associatedGraphicsWidgets", "@brief Method QList<QGraphicsWidget *> QAction::associatedGraphicsWidgets()\n", true, &_init_f_associatedGraphicsWidgets_c0, &_call_f_associatedGraphicsWidgets_c0);
  methods += new qt_gsi::GenericMethod ("associatedWidgets", "@brief Method QList<QWidget *> QAction::associatedWidgets()\n", true, &_init_f_associatedWidgets_c0, &_call_f_associatedWidgets_c0);
  methods += new qt_gsi::GenericMethod (":autoRepeat", "@brief Method bool QAction::autoRepeat()\n", true, &_init_f_autoRepeat_c0, &_call_f_autoRepeat_c0);
  methods += new qt_gsi::GenericMethod (":data", "@brief Method QVariant QAction::data()\n", true, &_init_f_data_c0, &_call_f_data_c0);
  methods += new qt_gsi::GenericMethod (":font", "@brief Method QFont QAction::font()\n", true, &_init_f_font_c0, &_call_f_font_c0);
  methods += new qt_gsi::GenericMethod ("hover", "@brief Method void QAction::hover()\n", false, &_init_f_hover_0, &_call_f_hover_0);
  methods += new qt_gsi::GenericMethod (":icon", "@brief Method QIcon QAction::icon()\n", true, &_init_f_icon_c0, &_call_f_icon_c0);
  methods += new qt_gsi::GenericMethod (":iconText", "@brief Method QString QAction::iconText()\n", true, &_init_f_iconText_c0, &_call_f_iconText_c0);
  methods += new qt_gsi::GenericMethod ("isCheckable?|:checkable", "@brief Method bool QAction::isCheckable()\n", true, &_init_f_isCheckable_c0, &_call_f_isCheckable_c0);
  methods += new qt_gsi::GenericMethod ("isChecked?|:checked", "@brief Method bool QAction::isChecked()\n", true, &_init_f_isChecked_c0, &_call_f_isChecked_c0);
  methods += new qt_gsi::GenericMethod ("isEnabled?|:enabled", "@brief Method bool QAction::isEnabled()\n", true, &_init_f_isEnabled_c0, &_call_f_isEnabled_c0);
  methods += new qt_gsi::GenericMethod ("isIconVisibleInMenu?|:iconVisibleInMenu", "@brief Method bool QAction::isIconVisibleInMenu()\n", true, &_init_f_isIconVisibleInMenu_c0, &_call_f_isIconVisibleInMenu_c0);
  methods += new qt_gsi::GenericMethod ("isSeparator?|:separator", "@brief Method bool QAction::isSeparator()\n", true, &_init_f_isSeparator_c0, &_call_f_isSeparator_c0);
  methods += new qt_gsi::GenericMethod ("isVisible?|:visible", "@brief Method bool QAction::isVisible()\n", true, &_init_f_isVisible_c0, &_call_f_isVisible_c0);
  methods += new qt_gsi::GenericMethod (":menu", "@brief Method QMenu *QAction::menu()\n", true, &_init_f_menu_c0, &_call_f_menu_c0);
  methods += new qt_gsi::GenericMethod (":menuRole", "@brief Method QAction::MenuRole QAction::menuRole()\n", true, &_init_f_menuRole_c0, &_call_f_menuRole_c0);
  methods += new qt_gsi::GenericMethod ("parentWidget", "@brief Method QWidget *QAction::parentWidget()\n", true, &_init_f_parentWidget_c0, &_call_f_parentWidget_c0);
  methods += new qt_gsi::GenericMethod (":priority", "@brief Method QAction::Priority QAction::priority()\n", true, &_init_f_priority_c0, &_call_f_priority_c0);
  methods += new qt_gsi::GenericMethod ("setActionGroup|actionGroup=", "@brief Method void QAction::setActionGroup(QActionGroup *group)\n", false, &_init_f_setActionGroup_1834, &_call_f_setActionGroup_1834);
  methods += new qt_gsi::GenericMethod ("setAutoRepeat|autoRepeat=", "@brief Method void QAction::setAutoRepeat(bool)\n", false, &_init_f_setAutoRepeat_864, &_call_f_setAutoRepeat_864);
  methods += new qt_gsi::GenericMethod ("setCheckable|checkable=", "@brief Method void QAction::setCheckable(bool)\n", false, &_init_f_setCheckable_864, &_call_f_setCheckable_864);
  methods += new qt_gsi::GenericMethod ("setChecked|checked=", "@brief Method void QAction::setChecked(bool)\n", false, &_init_f_setChecked_864, &_call_f_setChecked_864);
  methods += new qt_gsi::GenericMethod ("setData|data=", "@brief Method void QAction::setData(const QVariant &var)\n", false, &_init_f_setData_2119, &_call_f_setData_2119);
  methods += new qt_gsi::GenericMethod ("setDisabled", "@brief Method void QAction::setDisabled(bool b)\n", false, &_init_f_setDisabled_864, &_call_f_setDisabled_864);
  methods += new qt_gsi::GenericMethod ("setEnabled|enabled=", "@brief Method void QAction::setEnabled(bool)\n", false, &_init_f_setEnabled_864, &_call_f_setEnabled_864);
  methods += new qt_gsi::GenericMethod ("setFont|font=", "@brief Method void QAction::setFont(const QFont &font)\n", false, &_init_f_setFont_1801, &_call_f_setFont_1801);
  methods += new qt_gsi::GenericMethod ("setIcon|icon=", "@brief Method void QAction::setIcon(const QIcon &icon)\n", false, &_init_f_setIcon_1787, &_call_f_setIcon_1787);
  methods += new qt_gsi::GenericMethod ("setIconText|iconText=", "@brief Method void QAction::setIconText(const QString &text)\n", false, &_init_f_setIconText_2025, &_call_f_setIconText_2025);
  methods += new qt_gsi::GenericMethod ("setIconVisibleInMenu|iconVisibleInMenu=", "@brief Method void QAction::setIconVisibleInMenu(bool visible)\n", false, &_init_f_setIconVisibleInMenu_864, &_call_f_setIconVisibleInMenu_864);
  methods += new qt_gsi::GenericMethod ("setMenu|menu=", "@brief Method void QAction::setMenu(QMenu *menu)\n", false, &_init_f_setMenu_1108, &_call_f_setMenu_1108);
  methods += new qt_gsi::GenericMethod ("setMenuRole|menuRole=", "@brief Method void QAction::setMenuRole(QAction::MenuRole menuRole)\n", false, &_init_f_setMenuRole_2046, &_call_f_setMenuRole_2046);
  methods += new qt_gsi::GenericMethod ("setPriority|priority=", "@brief Method void QAction::setPriority(QAction::Priority priority)\n", false, &_init_f_setPriority_2105, &_call_f_setPriority_2105);
  methods += new qt_gsi::GenericMethod ("setSeparator|separator=", "@brief Method void QAction::setSeparator(bool b)\n", false, &_init_f_setSeparator_864, &_call_f_setSeparator_864);
  methods += new qt_gsi::GenericMethod ("setShortcut|shortcut=", "@brief Method void QAction::setShortcut(const QKeySequence &shortcut)\n", false, &_init_f_setShortcut_2516, &_call_f_setShortcut_2516);
  methods += new qt_gsi::GenericMethod ("setShortcutContext|shortcutContext=", "@brief Method void QAction::setShortcutContext(Qt::ShortcutContext context)\n", false, &_init_f_setShortcutContext_2350, &_call_f_setShortcutContext_2350);
  methods += new qt_gsi::GenericMethod ("setShortcuts|shortcuts=", "@brief Method void QAction::setShortcuts(const QList<QKeySequence> &shortcuts)\n", false, &_init_f_setShortcuts_3131, &_call_f_setShortcuts_3131);
  methods += new qt_gsi::GenericMethod ("setShortcuts|shortcuts=", "@brief Method void QAction::setShortcuts(QKeySequence::StandardKey)\n", false, &_init_f_setShortcuts_2869, &_call_f_setShortcuts_2869);
  methods += new qt_gsi::GenericMethod ("setSoftKeyRole|softKeyRole=", "@brief Method void QAction::setSoftKeyRole(QAction::SoftKeyRole softKeyRole)\n", false, &_init_f_setSoftKeyRole_2350, &_call_f_setSoftKeyRole_2350);
  methods += new qt_gsi::GenericMethod ("setStatusTip|statusTip=", "@brief Method void QAction::setStatusTip(const QString &statusTip)\n", false, &_init_f_setStatusTip_2025, &_call_f_setStatusTip_2025);
  methods += new qt_gsi::GenericMethod ("setText|text=", "@brief Method void QAction::setText(const QString &text)\n", false, &_init_f_setText_2025, &_call_f_setText_2025);
  methods += new qt_gsi::GenericMethod ("setToolTip|toolTip=", "@brief Method void QAction::setToolTip(const QString &tip)\n", false, &_init_f_setToolTip_2025, &_call_f_setToolTip_2025);
  methods += new qt_gsi::GenericMethod ("setVisible|visible=", "@brief Method void QAction::setVisible(bool)\n", false, &_init_f_setVisible_864, &_call_f_setVisible_864);
  methods += new qt_gsi::GenericMethod ("setWhatsThis|whatsThis=", "@brief Method void QAction::setWhatsThis(const QString &what)\n", false, &_init_f_setWhatsThis_2025, &_call_f_setWhatsThis_2025);
  methods += new qt_gsi::GenericMethod (":shortcut", "@brief Method QKeySequence QAction::shortcut()\n", true, &_init_f_shortcut_c0, &_call_f_shortcut_c0);
  methods += new qt_gsi::GenericMethod (":shortcutContext", "@brief Method Qt::ShortcutContext QAction::shortcutContext()\n", true, &_init_f_shortcutContext_c0, &_call_f_shortcutContext_c0);
  methods += new qt_gsi::GenericMethod (":shortcuts", "@brief Method QList<QKeySequence> QAction::shortcuts()\n", true, &_init_f_shortcuts_c0, &_call_f_shortcuts_c0);
  methods += new qt_gsi::GenericMethod ("showStatusText", "@brief Method bool QAction::showStatusText(QWidget *widget)\n", false, &_init_f_showStatusText_1315, &_call_f_showStatusText_1315);
  methods += new qt_gsi::GenericMethod (":softKeyRole", "@brief Method QAction::SoftKeyRole QAction::softKeyRole()\n", true, &_init_f_softKeyRole_c0, &_call_f_softKeyRole_c0);
  methods += new qt_gsi::GenericMethod (":statusTip", "@brief Method QString QAction::statusTip()\n", true, &_init_f_statusTip_c0, &_call_f_statusTip_c0);
  methods += new qt_gsi::GenericMethod (":text", "@brief Method QString QAction::text()\n", true, &_init_f_text_c0, &_call_f_text_c0);
  methods += new qt_gsi::GenericMethod ("toggle", "@brief Method void QAction::toggle()\n", false, &_init_f_toggle_0, &_call_f_toggle_0);
  methods += new qt_gsi::GenericMethod (":toolTip", "@brief Method QString QAction::toolTip()\n", true, &_init_f_toolTip_c0, &_call_f_toolTip_c0);
  methods += new qt_gsi::GenericMethod ("trigger", "@brief Method void QAction::trigger()\n", false, &_init_f_trigger_0, &_call_f_trigger_0);
  methods += new qt_gsi::GenericMethod (":whatsThis", "@brief Method QString QAction::whatsThis()\n", true, &_init_f_whatsThis_c0, &_call_f_whatsThis_c0);
  methods += gsi::qt_signal ("changed()", "changed", "@brief Signal declaration for QAction::changed()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QAction::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("hovered()", "hovered", "@brief Signal declaration for QAction::hovered()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("toggled(bool)", "toggled", gsi::arg("arg1"), "@brief Signal declaration for QAction::toggled(bool)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("triggered(bool)", "triggered", gsi::arg("checked"), "@brief Signal declaration for QAction::triggered(bool checked)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAction::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAction::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAction::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAction::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QAction> decl_QAction (qtdecl_QObject (), "QtGui", "QAction_Native",
  methods_QAction (),
  "@hide\n@alias QAction");

GSI_QTGUI_PUBLIC gsi::Class<QAction> &qtdecl_QAction () { return decl_QAction; }

}


class QAction_Adaptor : public QAction, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAction_Adaptor();

  //  [adaptor ctor] QAction::QAction(QObject *parent)
  QAction_Adaptor(QObject *parent) : QAction(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QAction::QAction(const QString &text, QObject *parent)
  QAction_Adaptor(const QString &text, QObject *parent) : QAction(text, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QAction::QAction(const QIcon &icon, const QString &text, QObject *parent)
  QAction_Adaptor(const QIcon &icon, const QString &text, QObject *parent) : QAction(icon, text, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] int QAction::receivers(const char *signal)
  int fp_QAction_receivers_c1731 (const char *signal) const {
    return QAction::receivers(signal);
  }

  //  [expose] QObject *QAction::sender()
  QObject * fp_QAction_sender_c0 () const {
    return QAction::sender();
  }

  //  [adaptor impl] bool QAction::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QAction::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QAction_Adaptor, bool, QObject *, QEvent *>(&QAction_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QAction::eventFilter(arg1, arg2);
    }
  }

  //  [emitter impl] void QAction::changed()
  void emitter_QAction_changed_0()
  {
    emit QAction::changed();
  }

  //  [adaptor impl] void QAction::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QAction::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QAction_Adaptor, QChildEvent *>(&QAction_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QAction::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QAction::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QAction::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QAction_Adaptor, QEvent *>(&QAction_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QAction::customEvent(arg1);
    }
  }

  //  [emitter impl] void QAction::destroyed(QObject *)
  void emitter_QAction_destroyed_1302(QObject *arg1)
  {
    emit QAction::destroyed(arg1);
  }

  //  [adaptor impl] void QAction::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QAction::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QAction_Adaptor, const char *>(&QAction_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QAction::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QAction::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QAction::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QAction_Adaptor, bool, QEvent *>(&QAction_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QAction::event(arg1);
    }
  }

  //  [emitter impl] void QAction::hovered()
  void emitter_QAction_hovered_0()
  {
    emit QAction::hovered();
  }

  //  [adaptor impl] void QAction::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QAction::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QAction_Adaptor, QTimerEvent *>(&QAction_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QAction::timerEvent(arg1);
    }
  }

  //  [emitter impl] void QAction::toggled(bool)
  void emitter_QAction_toggled_864(bool arg1)
  {
    emit QAction::toggled(arg1);
  }

  //  [emitter impl] void QAction::triggered(bool checked)
  void emitter_QAction_triggered_864(bool checked)
  {
    emit QAction::triggered(checked);
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QAction_Adaptor::~QAction_Adaptor() { }

//  Constructor QAction::QAction(QObject *parent) (adaptor class)

static void _init_ctor_QAction_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QAction_Adaptor> ();
}

static void _call_ctor_QAction_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  ret.write<QAction_Adaptor *> (new QAction_Adaptor (arg1));
}


//  Constructor QAction::QAction(const QString &text, QObject *parent) (adaptor class)

static void _init_ctor_QAction_Adaptor_3219 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QAction_Adaptor> ();
}

static void _call_ctor_QAction_Adaptor_3219 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  QObject *arg2 = gsi::arg_reader<QObject * >() (args, heap);
  ret.write<QAction_Adaptor *> (new QAction_Adaptor (arg1, arg2));
}


//  Constructor QAction::QAction(const QIcon &icon, const QString &text, QObject *parent) (adaptor class)

static void _init_ctor_QAction_Adaptor_4898 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<QObject * > (argspec_2);
  decl->set_return_new<QAction_Adaptor> ();
}

static void _call_ctor_QAction_Adaptor_4898 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  QObject *arg3 = gsi::arg_reader<QObject * >() (args, heap);
  ret.write<QAction_Adaptor *> (new QAction_Adaptor (arg1, arg2, arg3));
}


// emitter void QAction::changed()

static void _init_emitter_changed_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_changed_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QAction_Adaptor *)cls)->emitter_QAction_changed_0 ();
}


// void QAction::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAction_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QAction::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAction_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QAction::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QAction_Adaptor *)cls)->emitter_QAction_destroyed_1302 (arg1);
}


// void QAction::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QAction_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// bool QAction::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAction_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAction_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QAction::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAction_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAction_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QAction::hovered()

static void _init_emitter_hovered_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_hovered_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QAction_Adaptor *)cls)->emitter_QAction_hovered_0 ();
}


// exposed int QAction::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QAction_Adaptor *)cls)->fp_QAction_receivers_c1731 (arg1));
}


// exposed QObject *QAction::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QAction_Adaptor *)cls)->fp_QAction_sender_c0 ());
}


// void QAction::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAction_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QAction_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// emitter void QAction::toggled(bool)

static void _init_emitter_toggled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_toggled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QAction_Adaptor *)cls)->emitter_QAction_toggled_864 (arg1);
}


// emitter void QAction::triggered(bool checked)

static void _init_emitter_triggered_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("checked", true, "false");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_triggered_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (false, heap);
  ((QAction_Adaptor *)cls)->emitter_QAction_triggered_864 (arg1);
}


namespace gsi
{

gsi::Class<QAction> &qtdecl_QAction ();

static gsi::Methods methods_QAction_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAction::QAction(QObject *parent)\nThis method creates an object of class QAction.", &_init_ctor_QAction_Adaptor_1302, &_call_ctor_QAction_Adaptor_1302);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAction::QAction(const QString &text, QObject *parent)\nThis method creates an object of class QAction.", &_init_ctor_QAction_Adaptor_3219, &_call_ctor_QAction_Adaptor_3219);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAction::QAction(const QIcon &icon, const QString &text, QObject *parent)\nThis method creates an object of class QAction.", &_init_ctor_QAction_Adaptor_4898, &_call_ctor_QAction_Adaptor_4898);
  methods += new qt_gsi::GenericMethod ("emit_changed", "@brief Emitter for signal void QAction::changed()\nCall this method to emit this signal.", false, &_init_emitter_changed_0, &_call_emitter_changed_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QAction::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QAction::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QAction::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QAction::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QAction::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QAction::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_hovered", "@brief Emitter for signal void QAction::hovered()\nCall this method to emit this signal.", false, &_init_emitter_hovered_0, &_call_emitter_hovered_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QAction::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QAction::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QAction::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("emit_toggled", "@brief Emitter for signal void QAction::toggled(bool)\nCall this method to emit this signal.", false, &_init_emitter_toggled_864, &_call_emitter_toggled_864);
  methods += new qt_gsi::GenericMethod ("emit_triggered", "@brief Emitter for signal void QAction::triggered(bool checked)\nCall this method to emit this signal.", false, &_init_emitter_triggered_864, &_call_emitter_triggered_864);
  return methods;
}

gsi::Class<QAction_Adaptor> decl_QAction_Adaptor (qtdecl_QAction (), "QtGui", "QAction",
  methods_QAction_Adaptor (),
  "@qt\n@brief Binding of QAction");

}


//  Implementation of the enum wrapper class for QAction::ActionEvent
namespace qt_gsi
{

static gsi::Enum<QAction::ActionEvent> decl_QAction_ActionEvent_Enum ("QtGui", "QAction_ActionEvent",
    gsi::enum_const ("Trigger", QAction::Trigger, "@brief Enum constant QAction::Trigger") +
    gsi::enum_const ("Hover", QAction::Hover, "@brief Enum constant QAction::Hover"),
  "@qt\n@brief This class represents the QAction::ActionEvent enum");

static gsi::QFlagsClass<QAction::ActionEvent > decl_QAction_ActionEvent_Enums ("QtGui", "QAction_QFlags_ActionEvent",
  "@qt\n@brief This class represents the QFlags<QAction::ActionEvent> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAction> inject_QAction_ActionEvent_Enum_in_parent (decl_QAction_ActionEvent_Enum.defs ());
static gsi::ClassExt<QAction> decl_QAction_ActionEvent_Enum_as_child (decl_QAction_ActionEvent_Enum, "ActionEvent");
static gsi::ClassExt<QAction> decl_QAction_ActionEvent_Enums_as_child (decl_QAction_ActionEvent_Enums, "QFlags_ActionEvent");

}


//  Implementation of the enum wrapper class for QAction::MenuRole
namespace qt_gsi
{

static gsi::Enum<QAction::MenuRole> decl_QAction_MenuRole_Enum ("QtGui", "QAction_MenuRole",
    gsi::enum_const ("NoRole", QAction::NoRole, "@brief Enum constant QAction::NoRole") +
    gsi::enum_const ("TextHeuristicRole", QAction::TextHeuristicRole, "@brief Enum constant QAction::TextHeuristicRole") +
    gsi::enum_const ("ApplicationSpecificRole", QAction::ApplicationSpecificRole, "@brief Enum constant QAction::ApplicationSpecificRole") +
    gsi::enum_const ("AboutQtRole", QAction::AboutQtRole, "@brief Enum constant QAction::AboutQtRole") +
    gsi::enum_const ("AboutRole", QAction::AboutRole, "@brief Enum constant QAction::AboutRole") +
    gsi::enum_const ("PreferencesRole", QAction::PreferencesRole, "@brief Enum constant QAction::PreferencesRole") +
    gsi::enum_const ("QuitRole", QAction::QuitRole, "@brief Enum constant QAction::QuitRole"),
  "@qt\n@brief This class represents the QAction::MenuRole enum");

static gsi::QFlagsClass<QAction::MenuRole > decl_QAction_MenuRole_Enums ("QtGui", "QAction_QFlags_MenuRole",
  "@qt\n@brief This class represents the QFlags<QAction::MenuRole> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAction> inject_QAction_MenuRole_Enum_in_parent (decl_QAction_MenuRole_Enum.defs ());
static gsi::ClassExt<QAction> decl_QAction_MenuRole_Enum_as_child (decl_QAction_MenuRole_Enum, "MenuRole");
static gsi::ClassExt<QAction> decl_QAction_MenuRole_Enums_as_child (decl_QAction_MenuRole_Enums, "QFlags_MenuRole");

}


//  Implementation of the enum wrapper class for QAction::Priority
namespace qt_gsi
{

static gsi::Enum<QAction::Priority> decl_QAction_Priority_Enum ("QtGui", "QAction_Priority",
    gsi::enum_const ("LowPriority", QAction::LowPriority, "@brief Enum constant QAction::LowPriority") +
    gsi::enum_const ("NormalPriority", QAction::NormalPriority, "@brief Enum constant QAction::NormalPriority") +
    gsi::enum_const ("HighPriority", QAction::HighPriority, "@brief Enum constant QAction::HighPriority"),
  "@qt\n@brief This class represents the QAction::Priority enum");

static gsi::QFlagsClass<QAction::Priority > decl_QAction_Priority_Enums ("QtGui", "QAction_QFlags_Priority",
  "@qt\n@brief This class represents the QFlags<QAction::Priority> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAction> inject_QAction_Priority_Enum_in_parent (decl_QAction_Priority_Enum.defs ());
static gsi::ClassExt<QAction> decl_QAction_Priority_Enum_as_child (decl_QAction_Priority_Enum, "Priority");
static gsi::ClassExt<QAction> decl_QAction_Priority_Enums_as_child (decl_QAction_Priority_Enums, "QFlags_Priority");

}


//  Implementation of the enum wrapper class for QAction::SoftKeyRole
namespace qt_gsi
{

static gsi::Enum<QAction::SoftKeyRole> decl_QAction_SoftKeyRole_Enum ("QtGui", "QAction_SoftKeyRole",
    gsi::enum_const ("NoSoftKey", QAction::NoSoftKey, "@brief Enum constant QAction::NoSoftKey") +
    gsi::enum_const ("PositiveSoftKey", QAction::PositiveSoftKey, "@brief Enum constant QAction::PositiveSoftKey") +
    gsi::enum_const ("NegativeSoftKey", QAction::NegativeSoftKey, "@brief Enum constant QAction::NegativeSoftKey") +
    gsi::enum_const ("SelectSoftKey", QAction::SelectSoftKey, "@brief Enum constant QAction::SelectSoftKey"),
  "@qt\n@brief This class represents the QAction::SoftKeyRole enum");

static gsi::QFlagsClass<QAction::SoftKeyRole > decl_QAction_SoftKeyRole_Enums ("QtGui", "QAction_QFlags_SoftKeyRole",
  "@qt\n@brief This class represents the QFlags<QAction::SoftKeyRole> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAction> inject_QAction_SoftKeyRole_Enum_in_parent (decl_QAction_SoftKeyRole_Enum.defs ());
static gsi::ClassExt<QAction> decl_QAction_SoftKeyRole_Enum_as_child (decl_QAction_SoftKeyRole_Enum, "SoftKeyRole");
static gsi::ClassExt<QAction> decl_QAction_SoftKeyRole_Enums_as_child (decl_QAction_SoftKeyRole_Enums, "QFlags_SoftKeyRole");

}

