/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef TOOL_H
#define TOOL_H

#include <QtCore/QString>

#include "qldap.h"

class Tool
{
  public:
    static int numberOfMails( QLdap* connection, const QString &baseDn,
                              const QString &email, const QStringList &excludedDns );

    static QString dnForMailOrAlias( QLdap* connection, const QString &value );

    static bool deleteObject( QLdap* connection, const QString &dn, QString &errorMsg, bool deleteNow = false );
    static bool deleteSharedFolder( QLdap* connection, const QString &dn, QString &errorMsg, bool deleteNow = false );
    static bool deleteGroupOfNames( QLdap* connection, const QString &dn, QString &errorMsg, bool deleteNow = false );

    static QLdapEntry kolabSettings( QLdap* connection );

    static QString randomString( int length );

    static QString escape( const QString &value );
    static QString escapeDn( const QString &dn );
};

#endif
