package junit.test.svg;

import latexDraw.parsers.svg.SVGCDATASection;
import latexDraw.parsers.svg.SVGDocument;

import org.junit.Test;
import org.w3c.dom.Node;

/** 
 * This class contains tests for the SVGCDATASection class.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 03/30/08<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class TestSVGCDATASection extends TestSVGText
{
	@Override
	@Test
	public void testGetNodeType()
	{
		SVGCDATASection cdata = createSVGText("test", doc);
		assertEquals(Node.CDATA_SECTION_NODE, cdata.getNodeType());
	}
	
	
	@Override
	protected SVGCDATASection createSVGText(String txt, SVGDocument document) throws IllegalArgumentException
	{
		return new SVGCDATASection(txt, document);
	}
}
