package latexDraw.ui.dialog;


import java.awt.*;

import javax.swing.*;
import javax.swing.event.ChangeEvent;

import latexDraw.figures.Draw;
import latexDraw.figures.Figure;
import latexDraw.figures.LaTeXDrawRectangle;
import latexDraw.lang.LaTeXDrawLang;
import latexDraw.ui.DrawPanel;
import latexDraw.util.LaTeXDrawPoint2D;
import latexDraw.util.LaTeXDrawResources;


/** 
 * This class defines the frame which allows to change the parameters of the drawing.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 01/20/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class ParametersDrawFrame extends AbstractParametersFrame
{
	private static final long serialVersionUID = 1L;

	/** Allows to change the x-coordinates of the North-West point */
	protected JSpinner NWX;
	
	/** Allows to change the y-coordinates of the North-West point */
	protected JSpinner NWY;
	
	/** Allows to change the x-coordinates of the North-West point */
	protected JSpinner SEX;
	
	/** Allows to change the y-coordinates of the North-West point */
	protected JSpinner SEY;
	
	/** The label of the item NWX */
	public static final String LABEL_NWX = LaTeXDrawLang.getDialogFrameString("ParametersDrawFrame.0"); //$NON-NLS-1$
	
	/** The label of the item NWY */
	public static final String LABEL_NWY = LaTeXDrawLang.getDialogFrameString("ParametersDrawFrame.1"); //$NON-NLS-1$
	
	/** The label of the item SEX */
	public static final String LABEL_SEX = LaTeXDrawLang.getDialogFrameString("ParametersDrawFrame.2"); //$NON-NLS-1$
	
	/** The label of the item SEY */
	public static final String LABEL_SEY = LaTeXDrawLang.getDialogFrameString("ParametersDrawFrame.3"); //$NON-NLS-1$
	
	
	
	
	public ParametersDrawFrame(Frame parent, DrawPanel d, boolean attachToMainFrame)
	{
		super(parent, d, attachToMainFrame);
		
		try
		{
	  		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
	  		
	  		setLocation(dim.width*1/3, dim.height*1/5);
	  		String add = " :";//$NON-NLS-1$
	  		
	  		JPanel pButton  = createButtonsPanel(this);
	  		JPanel pGeneral = new JPanel();
			
	  		pGeneral.setLayout(new GridBagLayout());
	  		
	  		GridBagConstraints constraint = new GridBagConstraints();
	    	constraint.gridx = 0;
	     	constraint.gridy = 0;
	     	constraint.gridwidth = 1;
	     	constraint.gridheight = 1;
	     	constraint.weightx = 0.1;
	     	constraint.weighty = 0.1;
	     	constraint.fill = GridBagConstraints.NONE;
	     	constraint.anchor = GridBagConstraints.CENTER;
	     	pGeneral.add(new JLabel(LABEL_NWX+add), constraint);
	  		
	     	SpinnerModel model = new SpinnerNumberModel(0,0,10000,0.1);
	     	NWX = new JSpinner(model);
	     	NWX.setEditor(new JSpinner.NumberEditor(NWX, "0.0"));//$NON-NLS-1$
			NWX.addChangeListener(this);
	     	NWX.setName(LABEL_NWX);
	     	constraint.gridx++;
	     	pGeneral.add(NWX, constraint);
	     	
	     	constraint.gridx++;
	     	pGeneral.add(new JLabel(LABEL_NWY+add), constraint);
	     	
	     	model = new SpinnerNumberModel(0,0,10000,0.1);
	     	NWY = new JSpinner(model);
	     	NWY.setEditor(new JSpinner.NumberEditor(NWY, "0.0"));//$NON-NLS-1$
	     	NWY.addChangeListener(this);
	     	NWY.setName(LABEL_NWY);
	     	constraint.gridx++;
	     	pGeneral.add(NWY, constraint);
	     	
	     	constraint.gridx=0;	constraint.gridy++;
	     	pGeneral.add(new JLabel(LABEL_SEX+add), constraint);
	  		
	     	model = new SpinnerNumberModel(0,0,10000,0.1);
	     	SEX = new JSpinner(model);
	     	SEX.setEditor(new JSpinner.NumberEditor(SEX, "0.0"));//$NON-NLS-1$
	     	SEX.addChangeListener(this);
	     	SEX.setName(LABEL_SEX);
	     	constraint.gridx++;
	     	pGeneral.add(SEX, constraint);
	     	
	     	constraint.gridx++;
	     	pGeneral.add(new JLabel(LABEL_SEY+add), constraint);
	     	
	     	model = new SpinnerNumberModel(0,0,10000,0.1);
	     	SEY = new JSpinner(model);
	     	SEY.setEditor(new JSpinner.NumberEditor(SEY, "0.0"));//$NON-NLS-1$
	     	SEY.addChangeListener(this);
	     	SEY.setName(LABEL_SEY);
	     	constraint.gridx++;
	     	pGeneral.add(SEY, constraint);
	     	
	     	constraint.gridx = 0;	constraint.gridy++;
	     	pGeneral.add(new JLabel(LABEL_ROTATION), constraint);
	     	
	     	model = new SpinnerNumberModel(Figure.DEFAULT_ROTATION_ANGLE, 
					-360, 360,0.1);
	     	rotationField = new JSpinner(model);
	     	rotationField.setEditor(new JSpinner.NumberEditor(rotationField, "0.0"));//$NON-NLS-1$
	     	rotationField.addChangeListener(this);
	     	rotationField.setName(LaTeXDrawResources.LABEL_ROTATE);
	     	constraint.gridx = 1;
	     	pGeneral.add(rotationField, constraint);
	     	
	     	JPanel panel = new JPanel();
	     	panel.setLayout(new GridLayout(2,1));
	     	panel.add(glimpsePanelZoom);
	     	panel.add(pGeneral);
	     	getContentPane().setLayout(new BorderLayout());
	     	getContentPane().add(panel, BorderLayout.CENTER);
			getContentPane().add(pButton, BorderLayout.SOUTH);
	  		setSize(440, 470);
			setVisible(false);
			setResizable(false);

		}catch(Exception e)
		{
			e.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(e);
		}
	}

	
	
	
	@Override
	public void stateChanged(ChangeEvent e) 
	{
		try
		{
			Object o = e.getSource();
			
			Draw f = (Draw)glimpsePanel.getGlimpseFigure();
			
			if(o instanceof JSpinner)
			{
				String name = ((JSpinner)o).getName();
				LaTeXDrawRectangle borders = f.getBorders();
				LaTeXDrawPoint2D NW = borders.getTheNWPoint();
				LaTeXDrawPoint2D SE = borders.getTheSEPoint();

				if(name.equals(LABEL_NWX))
				{
					float newVal = Float.valueOf(NWX.getValue().toString());
					setModified(true);
					
					if(newVal!=(float)NW.x)
					{	
						f.rescaleX(NW.x, newVal, Math.abs((newVal-SE.x)/(NW.x-SE.x)), borders);
						glimpsePanel.repaint();
						((SpinnerNumberModel)SEX.getModel()).setMinimum(NW.x);
					}
					return ;
				}
				
				if(name.equals(LABEL_NWY))
				{
					float newVal = Float.valueOf(NWY.getValue().toString());
					setModified(true);
					
					if(newVal!=(float)NW.y)
					{
						f.rescaleY(NW.y, newVal, Math.abs((newVal-SE.y)/(NW.y-SE.y)), borders);
						glimpsePanel.repaint();
						((SpinnerNumberModel)SEY.getModel()).setMinimum(NW.y);
					}

					return ;
				}
				
				if(name.equals(LABEL_SEX))
				{
					float newVal = Float.valueOf(SEX.getValue().toString());
					setModified(true);
					
					if(newVal!=(float)SE.x)
					{
						f.rescaleX(SE.x, newVal, Math.abs((newVal-NW.x)/(SE.x-NW.x)), borders);
						glimpsePanel.repaint();
						((SpinnerNumberModel)NWX.getModel()).setMaximum(SE.x);
					}

					return ;
				}
				
				if(name.equals(LABEL_SEY))
				{
					float newVal = Float.valueOf(SEY.getValue().toString());
					setModified(true);
					
					if(newVal!=(float)SE.y)
					{
						f.rescaleY(SE.y, newVal, Math.abs((newVal-NW.y)/(SE.y-NW.y)), borders);
						glimpsePanel.repaint();
						((SpinnerNumberModel)NWY.getModel()).setMinimum(SE.y);
					}

					return ;
				}
			}
		}catch(Exception ex)
		{
			ex.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(ex);
		}
		
		super.stateChanged(e);
	}
	
	
	
	@Override
	public void saveParameters()
	{
		if(!(figure instanceof Draw))
			throw new ClassCastException();
		
		LaTeXDrawRectangle borders = figure.getBorders();
		LaTeXDrawPoint2D NW = borders.getTheNWPoint();
		LaTeXDrawPoint2D SE = borders.getTheSEPoint();
		
		float newVal = Float.valueOf(NWX.getValue().toString()).floatValue();
		figure.rescaleX(NW.x, newVal, Math.abs((newVal-SE.x)/(NW.x-SE.x)), borders);
		
		newVal = Float.valueOf(NWY.getValue().toString()).floatValue();
		figure.rescaleY(NW.y, newVal, Math.abs((newVal-SE.y)/(NW.y-SE.y)), borders);

		newVal = Float.valueOf(SEX.getValue().toString()).floatValue();
		figure.rescaleX(SE.x, newVal, Math.abs((newVal-NW.x)/(SE.x-NW.x)), borders);

		newVal = Float.valueOf(SEY.getValue().toString()).floatValue();
		figure.rescaleY(SE.y, newVal, Math.abs((newVal-NW.y)/(SE.y-NW.y)), borders);
		
		((Draw)figure).updateBorders();
		((Draw)figure).updateGravityCenter();

		super.saveParameters();
	}
	
	
	
	
	@Override
	public void setVisible(boolean visible, Figure selected, boolean deleteOnCancel, boolean isFramedBox) 
	{
		try
		{
			if(!(selected instanceof Draw))
				throw new ClassCastException();
			
			super.setVisible(visible, selected, deleteOnCancel, isFramedBox);
		}
		catch(Exception ex)
		{
			ex.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(ex);
		}	
	}
	
	
	
	
	@Override
	public void setFigureFrameField()
	{
		LaTeXDrawPoint2D NW = figure.getTheNWPoint(), SE = figure.getTheSEPoint();
		
		NWX.setValue((float)NW.x);
		((SpinnerNumberModel)NWX.getModel()).setMaximum(SE.x);
		SEX.setValue((float)SE.x);
		((SpinnerNumberModel)SEX.getModel()).setMinimum(NW.x);
		NWY.setValue((float)NW.y);
		((SpinnerNumberModel)NWY.getModel()).setMaximum(SE.y);
		SEY.setValue((float)SE.y);
		((SpinnerNumberModel)SEY.getModel()).setMinimum(NW.y);
	}
}
