# Welcome to Flang's documentation

Flang is LLVM's Fortran frontend

```eval_rst
.. toctree::
   :titlesonly:

   ReleaseNotes
```

# Contributing to Flang

```eval_rst
.. toctree::
   :titlesonly:

   GettingInvolved
   FortranForCProgrammers
   C++style
   C++17
   PullRequestChecklist
   ImplementingASemanticCheck
```

# Design Documents

```eval_rst
.. toctree::
   :titlesonly:

   Overview
   Preprocessing
   Parsing
   LabelResolution
   ModFiles
   Semantics
   OpenMP-semantics
   ControlFlowGraph
   FortranIR
   IORuntimeInternals
   f2018-grammar.md
   OpenMP-4.5-grammar.md
   Directives
   Extensions
   Intrinsics
   OptionComparison
   ParserCombinators
   RuntimeDescriptor
   RuntimeTypeInfo
   Calls
   Character
   ArrayComposition
   BijectiveInternalNameUniquing
   DoConcurrent
```

# Indices and tables

```eval_rst
* :ref:`genindex`
* :ref:`modindex`
* :ref:`search`
```
