// RUN: llvm-mc -arch=amdgcn -mcpu=gfx900 -show-encoding %s | FileCheck %s

s_add_u32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x80]

s_add_u32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x80]

s_add_u32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x80]

s_add_u32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x80]

s_add_u32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x80]

s_add_u32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x80]

s_add_u32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x80]

s_add_u32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x80]

s_add_u32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x80]

s_add_u32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x80]

s_add_u32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x80]

s_add_u32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x80]

s_add_u32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x80]

s_add_u32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x80]

s_add_u32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x80]

s_add_u32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x80]

s_add_u32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x80]

s_add_u32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x80]

s_add_u32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x80]

s_add_u32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x80]

s_add_u32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x80]

s_add_u32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x80]

s_add_u32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x80]

s_add_u32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x80]

s_add_u32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x80]

s_add_u32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x80]

s_add_u32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x80,0x56,0x34,0x12,0xaf]

s_add_u32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x80,0x73,0x72,0x71,0x3f]

s_add_u32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x80]

s_add_u32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x80]

s_add_u32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x80]

s_add_u32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x80]

s_add_u32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x80]

s_add_u32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x80]

s_add_u32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x80]

s_add_u32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x80]

s_add_u32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x80]

s_add_u32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x80]

s_add_u32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x80]

s_add_u32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x80]

s_add_u32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x80]

s_add_u32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x80]

s_add_u32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x80]

s_add_u32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x80]

s_add_u32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x80,0x56,0x34,0x12,0xaf]

s_add_u32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x80,0x73,0x72,0x71,0x3f]

s_sub_u32 s5, s1, s2
// CHECK: [0x01,0x02,0x85,0x80]

s_sub_u32 s101, s1, s2
// CHECK: [0x01,0x02,0xe5,0x80]

s_sub_u32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0xe6,0x80]

s_sub_u32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0xe7,0x80]

s_sub_u32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0xea,0x80]

s_sub_u32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0xeb,0x80]

s_sub_u32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0xfb,0x80]

s_sub_u32 m0, s1, s2
// CHECK: [0x01,0x02,0xfc,0x80]

s_sub_u32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0xfe,0x80]

s_sub_u32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0xff,0x80]

s_sub_u32 s5, s101, s2
// CHECK: [0x65,0x02,0x85,0x80]

s_sub_u32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x85,0x80]

s_sub_u32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x85,0x80]

s_sub_u32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x85,0x80]

s_sub_u32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x85,0x80]

s_sub_u32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x85,0x80]

s_sub_u32 s5, m0, s2
// CHECK: [0x7c,0x02,0x85,0x80]

s_sub_u32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x85,0x80]

s_sub_u32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x85,0x80]

s_sub_u32 s5, 0, s2
// CHECK: [0x80,0x02,0x85,0x80]

s_sub_u32 s5, -1, s2
// CHECK: [0xc1,0x02,0x85,0x80]

s_sub_u32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x85,0x80]

s_sub_u32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x85,0x80]

s_sub_u32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x85,0x80]

s_sub_u32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x85,0x80]

s_sub_u32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x85,0x80]

s_sub_u32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x85,0x80,0x56,0x34,0x12,0xaf]

s_sub_u32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x85,0x80,0x73,0x72,0x71,0x3f]

s_sub_u32 s5, s1, s101
// CHECK: [0x01,0x65,0x85,0x80]

s_sub_u32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x85,0x80]

s_sub_u32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x85,0x80]

s_sub_u32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x85,0x80]

s_sub_u32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x85,0x80]

s_sub_u32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x85,0x80]

s_sub_u32 s5, s1, m0
// CHECK: [0x01,0x7c,0x85,0x80]

s_sub_u32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x85,0x80]

s_sub_u32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x85,0x80]

s_sub_u32 s5, s1, 0
// CHECK: [0x01,0x80,0x85,0x80]

s_sub_u32 s5, s1, -1
// CHECK: [0x01,0xc1,0x85,0x80]

s_sub_u32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x85,0x80]

s_sub_u32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x85,0x80]

s_sub_u32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x85,0x80]

s_sub_u32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x85,0x80]

s_sub_u32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x85,0x80]

s_sub_u32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x85,0x80,0x56,0x34,0x12,0xaf]

s_sub_u32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x85,0x80,0x73,0x72,0x71,0x3f]

s_add_i32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x81]

s_add_i32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x81]

s_add_i32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x81]

s_add_i32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x81]

s_add_i32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x81]

s_add_i32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x81]

s_add_i32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x81]

s_add_i32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x81]

s_add_i32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x81]

s_add_i32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x81]

s_add_i32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x81]

s_add_i32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x81]

s_add_i32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x81]

s_add_i32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x81]

s_add_i32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x81]

s_add_i32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x81]

s_add_i32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x81]

s_add_i32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x81]

s_add_i32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x81]

s_add_i32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x81]

s_add_i32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x81]

s_add_i32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x81]

s_add_i32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x81]

s_add_i32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x81]

s_add_i32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x81]

s_add_i32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x81]

s_add_i32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x81,0x56,0x34,0x12,0xaf]

s_add_i32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x81,0x73,0x72,0x71,0x3f]

s_add_i32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x81]

s_add_i32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x81]

s_add_i32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x81]

s_add_i32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x81]

s_add_i32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x81]

s_add_i32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x81]

s_add_i32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x81]

s_add_i32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x81]

s_add_i32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x81]

s_add_i32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x81]

s_add_i32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x81]

s_add_i32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x81]

s_add_i32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x81]

s_add_i32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x81]

s_add_i32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x81]

s_add_i32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x81]

s_add_i32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x81,0x56,0x34,0x12,0xaf]

s_add_i32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x81,0x73,0x72,0x71,0x3f]

s_sub_i32 s5, s1, s2
// CHECK: [0x01,0x02,0x85,0x81]

s_sub_i32 s101, s1, s2
// CHECK: [0x01,0x02,0xe5,0x81]

s_sub_i32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0xe6,0x81]

s_sub_i32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0xe7,0x81]

s_sub_i32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0xea,0x81]

s_sub_i32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0xeb,0x81]

s_sub_i32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0xfb,0x81]

s_sub_i32 m0, s1, s2
// CHECK: [0x01,0x02,0xfc,0x81]

s_sub_i32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0xfe,0x81]

s_sub_i32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0xff,0x81]

s_sub_i32 s5, s101, s2
// CHECK: [0x65,0x02,0x85,0x81]

s_sub_i32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x85,0x81]

s_sub_i32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x85,0x81]

s_sub_i32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x85,0x81]

s_sub_i32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x85,0x81]

s_sub_i32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x85,0x81]

s_sub_i32 s5, m0, s2
// CHECK: [0x7c,0x02,0x85,0x81]

s_sub_i32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x85,0x81]

s_sub_i32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x85,0x81]

s_sub_i32 s5, 0, s2
// CHECK: [0x80,0x02,0x85,0x81]

s_sub_i32 s5, -1, s2
// CHECK: [0xc1,0x02,0x85,0x81]

s_sub_i32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x85,0x81]

s_sub_i32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x85,0x81]

s_sub_i32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x85,0x81]

s_sub_i32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x85,0x81]

s_sub_i32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x85,0x81]

s_sub_i32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x85,0x81,0x56,0x34,0x12,0xaf]

s_sub_i32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x85,0x81,0x73,0x72,0x71,0x3f]

s_sub_i32 s5, s1, s101
// CHECK: [0x01,0x65,0x85,0x81]

s_sub_i32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x85,0x81]

s_sub_i32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x85,0x81]

s_sub_i32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x85,0x81]

s_sub_i32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x85,0x81]

s_sub_i32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x85,0x81]

s_sub_i32 s5, s1, m0
// CHECK: [0x01,0x7c,0x85,0x81]

s_sub_i32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x85,0x81]

s_sub_i32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x85,0x81]

s_sub_i32 s5, s1, 0
// CHECK: [0x01,0x80,0x85,0x81]

s_sub_i32 s5, s1, -1
// CHECK: [0x01,0xc1,0x85,0x81]

s_sub_i32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x85,0x81]

s_sub_i32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x85,0x81]

s_sub_i32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x85,0x81]

s_sub_i32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x85,0x81]

s_sub_i32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x85,0x81]

s_sub_i32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x85,0x81,0x56,0x34,0x12,0xaf]

s_sub_i32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x85,0x81,0x73,0x72,0x71,0x3f]

s_addc_u32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x82]

s_addc_u32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x82]

s_addc_u32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x82]

s_addc_u32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x82]

s_addc_u32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x82]

s_addc_u32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x82]

s_addc_u32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x82]

s_addc_u32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x82]

s_addc_u32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x82]

s_addc_u32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x82]

s_addc_u32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x82]

s_addc_u32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x82]

s_addc_u32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x82]

s_addc_u32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x82]

s_addc_u32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x82]

s_addc_u32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x82]

s_addc_u32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x82]

s_addc_u32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x82]

s_addc_u32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x82]

s_addc_u32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x82]

s_addc_u32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x82]

s_addc_u32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x82]

s_addc_u32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x82]

s_addc_u32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x82]

s_addc_u32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x82]

s_addc_u32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x82]

s_addc_u32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x82,0x56,0x34,0x12,0xaf]

s_addc_u32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x82,0x73,0x72,0x71,0x3f]

s_addc_u32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x82]

s_addc_u32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x82]

s_addc_u32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x82]

s_addc_u32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x82]

s_addc_u32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x82]

s_addc_u32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x82]

s_addc_u32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x82]

s_addc_u32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x82]

s_addc_u32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x82]

s_addc_u32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x82]

s_addc_u32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x82]

s_addc_u32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x82]

s_addc_u32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x82]

s_addc_u32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x82]

s_addc_u32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x82]

s_addc_u32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x82]

s_addc_u32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x82,0x56,0x34,0x12,0xaf]

s_addc_u32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x82,0x73,0x72,0x71,0x3f]

s_subb_u32 s5, s1, s2
// CHECK: [0x01,0x02,0x85,0x82]

s_subb_u32 s101, s1, s2
// CHECK: [0x01,0x02,0xe5,0x82]

s_subb_u32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0xe6,0x82]

s_subb_u32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0xe7,0x82]

s_subb_u32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0xea,0x82]

s_subb_u32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0xeb,0x82]

s_subb_u32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0xfb,0x82]

s_subb_u32 m0, s1, s2
// CHECK: [0x01,0x02,0xfc,0x82]

s_subb_u32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0xfe,0x82]

s_subb_u32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0xff,0x82]

s_subb_u32 s5, s101, s2
// CHECK: [0x65,0x02,0x85,0x82]

s_subb_u32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x85,0x82]

s_subb_u32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x85,0x82]

s_subb_u32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x85,0x82]

s_subb_u32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x85,0x82]

s_subb_u32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x85,0x82]

s_subb_u32 s5, m0, s2
// CHECK: [0x7c,0x02,0x85,0x82]

s_subb_u32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x85,0x82]

s_subb_u32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x85,0x82]

s_subb_u32 s5, 0, s2
// CHECK: [0x80,0x02,0x85,0x82]

s_subb_u32 s5, -1, s2
// CHECK: [0xc1,0x02,0x85,0x82]

s_subb_u32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x85,0x82]

s_subb_u32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x85,0x82]

s_subb_u32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x85,0x82]

s_subb_u32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x85,0x82]

s_subb_u32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x85,0x82]

s_subb_u32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x85,0x82,0x56,0x34,0x12,0xaf]

s_subb_u32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x85,0x82,0x73,0x72,0x71,0x3f]

s_subb_u32 s5, s1, s101
// CHECK: [0x01,0x65,0x85,0x82]

s_subb_u32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x85,0x82]

s_subb_u32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x85,0x82]

s_subb_u32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x85,0x82]

s_subb_u32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x85,0x82]

s_subb_u32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x85,0x82]

s_subb_u32 s5, s1, m0
// CHECK: [0x01,0x7c,0x85,0x82]

s_subb_u32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x85,0x82]

s_subb_u32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x85,0x82]

s_subb_u32 s5, s1, 0
// CHECK: [0x01,0x80,0x85,0x82]

s_subb_u32 s5, s1, -1
// CHECK: [0x01,0xc1,0x85,0x82]

s_subb_u32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x85,0x82]

s_subb_u32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x85,0x82]

s_subb_u32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x85,0x82]

s_subb_u32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x85,0x82]

s_subb_u32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x85,0x82]

s_subb_u32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x85,0x82,0x56,0x34,0x12,0xaf]

s_subb_u32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x85,0x82,0x73,0x72,0x71,0x3f]

s_min_i32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x83]

s_min_i32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x83]

s_min_i32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x83]

s_min_i32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x83]

s_min_i32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x83]

s_min_i32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x83]

s_min_i32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x83]

s_min_i32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x83]

s_min_i32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x83]

s_min_i32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x83]

s_min_i32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x83]

s_min_i32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x83]

s_min_i32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x83]

s_min_i32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x83]

s_min_i32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x83]

s_min_i32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x83]

s_min_i32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x83]

s_min_i32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x83]

s_min_i32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x83]

s_min_i32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x83]

s_min_i32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x83]

s_min_i32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x83]

s_min_i32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x83]

s_min_i32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x83]

s_min_i32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x83]

s_min_i32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x83]

s_min_i32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x83,0x56,0x34,0x12,0xaf]

s_min_i32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x83,0x73,0x72,0x71,0x3f]

s_min_i32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x83]

s_min_i32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x83]

s_min_i32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x83]

s_min_i32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x83]

s_min_i32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x83]

s_min_i32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x83]

s_min_i32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x83]

s_min_i32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x83]

s_min_i32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x83]

s_min_i32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x83]

s_min_i32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x83]

s_min_i32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x83]

s_min_i32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x83]

s_min_i32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x83]

s_min_i32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x83]

s_min_i32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x83]

s_min_i32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x83,0x56,0x34,0x12,0xaf]

s_min_i32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x83,0x73,0x72,0x71,0x3f]

s_min_u32 s5, s1, s2
// CHECK: [0x01,0x02,0x85,0x83]

s_min_u32 s101, s1, s2
// CHECK: [0x01,0x02,0xe5,0x83]

s_min_u32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0xe6,0x83]

s_min_u32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0xe7,0x83]

s_min_u32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0xea,0x83]

s_min_u32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0xeb,0x83]

s_min_u32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0xfb,0x83]

s_min_u32 m0, s1, s2
// CHECK: [0x01,0x02,0xfc,0x83]

s_min_u32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0xfe,0x83]

s_min_u32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0xff,0x83]

s_min_u32 s5, s101, s2
// CHECK: [0x65,0x02,0x85,0x83]

s_min_u32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x85,0x83]

s_min_u32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x85,0x83]

s_min_u32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x85,0x83]

s_min_u32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x85,0x83]

s_min_u32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x85,0x83]

s_min_u32 s5, m0, s2
// CHECK: [0x7c,0x02,0x85,0x83]

s_min_u32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x85,0x83]

s_min_u32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x85,0x83]

s_min_u32 s5, 0, s2
// CHECK: [0x80,0x02,0x85,0x83]

s_min_u32 s5, -1, s2
// CHECK: [0xc1,0x02,0x85,0x83]

s_min_u32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x85,0x83]

s_min_u32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x85,0x83]

s_min_u32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x85,0x83]

s_min_u32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x85,0x83]

s_min_u32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x85,0x83]

s_min_u32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x85,0x83,0x56,0x34,0x12,0xaf]

s_min_u32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x85,0x83,0x73,0x72,0x71,0x3f]

s_min_u32 s5, s1, s101
// CHECK: [0x01,0x65,0x85,0x83]

s_min_u32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x85,0x83]

s_min_u32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x85,0x83]

s_min_u32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x85,0x83]

s_min_u32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x85,0x83]

s_min_u32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x85,0x83]

s_min_u32 s5, s1, m0
// CHECK: [0x01,0x7c,0x85,0x83]

s_min_u32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x85,0x83]

s_min_u32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x85,0x83]

s_min_u32 s5, s1, 0
// CHECK: [0x01,0x80,0x85,0x83]

s_min_u32 s5, s1, -1
// CHECK: [0x01,0xc1,0x85,0x83]

s_min_u32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x85,0x83]

s_min_u32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x85,0x83]

s_min_u32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x85,0x83]

s_min_u32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x85,0x83]

s_min_u32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x85,0x83]

s_min_u32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x85,0x83,0x56,0x34,0x12,0xaf]

s_min_u32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x85,0x83,0x73,0x72,0x71,0x3f]

s_max_i32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x84]

s_max_i32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x84]

s_max_i32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x84]

s_max_i32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x84]

s_max_i32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x84]

s_max_i32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x84]

s_max_i32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x84]

s_max_i32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x84]

s_max_i32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x84]

s_max_i32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x84]

s_max_i32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x84]

s_max_i32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x84]

s_max_i32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x84]

s_max_i32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x84]

s_max_i32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x84]

s_max_i32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x84]

s_max_i32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x84]

s_max_i32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x84]

s_max_i32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x84]

s_max_i32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x84]

s_max_i32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x84]

s_max_i32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x84]

s_max_i32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x84]

s_max_i32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x84]

s_max_i32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x84]

s_max_i32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x84]

s_max_i32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x84,0x56,0x34,0x12,0xaf]

s_max_i32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x84,0x73,0x72,0x71,0x3f]

s_max_i32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x84]

s_max_i32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x84]

s_max_i32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x84]

s_max_i32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x84]

s_max_i32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x84]

s_max_i32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x84]

s_max_i32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x84]

s_max_i32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x84]

s_max_i32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x84]

s_max_i32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x84]

s_max_i32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x84]

s_max_i32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x84]

s_max_i32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x84]

s_max_i32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x84]

s_max_i32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x84]

s_max_i32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x84]

s_max_i32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x84,0x56,0x34,0x12,0xaf]

s_max_i32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x84,0x73,0x72,0x71,0x3f]

s_max_u32 s5, s1, s2
// CHECK: [0x01,0x02,0x85,0x84]

s_max_u32 s101, s1, s2
// CHECK: [0x01,0x02,0xe5,0x84]

s_max_u32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0xe6,0x84]

s_max_u32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0xe7,0x84]

s_max_u32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0xea,0x84]

s_max_u32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0xeb,0x84]

s_max_u32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0xfb,0x84]

s_max_u32 m0, s1, s2
// CHECK: [0x01,0x02,0xfc,0x84]

s_max_u32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0xfe,0x84]

s_max_u32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0xff,0x84]

s_max_u32 s5, s101, s2
// CHECK: [0x65,0x02,0x85,0x84]

s_max_u32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x85,0x84]

s_max_u32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x85,0x84]

s_max_u32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x85,0x84]

s_max_u32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x85,0x84]

s_max_u32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x85,0x84]

s_max_u32 s5, m0, s2
// CHECK: [0x7c,0x02,0x85,0x84]

s_max_u32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x85,0x84]

s_max_u32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x85,0x84]

s_max_u32 s5, 0, s2
// CHECK: [0x80,0x02,0x85,0x84]

s_max_u32 s5, -1, s2
// CHECK: [0xc1,0x02,0x85,0x84]

s_max_u32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x85,0x84]

s_max_u32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x85,0x84]

s_max_u32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x85,0x84]

s_max_u32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x85,0x84]

s_max_u32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x85,0x84]

s_max_u32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x85,0x84,0x56,0x34,0x12,0xaf]

s_max_u32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x85,0x84,0x73,0x72,0x71,0x3f]

s_max_u32 s5, s1, s101
// CHECK: [0x01,0x65,0x85,0x84]

s_max_u32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x85,0x84]

s_max_u32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x85,0x84]

s_max_u32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x85,0x84]

s_max_u32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x85,0x84]

s_max_u32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x85,0x84]

s_max_u32 s5, s1, m0
// CHECK: [0x01,0x7c,0x85,0x84]

s_max_u32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x85,0x84]

s_max_u32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x85,0x84]

s_max_u32 s5, s1, 0
// CHECK: [0x01,0x80,0x85,0x84]

s_max_u32 s5, s1, -1
// CHECK: [0x01,0xc1,0x85,0x84]

s_max_u32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x85,0x84]

s_max_u32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x85,0x84]

s_max_u32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x85,0x84]

s_max_u32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x85,0x84]

s_max_u32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x85,0x84]

s_max_u32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x85,0x84,0x56,0x34,0x12,0xaf]

s_max_u32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x85,0x84,0x73,0x72,0x71,0x3f]

s_cselect_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x85]

s_cselect_b32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x85]

s_cselect_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x85]

s_cselect_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x85]

s_cselect_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x85]

s_cselect_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x85]

s_cselect_b32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x85]

s_cselect_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x85]

s_cselect_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x85]

s_cselect_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x85]

s_cselect_b32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x85]

s_cselect_b32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x85]

s_cselect_b32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x85]

s_cselect_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x85]

s_cselect_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x85]

s_cselect_b32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x85]

s_cselect_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x85]

s_cselect_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x85]

s_cselect_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x85]

s_cselect_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x85]

s_cselect_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x85]

s_cselect_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x85]

s_cselect_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x85]

s_cselect_b32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x85]

s_cselect_b32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x85]

s_cselect_b32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x85]

s_cselect_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x85,0x56,0x34,0x12,0xaf]

s_cselect_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x85,0x73,0x72,0x71,0x3f]

s_cselect_b32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x85]

s_cselect_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x85]

s_cselect_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x85]

s_cselect_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x85]

s_cselect_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x85]

s_cselect_b32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x85]

s_cselect_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x85]

s_cselect_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x85]

s_cselect_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x85]

s_cselect_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x85]

s_cselect_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x85]

s_cselect_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x85]

s_cselect_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x85]

s_cselect_b32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x85]

s_cselect_b32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x85]

s_cselect_b32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x85]

s_cselect_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x85,0x56,0x34,0x12,0xaf]

s_cselect_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x85,0x73,0x72,0x71,0x3f]

s_cselect_b64 s[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8a,0x85]

s_cselect_b64 s[12:13], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8c,0x85]

s_cselect_b64 s[100:101], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe4,0x85]

s_cselect_b64 flat_scratch, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe6,0x85]

s_cselect_b64 vcc, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xea,0x85]

s_cselect_b64 ttmp[14:15], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfa,0x85]

s_cselect_b64 exec, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfe,0x85]

s_cselect_b64 s[10:11], s[4:5], s[4:5]
// CHECK: [0x04,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], s[100:101], s[4:5]
// CHECK: [0x64,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], flat_scratch, s[4:5]
// CHECK: [0x66,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], vcc, s[4:5]
// CHECK: [0x6a,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], ttmp[14:15], s[4:5]
// CHECK: [0x7a,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], exec, s[4:5]
// CHECK: [0x7e,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], 0, s[4:5]
// CHECK: [0x80,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], -1, s[4:5]
// CHECK: [0xc1,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], 0.5, s[4:5]
// CHECK: [0xf0,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], -4.0, s[4:5]
// CHECK: [0xf7,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], src_vccz, s[4:5]
// CHECK: [0xfb,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], src_execz, s[4:5]
// CHECK: [0xfc,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], src_scc, s[4:5]
// CHECK: [0xfd,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], 0xaf123456, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x85,0x56,0x34,0x12,0xaf]

s_cselect_b64 s[10:11], 0x3f717273, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x85,0x73,0x72,0x71,0x3f]

s_cselect_b64 s[10:11], s[2:3], s[6:7]
// CHECK: [0x02,0x06,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], s[100:101]
// CHECK: [0x02,0x64,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], flat_scratch
// CHECK: [0x02,0x66,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], vcc
// CHECK: [0x02,0x6a,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], ttmp[14:15]
// CHECK: [0x02,0x7a,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], exec
// CHECK: [0x02,0x7e,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], src_vccz
// CHECK: [0x02,0xfb,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], src_execz
// CHECK: [0x02,0xfc,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], src_scc
// CHECK: [0x02,0xfd,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x85,0x56,0x34,0x12,0xaf]

s_cselect_b64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x85,0x73,0x72,0x71,0x3f]

s_and_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x86]

s_and_b32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x86]

s_and_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x86]

s_and_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x86]

s_and_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x86]

s_and_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x86]

s_and_b32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x86]

s_and_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x86]

s_and_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x86]

s_and_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x86]

s_and_b32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x86]

s_and_b32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x86]

s_and_b32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x86]

s_and_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x86]

s_and_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x86]

s_and_b32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x86]

s_and_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x86]

s_and_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x86]

s_and_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x86]

s_and_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x86]

s_and_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x86]

s_and_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x86]

s_and_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x86]

s_and_b32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x86]

s_and_b32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x86]

s_and_b32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x86]

s_and_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x86,0x56,0x34,0x12,0xaf]

s_and_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x86,0x73,0x72,0x71,0x3f]

s_and_b32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x86]

s_and_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x86]

s_and_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x86]

s_and_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x86]

s_and_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x86]

s_and_b32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x86]

s_and_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x86]

s_and_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x86]

s_and_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x86]

s_and_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x86]

s_and_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x86]

s_and_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x86]

s_and_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x86]

s_and_b32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x86]

s_and_b32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x86]

s_and_b32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x86]

s_and_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x86,0x56,0x34,0x12,0xaf]

s_and_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x86,0x73,0x72,0x71,0x3f]

s_and_b64 s[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8a,0x86]

s_and_b64 s[12:13], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8c,0x86]

s_and_b64 s[100:101], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe4,0x86]

s_and_b64 flat_scratch, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe6,0x86]

s_and_b64 vcc, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xea,0x86]

s_and_b64 ttmp[14:15], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfa,0x86]

s_and_b64 exec, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfe,0x86]

s_and_b64 s[10:11], s[4:5], s[4:5]
// CHECK: [0x04,0x04,0x8a,0x86]

s_and_b64 s[10:11], s[100:101], s[4:5]
// CHECK: [0x64,0x04,0x8a,0x86]

s_and_b64 s[10:11], flat_scratch, s[4:5]
// CHECK: [0x66,0x04,0x8a,0x86]

s_and_b64 s[10:11], vcc, s[4:5]
// CHECK: [0x6a,0x04,0x8a,0x86]

s_and_b64 s[10:11], ttmp[14:15], s[4:5]
// CHECK: [0x7a,0x04,0x8a,0x86]

s_and_b64 s[10:11], exec, s[4:5]
// CHECK: [0x7e,0x04,0x8a,0x86]

s_and_b64 s[10:11], 0, s[4:5]
// CHECK: [0x80,0x04,0x8a,0x86]

s_and_b64 s[10:11], -1, s[4:5]
// CHECK: [0xc1,0x04,0x8a,0x86]

s_and_b64 s[10:11], 0.5, s[4:5]
// CHECK: [0xf0,0x04,0x8a,0x86]

s_and_b64 s[10:11], -4.0, s[4:5]
// CHECK: [0xf7,0x04,0x8a,0x86]

s_and_b64 s[10:11], src_vccz, s[4:5]
// CHECK: [0xfb,0x04,0x8a,0x86]

s_and_b64 s[10:11], src_execz, s[4:5]
// CHECK: [0xfc,0x04,0x8a,0x86]

s_and_b64 s[10:11], src_scc, s[4:5]
// CHECK: [0xfd,0x04,0x8a,0x86]

s_and_b64 s[10:11], 0xaf123456, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x86,0x56,0x34,0x12,0xaf]

s_and_b64 s[10:11], 0x3f717273, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x86,0x73,0x72,0x71,0x3f]

s_and_b64 s[10:11], s[2:3], s[6:7]
// CHECK: [0x02,0x06,0x8a,0x86]

s_and_b64 s[10:11], s[2:3], s[100:101]
// CHECK: [0x02,0x64,0x8a,0x86]

s_and_b64 s[10:11], s[2:3], flat_scratch
// CHECK: [0x02,0x66,0x8a,0x86]

s_and_b64 s[10:11], s[2:3], vcc
// CHECK: [0x02,0x6a,0x8a,0x86]

s_and_b64 s[10:11], s[2:3], ttmp[14:15]
// CHECK: [0x02,0x7a,0x8a,0x86]

s_and_b64 s[10:11], s[2:3], exec
// CHECK: [0x02,0x7e,0x8a,0x86]

s_and_b64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x86]

s_and_b64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x86]

s_and_b64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x86]

s_and_b64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x86]

s_and_b64 s[10:11], s[2:3], src_vccz
// CHECK: [0x02,0xfb,0x8a,0x86]

s_and_b64 s[10:11], s[2:3], src_execz
// CHECK: [0x02,0xfc,0x8a,0x86]

s_and_b64 s[10:11], s[2:3], src_scc
// CHECK: [0x02,0xfd,0x8a,0x86]

s_and_b64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x86,0x56,0x34,0x12,0xaf]

s_and_b64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x86,0x73,0x72,0x71,0x3f]

s_or_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x87]

s_or_b32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x87]

s_or_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x87]

s_or_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x87]

s_or_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x87]

s_or_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x87]

s_or_b32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x87]

s_or_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x87]

s_or_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x87]

s_or_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x87]

s_or_b32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x87]

s_or_b32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x87]

s_or_b32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x87]

s_or_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x87]

s_or_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x87]

s_or_b32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x87]

s_or_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x87]

s_or_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x87]

s_or_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x87]

s_or_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x87]

s_or_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x87]

s_or_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x87]

s_or_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x87]

s_or_b32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x87]

s_or_b32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x87]

s_or_b32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x87]

s_or_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x87,0x56,0x34,0x12,0xaf]

s_or_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x87,0x73,0x72,0x71,0x3f]

s_or_b32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x87]

s_or_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x87]

s_or_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x87]

s_or_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x87]

s_or_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x87]

s_or_b32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x87]

s_or_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x87]

s_or_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x87]

s_or_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x87]

s_or_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x87]

s_or_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x87]

s_or_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x87]

s_or_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x87]

s_or_b32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x87]

s_or_b32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x87]

s_or_b32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x87]

s_or_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x87,0x56,0x34,0x12,0xaf]

s_or_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x87,0x73,0x72,0x71,0x3f]

s_or_b64 s[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8a,0x87]

s_or_b64 s[12:13], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8c,0x87]

s_or_b64 s[100:101], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe4,0x87]

s_or_b64 flat_scratch, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe6,0x87]

s_or_b64 vcc, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xea,0x87]

s_or_b64 ttmp[14:15], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfa,0x87]

s_or_b64 exec, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfe,0x87]

s_or_b64 s[10:11], s[4:5], s[4:5]
// CHECK: [0x04,0x04,0x8a,0x87]

s_or_b64 s[10:11], s[100:101], s[4:5]
// CHECK: [0x64,0x04,0x8a,0x87]

s_or_b64 s[10:11], flat_scratch, s[4:5]
// CHECK: [0x66,0x04,0x8a,0x87]

s_or_b64 s[10:11], vcc, s[4:5]
// CHECK: [0x6a,0x04,0x8a,0x87]

s_or_b64 s[10:11], ttmp[14:15], s[4:5]
// CHECK: [0x7a,0x04,0x8a,0x87]

s_or_b64 s[10:11], exec, s[4:5]
// CHECK: [0x7e,0x04,0x8a,0x87]

s_or_b64 s[10:11], 0, s[4:5]
// CHECK: [0x80,0x04,0x8a,0x87]

s_or_b64 s[10:11], -1, s[4:5]
// CHECK: [0xc1,0x04,0x8a,0x87]

s_or_b64 s[10:11], 0.5, s[4:5]
// CHECK: [0xf0,0x04,0x8a,0x87]

s_or_b64 s[10:11], -4.0, s[4:5]
// CHECK: [0xf7,0x04,0x8a,0x87]

s_or_b64 s[10:11], src_vccz, s[4:5]
// CHECK: [0xfb,0x04,0x8a,0x87]

s_or_b64 s[10:11], src_execz, s[4:5]
// CHECK: [0xfc,0x04,0x8a,0x87]

s_or_b64 s[10:11], src_scc, s[4:5]
// CHECK: [0xfd,0x04,0x8a,0x87]

s_or_b64 s[10:11], 0xaf123456, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x87,0x56,0x34,0x12,0xaf]

s_or_b64 s[10:11], 0x3f717273, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x87,0x73,0x72,0x71,0x3f]

s_or_b64 s[10:11], s[2:3], s[6:7]
// CHECK: [0x02,0x06,0x8a,0x87]

s_or_b64 s[10:11], s[2:3], s[100:101]
// CHECK: [0x02,0x64,0x8a,0x87]

s_or_b64 s[10:11], s[2:3], flat_scratch
// CHECK: [0x02,0x66,0x8a,0x87]

s_or_b64 s[10:11], s[2:3], vcc
// CHECK: [0x02,0x6a,0x8a,0x87]

s_or_b64 s[10:11], s[2:3], ttmp[14:15]
// CHECK: [0x02,0x7a,0x8a,0x87]

s_or_b64 s[10:11], s[2:3], exec
// CHECK: [0x02,0x7e,0x8a,0x87]

s_or_b64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x87]

s_or_b64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x87]

s_or_b64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x87]

s_or_b64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x87]

s_or_b64 s[10:11], s[2:3], src_vccz
// CHECK: [0x02,0xfb,0x8a,0x87]

s_or_b64 s[10:11], s[2:3], src_execz
// CHECK: [0x02,0xfc,0x8a,0x87]

s_or_b64 s[10:11], s[2:3], src_scc
// CHECK: [0x02,0xfd,0x8a,0x87]

s_or_b64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x87,0x56,0x34,0x12,0xaf]

s_or_b64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x87,0x73,0x72,0x71,0x3f]

s_xor_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x88]

s_xor_b32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x88]

s_xor_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x88]

s_xor_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x88]

s_xor_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x88]

s_xor_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x88]

s_xor_b32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x88]

s_xor_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x88]

s_xor_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x88]

s_xor_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x88]

s_xor_b32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x88]

s_xor_b32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x88]

s_xor_b32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x88]

s_xor_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x88]

s_xor_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x88]

s_xor_b32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x88]

s_xor_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x88]

s_xor_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x88]

s_xor_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x88]

s_xor_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x88]

s_xor_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x88]

s_xor_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x88]

s_xor_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x88]

s_xor_b32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x88]

s_xor_b32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x88]

s_xor_b32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x88]

s_xor_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x88,0x56,0x34,0x12,0xaf]

s_xor_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x88,0x73,0x72,0x71,0x3f]

s_xor_b32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x88]

s_xor_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x88]

s_xor_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x88]

s_xor_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x88]

s_xor_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x88]

s_xor_b32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x88]

s_xor_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x88]

s_xor_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x88]

s_xor_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x88]

s_xor_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x88]

s_xor_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x88]

s_xor_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x88]

s_xor_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x88]

s_xor_b32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x88]

s_xor_b32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x88]

s_xor_b32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x88]

s_xor_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x88,0x56,0x34,0x12,0xaf]

s_xor_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x88,0x73,0x72,0x71,0x3f]

s_xor_b64 s[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8a,0x88]

s_xor_b64 s[12:13], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8c,0x88]

s_xor_b64 s[100:101], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe4,0x88]

s_xor_b64 flat_scratch, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe6,0x88]

s_xor_b64 vcc, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xea,0x88]

s_xor_b64 ttmp[14:15], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfa,0x88]

s_xor_b64 exec, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfe,0x88]

s_xor_b64 s[10:11], s[4:5], s[4:5]
// CHECK: [0x04,0x04,0x8a,0x88]

s_xor_b64 s[10:11], s[100:101], s[4:5]
// CHECK: [0x64,0x04,0x8a,0x88]

s_xor_b64 s[10:11], flat_scratch, s[4:5]
// CHECK: [0x66,0x04,0x8a,0x88]

s_xor_b64 s[10:11], vcc, s[4:5]
// CHECK: [0x6a,0x04,0x8a,0x88]

s_xor_b64 s[10:11], ttmp[14:15], s[4:5]
// CHECK: [0x7a,0x04,0x8a,0x88]

s_xor_b64 s[10:11], exec, s[4:5]
// CHECK: [0x7e,0x04,0x8a,0x88]

s_xor_b64 s[10:11], 0, s[4:5]
// CHECK: [0x80,0x04,0x8a,0x88]

s_xor_b64 s[10:11], -1, s[4:5]
// CHECK: [0xc1,0x04,0x8a,0x88]

s_xor_b64 s[10:11], 0.5, s[4:5]
// CHECK: [0xf0,0x04,0x8a,0x88]

s_xor_b64 s[10:11], -4.0, s[4:5]
// CHECK: [0xf7,0x04,0x8a,0x88]

s_xor_b64 s[10:11], src_vccz, s[4:5]
// CHECK: [0xfb,0x04,0x8a,0x88]

s_xor_b64 s[10:11], src_execz, s[4:5]
// CHECK: [0xfc,0x04,0x8a,0x88]

s_xor_b64 s[10:11], src_scc, s[4:5]
// CHECK: [0xfd,0x04,0x8a,0x88]

s_xor_b64 s[10:11], 0xaf123456, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x88,0x56,0x34,0x12,0xaf]

s_xor_b64 s[10:11], 0x3f717273, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x88,0x73,0x72,0x71,0x3f]

s_xor_b64 s[10:11], s[2:3], s[6:7]
// CHECK: [0x02,0x06,0x8a,0x88]

s_xor_b64 s[10:11], s[2:3], s[100:101]
// CHECK: [0x02,0x64,0x8a,0x88]

s_xor_b64 s[10:11], s[2:3], flat_scratch
// CHECK: [0x02,0x66,0x8a,0x88]

s_xor_b64 s[10:11], s[2:3], vcc
// CHECK: [0x02,0x6a,0x8a,0x88]

s_xor_b64 s[10:11], s[2:3], ttmp[14:15]
// CHECK: [0x02,0x7a,0x8a,0x88]

s_xor_b64 s[10:11], s[2:3], exec
// CHECK: [0x02,0x7e,0x8a,0x88]

s_xor_b64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x88]

s_xor_b64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x88]

s_xor_b64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x88]

s_xor_b64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x88]

s_xor_b64 s[10:11], s[2:3], src_vccz
// CHECK: [0x02,0xfb,0x8a,0x88]

s_xor_b64 s[10:11], s[2:3], src_execz
// CHECK: [0x02,0xfc,0x8a,0x88]

s_xor_b64 s[10:11], s[2:3], src_scc
// CHECK: [0x02,0xfd,0x8a,0x88]

s_xor_b64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x88,0x56,0x34,0x12,0xaf]

s_xor_b64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x88,0x73,0x72,0x71,0x3f]

s_andn2_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x89]

s_andn2_b32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x89]

s_andn2_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x89]

s_andn2_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x89]

s_andn2_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x89]

s_andn2_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x89]

s_andn2_b32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x89]

s_andn2_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x89]

s_andn2_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x89]

s_andn2_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x89]

s_andn2_b32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x89]

s_andn2_b32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x89]

s_andn2_b32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x89]

s_andn2_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x89]

s_andn2_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x89]

s_andn2_b32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x89]

s_andn2_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x89]

s_andn2_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x89]

s_andn2_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x89]

s_andn2_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x89]

s_andn2_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x89]

s_andn2_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x89]

s_andn2_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x89]

s_andn2_b32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x89]

s_andn2_b32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x89]

s_andn2_b32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x89]

s_andn2_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x89,0x56,0x34,0x12,0xaf]

s_andn2_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x89,0x73,0x72,0x71,0x3f]

s_andn2_b32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x89]

s_andn2_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x89]

s_andn2_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x89]

s_andn2_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x89]

s_andn2_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x89]

s_andn2_b32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x89]

s_andn2_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x89]

s_andn2_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x89]

s_andn2_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x89]

s_andn2_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x89]

s_andn2_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x89]

s_andn2_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x89]

s_andn2_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x89]

s_andn2_b32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x89]

s_andn2_b32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x89]

s_andn2_b32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x89]

s_andn2_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x89,0x56,0x34,0x12,0xaf]

s_andn2_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x89,0x73,0x72,0x71,0x3f]

s_andn2_b64 s[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8a,0x89]

s_andn2_b64 s[12:13], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8c,0x89]

s_andn2_b64 s[100:101], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe4,0x89]

s_andn2_b64 flat_scratch, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe6,0x89]

s_andn2_b64 vcc, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xea,0x89]

s_andn2_b64 ttmp[14:15], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfa,0x89]

s_andn2_b64 exec, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfe,0x89]

s_andn2_b64 s[10:11], s[4:5], s[4:5]
// CHECK: [0x04,0x04,0x8a,0x89]

s_andn2_b64 s[10:11], s[100:101], s[4:5]
// CHECK: [0x64,0x04,0x8a,0x89]

s_andn2_b64 s[10:11], flat_scratch, s[4:5]
// CHECK: [0x66,0x04,0x8a,0x89]

s_andn2_b64 s[10:11], vcc, s[4:5]
// CHECK: [0x6a,0x04,0x8a,0x89]

s_andn2_b64 s[10:11], ttmp[14:15], s[4:5]
// CHECK: [0x7a,0x04,0x8a,0x89]

s_andn2_b64 s[10:11], exec, s[4:5]
// CHECK: [0x7e,0x04,0x8a,0x89]

s_andn2_b64 s[10:11], 0, s[4:5]
// CHECK: [0x80,0x04,0x8a,0x89]

s_andn2_b64 s[10:11], -1, s[4:5]
// CHECK: [0xc1,0x04,0x8a,0x89]

s_andn2_b64 s[10:11], 0.5, s[4:5]
// CHECK: [0xf0,0x04,0x8a,0x89]

s_andn2_b64 s[10:11], -4.0, s[4:5]
// CHECK: [0xf7,0x04,0x8a,0x89]

s_andn2_b64 s[10:11], src_vccz, s[4:5]
// CHECK: [0xfb,0x04,0x8a,0x89]

s_andn2_b64 s[10:11], src_execz, s[4:5]
// CHECK: [0xfc,0x04,0x8a,0x89]

s_andn2_b64 s[10:11], src_scc, s[4:5]
// CHECK: [0xfd,0x04,0x8a,0x89]

s_andn2_b64 s[10:11], 0xaf123456, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x89,0x56,0x34,0x12,0xaf]

s_andn2_b64 s[10:11], 0x3f717273, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x89,0x73,0x72,0x71,0x3f]

s_andn2_b64 s[10:11], s[2:3], s[6:7]
// CHECK: [0x02,0x06,0x8a,0x89]

s_andn2_b64 s[10:11], s[2:3], s[100:101]
// CHECK: [0x02,0x64,0x8a,0x89]

s_andn2_b64 s[10:11], s[2:3], flat_scratch
// CHECK: [0x02,0x66,0x8a,0x89]

s_andn2_b64 s[10:11], s[2:3], vcc
// CHECK: [0x02,0x6a,0x8a,0x89]

s_andn2_b64 s[10:11], s[2:3], ttmp[14:15]
// CHECK: [0x02,0x7a,0x8a,0x89]

s_andn2_b64 s[10:11], s[2:3], exec
// CHECK: [0x02,0x7e,0x8a,0x89]

s_andn2_b64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x89]

s_andn2_b64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x89]

s_andn2_b64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x89]

s_andn2_b64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x89]

s_andn2_b64 s[10:11], s[2:3], src_vccz
// CHECK: [0x02,0xfb,0x8a,0x89]

s_andn2_b64 s[10:11], s[2:3], src_execz
// CHECK: [0x02,0xfc,0x8a,0x89]

s_andn2_b64 s[10:11], s[2:3], src_scc
// CHECK: [0x02,0xfd,0x8a,0x89]

s_andn2_b64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x89,0x56,0x34,0x12,0xaf]

s_andn2_b64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x89,0x73,0x72,0x71,0x3f]

s_orn2_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x8a]

s_orn2_b32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x8a]

s_orn2_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x8a]

s_orn2_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x8a]

s_orn2_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x8a]

s_orn2_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x8a]

s_orn2_b32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x8a]

s_orn2_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x8a]

s_orn2_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x8a]

s_orn2_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x8a]

s_orn2_b32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x8a]

s_orn2_b32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x8a]

s_orn2_b32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x8a]

s_orn2_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x8a]

s_orn2_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x8a]

s_orn2_b32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x8a]

s_orn2_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x8a]

s_orn2_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x8a]

s_orn2_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x8a]

s_orn2_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x8a]

s_orn2_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x8a]

s_orn2_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x8a]

s_orn2_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x8a]

s_orn2_b32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x8a]

s_orn2_b32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x8a]

s_orn2_b32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x8a]

s_orn2_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x8a,0x56,0x34,0x12,0xaf]

s_orn2_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x8a,0x73,0x72,0x71,0x3f]

s_orn2_b32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x8a]

s_orn2_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x8a]

s_orn2_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x8a]

s_orn2_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x8a]

s_orn2_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x8a]

s_orn2_b32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x8a]

s_orn2_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x8a]

s_orn2_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x8a]

s_orn2_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x8a]

s_orn2_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x8a]

s_orn2_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x8a]

s_orn2_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x8a]

s_orn2_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x8a]

s_orn2_b32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x8a]

s_orn2_b32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x8a]

s_orn2_b32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x8a]

s_orn2_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x8a,0x56,0x34,0x12,0xaf]

s_orn2_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x8a,0x73,0x72,0x71,0x3f]

s_orn2_b64 s[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8a,0x8a]

s_orn2_b64 s[12:13], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8c,0x8a]

s_orn2_b64 s[100:101], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe4,0x8a]

s_orn2_b64 flat_scratch, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe6,0x8a]

s_orn2_b64 vcc, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xea,0x8a]

s_orn2_b64 ttmp[14:15], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfa,0x8a]

s_orn2_b64 exec, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfe,0x8a]

s_orn2_b64 s[10:11], s[4:5], s[4:5]
// CHECK: [0x04,0x04,0x8a,0x8a]

s_orn2_b64 s[10:11], s[100:101], s[4:5]
// CHECK: [0x64,0x04,0x8a,0x8a]

s_orn2_b64 s[10:11], flat_scratch, s[4:5]
// CHECK: [0x66,0x04,0x8a,0x8a]

s_orn2_b64 s[10:11], vcc, s[4:5]
// CHECK: [0x6a,0x04,0x8a,0x8a]

s_orn2_b64 s[10:11], ttmp[14:15], s[4:5]
// CHECK: [0x7a,0x04,0x8a,0x8a]

s_orn2_b64 s[10:11], exec, s[4:5]
// CHECK: [0x7e,0x04,0x8a,0x8a]

s_orn2_b64 s[10:11], 0, s[4:5]
// CHECK: [0x80,0x04,0x8a,0x8a]

s_orn2_b64 s[10:11], -1, s[4:5]
// CHECK: [0xc1,0x04,0x8a,0x8a]

s_orn2_b64 s[10:11], 0.5, s[4:5]
// CHECK: [0xf0,0x04,0x8a,0x8a]

s_orn2_b64 s[10:11], -4.0, s[4:5]
// CHECK: [0xf7,0x04,0x8a,0x8a]

s_orn2_b64 s[10:11], src_vccz, s[4:5]
// CHECK: [0xfb,0x04,0x8a,0x8a]

s_orn2_b64 s[10:11], src_execz, s[4:5]
// CHECK: [0xfc,0x04,0x8a,0x8a]

s_orn2_b64 s[10:11], src_scc, s[4:5]
// CHECK: [0xfd,0x04,0x8a,0x8a]

s_orn2_b64 s[10:11], 0xaf123456, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x8a,0x56,0x34,0x12,0xaf]

s_orn2_b64 s[10:11], 0x3f717273, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x8a,0x73,0x72,0x71,0x3f]

s_orn2_b64 s[10:11], s[2:3], s[6:7]
// CHECK: [0x02,0x06,0x8a,0x8a]

s_orn2_b64 s[10:11], s[2:3], s[100:101]
// CHECK: [0x02,0x64,0x8a,0x8a]

s_orn2_b64 s[10:11], s[2:3], flat_scratch
// CHECK: [0x02,0x66,0x8a,0x8a]

s_orn2_b64 s[10:11], s[2:3], vcc
// CHECK: [0x02,0x6a,0x8a,0x8a]

s_orn2_b64 s[10:11], s[2:3], ttmp[14:15]
// CHECK: [0x02,0x7a,0x8a,0x8a]

s_orn2_b64 s[10:11], s[2:3], exec
// CHECK: [0x02,0x7e,0x8a,0x8a]

s_orn2_b64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x8a]

s_orn2_b64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x8a]

s_orn2_b64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x8a]

s_orn2_b64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x8a]

s_orn2_b64 s[10:11], s[2:3], src_vccz
// CHECK: [0x02,0xfb,0x8a,0x8a]

s_orn2_b64 s[10:11], s[2:3], src_execz
// CHECK: [0x02,0xfc,0x8a,0x8a]

s_orn2_b64 s[10:11], s[2:3], src_scc
// CHECK: [0x02,0xfd,0x8a,0x8a]

s_orn2_b64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x8a,0x56,0x34,0x12,0xaf]

s_orn2_b64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x8a,0x73,0x72,0x71,0x3f]

s_nand_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x8b]

s_nand_b32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x8b]

s_nand_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x8b]

s_nand_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x8b]

s_nand_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x8b]

s_nand_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x8b]

s_nand_b32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x8b]

s_nand_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x8b]

s_nand_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x8b]

s_nand_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x8b]

s_nand_b32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x8b]

s_nand_b32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x8b]

s_nand_b32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x8b]

s_nand_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x8b]

s_nand_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x8b]

s_nand_b32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x8b]

s_nand_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x8b]

s_nand_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x8b]

s_nand_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x8b]

s_nand_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x8b]

s_nand_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x8b]

s_nand_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x8b]

s_nand_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x8b]

s_nand_b32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x8b]

s_nand_b32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x8b]

s_nand_b32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x8b]

s_nand_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x8b,0x56,0x34,0x12,0xaf]

s_nand_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x8b,0x73,0x72,0x71,0x3f]

s_nand_b32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x8b]

s_nand_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x8b]

s_nand_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x8b]

s_nand_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x8b]

s_nand_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x8b]

s_nand_b32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x8b]

s_nand_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x8b]

s_nand_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x8b]

s_nand_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x8b]

s_nand_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x8b]

s_nand_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x8b]

s_nand_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x8b]

s_nand_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x8b]

s_nand_b32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x8b]

s_nand_b32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x8b]

s_nand_b32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x8b]

s_nand_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x8b,0x56,0x34,0x12,0xaf]

s_nand_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x8b,0x73,0x72,0x71,0x3f]

s_nand_b64 s[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8a,0x8b]

s_nand_b64 s[12:13], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8c,0x8b]

s_nand_b64 s[100:101], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe4,0x8b]

s_nand_b64 flat_scratch, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe6,0x8b]

s_nand_b64 vcc, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xea,0x8b]

s_nand_b64 ttmp[14:15], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfa,0x8b]

s_nand_b64 exec, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfe,0x8b]

s_nand_b64 s[10:11], s[4:5], s[4:5]
// CHECK: [0x04,0x04,0x8a,0x8b]

s_nand_b64 s[10:11], s[100:101], s[4:5]
// CHECK: [0x64,0x04,0x8a,0x8b]

s_nand_b64 s[10:11], flat_scratch, s[4:5]
// CHECK: [0x66,0x04,0x8a,0x8b]

s_nand_b64 s[10:11], vcc, s[4:5]
// CHECK: [0x6a,0x04,0x8a,0x8b]

s_nand_b64 s[10:11], ttmp[14:15], s[4:5]
// CHECK: [0x7a,0x04,0x8a,0x8b]

s_nand_b64 s[10:11], exec, s[4:5]
// CHECK: [0x7e,0x04,0x8a,0x8b]

s_nand_b64 s[10:11], 0, s[4:5]
// CHECK: [0x80,0x04,0x8a,0x8b]

s_nand_b64 s[10:11], -1, s[4:5]
// CHECK: [0xc1,0x04,0x8a,0x8b]

s_nand_b64 s[10:11], 0.5, s[4:5]
// CHECK: [0xf0,0x04,0x8a,0x8b]

s_nand_b64 s[10:11], -4.0, s[4:5]
// CHECK: [0xf7,0x04,0x8a,0x8b]

s_nand_b64 s[10:11], src_vccz, s[4:5]
// CHECK: [0xfb,0x04,0x8a,0x8b]

s_nand_b64 s[10:11], src_execz, s[4:5]
// CHECK: [0xfc,0x04,0x8a,0x8b]

s_nand_b64 s[10:11], src_scc, s[4:5]
// CHECK: [0xfd,0x04,0x8a,0x8b]

s_nand_b64 s[10:11], 0xaf123456, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x8b,0x56,0x34,0x12,0xaf]

s_nand_b64 s[10:11], 0x3f717273, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x8b,0x73,0x72,0x71,0x3f]

s_nand_b64 s[10:11], s[2:3], s[6:7]
// CHECK: [0x02,0x06,0x8a,0x8b]

s_nand_b64 s[10:11], s[2:3], s[100:101]
// CHECK: [0x02,0x64,0x8a,0x8b]

s_nand_b64 s[10:11], s[2:3], flat_scratch
// CHECK: [0x02,0x66,0x8a,0x8b]

s_nand_b64 s[10:11], s[2:3], vcc
// CHECK: [0x02,0x6a,0x8a,0x8b]

s_nand_b64 s[10:11], s[2:3], ttmp[14:15]
// CHECK: [0x02,0x7a,0x8a,0x8b]

s_nand_b64 s[10:11], s[2:3], exec
// CHECK: [0x02,0x7e,0x8a,0x8b]

s_nand_b64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x8b]

s_nand_b64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x8b]

s_nand_b64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x8b]

s_nand_b64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x8b]

s_nand_b64 s[10:11], s[2:3], src_vccz
// CHECK: [0x02,0xfb,0x8a,0x8b]

s_nand_b64 s[10:11], s[2:3], src_execz
// CHECK: [0x02,0xfc,0x8a,0x8b]

s_nand_b64 s[10:11], s[2:3], src_scc
// CHECK: [0x02,0xfd,0x8a,0x8b]

s_nand_b64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x8b,0x56,0x34,0x12,0xaf]

s_nand_b64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x8b,0x73,0x72,0x71,0x3f]

s_nor_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x8c]

s_nor_b32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x8c]

s_nor_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x8c]

s_nor_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x8c]

s_nor_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x8c]

s_nor_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x8c]

s_nor_b32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x8c]

s_nor_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x8c]

s_nor_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x8c]

s_nor_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x8c]

s_nor_b32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x8c]

s_nor_b32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x8c]

s_nor_b32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x8c]

s_nor_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x8c]

s_nor_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x8c]

s_nor_b32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x8c]

s_nor_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x8c]

s_nor_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x8c]

s_nor_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x8c]

s_nor_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x8c]

s_nor_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x8c]

s_nor_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x8c]

s_nor_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x8c]

s_nor_b32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x8c]

s_nor_b32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x8c]

s_nor_b32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x8c]

s_nor_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x8c,0x56,0x34,0x12,0xaf]

s_nor_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x8c,0x73,0x72,0x71,0x3f]

s_nor_b32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x8c]

s_nor_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x8c]

s_nor_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x8c]

s_nor_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x8c]

s_nor_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x8c]

s_nor_b32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x8c]

s_nor_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x8c]

s_nor_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x8c]

s_nor_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x8c]

s_nor_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x8c]

s_nor_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x8c]

s_nor_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x8c]

s_nor_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x8c]

s_nor_b32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x8c]

s_nor_b32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x8c]

s_nor_b32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x8c]

s_nor_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x8c,0x56,0x34,0x12,0xaf]

s_nor_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x8c,0x73,0x72,0x71,0x3f]

s_nor_b64 s[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8a,0x8c]

s_nor_b64 s[12:13], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8c,0x8c]

s_nor_b64 s[100:101], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe4,0x8c]

s_nor_b64 flat_scratch, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe6,0x8c]

s_nor_b64 vcc, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xea,0x8c]

s_nor_b64 ttmp[14:15], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfa,0x8c]

s_nor_b64 exec, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfe,0x8c]

s_nor_b64 s[10:11], s[4:5], s[4:5]
// CHECK: [0x04,0x04,0x8a,0x8c]

s_nor_b64 s[10:11], s[100:101], s[4:5]
// CHECK: [0x64,0x04,0x8a,0x8c]

s_nor_b64 s[10:11], flat_scratch, s[4:5]
// CHECK: [0x66,0x04,0x8a,0x8c]

s_nor_b64 s[10:11], vcc, s[4:5]
// CHECK: [0x6a,0x04,0x8a,0x8c]

s_nor_b64 s[10:11], ttmp[14:15], s[4:5]
// CHECK: [0x7a,0x04,0x8a,0x8c]

s_nor_b64 s[10:11], exec, s[4:5]
// CHECK: [0x7e,0x04,0x8a,0x8c]

s_nor_b64 s[10:11], 0, s[4:5]
// CHECK: [0x80,0x04,0x8a,0x8c]

s_nor_b64 s[10:11], -1, s[4:5]
// CHECK: [0xc1,0x04,0x8a,0x8c]

s_nor_b64 s[10:11], 0.5, s[4:5]
// CHECK: [0xf0,0x04,0x8a,0x8c]

s_nor_b64 s[10:11], -4.0, s[4:5]
// CHECK: [0xf7,0x04,0x8a,0x8c]

s_nor_b64 s[10:11], src_vccz, s[4:5]
// CHECK: [0xfb,0x04,0x8a,0x8c]

s_nor_b64 s[10:11], src_execz, s[4:5]
// CHECK: [0xfc,0x04,0x8a,0x8c]

s_nor_b64 s[10:11], src_scc, s[4:5]
// CHECK: [0xfd,0x04,0x8a,0x8c]

s_nor_b64 s[10:11], 0xaf123456, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x8c,0x56,0x34,0x12,0xaf]

s_nor_b64 s[10:11], 0x3f717273, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x8c,0x73,0x72,0x71,0x3f]

s_nor_b64 s[10:11], s[2:3], s[6:7]
// CHECK: [0x02,0x06,0x8a,0x8c]

s_nor_b64 s[10:11], s[2:3], s[100:101]
// CHECK: [0x02,0x64,0x8a,0x8c]

s_nor_b64 s[10:11], s[2:3], flat_scratch
// CHECK: [0x02,0x66,0x8a,0x8c]

s_nor_b64 s[10:11], s[2:3], vcc
// CHECK: [0x02,0x6a,0x8a,0x8c]

s_nor_b64 s[10:11], s[2:3], ttmp[14:15]
// CHECK: [0x02,0x7a,0x8a,0x8c]

s_nor_b64 s[10:11], s[2:3], exec
// CHECK: [0x02,0x7e,0x8a,0x8c]

s_nor_b64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x8c]

s_nor_b64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x8c]

s_nor_b64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x8c]

s_nor_b64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x8c]

s_nor_b64 s[10:11], s[2:3], src_vccz
// CHECK: [0x02,0xfb,0x8a,0x8c]

s_nor_b64 s[10:11], s[2:3], src_execz
// CHECK: [0x02,0xfc,0x8a,0x8c]

s_nor_b64 s[10:11], s[2:3], src_scc
// CHECK: [0x02,0xfd,0x8a,0x8c]

s_nor_b64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x8c,0x56,0x34,0x12,0xaf]

s_nor_b64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x8c,0x73,0x72,0x71,0x3f]

s_xnor_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x8d]

s_xnor_b32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x8d]

s_xnor_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x8d]

s_xnor_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x8d]

s_xnor_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x8d]

s_xnor_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x8d]

s_xnor_b32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x8d]

s_xnor_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x8d]

s_xnor_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x8d]

s_xnor_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x8d]

s_xnor_b32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x8d]

s_xnor_b32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x8d]

s_xnor_b32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x8d]

s_xnor_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x8d]

s_xnor_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x8d]

s_xnor_b32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x8d]

s_xnor_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x8d]

s_xnor_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x8d]

s_xnor_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x8d]

s_xnor_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x8d]

s_xnor_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x8d]

s_xnor_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x8d]

s_xnor_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x8d]

s_xnor_b32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x8d]

s_xnor_b32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x8d]

s_xnor_b32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x8d]

s_xnor_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x8d,0x56,0x34,0x12,0xaf]

s_xnor_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x8d,0x73,0x72,0x71,0x3f]

s_xnor_b32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x8d]

s_xnor_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x8d]

s_xnor_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x8d]

s_xnor_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x8d]

s_xnor_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x8d]

s_xnor_b32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x8d]

s_xnor_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x8d]

s_xnor_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x8d]

s_xnor_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x8d]

s_xnor_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x8d]

s_xnor_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x8d]

s_xnor_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x8d]

s_xnor_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x8d]

s_xnor_b32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x8d]

s_xnor_b32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x8d]

s_xnor_b32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x8d]

s_xnor_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x8d,0x56,0x34,0x12,0xaf]

s_xnor_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x8d,0x73,0x72,0x71,0x3f]

s_xnor_b64 s[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8a,0x8d]

s_xnor_b64 s[12:13], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8c,0x8d]

s_xnor_b64 s[100:101], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe4,0x8d]

s_xnor_b64 flat_scratch, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe6,0x8d]

s_xnor_b64 vcc, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xea,0x8d]

s_xnor_b64 ttmp[14:15], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfa,0x8d]

s_xnor_b64 exec, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfe,0x8d]

s_xnor_b64 s[10:11], s[4:5], s[4:5]
// CHECK: [0x04,0x04,0x8a,0x8d]

s_xnor_b64 s[10:11], s[100:101], s[4:5]
// CHECK: [0x64,0x04,0x8a,0x8d]

s_xnor_b64 s[10:11], flat_scratch, s[4:5]
// CHECK: [0x66,0x04,0x8a,0x8d]

s_xnor_b64 s[10:11], vcc, s[4:5]
// CHECK: [0x6a,0x04,0x8a,0x8d]

s_xnor_b64 s[10:11], ttmp[14:15], s[4:5]
// CHECK: [0x7a,0x04,0x8a,0x8d]

s_xnor_b64 s[10:11], exec, s[4:5]
// CHECK: [0x7e,0x04,0x8a,0x8d]

s_xnor_b64 s[10:11], 0, s[4:5]
// CHECK: [0x80,0x04,0x8a,0x8d]

s_xnor_b64 s[10:11], -1, s[4:5]
// CHECK: [0xc1,0x04,0x8a,0x8d]

s_xnor_b64 s[10:11], 0.5, s[4:5]
// CHECK: [0xf0,0x04,0x8a,0x8d]

s_xnor_b64 s[10:11], -4.0, s[4:5]
// CHECK: [0xf7,0x04,0x8a,0x8d]

s_xnor_b64 s[10:11], src_vccz, s[4:5]
// CHECK: [0xfb,0x04,0x8a,0x8d]

s_xnor_b64 s[10:11], src_execz, s[4:5]
// CHECK: [0xfc,0x04,0x8a,0x8d]

s_xnor_b64 s[10:11], src_scc, s[4:5]
// CHECK: [0xfd,0x04,0x8a,0x8d]

s_xnor_b64 s[10:11], 0xaf123456, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x8d,0x56,0x34,0x12,0xaf]

s_xnor_b64 s[10:11], 0x3f717273, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x8d,0x73,0x72,0x71,0x3f]

s_xnor_b64 s[10:11], s[2:3], s[6:7]
// CHECK: [0x02,0x06,0x8a,0x8d]

s_xnor_b64 s[10:11], s[2:3], s[100:101]
// CHECK: [0x02,0x64,0x8a,0x8d]

s_xnor_b64 s[10:11], s[2:3], flat_scratch
// CHECK: [0x02,0x66,0x8a,0x8d]

s_xnor_b64 s[10:11], s[2:3], vcc
// CHECK: [0x02,0x6a,0x8a,0x8d]

s_xnor_b64 s[10:11], s[2:3], ttmp[14:15]
// CHECK: [0x02,0x7a,0x8a,0x8d]

s_xnor_b64 s[10:11], s[2:3], exec
// CHECK: [0x02,0x7e,0x8a,0x8d]

s_xnor_b64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x8d]

s_xnor_b64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x8d]

s_xnor_b64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x8d]

s_xnor_b64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x8d]

s_xnor_b64 s[10:11], s[2:3], src_vccz
// CHECK: [0x02,0xfb,0x8a,0x8d]

s_xnor_b64 s[10:11], s[2:3], src_execz
// CHECK: [0x02,0xfc,0x8a,0x8d]

s_xnor_b64 s[10:11], s[2:3], src_scc
// CHECK: [0x02,0xfd,0x8a,0x8d]

s_xnor_b64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x8d,0x56,0x34,0x12,0xaf]

s_xnor_b64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x8d,0x73,0x72,0x71,0x3f]

s_lshl_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x8e]

s_lshl_b32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x8e]

s_lshl_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x8e]

s_lshl_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x8e]

s_lshl_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x8e]

s_lshl_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x8e]

s_lshl_b32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x8e]

s_lshl_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x8e]

s_lshl_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x8e]

s_lshl_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x8e]

s_lshl_b32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x8e]

s_lshl_b32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x8e]

s_lshl_b32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x8e]

s_lshl_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x8e]

s_lshl_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x8e]

s_lshl_b32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x8e]

s_lshl_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x8e]

s_lshl_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x8e]

s_lshl_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x8e]

s_lshl_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x8e]

s_lshl_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x8e]

s_lshl_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x8e]

s_lshl_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x8e]

s_lshl_b32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x8e]

s_lshl_b32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x8e]

s_lshl_b32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x8e]

s_lshl_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x8e,0x56,0x34,0x12,0xaf]

s_lshl_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x8e,0x73,0x72,0x71,0x3f]

s_lshl_b32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x8e]

s_lshl_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x8e]

s_lshl_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x8e]

s_lshl_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x8e]

s_lshl_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x8e]

s_lshl_b32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x8e]

s_lshl_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x8e]

s_lshl_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x8e]

s_lshl_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x8e]

s_lshl_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x8e]

s_lshl_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x8e]

s_lshl_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x8e]

s_lshl_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x8e]

s_lshl_b32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x8e]

s_lshl_b32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x8e]

s_lshl_b32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x8e]

s_lshl_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x8e,0x56,0x34,0x12,0xaf]

s_lshl_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x8e,0x73,0x72,0x71,0x3f]

s_lshl_b64 s[10:11], s[2:3], s2
// CHECK: [0x02,0x02,0x8a,0x8e]

s_lshl_b64 s[12:13], s[2:3], s2
// CHECK: [0x02,0x02,0x8c,0x8e]

s_lshl_b64 s[100:101], s[2:3], s2
// CHECK: [0x02,0x02,0xe4,0x8e]

s_lshl_b64 flat_scratch, s[2:3], s2
// CHECK: [0x02,0x02,0xe6,0x8e]

s_lshl_b64 vcc, s[2:3], s2
// CHECK: [0x02,0x02,0xea,0x8e]

s_lshl_b64 ttmp[14:15], s[2:3], s2
// CHECK: [0x02,0x02,0xfa,0x8e]

s_lshl_b64 exec, s[2:3], s2
// CHECK: [0x02,0x02,0xfe,0x8e]

s_lshl_b64 s[10:11], s[4:5], s2
// CHECK: [0x04,0x02,0x8a,0x8e]

s_lshl_b64 s[10:11], s[100:101], s2
// CHECK: [0x64,0x02,0x8a,0x8e]

s_lshl_b64 s[10:11], flat_scratch, s2
// CHECK: [0x66,0x02,0x8a,0x8e]

s_lshl_b64 s[10:11], vcc, s2
// CHECK: [0x6a,0x02,0x8a,0x8e]

s_lshl_b64 s[10:11], ttmp[14:15], s2
// CHECK: [0x7a,0x02,0x8a,0x8e]

s_lshl_b64 s[10:11], exec, s2
// CHECK: [0x7e,0x02,0x8a,0x8e]

s_lshl_b64 s[10:11], 0, s2
// CHECK: [0x80,0x02,0x8a,0x8e]

s_lshl_b64 s[10:11], -1, s2
// CHECK: [0xc1,0x02,0x8a,0x8e]

s_lshl_b64 s[10:11], 0.5, s2
// CHECK: [0xf0,0x02,0x8a,0x8e]

s_lshl_b64 s[10:11], -4.0, s2
// CHECK: [0xf7,0x02,0x8a,0x8e]

s_lshl_b64 s[10:11], src_vccz, s2
// CHECK: [0xfb,0x02,0x8a,0x8e]

s_lshl_b64 s[10:11], src_execz, s2
// CHECK: [0xfc,0x02,0x8a,0x8e]

s_lshl_b64 s[10:11], src_scc, s2
// CHECK: [0xfd,0x02,0x8a,0x8e]

s_lshl_b64 s[10:11], 0xaf123456, s2
// CHECK: [0xff,0x02,0x8a,0x8e,0x56,0x34,0x12,0xaf]

s_lshl_b64 s[10:11], 0x3f717273, s2
// CHECK: [0xff,0x02,0x8a,0x8e,0x73,0x72,0x71,0x3f]

s_lshl_b64 s[10:11], s[2:3], s101
// CHECK: [0x02,0x65,0x8a,0x8e]

s_lshl_b64 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x02,0x66,0x8a,0x8e]

s_lshl_b64 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x02,0x67,0x8a,0x8e]

s_lshl_b64 s[10:11], s[2:3], vcc_lo
// CHECK: [0x02,0x6a,0x8a,0x8e]

s_lshl_b64 s[10:11], s[2:3], vcc_hi
// CHECK: [0x02,0x6b,0x8a,0x8e]

s_lshl_b64 s[10:11], s[2:3], ttmp15
// CHECK: [0x02,0x7b,0x8a,0x8e]

s_lshl_b64 s[10:11], s[2:3], m0
// CHECK: [0x02,0x7c,0x8a,0x8e]

s_lshl_b64 s[10:11], s[2:3], exec_lo
// CHECK: [0x02,0x7e,0x8a,0x8e]

s_lshl_b64 s[10:11], s[2:3], exec_hi
// CHECK: [0x02,0x7f,0x8a,0x8e]

s_lshl_b64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x8e]

s_lshl_b64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x8e]

s_lshl_b64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x8e]

s_lshl_b64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x8e]

s_lshl_b64 s[10:11], s[2:3], src_vccz
// CHECK: [0x02,0xfb,0x8a,0x8e]

s_lshl_b64 s[10:11], s[2:3], src_execz
// CHECK: [0x02,0xfc,0x8a,0x8e]

s_lshl_b64 s[10:11], s[2:3], src_scc
// CHECK: [0x02,0xfd,0x8a,0x8e]

s_lshl_b64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x8e,0x56,0x34,0x12,0xaf]

s_lshl_b64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x8e,0x73,0x72,0x71,0x3f]

s_lshr_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x8f]

s_lshr_b32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x8f]

s_lshr_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x8f]

s_lshr_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x8f]

s_lshr_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x8f]

s_lshr_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x8f]

s_lshr_b32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x8f]

s_lshr_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x8f]

s_lshr_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x8f]

s_lshr_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x8f]

s_lshr_b32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x8f]

s_lshr_b32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x8f]

s_lshr_b32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x8f]

s_lshr_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x8f]

s_lshr_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x8f]

s_lshr_b32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x8f]

s_lshr_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x8f]

s_lshr_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x8f]

s_lshr_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x8f]

s_lshr_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x8f]

s_lshr_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x8f]

s_lshr_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x8f]

s_lshr_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x8f]

s_lshr_b32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x8f]

s_lshr_b32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x8f]

s_lshr_b32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x8f]

s_lshr_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x8f,0x56,0x34,0x12,0xaf]

s_lshr_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x8f,0x73,0x72,0x71,0x3f]

s_lshr_b32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x8f]

s_lshr_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x8f]

s_lshr_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x8f]

s_lshr_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x8f]

s_lshr_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x8f]

s_lshr_b32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x8f]

s_lshr_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x8f]

s_lshr_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x8f]

s_lshr_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x8f]

s_lshr_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x8f]

s_lshr_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x8f]

s_lshr_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x8f]

s_lshr_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x8f]

s_lshr_b32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x8f]

s_lshr_b32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x8f]

s_lshr_b32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x8f]

s_lshr_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x8f,0x56,0x34,0x12,0xaf]

s_lshr_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x8f,0x73,0x72,0x71,0x3f]

s_lshr_b64 s[10:11], s[2:3], s2
// CHECK: [0x02,0x02,0x8a,0x8f]

s_lshr_b64 s[12:13], s[2:3], s2
// CHECK: [0x02,0x02,0x8c,0x8f]

s_lshr_b64 s[100:101], s[2:3], s2
// CHECK: [0x02,0x02,0xe4,0x8f]

s_lshr_b64 flat_scratch, s[2:3], s2
// CHECK: [0x02,0x02,0xe6,0x8f]

s_lshr_b64 vcc, s[2:3], s2
// CHECK: [0x02,0x02,0xea,0x8f]

s_lshr_b64 ttmp[14:15], s[2:3], s2
// CHECK: [0x02,0x02,0xfa,0x8f]

s_lshr_b64 exec, s[2:3], s2
// CHECK: [0x02,0x02,0xfe,0x8f]

s_lshr_b64 s[10:11], s[4:5], s2
// CHECK: [0x04,0x02,0x8a,0x8f]

s_lshr_b64 s[10:11], s[100:101], s2
// CHECK: [0x64,0x02,0x8a,0x8f]

s_lshr_b64 s[10:11], flat_scratch, s2
// CHECK: [0x66,0x02,0x8a,0x8f]

s_lshr_b64 s[10:11], vcc, s2
// CHECK: [0x6a,0x02,0x8a,0x8f]

s_lshr_b64 s[10:11], ttmp[14:15], s2
// CHECK: [0x7a,0x02,0x8a,0x8f]

s_lshr_b64 s[10:11], exec, s2
// CHECK: [0x7e,0x02,0x8a,0x8f]

s_lshr_b64 s[10:11], 0, s2
// CHECK: [0x80,0x02,0x8a,0x8f]

s_lshr_b64 s[10:11], -1, s2
// CHECK: [0xc1,0x02,0x8a,0x8f]

s_lshr_b64 s[10:11], 0.5, s2
// CHECK: [0xf0,0x02,0x8a,0x8f]

s_lshr_b64 s[10:11], -4.0, s2
// CHECK: [0xf7,0x02,0x8a,0x8f]

s_lshr_b64 s[10:11], src_vccz, s2
// CHECK: [0xfb,0x02,0x8a,0x8f]

s_lshr_b64 s[10:11], src_execz, s2
// CHECK: [0xfc,0x02,0x8a,0x8f]

s_lshr_b64 s[10:11], src_scc, s2
// CHECK: [0xfd,0x02,0x8a,0x8f]

s_lshr_b64 s[10:11], 0xaf123456, s2
// CHECK: [0xff,0x02,0x8a,0x8f,0x56,0x34,0x12,0xaf]

s_lshr_b64 s[10:11], 0x3f717273, s2
// CHECK: [0xff,0x02,0x8a,0x8f,0x73,0x72,0x71,0x3f]

s_lshr_b64 s[10:11], s[2:3], s101
// CHECK: [0x02,0x65,0x8a,0x8f]

s_lshr_b64 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x02,0x66,0x8a,0x8f]

s_lshr_b64 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x02,0x67,0x8a,0x8f]

s_lshr_b64 s[10:11], s[2:3], vcc_lo
// CHECK: [0x02,0x6a,0x8a,0x8f]

s_lshr_b64 s[10:11], s[2:3], vcc_hi
// CHECK: [0x02,0x6b,0x8a,0x8f]

s_lshr_b64 s[10:11], s[2:3], ttmp15
// CHECK: [0x02,0x7b,0x8a,0x8f]

s_lshr_b64 s[10:11], s[2:3], m0
// CHECK: [0x02,0x7c,0x8a,0x8f]

s_lshr_b64 s[10:11], s[2:3], exec_lo
// CHECK: [0x02,0x7e,0x8a,0x8f]

s_lshr_b64 s[10:11], s[2:3], exec_hi
// CHECK: [0x02,0x7f,0x8a,0x8f]

s_lshr_b64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x8f]

s_lshr_b64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x8f]

s_lshr_b64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x8f]

s_lshr_b64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x8f]

s_lshr_b64 s[10:11], s[2:3], src_vccz
// CHECK: [0x02,0xfb,0x8a,0x8f]

s_lshr_b64 s[10:11], s[2:3], src_execz
// CHECK: [0x02,0xfc,0x8a,0x8f]

s_lshr_b64 s[10:11], s[2:3], src_scc
// CHECK: [0x02,0xfd,0x8a,0x8f]

s_lshr_b64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x8f,0x56,0x34,0x12,0xaf]

s_lshr_b64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x8f,0x73,0x72,0x71,0x3f]

s_ashr_i32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x90]

s_ashr_i32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x90]

s_ashr_i32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x90]

s_ashr_i32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x90]

s_ashr_i32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x90]

s_ashr_i32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x90]

s_ashr_i32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x90]

s_ashr_i32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x90]

s_ashr_i32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x90]

s_ashr_i32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x90]

s_ashr_i32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x90]

s_ashr_i32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x90]

s_ashr_i32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x90]

s_ashr_i32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x90]

s_ashr_i32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x90]

s_ashr_i32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x90]

s_ashr_i32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x90]

s_ashr_i32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x90]

s_ashr_i32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x90]

s_ashr_i32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x90]

s_ashr_i32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x90]

s_ashr_i32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x90]

s_ashr_i32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x90]

s_ashr_i32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x90]

s_ashr_i32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x90]

s_ashr_i32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x90]

s_ashr_i32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x90,0x56,0x34,0x12,0xaf]

s_ashr_i32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x90,0x73,0x72,0x71,0x3f]

s_ashr_i32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x90]

s_ashr_i32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x90]

s_ashr_i32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x90]

s_ashr_i32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x90]

s_ashr_i32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x90]

s_ashr_i32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x90]

s_ashr_i32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x90]

s_ashr_i32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x90]

s_ashr_i32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x90]

s_ashr_i32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x90]

s_ashr_i32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x90]

s_ashr_i32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x90]

s_ashr_i32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x90]

s_ashr_i32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x90]

s_ashr_i32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x90]

s_ashr_i32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x90]

s_ashr_i32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x90,0x56,0x34,0x12,0xaf]

s_ashr_i32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x90,0x73,0x72,0x71,0x3f]

s_ashr_i64 s[10:11], s[2:3], s2
// CHECK: [0x02,0x02,0x8a,0x90]

s_ashr_i64 s[12:13], s[2:3], s2
// CHECK: [0x02,0x02,0x8c,0x90]

s_ashr_i64 s[100:101], s[2:3], s2
// CHECK: [0x02,0x02,0xe4,0x90]

s_ashr_i64 flat_scratch, s[2:3], s2
// CHECK: [0x02,0x02,0xe6,0x90]

s_ashr_i64 vcc, s[2:3], s2
// CHECK: [0x02,0x02,0xea,0x90]

s_ashr_i64 ttmp[14:15], s[2:3], s2
// CHECK: [0x02,0x02,0xfa,0x90]

s_ashr_i64 exec, s[2:3], s2
// CHECK: [0x02,0x02,0xfe,0x90]

s_ashr_i64 s[10:11], s[4:5], s2
// CHECK: [0x04,0x02,0x8a,0x90]

s_ashr_i64 s[10:11], s[100:101], s2
// CHECK: [0x64,0x02,0x8a,0x90]

s_ashr_i64 s[10:11], flat_scratch, s2
// CHECK: [0x66,0x02,0x8a,0x90]

s_ashr_i64 s[10:11], vcc, s2
// CHECK: [0x6a,0x02,0x8a,0x90]

s_ashr_i64 s[10:11], ttmp[14:15], s2
// CHECK: [0x7a,0x02,0x8a,0x90]

s_ashr_i64 s[10:11], exec, s2
// CHECK: [0x7e,0x02,0x8a,0x90]

s_ashr_i64 s[10:11], 0, s2
// CHECK: [0x80,0x02,0x8a,0x90]

s_ashr_i64 s[10:11], -1, s2
// CHECK: [0xc1,0x02,0x8a,0x90]

s_ashr_i64 s[10:11], 0.5, s2
// CHECK: [0xf0,0x02,0x8a,0x90]

s_ashr_i64 s[10:11], -4.0, s2
// CHECK: [0xf7,0x02,0x8a,0x90]

s_ashr_i64 s[10:11], src_vccz, s2
// CHECK: [0xfb,0x02,0x8a,0x90]

s_ashr_i64 s[10:11], src_execz, s2
// CHECK: [0xfc,0x02,0x8a,0x90]

s_ashr_i64 s[10:11], src_scc, s2
// CHECK: [0xfd,0x02,0x8a,0x90]

s_ashr_i64 s[10:11], 0xaf123456, s2
// CHECK: [0xff,0x02,0x8a,0x90,0x56,0x34,0x12,0xaf]

s_ashr_i64 s[10:11], 0x3f717273, s2
// CHECK: [0xff,0x02,0x8a,0x90,0x73,0x72,0x71,0x3f]

s_ashr_i64 s[10:11], s[2:3], s101
// CHECK: [0x02,0x65,0x8a,0x90]

s_ashr_i64 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x02,0x66,0x8a,0x90]

s_ashr_i64 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x02,0x67,0x8a,0x90]

s_ashr_i64 s[10:11], s[2:3], vcc_lo
// CHECK: [0x02,0x6a,0x8a,0x90]

s_ashr_i64 s[10:11], s[2:3], vcc_hi
// CHECK: [0x02,0x6b,0x8a,0x90]

s_ashr_i64 s[10:11], s[2:3], ttmp15
// CHECK: [0x02,0x7b,0x8a,0x90]

s_ashr_i64 s[10:11], s[2:3], m0
// CHECK: [0x02,0x7c,0x8a,0x90]

s_ashr_i64 s[10:11], s[2:3], exec_lo
// CHECK: [0x02,0x7e,0x8a,0x90]

s_ashr_i64 s[10:11], s[2:3], exec_hi
// CHECK: [0x02,0x7f,0x8a,0x90]

s_ashr_i64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x90]

s_ashr_i64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x90]

s_ashr_i64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x90]

s_ashr_i64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x90]

s_ashr_i64 s[10:11], s[2:3], src_vccz
// CHECK: [0x02,0xfb,0x8a,0x90]

s_ashr_i64 s[10:11], s[2:3], src_execz
// CHECK: [0x02,0xfc,0x8a,0x90]

s_ashr_i64 s[10:11], s[2:3], src_scc
// CHECK: [0x02,0xfd,0x8a,0x90]

s_ashr_i64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x90,0x56,0x34,0x12,0xaf]

s_ashr_i64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x90,0x73,0x72,0x71,0x3f]

s_bfm_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x91]

s_bfm_b32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x91]

s_bfm_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x91]

s_bfm_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x91]

s_bfm_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x91]

s_bfm_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x91]

s_bfm_b32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x91]

s_bfm_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x91]

s_bfm_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x91]

s_bfm_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x91]

s_bfm_b32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x91]

s_bfm_b32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x91]

s_bfm_b32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x91]

s_bfm_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x91]

s_bfm_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x91]

s_bfm_b32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x91]

s_bfm_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x91]

s_bfm_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x91]

s_bfm_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x91]

s_bfm_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x91]

s_bfm_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x91]

s_bfm_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x91]

s_bfm_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x91]

s_bfm_b32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x91]

s_bfm_b32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x91]

s_bfm_b32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x91]

s_bfm_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x91,0x56,0x34,0x12,0xaf]

s_bfm_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x91,0x73,0x72,0x71,0x3f]

s_bfm_b32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x91]

s_bfm_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x91]

s_bfm_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x91]

s_bfm_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x91]

s_bfm_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x91]

s_bfm_b32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x91]

s_bfm_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x91]

s_bfm_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x91]

s_bfm_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x91]

s_bfm_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x91]

s_bfm_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x91]

s_bfm_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x91]

s_bfm_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x91]

s_bfm_b32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x91]

s_bfm_b32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x91]

s_bfm_b32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x91]

s_bfm_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x91,0x56,0x34,0x12,0xaf]

s_bfm_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x91,0x73,0x72,0x71,0x3f]

s_bfm_b64 s[10:11], s1, s2
// CHECK: [0x01,0x02,0x8a,0x91]

s_bfm_b64 s[12:13], s1, s2
// CHECK: [0x01,0x02,0x8c,0x91]

s_bfm_b64 s[100:101], s1, s2
// CHECK: [0x01,0x02,0xe4,0x91]

s_bfm_b64 flat_scratch, s1, s2
// CHECK: [0x01,0x02,0xe6,0x91]

s_bfm_b64 vcc, s1, s2
// CHECK: [0x01,0x02,0xea,0x91]

s_bfm_b64 ttmp[14:15], s1, s2
// CHECK: [0x01,0x02,0xfa,0x91]

s_bfm_b64 exec, s1, s2
// CHECK: [0x01,0x02,0xfe,0x91]

s_bfm_b64 s[10:11], s101, s2
// CHECK: [0x65,0x02,0x8a,0x91]

s_bfm_b64 s[10:11], flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x8a,0x91]

s_bfm_b64 s[10:11], flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x8a,0x91]

s_bfm_b64 s[10:11], vcc_lo, s2
// CHECK: [0x6a,0x02,0x8a,0x91]

s_bfm_b64 s[10:11], vcc_hi, s2
// CHECK: [0x6b,0x02,0x8a,0x91]

s_bfm_b64 s[10:11], ttmp15, s2
// CHECK: [0x7b,0x02,0x8a,0x91]

s_bfm_b64 s[10:11], m0, s2
// CHECK: [0x7c,0x02,0x8a,0x91]

s_bfm_b64 s[10:11], exec_lo, s2
// CHECK: [0x7e,0x02,0x8a,0x91]

s_bfm_b64 s[10:11], exec_hi, s2
// CHECK: [0x7f,0x02,0x8a,0x91]

s_bfm_b64 s[10:11], 0, s2
// CHECK: [0x80,0x02,0x8a,0x91]

s_bfm_b64 s[10:11], -1, s2
// CHECK: [0xc1,0x02,0x8a,0x91]

s_bfm_b64 s[10:11], 0.5, s2
// CHECK: [0xf0,0x02,0x8a,0x91]

s_bfm_b64 s[10:11], -4.0, s2
// CHECK: [0xf7,0x02,0x8a,0x91]

s_bfm_b64 s[10:11], src_vccz, s2
// CHECK: [0xfb,0x02,0x8a,0x91]

s_bfm_b64 s[10:11], src_execz, s2
// CHECK: [0xfc,0x02,0x8a,0x91]

s_bfm_b64 s[10:11], src_scc, s2
// CHECK: [0xfd,0x02,0x8a,0x91]

s_bfm_b64 s[10:11], 0xaf123456, s2
// CHECK: [0xff,0x02,0x8a,0x91,0x56,0x34,0x12,0xaf]

s_bfm_b64 s[10:11], 0x3f717273, s2
// CHECK: [0xff,0x02,0x8a,0x91,0x73,0x72,0x71,0x3f]

s_bfm_b64 s[10:11], s1, s101
// CHECK: [0x01,0x65,0x8a,0x91]

s_bfm_b64 s[10:11], s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x8a,0x91]

s_bfm_b64 s[10:11], s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x8a,0x91]

s_bfm_b64 s[10:11], s1, vcc_lo
// CHECK: [0x01,0x6a,0x8a,0x91]

s_bfm_b64 s[10:11], s1, vcc_hi
// CHECK: [0x01,0x6b,0x8a,0x91]

s_bfm_b64 s[10:11], s1, ttmp15
// CHECK: [0x01,0x7b,0x8a,0x91]

s_bfm_b64 s[10:11], s1, m0
// CHECK: [0x01,0x7c,0x8a,0x91]

s_bfm_b64 s[10:11], s1, exec_lo
// CHECK: [0x01,0x7e,0x8a,0x91]

s_bfm_b64 s[10:11], s1, exec_hi
// CHECK: [0x01,0x7f,0x8a,0x91]

s_bfm_b64 s[10:11], s1, 0
// CHECK: [0x01,0x80,0x8a,0x91]

s_bfm_b64 s[10:11], s1, -1
// CHECK: [0x01,0xc1,0x8a,0x91]

s_bfm_b64 s[10:11], s1, 0.5
// CHECK: [0x01,0xf0,0x8a,0x91]

s_bfm_b64 s[10:11], s1, -4.0
// CHECK: [0x01,0xf7,0x8a,0x91]

s_bfm_b64 s[10:11], s1, src_vccz
// CHECK: [0x01,0xfb,0x8a,0x91]

s_bfm_b64 s[10:11], s1, src_execz
// CHECK: [0x01,0xfc,0x8a,0x91]

s_bfm_b64 s[10:11], s1, src_scc
// CHECK: [0x01,0xfd,0x8a,0x91]

s_bfm_b64 s[10:11], s1, 0xaf123456
// CHECK: [0x01,0xff,0x8a,0x91,0x56,0x34,0x12,0xaf]

s_bfm_b64 s[10:11], s1, 0x3f717273
// CHECK: [0x01,0xff,0x8a,0x91,0x73,0x72,0x71,0x3f]

s_mul_i32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x92]

s_mul_i32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x92]

s_mul_i32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x92]

s_mul_i32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x92]

s_mul_i32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x92]

s_mul_i32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x92]

s_mul_i32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x92]

s_mul_i32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x92]

s_mul_i32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x92]

s_mul_i32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x92]

s_mul_i32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x92]

s_mul_i32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x92]

s_mul_i32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x92]

s_mul_i32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x92]

s_mul_i32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x92]

s_mul_i32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x92]

s_mul_i32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x92]

s_mul_i32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x92]

s_mul_i32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x92]

s_mul_i32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x92]

s_mul_i32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x92]

s_mul_i32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x92]

s_mul_i32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x92]

s_mul_i32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x92]

s_mul_i32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x92]

s_mul_i32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x92]

s_mul_i32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x92,0x56,0x34,0x12,0xaf]

s_mul_i32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x92,0x73,0x72,0x71,0x3f]

s_mul_i32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x92]

s_mul_i32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x92]

s_mul_i32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x92]

s_mul_i32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x92]

s_mul_i32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x92]

s_mul_i32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x92]

s_mul_i32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x92]

s_mul_i32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x92]

s_mul_i32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x92]

s_mul_i32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x92]

s_mul_i32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x92]

s_mul_i32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x92]

s_mul_i32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x92]

s_mul_i32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x92]

s_mul_i32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x92]

s_mul_i32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x92]

s_mul_i32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x92,0x56,0x34,0x12,0xaf]

s_mul_i32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x92,0x73,0x72,0x71,0x3f]

s_bfe_u32 s5, s1, s2
// CHECK: [0x01,0x02,0x85,0x92]

s_bfe_u32 s101, s1, s2
// CHECK: [0x01,0x02,0xe5,0x92]

s_bfe_u32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0xe6,0x92]

s_bfe_u32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0xe7,0x92]

s_bfe_u32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0xea,0x92]

s_bfe_u32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0xeb,0x92]

s_bfe_u32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0xfb,0x92]

s_bfe_u32 m0, s1, s2
// CHECK: [0x01,0x02,0xfc,0x92]

s_bfe_u32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0xfe,0x92]

s_bfe_u32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0xff,0x92]

s_bfe_u32 s5, s101, s2
// CHECK: [0x65,0x02,0x85,0x92]

s_bfe_u32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x85,0x92]

s_bfe_u32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x85,0x92]

s_bfe_u32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x85,0x92]

s_bfe_u32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x85,0x92]

s_bfe_u32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x85,0x92]

s_bfe_u32 s5, m0, s2
// CHECK: [0x7c,0x02,0x85,0x92]

s_bfe_u32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x85,0x92]

s_bfe_u32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x85,0x92]

s_bfe_u32 s5, 0, s2
// CHECK: [0x80,0x02,0x85,0x92]

s_bfe_u32 s5, -1, s2
// CHECK: [0xc1,0x02,0x85,0x92]

s_bfe_u32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x85,0x92]

s_bfe_u32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x85,0x92]

s_bfe_u32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x85,0x92]

s_bfe_u32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x85,0x92]

s_bfe_u32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x85,0x92]

s_bfe_u32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x85,0x92,0x56,0x34,0x12,0xaf]

s_bfe_u32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x85,0x92,0x73,0x72,0x71,0x3f]

s_bfe_u32 s5, s1, s101
// CHECK: [0x01,0x65,0x85,0x92]

s_bfe_u32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x85,0x92]

s_bfe_u32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x85,0x92]

s_bfe_u32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x85,0x92]

s_bfe_u32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x85,0x92]

s_bfe_u32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x85,0x92]

s_bfe_u32 s5, s1, m0
// CHECK: [0x01,0x7c,0x85,0x92]

s_bfe_u32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x85,0x92]

s_bfe_u32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x85,0x92]

s_bfe_u32 s5, s1, 0
// CHECK: [0x01,0x80,0x85,0x92]

s_bfe_u32 s5, s1, -1
// CHECK: [0x01,0xc1,0x85,0x92]

s_bfe_u32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x85,0x92]

s_bfe_u32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x85,0x92]

s_bfe_u32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x85,0x92]

s_bfe_u32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x85,0x92]

s_bfe_u32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x85,0x92]

s_bfe_u32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x85,0x92,0x56,0x34,0x12,0xaf]

s_bfe_u32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x85,0x92,0x73,0x72,0x71,0x3f]

s_bfe_i32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x93]

s_bfe_i32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x93]

s_bfe_i32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x93]

s_bfe_i32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x93]

s_bfe_i32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x93]

s_bfe_i32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x93]

s_bfe_i32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x93]

s_bfe_i32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x93]

s_bfe_i32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x93]

s_bfe_i32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x93]

s_bfe_i32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x93]

s_bfe_i32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x93]

s_bfe_i32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x93]

s_bfe_i32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x93]

s_bfe_i32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x93]

s_bfe_i32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x93]

s_bfe_i32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x93]

s_bfe_i32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x93]

s_bfe_i32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x93]

s_bfe_i32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x93]

s_bfe_i32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x93]

s_bfe_i32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x93]

s_bfe_i32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x93]

s_bfe_i32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x93]

s_bfe_i32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x93]

s_bfe_i32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x93]

s_bfe_i32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x93,0x56,0x34,0x12,0xaf]

s_bfe_i32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x93,0x73,0x72,0x71,0x3f]

s_bfe_i32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x93]

s_bfe_i32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x93]

s_bfe_i32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x93]

s_bfe_i32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x93]

s_bfe_i32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x93]

s_bfe_i32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x93]

s_bfe_i32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x93]

s_bfe_i32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x93]

s_bfe_i32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x93]

s_bfe_i32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x93]

s_bfe_i32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x93]

s_bfe_i32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x93]

s_bfe_i32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x93]

s_bfe_i32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x93]

s_bfe_i32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x93]

s_bfe_i32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x93]

s_bfe_i32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x93,0x56,0x34,0x12,0xaf]

s_bfe_i32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x93,0x73,0x72,0x71,0x3f]

s_bfe_u64 s[10:11], s[2:3], s2
// CHECK: [0x02,0x02,0x8a,0x93]

s_bfe_u64 s[12:13], s[2:3], s2
// CHECK: [0x02,0x02,0x8c,0x93]

s_bfe_u64 s[100:101], s[2:3], s2
// CHECK: [0x02,0x02,0xe4,0x93]

s_bfe_u64 flat_scratch, s[2:3], s2
// CHECK: [0x02,0x02,0xe6,0x93]

s_bfe_u64 vcc, s[2:3], s2
// CHECK: [0x02,0x02,0xea,0x93]

s_bfe_u64 ttmp[14:15], s[2:3], s2
// CHECK: [0x02,0x02,0xfa,0x93]

s_bfe_u64 exec, s[2:3], s2
// CHECK: [0x02,0x02,0xfe,0x93]

s_bfe_u64 s[10:11], s[4:5], s2
// CHECK: [0x04,0x02,0x8a,0x93]

s_bfe_u64 s[10:11], s[100:101], s2
// CHECK: [0x64,0x02,0x8a,0x93]

s_bfe_u64 s[10:11], flat_scratch, s2
// CHECK: [0x66,0x02,0x8a,0x93]

s_bfe_u64 s[10:11], vcc, s2
// CHECK: [0x6a,0x02,0x8a,0x93]

s_bfe_u64 s[10:11], ttmp[14:15], s2
// CHECK: [0x7a,0x02,0x8a,0x93]

s_bfe_u64 s[10:11], exec, s2
// CHECK: [0x7e,0x02,0x8a,0x93]

s_bfe_u64 s[10:11], 0, s2
// CHECK: [0x80,0x02,0x8a,0x93]

s_bfe_u64 s[10:11], -1, s2
// CHECK: [0xc1,0x02,0x8a,0x93]

s_bfe_u64 s[10:11], 0.5, s2
// CHECK: [0xf0,0x02,0x8a,0x93]

s_bfe_u64 s[10:11], -4.0, s2
// CHECK: [0xf7,0x02,0x8a,0x93]

s_bfe_u64 s[10:11], src_vccz, s2
// CHECK: [0xfb,0x02,0x8a,0x93]

s_bfe_u64 s[10:11], src_execz, s2
// CHECK: [0xfc,0x02,0x8a,0x93]

s_bfe_u64 s[10:11], src_scc, s2
// CHECK: [0xfd,0x02,0x8a,0x93]

s_bfe_u64 s[10:11], 0xaf123456, s2
// CHECK: [0xff,0x02,0x8a,0x93,0x56,0x34,0x12,0xaf]

s_bfe_u64 s[10:11], 0x3f717273, s2
// CHECK: [0xff,0x02,0x8a,0x93,0x73,0x72,0x71,0x3f]

s_bfe_u64 s[10:11], s[2:3], s101
// CHECK: [0x02,0x65,0x8a,0x93]

s_bfe_u64 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x02,0x66,0x8a,0x93]

s_bfe_u64 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x02,0x67,0x8a,0x93]

s_bfe_u64 s[10:11], s[2:3], vcc_lo
// CHECK: [0x02,0x6a,0x8a,0x93]

s_bfe_u64 s[10:11], s[2:3], vcc_hi
// CHECK: [0x02,0x6b,0x8a,0x93]

s_bfe_u64 s[10:11], s[2:3], ttmp15
// CHECK: [0x02,0x7b,0x8a,0x93]

s_bfe_u64 s[10:11], s[2:3], m0
// CHECK: [0x02,0x7c,0x8a,0x93]

s_bfe_u64 s[10:11], s[2:3], exec_lo
// CHECK: [0x02,0x7e,0x8a,0x93]

s_bfe_u64 s[10:11], s[2:3], exec_hi
// CHECK: [0x02,0x7f,0x8a,0x93]

s_bfe_u64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x93]

s_bfe_u64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x93]

s_bfe_u64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x93]

s_bfe_u64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x93]

s_bfe_u64 s[10:11], s[2:3], src_vccz
// CHECK: [0x02,0xfb,0x8a,0x93]

s_bfe_u64 s[10:11], s[2:3], src_execz
// CHECK: [0x02,0xfc,0x8a,0x93]

s_bfe_u64 s[10:11], s[2:3], src_scc
// CHECK: [0x02,0xfd,0x8a,0x93]

s_bfe_u64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x93,0x56,0x34,0x12,0xaf]

s_bfe_u64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x93,0x73,0x72,0x71,0x3f]

s_bfe_i64 s[10:11], s[2:3], s2
// CHECK: [0x02,0x02,0x0a,0x94]

s_bfe_i64 s[12:13], s[2:3], s2
// CHECK: [0x02,0x02,0x0c,0x94]

s_bfe_i64 s[100:101], s[2:3], s2
// CHECK: [0x02,0x02,0x64,0x94]

s_bfe_i64 flat_scratch, s[2:3], s2
// CHECK: [0x02,0x02,0x66,0x94]

s_bfe_i64 vcc, s[2:3], s2
// CHECK: [0x02,0x02,0x6a,0x94]

s_bfe_i64 ttmp[14:15], s[2:3], s2
// CHECK: [0x02,0x02,0x7a,0x94]

s_bfe_i64 exec, s[2:3], s2
// CHECK: [0x02,0x02,0x7e,0x94]

s_bfe_i64 s[10:11], s[4:5], s2
// CHECK: [0x04,0x02,0x0a,0x94]

s_bfe_i64 s[10:11], s[100:101], s2
// CHECK: [0x64,0x02,0x0a,0x94]

s_bfe_i64 s[10:11], flat_scratch, s2
// CHECK: [0x66,0x02,0x0a,0x94]

s_bfe_i64 s[10:11], vcc, s2
// CHECK: [0x6a,0x02,0x0a,0x94]

s_bfe_i64 s[10:11], ttmp[14:15], s2
// CHECK: [0x7a,0x02,0x0a,0x94]

s_bfe_i64 s[10:11], exec, s2
// CHECK: [0x7e,0x02,0x0a,0x94]

s_bfe_i64 s[10:11], 0, s2
// CHECK: [0x80,0x02,0x0a,0x94]

s_bfe_i64 s[10:11], -1, s2
// CHECK: [0xc1,0x02,0x0a,0x94]

s_bfe_i64 s[10:11], 0.5, s2
// CHECK: [0xf0,0x02,0x0a,0x94]

s_bfe_i64 s[10:11], -4.0, s2
// CHECK: [0xf7,0x02,0x0a,0x94]

s_bfe_i64 s[10:11], src_vccz, s2
// CHECK: [0xfb,0x02,0x0a,0x94]

s_bfe_i64 s[10:11], src_execz, s2
// CHECK: [0xfc,0x02,0x0a,0x94]

s_bfe_i64 s[10:11], src_scc, s2
// CHECK: [0xfd,0x02,0x0a,0x94]

s_bfe_i64 s[10:11], 0xaf123456, s2
// CHECK: [0xff,0x02,0x0a,0x94,0x56,0x34,0x12,0xaf]

s_bfe_i64 s[10:11], 0x3f717273, s2
// CHECK: [0xff,0x02,0x0a,0x94,0x73,0x72,0x71,0x3f]

s_bfe_i64 s[10:11], s[2:3], s101
// CHECK: [0x02,0x65,0x0a,0x94]

s_bfe_i64 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x02,0x66,0x0a,0x94]

s_bfe_i64 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x02,0x67,0x0a,0x94]

s_bfe_i64 s[10:11], s[2:3], vcc_lo
// CHECK: [0x02,0x6a,0x0a,0x94]

s_bfe_i64 s[10:11], s[2:3], vcc_hi
// CHECK: [0x02,0x6b,0x0a,0x94]

s_bfe_i64 s[10:11], s[2:3], ttmp15
// CHECK: [0x02,0x7b,0x0a,0x94]

s_bfe_i64 s[10:11], s[2:3], m0
// CHECK: [0x02,0x7c,0x0a,0x94]

s_bfe_i64 s[10:11], s[2:3], exec_lo
// CHECK: [0x02,0x7e,0x0a,0x94]

s_bfe_i64 s[10:11], s[2:3], exec_hi
// CHECK: [0x02,0x7f,0x0a,0x94]

s_bfe_i64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x0a,0x94]

s_bfe_i64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x0a,0x94]

s_bfe_i64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x0a,0x94]

s_bfe_i64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x0a,0x94]

s_bfe_i64 s[10:11], s[2:3], src_vccz
// CHECK: [0x02,0xfb,0x0a,0x94]

s_bfe_i64 s[10:11], s[2:3], src_execz
// CHECK: [0x02,0xfc,0x0a,0x94]

s_bfe_i64 s[10:11], s[2:3], src_scc
// CHECK: [0x02,0xfd,0x0a,0x94]

s_bfe_i64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x0a,0x94,0x56,0x34,0x12,0xaf]

s_bfe_i64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x0a,0x94,0x73,0x72,0x71,0x3f]

s_cbranch_g_fork s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x80,0x94]

s_cbranch_g_fork s[4:5], s[4:5]
// CHECK: [0x04,0x04,0x80,0x94]

s_cbranch_g_fork s[100:101], s[4:5]
// CHECK: [0x64,0x04,0x80,0x94]

s_cbranch_g_fork flat_scratch, s[4:5]
// CHECK: [0x66,0x04,0x80,0x94]

s_cbranch_g_fork vcc, s[4:5]
// CHECK: [0x6a,0x04,0x80,0x94]

s_cbranch_g_fork ttmp[14:15], s[4:5]
// CHECK: [0x7a,0x04,0x80,0x94]

s_cbranch_g_fork exec, s[4:5]
// CHECK: [0x7e,0x04,0x80,0x94]

s_cbranch_g_fork 0, s[4:5]
// CHECK: [0x80,0x04,0x80,0x94]

s_cbranch_g_fork -1, s[4:5]
// CHECK: [0xc1,0x04,0x80,0x94]

s_cbranch_g_fork 0.5, s[4:5]
// CHECK: [0xf0,0x04,0x80,0x94]

s_cbranch_g_fork -4.0, s[4:5]
// CHECK: [0xf7,0x04,0x80,0x94]

s_cbranch_g_fork src_vccz, s[4:5]
// CHECK: [0xfb,0x04,0x80,0x94]

s_cbranch_g_fork src_execz, s[4:5]
// CHECK: [0xfc,0x04,0x80,0x94]

s_cbranch_g_fork src_scc, s[4:5]
// CHECK: [0xfd,0x04,0x80,0x94]

s_cbranch_g_fork s[2:3], s[6:7]
// CHECK: [0x02,0x06,0x80,0x94]

s_cbranch_g_fork s[2:3], s[100:101]
// CHECK: [0x02,0x64,0x80,0x94]

s_cbranch_g_fork s[2:3], flat_scratch
// CHECK: [0x02,0x66,0x80,0x94]

s_cbranch_g_fork s[2:3], vcc
// CHECK: [0x02,0x6a,0x80,0x94]

s_cbranch_g_fork s[2:3], ttmp[14:15]
// CHECK: [0x02,0x7a,0x80,0x94]

s_cbranch_g_fork s[2:3], exec
// CHECK: [0x02,0x7e,0x80,0x94]

s_cbranch_g_fork s[2:3], 0
// CHECK: [0x02,0x80,0x80,0x94]

s_cbranch_g_fork s[2:3], -1
// CHECK: [0x02,0xc1,0x80,0x94]

s_cbranch_g_fork s[2:3], 0.5
// CHECK: [0x02,0xf0,0x80,0x94]

s_cbranch_g_fork s[2:3], -4.0
// CHECK: [0x02,0xf7,0x80,0x94]

s_cbranch_g_fork s[2:3], src_vccz
// CHECK: [0x02,0xfb,0x80,0x94]

s_cbranch_g_fork s[2:3], src_execz
// CHECK: [0x02,0xfc,0x80,0x94]

s_cbranch_g_fork s[2:3], src_scc
// CHECK: [0x02,0xfd,0x80,0x94]

s_absdiff_i32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x95]

s_absdiff_i32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x95]

s_absdiff_i32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x95]

s_absdiff_i32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x95]

s_absdiff_i32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x95]

s_absdiff_i32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x95]

s_absdiff_i32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x95]

s_absdiff_i32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x95]

s_absdiff_i32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x95]

s_absdiff_i32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x95]

s_absdiff_i32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x95]

s_absdiff_i32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x95]

s_absdiff_i32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x95]

s_absdiff_i32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x95]

s_absdiff_i32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x95]

s_absdiff_i32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x95]

s_absdiff_i32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x95]

s_absdiff_i32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x95]

s_absdiff_i32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x95]

s_absdiff_i32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x95]

s_absdiff_i32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x95]

s_absdiff_i32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x95]

s_absdiff_i32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x95]

s_absdiff_i32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x95]

s_absdiff_i32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x95]

s_absdiff_i32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x95]

s_absdiff_i32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x95,0x56,0x34,0x12,0xaf]

s_absdiff_i32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x95,0x73,0x72,0x71,0x3f]

s_absdiff_i32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x95]

s_absdiff_i32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x95]

s_absdiff_i32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x95]

s_absdiff_i32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x95]

s_absdiff_i32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x95]

s_absdiff_i32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x95]

s_absdiff_i32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x95]

s_absdiff_i32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x95]

s_absdiff_i32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x95]

s_absdiff_i32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x95]

s_absdiff_i32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x95]

s_absdiff_i32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x95]

s_absdiff_i32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x95]

s_absdiff_i32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x95]

s_absdiff_i32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x95]

s_absdiff_i32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x95]

s_absdiff_i32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x95,0x56,0x34,0x12,0xaf]

s_absdiff_i32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x95,0x73,0x72,0x71,0x3f]

s_rfe_restore_b64 s[2:3], s2
// CHECK: [0x02,0x02,0x80,0x95]

s_rfe_restore_b64 s[4:5], s2
// CHECK: [0x04,0x02,0x80,0x95]

s_rfe_restore_b64 s[100:101], s2
// CHECK: [0x64,0x02,0x80,0x95]

s_rfe_restore_b64 flat_scratch, s2
// CHECK: [0x66,0x02,0x80,0x95]

s_rfe_restore_b64 vcc, s2
// CHECK: [0x6a,0x02,0x80,0x95]

s_rfe_restore_b64 ttmp[14:15], s2
// CHECK: [0x7a,0x02,0x80,0x95]

s_rfe_restore_b64 exec, s2
// CHECK: [0x7e,0x02,0x80,0x95]

s_rfe_restore_b64 0, s2
// CHECK: [0x80,0x02,0x80,0x95]

s_rfe_restore_b64 -1, s2
// CHECK: [0xc1,0x02,0x80,0x95]

s_rfe_restore_b64 0.5, s2
// CHECK: [0xf0,0x02,0x80,0x95]

s_rfe_restore_b64 -4.0, s2
// CHECK: [0xf7,0x02,0x80,0x95]

s_rfe_restore_b64 src_vccz, s2
// CHECK: [0xfb,0x02,0x80,0x95]

s_rfe_restore_b64 src_execz, s2
// CHECK: [0xfc,0x02,0x80,0x95]

s_rfe_restore_b64 src_scc, s2
// CHECK: [0xfd,0x02,0x80,0x95]

s_rfe_restore_b64 0xaf123456, s2
// CHECK: [0xff,0x02,0x80,0x95,0x56,0x34,0x12,0xaf]

s_rfe_restore_b64 0x3f717273, s2
// CHECK: [0xff,0x02,0x80,0x95,0x73,0x72,0x71,0x3f]

s_rfe_restore_b64 s[2:3], s101
// CHECK: [0x02,0x65,0x80,0x95]

s_rfe_restore_b64 s[2:3], flat_scratch_lo
// CHECK: [0x02,0x66,0x80,0x95]

s_rfe_restore_b64 s[2:3], flat_scratch_hi
// CHECK: [0x02,0x67,0x80,0x95]

s_rfe_restore_b64 s[2:3], vcc_lo
// CHECK: [0x02,0x6a,0x80,0x95]

s_rfe_restore_b64 s[2:3], vcc_hi
// CHECK: [0x02,0x6b,0x80,0x95]

s_rfe_restore_b64 s[2:3], ttmp15
// CHECK: [0x02,0x7b,0x80,0x95]

s_rfe_restore_b64 s[2:3], m0
// CHECK: [0x02,0x7c,0x80,0x95]

s_rfe_restore_b64 s[2:3], exec_lo
// CHECK: [0x02,0x7e,0x80,0x95]

s_rfe_restore_b64 s[2:3], exec_hi
// CHECK: [0x02,0x7f,0x80,0x95]

s_rfe_restore_b64 s[2:3], 0
// CHECK: [0x02,0x80,0x80,0x95]

s_rfe_restore_b64 s[2:3], -1
// CHECK: [0x02,0xc1,0x80,0x95]

s_rfe_restore_b64 s[2:3], 0.5
// CHECK: [0x02,0xf0,0x80,0x95]

s_rfe_restore_b64 s[2:3], -4.0
// CHECK: [0x02,0xf7,0x80,0x95]

s_rfe_restore_b64 s[2:3], src_vccz
// CHECK: [0x02,0xfb,0x80,0x95]

s_rfe_restore_b64 s[2:3], src_execz
// CHECK: [0x02,0xfc,0x80,0x95]

s_rfe_restore_b64 s[2:3], src_scc
// CHECK: [0x02,0xfd,0x80,0x95]

s_rfe_restore_b64 s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x80,0x95,0x56,0x34,0x12,0xaf]

s_rfe_restore_b64 s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x80,0x95,0x73,0x72,0x71,0x3f]

s_mul_hi_u32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x96]

s_mul_hi_u32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x96]

s_mul_hi_u32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x96]

s_mul_hi_u32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x96]

s_mul_hi_u32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x96]

s_mul_hi_u32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x96]

s_mul_hi_u32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x96]

s_mul_hi_u32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x96]

s_mul_hi_u32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x96]

s_mul_hi_u32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x96]

s_mul_hi_u32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x96]

s_mul_hi_u32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x96]

s_mul_hi_u32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x96]

s_mul_hi_u32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x96]

s_mul_hi_u32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x96]

s_mul_hi_u32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x96]

s_mul_hi_u32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x96]

s_mul_hi_u32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x96]

s_mul_hi_u32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x96]

s_mul_hi_u32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x96]

s_mul_hi_u32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x96]

s_mul_hi_u32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x96]

s_mul_hi_u32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x96]

s_mul_hi_u32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x96]

s_mul_hi_u32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x96]

s_mul_hi_u32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x96]

s_mul_hi_u32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x96,0x56,0x34,0x12,0xaf]

s_mul_hi_u32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x96,0x73,0x72,0x71,0x3f]

s_mul_hi_u32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x96]

s_mul_hi_u32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x96]

s_mul_hi_u32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x96]

s_mul_hi_u32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x96]

s_mul_hi_u32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x96]

s_mul_hi_u32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x96]

s_mul_hi_u32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x96]

s_mul_hi_u32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x96]

s_mul_hi_u32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x96]

s_mul_hi_u32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x96]

s_mul_hi_u32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x96]

s_mul_hi_u32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x96]

s_mul_hi_u32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x96]

s_mul_hi_u32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x96]

s_mul_hi_u32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x96]

s_mul_hi_u32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x96]

s_mul_hi_u32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x96,0x56,0x34,0x12,0xaf]

s_mul_hi_u32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x96,0x73,0x72,0x71,0x3f]

s_mul_hi_i32 s5, s1, s2
// CHECK: [0x01,0x02,0x85,0x96]

s_mul_hi_i32 s101, s1, s2
// CHECK: [0x01,0x02,0xe5,0x96]

s_mul_hi_i32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0xe6,0x96]

s_mul_hi_i32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0xe7,0x96]

s_mul_hi_i32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0xea,0x96]

s_mul_hi_i32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0xeb,0x96]

s_mul_hi_i32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0xfb,0x96]

s_mul_hi_i32 m0, s1, s2
// CHECK: [0x01,0x02,0xfc,0x96]

s_mul_hi_i32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0xfe,0x96]

s_mul_hi_i32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0xff,0x96]

s_mul_hi_i32 s5, s101, s2
// CHECK: [0x65,0x02,0x85,0x96]

s_mul_hi_i32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x85,0x96]

s_mul_hi_i32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x85,0x96]

s_mul_hi_i32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x85,0x96]

s_mul_hi_i32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x85,0x96]

s_mul_hi_i32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x85,0x96]

s_mul_hi_i32 s5, m0, s2
// CHECK: [0x7c,0x02,0x85,0x96]

s_mul_hi_i32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x85,0x96]

s_mul_hi_i32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x85,0x96]

s_mul_hi_i32 s5, 0, s2
// CHECK: [0x80,0x02,0x85,0x96]

s_mul_hi_i32 s5, -1, s2
// CHECK: [0xc1,0x02,0x85,0x96]

s_mul_hi_i32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x85,0x96]

s_mul_hi_i32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x85,0x96]

s_mul_hi_i32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x85,0x96]

s_mul_hi_i32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x85,0x96]

s_mul_hi_i32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x85,0x96]

s_mul_hi_i32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x85,0x96,0x56,0x34,0x12,0xaf]

s_mul_hi_i32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x85,0x96,0x73,0x72,0x71,0x3f]

s_mul_hi_i32 s5, s1, s101
// CHECK: [0x01,0x65,0x85,0x96]

s_mul_hi_i32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x85,0x96]

s_mul_hi_i32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x85,0x96]

s_mul_hi_i32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x85,0x96]

s_mul_hi_i32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x85,0x96]

s_mul_hi_i32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x85,0x96]

s_mul_hi_i32 s5, s1, m0
// CHECK: [0x01,0x7c,0x85,0x96]

s_mul_hi_i32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x85,0x96]

s_mul_hi_i32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x85,0x96]

s_mul_hi_i32 s5, s1, 0
// CHECK: [0x01,0x80,0x85,0x96]

s_mul_hi_i32 s5, s1, -1
// CHECK: [0x01,0xc1,0x85,0x96]

s_mul_hi_i32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x85,0x96]

s_mul_hi_i32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x85,0x96]

s_mul_hi_i32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x85,0x96]

s_mul_hi_i32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x85,0x96]

s_mul_hi_i32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x85,0x96]

s_mul_hi_i32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x85,0x96,0x56,0x34,0x12,0xaf]

s_mul_hi_i32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x85,0x96,0x73,0x72,0x71,0x3f]

s_lshl1_add_u32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x97]

s_lshl1_add_u32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x97]

s_lshl1_add_u32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x97]

s_lshl1_add_u32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x97]

s_lshl1_add_u32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x97]

s_lshl1_add_u32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x97]

s_lshl1_add_u32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x97]

s_lshl1_add_u32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x97]

s_lshl1_add_u32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x97]

s_lshl1_add_u32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x97]

s_lshl1_add_u32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x97]

s_lshl1_add_u32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x97]

s_lshl1_add_u32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x97]

s_lshl1_add_u32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x97]

s_lshl1_add_u32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x97]

s_lshl1_add_u32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x97]

s_lshl1_add_u32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x97]

s_lshl1_add_u32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x97]

s_lshl1_add_u32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x97]

s_lshl1_add_u32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x97]

s_lshl1_add_u32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x97]

s_lshl1_add_u32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x97]

s_lshl1_add_u32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x97]

s_lshl1_add_u32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x97]

s_lshl1_add_u32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x97]

s_lshl1_add_u32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x97]

s_lshl1_add_u32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x97,0x56,0x34,0x12,0xaf]

s_lshl1_add_u32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x97,0x73,0x72,0x71,0x3f]

s_lshl1_add_u32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x97]

s_lshl1_add_u32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x97]

s_lshl1_add_u32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x97]

s_lshl1_add_u32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x97]

s_lshl1_add_u32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x97]

s_lshl1_add_u32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x97]

s_lshl1_add_u32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x97]

s_lshl1_add_u32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x97]

s_lshl1_add_u32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x97]

s_lshl1_add_u32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x97]

s_lshl1_add_u32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x97]

s_lshl1_add_u32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x97]

s_lshl1_add_u32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x97]

s_lshl1_add_u32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x97]

s_lshl1_add_u32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x97]

s_lshl1_add_u32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x97]

s_lshl1_add_u32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x97,0x56,0x34,0x12,0xaf]

s_lshl1_add_u32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x97,0x73,0x72,0x71,0x3f]

s_lshl2_add_u32 s5, s1, s2
// CHECK: [0x01,0x02,0x85,0x97]

s_lshl2_add_u32 s101, s1, s2
// CHECK: [0x01,0x02,0xe5,0x97]

s_lshl2_add_u32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0xe6,0x97]

s_lshl2_add_u32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0xe7,0x97]

s_lshl2_add_u32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0xea,0x97]

s_lshl2_add_u32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0xeb,0x97]

s_lshl2_add_u32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0xfb,0x97]

s_lshl2_add_u32 m0, s1, s2
// CHECK: [0x01,0x02,0xfc,0x97]

s_lshl2_add_u32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0xfe,0x97]

s_lshl2_add_u32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0xff,0x97]

s_lshl2_add_u32 s5, s101, s2
// CHECK: [0x65,0x02,0x85,0x97]

s_lshl2_add_u32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x85,0x97]

s_lshl2_add_u32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x85,0x97]

s_lshl2_add_u32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x85,0x97]

s_lshl2_add_u32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x85,0x97]

s_lshl2_add_u32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x85,0x97]

s_lshl2_add_u32 s5, m0, s2
// CHECK: [0x7c,0x02,0x85,0x97]

s_lshl2_add_u32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x85,0x97]

s_lshl2_add_u32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x85,0x97]

s_lshl2_add_u32 s5, 0, s2
// CHECK: [0x80,0x02,0x85,0x97]

s_lshl2_add_u32 s5, -1, s2
// CHECK: [0xc1,0x02,0x85,0x97]

s_lshl2_add_u32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x85,0x97]

s_lshl2_add_u32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x85,0x97]

s_lshl2_add_u32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x85,0x97]

s_lshl2_add_u32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x85,0x97]

s_lshl2_add_u32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x85,0x97]

s_lshl2_add_u32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x85,0x97,0x56,0x34,0x12,0xaf]

s_lshl2_add_u32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x85,0x97,0x73,0x72,0x71,0x3f]

s_lshl2_add_u32 s5, s1, s101
// CHECK: [0x01,0x65,0x85,0x97]

s_lshl2_add_u32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x85,0x97]

s_lshl2_add_u32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x85,0x97]

s_lshl2_add_u32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x85,0x97]

s_lshl2_add_u32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x85,0x97]

s_lshl2_add_u32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x85,0x97]

s_lshl2_add_u32 s5, s1, m0
// CHECK: [0x01,0x7c,0x85,0x97]

s_lshl2_add_u32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x85,0x97]

s_lshl2_add_u32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x85,0x97]

s_lshl2_add_u32 s5, s1, 0
// CHECK: [0x01,0x80,0x85,0x97]

s_lshl2_add_u32 s5, s1, -1
// CHECK: [0x01,0xc1,0x85,0x97]

s_lshl2_add_u32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x85,0x97]

s_lshl2_add_u32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x85,0x97]

s_lshl2_add_u32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x85,0x97]

s_lshl2_add_u32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x85,0x97]

s_lshl2_add_u32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x85,0x97]

s_lshl2_add_u32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x85,0x97,0x56,0x34,0x12,0xaf]

s_lshl2_add_u32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x85,0x97,0x73,0x72,0x71,0x3f]

s_lshl3_add_u32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x98]

s_lshl3_add_u32 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x98]

s_lshl3_add_u32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x98]

s_lshl3_add_u32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x98]

s_lshl3_add_u32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x98]

s_lshl3_add_u32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x98]

s_lshl3_add_u32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x98]

s_lshl3_add_u32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x98]

s_lshl3_add_u32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x98]

s_lshl3_add_u32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x98]

s_lshl3_add_u32 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x98]

s_lshl3_add_u32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x98]

s_lshl3_add_u32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x98]

s_lshl3_add_u32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x98]

s_lshl3_add_u32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x98]

s_lshl3_add_u32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x98]

s_lshl3_add_u32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x98]

s_lshl3_add_u32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x98]

s_lshl3_add_u32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x98]

s_lshl3_add_u32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x98]

s_lshl3_add_u32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x98]

s_lshl3_add_u32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x98]

s_lshl3_add_u32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x98]

s_lshl3_add_u32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x98]

s_lshl3_add_u32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x98]

s_lshl3_add_u32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x98]

s_lshl3_add_u32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x98,0x56,0x34,0x12,0xaf]

s_lshl3_add_u32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x98,0x73,0x72,0x71,0x3f]

s_lshl3_add_u32 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x98]

s_lshl3_add_u32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x98]

s_lshl3_add_u32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x98]

s_lshl3_add_u32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x98]

s_lshl3_add_u32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x98]

s_lshl3_add_u32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x98]

s_lshl3_add_u32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x98]

s_lshl3_add_u32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x98]

s_lshl3_add_u32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x98]

s_lshl3_add_u32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x98]

s_lshl3_add_u32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x98]

s_lshl3_add_u32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x98]

s_lshl3_add_u32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x98]

s_lshl3_add_u32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x98]

s_lshl3_add_u32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x98]

s_lshl3_add_u32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x98]

s_lshl3_add_u32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x98,0x56,0x34,0x12,0xaf]

s_lshl3_add_u32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x98,0x73,0x72,0x71,0x3f]

s_lshl4_add_u32 s5, s1, s2
// CHECK: [0x01,0x02,0x85,0x98]

s_lshl4_add_u32 s101, s1, s2
// CHECK: [0x01,0x02,0xe5,0x98]

s_lshl4_add_u32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0xe6,0x98]

s_lshl4_add_u32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0xe7,0x98]

s_lshl4_add_u32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0xea,0x98]

s_lshl4_add_u32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0xeb,0x98]

s_lshl4_add_u32 ttmp15, s1, s2
// CHECK: [0x01,0x02,0xfb,0x98]

s_lshl4_add_u32 m0, s1, s2
// CHECK: [0x01,0x02,0xfc,0x98]

s_lshl4_add_u32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0xfe,0x98]

s_lshl4_add_u32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0xff,0x98]

s_lshl4_add_u32 s5, s101, s2
// CHECK: [0x65,0x02,0x85,0x98]

s_lshl4_add_u32 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x85,0x98]

s_lshl4_add_u32 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x85,0x98]

s_lshl4_add_u32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x85,0x98]

s_lshl4_add_u32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x85,0x98]

s_lshl4_add_u32 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x85,0x98]

s_lshl4_add_u32 s5, m0, s2
// CHECK: [0x7c,0x02,0x85,0x98]

s_lshl4_add_u32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x85,0x98]

s_lshl4_add_u32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x85,0x98]

s_lshl4_add_u32 s5, 0, s2
// CHECK: [0x80,0x02,0x85,0x98]

s_lshl4_add_u32 s5, -1, s2
// CHECK: [0xc1,0x02,0x85,0x98]

s_lshl4_add_u32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x85,0x98]

s_lshl4_add_u32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x85,0x98]

s_lshl4_add_u32 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x85,0x98]

s_lshl4_add_u32 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x85,0x98]

s_lshl4_add_u32 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x85,0x98]

s_lshl4_add_u32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x85,0x98,0x56,0x34,0x12,0xaf]

s_lshl4_add_u32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x85,0x98,0x73,0x72,0x71,0x3f]

s_lshl4_add_u32 s5, s1, s101
// CHECK: [0x01,0x65,0x85,0x98]

s_lshl4_add_u32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x85,0x98]

s_lshl4_add_u32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x85,0x98]

s_lshl4_add_u32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x85,0x98]

s_lshl4_add_u32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x85,0x98]

s_lshl4_add_u32 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x85,0x98]

s_lshl4_add_u32 s5, s1, m0
// CHECK: [0x01,0x7c,0x85,0x98]

s_lshl4_add_u32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x85,0x98]

s_lshl4_add_u32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x85,0x98]

s_lshl4_add_u32 s5, s1, 0
// CHECK: [0x01,0x80,0x85,0x98]

s_lshl4_add_u32 s5, s1, -1
// CHECK: [0x01,0xc1,0x85,0x98]

s_lshl4_add_u32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x85,0x98]

s_lshl4_add_u32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x85,0x98]

s_lshl4_add_u32 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x85,0x98]

s_lshl4_add_u32 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x85,0x98]

s_lshl4_add_u32 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x85,0x98]

s_lshl4_add_u32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x85,0x98,0x56,0x34,0x12,0xaf]

s_lshl4_add_u32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x85,0x98,0x73,0x72,0x71,0x3f]

s_pack_ll_b32_b16 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x99]

s_pack_ll_b32_b16 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x99]

s_pack_ll_b32_b16 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x99]

s_pack_ll_b32_b16 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x99]

s_pack_ll_b32_b16 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x99]

s_pack_ll_b32_b16 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x99]

s_pack_ll_b32_b16 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x99]

s_pack_ll_b32_b16 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x99]

s_pack_ll_b32_b16 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x99]

s_pack_ll_b32_b16 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x99]

s_pack_ll_b32_b16 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x99]

s_pack_ll_b32_b16 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x99]

s_pack_ll_b32_b16 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x99]

s_pack_ll_b32_b16 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x99]

s_pack_ll_b32_b16 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x99]

s_pack_ll_b32_b16 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x99]

s_pack_ll_b32_b16 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x99]

s_pack_ll_b32_b16 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x99]

s_pack_ll_b32_b16 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x99]

s_pack_ll_b32_b16 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x99]

s_pack_ll_b32_b16 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x99]

s_pack_ll_b32_b16 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x99]

s_pack_ll_b32_b16 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x99]

s_pack_ll_b32_b16 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x99]

s_pack_ll_b32_b16 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x99]

s_pack_ll_b32_b16 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x99]

s_pack_ll_b32_b16 s5, 0xfe0b, s2
// CHECK: [0xff,0x02,0x05,0x99,0x0b,0xfe,0x00,0x00]

s_pack_ll_b32_b16 s5, 0x3456, s2
// CHECK: [0xff,0x02,0x05,0x99,0x56,0x34,0x00,0x00]

s_pack_ll_b32_b16 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x99]

s_pack_ll_b32_b16 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x99]

s_pack_ll_b32_b16 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x99]

s_pack_ll_b32_b16 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x99]

s_pack_ll_b32_b16 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x99]

s_pack_ll_b32_b16 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x99]

s_pack_ll_b32_b16 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x99]

s_pack_ll_b32_b16 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x99]

s_pack_ll_b32_b16 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x99]

s_pack_ll_b32_b16 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x99]

s_pack_ll_b32_b16 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x99]

s_pack_ll_b32_b16 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x99]

s_pack_ll_b32_b16 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x99]

s_pack_ll_b32_b16 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x99]

s_pack_ll_b32_b16 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x99]

s_pack_ll_b32_b16 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x99]

s_pack_ll_b32_b16 s5, s1, 0xfe0b
// CHECK: [0x01,0xff,0x05,0x99,0x0b,0xfe,0x00,0x00]

s_pack_ll_b32_b16 s5, s1, 0x3456
// CHECK: [0x01,0xff,0x05,0x99,0x56,0x34,0x00,0x00]

s_pack_lh_b32_b16 s5, s1, s2
// CHECK: [0x01,0x02,0x85,0x99]

s_pack_lh_b32_b16 s101, s1, s2
// CHECK: [0x01,0x02,0xe5,0x99]

s_pack_lh_b32_b16 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0xe6,0x99]

s_pack_lh_b32_b16 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0xe7,0x99]

s_pack_lh_b32_b16 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0xea,0x99]

s_pack_lh_b32_b16 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0xeb,0x99]

s_pack_lh_b32_b16 ttmp15, s1, s2
// CHECK: [0x01,0x02,0xfb,0x99]

s_pack_lh_b32_b16 m0, s1, s2
// CHECK: [0x01,0x02,0xfc,0x99]

s_pack_lh_b32_b16 exec_lo, s1, s2
// CHECK: [0x01,0x02,0xfe,0x99]

s_pack_lh_b32_b16 exec_hi, s1, s2
// CHECK: [0x01,0x02,0xff,0x99]

s_pack_lh_b32_b16 s5, s101, s2
// CHECK: [0x65,0x02,0x85,0x99]

s_pack_lh_b32_b16 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x85,0x99]

s_pack_lh_b32_b16 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x85,0x99]

s_pack_lh_b32_b16 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x85,0x99]

s_pack_lh_b32_b16 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x85,0x99]

s_pack_lh_b32_b16 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x85,0x99]

s_pack_lh_b32_b16 s5, m0, s2
// CHECK: [0x7c,0x02,0x85,0x99]

s_pack_lh_b32_b16 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x85,0x99]

s_pack_lh_b32_b16 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x85,0x99]

s_pack_lh_b32_b16 s5, 0, s2
// CHECK: [0x80,0x02,0x85,0x99]

s_pack_lh_b32_b16 s5, -1, s2
// CHECK: [0xc1,0x02,0x85,0x99]

s_pack_lh_b32_b16 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x85,0x99]

s_pack_lh_b32_b16 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x85,0x99]

s_pack_lh_b32_b16 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x85,0x99]

s_pack_lh_b32_b16 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x85,0x99]

s_pack_lh_b32_b16 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x85,0x99]

s_pack_lh_b32_b16 s5, 0xfe0b, s2
// CHECK: [0xff,0x02,0x85,0x99,0x0b,0xfe,0x00,0x00]

s_pack_lh_b32_b16 s5, 0x3456, s2
// CHECK: [0xff,0x02,0x85,0x99,0x56,0x34,0x00,0x00]

s_pack_lh_b32_b16 s5, s1, s101
// CHECK: [0x01,0x65,0x85,0x99]

s_pack_lh_b32_b16 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x85,0x99]

s_pack_lh_b32_b16 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x85,0x99]

s_pack_lh_b32_b16 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x85,0x99]

s_pack_lh_b32_b16 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x85,0x99]

s_pack_lh_b32_b16 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x85,0x99]

s_pack_lh_b32_b16 s5, s1, m0
// CHECK: [0x01,0x7c,0x85,0x99]

s_pack_lh_b32_b16 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x85,0x99]

s_pack_lh_b32_b16 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x85,0x99]

s_pack_lh_b32_b16 s5, s1, 0
// CHECK: [0x01,0x80,0x85,0x99]

s_pack_lh_b32_b16 s5, s1, -1
// CHECK: [0x01,0xc1,0x85,0x99]

s_pack_lh_b32_b16 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x85,0x99]

s_pack_lh_b32_b16 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x85,0x99]

s_pack_lh_b32_b16 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x85,0x99]

s_pack_lh_b32_b16 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x85,0x99]

s_pack_lh_b32_b16 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x85,0x99]

s_pack_lh_b32_b16 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x85,0x99,0x56,0x34,0x12,0xaf]

s_pack_lh_b32_b16 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x85,0x99,0x73,0x72,0x71,0x3f]

s_pack_hh_b32_b16 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x9a]

s_pack_hh_b32_b16 s101, s1, s2
// CHECK: [0x01,0x02,0x65,0x9a]

s_pack_hh_b32_b16 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x66,0x9a]

s_pack_hh_b32_b16 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x67,0x9a]

s_pack_hh_b32_b16 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x9a]

s_pack_hh_b32_b16 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x9a]

s_pack_hh_b32_b16 ttmp15, s1, s2
// CHECK: [0x01,0x02,0x7b,0x9a]

s_pack_hh_b32_b16 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x9a]

s_pack_hh_b32_b16 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x9a]

s_pack_hh_b32_b16 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x9a]

s_pack_hh_b32_b16 s5, s101, s2
// CHECK: [0x65,0x02,0x05,0x9a]

s_pack_hh_b32_b16 s5, flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0x9a]

s_pack_hh_b32_b16 s5, flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0x9a]

s_pack_hh_b32_b16 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x9a]

s_pack_hh_b32_b16 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x9a]

s_pack_hh_b32_b16 s5, ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0x9a]

s_pack_hh_b32_b16 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x9a]

s_pack_hh_b32_b16 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x9a]

s_pack_hh_b32_b16 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x9a]

s_pack_hh_b32_b16 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x9a]

s_pack_hh_b32_b16 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x9a]

s_pack_hh_b32_b16 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x9a]

s_pack_hh_b32_b16 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x9a]

s_pack_hh_b32_b16 s5, src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0x9a]

s_pack_hh_b32_b16 s5, src_execz, s2
// CHECK: [0xfc,0x02,0x05,0x9a]

s_pack_hh_b32_b16 s5, src_scc, s2
// CHECK: [0xfd,0x02,0x05,0x9a]

s_pack_hh_b32_b16 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x9a,0x56,0x34,0x12,0xaf]

s_pack_hh_b32_b16 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x9a,0x73,0x72,0x71,0x3f]

s_pack_hh_b32_b16 s5, s1, s101
// CHECK: [0x01,0x65,0x05,0x9a]

s_pack_hh_b32_b16 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0x9a]

s_pack_hh_b32_b16 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0x9a]

s_pack_hh_b32_b16 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x9a]

s_pack_hh_b32_b16 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x9a]

s_pack_hh_b32_b16 s5, s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0x9a]

s_pack_hh_b32_b16 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x9a]

s_pack_hh_b32_b16 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x9a]

s_pack_hh_b32_b16 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x9a]

s_pack_hh_b32_b16 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x9a]

s_pack_hh_b32_b16 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x9a]

s_pack_hh_b32_b16 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x9a]

s_pack_hh_b32_b16 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x9a]

s_pack_hh_b32_b16 s5, s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0x9a]

s_pack_hh_b32_b16 s5, s1, src_execz
// CHECK: [0x01,0xfc,0x05,0x9a]

s_pack_hh_b32_b16 s5, s1, src_scc
// CHECK: [0x01,0xfd,0x05,0x9a]

s_pack_hh_b32_b16 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x9a,0x56,0x34,0x12,0xaf]

s_pack_hh_b32_b16 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x9a,0x73,0x72,0x71,0x3f]
