/*
 * Copyright (c) 2007, intarsys consulting GmbH
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * - Neither the name of intarsys nor the names of its contributors may be used
 *   to endorse or promote products derived from this software without specific
 *   prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package de.intarsys.tools.functor;

/**
 * A generic implementation for {@link IDeclarationBlock}.
 * 
 */
public class DeclarationBlock extends Declaration implements IDeclarationBlock {

	final public static IDeclarationBlock EMPTY = new EmptyDeclarationBlock();

	private IDeclaration[] declarations;

	public DeclarationBlock(Object declarationContext) {
		super(declarationContext);
		declarations = new IDeclaration[0];
	}

	public DeclarationBlock(Object declarationContext,
			IDeclaration[] declarations) {
		super(declarationContext);
		this.declarations = declarations;
	}

	public IFunctorCall accept(IFunctorCall call) throws DeclarationException {
		IFunctorCall result = call;
		for (int i = 0; i < declarations.length; i++) {
			IDeclaration declaration = declarations[i];
			result = declaration.accept(result);
		}
		return result;
	}

	public void addDeclaration(IDeclaration declaration) {
		IDeclaration[] newDeclarations = new IDeclaration[declarations.length + 1];
		System.arraycopy(declarations, 0, newDeclarations, 0,
				declarations.length);
		newDeclarations[declarations.length] = declaration;
		declarations = newDeclarations;
	}

	public IDeclaration[] getDeclarations() {
		return declarations;
	}

	@Override
	public boolean isBlock() {
		return true;
	}

	public boolean removeDeclaration(IDeclaration declaration) {
		for (int i = 0; i < declarations.length; i++) {
			if (declarations[i] == declaration) {
				IDeclaration[] newDeclarations = new IDeclaration[declarations.length - 1];
				System.arraycopy(declarations, 0, newDeclarations, 0, i);
				System.arraycopy(declarations, i + 1, newDeclarations, i,
						declarations.length - i - 1);
				declarations = newDeclarations;
				return true;
			}
		}
		return false;
	}

	public int size() {
		return declarations.length;
	}
}
