#include <stdio.h>
#include <stdlib.h>
#include "ppd.h"

int main(int argc, char *argv[])
{
  PpdFile *ppd;
  int i;

  if (argc < 2) {
    printf
      ("Usage: %s [ppdfiles]\nWhere [ppdfiles] is a list of ppd files to dump.\n",
       argv[0]);
    return (1);
  }

  for (i = 1; i < argc; i++) {
    // printf("Dumping file: %s\n", argv[i]);
    if ((ppd = ppd_file_new(argv[i])) == NULL) {
      printf("Unable to load ppd file: %s\n", argv[i]);
      exit(1);
    }

    ppd_debug_dump_ppd(ppd);
    ppd_file_free(ppd);
  }
  return (0);
}
