/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.text.NumberFormat;
import java.text.ParsePosition;
import org.postgresql.core.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ServerVersion implements Version
{
    INVALID("0.0.0"),
    v6_4("6.4.0"),
    v6_5("6.5.0"),
    v7_0("7.0.0"),
    v7_1("7.1.0"),
    v7_2("7.2.0"),
    v7_3("7.3.0"),
    v7_4("7.4.0"),
    v8_0("8.0.0"),
    v8_1("8.1.0"),
    v8_2("8.2.0"),
    v8_3("8.3.0"),
    v8_4("8.4.0"),
    v9_0("9.0.0"),
    v9_1("9.1.0"),
    v9_2("9.2.0"),
    v9_3("9.3.0"),
    v9_4("9.4.0"),
    v9_5("9.5.0");

    private final int version;

    private ServerVersion(String version) {
        this.version = ServerVersion.parseServerVersionStr(version);
    }

    @Override
    public int getVersionNum() {
        return this.version;
    }

    public static Version from(String version) {
        final int versionNum = ServerVersion.parseServerVersionStr(version);
        return new Version(){

            public int getVersionNum() {
                return versionNum;
            }

            public boolean equals(Object obj) {
                if (obj instanceof Version) {
                    return this.getVersionNum() == ((Version)obj).getVersionNum();
                }
                return false;
            }

            public int hashCode() {
                return this.getVersionNum();
            }

            public String toString() {
                return Integer.toString(versionNum);
            }
        };
    }

    static int parseServerVersionStr(String serverVersion) throws NumberFormatException {
        NumberFormat numformat = NumberFormat.getIntegerInstance();
        numformat.setGroupingUsed(false);
        ParsePosition parsepos = new ParsePosition(0);
        if (serverVersion == null) {
            return 0;
        }
        Long parsed = (Long)numformat.parseObject(serverVersion, parsepos);
        if (parsed == null) {
            return 0;
        }
        if (parsed.intValue() >= 10000) {
            if (parsepos.getIndex() == serverVersion.length()) {
                return parsed.intValue();
            }
            throw new NumberFormatException("First major-version part equal to or greater than 10000 in invalid version string: " + serverVersion);
        }
        int vers = parsed.intValue() * 10000;
        if (parsepos.getIndex() == serverVersion.length()) {
            return 0;
        }
        if (serverVersion.charAt(parsepos.getIndex()) != '.') {
            return 0;
        }
        parsepos.setIndex(parsepos.getIndex() + 1);
        parsed = (Long)numformat.parseObject(serverVersion, parsepos);
        if (parsed == null) {
            return 0;
        }
        if (parsed.intValue() > 99) {
            throw new NumberFormatException("Unsupported second part of major version > 99 in invalid version string: " + serverVersion);
        }
        vers += parsed.intValue() * 100;
        if (parsepos.getIndex() == serverVersion.length()) {
            return vers;
        }
        if (serverVersion.charAt(parsepos.getIndex()) != '.') {
            return vers;
        }
        parsepos.setIndex(parsepos.getIndex() + 1);
        parsed = (Long)numformat.parseObject(serverVersion, parsepos);
        if (parsed != null) {
            if (parsed.intValue() > 99) {
                throw new NumberFormatException("Unsupported minor version value > 99 in invalid version string: " + serverVersion);
            }
            vers += parsed.intValue();
        }
        return vers;
    }
}

