# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.render_view import RenderView


class GraphLayoutView(RenderView):
    r"""
    GraphLayoutView - Lays out and displays a graph
    
    Superclass: RenderView
    
    GraphLayoutView performs graph layout and displays a Graph. You
    may color and label the vertices and edges using fields in the graph.
    If coordinates are already assigned to the graph vertices in your
    graph, set the layout strategy to pass_through in this view. The
    default layout is Fast2D which is fast but not that good, for better
    layout set the layout to Simple2D or force_directed. There are also
    tree and circle layout strategies. :)
    
    .SEE ALSO Fast2DLayoutStrategy Simple2DLayoutStrategy
    ForceDirectedLayoutStrategy
    
    @par Thanks: Thanks a bunch to the holographic unfolding pattern.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGraphLayoutView, obj, update, **traits)
    
    color_edges = tvtk_base.false_bool_trait(desc=\
        r"""
        Whether to color edges.  Default is off.
        """
    )

    def _color_edges_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetColorEdges,
                        self.color_edges_)

    color_vertices = tvtk_base.false_bool_trait(desc=\
        r"""
        Whether to color vertices.  Default is off.
        """
    )

    def _color_vertices_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetColorVertices,
                        self.color_vertices_)

    edge_label_visibility = tvtk_base.false_bool_trait(desc=\
        r"""
        Whether to show edge labels.  Default is off.
        """
    )

    def _edge_label_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEdgeLabelVisibility,
                        self.edge_label_visibility_)

    edge_selection = tvtk_base.true_bool_trait(desc=\
        r"""
        Whether edges are selectable. Default is on.
        """
    )

    def _edge_selection_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEdgeSelection,
                        self.edge_selection_)

    edge_visibility = tvtk_base.true_bool_trait(desc=\
        r"""
        Whether to show the edges at all. Default is on
        """
    )

    def _edge_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEdgeVisibility,
                        self.edge_visibility_)

    hide_edge_labels_on_interaction = tvtk_base.false_bool_trait(desc=\
        r"""
        Whether to hide edge labels during mouse interactions.  Default
        is off.
        """
    )

    def _hide_edge_labels_on_interaction_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHideEdgeLabelsOnInteraction,
                        self.hide_edge_labels_on_interaction_)

    hide_vertex_labels_on_interaction = tvtk_base.false_bool_trait(desc=\
        r"""
        Whether to hide vertex labels during mouse interactions.  Default
        is off.
        """
    )

    def _hide_vertex_labels_on_interaction_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHideVertexLabelsOnInteraction,
                        self.hide_vertex_labels_on_interaction_)

    icon_visibility = tvtk_base.false_bool_trait(desc=\
        r"""
        Whether icons are visible (default off).
        """
    )

    def _icon_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIconVisibility,
                        self.icon_visibility_)

    scaled_glyphs = tvtk_base.false_bool_trait(desc=\
        r"""
        Whether to use scaled glyphs or not.  Default is off.
        """
    )

    def _scaled_glyphs_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScaledGlyphs,
                        self.scaled_glyphs_)

    vertex_label_visibility = tvtk_base.false_bool_trait(desc=\
        r"""
        Whether to show vertex labels.  Default is off.
        """
    )

    def _vertex_label_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVertexLabelVisibility,
                        self.vertex_label_visibility_)

    def get_edge_layout_strategy(self):
        """
        get_edge_layout_strategy(self) -> EdgeLayoutStrategy
        C++: EdgeLayoutStrategy *get_edge_layout_strategy()
        The layout strategy to use when performing the edge layout. This
        signature allows an application to create a layout object
        directly and simply set the pointer through this method.
        """
        ret = wrap_vtk(self._vtk_obj.GetEdgeLayoutStrategy())
        return ret
        

    def set_edge_layout_strategy_to_arc_parallel(self):
        """
        set_edge_layout_strategy_to_arc_parallel(self) -> None
        C++: void set_edge_layout_strategy_to_arc_parallel()"""
        self._vtk_obj.SetEdgeLayoutStrategyToArcParallel()

    def set_edge_layout_strategy_to_pass_through(self):
        """
        set_edge_layout_strategy_to_pass_through(self) -> None
        C++: void set_edge_layout_strategy_to_pass_through()"""
        self._vtk_obj.SetEdgeLayoutStrategyToPassThrough()

    def get_layout_strategy(self):
        """
        get_layout_strategy(self) -> GraphLayoutStrategy
        C++: GraphLayoutStrategy *get_layout_strategy()
        The layout strategy to use when performing the graph layout. This
        signature allows an application to create a layout object
        directly and simply set the pointer through this method.
        """
        ret = wrap_vtk(self._vtk_obj.GetLayoutStrategy())
        return ret
        

    def set_layout_strategy_to_clustering2d(self):
        """
        set_layout_strategy_to_clustering2d(self) -> None
        C++: void set_layout_strategy_to_clustering2d()"""
        self._vtk_obj.SetLayoutStrategyToClustering2D()

    def set_layout_strategy_to_community2d(self):
        """
        set_layout_strategy_to_community2d(self) -> None
        C++: void set_layout_strategy_to_community2d()"""
        self._vtk_obj.SetLayoutStrategyToCommunity2D()

    def set_layout_strategy_to_cone(self):
        """
        set_layout_strategy_to_cone(self) -> None
        C++: void set_layout_strategy_to_cone()"""
        self._vtk_obj.SetLayoutStrategyToCone()

    def set_layout_strategy_to_cosmic_tree(self):
        """
        set_layout_strategy_to_cosmic_tree(self) -> None
        C++: void set_layout_strategy_to_cosmic_tree()"""
        self._vtk_obj.SetLayoutStrategyToCosmicTree()

    def set_layout_strategy_to_fast2d(self):
        """
        set_layout_strategy_to_fast2d(self) -> None
        C++: void set_layout_strategy_to_fast2d()"""
        self._vtk_obj.SetLayoutStrategyToFast2D()

    def set_layout_strategy_to_force_directed(self):
        """
        set_layout_strategy_to_force_directed(self) -> None
        C++: void set_layout_strategy_to_force_directed()"""
        self._vtk_obj.SetLayoutStrategyToForceDirected()

    def set_layout_strategy_to_pass_through(self):
        """
        set_layout_strategy_to_pass_through(self) -> None
        C++: void set_layout_strategy_to_pass_through()"""
        self._vtk_obj.SetLayoutStrategyToPassThrough()

    def set_layout_strategy_to_random(self):
        """
        set_layout_strategy_to_random(self) -> None
        C++: void set_layout_strategy_to_random()"""
        self._vtk_obj.SetLayoutStrategyToRandom()

    def set_layout_strategy_to_simple2d(self):
        """
        set_layout_strategy_to_simple2d(self) -> None
        C++: void set_layout_strategy_to_simple2d()"""
        self._vtk_obj.SetLayoutStrategyToSimple2D()

    def set_layout_strategy_to_span_tree(self):
        """
        set_layout_strategy_to_span_tree(self) -> None
        C++: void set_layout_strategy_to_span_tree()"""
        self._vtk_obj.SetLayoutStrategyToSpanTree()

    def set_layout_strategy_to_tree(self):
        """
        set_layout_strategy_to_tree(self) -> None
        C++: void set_layout_strategy_to_tree()"""
        self._vtk_obj.SetLayoutStrategyToTree()

    edge_color_array_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        The array to use for coloring edges.  Default is "color".
        """
    )

    def _edge_color_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEdgeColorArrayName,
                        self.edge_color_array_name)

    edge_label_array_name = traits.String('LabelText', enter_set=True, auto_set=False, desc=\
        r"""
        The array to use for edge labeling.  Default is "label_text".
        """
    )

    def _edge_label_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEdgeLabelArrayName,
                        self.edge_label_array_name)

    edge_label_font_size = traits.Int(10, enter_set=True, auto_set=False, desc=\
        r"""
        The size of the font used for edge labeling
        """
    )

    def _edge_label_font_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEdgeLabelFontSize,
                        self.edge_label_font_size)

    edge_scalar_bar_visibility = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        Whether the scalar bar for edges is visible.  Default is off.
        """
    )

    def _edge_scalar_bar_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEdgeScalarBarVisibility,
                        self.edge_scalar_bar_visibility)

    enable_edges_by_array = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Whether to color edges.  Default is off.
        """
    )

    def _enable_edges_by_array_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnableEdgesByArray,
                        self.enable_edges_by_array)

    enable_vertices_by_array = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Whether to color vertices.  Default is off.
        """
    )

    def _enable_vertices_by_array_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnableVerticesByArray,
                        self.enable_vertices_by_array)

    enabled_edges_array_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        The array to use for coloring edges.
        """
    )

    def _enabled_edges_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnabledEdgesArrayName,
                        self.enabled_edges_array_name)

    enabled_vertices_array_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        The array to use for coloring vertices.
        """
    )

    def _enabled_vertices_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnabledVerticesArrayName,
                        self.enabled_vertices_array_name)

    glyph_type = traits.Int(1, enter_set=True, auto_set=False, desc=\
        r"""
        The type of glyph to use for the vertices
        """
    )

    def _glyph_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGlyphType,
                        self.glyph_type)

    icon_array_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        The array used for assigning icons
        """
    )

    def _icon_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIconArrayName,
                        self.icon_array_name)

    scaling_array_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        The array used for scaling (if scaled_glyphs is ON)
        """
    )

    def _scaling_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScalingArrayName,
                        self.scaling_array_name)

    vertex_color_array_name = traits.String('VertexDegree', enter_set=True, auto_set=False, desc=\
        r"""
        The array to use for coloring vertices.  The default behavior is
        to color by vertex degree.
        """
    )

    def _vertex_color_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVertexColorArrayName,
                        self.vertex_color_array_name)

    vertex_label_array_name = traits.String('VertexDegree', enter_set=True, auto_set=False, desc=\
        r"""
        The array to use for vertex labeling.  Default is "vertex_degree".
        """
    )

    def _vertex_label_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVertexLabelArrayName,
                        self.vertex_label_array_name)

    vertex_label_font_size = traits.Int(12, enter_set=True, auto_set=False, desc=\
        r"""
        The size of the font used for vertex labeling
        """
    )

    def _vertex_label_font_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVertexLabelFontSize,
                        self.vertex_label_font_size)

    vertex_scalar_bar_visibility = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        Whether the scalar bar for vertices is visible.  Default is off.
        """
    )

    def _vertex_scalar_bar_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVertexScalarBarVisibility,
                        self.vertex_scalar_bar_visibility)

    def _get_edge_layout_strategy_name(self):
        return self._vtk_obj.GetEdgeLayoutStrategyName()
    edge_layout_strategy_name = traits.Property(_get_edge_layout_strategy_name, desc=\
        r"""
        
        """
    )

    def _get_layout_strategy_name(self):
        return self._vtk_obj.GetLayoutStrategyName()
    layout_strategy_name = traits.Property(_get_layout_strategy_name, desc=\
        r"""
        
        """
    )

    def add_icon_type(self, *args):
        """
        add_icon_type(self, type:str, index:int) -> None
        C++: void add_icon_type(const char *type, int index)
        Associate the icon at index "index" in the Texture to all
        vertices containing "type" as a value in the vertex attribute
        array specified by icon_array_name.
        """
        ret = self._wrap_call(self._vtk_obj.AddIconType, *args)
        return ret

    def clear_icon_types(self):
        """
        clear_icon_types(self) -> None
        C++: void clear_icon_types()
        Clear all icon mappings.
        """
        ret = self._vtk_obj.ClearIconTypes()
        return ret
        

    def is_layout_complete(self):
        """
        is_layout_complete(self) -> int
        C++: virtual int is_layout_complete()
        Is the graph layout complete? This method is useful for when the
        strategy is iterative and the application wants to show the
        iterative progress of the graph layout See Also: update_layout();
        """
        ret = self._vtk_obj.IsLayoutComplete()
        return ret
        

    def set_icon_alignment(self, *args):
        """
        set_icon_alignment(self, alignment:int) -> None
        C++: void set_icon_alignment(int alignment)
        Specify where the icons should be placed in relation to the
        vertex. See IconGlyphFilter.h for possible values.
        """
        ret = self._wrap_call(self._vtk_obj.SetIconAlignment, *args)
        return ret

    def update_layout(self):
        """
        update_layout(self) -> None
        C++: virtual void update_layout()
        This method is useful for when the strategy is iterative and the
        application wants to show the iterative progress of the graph
        layout. The application would have something like
        while(!is_layout_complete()) { update_layout(); } See Also:
        is_layout_complete();
        """
        ret = self._vtk_obj.UpdateLayout()
        return ret
        

    def zoom_to_selection(self):
        """
        zoom_to_selection(self) -> None
        C++: void zoom_to_selection()
        Reset the camera based on the bounds of the selected region.
        """
        ret = self._vtk_obj.ZoomToSelection()
        return ret
        

    _updateable_traits_ = \
    (('color_edges', 'GetColorEdges'), ('color_vertices',
    'GetColorVertices'), ('edge_label_visibility',
    'GetEdgeLabelVisibility'), ('edge_selection', 'GetEdgeSelection'),
    ('edge_visibility', 'GetEdgeVisibility'),
    ('hide_edge_labels_on_interaction', 'GetHideEdgeLabelsOnInteraction'),
    ('hide_vertex_labels_on_interaction',
    'GetHideVertexLabelsOnInteraction'), ('icon_visibility',
    'GetIconVisibility'), ('scaled_glyphs', 'GetScaledGlyphs'),
    ('vertex_label_visibility', 'GetVertexLabelVisibility'),
    ('display_hover_text', 'GetDisplayHoverText'),
    ('render_on_mouse_move', 'GetRenderOnMouseMove'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('label_placement_mode', 'GetLabelPlacementMode'),
    ('label_render_mode', 'GetLabelRenderMode'), ('selection_mode',
    'GetSelectionMode'), ('edge_color_array_name',
    'GetEdgeColorArrayName'), ('edge_label_array_name',
    'GetEdgeLabelArrayName'), ('edge_label_font_size',
    'GetEdgeLabelFontSize'), ('edge_scalar_bar_visibility',
    'GetEdgeScalarBarVisibility'), ('enable_edges_by_array',
    'GetEnableEdgesByArray'), ('enable_vertices_by_array',
    'GetEnableVerticesByArray'), ('enabled_edges_array_name',
    'GetEnabledEdgesArrayName'), ('enabled_vertices_array_name',
    'GetEnabledVerticesArrayName'), ('glyph_type', 'GetGlyphType'),
    ('icon_array_name', 'GetIconArrayName'), ('scaling_array_name',
    'GetScalingArrayName'), ('vertex_color_array_name',
    'GetVertexColorArrayName'), ('vertex_label_array_name',
    'GetVertexLabelArrayName'), ('vertex_label_font_size',
    'GetVertexLabelFontSize'), ('vertex_scalar_bar_visibility',
    'GetVertexScalarBarVisibility'), ('icon_size', 'GetIconSize'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['color_edges', 'color_vertices', 'debug', 'display_hover_text',
    'edge_label_visibility', 'edge_selection', 'edge_visibility',
    'global_warning_display', 'hide_edge_labels_on_interaction',
    'hide_vertex_labels_on_interaction', 'icon_visibility',
    'render_on_mouse_move', 'scaled_glyphs', 'vertex_label_visibility',
    'label_placement_mode', 'label_render_mode', 'selection_mode',
    'edge_color_array_name', 'edge_label_array_name',
    'edge_label_font_size', 'edge_scalar_bar_visibility',
    'enable_edges_by_array', 'enable_vertices_by_array',
    'enabled_edges_array_name', 'enabled_vertices_array_name',
    'glyph_type', 'icon_array_name', 'icon_size', 'object_name',
    'scaling_array_name', 'vertex_color_array_name',
    'vertex_label_array_name', 'vertex_label_font_size',
    'vertex_scalar_bar_visibility'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GraphLayoutView, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GraphLayoutView properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['color_edges', 'color_vertices', 'display_hover_text',
            'edge_label_visibility', 'edge_selection', 'edge_visibility',
            'hide_edge_labels_on_interaction',
            'hide_vertex_labels_on_interaction', 'icon_visibility',
            'render_on_mouse_move', 'scaled_glyphs', 'vertex_label_visibility'],
            ['label_placement_mode', 'label_render_mode', 'selection_mode'],
            ['edge_color_array_name', 'edge_label_array_name',
            'edge_label_font_size', 'edge_scalar_bar_visibility',
            'enable_edges_by_array', 'enable_vertices_by_array',
            'enabled_edges_array_name', 'enabled_vertices_array_name',
            'glyph_type', 'icon_array_name', 'icon_size', 'object_name',
            'scaling_array_name', 'vertex_color_array_name',
            'vertex_label_array_name', 'vertex_label_font_size',
            'vertex_scalar_bar_visibility']),
            title='Edit GraphLayoutView properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GraphLayoutView properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

