/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.h2.command.Command;
import org.h2.command.Parser;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.FunctionCall;
import org.h2.expression.FunctionInfo;
import org.h2.expression.SequenceValue;
import org.h2.expression.TableFunction;
import org.h2.expression.ValueExpression;
import org.h2.expression.Variable;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.security.BlockCipher;
import org.h2.security.CipherFactory;
import org.h2.security.SHA256;
import org.h2.store.fs.FileUtils;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.LinkSchema;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.tools.CompressTool;
import org.h2.tools.Csv;
import org.h2.util.DateTimeFunctions;
import org.h2.util.DateTimeUtils;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.ToChar;
import org.h2.util.ToDateParser;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueUuid;

public class Function
extends Expression
implements FunctionCall {
    public static final int ABS = 0;
    public static final int ACOS = 1;
    public static final int ASIN = 2;
    public static final int ATAN = 3;
    public static final int ATAN2 = 4;
    public static final int BITAND = 5;
    public static final int BITOR = 6;
    public static final int BITXOR = 7;
    public static final int CEILING = 8;
    public static final int COS = 9;
    public static final int COT = 10;
    public static final int DEGREES = 11;
    public static final int EXP = 12;
    public static final int FLOOR = 13;
    public static final int LOG = 14;
    public static final int LOG10 = 15;
    public static final int MOD = 16;
    public static final int PI = 17;
    public static final int POWER = 18;
    public static final int RADIANS = 19;
    public static final int RAND = 20;
    public static final int ROUND = 21;
    public static final int ROUNDMAGIC = 22;
    public static final int SIGN = 23;
    public static final int SIN = 24;
    public static final int SQRT = 25;
    public static final int TAN = 26;
    public static final int TRUNCATE = 27;
    public static final int SECURE_RAND = 28;
    public static final int HASH = 29;
    public static final int ENCRYPT = 30;
    public static final int DECRYPT = 31;
    public static final int COMPRESS = 32;
    public static final int EXPAND = 33;
    public static final int ZERO = 34;
    public static final int RANDOM_UUID = 35;
    public static final int COSH = 36;
    public static final int SINH = 37;
    public static final int TANH = 38;
    public static final int LN = 39;
    public static final int BITGET = 40;
    public static final int ASCII = 50;
    public static final int BIT_LENGTH = 51;
    public static final int CHAR = 52;
    public static final int CHAR_LENGTH = 53;
    public static final int CONCAT = 54;
    public static final int DIFFERENCE = 55;
    public static final int HEXTORAW = 56;
    public static final int INSERT = 57;
    public static final int INSTR = 58;
    public static final int LCASE = 59;
    public static final int LEFT = 60;
    public static final int LENGTH = 61;
    public static final int LOCATE = 62;
    public static final int LTRIM = 63;
    public static final int OCTET_LENGTH = 64;
    public static final int RAWTOHEX = 65;
    public static final int REPEAT = 66;
    public static final int REPLACE = 67;
    public static final int RIGHT = 68;
    public static final int RTRIM = 69;
    public static final int SOUNDEX = 70;
    public static final int SPACE = 71;
    public static final int SUBSTR = 72;
    public static final int SUBSTRING = 73;
    public static final int UCASE = 74;
    public static final int LOWER = 75;
    public static final int UPPER = 76;
    public static final int POSITION = 77;
    public static final int TRIM = 78;
    public static final int STRINGENCODE = 79;
    public static final int STRINGDECODE = 80;
    public static final int STRINGTOUTF8 = 81;
    public static final int UTF8TOSTRING = 82;
    public static final int XMLATTR = 83;
    public static final int XMLNODE = 84;
    public static final int XMLCOMMENT = 85;
    public static final int XMLCDATA = 86;
    public static final int XMLSTARTDOC = 87;
    public static final int XMLTEXT = 88;
    public static final int REGEXP_REPLACE = 89;
    public static final int RPAD = 90;
    public static final int LPAD = 91;
    public static final int CONCAT_WS = 92;
    public static final int TO_CHAR = 93;
    public static final int TRANSLATE = 94;
    public static final int ORA_HASH = 95;
    public static final int TO_DATE = 96;
    public static final int TO_TIMESTAMP = 97;
    public static final int ADD_MONTHS = 98;
    public static final int TO_TIMESTAMP_TZ = 99;
    public static final int CURDATE = 100;
    public static final int CURTIME = 101;
    public static final int DATE_ADD = 102;
    public static final int DATE_DIFF = 103;
    public static final int DAY_NAME = 104;
    public static final int DAY_OF_MONTH = 105;
    public static final int DAY_OF_WEEK = 106;
    public static final int DAY_OF_YEAR = 107;
    public static final int HOUR = 108;
    public static final int MINUTE = 109;
    public static final int MONTH = 110;
    public static final int MONTH_NAME = 111;
    public static final int NOW = 112;
    public static final int QUARTER = 113;
    public static final int SECOND = 114;
    public static final int WEEK = 115;
    public static final int YEAR = 116;
    public static final int CURRENT_DATE = 117;
    public static final int CURRENT_TIME = 118;
    public static final int CURRENT_TIMESTAMP = 119;
    public static final int EXTRACT = 120;
    public static final int FORMATDATETIME = 121;
    public static final int PARSEDATETIME = 122;
    public static final int ISO_YEAR = 123;
    public static final int ISO_WEEK = 124;
    public static final int ISO_DAY_OF_WEEK = 125;
    public static final int DATE_TRUNC = 132;
    public static final int MILLISECOND = 126;
    public static final int EPOCH = 127;
    public static final int MICROSECOND = 128;
    public static final int NANOSECOND = 129;
    public static final int TIMEZONE_HOUR = 130;
    public static final int TIMEZONE_MINUTE = 131;
    public static final int DECADE = 132;
    public static final int CENTURY = 133;
    public static final int MILLENNIUM = 134;
    public static final int DATABASE = 150;
    public static final int USER = 151;
    public static final int CURRENT_USER = 152;
    public static final int IDENTITY = 153;
    public static final int SCOPE_IDENTITY = 154;
    public static final int AUTOCOMMIT = 155;
    public static final int READONLY = 156;
    public static final int DATABASE_PATH = 157;
    public static final int LOCK_TIMEOUT = 158;
    public static final int DISK_SPACE_USED = 159;
    public static final int SIGNAL = 160;
    private static final Pattern SIGNAL_PATTERN = Pattern.compile("[0-9A-Z]{5}");
    public static final int IFNULL = 200;
    public static final int CASEWHEN = 201;
    public static final int CONVERT = 202;
    public static final int CAST = 203;
    public static final int COALESCE = 204;
    public static final int NULLIF = 205;
    public static final int CASE = 206;
    public static final int NEXTVAL = 207;
    public static final int CURRVAL = 208;
    public static final int ARRAY_GET = 209;
    public static final int CSVREAD = 210;
    public static final int CSVWRITE = 211;
    public static final int MEMORY_FREE = 212;
    public static final int MEMORY_USED = 213;
    public static final int LOCK_MODE = 214;
    public static final int SCHEMA = 215;
    public static final int SESSION_ID = 216;
    public static final int ARRAY_LENGTH = 217;
    public static final int LINK_SCHEMA = 218;
    public static final int GREATEST = 219;
    public static final int LEAST = 220;
    public static final int CANCEL_SESSION = 221;
    public static final int SET = 222;
    public static final int TABLE = 223;
    public static final int TABLE_DISTINCT = 224;
    public static final int FILE_READ = 225;
    public static final int TRANSACTION_ID = 226;
    public static final int TRUNCATE_VALUE = 227;
    public static final int NVL2 = 228;
    public static final int DECODE = 229;
    public static final int ARRAY_CONTAINS = 230;
    public static final int FILE_WRITE = 232;
    public static final int REGEXP_LIKE = 240;
    public static final int VALUES = 250;
    public static final int H2VERSION = 231;
    public static final int ROW_NUMBER = 300;
    private static final int VAR_ARGS = -1;
    private static final long PRECISION_UNKNOWN = -1L;
    private static final HashMap<String, FunctionInfo> FUNCTIONS = new HashMap();
    private static final char[] SOUNDEX_INDEX = new char[128];
    protected Expression[] args;
    private final FunctionInfo info;
    private ArrayList<Expression> varArgs;
    private int dataType;
    private int scale;
    private long precision = -1L;
    private int displaySize;
    private final Database database;

    protected Function(Database database, FunctionInfo functionInfo) {
        this.database = database;
        this.info = functionInfo;
        if (functionInfo.parameterCount == -1) {
            this.varArgs = New.arrayList();
        } else {
            this.args = new Expression[functionInfo.parameterCount];
        }
    }

    private static void addFunction(String string, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        FunctionInfo functionInfo = new FunctionInfo();
        functionInfo.name = string;
        functionInfo.type = n;
        functionInfo.parameterCount = n2;
        functionInfo.returnDataType = n3;
        functionInfo.nullIfParameterIsNull = bl;
        functionInfo.deterministic = bl2;
        functionInfo.bufferResultSetToLocalTemp = bl3;
        FUNCTIONS.put(string, functionInfo);
    }

    private static void addFunctionNotDeterministic(String string, int n, int n2, int n3) {
        Function.addFunction(string, n, n2, n3, true, false, true);
    }

    private static void addFunction(String string, int n, int n2, int n3) {
        Function.addFunction(string, n, n2, n3, true, true, true);
    }

    private static void addFunctionWithNull(String string, int n, int n2, int n3) {
        Function.addFunction(string, n, n2, n3, false, true, true);
    }

    private static FunctionInfo getFunctionInfo(String string) {
        return FUNCTIONS.get(string);
    }

    public static Function getFunction(Database database, String string) {
        FunctionInfo functionInfo;
        if (!database.getSettings().databaseToUpper) {
            string = StringUtils.toUpperEnglish(string);
        }
        if ((functionInfo = Function.getFunctionInfo(string)) == null) {
            return null;
        }
        switch (functionInfo.type) {
            case 223: 
            case 224: {
                return new TableFunction(database, functionInfo, Long.MAX_VALUE);
            }
        }
        return new Function(database, functionInfo);
    }

    public void setParameter(int n, Expression expression) {
        if (this.varArgs != null) {
            this.varArgs.add(expression);
        } else {
            if (n >= this.args.length) {
                throw DbException.get(7001, this.info.name, "" + this.args.length);
            }
            this.args[n] = expression;
        }
    }

    @Override
    public Value getValue(Session session) {
        return this.getValueWithArgs(session, this.args);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private Value getSimpleValue(Session session, Value value, Expression[] expressionArray, Value[] valueArray) {
        Expression expression;
        void var5_107;
        block117: {
            int n;
            int n2;
            switch (this.info.type) {
                case 0: {
                    Value value2 = value.getSignum() >= 0 ? value : value.negate();
                    return var5_107;
                }
                case 1: {
                    ValueDouble valueDouble = ValueDouble.get(Math.acos(value.getDouble()));
                    return var5_107;
                }
                case 2: {
                    ValueDouble valueDouble = ValueDouble.get(Math.asin(value.getDouble()));
                    return var5_107;
                }
                case 3: {
                    ValueDouble valueDouble = ValueDouble.get(Math.atan(value.getDouble()));
                    return var5_107;
                }
                case 8: {
                    ValueDouble valueDouble = ValueDouble.get(Math.ceil(value.getDouble()));
                    return var5_107;
                }
                case 9: {
                    ValueDouble valueDouble = ValueDouble.get(Math.cos(value.getDouble()));
                    return var5_107;
                }
                case 36: {
                    ValueDouble valueDouble = ValueDouble.get(Math.cosh(value.getDouble()));
                    return var5_107;
                }
                case 10: {
                    double d = Math.tan(value.getDouble());
                    if (d == 0.0) {
                        throw DbException.get(22012, this.getSQL());
                    }
                    ValueDouble valueDouble = ValueDouble.get(1.0 / d);
                    return var5_107;
                }
                case 11: {
                    ValueDouble valueDouble = ValueDouble.get(Math.toDegrees(value.getDouble()));
                    return var5_107;
                }
                case 12: {
                    ValueDouble valueDouble = ValueDouble.get(Math.exp(value.getDouble()));
                    return var5_107;
                }
                case 13: {
                    ValueDouble valueDouble = ValueDouble.get(Math.floor(value.getDouble()));
                    return var5_107;
                }
                case 39: {
                    ValueDouble valueDouble = ValueDouble.get(Math.log(value.getDouble()));
                    return var5_107;
                }
                case 14: {
                    if (this.database.getMode().logIsLogBase10) {
                        ValueDouble valueDouble = ValueDouble.get(Math.log10(value.getDouble()));
                        return var5_107;
                    }
                    ValueDouble valueDouble = ValueDouble.get(Math.log(value.getDouble()));
                    return var5_107;
                }
                case 15: {
                    ValueDouble valueDouble = ValueDouble.get(Math.log10(value.getDouble()));
                    return var5_107;
                }
                case 17: {
                    ValueDouble valueDouble = ValueDouble.get(Math.PI);
                    return var5_107;
                }
                case 19: {
                    ValueDouble valueDouble = ValueDouble.get(Math.toRadians(value.getDouble()));
                    return var5_107;
                }
                case 20: {
                    if (value != null) {
                        session.getRandom().setSeed(value.getInt());
                    }
                    ValueDouble valueDouble = ValueDouble.get(session.getRandom().nextDouble());
                    return var5_107;
                }
                case 22: {
                    ValueDouble valueDouble = ValueDouble.get(Function.roundMagic(value.getDouble()));
                    return var5_107;
                }
                case 23: {
                    ValueInt valueInt = ValueInt.get(value.getSignum());
                    return var5_107;
                }
                case 24: {
                    ValueDouble valueDouble = ValueDouble.get(Math.sin(value.getDouble()));
                    return var5_107;
                }
                case 37: {
                    ValueDouble valueDouble = ValueDouble.get(Math.sinh(value.getDouble()));
                    return var5_107;
                }
                case 25: {
                    ValueDouble valueDouble = ValueDouble.get(Math.sqrt(value.getDouble()));
                    return var5_107;
                }
                case 26: {
                    ValueDouble valueDouble = ValueDouble.get(Math.tan(value.getDouble()));
                    return var5_107;
                }
                case 38: {
                    ValueDouble valueDouble = ValueDouble.get(Math.tanh(value.getDouble()));
                    return var5_107;
                }
                case 28: {
                    ValueBytes valueBytes = ValueBytes.getNoCopy(MathUtils.secureRandomBytes(value.getInt()));
                    return var5_107;
                }
                case 33: {
                    ValueBytes valueBytes = ValueBytes.getNoCopy(CompressTool.getInstance().expand(value.getBytesNoCopy()));
                    return var5_107;
                }
                case 34: {
                    ValueInt valueInt = ValueInt.get(0);
                    return var5_107;
                }
                case 35: {
                    ValueUuid valueUuid = ValueUuid.getNewRandom();
                    return var5_107;
                }
                case 50: {
                    String string = value.getString();
                    if (string.length() == 0) {
                        ValueNull valueNull = ValueNull.INSTANCE;
                        return var5_107;
                    }
                    ValueInt valueInt = ValueInt.get(string.charAt(0));
                    return var5_107;
                }
                case 51: {
                    ValueLong valueLong = ValueLong.get(16L * Function.length(value));
                    return var5_107;
                }
                case 52: {
                    Value value3 = ValueString.get(String.valueOf((char)value.getInt()), this.database.getMode().treatEmptyStringsAsNull);
                    return var5_107;
                }
                case 53: 
                case 61: {
                    ValueLong valueLong = ValueLong.get(Function.length(value));
                    return var5_107;
                }
                case 64: {
                    ValueLong valueLong = ValueLong.get(2L * Function.length(value));
                    return var5_107;
                }
                case 54: 
                case 92: {
                    ValueNull valueNull = ValueNull.INSTANCE;
                    int n3 = 0;
                    String string = "";
                    if (this.info.type == 92) {
                        n3 = 1;
                        string = Function.getNullOrValue(session, expressionArray, valueArray, 0).getString();
                    }
                    int n4 = n3;
                    while (true) {
                        void var5_41;
                        if (n4 >= expressionArray.length) {
                            if (this.info.type != 92) return var5_107;
                            if (string == null) return var5_107;
                            if (var5_41 != ValueNull.INSTANCE) return var5_107;
                            Value value4 = ValueString.get("", this.database.getMode().treatEmptyStringsAsNull);
                            return var5_107;
                        }
                        Value value5 = Function.getNullOrValue(session, expressionArray, valueArray, n4);
                        if (value5 != ValueNull.INSTANCE) {
                            if (var5_41 == ValueNull.INSTANCE) {
                                Value value6 = value5;
                            } else {
                                Object object = value5.getString();
                                if (!StringUtils.isNullOrEmpty(string) && !StringUtils.isNullOrEmpty((String)object)) {
                                    object = string + (String)object;
                                }
                                Value value7 = ValueString.get(var5_41.getString() + (String)object, this.database.getMode().treatEmptyStringsAsNull);
                            }
                        }
                        ++n4;
                    }
                }
                case 56: {
                    Value value8 = ValueString.get(Function.hexToRaw(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                    return var5_107;
                }
                case 59: 
                case 75: {
                    Value value9 = ValueString.get(value.getString().toLowerCase(), this.database.getMode().treatEmptyStringsAsNull);
                    return var5_107;
                }
                case 65: {
                    Value value10 = ValueString.get(Function.rawToHex(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                    return var5_107;
                }
                case 70: {
                    Value value11 = ValueString.get(Function.getSoundex(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                    return var5_107;
                }
                case 71: {
                    int n5 = Math.max(0, value.getInt());
                    char[] cArray = new char[n5];
                    int n6 = n5 - 1;
                    while (true) {
                        if (n6 < 0) {
                            Value value12 = ValueString.get(new String(cArray), this.database.getMode().treatEmptyStringsAsNull);
                            return var5_107;
                        }
                        cArray[n6] = 32;
                        --n6;
                    }
                }
                case 74: 
                case 76: {
                    Value value13 = ValueString.get(value.getString().toUpperCase(), this.database.getMode().treatEmptyStringsAsNull);
                    return var5_107;
                }
                case 79: {
                    Value value14 = ValueString.get(StringUtils.javaEncode(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                    return var5_107;
                }
                case 80: {
                    Value value15 = ValueString.get(StringUtils.javaDecode(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                    return var5_107;
                }
                case 81: {
                    ValueBytes valueBytes = ValueBytes.getNoCopy(value.getString().getBytes(StandardCharsets.UTF_8));
                    return var5_107;
                }
                case 82: {
                    Value value16 = ValueString.get(new String(value.getBytesNoCopy(), StandardCharsets.UTF_8), this.database.getMode().treatEmptyStringsAsNull);
                    return var5_107;
                }
                case 85: {
                    Value value17 = ValueString.get(StringUtils.xmlComment(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                    return var5_107;
                }
                case 86: {
                    Value value18 = ValueString.get(StringUtils.xmlCData(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                    return var5_107;
                }
                case 87: {
                    Value value19 = ValueString.get(StringUtils.xmlStartDoc(), this.database.getMode().treatEmptyStringsAsNull);
                    return var5_107;
                }
                case 104: {
                    int n7 = DateTimeUtils.getSundayDayOfWeek(DateTimeUtils.dateAndTimeFromValue(value)[0]);
                    Value value20 = ValueString.get(DateTimeFunctions.getMonthsAndWeeks(1)[n7], this.database.getMode().treatEmptyStringsAsNull);
                    return var5_107;
                }
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 123: 
                case 124: 
                case 125: {
                    ValueInt valueInt = ValueInt.get(DateTimeFunctions.getIntDatePart(value, this.info.type));
                    return var5_107;
                }
                case 111: {
                    int n8 = DateTimeUtils.monthFromDateValue(DateTimeUtils.dateAndTimeFromValue(value)[0]);
                    Value value21 = ValueString.get(DateTimeFunctions.getMonthsAndWeeks(0)[n8 - 1], this.database.getMode().treatEmptyStringsAsNull);
                    return var5_107;
                }
                case 100: 
                case 117: {
                    long l = session.getTransactionStart();
                    ValueDate valueDate = ValueDate.fromMillis(l);
                    return var5_107;
                }
                case 101: 
                case 118: {
                    long l = session.getTransactionStart();
                    ValueTime valueTime = ValueTime.fromMillis(l);
                    return var5_107;
                }
                case 112: 
                case 119: {
                    long l = session.getTransactionStart();
                    ValueTimestamp valueTimestamp = ValueTimestamp.fromMillis(l);
                    if (value != null) {
                        Mode mode = this.database.getMode();
                        valueTimestamp = (ValueTimestamp)valueTimestamp.convertScale(mode.convertOnlyToSmallerScale, value.getInt());
                    }
                    ValueTimestamp valueTimestamp2 = valueTimestamp;
                    return var5_107;
                }
                case 150: {
                    Value value22 = ValueString.get(this.database.getShortName(), this.database.getMode().treatEmptyStringsAsNull);
                    return var5_107;
                }
                case 151: 
                case 152: {
                    Value value23 = ValueString.get(session.getUser().getName(), this.database.getMode().treatEmptyStringsAsNull);
                    return var5_107;
                }
                case 153: {
                    Value value24 = session.getLastIdentity();
                    return var5_107;
                }
                case 154: {
                    Value value25 = session.getLastScopeIdentity();
                    return var5_107;
                }
                case 155: {
                    ValueBoolean valueBoolean = ValueBoolean.get(session.getAutoCommit());
                    return var5_107;
                }
                case 156: {
                    ValueBoolean valueBoolean = ValueBoolean.get(this.database.isReadOnly());
                    return var5_107;
                }
                case 157: {
                    String string = this.database.getDatabasePath();
                    ValueNull valueNull = string == null ? ValueNull.INSTANCE : ValueString.get(string, this.database.getMode().treatEmptyStringsAsNull);
                    return var5_107;
                }
                case 158: {
                    ValueInt valueInt = ValueInt.get(session.getLockTimeout());
                    return var5_107;
                }
                case 159: {
                    ValueLong valueLong = ValueLong.get(Function.getDiskSpaceUsed(session, value));
                    return var5_107;
                }
                case 202: 
                case 203: {
                    value = value.convertTo(this.dataType);
                    Mode mode = this.database.getMode();
                    value = value.convertScale(mode.convertOnlyToSmallerScale, this.scale);
                    Value value26 = value = value.convertPrecision(this.getPrecision(), false);
                    return var5_107;
                }
                case 212: {
                    session.getUser().checkAdmin();
                    ValueInt valueInt = ValueInt.get(Utils.getMemoryFree());
                    return var5_107;
                }
                case 213: {
                    session.getUser().checkAdmin();
                    ValueInt valueInt = ValueInt.get(Utils.getMemoryUsed());
                    return var5_107;
                }
                case 214: {
                    ValueInt valueInt = ValueInt.get(this.database.getLockMode());
                    return var5_107;
                }
                case 215: {
                    Value value27 = ValueString.get(session.getCurrentSchemaName(), this.database.getMode().treatEmptyStringsAsNull);
                    return var5_107;
                }
                case 216: {
                    ValueInt valueInt = ValueInt.get(session.getId());
                    return var5_107;
                }
                case 200: {
                    void var5_81;
                    Value value28 = value;
                    if (value == ValueNull.INSTANCE) {
                        Value value29 = Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    }
                    Value value30 = this.convertResult((Value)var5_81);
                    return var5_107;
                }
                case 201: {
                    Value value31 = !value.getBoolean() ? Function.getNullOrValue(session, expressionArray, valueArray, 2) : Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    Value value32 = value31.convertTo(this.dataType);
                    return var5_107;
                }
                case 229: {
                    int n9 = -1;
                    int n10 = expressionArray.length - 1;
                    for (int i = 1; i < n10; i += 2) {
                        if (!this.database.areEqual(value, Function.getNullOrValue(session, expressionArray, valueArray, i))) continue;
                        n9 = i + 1;
                        break;
                    }
                    if (n9 < 0 && expressionArray.length % 2 == 0) {
                        n9 = expressionArray.length - 1;
                    }
                    ValueNull valueNull = n9 < 0 ? ValueNull.INSTANCE : Function.getNullOrValue(session, expressionArray, valueArray, n9);
                    Value value33 = valueNull.convertTo(this.dataType);
                    return var5_107;
                }
                case 228: {
                    Value value34 = value == ValueNull.INSTANCE ? Function.getNullOrValue(session, expressionArray, valueArray, 2) : Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    Value value35 = value34.convertTo(this.dataType);
                    return var5_107;
                }
                case 204: {
                    Value value36 = value;
                    int n11 = 0;
                    while (n11 < expressionArray.length) {
                        Value value37 = Function.getNullOrValue(session, expressionArray, valueArray, n11);
                        if (value37 != ValueNull.INSTANCE) {
                            Value value38 = value37.convertTo(this.dataType);
                            return var5_107;
                        }
                        ++n11;
                    }
                    return var5_107;
                }
                case 219: 
                case 220: {
                    ValueNull valueNull = ValueNull.INSTANCE;
                    int n12 = 0;
                    while (n12 < expressionArray.length) {
                        Value value39 = Function.getNullOrValue(session, expressionArray, valueArray, n12);
                        if (value39 != ValueNull.INSTANCE) {
                            void var5_90;
                            value39 = value39.convertTo(this.dataType);
                            if (var5_90 == ValueNull.INSTANCE) {
                                Value value40 = value39;
                            } else {
                                int n13 = this.database.compareTypeSafe((Value)var5_90, value39);
                                if (this.info.type == 219 && n13 < 0) {
                                    Value value41 = value39;
                                } else if (this.info.type == 220 && n13 > 0) {
                                    Value value42 = value39;
                                }
                            }
                        }
                        ++n12;
                    }
                    return var5_107;
                }
                case 206: {
                    expression = null;
                    if (value == null) {
                        n2 = expressionArray.length - 1;
                        break;
                    }
                    if (value == ValueNull.INSTANCE) break block117;
                    int n14 = expressionArray.length - 1;
                    for (n = 1; n < n14; n += 2) {
                        Value value43 = expressionArray[n].getValue(session);
                        if (!this.database.areEqual(value, value43)) continue;
                        expression = expressionArray[n + 1];
                        break block117;
                    }
                    break block117;
                }
                case 209: {
                    if (value.getType() != 17) {
                        ValueNull valueNull = ValueNull.INSTANCE;
                        return var5_107;
                    }
                    Value value44 = Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    int n15 = value44.getInt();
                    Value[] valueArray2 = ((ValueArray)value).getList();
                    if (n15 >= 1 && n15 <= valueArray2.length) {
                        Value value45 = valueArray2[n15 - 1];
                        return var5_107;
                    }
                    ValueNull valueNull = ValueNull.INSTANCE;
                    return var5_107;
                }
                case 217: {
                    if (value.getType() == 17) {
                        Value[] valueArray3 = ((ValueArray)value).getList();
                        ValueInt valueInt = ValueInt.get(valueArray3.length);
                        return var5_107;
                    }
                    ValueNull valueNull = ValueNull.INSTANCE;
                    return var5_107;
                }
                case 230: {
                    Value[] valueArray4;
                    ValueBoolean valueBoolean = ValueBoolean.FALSE;
                    if (value.getType() != 17) return var5_107;
                    Value value46 = Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    Value[] valueArray5 = valueArray4 = ((ValueArray)value).getList();
                    int n16 = valueArray5.length;
                    int n17 = 0;
                    while (n17 < n16) {
                        Value value47 = valueArray5[n17];
                        if (value47.equals(value46)) {
                            ValueBoolean valueBoolean2 = ValueBoolean.TRUE;
                            return var5_107;
                        }
                        ++n17;
                    }
                    return var5_107;
                }
                case 221: {
                    ValueBoolean valueBoolean = ValueBoolean.get(Function.cancelStatement(session, value.getInt()));
                    return var5_107;
                }
                case 226: {
                    Value value48 = session.getTransactionId();
                    return var5_107;
                }
                default: {
                    return var5_107;
                }
            }
            for (n = 1; n < n2; n += 2) {
                Value value49 = expressionArray[n].getValue(session);
                if (!value49.getBoolean()) continue;
                expression = expressionArray[n + 1];
                break;
            }
        }
        if (expression == null && expressionArray.length % 2 == 0) {
            expression = expressionArray[expressionArray.length - 1];
        }
        ValueNull valueNull = expression == null ? ValueNull.INSTANCE : expression.getValue(session);
        Value value50 = valueNull.convertTo(this.dataType);
        return var5_107;
    }

    private Value convertResult(Value value) {
        return value.convertTo(this.dataType);
    }

    private static boolean cancelStatement(Session session, int n) {
        Session[] sessionArray;
        session.getUser().checkAdmin();
        for (Session session2 : sessionArray = session.getDatabase().getSessions(false)) {
            if (session2.getId() != n) continue;
            Command command = session2.getCurrentCommand();
            if (command == null) {
                return false;
            }
            command.cancel();
            return true;
        }
        return false;
    }

    private static long getDiskSpaceUsed(Session session, Value value) {
        Parser parser = new Parser(session);
        String string = value.getString();
        Table table = parser.parseTableName(string);
        return table.getDiskSpaceUsed();
    }

    private static Value getNullOrValue(Session session, Expression[] expressionArray, Value[] valueArray, int n) {
        if (n >= expressionArray.length) {
            return null;
        }
        Value value = valueArray[n];
        if (value == null) {
            Expression expression = expressionArray[n];
            if (expression == null) {
                return null;
            }
            value = valueArray[n] = expression.getValue(session);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value getValueWithArgs(Session session, Expression[] expressionArray) {
        Value value;
        Value value2;
        Value value3;
        Object object;
        Value[] valueArray = new Value[expressionArray.length];
        if (this.info.nullIfParameterIsNull) {
            for (int i = 0; i < expressionArray.length; ++i) {
                object = expressionArray[i];
                value3 = ((Expression)object).getValue(session);
                if (value3 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                valueArray[i] = value3;
            }
        }
        if ((object = this.getSimpleValue(session, value2 = Function.getNullOrValue(session, expressionArray, valueArray, 0), expressionArray, valueArray)) != null) {
            return object;
        }
        value3 = Function.getNullOrValue(session, expressionArray, valueArray, 1);
        Value value4 = Function.getNullOrValue(session, expressionArray, valueArray, 2);
        Value value5 = Function.getNullOrValue(session, expressionArray, valueArray, 3);
        Value value6 = Function.getNullOrValue(session, expressionArray, valueArray, 4);
        Value value7 = Function.getNullOrValue(session, expressionArray, valueArray, 5);
        block9 : switch (this.info.type) {
            case 4: {
                value = ValueDouble.get(Math.atan2(value2.getDouble(), value3.getDouble()));
                break;
            }
            case 5: {
                value = ValueLong.get(value2.getLong() & value3.getLong());
                break;
            }
            case 40: {
                value = ValueBoolean.get((value2.getLong() & 1L << value3.getInt()) != 0L);
                break;
            }
            case 6: {
                value = ValueLong.get(value2.getLong() | value3.getLong());
                break;
            }
            case 7: {
                value = ValueLong.get(value2.getLong() ^ value3.getLong());
                break;
            }
            case 16: {
                long l = value3.getLong();
                if (l == 0L) {
                    throw DbException.get(22012, this.getSQL());
                }
                value = ValueLong.get(value2.getLong() % l);
                break;
            }
            case 18: {
                value = ValueDouble.get(Math.pow(value2.getDouble(), value3.getDouble()));
                break;
            }
            case 21: {
                double d = value3 == null ? 1.0 : Math.pow(10.0, value3.getDouble());
                double d2 = value2.getDouble() * d;
                int n = d2 > 0.0 ? 1 : -1;
                value = ValueDouble.get((double)Math.round(Math.abs(d2)) / d * (double)n);
                break;
            }
            case 27: {
                if (value2.getType() == 11) {
                    value = ValueTimestamp.fromDateValueAndNanos(((ValueTimestamp)value2).getDateValue(), 0L);
                    break;
                }
                if (value2.getType() == 10) {
                    value = ValueTimestamp.fromDateValueAndNanos(((ValueDate)value2).getDateValue(), 0L);
                    break;
                }
                if (value2.getType() == 24) {
                    ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value2;
                    value = ValueTimestampTimeZone.fromDateValueAndNanos(valueTimestampTimeZone.getDateValue(), 0L, valueTimestampTimeZone.getTimeZoneOffsetMins());
                    break;
                }
                if (value2.getType() == 13) {
                    ValueTimestamp valueTimestamp = ValueTimestamp.parse(value2.getString(), session.getDatabase().getMode());
                    value = ValueTimestamp.fromDateValueAndNanos(valueTimestamp.getDateValue(), 0L);
                    break;
                }
                double d = value2.getDouble();
                int n = value3 == null ? 0 : value3.getInt();
                double d3 = Math.pow(10.0, n);
                double d4 = d * d3;
                value = ValueDouble.get((d < 0.0 ? Math.ceil(d4) : Math.floor(d4)) / d3);
                break;
            }
            case 29: {
                value = ValueBytes.getNoCopy(Function.getHash(value2.getString(), value3.getBytesNoCopy(), value4.getInt()));
                break;
            }
            case 30: {
                value = ValueBytes.getNoCopy(Function.encrypt(value2.getString(), value3.getBytesNoCopy(), value4.getBytesNoCopy()));
                break;
            }
            case 31: {
                value = ValueBytes.getNoCopy(Function.decrypt(value2.getString(), value3.getBytesNoCopy(), value4.getBytesNoCopy()));
                break;
            }
            case 32: {
                String string = null;
                if (value3 != null) {
                    string = value3.getString();
                }
                value = ValueBytes.getNoCopy(CompressTool.getInstance().compress(value2.getBytesNoCopy(), string));
                break;
            }
            case 55: {
                value = ValueInt.get(Function.getDifference(value2.getString(), value3.getString()));
                break;
            }
            case 57: {
                if (value3 == ValueNull.INSTANCE || value4 == ValueNull.INSTANCE) {
                    value = value3;
                    break;
                }
                value = ValueString.get(Function.insert(value2.getString(), value3.getInt(), value4.getInt(), value5.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 60: {
                value = ValueString.get(Function.left(value2.getString(), value3.getInt()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 62: {
                int n = value4 == null ? 0 : value4.getInt();
                value = ValueInt.get(Function.locate(value2.getString(), value3.getString(), n));
                break;
            }
            case 58: {
                int n = value4 == null ? 0 : value4.getInt();
                value = ValueInt.get(Function.locate(value3.getString(), value2.getString(), n));
                break;
            }
            case 66: {
                int n = Math.max(0, value3.getInt());
                value = ValueString.get(Function.repeat(value2.getString(), n), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 67: {
                String string;
                if (value2 == ValueNull.INSTANCE || value3 == ValueNull.INSTANCE || value4 == ValueNull.INSTANCE && this.database.getMode().getEnum() != Mode.ModeEnum.Oracle) {
                    value = ValueNull.INSTANCE;
                    break;
                }
                String string2 = value2.getString();
                String string3 = value3.getString();
                String string4 = string = value4 == null ? "" : value4.getString();
                if (string == null) {
                    string = "";
                }
                value = ValueString.get(StringUtils.replaceAll(string2, string3, string), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 68: {
                value = ValueString.get(Function.right(value2.getString(), value3.getInt()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 63: {
                value = ValueString.get(StringUtils.trim(value2.getString(), true, false, value3 == null ? " " : value3.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 78: {
                value = ValueString.get(StringUtils.trim(value2.getString(), true, true, value3 == null ? " " : value3.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 69: {
                value = ValueString.get(StringUtils.trim(value2.getString(), false, true, value3 == null ? " " : value3.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 72: 
            case 73: {
                String string = value2.getString();
                int n = value3.getInt();
                if (n < 0) {
                    n = string.length() + n + 1;
                }
                int n2 = value4 == null ? string.length() : value4.getInt();
                value = ValueString.get(Function.substring(string, n, n2), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 77: {
                value = ValueInt.get(Function.locate(value2.getString(), value3.getString(), 0));
                break;
            }
            case 83: {
                value = ValueString.get(StringUtils.xmlAttr(value2.getString(), value3.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 84: {
                String string;
                String string5 = value3 == null ? null : (string = value3 == ValueNull.INSTANCE ? null : value3.getString());
                String string6 = value4 == null ? null : (value4 == ValueNull.INSTANCE ? null : value4.getString());
                boolean bl = value5 == null ? true : value5.getBoolean();
                value = ValueString.get(StringUtils.xmlNode(value2.getString(), string, string6, bl), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 89: {
                int n;
                CharSequence charSequence;
                String string = value3.getString();
                String string7 = value4.getString();
                if (this.database.getMode().regexpReplaceBackslashReferences && (string7.indexOf(92) >= 0 || string7.indexOf(36) >= 0)) {
                    charSequence = new StringBuilder();
                    for (n = 0; n < string7.length(); ++n) {
                        char c = string7.charAt(n);
                        if (c == '$') {
                            ((StringBuilder)charSequence).append('\\');
                        } else if (c == '\\' && ++n < string7.length()) {
                            c = string7.charAt(n);
                            ((StringBuilder)charSequence).append((char)(c >= '0' && c <= '9' ? 36 : 92));
                        }
                        ((StringBuilder)charSequence).append(c);
                    }
                    string7 = ((StringBuilder)charSequence).toString();
                }
                charSequence = value5 == null || value5.getString() == null ? "" : value5.getString();
                n = Function.makeRegexpFlags((String)charSequence);
                try {
                    value = ValueString.get(Pattern.compile(string, n).matcher(value2.getString()).replaceAll(string7), this.database.getMode().treatEmptyStringsAsNull);
                    break;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    throw DbException.get(22025, stringIndexOutOfBoundsException, string7);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DbException.get(22025, patternSyntaxException, string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DbException.get(22025, illegalArgumentException, string7);
                }
            }
            case 90: {
                value = ValueString.get(StringUtils.pad(value2.getString(), value3.getInt(), value4 == null ? null : value4.getString(), true), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 91: {
                value = ValueString.get(StringUtils.pad(value2.getString(), value3.getInt(), value4 == null ? null : value4.getString(), false), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 95: {
                value = ValueLong.get(Function.oraHash(value2.getString(), value3 == null ? null : Integer.valueOf(value3.getInt()), value4 == null ? null : Integer.valueOf(value4.getInt())).intValue());
                break;
            }
            case 93: {
                switch (value2.getType()) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 24: {
                        value = ValueString.get(ToChar.toCharDateTime(value2, value3 == null ? null : value3.getString(), value4 == null ? null : value4.getString()), this.database.getMode().treatEmptyStringsAsNull);
                        break block9;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        value = ValueString.get(ToChar.toChar(value2.getBigDecimal(), value3 == null ? null : value3.getString(), value4 == null ? null : value4.getString()), this.database.getMode().treatEmptyStringsAsNull);
                        break block9;
                    }
                }
                value = ValueString.get(value2.getString(), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 96: {
                value = ToDateParser.toDate(value2.getString(), value3 == null ? null : value3.getString());
                break;
            }
            case 97: {
                value = ToDateParser.toTimestamp(value2.getString(), value3 == null ? null : value3.getString());
                break;
            }
            case 98: {
                value = DateTimeFunctions.dateadd("MONTH", value3.getInt(), value2);
                break;
            }
            case 99: {
                value = ToDateParser.toTimestampTz(value2.getString(), value3 == null ? null : value3.getString());
                break;
            }
            case 94: {
                String string = value3.getString();
                String string8 = value4.getString();
                value = ValueString.get(Function.translate(value2.getString(), string, string8), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 231: {
                value = ValueString.get(Constants.getVersion(), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 102: {
                value = DateTimeFunctions.dateadd(value2.getString(), value3.getLong(), value4);
                break;
            }
            case 103: {
                value = ValueLong.get(DateTimeFunctions.datediff(value2.getString(), value3, value4));
                break;
            }
            case 132: {
                value = DateTimeFunctions.truncateDate(value2.getString(), value3);
                break;
            }
            case 120: {
                value = DateTimeFunctions.extract(value2.getString(), value3);
                break;
            }
            case 121: {
                String string;
                String string9;
                if (value2 == ValueNull.INSTANCE || value3 == ValueNull.INSTANCE) {
                    value = ValueNull.INSTANCE;
                    break;
                }
                String string10 = value4 == null ? null : (string9 = value4 == ValueNull.INSTANCE ? null : value4.getString());
                String string11 = value5 == null ? null : (string = value5 == ValueNull.INSTANCE ? null : value5.getString());
                if (value2 instanceof ValueTimestampTimeZone) {
                    string = DateTimeUtils.timeZoneNameFromOffsetMins(((ValueTimestampTimeZone)value2).getTimeZoneOffsetMins());
                }
                value = ValueString.get(DateTimeFunctions.formatDateTime(value2.getTimestamp(), value3.getString(), string9, string), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 122: {
                String string;
                if (value2 == ValueNull.INSTANCE || value3 == ValueNull.INSTANCE) {
                    value = ValueNull.INSTANCE;
                    break;
                }
                String string12 = value4 == null ? null : (string = value4 == ValueNull.INSTANCE ? null : value4.getString());
                String string13 = value5 == null ? null : (value5 == ValueNull.INSTANCE ? null : value5.getString());
                Date date = DateTimeFunctions.parseDateTime(value2.getString(), value3.getString(), string, string13);
                value = ValueTimestamp.fromMillis(date.getTime());
                break;
            }
            case 205: {
                value = this.database.areEqual(value2, value3) ? ValueNull.INSTANCE : value2;
                break;
            }
            case 207: {
                Sequence sequence = this.getSequence(session, value2, value3);
                SequenceValue sequenceValue = new SequenceValue(sequence);
                value = sequenceValue.getValue(session);
                break;
            }
            case 208: {
                Sequence sequence = this.getSequence(session, value2, value3);
                value = ValueLong.get(sequence.getCurrentValue());
                break;
            }
            case 210: {
                String[] stringArray;
                String string = value2.getString();
                String string14 = value3 == null ? null : value3.getString();
                Csv csv = new Csv();
                String string15 = value4 == null ? null : value4.getString();
                String string16 = null;
                if (string15 != null && string15.indexOf(61) >= 0) {
                    string16 = csv.setOptions(string15);
                } else {
                    string16 = string15;
                    String string17 = value5 == null ? null : value5.getString();
                    stringArray = value6 == null ? null : value6.getString();
                    String string18 = value7 == null ? null : value7.getString();
                    Value value8 = Function.getNullOrValue(session, expressionArray, valueArray, 6);
                    String string19 = value8 == null ? null : value8.getString();
                    Function.setCsvDelimiterEscape(csv, string17, (String)stringArray, string18);
                    csv.setNullString(string19);
                }
                char c = csv.getFieldSeparatorRead();
                stringArray = StringUtils.arraySplit(string14, c, true);
                try {
                    value = ValueResultSet.get(csv.read(string, stringArray, string16));
                    break;
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
            }
            case 218: {
                session.getUser().checkAdmin();
                JdbcConnection jdbcConnection = session.createConnection(false);
                ResultSet resultSet = LinkSchema.linkSchema(jdbcConnection, value2.getString(), value3.getString(), value4.getString(), value5.getString(), value6.getString(), value7.getString());
                value = ValueResultSet.get(resultSet);
                break;
            }
            case 211: {
                session.getUser().checkAdmin();
                JdbcConnection jdbcConnection = session.createConnection(false);
                Csv csv = new Csv();
                String string = value4 == null ? null : value4.getString();
                String string20 = null;
                if (string != null && string.indexOf(61) >= 0) {
                    string20 = csv.setOptions(string);
                } else {
                    string20 = string;
                    String string21 = value5 == null ? null : value5.getString();
                    String string22 = value6 == null ? null : value6.getString();
                    String string23 = value7 == null ? null : value7.getString();
                    Value value9 = Function.getNullOrValue(session, expressionArray, valueArray, 6);
                    String string24 = value9 == null ? null : value9.getString();
                    Value value10 = Function.getNullOrValue(session, expressionArray, valueArray, 7);
                    String string25 = value10 == null ? null : value10.getString();
                    Function.setCsvDelimiterEscape(csv, string21, string22, string23);
                    csv.setNullString(string24);
                    if (string25 != null) {
                        csv.setLineSeparator(string25);
                    }
                }
                try {
                    int n = csv.write(jdbcConnection, value2.getString(), value3.getString(), string20);
                    value = ValueInt.get(n);
                    break;
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
            }
            case 222: {
                Variable variable = (Variable)expressionArray[0];
                session.setVariable(variable.getName(), value3);
                value = value3;
                break;
            }
            case 225: {
                session.getUser().checkAdmin();
                String string = value2.getString();
                boolean bl = expressionArray.length == 1;
                try {
                    long l = FileUtils.size(string);
                    InputStream inputStream = FileUtils.newInputStream(string);
                    try {
                        if (bl) {
                            value = this.database.getLobStorage().createBlob(inputStream, l);
                        } else {
                            InputStreamReader inputStreamReader = value3 == ValueNull.INSTANCE ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, value3.getString());
                            value = this.database.getLobStorage().createClob(inputStreamReader, l);
                        }
                    }
                    finally {
                        IOUtils.closeSilently(inputStream);
                    }
                    session.addTemporaryLob(value);
                    break;
                }
                catch (IOException iOException) {
                    throw DbException.convertIOException(iOException, string);
                }
            }
            case 232: {
                session.getUser().checkAdmin();
                value = ValueNull.INSTANCE;
                String string = value3.getString();
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(string);
                    try (InputStream inputStream = value2.getInputStream();){
                        value = ValueLong.get(IOUtils.copyAndClose(inputStream, fileOutputStream));
                        break;
                    }
                }
                catch (IOException iOException) {
                    throw DbException.convertIOException(iOException, string);
                }
            }
            case 227: {
                value = value2.convertPrecision(value3.getLong(), value4.getBoolean());
                break;
            }
            case 88: {
                if (value3 == null) {
                    value = ValueString.get(StringUtils.xmlText(value2.getString()), this.database.getMode().treatEmptyStringsAsNull);
                    break;
                }
                value = ValueString.get(StringUtils.xmlText(value2.getString(), value3.getBoolean()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 240: {
                String string = value3.getString();
                String string26 = value4 == null || value4.getString() == null ? "" : value4.getString();
                int n = Function.makeRegexpFlags(string26);
                try {
                    value = ValueBoolean.get(Pattern.compile(string, n).matcher(value2.getString()).find());
                    break;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DbException.get(22025, patternSyntaxException, string);
                }
            }
            case 250: {
                value = session.getVariable(expressionArray[0].getSchemaName() + "." + expressionArray[0].getTableName() + "." + expressionArray[0].getColumnName());
                break;
            }
            case 160: {
                String string = value2.getString();
                if (string.startsWith("00") || !SIGNAL_PATTERN.matcher(string).matches()) {
                    throw DbException.getInvalidValueException("SQLSTATE", string);
                }
                String string27 = value3.getString();
                throw DbException.fromUser(string, string27);
            }
            default: {
                throw DbException.throwInternalError("type=" + this.info.type);
            }
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Sequence getSequence(Session session, Value value, Value value2) {
        Object object;
        String string;
        Object object2;
        Object object3;
        if (value2 == null) {
            object3 = new Parser(session);
            object2 = value.getString();
            Expression expression = ((Parser)object3).parseExpression((String)object2);
            if (!(expression instanceof ExpressionColumn)) throw DbException.getSyntaxError((String)object2, 1);
            ExpressionColumn expressionColumn = (ExpressionColumn)expression;
            string = expressionColumn.getOriginalTableAliasName();
            if (string == null) {
                string = session.getCurrentSchemaName();
                object = object2;
            } else {
                object = expressionColumn.getColumnName();
            }
        } else {
            string = value.getString();
            object = value2.getString();
        }
        if ((object3 = this.database.findSchema(string)) == null) {
            string = StringUtils.toUpperEnglish(string);
            object3 = this.database.getSchema(string);
        }
        if ((object2 = ((Schema)object3).findSequence((String)object)) != null) return object2;
        object = StringUtils.toUpperEnglish((String)object);
        return ((Schema)object3).getSequence((String)object);
    }

    private static long length(Value value) {
        switch (value.getType()) {
            case 12: 
            case 15: 
            case 16: 
            case 19: {
                return value.getPrecision();
            }
        }
        return value.getString().length();
    }

    private static byte[] getPaddedArrayCopy(byte[] byArray, int n) {
        int n2 = MathUtils.roundUpInt(byArray.length, n);
        return Utils.copyBytes(byArray, n2);
    }

    private static byte[] decrypt(String string, byte[] byArray, byte[] byArray2) {
        BlockCipher blockCipher = CipherFactory.getBlockCipher(string);
        byte[] byArray3 = Function.getPaddedArrayCopy(byArray, blockCipher.getKeyLength());
        blockCipher.setKey(byArray3);
        byte[] byArray4 = Function.getPaddedArrayCopy(byArray2, 16);
        blockCipher.decrypt(byArray4, 0, byArray4.length);
        return byArray4;
    }

    private static byte[] encrypt(String string, byte[] byArray, byte[] byArray2) {
        BlockCipher blockCipher = CipherFactory.getBlockCipher(string);
        byte[] byArray3 = Function.getPaddedArrayCopy(byArray, blockCipher.getKeyLength());
        blockCipher.setKey(byArray3);
        byte[] byArray4 = Function.getPaddedArrayCopy(byArray2, 16);
        blockCipher.encrypt(byArray4, 0, byArray4.length);
        return byArray4;
    }

    private static byte[] getHash(String string, byte[] byArray, int n) {
        if (!"SHA256".equalsIgnoreCase(string)) {
            throw DbException.getInvalidValueException("algorithm", string);
        }
        for (int i = 0; i < n; ++i) {
            byArray = SHA256.getHash(byArray, false);
        }
        return byArray;
    }

    private static String substring(String string, int n, int n2) {
        int n3 = string.length();
        if (--n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n4 = n = n > n3 ? n3 : n;
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        return string.substring(n, n + n2);
    }

    private static String repeat(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * n);
        while (n-- > 0) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static String rawToHex(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(4 * n);
        for (int i = 0; i < n; ++i) {
            String string2 = Integer.toHexString(string.charAt(i) & 0xFFFF);
            for (int j = string2.length(); j < 4; ++j) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private static int locate(String string, String string2, int n) {
        if (n < 0) {
            int n2 = string2.length() + n;
            return string2.lastIndexOf(string, n2) + 1;
        }
        int n3 = n == 0 ? 0 : n - 1;
        return string2.indexOf(string, n3) + 1;
    }

    private static String right(String string, int n) {
        if (n < 0) {
            n = 0;
        } else if (n > string.length()) {
            n = string.length();
        }
        return string.substring(string.length() - n);
    }

    private static String left(String string, int n) {
        if (n < 0) {
            n = 0;
        } else if (n > string.length()) {
            n = string.length();
        }
        return string.substring(0, n);
    }

    private static String insert(String string, int n, int n2, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        int n3 = string.length();
        int n4 = string2.length();
        if (--n < 0 || n2 <= 0 || n4 == 0 || n > n3) {
            return string;
        }
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        return string.substring(0, n) + string2 + string.substring(n + n2);
    }

    private static String hexToRaw(String string) {
        int n = string.length();
        if (n % 4 != 0) {
            throw DbException.get(22018, string);
        }
        StringBuilder stringBuilder = new StringBuilder(n / 4);
        for (int i = 0; i < n; i += 4) {
            try {
                char c = (char)Integer.parseInt(string.substring(i, i + 4), 16);
                stringBuilder.append(c);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw DbException.get(22018, string);
            }
        }
        return stringBuilder.toString();
    }

    private static int getDifference(String string, String string2) {
        string = Function.getSoundex(string);
        string2 = Function.getSoundex(string2);
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (string.charAt(i) != string2.charAt(i)) continue;
            ++n;
        }
        return n;
    }

    private static String translate(String string, String string2, String string3) {
        if (StringUtils.isNullOrEmpty(string) || StringUtils.isNullOrEmpty(string2)) {
            return string;
        }
        StringBuilder stringBuilder = null;
        int n = string3 == null ? 0 : string3.length();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            int n3 = string2.indexOf(c);
            if (n3 >= 0) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(n2);
                    if (i > 0) {
                        stringBuilder.append(string, 0, i);
                    }
                }
                if (n3 < n) {
                    c = string3.charAt(n3);
                }
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c);
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    private static double roundMagic(double d) {
        if (d < 1.0E-13 && d > -1.0E-13) {
            return 0.0;
        }
        if (d > 1.0E12 || d < -1.0E12) {
            return d;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(d);
        if (stringBuilder.toString().indexOf(69) >= 0) {
            return d;
        }
        int n = stringBuilder.length();
        if (n < 16) {
            return d;
        }
        if (stringBuilder.toString().indexOf(46) > n - 3) {
            return d;
        }
        stringBuilder.delete(n - 2, n);
        char c = stringBuilder.charAt((n -= 2) - 2);
        char c2 = stringBuilder.charAt(n - 3);
        char c3 = stringBuilder.charAt(n - 4);
        if (c == '0' && c2 == '0' && c3 == '0') {
            stringBuilder.setCharAt(n - 1, '0');
        } else if (c == '9' && c2 == '9' && c3 == '9') {
            stringBuilder.setCharAt(n - 1, '9');
            stringBuilder.append('9');
            stringBuilder.append('9');
            stringBuilder.append('9');
        }
        return Double.parseDouble(stringBuilder.toString());
    }

    private static String getSoundex(String string) {
        int n = string.length();
        char[] cArray = new char[]{'0', '0', '0', '0'};
        char c = '0';
        int n2 = 0;
        for (int i = 0; i < n && n2 < 4; ++i) {
            char c2;
            char c3 = string.charAt(i);
            char c4 = c2 = c3 > SOUNDEX_INDEX.length ? (char)'\u0000' : SOUNDEX_INDEX[c3];
            if (c2 == '\u0000') continue;
            if (n2 == 0) {
                cArray[n2++] = c3;
                c = c2;
                continue;
            }
            if (c2 <= '6') {
                if (c2 == c) continue;
                cArray[n2++] = c2;
                c = c2;
                continue;
            }
            if (c2 != '7') continue;
            c = c2;
        }
        return new String(cArray);
    }

    private static Integer oraHash(String string, Integer n, Integer n2) {
        int n3 = string.hashCode();
        if (n2 != null && n2 != 0) {
            n3 *= n2 * 17;
        }
        if (n != null && n > 0) {
            n3 %= n.intValue();
        }
        return n3;
    }

    private static int makeRegexpFlags(String string) {
        int n = 64;
        if (string != null) {
            block6: for (int i = 0; i < string.length(); ++i) {
                switch (string.charAt(i)) {
                    case 'i': {
                        n |= 2;
                        continue block6;
                    }
                    case 'c': {
                        n &= 0xFFFFFFFD;
                        continue block6;
                    }
                    case 'n': {
                        n |= 0x20;
                        continue block6;
                    }
                    case 'm': {
                        n |= 8;
                        continue block6;
                    }
                    default: {
                        throw DbException.get(90008, string);
                    }
                }
            }
        }
        return n;
    }

    @Override
    public int getType() {
        return this.dataType;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.mapColumns(columnResolver, n);
        }
    }

    protected void checkParameterCount(int n) {
        boolean bl;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        switch (this.info.type) {
            case 204: 
            case 210: 
            case 219: 
            case 220: {
                n2 = 1;
                break;
            }
            case 20: 
            case 112: 
            case 119: {
                n3 = 1;
                break;
            }
            case 21: 
            case 27: 
            case 32: 
            case 63: 
            case 69: 
            case 78: 
            case 88: 
            case 97: 
            case 99: 
            case 225: {
                n2 = 1;
                n3 = 2;
                break;
            }
            case 132: {
                n2 = 2;
                n3 = 2;
                break;
            }
            case 93: 
            case 96: {
                n2 = 1;
                n3 = 3;
                break;
            }
            case 95: {
                n2 = 1;
                n3 = 3;
                break;
            }
            case 58: 
            case 62: 
            case 67: 
            case 72: 
            case 73: 
            case 90: 
            case 91: {
                n2 = 2;
                n3 = 3;
                break;
            }
            case 54: 
            case 92: 
            case 211: {
                n2 = 2;
                break;
            }
            case 84: {
                n2 = 1;
                n3 = 4;
                break;
            }
            case 121: 
            case 122: {
                n2 = 2;
                n3 = 4;
                break;
            }
            case 207: 
            case 208: {
                n2 = 1;
                n3 = 2;
                break;
            }
            case 206: 
            case 229: {
                n2 = 3;
                break;
            }
            case 89: {
                n2 = 3;
                n3 = 4;
                break;
            }
            case 240: {
                n2 = 2;
                n3 = 3;
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.info.type);
            }
        }
        boolean bl2 = bl = n >= n2 && n <= n3;
        if (!bl) {
            throw DbException.get(7001, this.info.name, n2 + ".." + n3);
        }
    }

    public void doneWithParameters() {
        if (this.info.parameterCount == -1) {
            this.checkParameterCount(this.varArgs.size());
            this.args = this.varArgs.toArray(new Expression[0]);
            this.varArgs = null;
        } else {
            int n = this.args.length;
            if (n > 0 && this.args[n - 1] == null) {
                throw DbException.get(7001, this.info.name, "" + n);
            }
        }
    }

    public void setDataType(Column column) {
        this.dataType = column.getType();
        this.precision = column.getPrecision();
        this.displaySize = column.getDisplaySize();
        this.scale = column.getScale();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Expression optimize(Session session) {
        int n;
        long l;
        int n2;
        int n3;
        boolean bl = this.info.deterministic;
        for (n3 = 0; n3 < this.args.length; ++n3) {
            Expression expression = this.args[n3];
            if (expression == null) continue;
            this.args[n3] = expression = expression.optimize(session);
            if (expression.isConstant()) continue;
            bl = false;
        }
        Expression expression = this.args.length < 1 ? null : this.args[0];
        switch (this.info.type) {
            case 200: 
            case 204: 
            case 205: 
            case 219: 
            case 220: {
                n3 = -1;
                n2 = 0;
                l = 0L;
                n = 0;
                for (Expression expression2 : this.args) {
                    int n4;
                    if (expression2 == ValueExpression.getNull() || (n4 = expression2.getType()) == -1 || n4 == 0) continue;
                    n3 = Value.getHigherOrder(n3, n4);
                    n2 = Math.max(n2, expression2.getScale());
                    l = Math.max(l, expression2.getPrecision());
                    n = Math.max(n, expression2.getDisplaySize());
                }
                if (n3 != -1) break;
                n3 = 13;
                n2 = 0;
                l = Integer.MAX_VALUE;
                n = Integer.MAX_VALUE;
                break;
            }
            case 206: 
            case 229: {
                Expression expression5;
                void expression3;
                n3 = -1;
                n2 = 0;
                l = 0L;
                n = 0;
                int i = 2;
                int n5 = this.args.length;
                while (expression3 < n5) {
                    int n6;
                    Expression expression4 = this.args[expression3];
                    if (expression4 != ValueExpression.getNull() && (n6 = expression4.getType()) != -1 && n6 != 0) {
                        n3 = Value.getHigherOrder(n3, n6);
                        n2 = Math.max(n2, expression4.getScale());
                        l = Math.max(l, expression4.getPrecision());
                        n = Math.max(n, expression4.getDisplaySize());
                    }
                    expression3 += 2;
                }
                if (this.args.length % 2 == 0 && (expression5 = this.args[this.args.length - 1]) != ValueExpression.getNull() && (n5 = expression5.getType()) != -1 && n5 != 0) {
                    n3 = Value.getHigherOrder(n3, n5);
                    n2 = Math.max(n2, expression5.getScale());
                    l = Math.max(l, expression5.getPrecision());
                    n = Math.max(n, expression5.getDisplaySize());
                }
                if (n3 != -1) break;
                n3 = 13;
                n2 = 0;
                l = Integer.MAX_VALUE;
                n = Integer.MAX_VALUE;
                break;
            }
            case 201: {
                n3 = Value.getHigherOrder(this.args[1].getType(), this.args[2].getType());
                l = Math.max(this.args[1].getPrecision(), this.args[2].getPrecision());
                n = Math.max(this.args[1].getDisplaySize(), this.args[2].getDisplaySize());
                n2 = Math.max(this.args[1].getScale(), this.args[2].getScale());
                break;
            }
            case 228: {
                switch (this.args[1].getType()) {
                    case 13: 
                    case 14: 
                    case 16: 
                    case 21: {
                        n3 = this.args[1].getType();
                        break;
                    }
                    default: {
                        n3 = Value.getHigherOrder(this.args[1].getType(), this.args[2].getType());
                    }
                }
                l = Math.max(this.args[1].getPrecision(), this.args[2].getPrecision());
                n = Math.max(this.args[1].getDisplaySize(), this.args[2].getDisplaySize());
                n2 = Math.max(this.args[1].getScale(), this.args[2].getScale());
                break;
            }
            case 202: 
            case 203: 
            case 227: {
                n3 = this.dataType;
                l = this.precision;
                n2 = this.scale;
                n = this.displaySize;
                break;
            }
            case 27: {
                n3 = expression.getType();
                n2 = expression.getScale();
                l = expression.getPrecision();
                n = expression.getDisplaySize();
                if (n3 == 0) {
                    n3 = 4;
                    l = 10L;
                    n = 11;
                    n2 = 0;
                    break;
                }
                if (n3 != 11) break;
                n3 = 10;
                l = 10L;
                n2 = 0;
                n = 10;
                break;
            }
            case 0: 
            case 13: 
            case 21: {
                n3 = expression.getType();
                n2 = expression.getScale();
                l = expression.getPrecision();
                n = expression.getDisplaySize();
                if (n3 != 0) break;
                n3 = 4;
                l = 10L;
                n = 11;
                n2 = 0;
                break;
            }
            case 222: {
                Expression dataType = this.args[1];
                n3 = dataType.getType();
                l = dataType.getPrecision();
                n2 = dataType.getScale();
                n = dataType.getDisplaySize();
                if (expression instanceof Variable) break;
                throw DbException.get(90137, expression.getSQL());
            }
            case 225: {
                n3 = this.args.length == 1 ? 15 : 16;
                l = Integer.MAX_VALUE;
                n2 = 0;
                n = Integer.MAX_VALUE;
                break;
            }
            case 72: 
            case 73: {
                n3 = this.info.returnDataType;
                l = this.args[0].getPrecision();
                n2 = 0;
                if (this.args[1].isConstant()) {
                    l -= this.args[1].getValue(session).getLong() - 1L;
                }
                if (this.args.length == 3 && this.args[2].isConstant()) {
                    l = Math.min(l, this.args[2].getValue(session).getLong());
                }
                l = Math.max(0L, l);
                n = MathUtils.convertLongToInt(l);
                break;
            }
            default: {
                n3 = this.info.returnDataType;
                DataType dataType = DataType.getDataType(n3);
                l = -1L;
                n = 0;
                n2 = dataType.defaultScale;
            }
        }
        this.dataType = n3;
        this.precision = l;
        this.scale = n2;
        this.displaySize = n;
        if (bl) {
            Value value = this.getValue(session);
            if (value == ValueNull.INSTANCE && (this.info.type == 203 || this.info.type == 202)) {
                return this;
            }
            return ValueExpression.get(value);
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.setEvaluatable(tableFilter, bl);
        }
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public long getPrecision() {
        if (this.precision == -1L) {
            this.calculatePrecisionAndDisplaySize();
        }
        return this.precision;
    }

    @Override
    public int getDisplaySize() {
        if (this.precision == -1L) {
            this.calculatePrecisionAndDisplaySize();
        }
        return this.displaySize;
    }

    private void calculatePrecisionAndDisplaySize() {
        switch (this.info.type) {
            case 30: 
            case 31: {
                this.precision = this.args[2].getPrecision();
                this.displaySize = this.args[2].getDisplaySize();
                break;
            }
            case 32: {
                this.precision = this.args[0].getPrecision();
                this.displaySize = this.args[0].getDisplaySize();
                break;
            }
            case 52: {
                this.precision = 1L;
                this.displaySize = 1;
                break;
            }
            case 54: {
                this.precision = 0L;
                this.displaySize = 0;
                for (Expression expression : this.args) {
                    this.precision += expression.getPrecision();
                    this.displaySize = MathUtils.convertLongToInt((long)this.displaySize + (long)expression.getDisplaySize());
                    if (this.precision >= 0L) continue;
                    this.precision = Long.MAX_VALUE;
                }
                break;
            }
            case 56: {
                this.precision = (this.args[0].getPrecision() + 3L) / 4L;
                this.displaySize = MathUtils.convertLongToInt(this.precision);
                break;
            }
            case 27: 
            case 59: 
            case 63: 
            case 68: 
            case 69: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 82: {
                this.precision = this.args[0].getPrecision();
                this.displaySize = this.args[0].getDisplaySize();
                break;
            }
            case 65: {
                this.precision = this.args[0].getPrecision() * 4L;
                this.displaySize = MathUtils.convertLongToInt(this.precision);
                break;
            }
            case 70: {
                this.precision = 4L;
                this.displaySize = (int)this.precision;
                break;
            }
            case 104: 
            case 111: {
                this.precision = 20L;
                this.displaySize = (int)this.precision;
                break;
            }
            default: {
                DataType dataType = DataType.getDataType(this.dataType);
                this.precision = dataType.defaultPrecision;
                this.displaySize = dataType.defaultDisplaySize;
            }
        }
    }

    @Override
    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder(this.info.name);
        if (this.info.type == 206) {
            if (this.args[0] != null) {
                statementBuilder.append(" ").append(this.args[0].getSQL());
            }
            int n = this.args.length - 1;
            for (int i = 1; i < n; i += 2) {
                statementBuilder.append(" WHEN ").append(this.args[i].getSQL());
                statementBuilder.append(" THEN ").append(this.args[i + 1].getSQL());
            }
            if (this.args.length % 2 == 0) {
                statementBuilder.append(" ELSE ").append(this.args[this.args.length - 1].getSQL());
            }
            return statementBuilder.append(" END").toString();
        }
        statementBuilder.append('(');
        switch (this.info.type) {
            case 203: {
                statementBuilder.append(this.args[0].getSQL()).append(" AS ").append(new Column(null, this.dataType, this.precision, this.scale, this.displaySize).getCreateSQL());
                break;
            }
            case 202: {
                if (this.database.getMode().swapConvertFunctionParameters) {
                    statementBuilder.append(new Column(null, this.dataType, this.precision, this.scale, this.displaySize).getCreateSQL()).append(',').append(this.args[0].getSQL());
                    break;
                }
                statementBuilder.append(this.args[0].getSQL()).append(',').append(new Column(null, this.dataType, this.precision, this.scale, this.displaySize).getCreateSQL());
                break;
            }
            case 120: {
                ValueString valueString = (ValueString)((ValueExpression)this.args[0]).getValue(null);
                statementBuilder.append(valueString.getString()).append(" FROM ").append(this.args[1].getSQL());
                break;
            }
            default: {
                for (Expression expression : this.args) {
                    statementBuilder.appendExceptFirst(", ");
                    statementBuilder.append(expression.getSQL());
                }
            }
        }
        return statementBuilder.append(')').toString();
    }

    @Override
    public void updateAggregate(Session session) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.updateAggregate(session);
        }
    }

    public int getFunctionType() {
        return this.info.type;
    }

    @Override
    public String getName() {
        return this.info.name;
    }

    @Override
    public ValueResultSet getValueForColumnList(Session session, Expression[] expressionArray) {
        switch (this.info.type) {
            case 210: {
                ValueResultSet valueResultSet;
                ResultSet resultSet;
                String[] stringArray;
                String string = expressionArray[0].getValue(session).getString();
                if (string == null) {
                    throw DbException.get(90012, "fileName");
                }
                String string2 = expressionArray.length < 2 ? null : expressionArray[1].getValue(session).getString();
                Csv csv = new Csv();
                String string3 = expressionArray.length < 3 ? null : expressionArray[2].getValue(session).getString();
                String string4 = null;
                if (string3 != null && string3.indexOf(61) >= 0) {
                    string4 = csv.setOptions(string3);
                } else {
                    string4 = string3;
                    String string5 = expressionArray.length < 4 ? null : expressionArray[3].getValue(session).getString();
                    stringArray = expressionArray.length < 5 ? null : expressionArray[4].getValue(session).getString();
                    resultSet = expressionArray.length < 6 ? null : expressionArray[5].getValue(session).getString();
                    Function.setCsvDelimiterEscape(csv, string5, (String)stringArray, (String)((Object)resultSet));
                }
                char c = csv.getFieldSeparatorRead();
                stringArray = StringUtils.arraySplit(string2, c, true);
                resultSet = null;
                try {
                    resultSet = csv.read(string, stringArray, string4);
                    valueResultSet = ValueResultSet.getCopy(resultSet, 0);
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
                finally {
                    csv.close();
                    JdbcUtils.closeSilently(resultSet);
                }
                return valueResultSet;
            }
        }
        return (ValueResultSet)this.getValueWithArgs(session, expressionArray);
    }

    private static void setCsvDelimiterEscape(Csv csv, String string, String string2, String string3) {
        char c;
        if (string != null) {
            csv.setFieldSeparatorWrite(string);
            if (string.length() > 0) {
                c = string.charAt(0);
                csv.setFieldSeparatorRead(c);
            }
        }
        if (string2 != null) {
            c = string2.length() == 0 ? (char)'\u0000' : string2.charAt(0);
            csv.setFieldDelimiter(c);
        }
        if (string3 != null) {
            c = string3.length() == 0 ? (char)'\u0000' : string3.charAt(0);
            csv.setEscapeCharacter(c);
        }
    }

    @Override
    public Expression[] getArgs() {
        return this.args;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        for (Expression expression : this.args) {
            if (expression == null || expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        switch (expressionVisitor.getType()) {
            case 2: 
            case 5: 
            case 8: {
                return this.info.deterministic;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        int n = 3;
        for (Expression expression : this.args) {
            if (expression == null) continue;
            n += expression.getCost();
        }
        return n;
    }

    @Override
    public boolean isDeterministic() {
        return this.info.deterministic;
    }

    @Override
    public boolean isBufferResultSetToLocalTemp() {
        return this.info.bufferResultSetToLocalTemp;
    }

    static {
        String string = "7AEIOUY8HW1BFPV2CGJKQSXZ3DT4L5MN6R";
        char c = '\u0000';
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 < '9') {
                c = c2;
                continue;
            }
            Function.SOUNDEX_INDEX[c2] = c;
            Function.SOUNDEX_INDEX[Character.toLowerCase((char)c2)] = c;
        }
        Function.addFunction("ABS", 0, 1, 0);
        Function.addFunction("ACOS", 1, 1, 7);
        Function.addFunction("ASIN", 2, 1, 7);
        Function.addFunction("ATAN", 3, 1, 7);
        Function.addFunction("ATAN2", 4, 2, 7);
        Function.addFunction("BITAND", 5, 2, 5);
        Function.addFunction("BITGET", 40, 2, 1);
        Function.addFunction("BITOR", 6, 2, 5);
        Function.addFunction("BITXOR", 7, 2, 5);
        Function.addFunction("CEILING", 8, 1, 7);
        Function.addFunction("CEIL", 8, 1, 7);
        Function.addFunction("COS", 9, 1, 7);
        Function.addFunction("COSH", 36, 1, 7);
        Function.addFunction("COT", 10, 1, 7);
        Function.addFunction("DEGREES", 11, 1, 7);
        Function.addFunction("EXP", 12, 1, 7);
        Function.addFunction("FLOOR", 13, 1, 7);
        Function.addFunction("LOG", 14, 1, 7);
        Function.addFunction("LN", 39, 1, 7);
        Function.addFunction("LOG10", 15, 1, 7);
        Function.addFunction("MOD", 16, 2, 5);
        Function.addFunction("PI", 17, 0, 7);
        Function.addFunction("POWER", 18, 2, 7);
        Function.addFunction("RADIANS", 19, 1, 7);
        Function.addFunctionNotDeterministic("RAND", 20, -1, 7);
        Function.addFunctionNotDeterministic("RANDOM", 20, -1, 7);
        Function.addFunction("ROUND", 21, -1, 7);
        Function.addFunction("ROUNDMAGIC", 22, 1, 7);
        Function.addFunction("SIGN", 23, 1, 4);
        Function.addFunction("SIN", 24, 1, 7);
        Function.addFunction("SINH", 37, 1, 7);
        Function.addFunction("SQRT", 25, 1, 7);
        Function.addFunction("TAN", 26, 1, 7);
        Function.addFunction("TANH", 38, 1, 7);
        Function.addFunction("TRUNCATE", 27, -1, 0);
        Function.addFunction("TRUNC", 27, -1, 0);
        Function.addFunction("HASH", 29, 3, 12);
        Function.addFunction("ENCRYPT", 30, 3, 12);
        Function.addFunction("DECRYPT", 31, 3, 12);
        Function.addFunctionNotDeterministic("SECURE_RAND", 28, 1, 12);
        Function.addFunction("COMPRESS", 32, -1, 12);
        Function.addFunction("EXPAND", 33, 1, 12);
        Function.addFunction("ZERO", 34, 0, 4);
        Function.addFunctionNotDeterministic("RANDOM_UUID", 35, 0, 20);
        Function.addFunctionNotDeterministic("SYS_GUID", 35, 0, 20);
        Function.addFunctionNotDeterministic("UUID", 35, 0, 20);
        Function.addFunction("ASCII", 50, 1, 4);
        Function.addFunction("BIT_LENGTH", 51, 1, 5);
        Function.addFunction("CHAR", 52, 1, 13);
        Function.addFunction("CHR", 52, 1, 13);
        Function.addFunction("CHAR_LENGTH", 53, 1, 4);
        Function.addFunction("CHARACTER_LENGTH", 53, 1, 4);
        Function.addFunctionWithNull("CONCAT", 54, -1, 13);
        Function.addFunctionWithNull("CONCAT_WS", 92, -1, 13);
        Function.addFunction("DIFFERENCE", 55, 2, 4);
        Function.addFunction("HEXTORAW", 56, 1, 13);
        Function.addFunctionWithNull("INSERT", 57, 4, 13);
        Function.addFunction("LCASE", 59, 1, 13);
        Function.addFunction("LEFT", 60, 2, 13);
        Function.addFunction("LENGTH", 61, 1, 5);
        Function.addFunction("LOCATE", 62, -1, 4);
        Function.addFunction("CHARINDEX", 62, -1, 4);
        Function.addFunction("POSITION", 62, 2, 4);
        Function.addFunction("INSTR", 58, -1, 4);
        Function.addFunction("LTRIM", 63, -1, 13);
        Function.addFunction("OCTET_LENGTH", 64, 1, 5);
        Function.addFunction("RAWTOHEX", 65, 1, 13);
        Function.addFunction("REPEAT", 66, 2, 13);
        Function.addFunction("REPLACE", 67, -1, 13, false, true, true);
        Function.addFunction("RIGHT", 68, 2, 13);
        Function.addFunction("RTRIM", 69, -1, 13);
        Function.addFunction("SOUNDEX", 70, 1, 13);
        Function.addFunction("SPACE", 71, 1, 13);
        Function.addFunction("SUBSTR", 72, -1, 13);
        Function.addFunction("SUBSTRING", 73, -1, 13);
        Function.addFunction("UCASE", 74, 1, 13);
        Function.addFunction("LOWER", 75, 1, 13);
        Function.addFunction("UPPER", 76, 1, 13);
        Function.addFunction("POSITION", 77, 2, 4);
        Function.addFunction("TRIM", 78, -1, 13);
        Function.addFunction("STRINGENCODE", 79, 1, 13);
        Function.addFunction("STRINGDECODE", 80, 1, 13);
        Function.addFunction("STRINGTOUTF8", 81, 1, 12);
        Function.addFunction("UTF8TOSTRING", 82, 1, 13);
        Function.addFunction("XMLATTR", 83, 2, 13);
        Function.addFunctionWithNull("XMLNODE", 84, -1, 13);
        Function.addFunction("XMLCOMMENT", 85, 1, 13);
        Function.addFunction("XMLCDATA", 86, 1, 13);
        Function.addFunction("XMLSTARTDOC", 87, 0, 13);
        Function.addFunction("XMLTEXT", 88, -1, 13);
        Function.addFunction("REGEXP_REPLACE", 89, -1, 13);
        Function.addFunction("RPAD", 90, -1, 13);
        Function.addFunction("LPAD", 91, -1, 13);
        Function.addFunction("TO_CHAR", 93, -1, 13);
        Function.addFunction("ORA_HASH", 95, -1, 4);
        Function.addFunction("TRANSLATE", 94, 3, 13);
        Function.addFunction("REGEXP_LIKE", 240, -1, 1);
        Function.addFunctionNotDeterministic("CURRENT_DATE", 117, 0, 10);
        Function.addFunctionNotDeterministic("CURDATE", 100, 0, 10);
        Function.addFunctionNotDeterministic("TODAY", 117, 0, 10);
        Function.addFunction("TO_DATE", 96, -1, 11);
        Function.addFunction("TO_TIMESTAMP", 97, -1, 11);
        Function.addFunction("ADD_MONTHS", 98, 2, 11);
        Function.addFunction("TO_TIMESTAMP_TZ", 99, -1, 24);
        Function.addFunctionNotDeterministic("GETDATE", 100, 0, 10);
        Function.addFunctionNotDeterministic("CURRENT_TIME", 118, 0, 9);
        Function.addFunctionNotDeterministic("SYSTIME", 118, 0, 9);
        Function.addFunctionNotDeterministic("CURTIME", 101, 0, 9);
        Function.addFunctionNotDeterministic("CURRENT_TIMESTAMP", 119, -1, 11);
        Function.addFunctionNotDeterministic("SYSDATE", 119, -1, 11);
        Function.addFunctionNotDeterministic("SYSTIMESTAMP", 119, -1, 11);
        Function.addFunctionNotDeterministic("NOW", 112, -1, 11);
        Function.addFunction("DATEADD", 102, 3, 11);
        Function.addFunction("TIMESTAMPADD", 102, 3, 11);
        Function.addFunction("DATEDIFF", 103, 3, 5);
        Function.addFunction("TIMESTAMPDIFF", 103, 3, 5);
        Function.addFunction("DAYNAME", 104, 1, 13);
        Function.addFunction("DAYNAME", 104, 1, 13);
        Function.addFunction("DAY", 105, 1, 4);
        Function.addFunction("DAY_OF_MONTH", 105, 1, 4);
        Function.addFunction("DAY_OF_WEEK", 106, 1, 4);
        Function.addFunction("DAY_OF_YEAR", 107, 1, 4);
        Function.addFunction("DAYOFMONTH", 105, 1, 4);
        Function.addFunction("DAYOFWEEK", 106, 1, 4);
        Function.addFunction("DAYOFYEAR", 107, 1, 4);
        Function.addFunction("HOUR", 108, 1, 4);
        Function.addFunction("MINUTE", 109, 1, 4);
        Function.addFunction("MONTH", 110, 1, 4);
        Function.addFunction("MONTHNAME", 111, 1, 13);
        Function.addFunction("QUARTER", 113, 1, 4);
        Function.addFunction("SECOND", 114, 1, 4);
        Function.addFunction("WEEK", 115, 1, 4);
        Function.addFunction("YEAR", 116, 1, 4);
        Function.addFunction("EXTRACT", 120, 2, 4);
        Function.addFunctionWithNull("FORMATDATETIME", 121, -1, 13);
        Function.addFunctionWithNull("PARSEDATETIME", 122, -1, 11);
        Function.addFunction("ISO_YEAR", 123, 1, 4);
        Function.addFunction("ISO_WEEK", 124, 1, 4);
        Function.addFunction("ISO_DAY_OF_WEEK", 125, 1, 4);
        Function.addFunction("DATE_TRUNC", 132, 2, 0);
        Function.addFunctionNotDeterministic("DATABASE", 150, 0, 13);
        Function.addFunctionNotDeterministic("USER", 151, 0, 13);
        Function.addFunctionNotDeterministic("CURRENT_USER", 152, 0, 13);
        Function.addFunctionNotDeterministic("IDENTITY", 153, 0, 5);
        Function.addFunctionNotDeterministic("SCOPE_IDENTITY", 154, 0, 5);
        Function.addFunctionNotDeterministic("IDENTITY_VAL_LOCAL", 153, 0, 5);
        Function.addFunctionNotDeterministic("LAST_INSERT_ID", 153, 0, 5);
        Function.addFunctionNotDeterministic("LASTVAL", 153, 0, 5);
        Function.addFunctionNotDeterministic("AUTOCOMMIT", 155, 0, 1);
        Function.addFunctionNotDeterministic("READONLY", 156, 0, 1);
        Function.addFunction("DATABASE_PATH", 157, 0, 13);
        Function.addFunctionNotDeterministic("LOCK_TIMEOUT", 158, 0, 4);
        Function.addFunctionWithNull("IFNULL", 200, 2, 0);
        Function.addFunctionWithNull("ISNULL", 200, 2, 0);
        Function.addFunctionWithNull("CASEWHEN", 201, 3, 0);
        Function.addFunctionWithNull("CONVERT", 202, 1, 0);
        Function.addFunctionWithNull("CAST", 203, 1, 0);
        Function.addFunctionWithNull("TRUNCATE_VALUE", 227, 3, 0);
        Function.addFunctionWithNull("COALESCE", 204, -1, 0);
        Function.addFunctionWithNull("NVL", 204, -1, 0);
        Function.addFunctionWithNull("NVL2", 228, 3, 0);
        Function.addFunctionWithNull("NULLIF", 205, 2, 0);
        Function.addFunctionWithNull("CASE", 206, -1, 0);
        Function.addFunctionNotDeterministic("NEXTVAL", 207, -1, 5);
        Function.addFunctionNotDeterministic("CURRVAL", 208, -1, 5);
        Function.addFunction("ARRAY_GET", 209, 2, 13);
        Function.addFunction("ARRAY_CONTAINS", 230, 2, 1, false, true, true);
        Function.addFunction("CSVREAD", 210, -1, 18, false, false, false);
        Function.addFunction("CSVWRITE", 211, -1, 4, false, false, true);
        Function.addFunctionNotDeterministic("MEMORY_FREE", 212, 0, 4);
        Function.addFunctionNotDeterministic("MEMORY_USED", 213, 0, 4);
        Function.addFunctionNotDeterministic("LOCK_MODE", 214, 0, 4);
        Function.addFunctionNotDeterministic("SCHEMA", 215, 0, 13);
        Function.addFunctionNotDeterministic("SESSION_ID", 216, 0, 4);
        Function.addFunction("ARRAY_LENGTH", 217, 1, 4);
        Function.addFunctionNotDeterministic("LINK_SCHEMA", 218, 6, 18);
        Function.addFunctionWithNull("LEAST", 220, -1, 0);
        Function.addFunctionWithNull("GREATEST", 219, -1, 0);
        Function.addFunctionNotDeterministic("CANCEL_SESSION", 221, 1, 1);
        Function.addFunction("SET", 222, 2, 0, false, false, true);
        Function.addFunction("FILE_READ", 225, -1, 0, false, false, true);
        Function.addFunction("FILE_WRITE", 232, 2, 5, false, false, true);
        Function.addFunctionNotDeterministic("TRANSACTION_ID", 226, 0, 13);
        Function.addFunctionWithNull("DECODE", 229, -1, 0);
        Function.addFunctionNotDeterministic("DISK_SPACE_USED", 159, 1, 5);
        Function.addFunctionWithNull("SIGNAL", 160, 2, 0);
        Function.addFunction("H2VERSION", 231, 0, 13);
        Function.addFunctionWithNull("TABLE", 223, -1, 18);
        Function.addFunctionWithNull("TABLE_DISTINCT", 224, -1, 18);
        Function.addFunctionWithNull("ROW_NUMBER", 300, 0, 5);
        Function.addFunction("VALUES", 250, 1, 0, false, true, false);
    }
}

