﻿package com.anttikupila.revolt {
	import flash.media.*;
	import flash.display.*;
	import flash.net.*;
	import flash.events.*;
	import flash.utils.*;
	import flash.filters.DropShadowFilter;
	import com.anttikupila.soundSpectrum.SoundProcessor;
	import com.anttikupila.revolt.presets.*;
	
	public class Revolt extends Sprite {
		private var sp:SoundProcessor;
		private var gfx:BitmapData;
		private var presetList:Array;
		private var presetInt:Timer;
		private var preset:Preset;
        private var lastChange:Number;
        private var _pic:Bitmap;
        private const ALL_PRESETS:Array = [new LineFourier(), new LineNoFourier(), new Explosion(), new LineSmooth(), new LineWorm(), new Tunnel()];

        function Revolt(w:uint, h:uint, presets:Array = null) {
            sp = new SoundProcessor();

            gfx = new BitmapData(w, h, false, 0x000000)
            _pic = new Bitmap(gfx);
            addChild(_pic);

            presetList = getPresets(presets);
            //			presetList = new Array(new LineWorm());

            setupTimer();
//            var initialDelay:Timer = new Timer(7100, 1);
//            initialDelay.addEventListener(TimerEvent.TIMER, setupTimer);
//            initialDelay.start();

            // initialize
            nextEffect();
            start();
        }

        public function set effect(val:int):void {
            nextEffect(val);
        }

        public function start():void {
            addEventListener(Event.ENTER_FRAME, compute);
        }
        
        public function stop():void {
            removeEventListener(Event.ENTER_FRAME, compute);
        }

        public function set effects(val:Array):void {
            presetList = getPresets(val);
            trace("preset list has " + presetList.length + " effects");
            if (presetList.length == 1) {
                presetInt.stop();
                nextEffect(0);
            } else {
                presetInt.start();
            }
        }

        private function getPresets(presets:Array):Array {
            if (! presets) return ALL_PRESETS;
            var result:Array = [];
            for (var i:int = 0; i < presets.length; i++) {
                result.push(ALL_PRESETS[presets[i]]);
            }
            return result;
        }

		private function compute(ev:Event):void {
			var soundArray:Array = sp.getSoundSpectrum(preset.fourier);
			preset.applyGfx(gfx, soundArray);
		}
		
		private function setupTimer():void {
			presetInt = new Timer(12950);
			presetInt.addEventListener(TimerEvent.TIMER, nextTimedEffect);
			presetInt.start();
			nextEffect();
		}
		
		public function nextEffect(effect:int = -1):void {
			var index:int = effect >= 0 ? effect : Math.floor(Math.random()*presetList.length);
			var newPreset:Preset = presetList[index];
			if (newPreset != preset) {
				preset = newPreset;
				preset.init();
				trace("next effect is '" + preset.toString().toLowerCase() + "'");
			} else {
				nextEffect();
			}
			lastChange = getTimer();
		}
		
		private function nextTimedEffect(ev:Event):void {
			if (getTimer() - lastChange > 5000) {
				nextEffect();
			}
		}

        override public function set width(val:Number):void {
            _pic.width = val;
        }

        override public function set height(val:Number):void {
            _pic.height = val;
        }
	}
}