/*****************************************************
*  
*  Copyright 2009 Adobe Systems Incorporated.  All Rights Reserved.
*  
*****************************************************
*  The contents of this file are subject to the Mozilla Public License
*  Version 1.1 (the "License"); you may not use this file except in
*  compliance with the License. You may obtain a copy of the License at
*  http://www.mozilla.org/MPL/
*   
*  Software distributed under the License is distributed on an "AS IS"
*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
*  License for the specific language governing rights and limitations
*  under the License.
*   
*  
*  The Initial Developer of the Original Code is Adobe Systems Incorporated.
*  Portions created by Adobe Systems Incorporated are Copyright (C) 2009 Adobe Systems 
*  Incorporated. All Rights Reserved. 
* 
*  Contributor(s): Akamai Technologies
*  
*****************************************************/
package org.osmf.netmocker
{
	import flash.net.NetConnection;
	import flash.net.NetStream;
	
	import org.osmf.media.URLResource;
	import org.osmf.net.NetClient;
	import org.osmf.net.NetConnectionFactoryBase;
	import org.osmf.net.NetLoader;
	
	/**
	 * A NetLoader which replaces the NetConnection and NetStream with mock
	 * objects which don't hit the network.
	 **/
	public class MockNetLoader extends NetLoader implements IMockNetLoader
	{
		/**
		 * Constructor
		 * 
		 * @param netConnectionFactory the netConnection factory instance to be used
		 * @param mockNetNegotiator the mock NetNegotiator to be used
		 */
		public function MockNetLoader(netConnectionFactory:NetConnectionFactoryBase=null, reconnectStreams:Boolean=true)
		{
			if (netConnectionFactory == null)
			{
				netConnectionFactory = new DefaultNetConnectionFactory();
			}
			
			super(netConnectionFactory);
			CONFIG::FLASH_10_1	
			{
				setReconnectStreams(reconnectStreams);
			}
			
			this.netConnectionFactory = netConnectionFactory;
		}

		/**
		 * The client's expectation for how this loader's NetConnection will
		 * behave after connect() is called.
		 **/ 
		public function set netConnectionExpectation(value:NetConnectionExpectation):void
		{
			if (netConnectionFactory is DefaultNetConnectionFactory)
			{
				DefaultNetConnectionFactory(netConnectionFactory).netConnectionExpectation = value;
			}
		}
		
		public function get netConnectionExpectation():NetConnectionExpectation
		{
			return netConnectionFactory is DefaultNetConnectionFactory ? DefaultNetConnectionFactory(netConnectionFactory).netConnectionExpectation : null;
		}
		
		/**
		 * The client's expectation for the version of the FMS server from which
		 * the NetConnection originates.  Format should be "3,5,3" (i.e. comma
		 * separated).
		 **/ 
		public function set netConnectionExpectedFMSVersion(value:String):void
		{
			if (netConnectionFactory is DefaultNetConnectionFactory)
			{
				DefaultNetConnectionFactory(netConnectionFactory).netConnectionExpectedFMSVersion = value;
			}
		}
		
		public function get netConnectionExpectedFMSVersion():String
		{
			return netConnectionFactory is DefaultNetConnectionFactory ? DefaultNetConnectionFactory(netConnectionFactory).netConnectionExpectedFMSVersion : null;
		}

		/**
		 * The expected duration of any mock NetStreams generated by this
		 * loader.
		 * 
		 * The expected duration will be returned in the onMetaData client
		 * callback.
		 **/
		public function set netStreamExpectedDuration(value:Number):void
		{
			_netStreamExpectedDuration = value;
		}
		
		public function get netStreamExpectedDuration():Number
		{
			return _netStreamExpectedDuration;
		}

		/**
		 * The expected total number of bytes of any mock NetStreams generated
		 * by this loader.
		 * 
		 * The expected bytesTotal will map to the bytesTotal property of
		 * the mock NetStream.
		 **/
		public function set netStreamExpectedBytesTotal(value:Number):void
		{
			_netStreamExpectedBytesTotal = value;
		}
		
		public function get netStreamExpectedBytesTotal():Number
		{
			return _netStreamExpectedBytesTotal;
		}

		/**
		 * The expected duration of any mock NetStreams generated by this
		 * loader, where the streams are subclips.
		 * 
		 * The expected duration will map to the playback duration of the
		 * media.
		 **/
		public function set netStreamExpectedSubclipDuration(value:Number):void
		{
			_netStreamExpectedSubclipDuration = value;
		}
		
		public function get netStreamExpectedSubclipDuration():Number
		{
			return _netStreamExpectedSubclipDuration;
		}

		/**
		 * The expected width of any mock NetStreams generated by this
		 * loader.
		 * 
		 * The expected width will be returned in the onMetaData client
		 * callback.
		 **/
		public function set netStreamExpectedWidth(value:Number):void
		{
			_netStreamExpectedWidth = value;
		}
		
		public function get netStreamExpectedWidth():Number
		{
			return _netStreamExpectedWidth;
		}

		/**
		 * The expected height of any mock NetStreams generated by this
		 * loader.
		 * 
		 * The expected height will be returned in the onMetaData client
		 * callback.
		 **/
		public function set netStreamExpectedHeight(value:Number):void
		{
			_netStreamExpectedHeight = value;
		}
		
		public function get netStreamExpectedHeight():Number
		{
			return _netStreamExpectedHeight;
		}
		
		/**
		 * An Array of EventInfos representing any events that are expected to
		 *  be dispatched when the mock NetStream's position crosses a certain
		 * threshold.  Note that these events are above and beyond what the
		 * MockNetStream typically dispatches during playback.
		 **/
		public function set netStreamExpectedEvents(value:Array):void
		{
			_netStreamExpectedEvents = value;
		}
		
		public function get netStreamExpectedEvents():Array
		{
			return _netStreamExpectedEvents;
		}
		
		/**
		 * An array of expected cue points. Necessary so that this
		 * mock stream class can call the in-stream callback
		 * onCuePoint with the data you expect.
		 * 
		 * Each value in the array should be an object
		 * with the following properties:
		 * <ul>
		 * <li>type - should be "event", "navigation"</li>
		 * <li>time - the time in seconds of the cue point</li>
		 * <li>name - the name of the cue point (can be any string)</li>
		 * <li>parameters - optional array of key/value pairs</li>
		 * </ul>
		 */
		public function set netStreamExpectedCuePoints(value:Array):void
		{
			_netStreamExpectedCuePoints = value;
		} 
		
		public function get netStreamExpectedCuePoints():Array
		{
			return _netStreamExpectedCuePoints;
		}
			    
	    /**
	     * @inheritDoc
	     **/
	    override protected function createNetStream(connection:NetConnection, resource:URLResource):NetStream
	    {
			var mockNetStream:MockNetStream = new MockNetStream(connection);
			mockNetStream.client = new NetClient();
			mockNetStream.expectedDuration = _netStreamExpectedDuration;
			mockNetStream.expectedBytesTotal = _netStreamExpectedBytesTotal;
			mockNetStream.expectedWidth = _netStreamExpectedWidth;
			mockNetStream.expectedHeight = _netStreamExpectedHeight;
			mockNetStream.expectedEvents = _netStreamExpectedEvents;
			mockNetStream.expectedSubclipDuration = _netStreamExpectedSubclipDuration;
			mockNetStream.expectedCuePoints = _netStreamExpectedCuePoints;
			return mockNetStream;
	    }

		CONFIG::FLASH_10_1	
		{								    
			/**
			 * @inheritDoc
		     **/
			override protected function createReconnectNetConnection():NetConnection
			{
				return new MockNetConnection();
			}
		   
			/**
			 * @inheritDoc
			 **/
			override protected function reconnect(netConnection:NetConnection, resource:URLResource):void
			{
				super.reconnect(netConnection, resource);
			}
		}
					    	    
	    private var _netStreamExpectedDuration:Number = 0;
	    private var _netStreamExpectedBytesTotal:Number = 0;
	    private var _netStreamExpectedSubclipDuration:Number = NaN;
	    private var _netStreamExpectedWidth:Number = 0;
	    private var _netStreamExpectedHeight:Number = 0;
	    private var _netStreamExpectedEvents:Array = [];
	    private var _netStreamExpectedCuePoints:Array = [];
	    
	    private var netConnectionFactory:NetConnectionFactoryBase;
	}
}