#include <stdio.h>
#include <usb.h>
#include "f60lib.h"
#include "mp3util.h"

void file_ext_to_mpm(char* c) {

     if (strlen(c) < 5) return;     
     c[strlen(c) - 1] = 'm';
     c[strlen(c) - 2] = 'p';
     c[strlen(c) - 3] = 'm';
     c[strlen(c) - 4] = '.';

}

void file_ext_to_mp3(char* c) {
     
     if (strlen(c) < 5) return;
     c[strlen(c) - 1] = '3';
     c[strlen(c) - 2] = 'p';
     c[strlen(c) - 3] = 'm';
     c[strlen(c) - 4] = '.';

}


int main(int argc,char** argv) {
     struct f60_dir* dirptr;
     int i;
     int filesize;
     char txt[51];
     char filename[280];
     usb_dev_handle *usb_hand = NULL;
     struct mp3_info* info;
     char *c;

     usb_init();
     usb_find_busses();
     usb_find_devices();

     usb_hand = f60_init();



     if (!usb_hand)  goto error;

     if (strcmp("smart",argv[0] + (strlen(argv[0]) - 5)) == 0) 
	f60_select_memory(SMARTMEDIA_MEMORY);	

     if (argc == 1)
	  goto end;


     
     if (strcmp("del",argv[1]) == 0  && argc == 3) {
	  if (!f60_delete_file(usb_hand,atoi(argv[2]))) goto error;
	  printf("deleted file\n");
	  goto end;
     }

     if (strcmp("send",argv[1]) == 0  && argc == 3) {
	  strcpy(filename,"/tmp/");
	  strncat(filename,f60_strip_path(argv[2]),256);
	  file_ext_to_mpm(filename);
	  printf("encoding file...\n");
	  fflush(stdout);
	  if (!f60_encode_file(argv[2],filename)) goto error;
	  printf("uploading file...\n");
	  fflush(stdout);
	  if (mp3_valid(argv[2])) {
	       info = mp3_get_info();
	       if (info->hastag) {
		    strncpy(txt,info->artist,24);
		    strcat(txt," ");
		    strncat(txt,info->title,24); 
		    if (!f60_send_file(usb_hand,filename,txt) ) goto error;
	       }
	       else
	       if (!f60_send_file(usb_hand,filename,f60_strip_path(argv[2])) ) goto error;
	  } else
	       if (!f60_send_file(usb_hand,filename,f60_strip_path(argv[2])) ) goto error;

	  unlink(filename);
	  printf("done!\n");
	  goto end;
     }

     if (strcmp("get",argv[1]) == 0  && argc == 3) {
	  printf("downloading file\n");
	  fflush(stdout);
	  c = f60_get_file(usb_hand,atoi(argv[2]),"/tmp/");
	  if (c == NULL)
	       goto error;
	  printf("decoding file\n");
	  fflush(stdout);
	  strncpy(filename,f60_strip_path(c),256);
	  file_ext_to_mp3(filename);
	  if (!f60_decode_file(c,filename)) goto error;
	  unlink(c);
	  goto end;
     }

	 

     printf("usage %s del # | send filename | get #\n",argv[0]);  
     f60_close(usb_hand);
     exit(1);

end:
     dirptr = f60_get_dir(usb_hand);
     if (dirptr == NULL) {
          if (argc == 1)     printf("usage %s del # | send filename | get #\n",argv[0]);  
	 
	  goto error;
     }
     printf("index of MPMAN F60\n");
     for(i=0;i<dirptr->size;i++) {
	  f60_big2little_endian((int*)&dirptr->contents[i*256],&filesize);
	  printf("%i] %9d    %s\n",i,filesize,f60_strip_path(&dirptr->contents[i*256 + 21]));
     }
     printf("Total memory %dk Free Memory %dk\n",
	   dirptr->total_memory /1024, dirptr->free_memory/1024);
    f60_close(usb_hand);

    exit(0);

error:
    printf("%s\n",f60_strerror);
    f60_close(usb_hand);
}
