/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ExtensionFunctionCall;
import net.sf.saxon.functions.ExtensionFunctionDefinition;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;

public class ItemAt
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "item-at");
    private static SequenceType[] argumentTypes = new SequenceType[]{SequenceType.ANY_SEQUENCE, SequenceType.OPTIONAL_NUMERIC};

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 2;
    }

    public int getMaximumNumberOfArguments() {
        return 2;
    }

    public SequenceType[] getArgumentTypes() {
        return argumentTypes;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.makeSequenceType(suppliedArgumentTypes[0].getPrimaryType(), 24576);
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ItemAtCall();
    }

    public Object getCompilerForJava() {
        try {
            return Class.forName("com.saxonica.codegen.ItemAtCompiler").newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static class ItemAtCall
    extends ExtensionFunctionCall {
        private ItemAtCall() {
        }

        public Expression rewrite(StaticContext context, Expression[] arguments) throws XPathException {
            if (arguments[1] instanceof Literal) {
                NumericValue val = (NumericValue)((Literal)arguments[1]).getValue();
                if (val.compareTo(1L) < 0 || val.compareTo(Integer.MAX_VALUE) > 0 || !val.isWholeNumber()) {
                    return new Literal(EmptySequence.getInstance());
                }
                if (val.compareTo(1L) > 0 && !Cardinality.allowsMany(arguments[0].getCardinality())) {
                    return new Literal(EmptySequence.getInstance());
                }
            }
            return null;
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            NumericValue index = (NumericValue)arguments[1].next();
            if (index == null) {
                return EmptyIterator.getInstance();
            }
            if (index.compareTo(Integer.MAX_VALUE) <= 0 && index.isWholeNumber()) {
                Item item;
                int intindex = (int)index.longValue();
                if (intindex < 1) {
                    return EmptyIterator.getInstance();
                }
                SequenceIterator base = arguments[0];
                if (intindex == 1) {
                    item = base.next();
                } else if (base instanceof GroundedIterator) {
                    GroundedValue value = ((GroundedIterator)base).materialize();
                    item = value.itemAt(intindex - 1);
                } else {
                    SequenceIterator tail = TailIterator.make(base, intindex);
                    item = tail.next();
                }
                return SingletonIterator.makeIterator(item);
            }
            return EmptyIterator.getInstance();
        }
    }
}

