# Начало работы

## Установить

::: code-group

```shell [npm]
npm install --save-dev husky
```

```shell [pnpm]
pnpm add --save-dev husky
```

```shell [yarn]
yarn add --dev husky
# Добавить pinst ТОЛЬКО если ваш пакет не является закрытым
yarn add --dev pinst
```

```shell [bun]
bun add --dev husky
```

:::

## `husky init` (рекомендуется)

Команда `init` упрощает настройку husky в проекте. Она создает скрипт `pre-commit` в `.husky/` и обновляет скрипт `prepare` в `package.json`. Изменения можно внести позже в соответствии с вашим рабочим процессом.

::: code-group

```shell [npm]
npx husky init
```

```shell [pnpm]
pnpm exec husky init
```

```shell [yarn]
# Из-за особых оговорок и различий с другими менеджерами пакетов,
# обратитесь к разделу «Как использовать».
```

```shell [bun]
bunx husky init
```

:::

## Попробуйте

Поздравляем! Вы успешно настроили свой первый Git hook всего одной командой 🎉. Давайте проверим:

```shell
git commit -m "Keep calm and commit"
# тестовый скрипт будет запускаться каждый раз при коммите
```

## Несколько слов...

### Скриптинг

Хотя большую часть времени вы просто запускаете несколько команд `npm run` или `npx` в своих хуках, вы также можете записать их с помощью оболочки POSIX для пользовательских рабочих процессов.

Например, вот как можно линтинговать подготовленные файлы на каждом коммите, используя всего две строки кода оболочки и без внешней зависимости:

```shell
# .husky/pre-commit
prettier $(git diff --cached --name-only --diff-filter=ACMR | sed 's| |\\ |g') --write --ignore-unknown
git update-index --again
```

_Это простой, но рабочий пример, проверьте [lint-staged](https://github.com/lint-staged/lint-staged), если вам нужно больше._

### Отключение хуков

Husky не принудительно использует хуки Git. Его можно отключить глобально (`HUSKY=0`) или включить, если нужно. См. раздел [Как сделать](how-to) для ручной настройки и дополнительной информации.