/***************************************************************************
 *
 * Project:  OpenCPN
 * Purpose:  NMEA0183 Support Classes
 * Author:   Samuel R. Blackburn, David S. Register
 *
 ***************************************************************************
 *   Copyright (C) 2010 by Samuel R. Blackburn, David S Register           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,  USA.             *
 ***************************************************************************
 *
 *   S Blackburn's original source license:                                *
 *         "You can use it any way you like."                              *
 *   More recent (2010) license statement:                                 *
 *         "It is BSD license, do with it what you will"                   *
 */


#if ! defined( RESPONSE_CLASS_HEADER )
#define RESPONSE_CLASS_HEADER

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like.
*/

class NMEA0183;

class RESPONSE
{

   protected:

      NMEA0183 *container_p;

   public:

      RESPONSE();
      virtual ~RESPONSE();

      /*
      ** Data
      */

      wxString ErrorMessage;
      wxString Mnemonic;
      wxString Talker;

      /*
      ** Methods
      */

      virtual void Empty( void ) = 0;
      virtual bool Parse( const SENTENCE& sentence ) = 0;
      virtual const wxString& PlainEnglish( void );
      virtual void SetErrorMessage( const wxString& );
      virtual void SetContainer( NMEA0183 *container );
      virtual bool Write( SENTENCE& sentence );
};



#endif // RESPONSE_CLASS_HEADER
