/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENRIJN_DISTANCE_INFORMATION_H_
#define _OPENRIJN_DISTANCE_INFORMATION_H_

namespace OpenRijn {
  /**
   * @ingroup OpenRijn
   *
   * This function is used as return of paintLine to contains information that need
   * to be passed for the next call.
   */
  struct DistanceInformation {
      DistanceInformation() : distance(0), spacing(0) {}
      DistanceInformation(float _distance, float _spacing) : distance(_distance), spacing(_spacing) {}
      float distance;
      float spacing;
  };
}

#endif
