# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1893-1 (cyrus-imapd-2.2 kolab-cyrus-imapd)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64977);
 script_cve_id("CVE-2009-2632", "CVE-2009-3235");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 1893-1 (cyrus-imapd-2.2 kolab-cyrus-imapd)");

 desc = "The remote host is missing an update to cyrus-imapd-2.2 kolab-cyrus-imapd
announced via advisory DSA 1893-1.


It was discovered that the SIEVE component of cyrus-imapd and
kolab-cyrus-imapd, the Cyrus mail system, is vulnerable to a buffer
overflow when processing SIEVE scripts.
This can be used to elevate privileges to the cyrus system user.  An
attacker who is able to install SIEVE scripts executed by the server is
therefore able to read and modify arbitrary email messages on the
system. The update introduced by DSA 1881-1 was incomplete and the issue
has been given an additional CVE id due to its complexity.


For the oldstable distribution (etch), this problem has been fixed in
version 2.2.13-10+etch4 for cyrus-imapd-2.2 and version 2.2.13-2+etch2
for kolab-cyrus-imapd.

For the stable distribution (lenny), this problem has been fixed in
version 2.2.13-14+lenny3 for cyrus-imapd-2.2, version 2.2.13-5+lenny2
for kolab-cyrus-imapd.

For the testing distribution (squeeze), this problem will be fixed soon.

For the unstable distribution (sid), this problem has been fixed in
version 2.2.13-15 for cyrus-imapd-2.2, and will be fixed soon for
kolab-cyrus-imapd.


We recommend that you upgrade your cyrus-imapd-2.2 and kolab-cyrus-imapd

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201893-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1893-1 (cyrus-imapd-2.2 kolab-cyrus-imapd)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cyrus-doc-2.2", ver:"2.2.13-10+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-admin-2.2", ver:"2.2.13-10+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kolab-cyrus-admin", ver:"2.2.13-2+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-murder-2.2", ver:"2.2.13-10+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kolab-libcyrus-imap-perl", ver:"2.2.13-2+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcyrus-imap-perl22", ver:"2.2.13-10+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-imapd-2.2", ver:"2.2.13-10+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-clients-2.2", ver:"2.2.13-10+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-dev-2.2", ver:"2.2.13-10+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kolab-cyrus-common", ver:"2.2.13-2+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-nntpd-2.2", ver:"2.2.13-10+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kolab-cyrus-pop3d", ver:"2.2.13-2+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-common-2.2", ver:"2.2.13-10+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kolab-cyrus-imapd", ver:"2.2.13-2+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kolab-cyrus-clients", ver:"2.2.13-2+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-pop3d-2.2", ver:"2.2.13-10+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-admin-2.2", ver:"2.2.13-14+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-doc-2.2", ver:"2.2.13-14+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kolab-cyrus-admin", ver:"2.2.13-5+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kolab-libcyrus-imap-perl", ver:"2.2.13-5+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcyrus-imap-perl22", ver:"2.2.13-14+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kolab-cyrus-imapd", ver:"2.2.13-5+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-common-2.2", ver:"2.2.13-14+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-dev-2.2", ver:"2.2.13-14+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-imapd-2.2", ver:"2.2.13-14+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kolab-cyrus-clients", ver:"2.2.13-5+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kolab-cyrus-pop3d", ver:"2.2.13-5+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-clients-2.2", ver:"2.2.13-14+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-nntpd-2.2", ver:"2.2.13-14+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kolab-cyrus-common", ver:"2.2.13-5+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-pop3d-2.2", ver:"2.2.13-14+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-murder-2.2", ver:"2.2.13-14+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
