Minutes from 93rd OpenVDB TSC meeting, June 1st, 2021, (EDT)

Attendees: *Nick* A., *Jeff* L., *Dan* B., *Andre* P.

Additional Attendees: JT Nelson (Blender), Richard Jones (DNeg),
Johannes Meng (Intel)

Regrets: *Ken* M.

Agenda:

1) Confirm Quorum
2) Secretary
3) Context functions in VDB AX
4) VDB Vector Merge
5) VDB 8.1.0
6) Feedback from Larry
7) Siggraph Course
8) Next meeting


1) Confirm Quorum

Quorum is present.

2) Secretary

Secretary is Dan Bailey.

3) Context functions in VDB AX

Nick presented some options for introducing "context functions". The backend is
working in AX, but the syntax has not yet been agreed upon. There are issues
with using free functions related to type inference in particular. For example,
"@density = volumesample()" needs to know the type of the volume being sampled.
Jeff mentions that VEX has support for return type overloads such as with the
point() function, however a specific choice was made to use volumesample and
volumesamplev to avoid the challenge of trying to infer the type in a nested
expression. An example of this is 5.0 * noise(...) - it's not clear if this is
intended to be 1D or 3D noise.

Nick wants the user to be able to select the context for two reasons. One to be
able to seamlessly transfer code from one context with another without having to
rewrite the snippet and two to be to use multi-context snippets, such as
sampling a volume onto a point attribute. Jeff highly values the first point.
Additional contexts being considered are a "metadata" context and a "generic"
context.

Various options were discussed, and the leading candidate came out to be this
one:

volume::@density->sample()

With the ability to assume default context by dropping the "namespace":

@density->sample()

One additional complexity is being able to retrieve the transform from the
volume associated with a point attribute, Rich gave this example:

volume::pt@density->transform()

Not ideal, but ideally would like the user not to need to know the name of the
point grid to access the transform.

Nick and Rich to look into issues related to this discussion and come back with
a more concrete proposal.

4) VDB Vector Merge

Proposal to rename this SOP to 'VDB Vector from Scalar' to avoid confusion with
the VDB Merge SOP which performs a very different operation. Will change just
the label name and not the operator type name.

Possibility to also rename 'VDB Vector Split' to 'VDB Scalar from Vector', but
this has the added confusion of sounding like it might compute the length of a
vector rather than splitting out each component.

Decision was to go ahead with the 'VDB Vector Merge' -> 'VDB Vector from Scalar'
rename and leave the 'VDB Vector Split'. Jeff has made the change in Houdini. No
change to the core library so not deemed urgent to rush it into the 8.1.0
release.

5) VDB 8.1.0

A few minor fixes to be introduced to the release candidate. Nick to merge
master into this branch. Otherwise, VDB 8.1.0 is ready for release.

6) Feedback from Larry

Which version of VDB was the feature/nanovdb branched from? Decision was to try
and merge master into this feature branch on a more regular basis so that there
are fewer differences between the two branches.

Can OpenVDB be built against OpenEXR 3.0? Has not been tested currently. This
will affect the core library (for Half) and the openvdb_render binary (for
OpenEXR). Decision to test this and to update the embedded version of Half now
that this version has been released.

7) Siggraph Course

JT will have a draft edit ready by Wednesday morning, a few minor changes needed
and the final slide. Submission deadline is Friday 4th June.

Submission deadline for course notes is the following week - Friday 11th June.
Course notes to be discussed in next weeks TSC meeting.

8) Next meeting

Next meeting is June 8th, 2021. 12pm-1pm EST (GMT-5).
