#ifndef ossimBmvUtil_HEADER
#define ossimBmvUtil_HEADER
#include <ossim/base/ossimConstants.h>
#include <ossim/base/ossimGpt.h>
#include <ossim/base/ossimIrect.h>
//#include "ossimArrayHolder.h"

class ossimBmvUtil
{
public:
   ossimBmvUtil(ossim_uint32 tileSize=256,
                ossim_uint32 level0TilesWide=10,
                ossim_uint32 level0TilesHigh=5);
   
   void getNumberOfTilesGivenLevel(ossim_uint32 level,
                                   ossim_uint32& tw,
                                   ossim_uint32& th)const;

   /*!
    * Get the width and height in pixels given a level
    */
   void getWidthHeightGivenLevel(ossim_uint32 level,
                                 ossim_uint32& w,
                                 ossim_uint32 h)const;

   /*!
    * Computes the geographic spacing for a given level
    */
   ossim_float64 getSpacing(ossim_uint32 level)const;

   /*!
    * Turns a gpt into a row col value for the tile
    */
   void getTileRowCol(ossim_uint32 level,
                      const ossimGpt& gpt,
                      ossim_uint32& row,
                      ossim_uint32& col)const;

   /*!
    * Computes the total tiles that exists for all levels up
    * to the maxLevel.  Note it includes the passed in maxLevel
    * in the count.
    */
   ossim_uint64 getTotalNumberOfTiles(ossim_uint32 maxLevel)const;

   ossimIrect getBounds(ossim_uint32 level)const;
   ossimIrect getBounds(ossim_uint32 level,
                        const ossimGpt& ul,
                        const ossimGpt& lr)const;
   
   ossim_uint32 findClosestLevel(ossim_float64 gsd)const;


   ossim_uint32 getLevel0TilesWide()const;
   ossim_uint32 getLevel0TilesHigh()const;
   ossim_uint32 getTileSize()const;

   /*!
    * Will return just the row_col portion of the file name.
    * 
    */
   ossimFilename getFilename(ossim_uint32 level,
                             ossim_uint32 row,
                             ossim_uint32 col)const;


   void readTile(ossim_uint16* destination,
                 const ossimFilename& baseLandDir,
                 ossim_uint32 level,
                 ossim_uint32 row,
                 ossim_uint32 col)const;
 protected:
   ossim_uint32 theTileSize;
   ossim_uint32 theLevel0TilesWide;
   ossim_uint32 theLevel0TilesHigh;
};

#endif
