/** @file cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.23
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt */

#ifndef CMDLINE_H
#define CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE PACKAGE
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#ifdef PACKAGE_NAME
#define CMDLINE_PARSER_PACKAGE_NAME PACKAGE_NAME
#else
#define CMDLINE_PARSER_PACKAGE_NAME PACKAGE
#endif
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  char * origin_arg;	/**< @brief Origin URL to use during registration. Defaults to pam://hostname.  */
  char * origin_orig;	/**< @brief Origin URL to use during registration. Defaults to pam://hostname original value given at command line.  */
  const char *origin_help; /**< @brief Origin URL to use during registration. Defaults to pam://hostname help description.  */
  char * appid_arg;	/**< @brief Application ID to use during registration. Defaults to pam://hostname.  */
  char * appid_orig;	/**< @brief Application ID to use during registration. Defaults to pam://hostname original value given at command line.  */
  const char *appid_help; /**< @brief Application ID to use during registration. Defaults to pam://hostname help description.  */
  char * type_arg;	/**< @brief COSE type to use during registration (ES256 or RS256). Defaults to ES256..  */
  char * type_orig;	/**< @brief COSE type to use during registration (ES256 or RS256). Defaults to ES256. original value given at command line.  */
  const char *type_help; /**< @brief COSE type to use during registration (ES256 or RS256). Defaults to ES256. help description.  */
  int resident_flag;	/**< @brief Generate a resident credential (default=off).  */
  const char *resident_help; /**< @brief Generate a resident credential help description.  */
  int no_user_presence_flag;	/**< @brief Allow the credential to be used without ensuring the user's presence (default=off).  */
  const char *no_user_presence_help; /**< @brief Allow the credential to be used without ensuring the user's presence help description.  */
  int pin_verification_flag;	/**< @brief Require PIN verification during authentication (default=off).  */
  const char *pin_verification_help; /**< @brief Require PIN verification during authentication help description.  */
  int user_verification_flag;	/**< @brief Require user verification during authentication (default=off).  */
  const char *user_verification_help; /**< @brief Require user verification during authentication help description.  */
  int debug_flag;	/**< @brief Print debug information (highly verbose) (default=off).  */
  const char *debug_help; /**< @brief Print debug information (highly verbose) help description.  */
  int verbose_flag;	/**< @brief Print information about chosen origin and appid (default=off).  */
  const char *verbose_help; /**< @brief Print information about chosen origin and appid help description.  */
  char * username_arg;	/**< @brief The name of the user registering the device. Defaults to the current user name.  */
  char * username_orig;	/**< @brief The name of the user registering the device. Defaults to the current user name original value given at command line.  */
  const char *username_help; /**< @brief The name of the user registering the device. Defaults to the current user name help description.  */
  const char *nouser_help; /**< @brief Print only registration information (keyHandle and public key). Useful for appending help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int origin_given ;	/**< @brief Whether origin was given.  */
  unsigned int appid_given ;	/**< @brief Whether appid was given.  */
  unsigned int type_given ;	/**< @brief Whether type was given.  */
  unsigned int resident_given ;	/**< @brief Whether resident was given.  */
  unsigned int no_user_presence_given ;	/**< @brief Whether no-user-presence was given.  */
  unsigned int pin_verification_given ;	/**< @brief Whether pin-verification was given.  */
  unsigned int user_verification_given ;	/**< @brief Whether user-verification was given.  */
  unsigned int debug_given ;	/**< @brief Whether debug was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */
  unsigned int username_given ;	/**< @brief Whether username was given.  */
  unsigned int nouser_given ;	/**< @brief Whether nouser was given.  */

  int user_group_counter; /**< @brief Counter for group user */
} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief the description string of the program */
extern const char *gengetopt_args_info_description;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINE_H */
