/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.impl.core.eventmodel;

import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLNodeType;

final class RouteHolder {
    VRMLNodeType srcNode;
    int srcIndex;
    VRMLNodeType destNode;
    int destIndex;

    RouteHolder() {
    }

    final boolean needsProcessing() {
        return this.srcNode.hasFieldChanged(this.srcIndex);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof RouteHolder) {
            RouteHolder routeHolder = (RouteHolder)object;
            return this.srcNode == routeHolder.srcNode && this.srcIndex == routeHolder.srcIndex && this.destNode == routeHolder.destNode && this.destIndex == routeHolder.destIndex;
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = 0;
        if (this.srcNode != null) {
            n += this.srcNode.hashCode();
        }
        if (this.destNode != null) {
            n += this.destNode.hashCode();
        }
        return n + this.srcIndex + this.destIndex;
    }

    final void sendRoute(double d) {
        this.srcNode.sendRoute(d, this.srcIndex, this.destNode, this.destIndex);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("route   from: ");
        stringBuffer.append(this.srcNode.getVRMLNodeName());
        stringBuffer.append(" field: ");
        VRMLFieldDeclaration vRMLFieldDeclaration = this.srcNode.getFieldDeclaration(this.srcIndex);
        stringBuffer.append(vRMLFieldDeclaration.getName());
        stringBuffer.append(" to: ");
        stringBuffer.append(this.destNode.getVRMLNodeName());
        stringBuffer.append(" field: ");
        vRMLFieldDeclaration = this.destNode.getFieldDeclaration(this.destIndex);
        stringBuffer.append(vRMLFieldDeclaration.getName());
        return stringBuffer.toString();
    }
}

