% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiSample.R
\name{mergeSequenceTables}
\alias{mergeSequenceTables}
\title{Merge two or more sample-by-sequence observation matrices.}
\usage{
mergeSequenceTables(
  table1 = NULL,
  table2 = NULL,
  ...,
  tables = NULL,
  repeats = "error",
  orderBy = "abundance",
  tryRC = FALSE
)
}
\arguments{
\item{table1}{(Optional, default=NULL). Named integer matrix. Rownames correspond to samples
and column names correspond to sequences. The output of \code{\link{makeSequenceTable}}.}

\item{table2}{(Optional, default=NULL). Named integer matrix. Rownames correspond to samples
and column names correspond to sequences. The output of \code{\link{makeSequenceTable}}.}

\item{...}{(Optional). Additional sequence tables.}

\item{tables}{(Optional, default=NULL). Either a list of sequence tables, or a list/vector of RDS filenames
corresponding to sequence tables. If provided, \code{table1}, \code{table2}, and any
additional arguments will be ignored.}

\item{repeats}{(Optional). Default "error".
Specifies how merging should proceed in the presence of repeated sample names.
Valid values: "error", "sum".
If "sum", then samples with the same name are summed together in the merged table.}

\item{orderBy}{(Optional). \code{character(1)}. Default "abundance".
Specifies how the sequences (columns) of the returned table should be ordered (decreasing).
Valid values: "abundance", "nsamples", NULL.}

\item{tryRC}{(Optional). \code{logical(1)}. Default FALSE.
If tryRC=TRUE, sequences whose reverse complement matches an earlier sequence will be reverse-
complemented and merged together with that earlier sequence. This is most useful when different
runs sequenced the same gene region in different or mixed orientations. Note, this does not
guarantee consistent orientatation from e.g. 5' to 3' on the gene, it just ensures that identical
sequences in different orientations are merged.}
}
\value{
Named integer matrix.
A row for each sample, and a column for each unique sequence across all the samples.
Note that the columns are named by the sequence which can make display unwieldy.
}
\description{
This function combines sequence tables together into one merged sequences table.
}
\examples{

\dontrun{
  mergetab <- mergeSequenceTables(seqtab1, seqtab2, seqtab3) # unnamed arguments assumed to be sequence tables
  input_tables <- list(seqtab1, seqtab2, seqtab3)
  mergetab <- mergeSequenceTables(tables=input_tables) # list of sequence tables
  files <- c(file1, file2, file3)
  mergetab <- mergeSequenceTables(tables=files) # vector of filenames
}

}
\seealso{
\code{\link{makeSequenceTable}}
}
