% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bench_time.R
\name{bench_time}
\alias{bench_time}
\alias{system_time}
\title{Measure Process CPU and real time that an expression used.}
\usage{
bench_time(expr)
}
\arguments{
\item{expr}{A expression to be timed.}
}
\value{
A \code{bench_time} object with two values.
\itemize{
\item \code{process} - The process CPU usage of the expression evaluation.
\item \code{real} - The wallclock time of the expression evaluation.
}
}
\description{
Measure Process CPU and real time that an expression used.
}
\details{
On some systems (such as macOS) the process clock has lower
precision than the realtime clock, as a result there may be cases where the
process time is larger than the real time for fast expressions.
}
\examples{
# This will use ~.5 seconds of real time, but very little process time.
bench_time(Sys.sleep(.5))
}
\seealso{
\code{\link[=bench_memory]{bench_memory()}} To measure memory allocations for a given expression.
}
