% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbs.R
\name{verb-GET}
\alias{verb-GET}
\title{HTTP verb info: GET}
\description{
The GET method requests a representation of the specified resource.
Requests using GET should only retrieve data.
}
\section{The GET method}{

The GET method requests transfer of a current selected
representation for the target resource.  GET is the primary
mechanism of information retrieval and the focus of almost all
performance optimizations. Hence, when people speak of retrieving
some identifiable information via HTTP, they are generally referring
to making a GET request.

It is tempting to think of resource identifiers as remote file system
pathnames and of representations as being a copy of the contents of
such files.  In fact, that is how many resources are implemented (see
Section 9.1 (\url{https://tools.ietf.org/html/rfc7231#section-9.1})
for related security considerations).  However, there are
no such limitations in practice.  The HTTP interface for a resource
is just as likely to be implemented as a tree of content objects, a
programmatic view on various database records, or a gateway to other
information systems.  Even when the URI mapping mechanism is tied to
a file system, an origin server might be configured to execute the
files with the request as input and send the output as the
representation rather than transfer the files directly.  Regardless,
only the origin server needs to know how each of its resource identifiers
corresponds to an implementation and how each implementation manages
to select and send a current representation of the target resource
in a response to GET.

A client can alter the semantics of GET to be a "range request",
requesting transfer of only some part(s) of the selected
representation, by sending a Range header field in the request
(RFC7233: \url{https://tools.ietf.org/html/rfc7233}).

A payload within a GET request message has no defined semantics;
sending a payload body on a GET request might cause some existing
implementations to reject the request.

The response to a GET request is cacheable; a cache MAY use it to
satisfy subsequent GET and HEAD requests unless otherwise indicated
by the Cache-Control header field (Section 5.2 of RFC7234:
\url{https://tools.ietf.org/html/rfc7234#section-5.2}).
}

\examples{
\dontrun{
x <- HttpClient$new(url = "https://httpbin.org")
x$get(path = 'get')
}

}
\references{
\url{https://tools.ietf.org/html/rfc7231#section-4.3.1}
}
\seealso{
\link{crul-package}

Other verbs: 
\code{\link{verb-DELETE}},
\code{\link{verb-HEAD}},
\code{\link{verb-PATCH}},
\code{\link{verb-POST}},
\code{\link{verb-PUT}}
}
\concept{verbs}
