% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_metrics.R
\name{ens}
\alias{ens}
\title{Burt's Effective Network Size and Constraint index.
The next two functions below provide ways to measure the actors' access to structural holes in a network. Structural holes 
"provide opportunities to broker connections between people" (Burt 2008).}
\usage{
ens(g)
}
\arguments{
\item{g}{The igraph object to analyze.}
}
\value{
A numeric vector with the effective network size for each vertex
}
\description{
Burt's Effective Network Size and Constraint index.
The next two functions below provide ways to measure the actors' access to structural holes in a network. Structural holes 
"provide opportunities to broker connections between people" (Burt 2008).
}
\examples{
ig.ex <- igraph::erdos.renyi.game(100, p.or.m=0.3) # generate an undirected 'igraph' object
ens(ig.ex) # Effective Network Size scores for each node in the graph

}
\references{
\url{https://www.sciencedirect.com/science/article/abs/pii/S0378873397000038}
}
