% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_history.R
\name{rl_history}
\alias{rl_history}
\title{Get historical assessments by taxon name, IUCN id, and region}
\usage{
rl_history(
  name = NULL,
  id = NULL,
  region = NULL,
  key = NULL,
  parse = TRUE,
  ...
)
}
\arguments{
\item{name}{(character) A taxonomic name}

\item{id}{(character) An IUCN identifier}

\item{region}{(character) A region name, see \code{\link{rl_regions}} for
acceptable region identifiers (use the entries in the \code{identifier}
column)}

\item{key}{A IUCN API token. See \code{\link{rl_use_iucn}}.}

\item{parse}{(logical) Whether to parse to list (\code{FALSE}) or
data.frame (\code{TRUE}). Default: \code{TRUE}}

\item{...}{Curl options passed to \code{\link[crul]{HttpClient}}}
}
\value{
A list, with the data in the \code{result} slot, unless using
a function with a trailing underscore, in which case json as character
string is returned.
}
\description{
Get historical assessments by taxon name, IUCN id, and region
}
\examples{
\dontrun{
rl_history('Loxodonta africana')
rl_history('Ursus maritimus', region = 'europe')
rl_history(id = 12392)
rl_history(id = 22823, region = 'europe')

rl_history_('Loxodonta africana')
rl_history_(id = 12392)
}
}
\references{
API docs at https://apiv3.iucnredlist.org/api/v3/docs
}
