% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl-df.r, R/utils-format.r
\name{format.tbl}
\alias{format.tbl}
\alias{format.tbl_df}
\alias{print.tbl}
\alias{print.tbl_df}
\alias{formatting}
\alias{trunc_mat}
\title{Tools for describing matrices}
\usage{
\method{format}{tbl}(x, ..., n = NULL, width = NULL, n_extra = NULL)

\method{format}{tbl_df}(x, ..., n = NULL, width = NULL, n_extra = NULL)

\method{print}{tbl}(x, ..., n = NULL, width = NULL, n_extra = NULL)

\method{print}{tbl_df}(x, ..., n = NULL, width = NULL, n_extra = NULL)

trunc_mat(x, n = NULL, width = NULL, n_extra = NULL)
}
\arguments{
\item{x}{Object to show.}

\item{n}{Number of rows to show. If \code{NULL}, the default, will print
all rows if less than option \code{tibble.print_max}. Otherwise, will
print \code{tibble.print_min} rows.}

\item{width}{Width of text output to generate. This defaults to NULL, which
means use \code{getOption("tibble.width")} or (if also NULL)
\code{getOption("width")}; the latter displays only the columns that
fit on one screen. You can also set \code{options(tibble.width = Inf)} to
override this default and always print all columns.}

\item{n_extra}{Number of extra columns to print abbreviated information for,
if the width is too small for the entire tibble. If \code{NULL}, the
default, will print information about at most \code{tibble.max_extra_cols}
extra columns.}
}
\description{
Tools for describing matrices
}
\examples{
trunc_mat(mtcars)

print(as_tibble(mtcars))
print(as_tibble(mtcars), n = 1)
print(as_tibble(mtcars), n = 3)
print(as_tibble(mtcars), n = 100)

if (!requireNamespace("nycflights13", quietly = TRUE))
  stop("Please install the nycflights13 package to run the rest of this example")

print(nycflights13::flights, n_extra = 2)
print(nycflights13::flights, width = Inf)
}
\seealso{
\link{tibble-package}
}
\keyword{internal}
